/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.saves;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.saves.SavedGameData;

public class Data
implements RMSHandler {
    private Vector data = new Vector();

    public SavedGameData getSavedGameData() {
        System.out.println("data size : " + this.data.size());
        if (this.data.size() > 0) {
            return (SavedGameData)this.data.firstElement();
        }
        return null;
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
        SavedGameData gameData = (SavedGameData)this.data.firstElement();
        dos.writeInt(1);
        dos.writeInt(gameData.totalGames);
        dos.writeInt(gameData.totalBaskets);
        dos.writeInt(gameData.cleanShots);
        dos.writeInt(gameData.offBoard);
        dos.writeInt(gameData.highShots);
        dos.writeInt(gameData.buzzerBeaters);
        dos.writeInt(gameData.bestCombo);
        dos.writeInt(gameData.bestScoreTime);
        dos.writeInt(gameData.bestScoreArcade);
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
        this.data.removeAllElements();
        if (dis.readInt() != 0) {
            SavedGameData gameData = new SavedGameData();
            gameData.totalGames = dis.readInt();
            gameData.totalBaskets = dis.readInt();
            gameData.cleanShots = dis.readInt();
            gameData.offBoard = dis.readInt();
            gameData.highShots = dis.readInt();
            gameData.buzzerBeaters = dis.readInt();
            gameData.bestCombo = dis.readInt();
            gameData.bestScoreTime = dis.readInt();
            gameData.bestScoreArcade = dis.readInt();
            this.data.addElement(gameData);
        }
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(0);
    }

    public void saveGame(SavedGameData savIt) {
        if (this.data.size() > 0) {
            this.data.setElementAt(savIt, 0);
        } else {
            this.data.addElement(savIt);
        }
    }
}

