/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Shape;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class MultiShape
extends Shape {
    protected Shape[] mShapes;
    protected int[] mVertexStartIndices;
    protected int[] mAxesStartIndices;

    public MultiShape(Vector vector) {
        this.initShapeMembers(vector);
    }

    protected void initShapeMembers(Vector vector) {
        int n;
        this.mShapes = new Shape[vector.size()];
        this.mVertexStartIndices = new int[vector.size() + 1];
        this.mAxesStartIndices = new int[vector.size() + 1];
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < vector.size(); ++n) {
            this.mShapes[n] = (Shape)vector.elementAt(n);
            this.mVertexStartIndices[n] = n2;
            n2 += this.mShapes[n].mVertices.length;
            n3 += this.mShapes[n].f;
        }
        this.mVertexStartIndices[vector.size()] = n2;
        this.mVertices = new FXVector[n2];
        n = 0;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            for (int i = 0; i < this.mShapes[n2].mVertices.length; ++i) {
                this.mVertices[n++] = this.mShapes[n2].mVertices[i];
            }
        }
        this.updateInternals();
        this.setMassFX(n3);
    }

    public MultiShape(MultiShape multiShape) {
        this.mVertices = new FXVector[multiShape.mVertices.length];
        System.arraycopy(multiShape.mVertices, 0, this.mVertices, 0, this.mVertices.length);
        this.mShapes = new Shape[multiShape.mShapes.length];
        System.arraycopy(multiShape.mShapes, 0, this.mShapes, 0, this.mShapes.length);
        this.mVertexStartIndices = new int[multiShape.mVertexStartIndices.length];
        System.arraycopy(multiShape.mVertexStartIndices, 0, this.mVertexStartIndices, 0, this.mVertexStartIndices.length);
        this.mAxesStartIndices = new int[multiShape.mAxesStartIndices.length];
        System.arraycopy(multiShape.mAxesStartIndices, 0, this.mAxesStartIndices, 0, this.mAxesStartIndices.length);
        this.setElasticityFX(multiShape.mElasticityFX);
        this.setFrictionFX(multiShape.mFrictionFX);
        this.updateInternals();
        this.setMassFX(multiShape.f);
        if (multiShape.mUserData != null) {
            this.mUserData = multiShape.mUserData.copy();
        }
    }

    public Shape getShape(int n) {
        return this.mShapes[n];
    }

    public int getShapeCount() {
        return this.mShapes.length;
    }

    final void a() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.mShapes.length; ++n) {
            n2 += this.mShapes[n].b;
        }
        this.b = n2;
        this.a = new int[n2];
        n = 0;
        for (n2 = 0; n2 < this.mShapes.length; ++n2) {
            this.mAxesStartIndices[n2] = n / 2;
            for (int i = 0; i < this.mShapes[n2].b; ++i) {
                this.a[n++] = this.mVertexStartIndices[n2] + this.mShapes[n2].a[i];
            }
        }
        this.mAxesStartIndices[this.mShapes.length] = n / 2;
    }

    final void b() {
        this.e = 0L;
        this.h = 0L;
        for (int i = 0; i < this.mShapes.length; ++i) {
            this.e += this.mShapes[i].e;
            this.h += this.mShapes[i].h;
        }
        if (this.h == 0L) {
            this.i = Integer.MAX_VALUE;
            return;
        }
        this.i = 0x1000000000L / this.h;
    }

    public static MultiShape loadShape(PhysicsFileReader object, UserData userData, Vector vector) {
        ((PhysicsFileReader)object).getVersion();
        int n = ((PhysicsFileReader)object).next();
        Vector vector2 = new Vector();
        for (int i = 0; i < n; ++i) {
            vector2.addElement(vector.elementAt(((PhysicsFileReader)object).next()));
        }
        MultiShape multiShape = new MultiShape(vector2);
        object = ((PhysicsFileReader)object).nextString();
        if (userData != null) {
            multiShape.mUserData = userData.createNewUserData((String)object, 2);
        }
        return multiShape;
    }
}

