/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Shape;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXVector;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.GameData;
import sk.inlogic.GraphicsMem;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.Variables;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.saves.Data;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.text.ResourceBundle;
import sk.inlogic.util.Particles;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private final int TOUCH_BALL;
    private final int HOME;
    private final int SOUND;
    private final int AGAIN;
    private final byte ID_ARCADE_MODE;
    private final byte ID_TIME_MODE;
    private MainCanvas mainCanvas;
    private PreparedText prepareTextInstructions;
    private GFont fontMain;
    private Image imgPause;
    private Image imgBG;
    private Image imgClockBG;
    private Image imgTimeBar;
    private Image imgClock;
    private Image imgHome;
    private Image imgBack;
    private Image imgSounds;
    private Image imgSoundOff;
    private Image imgInstructions;
    private Image imgSpot;
    private Image imgWindowInstr;
    private Image imgAgain;
    private Image imgCursor;
    private Image imgLogo;
    private Sprite sprBall;
    private Sprite sprBall2;
    private Sprite ball;
    private Sprite sprCoin;
    private Sprite sprShadowBall;
    private Sprite sprBoard;
    private Sprite sprBoardShadow;
    private Sprite sprParticleTest;
    private Sprite sprArrow;
    private Sprite sprArrowInactive;
    private Sprite sprUpHoop;
    private Sprite sprDownHoop;
    private Sprite sprBigNumber;
    private Rectangle rectScreen;
    private Rectangle rectBall;
    private Rectangle rectTimebar;
    private Rectangle rectPause;
    private Rectangle rectBoard;
    private Rectangle rectHome;
    private Rectangle rectStartAgain;
    private Rectangle rectScore;
    private Rectangle rectCombo;
    private Rectangle rectBallScore;
    private Rectangle rectCoins;
    private Rectangle rectShadowBall;
    private Rectangle rectHoop;
    private Rectangle rectInstructionsBtn;
    private Rectangle rectSounds;
    private Rectangle rectBack;
    private Rectangle rectHomePause;
    private Rectangle rectInstructions;
    private Rectangle rectTextInstr;
    private Rectangle rectInstrPlane;
    private Rectangle rectDownArrow;
    private Rectangle rectUpArrow;
    private Rectangle rectCursor;
    private Rectangle[] rectSettBtns;
    private int radius;
    private int score = 0;
    private int combo = 1;
    private int countDownToCoin;
    private int moveBoard;
    private int modeGame;
    private int scoreLine;
    private int maxHight;
    private int heightBoard;
    private int timePosBar;
    private int rotateBall = 0;
    private int previousBallX;
    private int onePiece;
    private int collisionObjectIndex = -1;
    private int frameCoin;
    private int frameShadowBall;
    private int screenShakeSteps;
    private int comboRight;
    private int comboLeft;
    private int xComboRight;
    private int yComboRight;
    private int xComboLeft;
    private int yComboLeft;
    private int comboLeftTimer;
    private int comboRightTimer;
    private int KEYBOARD_VALUE;
    private int yFirstPressedInstr;
    private int action;
    private int selectedPause;
    private int animScoreXPos;
    private int timeAnimScore;
    private int offset;
    private int ballBodyVelocity;
    private Data modeData;
    private final int MAX_TIMER_7_SEC;
    private final int MAX_STEPS_SHAKE;
    private final int ONE_MINUTE;
    private final int COMBO_SCORE_TIME;
    private long gameTimer;
    private long timer;
    private int resultStep;
    private boolean leftScore;
    private boolean rightScore;
    private boolean downPressedInstr;
    private boolean upPressedInstr;
    private boolean[] scoreAdded = new boolean[2];
    private boolean isRightBoard;
    private boolean isRightBall;
    private boolean isClearShot = true;
    private boolean highShot;
    private boolean buzzerBeater;
    private boolean createCoin;
    private boolean boardLeave;
    private boolean gameOver;
    private boolean lastChance;
    private boolean shotWithBoard;
    private boolean firstSpriteBall;
    private boolean screenShakeActivated;
    private boolean isParticleActiveGenerate;
    private boolean isMusicOn;
    private boolean isPause;
    private boolean isInstructionPressed;
    private boolean instrPressed;
    private boolean keyReleased;
    private boolean isBoardCreated;
    private World world;
    private Body ballBody;
    private Body earthBody;
    private Body scoreBodyUp;
    private Body scoreBodyDown;
    private Body coinBody;
    private Body leftWallScoreBody;
    private Body rightWallScoreBody;
    private Body[] board;
    private Particles particles = new Particles();
    static final Random randGenerator = new Random();
    private String textShot;
    public static String[] str = new String[33];
    private int screenShakeX;
    private int screenShakeY;

    public ScreenGame(MainCanvas mainCanvas, int modeGame, Data modeData) {
        this.TOUCH_BALL = 0;
        this.HOME = 1;
        this.SOUND = 2;
        this.AGAIN = 3;
        this.ID_ARCADE_MODE = 0;
        this.ID_TIME_MODE = 1;
        this.MAX_TIMER_7_SEC = 7000;
        this.MAX_STEPS_SHAKE = 10;
        this.ONE_MINUTE = 60000;
        this.COMBO_SCORE_TIME = 1000;
        this.mainCanvas = mainCanvas;
        this.modeGame = modeGame;
        this.modeData = modeData;
        this.newCountDownToCoin();
        if (modeGame == 1) {
            this.gameTimer = 60000L;
        }
        this.combo = 1;
    }

    static final int getRandomInt(int max) {
        return randGenerator.nextInt() % max;
    }

    static final int getRandomUInt(int max) {
        return Math.abs(randGenerator.nextInt() % max);
    }

    private void createWorld() {
        this.world = new World();
        this.world.setDampingLateralFX(4);
        this.world.setTimestepFX(500);
        if (MainCanvas.HEIGHT <= 480) {
            this.world.setGravity(80);
        } else {
            this.world.setGravity(100);
        }
        this.radius = this.sprBall.getWidth() >> 1;
        this.initBall();
        this.initEarthBox();
        this.initHoop();
        this.world.addBody(this.ballBody);
        this.world.addBody(this.earthBody);
    }

    public void paintWorld(Graphics g) {
        int bodyCount = this.world.getBodyCount();
        Body[] bodies = this.world.getBodies();
        g.setColor(255, 0, 0);
        for (int i = 0; i < bodyCount; ++i) {
            this.paintBody(g, bodies[i]);
        }
    }

    public void paintBody(Graphics g, Body b) {
        g.setColor(65280);
        FXVector[] positions = b.getVertices();
        if (positions.length == 1) {
            int radius = (int)ScreenGame.findSquareRoot(b.shape().getBoundingRadiusSquare());
            g.drawArc(b.positionFX().xAsInt() - radius, b.positionFX().yAsInt() - radius, radius * 2, radius * 2, 0, 360);
        } else {
            for (int i = 0; i < positions.length - 1; ++i) {
                g.drawLine(positions[i].xAsInt(), positions[i].yAsInt(), positions[i + 1].xAsInt(), positions[i + 1].yAsInt());
            }
            g.drawLine(positions[positions.length - 1].xAsInt(), positions[positions.length - 1].yAsInt(), positions[0].xAsInt(), positions[0].yAsInt());
        }
    }

    public static double findSquareRoot(double number) {
        double g1;
        if (number <= 0.0) {
            return 0.0;
        }
        double squareRoot = number / 2.0;
        while ((g1 = squareRoot) - (squareRoot = (g1 + number / g1) / 2.0) != 0.0) {
        }
        return squareRoot;
    }

    public void update(long lastRunLenght) {
        if (this.isPause) {
            if (this.isInstructionPressed && (this.downPressedInstr || this.upPressedInstr)) {
                this.updateInstructions(this.KEYBOARD_VALUE);
            }
            this.mainCanvas.repaint();
            return;
        }
        this.world.tick();
        this.updateBallBody();
        this.updateShadowBall();
        this.timer += lastRunLenght;
        if (!this.gameOver) {
            if (this.animScoreXPos == MainCanvas.getCenterX()) {
                this.timeAnimScore = (int)((long)this.timeAnimScore + lastRunLenght);
                if (this.timeAnimScore >= 1000) {
                    this.animScoreXPos = 0 - (this.rectScreen.width >> 1);
                }
            }
            if (this.animScoreXPos < MainCanvas.getCenterX() && this.timeAnimScore < 1000) {
                this.updateAnimCombo();
            }
            if (this.score > 0 && !this.lastChance) {
                if (this.gameTimer <= 0L) {
                    this.lastChance = true;
                }
                this.gameTimer -= lastRunLenght;
            } else if (this.lastChance && this.ballBodyVelocity > 0 && this.ballBody.positionFX().yAsInt() > this.scoreLine) {
                if (this.scoreAdded[0] && this.scoreAdded[1]) {
                    this.updateScore();
                }
                if (this.maxHight > this.scoreLine) {
                    this.gameOver = true;
                }
            }
            if (this.leftScore) {
                --this.comboLeftTimer;
                this.yComboLeft -= this.fontMain.getHeight() >> 1;
                if (this.comboLeftTimer < 0) {
                    this.comboLeftTimer = 0;
                    this.leftScore = false;
                }
            } else if (this.rightScore) {
                --this.comboRightTimer;
                this.yComboRight -= this.fontMain.getHeight() >> 1;
                if (this.comboRightTimer < 0) {
                    this.comboRightTimer = 0;
                    this.rightScore = false;
                }
            }
            if (this.isParticleActiveGenerate) {
                int x = this.rectBall.x + ScreenGame.getRandomUInt(this.sprBall.getWidth());
                int y = this.rectBall.getBottom();
                int xSpeed = ScreenGame.getRandomInt(this.sprBall.getWidth() >> 1);
                int ySpeed = ScreenGame.getRandomUInt(this.sprBall.getHeight());
                int xAcceleration = 1;
                int yAcceleration = 1;
                int frame = 0;
                int countOfFrames = ScreenGame.getRandomUInt(10) + 5;
                int maxFrames = 0;
                this.createParticles(x, y, xSpeed, ySpeed, xAcceleration, yAcceleration, this.sprParticleTest, frame, countOfFrames, maxFrames);
            }
        } else {
            this.resultStep = (int)((long)this.resultStep + lastRunLenght);
        }
        if (this.moveBoard > 0) {
            if (this.boardLeave) {
                this.updatingBoard();
                if (!this.boardLeave) {
                    this.otherSiteBoard();
                }
            } else {
                this.updatingBoard();
            }
        } else if (!this.isBoardCreated) {
            this.setBoard();
        }
        if (this.particles.activeParticles() > 0) {
            this.particles.update();
        }
        if (this.gameOver) {
            this.mainCanvas.repaint();
            return;
        }
        if (this.score > 0) {
            this.timePosBar = this.modeGame == 0 ? (int)((7000L - this.gameTimer) / (long)this.onePiece) : (int)((60000L - this.gameTimer) / (long)this.onePiece);
        }
        this.takeCoin();
        if (this.isBoardCreated) {
            this.checkClearShot();
            this.shotWithBoard = this.checkCollisionWithBoard();
            this.updateScore();
        }
        if (this.timer % 100L < 41L && this.coinBody != null) {
            this.updateAnimCoin();
        }
        this.mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        this.paintBG(g);
        if (this.isPause) {
            if (this.isInstructionPressed) {
                this.paintInstructions(g);
            } else {
                this.paintPausePressed(g);
            }
            g.drawImage(this.imgBack, this.rectBack.getCenterX(), this.rectBack.getCenterY(), 3);
            return;
        }
        if (this.screenShakeActivated && this.screenShakeSteps > 0) {
            --this.screenShakeSteps;
            this.screenShakeX = ScreenGame.getRandomInt(this.sprBall.getWidth() >> 2);
            this.screenShakeY = ScreenGame.getRandomInt(this.sprBall.getWidth() >> 2);
        } else {
            this.screenShakeX = 0;
            this.screenShakeY = 0;
        }
        if (!this.gameOver) {
            if (this.timeAnimScore < 1000) {
                this.paintScore(g);
            }
            this.paintNumbers(g, this.score, this.rectScore.getCenterY());
            this.paintTimeBar(g);
            this.paintPause(g);
            this.paintComboNumber(g);
        }
        if (this.particles.activeParticles() > 0) {
            this.particles.paint(g);
        }
        this.paintCoins(g);
        this.paintBoard(g);
        this.paintCoinBody(g);
        if (this.gameOver) {
            this.paintResult(g);
            this.paintCoins(g);
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
        if (!this.lastChance && !this.gameOver) {
            if (this.rectPause.contains(x, y) && !this.isPause) {
                this.isPause = true;
                this.initInstructions();
            } else if (this.isInstructionPressed) {
                if (this.rectInstrPlane.contains(x, y)) {
                    this.instrPressed = true;
                    this.yFirstPressedInstr = y;
                }
            } else if (this.isPause) {
                if (this.rectHomePause.contains(x, y)) {
                    this.action = 1;
                    this.confirmAction();
                } else if (this.rectSounds.contains(x, y)) {
                    this.action = 2;
                    this.confirmAction();
                } else if (this.rectInstructionsBtn.contains(x, y)) {
                    this.isInstructionPressed = true;
                } else if (this.rectBack.contains(x, y)) {
                    this.isPause = false;
                }
            } else if (this.rectScreen.contains(x, y)) {
                this.action = 0;
                this.confirmAction();
            }
        }
        if (this.gameOver) {
            switch (this.resultStep / 1000) {
                case 0: {
                    this.resultStep = 1000;
                    break;
                }
                case 1: {
                    this.resultStep = 2000;
                    break;
                }
                case 2: {
                    this.resultStep = 3000;
                    break;
                }
                case 3: {
                    this.resultStep = 4000;
                }
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.isInstructionPressed && this.rectInstrPlane.contains(x, y) && this.instrPressed) {
            int yDiff = this.yFirstPressedInstr - y;
            this.updateInstructions(yDiff);
            this.yFirstPressedInstr = y;
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.isInstructionPressed) {
            this.instrPressed = false;
            if (this.rectBack.contains(x, y)) {
                this.isInstructionPressed = false;
            }
        }
        if (this.gameOver) {
            if (this.rectHome.contains(x, y)) {
                this.action = 1;
                this.confirmAction();
            } else if (this.rectStartAgain.contains(x, y)) {
                this.action = 3;
                this.confirmAction();
            }
        }
    }

    public void afterHide() {
        System.out.println("AFTER HIDE");
        Resources.freeAllResources();
        MainCanvas.soundManager.Stop();
        this.saveGame();
    }

    public void beforeShow() {
        System.out.println("beforeShow()");
        this.fontMain = GraphicsMem.fontMain;
        this.imgPause = GraphicsMem.imgPause;
        this.imgBG = GraphicsMem.imgBg;
        this.imgClockBG = GraphicsMem.imgClockBG;
        this.imgTimeBar = GraphicsMem.imgTimeBar;
        this.imgClock = GraphicsMem.imgClock;
        this.imgBack = GraphicsMem.imgBack;
        this.imgSoundOff = GraphicsMem.imgSoundOff;
        this.imgSounds = GraphicsMem.imgSounds;
        this.imgInstructions = GraphicsMem.imgInstructions;
        this.imgHome = GraphicsMem.imgHome;
        this.imgSpot = GraphicsMem.imgSpot;
        this.imgWindowInstr = GraphicsMem.imgWindowInstr;
        this.imgAgain = GraphicsMem.imgAgain;
        this.imgCursor = GraphicsMem.imgCursor;
        this.imgLogo = GraphicsMem.imgLogo;
        this.sprBall = GraphicsMem.sprBall;
        this.sprBall2 = GraphicsMem.sprBall2;
        this.sprCoin = GraphicsMem.sprCoin;
        this.sprShadowBall = GraphicsMem.sprShadowBall;
        this.sprBoard = GraphicsMem.sprBoard;
        this.sprBoardShadow = GraphicsMem.sprBoardShadow;
        this.sprParticleTest = GraphicsMem.sprParticleTest;
        this.sprArrow = GraphicsMem.sprArrow;
        this.sprArrowInactive = GraphicsMem.sprArrowInactive;
        this.sprUpHoop = GraphicsMem.sprUpHoop;
        this.sprDownHoop = GraphicsMem.sprDownHoop;
        this.sprBigNumber = GraphicsMem.sprBigNumber;
        if (!this.mainCanvas.isInterrupted()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        }
        MainCanvas.soundManager.Stop();
        this.initParameters();
        this.createWorld();
        GameData.load();
        this.isMusicOn = GameData.isMusicOn;
        if (this.isMusicOn) {
            this.changeSound();
        }
    }

    public void beforeInteruption() {
        System.out.println("BEFORE INTERUPTION");
        MainCanvas.soundManager.Stop();
        this.saveGame();
        this.isPause = true;
        this.initInstructions();
    }

    public void afterInteruption() {
        System.out.println("AFTER INTERUPTION");
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        }
        this.saveGame();
        this.isPause = true;
        this.initInstructions();
    }

    private void paintBG(Graphics g) {
        if (this.imgBG == null) {
            return;
        }
        if (this.isPause || this.isInstructionPressed) {
            g.setColor(88, 86, 201);
            g.fillRect(this.rectScreen.x, this.rectScreen.y, this.rectScreen.width, this.rectScreen.height);
        } else {
            g.drawImage(this.imgBG, this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
        }
    }

    private void initParameters() {
        this.rectScreen = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.offset = this.imgAgain.getWidth() >> 3;
        this.initTexts();
        this.isRightBall = this.isRightBoard = ScreenGame.getRandomInt(500) > 0;
        if (!this.isRightBoard) {
            this.rotateBall = 2;
            this.sprBoard.setTransform(2);
            this.sprBoardShadow.setTransform(2);
            this.sprUpHoop.setTransform(2);
            this.sprDownHoop.setTransform(2);
        } else {
            this.rotateBall = 0;
            this.sprBoard.setTransform(0);
            this.sprBoardShadow.setTransform(0);
            this.sprUpHoop.setTransform(0);
            this.sprDownHoop.setTransform(0);
        }
        this.initCoinPos();
        this.initPause();
        this.initTimeBar();
        this.initResultBtns();
        this.initGameText();
        this.initSettButtons();
        int x = this.rectScreen.getCenterX() - (this.imgBack.getWidth() >> 1);
        int y = this.rectScreen.height - (this.imgBack.getHeight() + (this.imgBack.getHeight() >> 2));
        this.rectBack = new Rectangle(x, y, this.imgBack.getWidth(), this.imgBack.getHeight());
        this.rectSettBtns = new Rectangle[3];
        this.rectSettBtns[0] = this.rectHomePause = this.rectSounds;
        this.rectSettBtns[1] = this.rectInstructionsBtn;
        this.rectSettBtns[2] = this.rectBack;
        this.initCursor();
        this.animScoreXPos = 0 - (this.rectScreen.width >> 1);
    }

    private void initSettButtons() {
        int x = this.rectScreen.getCenterX() - (this.imgSounds.getWidth() >> 1);
        int y = this.rectScreen.getCenterY();
        this.rectHomePause = new Rectangle(x, y - (this.imgSounds.getHeight() << 1) - (this.imgSounds.getHeight() >> 1), this.imgSounds.getWidth(), this.imgSounds.getHeight());
        this.rectSounds = new Rectangle(x, y - this.imgSounds.getHeight(), this.imgSounds.getWidth(), this.imgSounds.getHeight());
        this.rectInstructionsBtn = new Rectangle(x, y + (this.imgSounds.getHeight() >> 1), this.imgInstructions.getWidth(), this.imgInstructions.getHeight());
    }

    private void paintScore(Graphics g) {
        if (this.textShot != null) {
            this.fontMain.drawString(g, this.textShot.toCharArray(), this.animScoreXPos, this.rectBallScore.getCenterY(), 3);
        }
        if (this.combo > 2) {
            this.fontMain.drawString(g, (str[12] + " " + (this.combo - 1)).toCharArray(), this.animScoreXPos, this.rectCombo.getCenterY(), 3);
        }
    }

    private void paintBall(Graphics g) {
        this.ball = this.firstSpriteBall ? this.sprBall : this.sprBall2;
        this.ball.setTransform(this.rotateBall);
        this.paintSprite(this.rectShadowBall.x, this.rectShadowBall.y, this.sprShadowBall, g, this.frameShadowBall);
        this.paintSprite(this.rectBall.getCenterX() - (this.ball.getWidth() >> 1), this.rectBall.getCenterY() - (this.ball.getHeight() >> 1), this.ball, g, GameData.selectedBall);
    }

    private void initBall() {
        Shape ball = Shape.createCircle(this.radius);
        ball.setElasticity(60);
        ball.setMass(1);
        this.ballBody = new Body(MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, ball, true);
        this.rectBall = new Rectangle(this.ballBody.positionFX().xAsInt() - this.radius, this.ballBody.positionFX().yAsInt() - this.radius, this.radius << 1, this.radius << 1);
        this.previousBallX = this.ballBody.positionFX().xAsInt();
    }

    private void initEarthBox() {
        int width = MainCanvas.WIDTH << 1;
        int height = (MainCanvas.HEIGHT >> 3) + 2;
        Shape earthBox = Shape.createRectangle(width, height);
        earthBox.setElasticity(100);
        this.earthBody = new Body(MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT - (height >> 2), earthBox, false);
    }

    private void paintTimeBar(Graphics g) {
        g.drawImage(this.imgClockBG, this.rectScreen.getCenterX(), this.rectTimebar.getCenterY(), 3);
        g.setClip(this.rectTimebar.x, this.rectTimebar.y, this.rectTimebar.width, this.rectTimebar.height);
        g.drawImage(this.imgTimeBar, this.rectTimebar.getRight() - this.timePosBar, this.rectTimebar.getCenterY(), 10);
        g.setClip(0, 0, this.rectScreen.width, this.rectScreen.height);
        g.drawImage(this.imgClock, this.rectScreen.getCenterX() - (this.imgClockBG.getWidth() >> 1), this.rectTimebar.getCenterY(), 6);
    }

    private void initTimeBar() {
        int width = this.imgClockBG.getWidth();
        int height = this.imgClockBG.getHeight();
        int x = this.rectScreen.getCenterX() - (this.imgClockBG.getWidth() >> 1);
        int y = this.rectPause.getCenterY() - (height >> 1);
        this.rectTimebar = new Rectangle(x, y, width, height);
        this.onePiece = this.modeGame == 1 ? 60000 / this.imgTimeBar.getWidth() : 7000 / this.imgTimeBar.getWidth();
    }

    private void paintPause(Graphics g) {
        g.drawImage(this.imgPause, this.rectPause.getCenterX(), this.rectPause.getCenterY(), 3);
    }

    private void paintPausePressed(Graphics g) {
        g.drawImage(this.imgSpot, this.rectScreen.getCenterX(), 0, 17);
        this.fontMain.drawString(g, str[14].toCharArray(), this.rectScreen.width >> 1, (this.fontMain.getHeight() << 1) - (this.fontMain.getHeight() >> 3), 33);
        this.paintSettButtons(g);
    }

    private void paintInstructions(Graphics g) {
        g.drawImage(this.imgSpot, this.rectScreen.getCenterX(), this.imgSpot.getHeight() >> 1, 3);
        this.fontMain.drawString(g, str[31].toCharArray(), this.rectScreen.width >> 1, (this.fontMain.getHeight() << 1) - (this.fontMain.getHeight() >> 3), 33);
        g.drawImage(this.imgWindowInstr, this.rectInstructions.getCenterX(), this.rectInstructions.getCenterY(), 3);
        g.setClip(this.rectInstrPlane.x, this.rectInstrPlane.y, this.rectInstrPlane.width, this.rectInstrPlane.height);
        this.prepareTextInstructions.drawText(g, this.rectTextInstr, 17);
        String txt = X.singleton.getAppProperty("MIDlet-Name").toUpperCase();
        g.drawImage(this.imgLogo, this.rectScreen.getCenterX(), this.rectTextInstr.getBottom() - this.imgLogo.getHeight() - (this.imgLogo.getHeight() >> 1), 3);
        this.fontMain.drawString(g, txt.toCharArray(), this.rectScreen.width >> 1, this.rectTextInstr.getBottom() - (this.imgLogo.getHeight() >> 1) - this.fontMain.getHeight(), 17);
        txt = Resources.resTexts[0].getHashedString(33) + " " + X.singleton.getAppProperty("MIDlet-Version").toUpperCase();
        this.fontMain.drawString(g, txt.toCharArray(), this.rectScreen.width >> 1, this.rectTextInstr.getBottom() - (this.imgLogo.getHeight() >> 1), 17);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (this.KEYBOARD_VALUE < 0) {
            if (this.rectInstrPlane.y > this.rectTextInstr.y) {
                this.sprArrowInactive.setTransform(6);
                this.paintSprite(this.rectUpArrow.x, this.rectUpArrow.y, this.sprArrowInactive, g, -1);
            }
            this.sprArrow.setTransform(5);
            this.paintSprite(this.rectDownArrow.x, this.rectDownArrow.y, this.sprArrow, g, -1);
        } else if (this.KEYBOARD_VALUE > 0) {
            this.sprArrow.setTransform(6);
            this.paintSprite(this.rectUpArrow.x, this.rectUpArrow.y, this.sprArrow, g, -1);
            if (this.rectInstrPlane.getBottom() < this.rectTextInstr.getBottom()) {
                this.sprArrowInactive.setTransform(5);
                this.paintSprite(this.rectDownArrow.x, this.rectDownArrow.y, this.sprArrowInactive, g, -1);
            }
        } else {
            if (this.rectInstrPlane.y > this.rectTextInstr.y) {
                this.sprArrow.setTransform(6);
                this.paintSprite(this.rectUpArrow.x, this.rectUpArrow.y, this.sprArrow, g, -1);
            }
            if (this.rectInstrPlane.getBottom() < this.rectTextInstr.getBottom()) {
                this.sprArrow.setTransform(5);
                this.paintSprite(this.rectDownArrow.x, this.rectDownArrow.y, this.sprArrow, g, -1);
            }
        }
    }

    private void updateInstructions(int yDiff) {
        this.rectTextInstr.y += -yDiff;
        if (this.rectTextInstr.y > this.rectInstrPlane.y) {
            this.rectTextInstr.y = this.rectInstrPlane.y;
        } else if (this.rectTextInstr.getBottom() < this.rectInstrPlane.getBottom()) {
            this.rectTextInstr.y = this.rectInstrPlane.getBottom() - this.rectTextInstr.height;
        }
    }

    private void initInstructions() {
        int logoMini = (this.imgLogo.getHeight() << 1) + (this.imgLogo.getHeight() >> 1);
        int width = this.imgWindowInstr.getWidth() - (this.imgWindowInstr.getWidth() >> 2);
        int height = this.imgWindowInstr.getHeight() - (this.imgWindowInstr.getHeight() >> 2);
        int x = this.rectScreen.getCenterX() - (width >> 1);
        int y = this.rectScreen.getCenterY() - (height >> 1);
        this.rectInstructions = new Rectangle(x, y, width, height);
        this.rectInstrPlane = new Rectangle(x, y - (this.imgWindowInstr.getHeight() >> 4) + (this.sprArrow.getWidth() >> 1), width, height - this.sprArrow.getWidth() - (this.sprArrow.getWidth() >> 1));
        String instructionsText = str[28];
        instructionsText = instructionsText + "\n\n" + str[29];
        this.prepareTextInstructions = new PreparedText(this.fontMain);
        this.prepareTextInstructions.prepareText(instructionsText, this.rectInstrPlane.width);
        this.rectTextInstr = new Rectangle(this.rectInstrPlane.x, this.rectInstrPlane.y, this.rectInstrPlane.width, this.prepareTextInstructions.getTextHeight() + logoMini);
        x = this.rectScreen.getCenterX() - (this.sprArrow.getHeight() >> 1);
        int y1 = this.rectInstrPlane.y - this.sprArrow.getWidth() - (this.sprArrow.getWidth() >> 2);
        int y2 = this.rectInstrPlane.getBottom() + (this.sprArrow.getWidth() >> 2);
        this.rectUpArrow = new Rectangle(x, y1, this.sprArrow.getHeight(), this.sprArrow.getWidth());
        this.rectDownArrow = new Rectangle(x, y2, this.sprArrow.getHeight(), this.sprArrow.getWidth());
    }

    private void initPause() {
        int x = this.rectScreen.width - this.imgPause.getWidth() - (this.imgPause.getWidth() >> 1);
        int y = this.imgPause.getHeight() >> 1;
        this.rectPause = new Rectangle(x, y, this.imgPause.getWidth(), this.imgPause.getHeight());
    }

    private void updateBallBody() {
        int x = this.ballBody.positionFX().xAsInt();
        int y = this.ballBody.positionFX().yAsInt();
        this.ballBodyVelocity = this.ballBody.velocityFX().yFX;
        if (this.isBoardCreated) {
            this.checkCollisionBallAndBoard(x);
        }
        if (!this.gameOver) {
            if (x < -this.radius) {
                this.ballBody.setPositionFX(FXVector.newVector(MainCanvas.WIDTH + this.radius, y));
            } else if (x > this.radius + MainCanvas.WIDTH) {
                this.ballBody.setPositionFX(FXVector.newVector(-this.radius, y));
            }
        }
        if (this.ballBodyVelocity < 0) {
            this.maxHight = y;
        } else if (this.isParticleActiveGenerate) {
            this.isParticleActiveGenerate = false;
        }
        this.rectBall.x = x - this.radius;
        this.rectBall.y = y - this.radius;
        if (this.maxHight > y) {
            this.maxHight = y;
            this.calculateMaxHight();
        }
        if (this.timer % 100L < 41L) {
            this.changeRotateBall(x);
            if (!this.firstSpriteBall) {
                if (!this.isRightBall) {
                    if (this.rotateBall == 0) {
                        this.rotateBall = 5;
                    } else if (this.rotateBall == 5) {
                        this.rotateBall = 3;
                    } else if (this.rotateBall == 3) {
                        this.rotateBall = 6;
                    } else if (this.rotateBall == 6) {
                        this.rotateBall = 0;
                    }
                } else if (this.rotateBall == 2) {
                    this.rotateBall = 4;
                } else if (this.rotateBall == 4) {
                    this.rotateBall = 1;
                } else if (this.rotateBall == 1) {
                    this.rotateBall = 7;
                } else if (this.rotateBall == 7) {
                    this.rotateBall = 2;
                }
            }
            this.firstSpriteBall = !this.firstSpriteBall;
        }
        this.previousBallX = x;
    }

    private void initHoop() {
        this.moveBoard = MainCanvas.WIDTH >> 2;
        this.heightBoard = this.sprBoard.getHeight();
        int x = (this.radius << 1) + (this.radius >> 1);
        int limit = this.earthBody.positionFX().yAsInt() - this.heightBoard - this.rectScore.getCenterY() - this.heightBoard;
        int var = ScreenGame.getRandomUInt(limit);
        int y = this.rectScore.y + var + (this.heightBoard >> 1);
        int xBody = this.radius + (this.radius >> 2);
        int yBody = y;
        this.rectBoard = new Rectangle(xBody - this.moveBoard - this.sprBoard.getWidth() + (this.radius >> 2), yBody - (this.heightBoard >> 1), this.sprBoard.getWidth(), this.heightBoard);
        this.rectHoop = new Rectangle(this.rectBoard.getRight(), this.rectBoard.getBottom() - this.sprUpHoop.getHeight(), this.sprUpHoop.getWidth(), this.sprUpHoop.getHeight());
        if (this.isRightBoard) {
            x = MainCanvas.WIDTH - (this.radius << 2) - (this.radius << 1) + (this.radius >> 1);
            xBody = x + (this.radius << 2) + (this.radius >> 1);
            yBody = y;
            this.rectBoard = new Rectangle(xBody - (this.radius << 2) + this.moveBoard + this.sprBoard.getWidth() - (this.radius >> 1), yBody - (this.heightBoard >> 1), this.sprBoard.getWidth(), this.heightBoard);
            this.rectHoop = new Rectangle(this.rectBoard.x - this.sprUpHoop.getWidth(), this.rectBoard.getBottom() - this.sprUpHoop.getHeight(), this.sprUpHoop.getWidth(), this.sprUpHoop.getHeight());
        }
        this.rectShadowBall = new Rectangle(this.ballBody.positionFX().xAsInt() - (this.sprBall.getWidth() >> 1), this.rectScreen.height - (this.rectScreen.height >> 3) + this.sprShadowBall.getHeight(), this.sprShadowBall.getWidth(), this.sprShadowBall.getHeight());
    }

    private void updateScore() {
        if (this.collisionObjectIndex == 3 && this.ballBodyVelocity < 0) {
            this.scoreAdded[0] = false;
            this.scoreAdded[1] = false;
            this.leftWallScoreBody.setInteracting(false);
            this.rightWallScoreBody.setInteracting(false);
        } else if (this.collisionObjectIndex == 3 && this.ballBodyVelocity > 0 && !this.scoreAdded[0]) {
            this.scoreAdded[0] = true;
            this.leftWallScoreBody.setInteracting(true);
            this.rightWallScoreBody.setInteracting(true);
        } else if (this.collisionObjectIndex == 4 && this.ballBodyVelocity > 0 && this.scoreAdded[0] && !this.scoreAdded[1]) {
            this.scoreAdded[1] = true;
            if ((double)this.board[0].positionFX().yAsInt() - (double)this.heightBoard * 1.3 >= (double)this.maxHight && this.isClearShot) {
                this.textShot = str[9];
                ++Variables.highShots;
                ++this.combo;
                if (this.shotWithBoard && this.isClearShot) {
                    ++Variables.ofTheBoard;
                }
                ++Variables.totalBaskets;
                Variables.save(this.modeGame, this.modeData);
                this.highShot = true;
            } else if (this.lastChance || this.isClearShot) {
                if (this.lastChance) {
                    ++Variables.buzzerBeaters;
                    this.textShot = str[11];
                    this.buzzerBeater = true;
                    if (this.modeGame == 1) {
                        this.gameTimer = 1000L;
                    }
                } else if (this.isClearShot) {
                    ++Variables.cleanShots;
                    this.textShot = str[8];
                }
                ++this.combo;
                if (this.shotWithBoard && this.isClearShot) {
                    ++Variables.ofTheBoard;
                }
                ++Variables.totalBaskets;
                Variables.save(this.modeGame, this.modeData);
            } else {
                this.textShot = null;
                this.combo = 1;
                ++Variables.totalBaskets;
                Variables.save(this.modeGame, this.modeData);
            }
        } else if (this.collisionObjectIndex == -1 && this.scoreAdded[0] && this.scoreAdded[1]) {
            this.scoreAdded[0] = false;
            this.scoreAdded[1] = false;
            this.addScore();
            this.boardLeave = true;
            this.moveBoard = MainCanvas.WIDTH >> 2;
            this.lastChance = false;
            this.isRightBoard = !this.isRightBoard;
            this.isRightBall = this.isRightBoard;
            this.rotateBall = !this.isRightBoard ? 2 : 0;
        }
    }

    private void otherSiteBoard() {
        if (this.coinBody != null) {
            this.world.removeBody(this.coinBody);
            this.coinBody = null;
        }
        for (int index = 0; index < this.board.length; ++index) {
            Body body = this.board[index];
            this.world.removeBody(body);
        }
        this.world.removeBody(this.leftWallScoreBody);
        this.world.removeBody(this.rightWallScoreBody);
        this.initHoop();
        if (this.isRightBoard) {
            this.sprBoard.setTransform(0);
            this.sprBoardShadow.setTransform(0);
            this.sprUpHoop.setTransform(0);
            this.sprDownHoop.setTransform(0);
        } else {
            this.sprBoard.setTransform(2);
            this.sprBoardShadow.setTransform(2);
            this.sprUpHoop.setTransform(2);
            this.sprDownHoop.setTransform(2);
        }
        this.isBoardCreated = false;
    }

    private void checkClearShot() {
        if (this.isClearShot) {
            if (this.collisionObjectIndex == 0 && this.scoreAdded[0]) {
                this.isClearShot = false;
            } else if (this.collisionObjectIndex == 1 && this.scoreAdded[0]) {
                this.isClearShot = false;
            }
        }
    }

    private void addScore() {
        this.timeAnimScore = 0;
        this.score = this.combo > 1 ? (this.score += this.combo - 1) : (this.score += this.combo);
        --this.countDownToCoin;
        if (this.isClearShot || this.buzzerBeater || this.highShot) {
            this.screenShakeActivated = true;
            this.screenShakeSteps = 10;
        }
        if (this.countDownToCoin == 0) {
            this.createCoin = true;
            this.newCountDownToCoin();
        }
        if (this.modeGame == 1) {
            if (this.score - this.combo == 0) {
                this.gameTimer = 60000L;
            }
            if (this.combo > 1) {
                ++this.gameTimer;
                this.timePosBar = (int)((60000L - this.gameTimer) / (long)this.onePiece);
            }
            if (Variables.bestScoreTime < this.score) {
                Variables.bestScoreTime = this.score;
            }
        } else if (this.modeGame == 0) {
            this.gameTimer = 7000L;
            this.timePosBar = 0;
            if (Variables.bestScoreArcade < this.score) {
                Variables.bestScoreArcade = this.score;
            }
        }
        if (this.isRightBoard) {
            this.comboRightTimer = 10;
            this.rightScore = true;
            this.comboRight = this.combo > 1 ? this.combo - 1 : this.combo;
        } else {
            this.comboLeftTimer = 10;
            this.leftScore = true;
            this.comboLeft = this.combo > 1 ? this.combo - 1 : this.combo;
        }
        this.leftWallScoreBody.setInteracting(false);
        this.rightWallScoreBody.setInteracting(false);
    }

    private void newCountDownToCoin() {
        this.countDownToCoin = ScreenGame.getRandomUInt(3) + 3;
    }

    private void initCoin() {
        Shape coin = Shape.createRectangle(this.sprCoin.getWidth(), this.sprCoin.getHeight());
        int x = (this.board[1].positionFX().xAsInt() - this.board[0].positionFX().xAsInt() >> 1) + this.board[0].positionFX().xAsInt();
        int y = this.board[3].positionFX().yAsInt() - this.radius;
        FXVector position = FXVector.newVector(x += ScreenGame.getRandomInt(this.sprCoin.getWidth()), y += ScreenGame.getRandomInt(this.sprCoin.getHeight()));
        this.coinBody = new Body(position, coin, false);
        this.coinBody.setInteracting(false);
        this.world.addBody(this.coinBody);
    }

    private void takeCoin() {
        if (this.coinBody != null && Collision.detectCollision(this.ballBody, this.coinBody) != null) {
            ++GameData.coins;
            this.world.removeBody(this.coinBody);
            this.coinBody = null;
            GameData.save();
        }
    }

    private void updatingBoard() {
        int oneStep = this.sprCoin.getWidth() >> 2;
        if (this.isRightBoard) {
            oneStep = -(this.sprCoin.getWidth() >> 2);
        }
        if (this.boardLeave) {
            this.moveBoard -= Math.abs(oneStep);
            if (this.moveBoard <= 0) {
                this.boardLeave = false;
            }
            for (int part = 0; part < this.board.length; ++part) {
                this.board[part].setInteracting(false);
            }
        } else {
            this.moveBoard -= Math.abs(oneStep);
        }
        this.rectBoard.x += oneStep;
        this.rectHoop.x += oneStep;
    }

    private void paintBoard(Graphics g) {
        if (this.isRightBoard) {
            this.paintSprite(this.rectBoard.getRight() - this.sprBoardShadow.getWidth() + this.screenShakeX, this.rectShadowBall.y - (this.sprBoardShadow.getHeight() >> 2) + this.screenShakeY, this.sprBoardShadow, g, -1);
        } else {
            this.paintSprite(this.rectBoard.x + this.screenShakeX, this.rectShadowBall.y - (this.sprBoardShadow.getHeight() >> 2) + this.screenShakeY, this.sprBoardShadow, g, -1);
        }
        this.paintSprite(this.rectBoard.x + this.screenShakeX, this.rectBoard.y + this.screenShakeY, this.sprBoard, g, 0);
        this.paintSprite(this.rectHoop.x + this.screenShakeX, this.rectHoop.y + this.screenShakeY, this.sprUpHoop, g, 0);
        this.paintBall(g);
        this.paintSprite(this.rectHoop.x + this.screenShakeX, this.rectHoop.y + this.screenShakeY, this.sprDownHoop, g, 0);
    }

    private void paintResult(Graphics g) {
        int x = this.rectScreen.getCenterX();
        int y = this.rectBallScore.getBottom() + (this.fontMain.getHeight() >> 1);
        g.drawImage(this.imgWindowInstr, this.rectScreen.getCenterX(), this.imgWindowInstr.getHeight() >> 1, 3);
        int bestScore = this.modeGame == 0 ? Variables.bestScoreArcade : Variables.bestScoreTime;
        if (this.resultStep >= 1000) {
            this.fontMain.drawString(g, str[27].toCharArray(), x, y, 3);
            y += this.fontMain.getHeight() + (this.sprBigNumber.getHeight() >> 2);
        }
        if (this.resultStep >= 2000) {
            this.paintNumbers(g, this.score, y);
            y = this.rectHome.y - (this.fontMain.getHeight() << 2) + this.fontMain.getHeight();
        }
        if (this.resultStep >= 3000) {
            this.fontMain.drawString(g, str[25].toCharArray(), x, y, 3);
            y += this.fontMain.getHeight();
        }
        if (this.resultStep >= 4000) {
            this.fontMain.drawString(g, (bestScore + "").toCharArray(), x, y, 3);
        }
        g.drawImage(this.imgHome, this.rectHome.getCenterX(), this.rectHome.getCenterY(), 3);
        g.drawImage(this.imgAgain, this.rectStartAgain.getCenterX(), this.rectStartAgain.getCenterY(), 3);
    }

    private void initResultBtns() {
        this.rectHome = new Rectangle(this.offset, this.rectScreen.height - (this.imgHome.getHeight() >> 2) - this.imgHome.getHeight(), this.imgHome.getWidth(), this.imgHome.getHeight());
        this.rectStartAgain = new Rectangle(this.rectScreen.width - this.offset - this.imgAgain.getWidth(), this.rectHome.y, this.imgAgain.getWidth(), this.imgAgain.getHeight());
    }

    private boolean checkCollisionWithBoard() {
        return this.collisionObjectIndex == 2;
    }

    private void paintScoreLine(Graphics g) {
    }

    private void calculateMaxHight() {
        if (this.board != null && this.board[0] != null) {
            int leftCirclePosY = this.board[0].positionFX().yAsInt();
            if (this.maxHight >= 0 && this.maxHight < leftCirclePosY) {
                this.maxHight = this.board[0].positionFX().yAsInt() - this.maxHight;
            } else if (this.maxHight < 0 && this.maxHight < leftCirclePosY) {
                this.maxHight = Math.abs(this.maxHight) + this.board[0].positionFX().yAsInt();
            }
            this.maxHight = this.maxHight < leftCirclePosY ? (this.maxHight >= 0 ? leftCirclePosY - this.maxHight : Math.abs(this.maxHight) + leftCirclePosY) : this.maxHight - leftCirclePosY + leftCirclePosY;
        }
    }

    private void initGameText() {
        int halfHeightFont = this.fontMain.getHeight() >> 1;
        this.rectBallScore = new Rectangle(0, this.rectTimebar.getBottom() + halfHeightFont, this.rectScreen.width, this.fontMain.getHeight());
        this.rectCombo = new Rectangle(0, this.rectBallScore.getBottom(), this.rectScreen.width, this.fontMain.getHeight());
        this.rectScore = new Rectangle(0, this.rectCombo.getBottom() + (this.sprBigNumber.getHeight() >> 2), this.rectScreen.width, this.fontMain.getHeight());
    }

    private void paintComboNumber(Graphics g) {
        if (this.comboRightTimer > 0 || this.comboLeftTimer > 0) {
            if (this.leftScore) {
                this.fontMain.drawString(g, (this.comboLeft + "").toCharArray(), this.xComboLeft, this.yComboLeft, 3);
            }
            if (this.rightScore) {
                this.fontMain.drawString(g, (this.comboRight + "").toCharArray(), this.xComboRight, this.yComboRight, 3);
            }
        }
    }

    private void paintCoins(Graphics g) {
        this.paintSprite(this.rectCoins.x + this.screenShakeX, this.rectCoins.y + this.screenShakeY, this.sprCoin, g, -1);
        this.fontMain.drawString(g, (GameData.coins + "").toCharArray(), this.rectCoins.getRight() + (this.sprCoin.getWidth() >> 1), this.rectCoins.getCenterY(), 6);
    }

    private void paintCoinBody(Graphics g) {
        if (this.coinBody != null) {
            this.paintSprite(this.coinBody.positionFX().xAsInt() - (this.sprCoin.getWidth() >> 1) + this.screenShakeX, this.coinBody.positionFX().yAsInt() - (this.sprCoin.getHeight() >> 1) + this.screenShakeY, this.sprCoin, g, this.frameCoin);
        }
    }

    private void initCoinPos() {
        int coinPosX = this.imgPause.getWidth() >> 1;
        int coinPosY = this.imgPause.getHeight() - (this.sprCoin.getHeight() >> 1);
        this.rectCoins = new Rectangle(coinPosX, coinPosY, this.sprCoin.getWidth(), this.sprCoin.getHeight());
    }

    private void updateAnimCoin() {
        ++this.frameCoin;
        if (this.frameCoin > this.sprCoin.getFrameSequenceLength() - 1) {
            this.frameCoin = 0;
        }
    }

    private void paintSprite(int x, int y, Sprite spr, Graphics g, int frame) {
        spr.setPosition(x, y);
        if (frame == -1) {
            spr.setFrame(0);
        } else {
            spr.setFrame(frame);
        }
        spr.paint(g);
    }

    private void updateShadowBall() {
        this.rectShadowBall.x = this.rectBall.x;
        this.frameShadowBall = this.ballBody.positionFX().yAsInt() < 0 ? 2 : (this.ballBody.positionFX().yAsInt() < this.earthBody.positionFX().yAsInt() - (this.heightBoard << 1) ? 1 : 0);
    }

    private void changeRotateBall(int x) {
        if (this.previousBallX > x && !this.isRightBall) {
            this.rotateBall = 2;
            this.isRightBall = true;
        } else if (this.previousBallX < x && this.isRightBall) {
            this.rotateBall = 0;
            this.isRightBall = false;
        } else if (this.previousBallX == x) {
            // empty if block
        }
    }

    private void checkCollisionBallAndBoard(int x) {
        if (this.collisionObjectIndex == -1) {
            for (int index = 0; index < this.board.length; ++index) {
                if (Collision.detectCollision(this.board[index], this.ballBody) == null) continue;
                this.collisionObjectIndex = index;
                return;
            }
        } else if (Collision.detectCollision(this.board[this.collisionObjectIndex], this.ballBody) == null) {
            this.collisionObjectIndex = -1;
        }
    }

    private void initTexts() {
        System.out.println("\n\tINIT TEXTS");
        Resources.loadText(0);
        ResourceBundle bundle = Resources.resTexts[0];
        ScreenGame.str[0] = "ZERO";
        for (int index = 1; index < str.length; ++index) {
            ScreenGame.str[index] = bundle.getHashedString(index);
        }
    }

    private void createParticles(int x, int y, int xSpeed, int ySpeed, int xAcceleration, int yAcceleration, Sprite sprite, int frame, int countOfFrames, int maxFrames) {
        this.particles.createParticle(x, y, xSpeed, ySpeed, xAcceleration, yAcceleration, sprite, frame, countOfFrames, maxFrames);
    }

    private void saveGame() {
        Variables.save(this.modeGame, this.modeData);
        System.out.println("save game game screen music: " + GameData.isMusicOn);
        GameData.save();
    }

    public void soundOn() {
        MainCanvas.soundManager.SetSoundOn(true);
        MainCanvas.soundManager.SetMusicOn(true);
        MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
    }

    public void soundOff() {
        MainCanvas.soundManager.Stop();
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.SetMusicOn(false);
    }

    private void changeSound() {
        if (this.isMusicOn) {
            this.soundOn();
        } else {
            this.soundOff();
        }
    }

    private void paintSettButtons(Graphics g) {
        g.drawImage(this.imgHome, this.rectHomePause.getCenterX(), this.rectHomePause.getCenterY(), 3);
        g.drawImage(this.imgInstructions, this.rectInstructionsBtn.getCenterX(), this.rectInstructionsBtn.getCenterY(), 3);
    }

    private void confirmAction() {
        switch (this.action) {
            case 0: {
                this.ballBody.velocityFX().xFX = 0;
                this.ballBody.velocityFX().yFX = 0;
                this.shotWithBoard = false;
                this.isClearShot = true;
                this.isRightBall = this.isRightBoard;
                int massBall = this.ballBody.shape().getMass();
                int gravity = this.world.getGravity().yAsInt() / 10;
                int xForce = this.radius + (this.radius >> 1);
                int yForce = this.radius - (this.radius >> 2);
                if (MainCanvas.HEIGHT <= 432) {
                    yForce += this.radius >> 2;
                    xForce += this.radius >> 2;
                }
                if (MainCanvas.WIDTH >= 300 && MainCanvas.HEIGHT < 500) {
                    yForce += this.radius >> 2;
                    xForce += this.radius >> 1;
                }
                if (MainCanvas.WIDTH > 500) {
                    xForce += this.radius >> 3;
                }
                int forceY = yForce * massBall * gravity;
                int forceX = xForce * massBall;
                if (!this.isRightBoard) {
                    forceX = -1 * forceX;
                }
                FXVector vector = FXVector.newVector(forceX, -forceY);
                this.ballBody.applyMomentum(vector);
                this.isParticleActiveGenerate = true;
                this.scoreAdded[0] = false;
                break;
            }
            case 1: {
                Variables.save(this.modeGame, this.modeData);
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, this.modeGame, 1));
                this.mainCanvas.repaint();
                break;
            }
            case 2: {
                this.isMusicOn = !this.isMusicOn;
                this.changeSound();
                GameData.isMusicOn = this.isMusicOn;
                GameData.save();
                break;
            }
            case 3: {
                ++Variables.totalGames;
                Variables.save(this.modeGame, this.modeData);
                this.mainCanvas.changeLastActiveScreen(new ScreenGame(this.mainCanvas, this.modeGame, this.modeData));
                this.mainCanvas.repaint();
            }
        }
    }

    private void changeCursorPos(int x, int y) {
        this.rectCursor.x = x - (this.rectCursor.width >> 1);
        this.rectCursor.y = y - (this.rectCursor.height >> 1);
    }

    private void initCursor() {
        int width = this.imgCursor.getWidth();
        int height = this.imgCursor.getHeight();
        int x = this.rectHomePause.getCenterX() - (width >> 1);
        int y = this.rectHomePause.getCenterY() - (height >> 1);
        this.rectCursor = new Rectangle(x, y, width, height);
    }

    private void paintCursor(Graphics g) {
        if (this.isPause) {
            g.drawImage(this.imgCursor, this.rectCursor.getCenterX() + (this.rectCursor.width >> 1), this.rectCursor.getCenterY() + (this.rectCursor.height >> 1), 3);
        }
    }

    private void updateAnimCombo() {
        if (this.animScoreXPos < MainCanvas.getCenterX()) {
            this.animScoreXPos += this.sprCoin.getWidth();
            if (this.animScoreXPos > MainCanvas.getCenterX()) {
                this.animScoreXPos = MainCanvas.getCenterX();
            }
        }
    }

    private void setBG() {
        int ID_BG = 13 + GameData.activeCourt;
        Resources.loadImages(new int[]{ID_BG});
        this.imgBG = Resources.resImgs[ID_BG];
    }

    private int getXBigNumberStartPos(int number) {
        int length = String.valueOf(number).length();
        int width = length * this.sprBigNumber.getWidth();
        return this.rectScreen.getCenterX() - (width >> 1);
    }

    private void paintNumbers(Graphics g, int number, int y) {
        String numberText = String.valueOf(number);
        int length = numberText.length();
        int x = this.getXBigNumberStartPos(number);
        for (int index = 0; index < length; ++index) {
            this.paintSprite(x, y, this.sprBigNumber, g, Integer.parseInt(numberText.charAt(index) + ""));
            x += this.sprBigNumber.getWidth();
        }
    }

    private void initScoreRectangles() {
        int width = 1;
        int height = this.sprUpHoop.getHeight() >> 1;
        Shape leftScoreWall = Shape.createRectangle(width, height);
        leftScoreWall.setElasticity(80);
        int xLeftBody = this.board[0].positionFX().xAsInt() + (this.radius >> 2);
        int xRightBody = this.board[1].positionFX().xAsInt() - (this.radius >> 3);
        int yBody = this.rectHoop.y + (this.rectHoop.height >> 1);
        this.leftWallScoreBody = new Body(xLeftBody, yBody, leftScoreWall, false);
        this.rightWallScoreBody = new Body(xRightBody, yBody, leftScoreWall, false);
        this.leftWallScoreBody.setInteracting(false);
        this.rightWallScoreBody.setInteracting(false);
        this.world.addBody(this.leftWallScoreBody);
        this.world.addBody(this.rightWallScoreBody);
    }

    private void setBoard() {
        int x = this.rectBoard.getRight();
        int y = this.rectBoard.getCenterY();
        int leftCircle = x + (this.rectHoop.width >> 3);
        int rightCircle = this.rectHoop.getRight();
        int widthBoard = this.rectBoard.width >> 3;
        Shape circle = Shape.createCircle(2);
        circle.setElasticity(100);
        Shape boardBox = Shape.createRectangle(widthBoard, this.heightBoard);
        boardBox.setElasticity(100);
        Shape scoreBox = Shape.createRectangle(this.rectHoop.width >> 1, 3);
        Body boardBody = new Body(x - (widthBoard >> 1), y, boardBox, false);
        if (this.isRightBoard) {
            x = this.rectBoard.x;
            leftCircle = x - this.rectHoop.width;
            rightCircle = x - (this.rectHoop.width >> 3);
            boardBody = new Body(x + (widthBoard >> 1), y, boardBox, false);
        }
        this.scoreBodyUp = new Body(this.rectHoop.getCenterX(), y - this.radius, scoreBox, false);
        this.scoreBodyUp.setInteracting(false);
        this.scoreBodyDown = new Body(this.rectHoop.getCenterX(), y + (this.radius << 1), scoreBox, false);
        this.scoreBodyDown.setInteracting(false);
        Body hoopCircleLeft = new Body(leftCircle, this.rectHoop.y + (this.rectHoop.height >> 2) - (this.radius >> 2), circle, false);
        Body hoopCircleRight = new Body(rightCircle, this.rectHoop.y + (this.rectHoop.height >> 2) - (this.radius >> 2), circle, false);
        this.board = new Body[]{hoopCircleLeft, hoopCircleRight, boardBody, this.scoreBodyUp, this.scoreBodyDown};
        for (int index = 0; index < this.board.length; ++index) {
            Body body = this.board[index];
            this.world.addBody(body);
        }
        this.scoreLine = this.scoreBodyDown.positionFX().yAsInt();
        this.xComboRight = this.xComboLeft = hoopCircleLeft.positionFX().xAsInt() + (hoopCircleRight.positionFX().xAsInt() - hoopCircleLeft.positionFX().xAsInt() >> 1);
        this.yComboLeft = this.yComboRight = hoopCircleLeft.positionFX().yAsInt() - this.radius;
        if (this.createCoin) {
            this.initCoin();
            this.createCoin = false;
        }
        this.isBoardCreated = true;
        this.initScoreRectangles();
    }
}

