/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.util;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.util.ArrayInt;
import sk.inlogic.util.ArrayObject;

public class Particles {
    static final int MAX_PARTICLES = 320;
    private int[] partX = new int[320];
    private int[] partY = new int[320];
    private int[] partVelX = new int[320];
    private int[] partVelY = new int[320];
    private int[] partAccX = new int[320];
    private int[] partAccY = new int[320];
    private int[] partCol = new int[320];
    private int[] partSize = new int[320];
    private int[] partLife = new int[320];
    private Sprite[] partSprite = new Sprite[320];
    private int[] partFrame = new int[320];
    private int partMaxFrames = 0;

    public void resetParticles() {
        ArrayInt.resetArray(this.partX);
        ArrayObject.resetObjectsArray(this.partSprite);
        System.gc();
    }

    public int createParticle(int X2, int Y, int VelX, int VelY, int AccX, int AccY, int Size, int Col, int Life) {
        for (int i = this.partX.length - 1; i >= 0; --i) {
            if (this.partX[i] != -9999999) continue;
            this.partSprite[i] = null;
            this.partFrame[i] = 0;
            this.partX[i] = X2 * 10;
            this.partY[i] = Y * 10;
            this.partVelX[i] = VelX;
            this.partVelY[i] = VelY;
            this.partAccX[i] = AccX;
            this.partAccY[i] = AccY;
            this.partSize[i] = Size;
            this.partCol[i] = Col;
            this.partLife[i] = Life;
            return i;
        }
        return -1;
    }

    public int createParticle(int X2, int Y, int VelX, int VelY, int AccX, int AccY, Sprite Source, int Frame, int Life, int maxFrames) {
        for (int i = this.partX.length - 1; i >= 0; --i) {
            if (this.partX[i] != -9999999) continue;
            this.partSprite[i] = Source;
            this.partFrame[i] = Frame;
            this.partX[i] = X2 * 10;
            this.partY[i] = Y * 10;
            this.partVelX[i] = VelX;
            this.partVelY[i] = VelY;
            this.partAccX[i] = AccX;
            this.partAccY[i] = AccY;
            this.partSize[i] = 0;
            this.partCol[i] = 0;
            this.partLife[i] = Life;
            this.partMaxFrames = maxFrames;
            return i;
        }
        return -1;
    }

    public boolean update() {
        boolean needRepaint = false;
        for (int i = this.partX.length - 1; i >= 0; --i) {
            if (this.partX[i] == -9999999) continue;
            if (this.partLife[i] > 0) {
                int n = i;
                this.partLife[n] = this.partLife[n] - 1;
                int n2 = i;
                this.partX[n2] = this.partX[n2] + this.partVelX[i];
                int n3 = i;
                this.partY[n3] = this.partY[n3] + this.partVelY[i];
                int n4 = i;
                this.partVelX[n4] = this.partVelX[n4] + this.partAccX[i];
                int n5 = i;
                this.partVelY[n5] = this.partVelY[n5] + this.partAccY[i];
                if (this.partLife[i] % 6 == 0) {
                    int n6 = i;
                    this.partFrame[n6] = this.partFrame[n6] + 1;
                    if (this.partFrame[i] == this.partMaxFrames) {
                        this.partFrame[i] = 0;
                    }
                }
                needRepaint = true;
                continue;
            }
            this.partX[i] = -9999999;
        }
        return needRepaint;
    }

    public void paint(Graphics g) {
        for (int i = this.partX.length - 1; i >= 0; --i) {
            if (this.partX[i] == -9999999) continue;
            int px = this.partX[i] / 10;
            int py = this.partY[i] / 10;
            if (this.partSprite[i] != null) {
                this.partSprite[i].setPosition(px - this.partSprite[i].getWidth() / 2, py - this.partSprite[i].getHeight() / 2);
                if (this.partMaxFrames == 0) {
                    this.partSprite[i].setFrame(this.partFrame[0]);
                } else {
                    this.partSprite[i].setFrame(this.partFrame[i]);
                }
                this.partSprite[i].paint(g);
                continue;
            }
            int tmp = this.partSize[i] / 2;
            g.setColor(this.partCol[i]);
            g.fillRect(px - tmp, py - tmp, this.partSize[i], this.partSize[i]);
        }
    }

    public int[] getActiveParts() {
        int[] actives = new int[this.partX.length - 1];
        int i = 0;
        for (int j = 0; j < actives.length; ++j) {
            actives[j] = -1;
        }
        for (int index = 0; index < this.partX.length; ++index) {
            if (this.partX[index] == -9999999) continue;
            actives[i] = index;
            ++i;
        }
        return actives;
    }

    public int activeParticles() {
        return ArrayInt.getNonNullValuesCount(this.partX);
    }

    public int getXPos(int pos) {
        int position = this.getActiveParts()[pos];
        int x = this.partX[position];
        return x;
    }

    public int getYPos(int pos) {
        int position = this.getActiveParts()[pos];
        int y = this.partY[position];
        return y;
    }
}

