/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import at.emini.physics2D.Body;
import at.emini.physics2D.Collision;
import at.emini.physics2D.Shape;
import at.emini.physics2D.World;
import at.emini.physics2D.util.FXVector;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Ball;
import sk.inlogic.Court;
import sk.inlogic.GameData;
import sk.inlogic.GraphicsMem;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.ShopList;
import sk.inlogic.Sounds;
import sk.inlogic.Variables;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.saves.Data;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.text.PreparedText;
import sk.inlogic.text.ResourceBundle;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    private final int ID_INTRO;
    private final int ID_MENU;
    private final int ID_STATS;
    private final int ID_SHOP;
    private final int ID_COURTS;
    private final int ID_INSTRUCTIONS;
    private final int ID_QUIT;
    private final int ID_LOGO;
    private final int ID_LANGUAGE;
    private final int ID_SOUNDS;
    private final int ID_SPLASH;
    private final int ID_ARCADE;
    private final int ID_TIME;
    private int action;
    private final int ID_LANG;
    private final int ID_PLAY;
    private final int ID_SHOP_MENU;
    private final int ID_COURTS_MENU;
    private final int ID_STATS_MENU;
    private final int ID_QUIT_APP;
    private final int ID_SOUNDS_SETT;
    private final int ID_SOUND_ON;
    private final int ID_SOUND_OFF;
    private int actuallScreen;
    private int subScreen;
    private int namePosX;
    private int namePosY;
    private int coinPosX;
    private int coinPosY;
    private int modeGame = 1;
    private Data modeData = RMSObjects.dataTimeMode;
    private int bestScorePosYText;
    private int bestScorePosY;
    private int oneRowStat;
    private int previousX;
    private int yBallPos;
    private int yCourtPos;
    private int rotateBall;
    private int timeToStartJump;
    private int maxVelocity;
    private int yFirstPressedInstr;
    private int KEYBOARD_VALUE;
    private int scrolling;
    private int offset;
    private boolean isMusicOn;
    private boolean isFirstSprite;
    private boolean isSettingsPressed;
    private boolean instrPressed;
    private boolean downPressedInstr;
    private boolean upPressedInstr;
    private boolean scrollingActivePressed;
    private boolean fkleftPressed;
    private long timer;
    private long introTimer;
    private String nameOfScreen;
    private String modeText;
    private String txt;
    public static String[] str = new String[33];
    private static String[] langCodes = new String[]{"en", "de", "fr", "it", "es", "pt"};
    private int selectedLang;
    private int selectedMenu;
    private int selectedSett;
    private Rectangle rectScreen;
    private Rectangle rectSett;
    private Rectangle rectStats;
    private Rectangle rectExit;
    private Rectangle[] rectButtons;
    private Rectangle[] rectSettBtns;
    private Rectangle rectSelectBtn;
    private Rectangle rectBackBtn;
    private Rectangle rectScroll;
    private Rectangle[] rectBalls;
    private Rectangle[] rectCourts;
    private Rectangle rectSounds;
    private Rectangle rectInstructions;
    private Rectangle rectInstructionsBtn;
    private Rectangle rectBack;
    private Rectangle rectTextInstr;
    private Rectangle rectInstrPlane;
    private Rectangle[] rectLanguages;
    private Rectangle rectCursor;
    private Rectangle rectYes;
    private Rectangle rectNo;
    private Rectangle rectLeftArrow;
    private Rectangle rectRightArrow;
    private Rectangle rectUpArrow;
    private Rectangle rectDownArrow;
    private GFont fontMain;
    private PreparedText prepareTextInstructions;
    private PreparedText prepareExitQuestion;
    private Image imgName;
    private Image imgSett;
    private Image imgStats;
    private Image imgExit;
    private Image imgLock;
    private Image imgUnderText;
    private Image imgSounds;
    private Image imgInstructions;
    private Image imgBg;
    private Image imgBack;
    private Image imgWindowInstr;
    private Image imgSpot;
    private Image imgSoundOff;
    private Image imgBackShort;
    private Image imgPlayRed;
    private Image imgRed;
    private Image imgFineRed;
    private Image imgLeftBtn;
    private Image imgPlayMenu;
    private Image imgButtonMenu;
    private Image imgBall;
    private Image imgCourt;
    private Image imgCursor;
    private Image imgLogo;
    private Image imgLockBall;
    private Image imgShadowCourt;
    private Image imgSplash;
    private Sprite sprCoin;
    private Sprite sprBalls;
    private Sprite sprBallsRotated;
    private Sprite ball;
    private Sprite sprShadowBall;
    private Sprite sprFlags;
    private Sprite sprFlagsInactive;
    private Sprite sprMaps;
    private Sprite sprArrow;
    private Sprite sprArrowInactive;
    private MainCanvas mainCanvas;
    private Vector balls = new Vector();
    private Vector courts = new Vector();
    private World world;
    private Body ballBody;
    private Body earthBody;
    private int iSoundProbTimer = 50;
    private boolean bInterrupted = true;

    public ScreenMenu(MainCanvas mainCanvas, int mode, int ID) {
        this.ID_INTRO = 0;
        this.ID_MENU = 1;
        this.ID_STATS = 2;
        this.ID_SHOP = 3;
        this.ID_COURTS = 4;
        this.ID_INSTRUCTIONS = 5;
        this.ID_QUIT = 6;
        this.ID_LOGO = 0;
        this.ID_LANGUAGE = 1;
        this.ID_SOUNDS = 2;
        this.ID_SPLASH = 3;
        this.ID_ARCADE = 0;
        this.ID_TIME = 1;
        this.ID_LANG = 0;
        this.ID_PLAY = 1;
        this.ID_SHOP_MENU = 2;
        this.ID_COURTS_MENU = 3;
        this.ID_STATS_MENU = 4;
        this.ID_QUIT_APP = 5;
        this.ID_SOUNDS_SETT = 6;
        this.ID_SOUND_ON = 7;
        this.ID_SOUND_OFF = 8;
        this.mainCanvas = mainCanvas;
        this.modeGame = mode;
        this.actuallScreen = ID;
        if (this.modeGame < 0) {
            this.modeGame = 1;
        }
        if (this.actuallScreen == 1) {
            this.setMode(false);
            return;
        }
        GraphicsMem.setGraphicsMem();
    }

    public void update(long lastRunLenght) {
        if (this.mainCanvas.isInterrupted() && !this.bInterrupted) {
            this.bInterrupted = true;
        } else if (this.bInterrupted && !this.mainCanvas.isInterrupted()) {
            if (this.iSoundProbTimer > 0) {
                --this.iSoundProbTimer;
            } else {
                this.changeSound();
            }
        }
        this.timer += lastRunLenght;
        if (this.timer % 100L < 40L) {
            if (!this.isFirstSprite) {
                if (this.rotateBall == 0) {
                    this.rotateBall = 5;
                } else if (this.rotateBall == 5) {
                    this.rotateBall = 3;
                } else if (this.rotateBall == 3) {
                    this.rotateBall = 6;
                } else if (this.rotateBall == 6) {
                    this.rotateBall = 0;
                }
            }
            this.isFirstSprite = !this.isFirstSprite;
        }
        switch (this.actuallScreen) {
            case 0: {
                this.introTimer += lastRunLenght;
                switch (this.subScreen) {
                    case 0: {
                        if (this.introTimer < 2000L) break;
                        this.subScreen = 3;
                        this.introTimer = 0L;
                        this.action = 0;
                        this.confirmAction();
                        this.changeCursorPos(this.rectButtons[0].getCenterX(), this.rectButtons[0].getCenterY());
                        break;
                    }
                    case 3: {
                        if (this.introTimer < 2000L) break;
                        this.actuallScreen = 1;
                        this.introTimer = 0L;
                    }
                }
                break;
            }
            case 3: {
                if (this.scrollingActivePressed) {
                    this.updateScroll(this.scrolling, this.rectBalls);
                    if (this.world != null) {
                        this.stopUpdateWorld();
                    }
                }
                this.timeToStartJump = (int)((long)this.timeToStartJump + lastRunLenght);
                if (this.world == null) break;
                this.checkCollisionBallAndEarth();
                if (this.timeToStartJump <= 500) break;
                this.world.tick();
                break;
            }
            case 4: {
                if (!this.scrollingActivePressed) break;
                this.updateScroll(this.scrolling, this.rectCourts);
                break;
            }
            case 5: {
                if (!this.downPressedInstr && !this.upPressedInstr) break;
                this.updateInstructions(this.KEYBOARD_VALUE);
            }
        }
        this.mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        this.paintBG(g);
        switch (this.actuallScreen) {
            case 0: {
                switch (this.subScreen) {
                    case 0: {
                        this.paintLogo(g);
                        break;
                    }
                    case 1: {
                        this.paintLanguage(g);
                        break;
                    }
                    case 2: {
                        this.paintQuestion(g);
                        break;
                    }
                    case 3: {
                        this.paintSplash(g);
                    }
                }
                break;
            }
            case 1: {
                if (this.isSettingsPressed) {
                    this.paintSettButtons(g);
                    this.paintBackButton(g);
                    break;
                }
                this.paintCoins(g);
                this.paintSettingsButton(g);
                this.paintName(g);
                this.paintBestScore(g);
                this.paintButtons(g);
                this.paintStatsButton(g);
                this.paintExit(g);
                break;
            }
            case 2: {
                this.paintStats(g);
                this.paintBackButton(g);
                break;
            }
            case 3: {
                this.paintNumberItems(g, GameData.selectedBall + 1, this.rectBalls.length);
                this.paintScroll(g, this.rectBalls, GameData.activeBall, true);
                this.paintShopAndCourtsButtons(g);
                break;
            }
            case 4: {
                this.paintScroll(g, this.rectCourts, GameData.activeCourt, false);
                this.paintShopAndCourtsButtons(g);
                break;
            }
            case 5: {
                this.paintInstructions(g);
                this.paintBackButton(g);
                break;
            }
            case 6: {
                this.paintQuestion(g);
            }
        }
        if (this.nameOfScreen != null) {
            this.paintScreenName(g);
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
        switch (this.actuallScreen) {
            case 3: 
            case 4: {
                if (!this.rectScroll.contains(x, y)) break;
                this.previousX = x;
                break;
            }
            case 5: {
                if (!this.rectInstrPlane.contains(x, y)) break;
                this.instrPressed = true;
                this.yFirstPressedInstr = y;
            }
        }
    }

    public void pointerDragged(int x, int y) {
        switch (this.actuallScreen) {
            case 3: {
                if (!this.rectScroll.contains(x, y) || Math.abs(this.previousX - x) <= 5) break;
                this.resetItems(this.rectBalls, this.yBallPos);
                if (this.rectScroll.contains(x, y)) {
                    if (this.previousX < x) {
                        this.updateScroll(Math.abs(this.previousX - x), this.rectBalls);
                    } else if (this.previousX > x) {
                        this.updateScroll(-Math.abs(this.previousX - x), this.rectBalls);
                    }
                }
                this.previousX = x;
                if (this.world == null) break;
                this.stopUpdateWorld();
                break;
            }
            case 4: {
                if (!this.rectScroll.contains(x, y) || Math.abs(this.previousX - x) <= 5) break;
                if (this.rectScroll.contains(x, y)) {
                    if (this.previousX < x) {
                        this.updateScroll(Math.abs(this.previousX - x), this.rectCourts);
                    } else if (this.previousX > x) {
                        this.updateScroll(-Math.abs(this.previousX - x), this.rectCourts);
                    }
                }
                this.previousX = x;
                break;
            }
            case 5: {
                if (!this.rectInstrPlane.contains(x, y) || !this.instrPressed) break;
                int yDiff = this.yFirstPressedInstr - y;
                this.updateInstructions(yDiff);
                this.yFirstPressedInstr = y;
            }
        }
    }

    public void pointerReleased(int x, int y) {
        block36: {
            block0 : switch (this.actuallScreen) {
                case 0: {
                    switch (this.subScreen) {
                        case 0: {
                            this.subScreen = 1;
                            break;
                        }
                        case 1: {
                            for (int index = 0; index < this.rectLanguages.length; ++index) {
                                if (!this.rectLanguages[index].contains(x, y)) continue;
                                this.selectedLang = index;
                                this.action = 0;
                                this.confirmAction();
                            }
                            break block0;
                        }
                        case 2: {
                            if (this.rectYes.contains(x, y)) {
                                this.action = 7;
                                this.confirmAction();
                                break;
                            }
                            if (this.rectNo.contains(x, y)) {
                                this.action = 8;
                                this.confirmAction();
                                break;
                            }
                            break block36;
                        }
                        case 3: {
                            this.actuallScreen = 1;
                        }
                    }
                    break;
                }
                case 1: {
                    if (this.isSettingsPressed) {
                        if (this.rectSounds.contains(x, y)) {
                            this.action = 6;
                            this.confirmAction();
                            break;
                        }
                        if (this.rectInstructionsBtn.contains(x, y)) {
                            this.actuallScreen = 5;
                            this.executeAction();
                            break;
                        }
                        if (!this.rectBack.contains(x, y)) break;
                        this.isSettingsPressed = false;
                        this.nameOfScreen = null;
                        break;
                    }
                    if (this.rectSett.contains(x, y)) {
                        this.isSettingsPressed = true;
                        this.nameOfScreen = str[14];
                        this.initInstructions();
                        break;
                    }
                    if (this.rectButtons[0].contains(x, y)) {
                        this.action = 1;
                        this.confirmAction();
                        break;
                    }
                    if (this.rectButtons[1].contains(x, y)) {
                        this.setMode(true);
                        Variables.load(this.modeGame, this.modeData);
                        break;
                    }
                    if (this.rectButtons[2].contains(x, y)) {
                        this.action = 2;
                        this.confirmAction();
                        break;
                    }
                    if (this.rectButtons[3].contains(x, y)) {
                        this.action = 3;
                        this.confirmAction();
                        break;
                    }
                    if (this.rectButtons[4].contains(x, y)) {
                        this.isSettingsPressed = true;
                        this.nameOfScreen = str[14];
                        this.initInstructions();
                        break;
                    }
                    if (this.rectExit.contains(x, y)) {
                        this.actuallScreen = 6;
                        this.executeAction();
                        break;
                    }
                    if (!this.rectStats.contains(x, y)) break;
                    this.action = 4;
                    this.confirmAction();
                    break;
                }
                case 2: {
                    if (!this.rectBack.contains(x, y)) break;
                    this.actuallScreen = 1;
                    this.executeAction();
                    break;
                }
                case 3: {
                    if (this.rectBackBtn.contains(x, y)) {
                        this.actuallScreen = 1;
                        this.executeAction();
                        this.resetWorld();
                        this.resetPositionForBalls();
                    } else if (this.rectSelectBtn.contains(x, y)) {
                        this.ballButtonAction();
                    }
                    this.automaticChangePosItems(this.rectBalls, true);
                    if (!this.rectScroll.contains(x, y) || this.world != null) break;
                    this.resetWorld();
                    break;
                }
                case 4: {
                    if (this.rectBackBtn.contains(x, y)) {
                        this.actuallScreen = 1;
                        this.executeAction();
                    } else if (this.rectSelectBtn.contains(x, y)) {
                        this.courtButtonAction();
                        GraphicsMem.setBG(GameData.activeCourt);
                    }
                    this.automaticChangePosItems(this.rectCourts, false);
                    break;
                }
                case 5: {
                    if (this.rectInstrPlane.contains(x, y)) {
                        this.instrPressed = false;
                        break;
                    }
                    if (!this.rectBack.contains(x, y)) break;
                    this.isSettingsPressed = true;
                    this.nameOfScreen = str[14];
                    this.actuallScreen = 1;
                    break;
                }
                case 6: {
                    if (this.rectYes.contains(x, y)) {
                        this.action = 5;
                        this.confirmAction();
                        break;
                    }
                    if (!this.rectNo.contains(x, y)) break;
                    this.actuallScreen = 1;
                    this.executeAction();
                }
            }
        }
    }

    public void afterHide() {
        Resources.freeAllResources();
        MainCanvas.soundManager.Stop();
        this.saveGame();
    }

    public void beforeShow() {
        System.out.println("beforeShow()");
        this.fontMain = GraphicsMem.fontMain;
        this.imgName = GraphicsMem.imgName;
        this.imgSett = GraphicsMem.imgSett;
        this.imgStats = GraphicsMem.imgStats;
        this.imgExit = GraphicsMem.imgExit;
        this.imgLock = GraphicsMem.imgLock;
        this.imgUnderText = GraphicsMem.imgUnderText;
        this.imgSounds = GraphicsMem.imgSounds;
        this.imgInstructions = GraphicsMem.imgInstructions;
        this.imgBg = GraphicsMem.imgBg;
        this.imgBack = GraphicsMem.imgBack;
        this.imgWindowInstr = GraphicsMem.imgWindowInstr;
        this.imgSpot = GraphicsMem.imgSpot;
        this.imgSoundOff = GraphicsMem.imgSoundOff;
        this.imgBackShort = GraphicsMem.imgBackShort;
        this.imgPlayRed = GraphicsMem.imgPlayRed;
        this.imgRed = GraphicsMem.imgRed;
        this.imgFineRed = GraphicsMem.imgFineRed;
        this.imgPlayMenu = GraphicsMem.imgPlayMenu;
        this.imgButtonMenu = GraphicsMem.imgButtonMenu;
        this.imgBall = GraphicsMem.imgBall;
        this.imgCourt = GraphicsMem.imgCourt;
        this.imgCursor = GraphicsMem.imgCursor;
        this.imgLogo = GraphicsMem.imgLogo;
        this.imgLockBall = GraphicsMem.imgLockBall;
        this.imgShadowCourt = GraphicsMem.imgShadowCourt;
        this.imgSplash = GraphicsMem.imgSplash;
        this.sprCoin = GraphicsMem.sprCoin;
        this.sprBalls = GraphicsMem.sprBalls;
        this.sprBallsRotated = GraphicsMem.sprBallsRotated;
        this.sprShadowBall = GraphicsMem.sprShadowBall;
        this.sprFlags = GraphicsMem.sprFlags;
        this.sprFlagsInactive = GraphicsMem.sprFlagsInactive;
        this.sprMaps = GraphicsMem.sprMaps;
        this.sprArrow = GraphicsMem.sprArrow;
        this.sprArrowInactive = GraphicsMem.sprArrowInactive;
        this.initParameters();
        if (!this.mainCanvas.isInterrupted()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        }
        MainCanvas.soundManager.Stop();
        if (!GameData.isNotfirstGame) {
            this.firstGame();
        }
        if (this.actuallScreen == 1 && GameData.isMusicOn) {
            this.isMusicOn = GameData.isMusicOn;
            this.changeSound();
        }
    }

    public void beforeInteruption() {
        System.out.println("BEFORE INTERUPTION MENU");
        MainCanvas.soundManager.Stop();
        this.saveGame();
    }

    public void afterInteruption() {
        System.out.println("AFTER INTERUPTION MENU");
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        }
        this.saveGame();
    }

    private void paintBG(Graphics g) {
        this.imgBg = GraphicsMem.imgBg;
        if (this.imgBg == null) {
            return;
        }
        block0 : switch (this.actuallScreen) {
            case 1: {
                if (this.isSettingsPressed) {
                    g.setColor(89, 86, 201);
                    g.fillRect(this.rectScreen.x, this.rectScreen.y, this.rectScreen.width, this.rectScreen.height);
                    break;
                }
                g.drawImage(this.imgBg, this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                g.setColor(89, 86, 201);
                g.fillRect(this.rectScreen.x, this.rectScreen.y, this.rectScreen.width, this.rectScreen.height);
                break;
            }
            case 0: {
                switch (this.subScreen) {
                    case 2: {
                        g.setColor(89, 86, 201);
                        g.fillRect(this.rectScreen.x, this.rectScreen.y, this.rectScreen.width, this.rectScreen.height);
                        break block0;
                    }
                    case 1: {
                        g.drawImage(this.imgBg, this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
                    }
                }
            }
        }
    }

    private void paintCoins(Graphics g) {
        this.paintSprite(this.coinPosX - (this.sprCoin.getWidth() >> 1), this.coinPosY - (this.sprCoin.getHeight() >> 1), this.sprCoin, g, -1);
        this.fontMain.drawString(g, (GameData.coins + "").toCharArray(), this.sprCoin.getWidth() << 1, this.coinPosY, 6);
    }

    private void paintSettingsButton(Graphics g) {
        g.drawImage(this.imgSett, this.rectSett.getCenterX(), this.rectSett.getCenterY(), 3);
    }

    private void paintName(Graphics g) {
        g.drawImage(this.imgName, this.namePosX, this.namePosY, 3);
    }

    private void initParameters() {
        this.rectScreen = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.offset = this.imgRed.getWidth() >> 4;
        Variables.load(this.modeGame, this.modeData);
        this.initCoinPos();
        this.initSettingsButton();
        this.initMenuButtons();
        this.initRectScroll();
        this.initNamePos();
        this.initBestScore();
        this.initBottomButtons();
        ShopList shopList = new ShopList();
        this.balls = shopList.createBalls(this.sprBalls.getFrameSequenceLength());
        this.courts = shopList.createCourts(this.sprMaps.getFrameSequenceLength());
        GameData.ballCount = this.balls.size();
        GameData.balls = new int[GameData.ballCount];
        GameData.courtCount = this.courts.size();
        GameData.courts = new int[GameData.courtCount];
        GameData.load();
        GameData.save();
        this.rectBalls = new Rectangle[this.balls.size()];
        this.rectCourts = new Rectangle[this.courts.size()];
        this.createRectItems(true, this.rectBalls);
        this.createRectItems(false, this.rectCourts);
        this.initStatYPos();
        this.initSettButtons();
        int x = this.rectScreen.getCenterX() - (this.imgBack.getWidth() >> 1);
        int y = this.rectScreen.height - (this.imgBack.getHeight() + (this.imgBack.getHeight() >> 2));
        this.rectBack = new Rectangle(x, y, this.imgBack.getWidth(), this.imgBack.getHeight());
        this.rectSettBtns = new Rectangle[3];
        this.rectSettBtns[0] = this.rectSounds;
        this.rectSettBtns[1] = this.rectInstructionsBtn;
        this.rectSettBtns[2] = this.rectBack;
        GraphicsMem.setBG(GameData.activeCourt);
        this.initLanguages();
        this.initCursor();
        if (this.actuallScreen == 1) {
            this.initQuestionBtns();
        }
    }

    private void initNamePos() {
        this.namePosX = this.rectScreen.getCenterX();
        this.namePosY = this.rectSett.getBottom() + (this.rectSett.height >> 2) + (this.imgName.getHeight() >> 1);
    }

    private void initCoinPos() {
        this.coinPosX = (this.imgStats.getWidth() >> 2) + (this.sprCoin.getWidth() >> 1);
        this.coinPosY = (this.imgStats.getWidth() >> 2) + (this.imgSett.getHeight() >> 1);
    }

    private void initSettingsButton() {
        int x = this.rectScreen.width - (this.imgSett.getWidth() + (this.imgStats.getWidth() >> 3));
        int y = this.imgStats.getWidth() >> 3;
        if (MainCanvas.HEIGHT > 307) {
            y += this.imgStats.getWidth() >> 3;
        }
        this.rectSett = new Rectangle(x, y, this.imgSett.getWidth(), this.imgSett.getHeight());
    }

    private void paintScreenName(Graphics g) {
        switch (this.actuallScreen) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                if (this.actuallScreen == 1 && !this.isSettingsPressed) break;
                g.drawImage(this.imgSpot, this.rectScreen.getCenterX(), 0, 17);
                this.fontMain.drawString(g, this.nameOfScreen.toCharArray(), this.rectScreen.width >> 1, (this.fontMain.getHeight() << 1) - (this.fontMain.getHeight() >> 3), 33);
                break;
            }
            case 4: {
                g.drawImage(this.imgSpot, this.rectScreen.getCenterX(), (this.fontMain.getHeight() << 1) + (this.imgSpot.getHeight() >> 1), 3);
                this.fontMain.drawString(g, this.nameOfScreen.toCharArray(), this.rectScreen.width >> 1, (this.fontMain.getHeight() << 2) - (this.fontMain.getHeight() >> 3), 33);
            }
        }
    }

    private void executeAction() {
        switch (this.actuallScreen) {
            case 1: 
            case 6: {
                this.nameOfScreen = null;
                break;
            }
            case 2: {
                this.nameOfScreen = str[5];
                break;
            }
            case 3: {
                this.nameOfScreen = str[15];
                break;
            }
            case 4: {
                this.nameOfScreen = str[16];
                break;
            }
            case 5: {
                this.nameOfScreen = str[31];
            }
        }
    }

    private void initBottomButtons() {
        int x = this.offset;
        int y = this.rectScreen.height - (this.imgStats.getHeight() + this.offset);
        this.rectStats = new Rectangle(x, y, this.imgStats.getWidth(), this.imgStats.getHeight());
        x = this.rectScreen.width - (this.imgExit.getWidth() + this.offset);
        this.rectExit = new Rectangle(x, y, this.imgExit.getWidth(), this.imgExit.getHeight());
    }

    private void paintStatsButton(Graphics g) {
        g.drawImage(this.imgStats, this.rectStats.getCenterX(), this.rectStats.getCenterY(), 3);
    }

    private void initMenuButtons() {
        this.rectButtons = new Rectangle[5];
        int width = this.imgPlayMenu.getWidth();
        int height = this.imgPlayMenu.getHeight();
        int x = (MainCanvas.WIDTH >> 1) - (width >> 1);
        int y = (this.rectScreen.height >> 1) - (height >> 3);
        this.rectButtons[0] = new Rectangle(x, y, width, height);
        this.rectButtons[1] = new Rectangle(x, (y += height >> 4) + height, width, height);
        width = this.imgBall.getWidth();
        height = this.imgBall.getHeight();
        this.rectButtons[2] = new Rectangle(x, (y += (height >> 4) + height) + height, width, height);
        x = this.rectButtons[0].getRight() - width;
        this.rectButtons[3] = new Rectangle(x, y + height, width, height);
        this.rectButtons[4] = this.rectSett;
    }

    private void paintButtons(Graphics g) {
        g.drawImage(this.imgPlayMenu, this.rectButtons[0].getCenterX(), this.rectButtons[0].getCenterY(), 3);
        g.drawImage(this.imgButtonMenu, this.rectButtons[1].getCenterX(), this.rectButtons[1].getCenterY(), 3);
        g.drawImage(this.imgBall, this.rectButtons[2].getCenterX(), this.rectButtons[2].getCenterY(), 3);
        g.drawImage(this.imgCourt, this.rectButtons[3].getCenterX(), this.rectButtons[3].getCenterY(), 3);
        this.fontMain.drawString(g, (str[2] + ": " + this.modeText).toCharArray(), this.rectButtons[1].getCenterX(), this.rectButtons[1].getCenterY(), 3);
    }

    private void setMode(boolean change) {
        if (change) {
            this.modeGame = this.modeGame == 0 ? 1 : 0;
        }
        if (this.modeGame == 1) {
            this.modeData = RMSObjects.dataTimeMode;
            this.modeText = str[4];
        } else {
            this.modeData = RMSObjects.dataArcadeMode;
            this.modeText = str[3];
        }
    }

    private void paintExit(Graphics g) {
        g.drawImage(this.imgExit, this.rectExit.getCenterX(), this.rectExit.getCenterY(), 3);
    }

    private void paintBestScore(Graphics g) {
        this.fontMain.drawString(g, str[25].toCharArray(), this.rectScreen.getCenterX(), this.bestScorePosYText, 3);
        this.fontMain.drawString(g, (Variables.bestCombo + "").toCharArray(), this.rectScreen.getCenterX(), this.bestScorePosY, 3);
    }

    private void initBestScore() {
        int top = this.namePosY + (this.imgName.getHeight() >> 1) + this.fontMain.getHeight();
        int bottom = this.rectButtons[0].y;
        int height = bottom - top;
        this.bestScorePosYText = top + (height >> 3) - (this.fontMain.getHeight() >> 1);
        this.bestScorePosY = this.bestScorePosYText + this.fontMain.getHeight();
    }

    private void paintStats(Graphics g) {
        g.drawImage(this.imgUnderText, this.rectScreen.getCenterX(), this.rectScreen.getCenterY() - this.oneRowStat * 3, 3);
        this.fontMain.drawString(g, (str[6] + ": " + Variables.totalGames).toCharArray(), this.rectScreen.getCenterX(), this.rectScreen.getCenterY() - this.oneRowStat * 3, 3);
        g.drawImage(this.imgUnderText, this.rectScreen.getCenterX(), this.rectScreen.getCenterY() - (this.oneRowStat << 1), 3);
        this.fontMain.drawString(g, (str[7] + ": " + Variables.totalBaskets).toCharArray(), this.rectScreen.getCenterX(), this.rectScreen.getCenterY() - (this.oneRowStat << 1), 3);
        g.drawImage(this.imgUnderText, this.rectScreen.getCenterX(), this.rectScreen.getCenterY() - this.oneRowStat, 3);
        this.fontMain.drawString(g, (str[8] + ": " + Variables.cleanShots).toCharArray(), this.rectScreen.getCenterX(), this.rectScreen.getCenterY() - this.oneRowStat, 3);
        g.drawImage(this.imgUnderText, this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
        this.fontMain.drawString(g, (str[10] + ": " + Variables.ofTheBoard).toCharArray(), this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
        g.drawImage(this.imgUnderText, this.rectScreen.getCenterX(), this.rectScreen.getCenterY() + this.oneRowStat, 3);
        this.fontMain.drawString(g, (str[9] + ": " + Variables.highShots).toCharArray(), this.rectScreen.getCenterX(), this.rectScreen.getCenterY() + this.oneRowStat, 3);
        g.drawImage(this.imgUnderText, this.rectScreen.getCenterX(), this.rectScreen.getCenterY() + (this.oneRowStat << 1), 3);
        this.fontMain.drawString(g, (str[11] + ": " + Variables.buzzerBeaters).toCharArray(), this.rectScreen.getCenterX(), this.rectScreen.getCenterY() + (this.oneRowStat << 1), 3);
        g.drawImage(this.imgUnderText, this.rectScreen.getCenterX(), this.rectScreen.getCenterY() + this.oneRowStat * 3, 3);
        this.fontMain.drawString(g, (str[13] + ": " + Variables.bestCombo).toCharArray(), this.rectScreen.getCenterX(), this.rectScreen.getCenterY() + this.oneRowStat * 3, 3);
    }

    private void firstGame() {
        Variables.totalGames = 0;
        Variables.totalBaskets = 0;
        Variables.cleanShots = 0;
        Variables.ofTheBoard = 0;
        Variables.highShots = 0;
        Variables.buzzerBeaters = 0;
        Variables.bestCombo = 0;
        GameData.coins = 0;
        GameData.isNotfirstGame = true;
    }

    private void initStatYPos() {
        int top = this.rectScreen.height >> 3;
        int bottom = this.rectScreen.height - (this.rectScreen.height >> 3);
        int height = bottom - top;
        this.oneRowStat = height >> 1 >> 2;
    }

    private void paintNumberItems(Graphics g, int selected, int max) {
        int y = this.imgSpot.getHeight() + (this.fontMain.getHeight() << 1);
        g.drawImage(this.imgUnderText, this.rectScreen.getCenterX(), y, 3);
        this.fontMain.drawString(g, (selected + " / " + max).toCharArray(), MainCanvas.WIDTH >> 1, y, 3);
    }

    private void paintScroll(Graphics g, Rectangle[] rect, int activeItem, boolean isBalls) {
        g.setClip(this.rectScroll.x, this.rectScroll.y, this.rectScroll.width, this.rectScroll.height);
        this.ball = isBalls ? this.sprBalls : this.sprMaps;
        for (int index = 0; index < rect.length; ++index) {
            if (isBalls) {
                if (index == GameData.selectedBall && GameData.balls[index] != 0) {
                    this.sprBalls.setTransform(this.rotateBall);
                    this.sprBallsRotated.setTransform(this.rotateBall);
                    Sprite spr = null;
                    spr = this.isFirstSprite ? this.sprBalls : this.sprBallsRotated;
                    int frame = 0;
                    if (Math.abs(this.ballBody.velocityFX().yFX) != 0) {
                        frame = Math.abs(this.maxVelocity) / Math.abs(this.ballBody.velocityFX().yFX) - 1;
                    }
                    if (frame > 2) {
                        frame = 2;
                    }
                    if (this.world != null) {
                        this.paintSprite(rect[index].x, this.earthBody.positionFX().yAsInt() - (MainCanvas.HEIGHT >> 5) - (this.sprShadowBall.getHeight() >> 2), this.sprShadowBall, g, frame);
                        this.paintSprite(this.ballBody.positionFX().xAsInt() - (this.sprBalls.getWidth() >> 1), this.ballBody.positionFX().yAsInt() - (this.sprBalls.getHeight() >> 1), spr, g, index);
                    } else {
                        this.paintSprite(rect[index].x, rect[index].y, this.sprBallsRotated, g, index);
                    }
                } else {
                    this.paintSprite(rect[index].x, rect[index].getBottom() - (this.sprShadowBall.getHeight() >> 1), this.sprShadowBall, g, 0);
                    this.sprBalls.setTransform(0);
                    this.sprBallsRotated.setTransform(0);
                    this.ball = this.sprBalls;
                    this.paintSprite(rect[index].x, rect[index].y, this.ball, g, index);
                }
                if (GameData.balls[index] != 0) continue;
                g.drawImage(this.imgLockBall, rect[index].getCenterX(), rect[index].getCenterY(), 3);
                g.drawImage(this.imgLock, rect[index].getCenterX(), rect[index].getCenterY(), 3);
                continue;
            }
            this.paintSprite(rect[index].x, rect[index].y, this.sprMaps, g, index);
            if (GameData.courts[index] != 0) continue;
            g.drawImage(this.imgShadowCourt, rect[index].getCenterX(), rect[index].getCenterY(), 3);
            g.drawImage(this.imgLock, rect[index].getCenterX(), rect[index].getCenterY(), 3);
        }
        g.setClip(0, 0, this.rectScreen.width, this.rectScreen.height);
        Rectangle[] rects = null;
        rects = isBalls ? this.rectBalls : this.rectCourts;
        this.initArrows(isBalls);
        if (this.scrolling > 0) {
            if (rects[0].x < this.rectScroll.getCenterX() - rects[0].width) {
                this.sprArrowInactive.setTransform(2);
                this.paintSprite(this.rectLeftArrow.x, this.rectLeftArrow.y, this.sprArrowInactive, g, -1);
            }
            this.sprArrow.setTransform(0);
            this.paintSprite(this.rectRightArrow.x, this.rectRightArrow.y, this.sprArrow, g, -1);
        } else if (this.scrolling < 0) {
            this.sprArrow.setTransform(2);
            this.paintSprite(this.rectLeftArrow.x, this.rectLeftArrow.y, this.sprArrow, g, -1);
            if (rects[rects.length - 1].getRight() > this.rectScroll.getCenterX() + rects[0].width) {
                this.sprArrowInactive.setTransform(0);
                this.paintSprite(this.rectRightArrow.x, this.rectRightArrow.y, this.sprArrowInactive, g, -1);
            }
        } else {
            if (rects[0].x < this.rectScroll.getCenterX() - rects[0].width) {
                this.sprArrow.setTransform(2);
                this.paintSprite(this.rectLeftArrow.x, this.rectLeftArrow.y, this.sprArrow, g, -1);
            }
            if (rects[rects.length - 1].getRight() > this.rectScroll.getCenterX() + rects[0].width) {
                this.sprArrow.setTransform(0);
                this.paintSprite(this.rectRightArrow.x, this.rectRightArrow.y, this.sprArrow, g, -1);
            }
        }
    }

    private void paintShopAndCourtsButtons(Graphics g) {
        g.setColor(255, 255, 255);
        g.drawImage(this.imgLeftBtn, this.rectSelectBtn.getCenterX(), this.rectSelectBtn.getCenterY(), 3);
        g.drawImage(this.imgBackShort, this.rectBackBtn.getCenterX(), this.rectBackBtn.getCenterY(), 3);
        if (this.txt != null) {
            this.fontMain.drawString(g, this.txt.toCharArray(), this.rectSelectBtn.getCenterX() - (this.rectSelectBtn.width >> 2) + (this.fontMain.getHeight() >> 1), this.rectSelectBtn.getCenterY(), 3);
            this.paintSprite(this.rectSelectBtn.getCenterX() + (this.rectSelectBtn.width >> 2) - (this.sprCoin.getWidth() >> 1), this.rectSelectBtn.getCenterY() - (this.sprCoin.getHeight() >> 1), this.sprCoin, g, 0);
        }
    }

    private void initShopOrCourtButtons() {
        int x = this.offset;
        int y = this.rectScreen.height - this.imgPlayRed.getHeight() - this.offset;
        this.rectSelectBtn = new Rectangle(x, y, this.imgPlayRed.getWidth(), this.imgPlayRed.getHeight());
        x = this.rectScreen.getRight() - this.offset - this.imgPlayRed.getWidth();
        this.rectBackBtn = new Rectangle(x, y, this.imgBackShort.getWidth(), this.imgBackShort.getHeight());
    }

    private void initRectScroll() {
        int width = this.rectScreen.width - (this.sprArrow.getWidth() << 2);
        int height = (MainCanvas.HEIGHT >> 1) - (MainCanvas.HEIGHT >> 3);
        this.rectScroll = new Rectangle(this.rectScreen.getCenterX() - (width >> 1), (this.rectScreen.height >> 1) - (height >> 1), width, height);
    }

    private void createRectItems(boolean isBalls, Rectangle[] rect) {
        int width = this.sprBalls.getWidth();
        int height = this.sprBalls.getHeight();
        this.yBallPos = this.rectScroll.getCenterY() + (width >> 1);
        int size = this.balls.size();
        int distBetweenItems = (width << 1) + (width >> 1);
        int y = this.yBallPos;
        int xStartPosition = (this.rectScreen.width >> 1) - GameData.activeBall * distBetweenItems;
        if (!isBalls) {
            width = this.sprMaps.getWidth();
            height = this.sprMaps.getHeight();
            distBetweenItems = width + (width >> 3);
            xStartPosition = (this.rectScreen.width >> 1) - GameData.activeCourt * distBetweenItems;
            size = this.courts.size();
            y = this.yCourtPos = this.rectScroll.getCenterY() - (width >> 1);
        }
        for (int index = 0; index < size; ++index) {
            int x = xStartPosition + index * distBetweenItems;
            rect[index] = new Rectangle(x, y, width, height);
        }
    }

    private void updateScroll(int number, Rectangle[] rect) {
        int min = this.rectScreen.getCenterX();
        int max = this.rectScreen.getCenterX();
        if (rect[0].x > min || rect[rect.length - 1].getRight() < max) {
            return;
        }
        for (int index = 0; index < rect.length; ++index) {
            rect[index].x += number;
        }
    }

    private void automaticChangePosItems(Rectangle[] rects, boolean isBalls) {
        int index;
        int minDistance = this.rectScreen.width;
        int translatePos = 0;
        for (index = 0; index < rects.length; ++index) {
            int posRect = rects[index].getCenterX();
            int dist = this.rectScreen.getCenterX() - posRect;
            int distance = Math.abs(dist);
            if (distance >= minDistance) continue;
            minDistance = distance;
            translatePos = dist;
            if (isBalls) {
                GameData.selectedBall = index;
                continue;
            }
            GameData.selectedCourt = index;
        }
        for (index = 0; index < rects.length; ++index) {
            rects[index].x += translatePos;
        }
        if (isBalls) {
            this.updateButtons(this.rectBalls, GameData.selectedBall, GameData.activeBall);
        } else {
            this.updateButtons(this.rectCourts, GameData.selectedCourt, GameData.activeCourt);
        }
    }

    private void resetItems(Rectangle[] rect, int y) {
        for (int index = 0; index < rect.length; ++index) {
            rect[index].y = y;
        }
    }

    private void paintSprite(int x, int y, Sprite spr, Graphics g, int frame) {
        spr.setPosition(x, y);
        if (frame == -1) {
            spr.setFrame(0);
        } else {
            spr.setFrame(frame);
        }
        spr.paint(g);
    }

    private void buyBall(int index) {
        Ball ball = (Ball)this.balls.elementAt(index);
        if (GameData.coins > ball.getPrice()) {
            GameData.coins -= ball.getPrice();
            GameData.balls[index] = 1;
            GameData.save();
            System.out.println("Ball was bought");
        } else {
            System.out.println("Coin is not enough");
        }
        this.resetWorld();
    }

    private void buyCourt(int index) {
        Court court = (Court)this.courts.elementAt(index);
        if (GameData.coins > court.getPrice()) {
            GameData.coins -= court.getPrice();
            GameData.courts[index] = 1;
            GameData.save();
            System.out.println("Court was bought");
        } else {
            System.out.println("Coin is not enough");
        }
    }

    private void ballButtonAction() {
        if (GameData.balls[GameData.selectedBall] == 0 && ((Ball)this.balls.elementAt(GameData.selectedBall)).getPrice() < GameData.coins) {
            this.buyBall(GameData.selectedBall);
        } else if (GameData.activeBall == GameData.selectedBall) {
            this.action = 1;
            this.confirmAction();
        } else if (GameData.balls[GameData.selectedBall] == 1) {
            GameData.activeBall = GameData.selectedBall;
            GameData.save();
        }
        this.updateButtons(this.rectBalls, GameData.selectedBall, GameData.activeBall);
    }

    private void courtButtonAction() {
        if (GameData.courts[GameData.selectedCourt] == 0) {
            if (((Court)this.courts.elementAt(GameData.selectedCourt)).getPrice() < GameData.coins) {
                this.buyCourt(GameData.selectedCourt);
            }
        } else if (GameData.activeCourt == GameData.selectedCourt) {
            this.action = 1;
            this.confirmAction();
        } else if (GameData.courts[GameData.selectedCourt] == 1) {
            GameData.activeCourt = GameData.selectedCourt;
            GameData.save();
        }
        this.updateButtons(this.rectCourts, GameData.selectedCourt, GameData.activeCourt);
    }

    private void createShopPhysics() {
        this.world = new World();
        this.world.setDampingLateralFX(4);
        this.world.setTimestepFX(250);
        this.world.setGravity(100);
        this.initBall();
        this.initEarthBox();
        this.world.addBody(this.ballBody);
        this.world.addBody(this.earthBody);
    }

    private void initBall() {
        Shape ball = Shape.createCircle(this.sprBalls.getWidth() >> 1);
        ball.setElasticity(60);
        ball.setMass(1);
        this.ballBody = new Body(this.rectBalls[GameData.selectedBall].getCenterX(), this.yBallPos + (this.sprBalls.getWidth() >> 1), ball, true);
    }

    private void initEarthBox() {
        int width = MainCanvas.WIDTH;
        int height = MainCanvas.HEIGHT >> 4;
        Shape earthBox = Shape.createRectangle(width, height);
        earthBox.setElasticity(100);
        int y = this.rectBalls[0].getBottom() + (height >> 1);
        this.earthBody = new Body(MainCanvas.WIDTH >> 1, y, earthBox, false);
    }

    public void paintWorld(Graphics g) {
        int bodyCount = this.world.getBodyCount();
        Body[] bodies = this.world.getBodies();
        g.setColor(255, 0, 0);
        for (int i = 0; i < bodyCount; ++i) {
            this.paintBody(g, bodies[i]);
        }
    }

    public void paintBody(Graphics g, Body b) {
        g.setColor(65280);
        FXVector[] positions = b.getVertices();
        if (positions.length == 1) {
            int radius = (int)ScreenMenu.findSquareRoot(b.shape().getBoundingRadiusSquare());
            g.drawArc(b.positionFX().xAsInt() - radius, b.positionFX().yAsInt() - radius, radius * 2, radius * 2, 0, 360);
        } else {
            for (int i = 0; i < positions.length - 1; ++i) {
                g.drawLine(positions[i].xAsInt(), positions[i].yAsInt(), positions[i + 1].xAsInt(), positions[i + 1].yAsInt());
            }
            g.drawLine(positions[positions.length - 1].xAsInt(), positions[positions.length - 1].yAsInt(), positions[0].xAsInt(), positions[0].yAsInt());
        }
    }

    public static double findSquareRoot(double number) {
        double g1;
        if (number <= 0.0) {
            return 0.0;
        }
        double squareRoot = number / 2.0;
        while ((g1 = squareRoot) - (squareRoot = (g1 + number / g1) / 2.0) != 0.0) {
        }
        return squareRoot;
    }

    private void giveMomentum() {
        this.ballBody.velocityFX().xFX = 0;
        this.ballBody.velocityFX().yFX = 0;
        int massBall = this.ballBody.shape().getMass();
        int gravity = this.world.getGravity().yAsInt() / 10;
        int yForce = (this.sprBalls.getHeight() >> 2) + (this.sprBalls.getHeight() >> 4);
        int forceY = yForce * massBall * gravity;
        FXVector vector = FXVector.newVector(0, -forceY);
        this.ballBody.applyMomentum(vector);
    }

    private void checkCollisionBallAndEarth() {
        if (Collision.detectCollision(this.earthBody, this.ballBody) != null) {
            this.giveMomentum();
            this.maxVelocity = this.ballBody.velocityFX().yFX;
        }
    }

    private void stopUpdateWorld() {
        this.world.removeBody(this.ballBody);
        this.world.removeBody(this.earthBody);
        this.world = null;
    }

    private void resetWorld() {
        this.timeToStartJump = 0;
        this.createShopPhysics();
    }

    private void resetPositionForBalls() {
        int diff = this.rectBalls[GameData.selectedBall].x - this.rectBalls[GameData.activeBall].x;
        for (int index = 0; index < this.rectBalls.length; ++index) {
            this.rectBalls[index].x += diff;
        }
    }

    private void paintSettButtons(Graphics g) {
        Image sound = this.isMusicOn ? this.imgSounds : this.imgSoundOff;
        g.drawImage(sound, this.rectSounds.getCenterX(), this.rectSounds.getCenterY(), 3);
        g.drawImage(this.imgInstructions, this.rectInstructionsBtn.getCenterX(), this.rectInstructionsBtn.getCenterY(), 3);
    }

    private void initSettButtons() {
        int x = this.rectScreen.getCenterX() - (this.imgSounds.getWidth() >> 1);
        int y = this.rectScreen.getCenterY();
        this.rectSounds = new Rectangle(x, y - this.imgSounds.getHeight() - (this.imgSounds.getHeight() >> 1), this.imgSounds.getWidth(), this.imgSounds.getHeight());
        this.rectInstructionsBtn = new Rectangle(x, y + (this.imgSounds.getHeight() >> 1), this.imgInstructions.getWidth(), this.imgInstructions.getHeight());
    }

    private void setBG() {
        int ID_BG = 13 + GameData.activeCourt;
        Resources.loadImages(new int[]{ID_BG});
        this.imgBg = Resources.resImgs[ID_BG];
    }

    private int getUnlockBalls() {
        int unlockBalls = 0;
        return unlockBalls;
    }

    private void paintSplash(Graphics g) {
        g.drawImage(this.imgSplash, this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
    }

    private void paintLogo(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(this.rectScreen.x, this.rectScreen.y, this.rectScreen.width, this.rectScreen.height);
        g.drawImage(this.imgLogo, this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
    }

    private void paintLanguage(Graphics g) {
        g.drawImage(this.imgWindowInstr, this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
        for (int index = 0; index < this.rectLanguages.length; ++index) {
            this.paintSprite(this.rectLanguages[index].x, this.rectLanguages[index].y, this.sprFlags, g, index);
        }
    }

    private void paintQuestion(Graphics g) {
        String question = str[26];
        if (this.actuallScreen == 6) {
            this.prepareExitQuestion.drawText(g, this.rectScreen, 3);
        } else {
            this.fontMain.drawString(g, (question + "?").toCharArray(), this.rectScreen.getCenterX(), this.rectScreen.getCenterY(), 3);
        }
        this.fontMain.drawString(g, str[23].toCharArray(), this.rectYes.x + this.sprCoin.getWidth(), this.rectYes.getBottom() - this.sprCoin.getWidth(), 36);
        this.fontMain.drawString(g, str[24].toCharArray(), this.rectNo.getRight() - this.sprCoin.getWidth(), this.rectNo.getBottom() - this.sprCoin.getWidth(), 40);
    }

    private void initLanguages() {
        this.rectLanguages = new Rectangle[6];
        int width = this.sprFlags.getWidth();
        int height = this.sprFlags.getHeight();
        int x = this.rectScreen.getCenterX() - width - (height >> 3);
        int y = this.rectScreen.getCenterY() - (height << 1) - (height >> 3);
        this.rectLanguages[0] = new Rectangle(x, y, width, height);
        this.rectLanguages[2] = new Rectangle(x, y += height + (height >> 2), width, height);
        this.rectLanguages[4] = new Rectangle(x, y += height + (height >> 2), width, height);
        x = this.rectScreen.getCenterX() + (height >> 3);
        y = this.rectScreen.getCenterY() - (height << 1) - (height >> 3);
        this.rectLanguages[1] = new Rectangle(x, y, width, height);
        this.rectLanguages[3] = new Rectangle(x, y += height + (height >> 2), width, height);
        this.rectLanguages[5] = new Rectangle(x, y += height + (height >> 2), width, height);
    }

    private void paintInstructions(Graphics g) {
        g.drawImage(this.imgWindowInstr, this.rectInstructions.getCenterX(), this.rectInstructions.getCenterY(), 3);
        g.setClip(this.rectInstrPlane.x, this.rectInstrPlane.y, this.rectInstrPlane.width, this.rectInstrPlane.height);
        this.prepareTextInstructions.drawText(g, this.rectTextInstr, 17);
        String txt = X.singleton.getAppProperty("MIDlet-Name").toUpperCase();
        g.drawImage(this.imgLogo, this.rectScreen.getCenterX(), this.rectTextInstr.getBottom() - this.imgLogo.getHeight() - (this.imgLogo.getHeight() >> 1), 3);
        this.fontMain.drawString(g, txt.toCharArray(), this.rectScreen.width >> 1, this.rectTextInstr.getBottom() - (this.imgLogo.getHeight() >> 1) - this.fontMain.getHeight(), 17);
        txt = Resources.resTexts[0].getHashedString(33) + " " + X.singleton.getAppProperty("MIDlet-Version").toUpperCase();
        this.fontMain.drawString(g, txt.toCharArray(), this.rectScreen.width >> 1, this.rectTextInstr.getBottom() - (this.imgLogo.getHeight() >> 1), 17);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        if (this.KEYBOARD_VALUE < 0) {
            if (this.rectInstrPlane.y > this.rectTextInstr.y) {
                this.sprArrowInactive.setTransform(6);
                this.paintSprite(this.rectUpArrow.x, this.rectUpArrow.y, this.sprArrowInactive, g, -1);
            }
            this.sprArrow.setTransform(5);
            this.paintSprite(this.rectDownArrow.x, this.rectDownArrow.y, this.sprArrow, g, -1);
        } else if (this.KEYBOARD_VALUE > 0) {
            this.sprArrow.setTransform(6);
            this.paintSprite(this.rectUpArrow.x, this.rectUpArrow.y, this.sprArrow, g, -1);
            if (this.rectInstrPlane.getBottom() < this.rectTextInstr.getBottom()) {
                this.sprArrowInactive.setTransform(5);
                this.paintSprite(this.rectDownArrow.x, this.rectDownArrow.y, this.sprArrowInactive, g, -1);
            }
        } else {
            if (this.rectInstrPlane.y > this.rectTextInstr.y) {
                this.sprArrow.setTransform(6);
                this.paintSprite(this.rectUpArrow.x, this.rectUpArrow.y, this.sprArrow, g, -1);
            }
            if (this.rectInstrPlane.getBottom() < this.rectTextInstr.getBottom()) {
                this.sprArrow.setTransform(5);
                this.paintSprite(this.rectDownArrow.x, this.rectDownArrow.y, this.sprArrow, g, -1);
            }
        }
    }

    private void updateInstructions(int yDiff) {
        this.rectTextInstr.y += -yDiff;
        if (this.rectTextInstr.y > this.rectInstrPlane.y) {
            this.rectTextInstr.y = this.rectInstrPlane.y;
        } else if (this.rectTextInstr.getBottom() < this.rectInstrPlane.getBottom()) {
            this.rectTextInstr.y = this.rectInstrPlane.getBottom() - this.rectTextInstr.height;
        }
    }

    private void initInstructions() {
        int logoMini = (this.imgLogo.getHeight() << 1) + (this.imgLogo.getHeight() >> 1);
        int width = this.imgWindowInstr.getWidth() - (this.imgWindowInstr.getWidth() >> 2);
        int height = this.imgWindowInstr.getHeight() - (this.imgWindowInstr.getHeight() >> 2);
        int x = this.rectScreen.getCenterX() - (width >> 1);
        int y = this.rectScreen.getCenterY() - (height >> 1);
        this.rectInstructions = new Rectangle(x, y, width, height);
        this.rectInstrPlane = new Rectangle(x, y - (this.imgWindowInstr.getHeight() >> 4) + (this.sprArrow.getWidth() >> 1), width, height - this.sprArrow.getWidth() - (this.sprArrow.getWidth() >> 1));
        String instructionsText = str[28];
        instructionsText = instructionsText + "\n\n" + str[29];
        this.prepareTextInstructions = new PreparedText(this.fontMain);
        this.prepareTextInstructions.prepareText(instructionsText, this.rectInstrPlane.width);
        this.rectTextInstr = new Rectangle(this.rectInstrPlane.x, this.rectInstrPlane.y, this.rectInstrPlane.width, this.prepareTextInstructions.getTextHeight() + logoMini);
        x = this.rectScreen.getCenterX() - (this.sprArrow.getHeight() >> 1);
        int y1 = this.rectInstrPlane.y - this.sprArrow.getWidth() - (this.sprArrow.getWidth() >> 2);
        int y2 = this.rectInstrPlane.getBottom() + (this.sprArrow.getWidth() >> 2);
        this.rectUpArrow = new Rectangle(x, y1, this.sprArrow.getHeight(), this.sprArrow.getWidth());
        this.rectDownArrow = new Rectangle(x, y2, this.sprArrow.getHeight(), this.sprArrow.getWidth());
    }

    private void initTexts() {
        Resources.loadText(0);
        ResourceBundle bundle = Resources.resTexts[0];
        ScreenMenu.str[0] = "ZERO";
        for (int index = 1; index < str.length; ++index) {
            ScreenMenu.str[index] = bundle.getHashedString(index);
        }
    }

    private void paintBackButton(Graphics g) {
        g.drawImage(this.imgBack, this.rectBack.getCenterX(), this.rectBack.getCenterY(), 3);
    }

    private void confirmAction() {
        switch (this.action) {
            case 0: {
                this.subScreen = 2;
                Resources.initLangDirs(langCodes[this.selectedLang]);
                this.initTexts();
                this.initQuestionBtns();
                this.setMode(false);
                break;
            }
            case 1: {
                ++Variables.totalGames;
                Variables.save(this.modeGame, this.modeData);
                this.mainCanvas.changeLastActiveScreen(new ScreenGame(this.mainCanvas, this.modeGame, this.modeData));
                this.mainCanvas.repaint();
                break;
            }
            case 2: {
                this.actuallScreen = 3;
                this.executeAction();
                this.automaticChangePosItems(this.rectBalls, true);
                this.initShopOrCourtButtons();
                this.createShopPhysics();
                this.timeToStartJump = 0;
                break;
            }
            case 3: {
                this.actuallScreen = 4;
                this.executeAction();
                this.automaticChangePosItems(this.rectCourts, false);
                this.initShopOrCourtButtons();
                break;
            }
            case 4: {
                this.actuallScreen = 2;
                this.executeAction();
                Variables.load(this.modeGame, this.modeData);
                this.changeCursorPos(this.rectBack.getCenterX(), this.rectBack.getCenterY());
                break;
            }
            case 6: {
                this.isMusicOn = !this.isMusicOn;
                this.changeSound();
                GameData.isMusicOn = this.isMusicOn;
                GameData.save();
                break;
            }
            case 5: {
                X.quitApp();
                break;
            }
            case 7: {
                this.isMusicOn = true;
                this.changeSound();
                this.subScreen = 3;
                this.introTimer = 0L;
                break;
            }
            case 8: {
                this.isMusicOn = false;
                this.changeSound();
                this.subScreen = 3;
                this.introTimer = 0L;
            }
        }
    }

    private void saveGame() {
        Variables.save(this.modeGame, this.modeData);
        GameData.save();
    }

    public void soundOn() {
        MainCanvas.soundManager.SetSoundOn(true);
        MainCanvas.soundManager.SetMusicOn(true);
        MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
    }

    public void soundOff() {
        MainCanvas.soundManager.Stop();
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.SetMusicOn(false);
    }

    private void changeSound() {
        if (this.isMusicOn) {
            this.soundOn();
        } else {
            this.soundOff();
        }
        this.iSoundProbTimer = 50;
        this.bInterrupted = false;
        GameData.isMusicOn = this.isMusicOn;
        GameData.save();
    }

    private void initCursor() {
        int width = this.imgCursor.getWidth();
        int height = this.imgCursor.getHeight();
        int x = this.rectLanguages[0].getCenterX() - (width >> 1);
        int y = this.rectLanguages[0].getCenterY() - (height >> 1);
        this.rectCursor = new Rectangle(x, y, width, height);
        if (this.actuallScreen == 1) {
            this.changeCursorPos(this.rectButtons[0].getCenterX(), this.rectButtons[0].getCenterY());
        }
    }

    private void paintCursor(Graphics g) {
        switch (this.actuallScreen) {
            case 0: {
                switch (this.subScreen) {
                    case 1: {
                        g.drawImage(this.imgCursor, this.rectCursor.getCenterX() + (this.rectCursor.width >> 1), this.rectCursor.getCenterY() + (this.rectCursor.height >> 1), 3);
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                g.drawImage(this.imgCursor, this.rectCursor.getCenterX() + (this.rectCursor.width >> 1), this.rectCursor.getCenterY() + (this.rectCursor.height >> 1), 3);
            }
        }
    }

    private void changeCursorPos(int x, int y) {
        this.rectCursor.x = x - (this.rectCursor.width >> 1);
        this.rectCursor.y = y - (this.rectCursor.height >> 1);
    }

    private void updateButtons(Rectangle[] rect, int selectedItem, int activeItem) {
        if (this.actuallScreen == 3) {
            if (rect[selectedItem].x == rect[activeItem].x) {
                this.txt = null;
                this.imgLeftBtn = this.imgPlayRed;
            } else if (GameData.balls[GameData.selectedBall] == 0) {
                this.txt = ((Ball)this.balls.elementAt(GameData.selectedBall)).getPrice() + "";
                this.imgLeftBtn = this.imgRed;
            } else {
                this.txt = null;
                this.imgLeftBtn = this.imgFineRed;
            }
        } else if (this.actuallScreen == 4) {
            if (rect[selectedItem].x == rect[activeItem].x) {
                this.txt = null;
                this.imgLeftBtn = this.imgPlayRed;
            } else if (GameData.courts[GameData.selectedCourt] == 0) {
                this.txt = ((Court)this.courts.elementAt(GameData.selectedCourt)).getPrice() + "";
                this.imgLeftBtn = this.imgRed;
            } else {
                this.txt = null;
                this.imgLeftBtn = this.imgFineRed;
            }
        }
    }

    private void initQuestionBtns() {
        int width = MainCanvas.WIDTH >> 1;
        int height = MainCanvas.HEIGHT >> 1;
        this.rectYes = new Rectangle(0, height, width, height);
        this.rectNo = new Rectangle(width, height, width, height);
        this.prepareExitQuestion = new PreparedText(this.fontMain);
        this.prepareExitQuestion.prepareText(str[32], this.rectScreen.width >> 1);
    }

    private void initArrows(boolean isBalls) {
        int x1 = this.sprArrow.getWidth() >> 1;
        int x2 = MainCanvas.WIDTH - (this.sprArrow.getWidth() >> 1) - this.sprArrow.getWidth();
        int y = this.rectScroll.getCenterY() - (this.sprArrow.getHeight() >> 1) - (this.rectScroll.height >> 2);
        this.rectLeftArrow = new Rectangle(x1, y, this.sprArrow.getWidth(), this.sprArrow.getHeight());
        this.rectRightArrow = new Rectangle(x2, y, this.sprArrow.getWidth(), this.sprArrow.getHeight());
        if (!isBalls) {
            this.rectLeftArrow.y = this.rectRightArrow.y = this.rectCourts[0].getCenterY() - (this.sprArrow.getHeight() >> 1);
        }
    }
}

