/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Hero {
    private MyCanvas canvas;
    public int xPosition;
    public int yPosition;
    public int width;
    public int height;
    public byte dir = 1;
    public byte frame;
    public byte bowPos = 1;
    private byte heroOffY;
    public byte frameCtr;
    public byte framePtr;
    public byte xVel;
    public byte yVel;
    public int jumpCtr;
    public int jumpLimit;
    public boolean JumpHtReached;
    public byte actionFrmPtr = 0;
    public boolean isHit = false;
    private byte hitCounter = 0;
    public boolean receiveKeypressed = false;
    public boolean swordLock = false;
    public byte weapon = 0;
    public boolean fireArrow;
    private byte waitCtr;
    public boolean isDead;
    private boolean isEnd;
    public byte action = 0;
    public static final byte STAND = 0;
    public static final byte RUN = 1;
    public static final byte JUMP = 2;
    public static final byte EDGE_HANG = 3;
    public static final byte EDGE_CLIMB = 4;
    public static final byte DIE = 5;
    public static final byte FALL = 6;
    public static final byte POWERUP_BREAK = 7;
    public static final byte SLIDE = 9;
    public static final byte SWORD_1 = 10;
    public static final byte SLIDE_DUCK = 13;
    public static final byte TOP_EDGE_CLIMB = 16;
    public static final byte TOP_EDGE_GETDOWN = 17;
    public static final byte ROPE_HANG = 26;
    public byte imageNo;
    private byte imageRotation;
    public static Image[] image;
    public short[] heroClipping = new short[]{0, 0, 30, 63, 31, 1, 30, 62, 61, 8, 41, 55, 102, 7, 29, 56, 131, 3, 32, 60, 163, 8, 44, 55, 207, 7, 41, 56, 248, 12, 31, 51, 279, 5, 34, 58, 313, 11, 44, 52, 0, 8, 44, 59, 44, 0, 29, 67, 0, 0, 25, 65, 25, 0, 27, 46, 52, 0, 30, 45, 82, 0, 31, 34, 0, 0, 45, 57, 45, 0, 54, 57, 99, 19, 54, 38, 153, 37, 67, 20, 0, 0, 41, 59, 42, 0, 38, 59, 80, 0, 50, 59, 0, 0, 23, 75, 23, 0, 30, 63, 54, 0, 27, 54};
    private byte[] heroPlacingRt = new byte[]{0, 0, 0, 1, -2, 5, 2, 4, 2, 3, -4, 6, -2, 5, 2, 6, 2, 5, -3, 6, 0, 0, 0, 0, 8, 0, 19, 7, -8, -19, 0, -29, -8, 4, -27, 10, -42, 26, -55, 42, -5, 5, -2, 4, -2, 4, 0, 0, -3, 5, -3, 11};
    private byte[] heroPlacingLf = new byte[]{0, 0, 0, 1, -9, 5, -1, 4, -4, 3, -10, 6, -9, 5, -3, 6, -6, 5, -11, 6, 0, 0, 0, 0, -12, 0, -19, 7, -8, -19, 0, -29, -7, 4, 3, 10, 19, 26, 17, 42, -5, 5, 1, 4, -8, 4, 0, 0, -3, 5, -3, 11};
    private byte[] framePos = new byte[]{0, 2, 10, 12, 16, 20, 23};

    public Hero(int xPosition, int yPosition, int width, int height, int direction, boolean hidden, MyCanvas canvas) {
        this.canvas = canvas;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.width = width;
        this.height = height;
        this.dir = (byte)direction;
    }

    public static void initResources() {
        try {
            image = new Image[7];
            Hero.image[0] = Image.createImage((String)"/h_st_run.png");
            Hero.image[5] = Image.createImage((String)"/h_die.png");
            Hero.image[1] = Image.createImage((String)"/h_jump.png");
            Hero.image[3] = Image.createImage((String)"/h_eg_hang.png");
            Hero.image[4] = Image.createImage((String)"/h_sword.png");
            Hero.image[6] = Image.createImage((String)"/h_ropeMove.png");
        }
        catch (Exception e) {
            System.out.println("Error in Hero Image Creation :" + e.toString());
        }
    }

    void updateHero() {
        try {
            switch (this.action) {
                case 0: {
                    Enemy.isJump = false;
                    if (MyCanvas.haveKeyPressed(4) || MyCanvas.haveKeyHold(4)) {
                        this.action = 1;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyPressed(64) || MyCanvas.haveKeyHold(64)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                    }
                    if (MyCanvas.haveKeyPressed(1)) {
                        if (MyCanvas.isReadyToClimbOnRope && !MyCanvas.isReadyToGetDown) {
                            this.xPosition = this.canvas.ladderOffX;
                            this.action = (byte)26;
                            this.frame = 0;
                            break;
                        }
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 3;
                        this.jumpCtr = 0;
                        this.xVel = (byte)(24 >> 1);
                        this.JumpHtReached = false;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(256)) {
                        this.action = (byte)10;
                        this.frame = (byte)-1;
                        this.frameCtr = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(128)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 3;
                        this.jumpCtr = 0;
                        this.JumpHtReached = false;
                        this.dir = (byte)-1;
                        this.xVel = (byte)((24 >> 1) + (24 >> 2));
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(2)) break;
                    this.action = (byte)2;
                    this.frame = (byte)-1;
                    this.jumpLimit = 3;
                    this.jumpCtr = 0;
                    this.JumpHtReached = false;
                    this.dir = 1;
                    this.xVel = (byte)((24 >> 1) + (24 >> 2));
                    break;
                }
                case 1: {
                    if (MyCanvas.haveKeyReleased(4) || MyCanvas.haveKeyReleased(64)) {
                        this.action = 0;
                        this.frame = 0;
                        this.frameCtr = 0;
                    }
                    if (MyCanvas.haveKeyHold(4)) {
                        this.action = 1;
                        this.dir = 1;
                    } else if (MyCanvas.haveKeyHold(64)) {
                        this.action = 1;
                        this.dir = (byte)-1;
                    } else if (MyCanvas.haveKeyPressed(256)) {
                        this.action = (byte)10;
                        this.frame = (byte)-1;
                        this.frameCtr = 0;
                    }
                    if (!MyCanvas.haveKeyPressed(1)) break;
                    this.action = (byte)2;
                    this.frame = (byte)-1;
                    this.jumpLimit = 3;
                    this.jumpCtr = 0;
                    this.JumpHtReached = false;
                    this.xVel = (byte)(24 >> 1);
                    break;
                }
                case 2: {
                    if (!MyCanvas.haveKeyHold(1) || this.jumpLimit >= 3) break;
                    ++this.jumpLimit;
                    break;
                }
                case 9: {
                    if (MyCanvas.haveKeyPressed(1)) {
                        this.action = (byte)2;
                        this.frame = (byte)-1;
                        this.jumpLimit = 1;
                        this.jumpCtr = 0;
                        this.xVel = (byte)(24 >> 1);
                        this.JumpHtReached = false;
                        break;
                    }
                    if (!MyCanvas.haveKeyPressed(16)) break;
                    this.action = (byte)13;
                    break;
                }
                case 13: {
                    if (!MyCanvas.haveKeyReleased(16) && !MyCanvas.haveKeyPressed(1)) break;
                    this.action = (byte)9;
                    break;
                }
                case 3: {
                    if (MyCanvas.haveKeyPressed(1)) {
                        if (MyCanvas.isReadyToClimb) {
                            this.action = (byte)16;
                            this.xPosition = this.canvas.edgeOffX;
                            this.yPosition = this.canvas.edgeOffY;
                            break;
                        }
                        this.action = (byte)4;
                        this.frame = 0;
                        break;
                    }
                    if (MyCanvas.haveKeyPressed(16)) {
                        this.action = (byte)6;
                        this.yPosition += 24 >> 2;
                        break;
                    }
                    if (this.dir > 0 && (MyCanvas.haveKeyPressed(64) || MyCanvas.haveKeyPressed(128))) {
                        this.action = (byte)2;
                        this.dir = (byte)-1;
                        this.frame = (byte)-1;
                        this.jumpLimit = 2;
                        this.jumpCtr = 0;
                        this.xVel = (byte)(24 >> 1);
                        this.JumpHtReached = false;
                        break;
                    }
                    if (this.dir >= 0 || !MyCanvas.haveKeyPressed(4) && !MyCanvas.haveKeyPressed(2)) break;
                    this.action = (byte)2;
                    this.dir = 1;
                    this.frame = (byte)-1;
                    this.jumpLimit = 2;
                    this.jumpCtr = 0;
                    this.xVel = (byte)(24 >> 1);
                    this.JumpHtReached = false;
                    break;
                }
                case 26: {
                    if (MyCanvas.haveKeyHold(1)) {
                        this.canvas.moveCamToY -= 6;
                        this.yPosition -= 3;
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        if (this.frameCtr > 2) {
                            this.frame = (byte)(this.frame + 1);
                            this.frameCtr = 0;
                        }
                        if (this.frame > 2) {
                            this.frame = 0;
                        }
                    }
                    if (!MyCanvas.haveKeyReleased(1)) break;
                    this.frame = 0;
                    break;
                }
                case 6: {
                    this.xVel = 0;
                    if (MyCanvas.haveKeyHold(4) || MyCanvas.haveKeyHold(2)) {
                        if (MyCanvas.isReadyToClimb) {
                            this.action = (byte)3;
                            this.xPosition = this.canvas.edgeOffX;
                            this.yPosition = this.canvas.edgeOffY;
                            this.frame = (byte)-1;
                        }
                        this.dir = 1;
                        this.xVel = (byte)6;
                        break;
                    }
                    if (!MyCanvas.haveKeyHold(64) && !MyCanvas.haveKeyHold(128)) break;
                    if (MyCanvas.isReadyToClimb) {
                        this.action = (byte)3;
                        this.xPosition = this.canvas.edgeOffX;
                        this.yPosition = this.canvas.edgeOffY;
                        this.frame = (byte)-1;
                    }
                    this.dir = (byte)-1;
                    this.xVel = (byte)6;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in updateHero>>" + e);
        }
    }

    void update() {
        try {
            byte by = this.canvas.currPage;
            this.canvas.getClass();
            if (by != 18) {
                this.updateHero();
            }
            if (this.dir == 1) {
                this.imageRotation = 0;
                this.canvas.HeroXposOnScr = (MyCanvas.canvasWidth >> 2) - this.width * 1;
            } else {
                this.imageRotation = (byte)2;
                this.canvas.HeroXposOnScr = MyCanvas.canvasWidth >> 2;
            }
            switch (this.action) {
                case 0: {
                    this.receiveKeypressed = true;
                    this.xVel = 0;
                    this.weapon = 0;
                    this.actionFrmPtr = 0;
                    this.frameCtr = (byte)(this.frameCtr + 1);
                    if (this.frameCtr > 3) {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    this.imageNo = 0;
                    if (this.frame > 1) {
                        this.frame = 0;
                    }
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = 1;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 1: {
                    this.actionFrmPtr = 1;
                    this.frame = (byte)(this.frame + 1);
                    this.imageNo = 0;
                    if (this.frame > 7) {
                        this.frame = 0;
                    }
                    this.xPosition += 10 * this.dir;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = 1;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 2: {
                    this.actionFrmPtr = (byte)2;
                    this.imageNo = 1;
                    this.xPosition += this.xVel * this.dir;
                    if (this.JumpHtReached) {
                        if (!MyCanvas.isGroundTouched) {
                            this.frame = 0;
                            this.action = (byte)6;
                            this.yPosition += 24 >> 2;
                            break;
                        }
                    }
                    if (this.JumpHtReached) {
                        if (MyCanvas.isGroundTouched) {
                            this.frame = 0;
                            this.action = (byte)6;
                            this.yPosition += 24 >> 2;
                            break;
                        }
                    }
                    if (this.jumpCtr >= this.jumpLimit) break;
                    this.frame = 0;
                    this.yPosition -= 24 >> 1;
                    ++this.jumpCtr;
                    if (this.jumpCtr < this.jumpLimit) break;
                    this.JumpHtReached = true;
                    break;
                }
                case 9: {
                    this.actionFrmPtr = (byte)8;
                    this.imageNo = 1;
                    this.frame = 0;
                    this.xPosition += (24 >> 2) * this.dir;
                    this.yPosition += 24 >> 3;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 13: {
                    this.actionFrmPtr = (byte)9;
                    this.imageNo = 1;
                    this.frame = 0;
                    this.xPosition += (24 >> 2) * this.dir;
                    this.yPosition += 24 >> 3;
                    if (MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = (byte)2;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 3: {
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = (byte)3;
                    break;
                }
                case 26: {
                    this.imageNo = (byte)6;
                    this.actionFrmPtr = (byte)6;
                    this.dir = 1;
                    if (MyCanvas.isReadyToClimbOnRope || MyCanvas.isGroundTouched) break;
                    this.imageNo = 1;
                    this.frame = 1;
                    this.action = (byte)6;
                    this.actionFrmPtr = (byte)2;
                    break;
                }
                case 4: {
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = (byte)3;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame != 2) break;
                    this.action = (byte)6;
                    this.yPosition -= 24 * 2;
                    break;
                }
                case 16: {
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = (byte)3;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame <= 3) break;
                    this.action = 0;
                    this.frame = 0;
                    this.actionFrmPtr = 0;
                    this.imageNo = 0;
                    this.frameCtr = 0;
                    this.yPosition -= this.height;
                    this.xPosition += 24 * this.dir;
                    break;
                }
                case 17: {
                    this.actionFrmPtr = (byte)3;
                    this.imageNo = (byte)3;
                    this.xPosition = this.canvas.edgeOffX;
                    this.yPosition = this.canvas.edgeOffY;
                    this.frame = (byte)(this.frame - 1);
                    if (this.frame >= 3) break;
                    this.action = (byte)3;
                    break;
                }
                case 5: {
                    this.imageNo = (byte)5;
                    this.actionFrmPtr = (byte)4;
                    if (this.frameCtr < 1) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                    } else {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame <= 3) break;
                    this.frame = (byte)3;
                    this.canvas.getClass();
                    this.canvas.currPage = (byte)9;
                    this.canvas.shutterY = 0;
                    this.canvas.shutterMaxY = 24 * 2;
                    break;
                }
                case 7: {
                    this.imageNo = (byte)5;
                    this.actionFrmPtr = (byte)4;
                    if (this.frameCtr < 1) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                    } else {
                        this.frame = (byte)(this.frame + 1);
                        this.frameCtr = 0;
                    }
                    if (this.frame <= 2) break;
                    this.frame = (byte)2;
                    this.action = 0;
                    this.frame = 0;
                    this.frameCtr = 0;
                    break;
                }
                case 10: {
                    this.imageNo = (byte)4;
                    this.actionFrmPtr = (byte)5;
                    this.frame = (byte)(this.frame + 1);
                    if (this.frame == 2) {
                        this.canvas.addElementArr(new Elements(this.xPosition + (this.dir > 0 ? 74 : -50), this.yPosition + 35, 3, 3, (24 * MyCanvas.cos(300) >> 9) * this.dir, -(24 * MyCanvas.sin(300) >> 9), false, 0, 0, 0, this.canvas));
                    }
                    if (this.frame <= 2) break;
                    this.action = 0;
                    this.imageNo = 0;
                    this.actionFrmPtr = 0;
                    this.frame = 0;
                    break;
                }
                case 6: {
                    if (this.isDead) {
                        this.imageNo = (byte)5;
                        this.actionFrmPtr = (byte)4;
                        this.frame = 0;
                        this.xPosition -= 24;
                        if (!MyCanvas.isGroundTouched) break;
                        this.action = (byte)5;
                        break;
                    }
                    this.actionFrmPtr = (byte)2;
                    if (MyCanvas.isGroundTouched) {
                        this.frameCtr = (byte)(this.frameCtr + 1);
                        this.JumpHtReached = false;
                        this.xVel = 0;
                        this.action = 0;
                        this.frame = 0;
                        this.actionFrmPtr = 0;
                        this.imageNo = 0;
                        this.frameCtr = 0;
                        break;
                    }
                    this.xPosition += this.xVel * this.dir;
                    this.frameCtr = 0;
                    this.actionFrmPtr = (byte)2;
                    this.imageNo = 1;
                    this.frame = 1;
                    if (!Enemy.isJump) {
                        this.yPosition += 24 >> 1;
                        break;
                    }
                    this.yPosition += 24 >> 1;
                    this.xPosition -= 24 * this.dir;
                    Enemy.isJump = false;
                }
            }
            this.framePtr = (byte)(this.framePos[this.actionFrmPtr] + this.frame);
            if (this.isHit) {
                if (this.hitCounter == 0) {
                    this.canvas.life = (byte)(this.canvas.life - 7);
                }
                this.hitCounter = (byte)(this.hitCounter + 1);
                if (this.hitCounter > 15) {
                    this.isHit = false;
                    this.hitCounter = 0;
                }
            }
        }
        catch (Exception e) {
            System.out.println("err in hero update>>" + this.action + " " + e);
        }
    }

    public void draw(Graphics g) {
        try {
            if (this.hitCounter % 2 == 0 || this.action == 5) {
                g.drawRegion(image[this.imageNo], (int)this.heroClipping[this.framePtr * 4], (int)this.heroClipping[this.framePtr * 4 + 1], (int)this.heroClipping[this.framePtr * 4 + 2], (int)this.heroClipping[this.framePtr * 4 + 3], (int)this.imageRotation, this.xPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2] : this.heroPlacingLf[this.framePtr * 2]), this.yPosition + (this.dir == 1 ? this.heroPlacingRt[this.framePtr * 2 + 1] : this.heroPlacingLf[this.framePtr * 2 + 1]), 0);
            }
        }
        catch (Exception e) {
            System.out.println("err in hero draw>>" + e + "" + this.action);
        }
    }
}

