/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.game.Game;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.ArrayAngles;
import sk.inlogic.util.Keys;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class ScreenMain
implements IScreen {
    public MainCanvas mainCanvas;
    private static final int DELAY_TIME = 3000;
    public GFont fontMain;
    private int delay;
    public static final byte TOTAL_PLANETS = 5;
    Rectangle rectTitle;
    Rectangle rectLeft;
    Rectangle rectRight;
    Rectangle rectScreen;
    Rectangle rectHeader;
    Rectangle rectQuit;
    Rectangle rectUpperRight;
    Rectangle rectSpeedUp;
    Rectangle rectSpeedDown;
    Rectangle rectLevelMenu;
    Rectangle rectPrepQuest;
    Rectangle rectMenu;
    Rectangle rectQuestGame;
    Rectangle[] rectMenuItems;
    Rectangle[] rectSettItems;
    Rectangle[] rectPauseItems;
    Rectangle rectButtons;
    Rectangle rectDownLeft;
    Rectangle rectDownRight;
    private Image imgEarth;
    Image imgPlanetEnemy;
    private Image[] imgLanguage = new Image[6];
    String sTextTitle;
    String sTextLevel;
    String[] sTextMenu = new String[4];
    String[] sTextSett = new String[3];
    String[] sTextPom = new String[3];
    String[] sTextResult = new String[3];
    PreparedText prepText;
    PreparedText prepTextQuestMenu;
    PreparedText prepTextQuestGame;
    Image imgBg;
    Image imgYesBtn;
    Image imgNoBtn;
    Image imgLogo;
    Image imgTitle;
    Image imgBackBtn;
    Image imgButton;
    Image imgFourBtn;
    Image imgSixBtn;
    Image imgEnemy;
    Image imgPlanetScore;
    Image imgSettingsBtn;
    Image imgPauseBtn;
    Image imgShield;
    Image imgUpBtn;
    Image imgDownBtn;
    boolean soundProbActive;
    Sprite sprDialog;
    Sprite sprButton;
    Sprite sprArrow;
    Sprite sprPlayer;
    private Vector quests = new Vector();
    static final Random randGenerator = new Random();
    private int screen;
    public int subScreen;
    private boolean bLoading = false;
    private boolean bAfterPause = false;
    public final byte SCREEN_INTRO;
    public final byte SCREEN_MENU;
    public final byte SCREEN_GAME = (byte)2;
    public final byte SCREEN_SETT = (byte)3;
    public static final byte GAME_LIVE = 0;
    public static final byte GAME_FIRST = 1;
    public static final byte GAME_OVER = 2;
    public static final byte GAME_PAUSE = 3;
    public static final byte GAME_INSTRUCTION = 4;
    public static final byte GAME_QUIT_TO_MENU = 5;
    public final byte INTRO_INIT_GRAPHICS;
    public final byte INTRO_INIT;
    public final byte INTRO_LOGO_INLOGIC = (byte)2;
    public final byte INTRO_LANGUAGE = (byte)3;
    public final byte INTRO_ENABLE_MUSIC = (byte)4;
    public final byte MENU_MAIN;
    public final byte MENU_PLAY;
    public final byte MENU_INSTRUCTION = (byte)2;
    public final byte MENU_ABOUT = (byte)3;
    public final byte MENU_MUSIC = (byte)4;
    public final byte MENU_QUIT = (byte)5;
    public final byte MENU_SETT = (byte)6;
    public final byte SETT_INSTRUCTIONS;
    public final byte SETT_MUSIC;
    public final byte SETT_ABOUT = (byte)2;
    public final byte SETT_BACK = (byte)3;
    final byte ID_MENU_PLAY;
    final byte ID_MENU_SETTINGS;
    final byte ID_MENU_ITEMS_TOTAL = (byte)2;
    final byte ID_SETT_INSTRUCTIONS;
    final byte ID_SETT_MUSIC;
    final byte ID_SETT_ABOUT = (byte)2;
    final byte ID_SETT_ITEMS_TOTAL = (byte)3;
    final byte ID_PAUSE_RESUME;
    final byte ID_PAUSE_INSTRUCTIONS;
    final byte ID_PAUSE_SOUND = (byte)2;
    final byte ID_PAUSE_ITEMS_TOTAL = (byte)3;
    public static int onePixel;
    public int iCircleX;
    public int iCircleY;
    public int iCircleYSecond;
    private int iInstructionsHeight;
    private int iTitleY;
    public int iResultStep = 0;
    private int iResultCounter = 0;
    private int iScoreShowed;
    private int iBlinkCounter;
    private int iAboutWidth;
    private int iAboutHeight;
    private int iResultH;
    private int iTextLines = 1;
    private int iTextShiftY = 0;
    private int iInstructionsShiftY = 0;
    private int iInstructionsMaxShiftY = 0;
    private int iInstructionsCenterY;
    private int updateCounter = 0;
    private int iShiftDirection;
    public int iShiftX;
    private int iShiftStep;
    private int iShipRadius;
    private int iSelectedMenuItem;
    private int iMenuItemsTotal;
    private int iSettItemsTotal;
    private int iSelectedSettItem;
    private int iSelectedPauseItem;
    private int iPauseItemsTotal;
    private int iPlanet;
    public static boolean[] resultSteps;
    private boolean bRecordDisplayed = true;
    boolean bDragInstructions = false;
    public static int showingCounter;
    public static boolean isShowingQuest;
    private static String[] langCodes;
    private static final int MAX_LANGUAGES = 6;
    private Rectangle[] rectLanguages = new Rectangle[6];
    private int iSelectedLanguage;
    private Game game;
    private Rectangle rectResult;
    private Rectangle[] rectResultBtns;
    public static int selectOptionResult;
    private int ResultTablePosY;
    private int updateYResult;
    private boolean isEarthquake;
    public static int resultTime;
    private int earthquakeTime;
    private int textUpResultX;
    private int textDownResultX;
    private Rectangle levelUp;
    private Rectangle levelDown;
    public boolean bIsFromPause = false;

    public ScreenMain(MainCanvas mainCanvas) {
        this.SCREEN_INTRO = 0;
        this.SCREEN_MENU = 1;
        this.INTRO_INIT_GRAPHICS = 0;
        this.INTRO_INIT = 1;
        this.MENU_MAIN = 0;
        this.MENU_PLAY = 1;
        this.SETT_INSTRUCTIONS = 0;
        this.SETT_MUSIC = 1;
        this.ID_MENU_PLAY = 0;
        this.ID_MENU_SETTINGS = 1;
        this.ID_SETT_INSTRUCTIONS = 0;
        this.ID_SETT_MUSIC = 1;
        this.ID_PAUSE_RESUME = 0;
        this.ID_PAUSE_INSTRUCTIONS = 1;
        this.mainCanvas = mainCanvas;
        this.setOnePixel();
    }

    static final int getRandomInt(int max) {
        return randGenerator.nextInt() % max;
    }

    static final int getRandomUInt(int max) {
        return Math.abs(randGenerator.nextInt() % max);
    }

    private void setOnePixel() {
        onePixel = MainCanvas.WIDTH < 240 ? 1 : (MainCanvas.WIDTH < 480 ? 2 : (MainCanvas.WIDTH < 720 ? 3 : 4));
    }

    public void setTexts() {
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 4: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(2);
                        this.setTitleCenter(this.sTextTitle);
                        this.sTextResult[2] = Resources.resTexts[0].getHashedString(5);
                        this.sTextResult[1] = Resources.resTexts[0].getHashedString(32);
                        this.sTextResult[0] = Resources.resTexts[0].getHashedString(33);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 5: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(18);
                        this.setTitleCenter(this.sTextTitle);
                        break block0;
                    }
                    case 0: {
                        this.sTextMenu[0] = Resources.resTexts[0].getHashedString(7);
                        this.sTextMenu[1] = Resources.resTexts[0].getHashedString(31);
                        break block0;
                    }
                    case 2: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(8);
                        this.bLoading = true;
                        int textMaxWidth = this.iAboutWidth - (this.iAboutWidth >> 3);
                        this.sTextPom[0] = Resources.resTexts[0].getHashedString(28) + "\n\n" + Resources.resTexts[0].getHashedString(27);
                        this.prepText = new PreparedText(this.fontMain);
                        this.prepText.prepareText(this.sTextPom[0], textMaxWidth);
                        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
                        int iTextYUp = (MainCanvas.HEIGHT >> 1) - (this.iAboutHeight >> 1) + this.sprArrow.getHeight() * 3;
                        int iTextYDown = (MainCanvas.HEIGHT >> 1) + (this.iAboutHeight >> 1) - this.sprArrow.getHeight() * 3;
                        int iTextHeight = iTextYDown - iTextYUp;
                        this.iTextShiftY = 0;
                        this.iInstructionsShiftY = 0;
                        this.iInstructionsMaxShiftY = this.prepText.getTextHeight() - iTextHeight;
                        this.bDragInstructions = false;
                        this.bLoading = false;
                        break block0;
                    }
                    case 3: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(10);
                        this.sTextPom[0] = X.singleton.getAppProperty("MIDlet-Name").toUpperCase();
                        this.sTextPom[1] = Resources.resTexts[0].getHashedString(17) + " " + X.singleton.getAppProperty("MIDlet-Version").toUpperCase();
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (this.subScreen) {
                    case 6: {
                        this.sTextSett[0] = Resources.resTexts[0].getHashedString(8);
                        this.sTextSett[1] = Resources.resTexts[0].getHashedString(9);
                        this.sTextSett[2] = Resources.resTexts[0].getHashedString(10);
                        this.sTextPom[0] = Resources.resTexts[0].getHashedString(15);
                        this.sTextPom[1] = Resources.resTexts[0].getHashedString(16);
                        break block0;
                    }
                    case 5: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(18);
                        this.setTitleCenter(this.sTextTitle);
                        break block0;
                    }
                    case 2: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(8);
                        this.bLoading = true;
                        int textMaxWidth = this.iAboutWidth - (this.iAboutWidth >> 3);
                        this.sTextPom[0] = Resources.resTexts[0].getHashedString(28) + "\n\n" + Resources.resTexts[0].getHashedString(27);
                        this.prepText = new PreparedText(this.fontMain);
                        this.prepText.prepareText(this.sTextPom[0], textMaxWidth);
                        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
                        int iTextYUp = (MainCanvas.HEIGHT >> 1) - (this.iAboutHeight >> 1) + this.sprArrow.getHeight() * 3;
                        int iTextYDown = (MainCanvas.HEIGHT >> 1) + (this.iAboutHeight >> 1) - this.sprArrow.getHeight() * 3;
                        int iTextHeight = iTextYDown - iTextYUp;
                        this.iTextShiftY = 0;
                        this.iInstructionsShiftY = 0;
                        this.iInstructionsMaxShiftY = this.prepText.getTextHeight() - iTextHeight;
                        this.bDragInstructions = false;
                        this.bLoading = false;
                        break block0;
                    }
                    case 3: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(10);
                        this.sTextPom[0] = X.singleton.getAppProperty("MIDlet-Name").toUpperCase();
                        this.sTextPom[1] = Resources.resTexts[0].getHashedString(17) + " " + X.singleton.getAppProperty("MIDlet-Version").toUpperCase();
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 1: {
                        this.sTextPom[0] = Resources.resTexts[0].getHashedString(22);
                        this.sTextPom[1] = Resources.resTexts[0].getHashedString(21);
                        this.sTextPom[2] = "SHIELD";
                        break block0;
                    }
                    case 2: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(24);
                        this.sTextMenu[0] = Resources.resTexts[0].getHashedString(23);
                        this.sTextPom[0] = Resources.resTexts[0].getHashedString(29);
                        this.sTextPom[1] = Resources.resTexts[0].getHashedString(30);
                        break block0;
                    }
                    case 5: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(14);
                        this.setTitleCenter(this.sTextTitle);
                        break block0;
                    }
                    case 3: {
                        this.sTextMenu[0] = Resources.resTexts[0].getHashedString(13);
                        this.sTextMenu[1] = Resources.resTexts[0].getHashedString(8);
                        this.sTextMenu[2] = Resources.resTexts[0].getHashedString(9);
                        this.sTextPom[0] = Resources.resTexts[0].getHashedString(15);
                        this.sTextPom[1] = Resources.resTexts[0].getHashedString(16);
                        break block0;
                    }
                    case 4: {
                        this.sTextTitle = Resources.resTexts[0].getHashedString(8);
                        this.bLoading = true;
                        int textMaxWidth = this.iAboutWidth - (this.iAboutWidth >> 3);
                        this.sTextPom[0] = Resources.resTexts[0].getHashedString(28) + "\n\n" + Resources.resTexts[0].getHashedString(27);
                        this.prepText = new PreparedText(this.fontMain);
                        this.prepText.prepareText(this.sTextPom[0], textMaxWidth);
                        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
                        int iTextYUp = (MainCanvas.HEIGHT >> 1) - (this.iAboutHeight >> 1) + this.sprArrow.getHeight() * 3;
                        int iTextYDown = (MainCanvas.HEIGHT >> 1) + (this.iAboutHeight >> 1) - this.sprArrow.getHeight() * 3;
                        int iTextHeight = iTextYDown - iTextYUp;
                        this.iTextShiftY = 0;
                        this.iInstructionsShiftY = 0;
                        this.iInstructionsMaxShiftY = this.prepText.getTextHeight() - iTextHeight;
                        this.bDragInstructions = false;
                        this.bLoading = false;
                        break block0;
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update(long lTick) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 0: {
                        this.initGraphics();
                        this.iSelectedLanguage = 0;
                        this.initTexts();
                        this.init();
                        break block0;
                    }
                    case 1: {
                        this.initIntro();
                        this.generatePlanets();
                        break block0;
                    }
                    case 2: {
                        if (this.delay > 0) {
                            this.delay = (int)((long)this.delay - lTick);
                            break block0;
                        }
                        this.nextScreen(0, 3);
                        break block0;
                    }
                    case 3: {
                        this.updateShift();
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        this.updateShift();
                        break;
                    }
                    case 2: {
                        this.updateInstructions();
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (this.subScreen) {
                    case 6: {
                        this.updateShift();
                        break;
                    }
                    case 2: {
                        this.updateInstructions();
                        break;
                    }
                }
                break;
            }
            case 2: {
                this.game.update(lTick);
                switch (this.subScreen) {
                    case 3: {
                        this.updateShift();
                        break;
                    }
                    case 4: {
                        this.updateInstructions();
                        break;
                    }
                    case 2: {
                        this.updateShift();
                        resultTime = (int)((long)resultTime + lTick);
                        if (this.isEarthquake) {
                            this.earthquakeTime = (int)((long)this.earthquakeTime - lTick);
                            if (this.earthquakeTime < 0) {
                                this.isEarthquake = false;
                                this.earthquakeTime = 500;
                                if (!resultSteps[2]) {
                                    this.textDownResultX = this.sprDialog.getWidth() << 3;
                                    ScreenMain.resultSteps[2] = true;
                                }
                            }
                        }
                        if (this.updateYResult < 5 && !resultSteps[0]) {
                            ScreenMain.resultSteps[0] = true;
                            ScreenMain.resultSteps[1] = true;
                            this.updateYResult = this.ResultTablePosY;
                            this.textUpResultX = this.sprDialog.getWidth() << 3;
                            this.earthquakeTime = 500;
                            break;
                        }
                        if (this.textUpResultX > 0 && resultSteps[1] && !resultSteps[2]) {
                            this.textUpResultX -= this.sprDialog.getWidth() >> 1;
                            if (this.textUpResultX > this.sprDialog.getWidth() >> 1) break;
                            this.earthquakeTime = 500;
                            this.isEarthquake = true;
                            break;
                        }
                        if (this.textDownResultX > 0 && resultSteps[2] && !resultSteps[3]) {
                            this.textDownResultX -= this.sprDialog.getWidth() >> 1;
                            if (this.textDownResultX > this.sprDialog.getWidth() >> 1) break;
                            this.earthquakeTime = 500;
                            this.isEarthquake = true;
                            break;
                        }
                        if (resultTime % 800 < 40 && !resultSteps[3] && resultSteps[2]) {
                            ScreenMain.resultSteps[3] = true;
                            break;
                        }
                        if (resultTime % 500 >= 40 || resultSteps[4] || !resultSteps[3]) break;
                        ScreenMain.resultSteps[4] = true;
                    }
                }
                break;
            }
        }
        if (Game.asteroidBackground == null) {
            this.game.generateAsteroidBackground();
        } else {
            this.game.updateAsteroidBackgroundScreen();
        }
        this.mainCanvas.repaint();
    }

    public void initIntro() {
        this.iSelectedLanguage = 0;
        this.iSelectedMenuItem = 0;
        this.iSelectedSettItem = 0;
        this.iMenuItemsTotal = 2;
        this.iSettItemsTotal = 3;
        this.iSelectedPauseItem = 0;
        this.iPauseItemsTotal = 3;
        int iLangItemH = this.imgLanguage[0].getHeight() + (this.imgLanguage[0].getHeight() >> 1);
        int iLangAreaH = iLangItemH * 3 - (this.imgLanguage[0].getHeight() >> 1);
        int iOffsetY = MainCanvas.HEIGHT - iLangAreaH >> 1;
        int iOffsetX = 0;
        int iCounterPositionY = 0;
        this.iShiftStep = MainCanvas.WIDTH / 80;
        if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
            this.iShiftStep = MainCanvas.HEIGHT / 160;
        }
        for (int i = 0; i < 6; ++i) {
            if (i == 3) {
                iOffsetX = this.imgLanguage[0].getWidth() + (this.imgLanguage[0].getWidth() >> 1);
                iCounterPositionY = 0;
            }
            this.rectLanguages[i] = new Rectangle((MainCanvas.WIDTH >> 1) - (this.imgLanguage[0].getWidth() >> 2) - this.imgLanguage[0].getWidth() + iOffsetX, iOffsetY + iCounterPositionY * iLangItemH, this.imgLanguage[0].getWidth(), this.imgLanguage[0].getHeight());
            ++iCounterPositionY;
        }
        this.nextScreen(0, 2);
    }

    public void initGraphics() {
        Resources.loadGFonts(new int[]{0});
        this.fontMain = Resources.resGFonts[0];
        Resources.loadImages(new int[]{23, 22, 8, 21, 19, 20, 18, 17, 9, 10, 3, 11, 0, 5, 12, 26, 24, 27, 28, 25, 29, 31, 16, 2, 30, 34});
        this.imgLogo = Resources.resImgs[0];
        this.imgBg = Resources.resImgs[11];
        this.imgEnemy = Resources.resImgs[3];
        this.imgYesBtn = Resources.resImgs[9];
        this.imgNoBtn = Resources.resImgs[10];
        this.imgBackBtn = Resources.resImgs[8];
        this.imgUpBtn = Resources.resImgs[32];
        this.imgDownBtn = Resources.resImgs[33];
        this.imgLanguage[0] = Resources.resImgs[24];
        this.imgLanguage[1] = Resources.resImgs[26];
        this.imgLanguage[2] = Resources.resImgs[25];
        this.imgLanguage[3] = Resources.resImgs[27];
        this.imgLanguage[4] = Resources.resImgs[28];
        this.imgLanguage[5] = Resources.resImgs[29];
        this.imgPlanetEnemy = Resources.resImgs[12];
        this.imgEarth = Resources.resImgs[5];
        this.imgTitle = Resources.resImgs[17];
        this.imgButton = Resources.resImgs[18];
        this.imgFourBtn = Resources.resImgs[19];
        this.imgSixBtn = Resources.resImgs[20];
        this.imgPlanetScore = Resources.resImgs[23];
        this.imgSettingsBtn = Resources.resImgs[21];
        this.imgPauseBtn = Resources.resImgs[22];
        this.imgShield = Resources.resImgs[38];
        Resources.loadSprites(new int[]{1, 0, 2, 4, 3, 6, 5});
        this.sprDialog = Resources.resSprs[0];
        this.sprButton = Resources.resSprs[2];
        this.sprArrow = Resources.resSprs[4];
        this.sprPlayer = Resources.resSprs[1];
        this.nextScreen(0, 1);
    }

    public void initTexts() {
        Resources.initLangDirs(langCodes[this.iSelectedLanguage]);
        Resources.loadText(0);
        this.quests.removeAllElements();
        this.initQuestList();
        if (this.game != null) {
            this.game.initFirst();
            this.initGame();
            int width = this.rectTitle.width;
            int height = this.rectTitle.height;
            this.initMenu(width, height);
            this.initSett(width, height);
            this.initPause(width, height);
            this.initResult(width, height);
        }
    }

    public void init() {
        System.out.println("init");
        System.gc();
        this.iScoreShowed = 0;
        this.iSelectedMenuItem = 0;
        this.iSelectedSettItem = 0;
        this.iMenuItemsTotal = 2;
        this.iSettItemsTotal = 3;
        this.iSelectedPauseItem = 0;
        this.iPauseItemsTotal = 3;
        this.initAbout();
        this.initInstructions();
        this.iTitleY = 0 + this.imgTitle.getHeight();
        this.iResultH = (MainCanvas.HEIGHT >> 1) - this.fontMain.getHeight();
        this.iShipRadius = MainCanvas.HEIGHT >> 2;
        this.iCircleX = MainCanvas.WIDTH >> 1;
        this.iCircleY = (MainCanvas.HEIGHT >> 1) - (MainCanvas.HEIGHT >> 2) + (MainCanvas.HEIGHT >> 4);
        this.iCircleYSecond = (MainCanvas.HEIGHT >> 1) + (MainCanvas.HEIGHT >> 2) - (MainCanvas.HEIGHT >> 4);
        this.rectSpeedUp = new Rectangle(MainCanvas.WIDTH - this.imgUpBtn.getWidth() - onePixel, MainCanvas.HEIGHT - this.imgUpBtn.getHeight() - onePixel, this.imgUpBtn.getWidth(), this.imgUpBtn.getHeight());
        this.rectSpeedDown = new Rectangle(0 + onePixel, MainCanvas.HEIGHT - this.imgDownBtn.getHeight() - onePixel, this.imgDownBtn.getWidth(), this.imgDownBtn.getHeight());
        this.rectRight = new Rectangle(MainCanvas.WIDTH - this.imgNoBtn.getWidth() - onePixel, MainCanvas.HEIGHT - this.imgNoBtn.getHeight() - onePixel, this.imgNoBtn.getWidth(), this.imgNoBtn.getHeight());
        this.rectLeft = new Rectangle(0 + onePixel, MainCanvas.HEIGHT - this.imgNoBtn.getHeight() - onePixel, this.imgNoBtn.getWidth(), this.imgNoBtn.getHeight());
        this.rectScreen = new Rectangle(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.rectQuit = new Rectangle(MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, (MainCanvas.WIDTH >> 1) + (MainCanvas.WIDTH >> 2), this.imgFourBtn.getHeight() << 2);
        this.rectUpperRight = new Rectangle(MainCanvas.WIDTH - this.imgNoBtn.getWidth() - onePixel, 0 + onePixel, this.imgNoBtn.getWidth(), this.imgNoBtn.getHeight());
        int menuButtonW = this.imgTitle.getWidth() + (this.sprButton.getHeight() << 1) - (this.imgTitle.getWidth() >> 2);
        int menuButtonH = this.sprButton.getHeight() << 1;
        int height = MainCanvas.HEIGHT - (this.iTitleY + this.imgTitle.getHeight() + this.imgBackBtn.getHeight());
        this.rectButtons = new Rectangle((MainCanvas.WIDTH >> 1) - (menuButtonW >> 1), this.iTitleY + this.imgTitle.getHeight(), menuButtonW, height);
        if (this.game == null) {
            this.game = new Game(this);
        }
        this.game.initFirst();
        this.initGame();
        this.initMenu(menuButtonW, menuButtonH);
        this.initSett(menuButtonW, menuButtonH);
        this.initPause(menuButtonW, menuButtonH);
        this.initResult(menuButtonW, menuButtonH);
        this.rectTitle = new Rectangle((MainCanvas.WIDTH >> 1) - (menuButtonW >> 1), menuButtonH >> 1, menuButtonW, menuButtonH);
        int siteOfRect = this.rectSpeedDown.width << 1;
        this.rectDownLeft = new Rectangle(0, this.rectScreen.height - siteOfRect, this.rectSpeedDown.width << 1, this.rectSpeedDown.height << 1);
        this.rectDownRight = new Rectangle(this.rectScreen.width - siteOfRect, this.rectScreen.height - siteOfRect, this.rectSpeedDown.width << 1, this.rectSpeedDown.height << 1);
        if (this.rectScreen.height < 500) {
            this.rectLeft = this.rectSpeedDown = this.rectDownLeft;
            this.rectRight = this.rectSpeedUp = this.rectDownRight;
        }
    }

    public void paint(Graphics g) {
        block0 : switch (this.screen) {
            case 0: {
                this.paintBg(g);
                if (this.game != null) {
                    this.game.paintAsteroidBackgroundScreen(g);
                }
                switch (this.subScreen) {
                    case 2: {
                        this.paintLogo(g);
                        break block0;
                    }
                    case 3: {
                        this.paintLanguages(g);
                        break block0;
                    }
                    case 4: {
                        this.paintEnableSounds(g);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.paintBg(g);
                this.game.paintAsteroidBackgroundScreen(g);
                switch (this.subScreen) {
                    case 0: {
                        this.paintMainMenu(g);
                        break block0;
                    }
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        this.paintInstructions(g);
                        break block0;
                    }
                    case 3: {
                        this.paintAbout(g);
                        break block0;
                    }
                    case 5: {
                        this.paintQuitMenu(g);
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                this.paintBg(g);
                this.game.paintAsteroidBackgroundScreen(g);
                switch (this.subScreen) {
                    case 6: {
                        this.paintSettMenu(g);
                        break block0;
                    }
                    case 2: {
                        this.paintInstructions(g);
                        break block0;
                    }
                    case 3: {
                        this.paintAbout(g);
                        break block0;
                    }
                    case 5: {
                        this.paintQuitMenu(g);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.paintBg(g);
                switch (this.subScreen) {
                    case 0: {
                        if (isShowingQuest) {
                            this.paintQuest(g);
                            break block0;
                        }
                        this.paintPlanets(g);
                        this.paintPauseButton(g);
                        this.game.paint(g);
                        break block0;
                    }
                    case 3: {
                        this.game.paintAsteroidBackgroundScreen(g);
                        this.paintPlanets(g);
                        this.paintPauseMenu(g);
                        break block0;
                    }
                    case 1: {
                        this.paintPlanets(g);
                        this.paintGameFirst(g);
                        break block0;
                    }
                    case 2: {
                        this.game.paintAsteroidBackgroundScreen(g);
                        if (this.game.isSuccessfuly()) {
                            this.paintCompletedGame(g);
                            break block0;
                        }
                        this.paintFailedGame(g);
                        break block0;
                    }
                    case 4: {
                        this.game.paintAsteroidBackgroundScreen(g);
                        this.paintInstructions(g);
                        break block0;
                    }
                    case 5: {
                        this.game.paintAsteroidBackgroundScreen(g);
                        this.paintPlanets(g);
                        this.paintQuitPause(g);
                    }
                }
            }
        }
    }

    public void paintBg(Graphics g) {
        if (this.imgBg != null) {
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            g.drawImage(this.imgBg, 0, 0, 20);
        }
    }

    public void paintCircles(Graphics g) {
        int i;
        g.setColor(33, 76, 128);
        g.setStrokeStyle(0);
        for (i = 0; i < 360; i += 5) {
            g.drawLine(this.iCircleX + (this.iShipRadius * ArrayAngles.cos(i) >> 8), this.iCircleY + (this.iShipRadius * ArrayAngles.sin(i) >> 8), this.iCircleX + (this.iShipRadius * ArrayAngles.cos(i + 2) >> 8), this.iCircleY + (this.iShipRadius * ArrayAngles.sin(i + 2) >> 8));
        }
        for (i = 0; i < 360; i += 5) {
            g.drawLine(this.iCircleX + (this.iShipRadius * ArrayAngles.cos(i) >> 8), this.iCircleYSecond + (this.iShipRadius * ArrayAngles.sin(i) >> 8), this.iCircleX + (this.iShipRadius * ArrayAngles.cos(i + 2) >> 8), this.iCircleYSecond + (this.iShipRadius * ArrayAngles.sin(i + 2) >> 8));
        }
    }

    public void paintLogo(Graphics g) {
        g.drawImage(this.imgLogo, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, 3);
    }

    public void paintSpeedButtons(Graphics g) {
        g.drawImage(this.imgUpBtn, this.rectSpeedUp.getCenterX(), this.rectSpeedUp.getCenterY(), 3);
        g.drawImage(this.imgDownBtn, this.rectSpeedDown.getCenterX(), this.rectSpeedDown.getCenterY(), 3);
    }

    public void paintPlanets(Graphics g) {
        g.drawImage(this.imgEarth, this.iCircleX, this.iCircleY - (this.imgEarth.getHeight() >> 2), 3);
        g.drawImage(this.imgPlanetEnemy, this.iCircleX, this.iCircleYSecond + (this.imgPlanetEnemy.getHeight() >> 2), 3);
    }

    public void paintPauseButton(Graphics g) {
        g.drawImage(this.imgPauseBtn, this.rectRight.getCenterX(), this.rectRight.getCenterY(), 3);
    }

    public void paintButtons(Graphics g) {
        g.drawImage(this.imgNoBtn, this.rectRight.getCenterX(), this.rectRight.getCenterY(), 3);
        g.drawImage(this.imgYesBtn, this.rectLeft.getCenterX(), this.rectLeft.getCenterY(), 3);
    }

    public void paintButton(Graphics g, Rectangle rect, String s, boolean bActive) {
        this.paintTable(g, this.sprDialog, rect.getCenterX(), rect.getCenterY(), rect.width, rect.height, false);
        if (bActive) {
            this.fontMain.drawString(g, s.toCharArray(), rect.getCenterX() - (this.fontMain.stringWidth(s.toCharArray()) >> 1), rect.getCenterY() - (this.fontMain.getHeight() >> 1) - 1, 20);
        } else {
            this.fontMain.drawString(g, s.toCharArray(), rect.getCenterX() - (this.fontMain.stringWidth(s.toCharArray()) >> 1), rect.getCenterY() - (this.fontMain.getHeight() >> 1) - 1, 20);
        }
    }

    public void paintEnableSounds(Graphics g) {
        this.paintButton2(g, this.rectQuit);
        this.paintButtons(g);
    }

    public void paintTitleLogo(Graphics g) {
        g.drawImage(this.imgTitle, MainCanvas.WIDTH >> 1, this.iTitleY, 3);
    }

    public void paintGameFirst(Graphics g) {
        int height = this.imgFourBtn.getHeight() << 2;
        int width = (MainCanvas.WIDTH >> 1) + (MainCanvas.WIDTH >> 2) + this.imgFourBtn.getHeight();
        int iTextWidth = (MainCanvas.WIDTH >> 1) + (this.imgFourBtn.getWidth() >> 1);
        int iBtnWidth = (MainCanvas.WIDTH >> 1) - (this.imgFourBtn.getWidth() << 1);
        int iBtnHeight = (MainCanvas.HEIGHT >> 1) - this.imgFourBtn.getHeight();
        if (Profile.level == 2) {
            height = this.imgShield.getHeight() << 1;
            width += this.imgShield.getWidth() - this.imgFourBtn.getHeight();
            iTextWidth = (MainCanvas.WIDTH >> 1) + (this.imgShield.getWidth() >> 1);
            iBtnWidth = (MainCanvas.WIDTH >> 1) - (this.imgShield.getWidth() << 1);
            iBtnHeight = (MainCanvas.HEIGHT >> 1) - (this.imgShield.getHeight() >> 1);
        } else if (Game.directMode[Profile.level]) {
            height = this.imgSixBtn.getHeight() << 1;
            iTextWidth = (MainCanvas.WIDTH >> 1) + (this.imgSixBtn.getWidth() >> 1);
            iBtnWidth = (MainCanvas.WIDTH >> 1) - (this.imgSixBtn.getWidth() << 1);
            iBtnHeight = (MainCanvas.HEIGHT >> 1) - (this.imgSixBtn.getHeight() >> 1);
        }
        this.paintTable(g, this.sprDialog, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, width, height, false);
        if (Profile.level == 2) {
            g.drawImage(this.imgShield, (MainCanvas.WIDTH >> 1) - this.imgFourBtn.getWidth() - this.imgShield.getWidth(), MainCanvas.HEIGHT >> 1, 3);
            String s3 = this.sTextPom[2];
            this.fontMain.drawString(g, s3.toCharArray(), MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, 3);
        } else if (Game.directMode[Profile.level]) {
            g.drawImage(this.imgSixBtn, (MainCanvas.WIDTH >> 1) - (this.imgSixBtn.getWidth() << 1), MainCanvas.HEIGHT >> 1, 3);
            String s3 = this.sTextPom[1];
            this.fontMain.drawString(g, s3.toCharArray(), MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, 3);
        } else {
            g.drawImage(this.imgFourBtn, iBtnWidth, iBtnHeight, 3);
            g.drawImage(this.imgSixBtn, iBtnWidth, iBtnHeight + (this.imgFourBtn.getHeight() << 1), 3);
            String s1 = this.sTextPom[0];
            String s2 = this.sTextPom[1];
            this.fontMain.drawString(g, s1.toCharArray(), iTextWidth, iBtnHeight, 3);
            this.fontMain.drawString(g, s2.toCharArray(), iTextWidth, iBtnHeight + (this.imgFourBtn.getHeight() << 1), 3);
        }
    }

    public void paintPause(Graphics g) {
        this.paintTable(g, this.sprButton, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, (MainCanvas.WIDTH >> 1) + (MainCanvas.WIDTH >> 2), this.imgFourBtn.getHeight() << 2, false);
        g.drawImage(this.imgBackBtn, this.rectRight.getCenterX(), this.rectRight.getCenterY(), 3);
    }

    public void paintGameOver(Graphics g) {
        g.drawImage(this.imgPlanetScore, 0 + this.fontMain.getHeight(), 0 + this.fontMain.getHeight(), 3);
        this.paintTable(g, this.sprDialog, MainCanvas.WIDTH >> 1, this.iResultH, this.iAboutWidth, this.fontMain.getHeight() << 3, false);
        int iScoreHeight = this.iResultH - (this.fontMain.getHeight() << 1);
        int iBestHeight = this.iResultH + this.fontMain.getHeight();
        String s1 = this.sTextTitle;
        String s2 = this.sTextPom[0];
        this.fontMain.drawString(g, s1.toCharArray(), this.iCircleX, iBestHeight, 3);
        this.fontMain.drawString(g, s2.toCharArray(), this.iCircleX, iScoreHeight, 3);
        String curScore = this.iScoreShowed + "";
        this.fontMain.drawString(g, curScore.toCharArray(), this.iCircleX, iScoreHeight + this.fontMain.getHeight(), 3);
    }

    public void paintBackButton(Graphics g) {
        g.drawImage(this.imgBackBtn, this.rectRight.getCenterX(), this.rectRight.getCenterY(), 3);
    }

    public void paintMainMenu(Graphics g) {
        this.paintBackButton(g);
        this.paintTitleLogo(g);
        this.fontMain.drawString(g, (Resources.resTexts[0].getHashedString(34) + " " + (Profile.level + 1)).toCharArray(), this.rectLevelMenu.getCenterX(), this.rectLevelMenu.getCenterY(), 3);
        String s = "";
        this.prepTextQuestMenu.drawText(g, this.rectPrepQuest, 17);
        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
            s = this.sTextMenu[i];
            if (i == this.iSelectedMenuItem) {
                this.paintMenuButton(g, this.rectMenuItems[i], s, true);
                continue;
            }
            this.paintMenuButton(g, this.rectMenuItems[i], s, false);
        }
    }

    public void paintSettMenu(Graphics g) {
        this.paintBackButton(g);
        this.paintTitleLogo(g);
        String s = "";
        for (int i = 0; i < this.iSettItemsTotal; ++i) {
            s = this.sTextSett[i];
            if (this.screen == 3 && this.subScreen == 6 && i == 1) {
                s = s + " " + (Profile.bMusic ? this.sTextPom[0] : this.sTextPom[1]);
            }
            if (i == this.iSelectedSettItem) {
                this.paintMenuButton(g, this.rectSettItems[i], s, true);
                continue;
            }
            this.paintMenuButton(g, this.rectSettItems[i], s, false);
        }
    }

    public void paintPauseMenu(Graphics g) {
        this.paintBackButton(g);
        String s = "";
        for (int i = 0; i < this.iPauseItemsTotal; ++i) {
            s = this.sTextMenu[i];
            if (this.screen == 2 && this.subScreen == 3 && i == 2) {
                s = s + " " + (Profile.bMusic ? this.sTextPom[0] : this.sTextPom[1]);
            }
            if (i == this.iSelectedPauseItem) {
                this.paintMenuButton(g, this.rectPauseItems[i], s, true);
                continue;
            }
            this.paintMenuButton(g, this.rectPauseItems[i], s, false);
        }
    }

    public void paintMenuButton(Graphics g, Rectangle rect, String s, boolean bSelected) {
        int pomShiftX = 0;
        if (bSelected) {
            pomShiftX = this.iShiftX;
        }
        this.paintTable(g, this.sprButton, rect.getCenterX() + pomShiftX, rect.getCenterY(), rect.width, rect.height, false);
        this.fontMain.drawString(g, s.toCharArray(), rect.getCenterX(), rect.getCenterY(), 3);
    }

    public void paintAbout(Graphics g) {
        this.paintTable(g, this.sprDialog, MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) + this.imgYesBtn.getHeight(), this.iAboutWidth, this.iAboutHeight, false);
        this.paintButton(g, this.rectTitle, this.sTextTitle, true);
        this.paintBackButton(g);
        int iLogoY = (MainCanvas.HEIGHT >> 1) + this.imgYesBtn.getHeight() - (this.imgLogo.getHeight() >> 2);
        g.drawImage(this.imgLogo, MainCanvas.WIDTH >> 1, iLogoY, 3);
        this.fontMain.drawString(g, this.sTextPom[0].toCharArray(), MainCanvas.WIDTH >> 1, iLogoY + (this.fontMain.getHeight() << 1) + this.fontMain.getHeight(), 3);
        this.fontMain.drawString(g, this.sTextPom[1].toCharArray(), MainCanvas.WIDTH >> 1, iLogoY + (this.fontMain.getHeight() << 2), 3);
    }

    public void paintInstructions(Graphics g) {
        this.paintTable(g, this.sprDialog, MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT >> 1) + this.imgYesBtn.getHeight(), this.iAboutWidth, this.iAboutHeight, false);
        this.paintButton(g, this.rectTitle, this.sTextTitle, true);
        this.paintBackButton(g);
        if (!this.bLoading) {
            this.paintInstructionsText(g);
        }
    }

    public void paintQuitPause(Graphics g) {
        this.paintButton2(g, this.rectQuit);
        this.paintButtons(g);
    }

    public void paintQuitMenu(Graphics g) {
        this.paintButton2(g, this.rectQuit);
        this.paintButtons(g);
    }

    public void paintLanguages(Graphics g) {
        for (int i = 0; i < 6; ++i) {
            int pomShiftX = 0;
            if (i == this.iSelectedLanguage) {
                pomShiftX = this.iShiftX;
            }
            g.drawImage(this.imgLanguage[i], this.rectLanguages[i].getCenterX() + pomShiftX, this.rectLanguages[i].getCenterY(), 3);
        }
    }

    public void paintButton2(Graphics g, Rectangle rect) {
        int iCenterY = rect.y;
        if (this.screen == 0) {
            iCenterY = MainCanvas.HEIGHT >> 1;
        }
        this.paintTable(g, this.sprDialog, rect.x, iCenterY, rect.width, rect.height, false);
        int textHeight = this.fontMain.getHeight() * this.iTextLines;
        int pomY = iCenterY - (textHeight >> 1) - 1;
        for (int i = 0; i < this.iTextLines; ++i) {
            this.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), rect.x, pomY, 17);
            pomY += this.fontMain.getHeight();
        }
    }

    public void paintTable(Graphics g, Sprite spr, int centerX, int centerY, int width, int height, boolean isAnim) {
        int i;
        if (isAnim) {
            if (!resultSteps[0]) {
                centerY -= this.updateYResult;
                this.updateYResult -= spr.getHeight() >> 1;
            }
            if (this.isEarthquake) {
                int randMoveX = ScreenMain.getRandomInt(spr.getWidth() >> 3);
                int randMoveY = ScreenMain.getRandomInt(spr.getHeight() >> 3);
                centerX += randMoveX;
                centerY += randMoveY;
            }
        }
        if (height < spr.getHeight() << 1) {
            height = spr.getHeight() << 1;
        }
        int left = centerX - (width >> 1);
        int top = centerY - (height >> 1);
        int countX = (width - (spr.getWidth() << 1)) / spr.getWidth() + 1;
        int countY = (height - (spr.getHeight() << 1)) / spr.getHeight() + 1;
        int iHeight2 = height - (spr.getHeight() << 1);
        int iWidth2 = width - (spr.getWidth() << 1);
        int iX = left;
        int iY = top;
        spr.setFrame(0);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX, iY + spr.getHeight(), MainCanvas.WIDTH, iHeight2);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(3);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        iY = top + height - spr.getHeight();
        spr.setFrame(6);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX + spr.getWidth(), top, iWidth2, MainCanvas.HEIGHT);
        for (i = 0; i < countX; ++i) {
            iY = top;
            spr.setFrame(1);
            spr.setPosition(iX += spr.getWidth(), iY);
            spr.paint(g);
            for (int j = 0; j < countY; ++j) {
                spr.setFrame(4);
                spr.setPosition(iX, iY += spr.getHeight());
                spr.paint(g);
            }
            iY = top + height - spr.getHeight();
            spr.setFrame(7);
            spr.setPosition(iX, iY);
            spr.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        iX = left + width - spr.getWidth();
        iY = top;
        spr.setFrame(2);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX, iY + spr.getHeight(), MainCanvas.WIDTH, iHeight2);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(5);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        iY = top + height - spr.getHeight();
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        spr.setFrame(8);
        spr.setPosition(iX, iY);
        spr.paint(g);
    }

    public void paintInstructionsText(Graphics g) {
        int iTextYUp = this.iInstructionsCenterY - (this.iAboutHeight >> 1) + this.sprArrow.getHeight() * 3;
        int iTextYDown = this.iInstructionsCenterY + (this.iAboutHeight >> 1) - this.sprArrow.getHeight() * 3;
        if (this.iInstructionsShiftY > 0) {
            this.sprArrow.setFrame(0);
            this.sprArrow.setTransform(1);
            this.sprArrow.setPosition((MainCanvas.WIDTH >> 1) - (this.sprArrow.getWidth() >> 1), iTextYUp - this.sprArrow.getHeight() - (this.sprArrow.getHeight() >> 1));
            this.sprArrow.paint(g);
        }
        if (this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
            this.sprArrow.setFrame(0);
            this.sprArrow.setTransform(0);
            this.sprArrow.setPosition((MainCanvas.WIDTH >> 1) - (this.sprArrow.getWidth() >> 1), iTextYDown + (this.sprArrow.getHeight() >> 1));
            this.sprArrow.paint(g);
        }
        g.setClip(0, iTextYUp, MainCanvas.WIDTH, iTextYDown - iTextYUp);
        int lineY = 0;
        for (int i = 0; i < this.iTextLines; ++i) {
            lineY = iTextYUp + i * this.fontMain.getHeight() - this.iInstructionsShiftY;
            if (lineY <= this.iInstructionsCenterY - (this.iAboutHeight >> 1) || lineY + this.fontMain.getHeight() >= this.iInstructionsCenterY + (this.iAboutHeight >> 1)) continue;
            this.fontMain.drawString(g, this.prepText.getText(i).toCharArray(), MainCanvas.WIDTH >> 1, lineY, 17);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void play() {
        this.iScoreShowed = 0;
        this.iResultStep = 0;
        this.iResultCounter = 0;
        this.iBlinkCounter = 0;
        this.generatePlanets();
        this.game.resetDataBeforePlay();
        int menuButtonW = this.imgTitle.getWidth() + (this.sprButton.getHeight() << 1) - (this.imgTitle.getWidth() >> 2);
        int menuButtonH = this.sprButton.getHeight() << 1;
        this.initMenu(menuButtonW, menuButtonH);
    }

    public void updateBlink(long lTick) {
        this.iBlinkCounter = (int)((long)this.iBlinkCounter + lTick);
        if (this.bRecordDisplayed) {
            if (this.iBlinkCounter >= 400) {
                this.iBlinkCounter = 0;
                this.bRecordDisplayed = false;
            }
        } else if (this.iBlinkCounter >= 100) {
            this.iBlinkCounter = 0;
            this.bRecordDisplayed = true;
        }
    }

    public void updateResult(long lTick) {
        if (this.game.isGameOver() && this.iResultStep < 5) {
            if (this.iResultStep == 2 && this.iScoreShowed != this.game.getScore()) {
                this.iResultCounter = (int)((long)this.iResultCounter + lTick);
                if (this.iResultCounter >= 250) {
                    int step = this.game.getScore() >> 3;
                    if (step < 1) {
                        step = 1;
                    }
                    this.iScoreShowed += step;
                    if (this.iScoreShowed >= this.game.getScore()) {
                        this.iScoreShowed = this.game.getScore();
                        this.iResultCounter = 0;
                    }
                }
                return;
            }
            this.iResultCounter = (int)((long)this.iResultCounter + lTick);
            if (this.iResultCounter >= 250) {
                this.iResultCounter = 0;
                ++this.iResultStep;
            }
        }
    }

    public void setTitleCenter(String s) {
        this.rectQuit.height = this.fontMain.getHeight() + (this.fontMain.getHeight() >> 1);
        int textMaxWidth = this.rectQuit.width - (this.rectQuit.width >> 3);
        this.prepText = new PreparedText(this.fontMain);
        this.prepText.prepareText(s, textMaxWidth);
        this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
        if (this.iTextLines > 1) {
            this.rectQuit.height += (this.iTextLines - 1) * this.fontMain.getHeight() + 1;
        }
        if (this.rectQuit != null) {
            this.rectQuit.height = this.fontMain.getHeight() + (this.fontMain.getHeight() >> 1);
            textMaxWidth = this.rectQuit.width - (this.rectQuit.width >> 3);
            this.prepText = new PreparedText(this.fontMain);
            this.prepText.prepareText(s, textMaxWidth);
            this.iTextLines = this.prepText.getTextHeight() / this.fontMain.getHeight();
            if (this.iTextLines > 1) {
                this.rectQuit.height += (this.iTextLines - 1) * this.fontMain.getHeight() + 1;
                this.rectQuit.height += this.fontMain.getHeight();
            }
        }
    }

    public void changeLanguage(int iType) {
        switch (iType) {
            case 0: {
                if (this.iSelectedLanguage <= 0) break;
                --this.iSelectedLanguage;
                break;
            }
            case 1: {
                if (this.iSelectedLanguage < 5) {
                    ++this.iSelectedLanguage;
                    break;
                }
                this.iSelectedLanguage = 0;
                break;
            }
            case 2: {
                if (this.iSelectedLanguage >= 3) break;
                this.iSelectedLanguage += 3;
                break;
            }
            case 3: {
                if (this.iSelectedLanguage <= 2) break;
                this.iSelectedLanguage -= 3;
                break;
            }
        }
    }

    public void pause(boolean bMusic) {
        if (!this.game.isGameOver()) {
            this.iSelectedMenuItem = 2;
            this.nextScreen(2, 3);
            if (bMusic) {
                // empty if block
            }
        }
    }

    public void updateInstructions() {
        if ((Keys.isActionPressed(1) || Keys.isKeyPressed(50)) && this.iInstructionsShiftY > 0) {
            this.iInstructionsShiftY -= this.fontMain.getHeight();
            if (this.iInstructionsShiftY < 0) {
                this.iInstructionsShiftY = 0;
            }
        }
        if ((Keys.isActionPressed(2) || Keys.isKeyPressed(56)) && this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
            this.iInstructionsShiftY += this.fontMain.getHeight();
            if (this.iInstructionsShiftY > this.iInstructionsMaxShiftY) {
                this.iInstructionsShiftY = this.iInstructionsMaxShiftY;
            }
        }
    }

    public void updateShift() {
        ++this.updateCounter;
        if (this.updateCounter > 1) {
            this.updateCounter = 0;
            if (this.iShiftDirection > 0) {
                this.iShiftX += this.iShiftStep;
                if (this.iShiftX >= this.iShiftStep << 1) {
                    this.iShiftDirection = -1;
                }
            } else {
                this.iShiftX -= this.iShiftStep;
                if (this.iShiftX <= -(this.iShiftStep << 1)) {
                    this.iShiftDirection = 1;
                }
            }
        }
    }

    public int changeSelectedMenuItem(int iShift) {
        int pom = 0;
        int selected = 0;
        switch (this.screen) {
            case 1: {
                pom = this.iMenuItemsTotal;
                selected = this.iSelectedMenuItem;
                break;
            }
            case 3: {
                pom = this.iSettItemsTotal;
                selected = this.iSelectedSettItem;
                break;
            }
            case 2: {
                pom = this.iPauseItemsTotal;
                selected = this.iSelectedPauseItem;
                break;
            }
        }
        selected = iShift > 0 ? (selected + 1) % pom : (selected > 0 ? --selected : pom - 1);
        return selected;
    }

    public void generatePlanets() {
        this.iPlanet = RandomNum.getRandomUInt(5);
    }

    public void soundOn() {
        Profile.bMusic = true;
        MainCanvas.soundManager.SetSoundOn(true);
        MainCanvas.soundManager.SetMusicOn(true);
    }

    public void soundOff() {
        Profile.bMusic = false;
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.SetMusicOn(false);
    }

    public void changeSound() {
        Profile.bMusic = !Profile.bMusic;
        Profile.save();
        if (Profile.bMusic) {
            this.soundOn();
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        } else {
            this.soundOff();
        }
    }

    public void quit() {
        X.quitApp();
    }

    public void afterHide() {
    }

    public void beforeShow() {
        Profile.load();
        this.screen = 0;
        this.subScreen = 0;
    }

    public void beforeInteruption() {
        if (this.screen != 0) {
            MainCanvas.soundManager.Stop();
            if (this.screen == 2 && this.subScreen == 0) {
                this.game.resetPlayerSpeed();
                if (!this.game.isGameOver()) {
                    this.iSelectedMenuItem = 2;
                    this.nextScreen(2, 3);
                }
            }
            MainCanvas.soundManager.Stop();
        }
    }

    public void afterInteruption() {
        if (this.screen != 0) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Stop();
            if (Profile.bMusic) {
                MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
            }
            if (this.screen == 2 && this.subScreen == 0) {
                this.game.resetPlayerSpeed();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void keyPressed(int keyCode) {
        switch (this.screen) {
            case 2: {
                switch (this.subScreen) {
                    case 0: {
                        if (isShowingQuest && (Keys.isKeyPressed(53) || Keys.isKeyPressed(5))) {
                            isShowingQuest = false;
                            showingCounter = -1;
                            return;
                        }
                        this.game.iPlayerSpeed = this.getPlayerSpeed();
                        if (this.game.iPlayerSpeed != 0) return;
                        this.game.resetPlayerSpeed();
                    }
                }
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyReleased(int keyCode) {
        block82: {
            block83: {
                if (this.bAfterPause) break block82;
                block0 : switch (this.screen) {
                    case 1: {
                        switch (this.subScreen) {
                            case 0: {
                                if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                                    this.iSelectedMenuItem = this.changeSelectedMenuItem(1);
                                    return;
                                }
                                if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                                    this.iSelectedMenuItem = this.changeSelectedMenuItem(-1);
                                    return;
                                }
                                if (Keys.isFKRightCode(keyCode)) {
                                    this.nextScreen(1, 5);
                                    return;
                                }
                                if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) return;
                                switch (this.iSelectedMenuItem) {
                                    case 0: {
                                        this.play();
                                        if (Profile.level == 2 || Profile.level == 0 || Game.directMode[Profile.level]) {
                                            this.nextScreen(2, 1);
                                            return;
                                        }
                                        this.nextScreen(2, 0);
                                        return;
                                    }
                                    case 1: {
                                        this.nextScreen(3, 6);
                                    }
                                }
                                return;
                            }
                            case 3: {
                                if (!Keys.isFKRightCode(keyCode)) return;
                                this.nextScreen(1, 0);
                                return;
                            }
                            case 2: {
                                if (!Keys.isFKRightCode(keyCode)) return;
                                this.nextScreen(1, 0);
                                return;
                            }
                            case 5: {
                                if (Keys.isFKLeftCode(keyCode)) {
                                    this.quit();
                                    return;
                                }
                                if (!Keys.isFKRightCode(keyCode)) return;
                                this.nextScreen(1, 0);
                                return;
                            }
                        }
                        return;
                    }
                    case 3: {
                        switch (this.subScreen) {
                            case 6: {
                                if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                                    this.iSelectedSettItem = this.changeSelectedMenuItem(1);
                                    return;
                                }
                                if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                                    this.iSelectedSettItem = this.changeSelectedMenuItem(-1);
                                    return;
                                }
                                if (Keys.isFKRightCode(keyCode)) {
                                    this.nextScreen(1, 0);
                                    return;
                                }
                                if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) return;
                                switch (this.iSelectedSettItem) {
                                    case 1: {
                                        this.changeSound();
                                        return;
                                    }
                                    case 2: {
                                        this.nextScreen(3, 3);
                                        return;
                                    }
                                    case 0: {
                                        this.nextScreen(3, 2);
                                    }
                                }
                                return;
                            }
                            case 3: {
                                if (!Keys.isFKRightCode(keyCode)) return;
                                this.nextScreen(3, 6);
                                return;
                            }
                            case 2: {
                                if (!Keys.isFKRightCode(keyCode)) return;
                                this.nextScreen(3, 6);
                                return;
                            }
                        }
                        return;
                    }
                    case 0: {
                        switch (this.subScreen) {
                            case 2: {
                                if (this.delay <= 100) return;
                                this.delay = 100;
                                return;
                            }
                            case 3: {
                                if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                                    this.changeLanguage(0);
                                    return;
                                }
                                if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                                    this.changeLanguage(1);
                                    return;
                                }
                                if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                                    this.changeLanguage(2);
                                    return;
                                }
                                if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                                    this.changeLanguage(3);
                                    return;
                                }
                                if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) return;
                                this.nextScreen(0, 4);
                                return;
                            }
                            case 4: {
                                if (Keys.isFKLeftCode(keyCode)) {
                                    this.soundOff();
                                    this.changeSound();
                                    this.nextScreen(1, 0);
                                    return;
                                }
                                if (!Keys.isFKRightCode(keyCode)) return;
                                this.soundOff();
                                this.nextScreen(1, 0);
                                return;
                            }
                        }
                        return;
                    }
                    case 2: {
                        switch (this.subScreen) {
                            case 0: {
                                if (Keys.isKeyPressed(54) || Keys.isActionPressed(4)) {
                                    this.game.resetPlayerSpeed();
                                    return;
                                }
                                if (Keys.isKeyPressed(52) || Keys.isActionPressed(3)) {
                                    this.game.resetPlayerSpeed();
                                    return;
                                }
                                if (!Keys.isFKRightCode(keyCode)) return;
                                this.game.bPause = true;
                                this.nextScreen(2, 3);
                                return;
                            }
                            case 1: {
                                if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) return;
                                this.nextScreen(2, 0);
                                return;
                            }
                            case 2: {
                                if (!resultSteps[resultSteps.length - 1]) {
                                    if (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                                        for (int index = 0; index < resultSteps.length; ++index) {
                                            ScreenMain.resultSteps[index] = true;
                                        }
                                        this.textUpResultX = 0;
                                        this.textDownResultX = 0;
                                    }
                                } else if (this.game.isSuccessfuly()) {
                                    if (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                                        int menuButtonW = this.imgTitle.getWidth() + (this.sprButton.getHeight() << 1) - (this.imgTitle.getWidth() >> 2);
                                        int menuButtonH = this.sprButton.getHeight() << 1;
                                        this.initMenu(menuButtonW, menuButtonH);
                                        this.nextScreen(1, 0);
                                    }
                                } else {
                                    if (Keys.isFKLeftCode(keyCode) || Keys.isActionPressed(5) || Keys.isKeyPressed(53)) {
                                        if (selectOptionResult == 0) {
                                            this.play();
                                            this.nextScreen(2, 0);
                                            return;
                                        } else {
                                            this.nextScreen(1, 0);
                                        }
                                        return;
                                    } else if (Keys.isKeyPressed(56) || Keys.isActionPressed(2)) {
                                        selectOptionResult = 1;
                                        return;
                                    } else {
                                        if (!Keys.isKeyPressed(50) && !Keys.isActionPressed(1)) return;
                                        selectOptionResult = 0;
                                    }
                                    return;
                                }
                                if (!Keys.isFKRightCode(keyCode)) return;
                                this.nextScreen(1, 0);
                                return;
                            }
                            case 3: {
                                if (Keys.isFKRightCode(keyCode)) {
                                    this.nextScreen(2, 5);
                                    return;
                                }
                                if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                                    this.iSelectedPauseItem = this.changeSelectedMenuItem(1);
                                    return;
                                }
                                if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                                    this.iSelectedPauseItem = this.changeSelectedMenuItem(-1);
                                    return;
                                }
                                if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) return;
                                switch (this.iSelectedPauseItem) {
                                    case 1: {
                                        this.nextScreen(2, 4);
                                        break block0;
                                    }
                                    case 0: {
                                        this.game.bPause = false;
                                        this.nextScreen(2, 0);
                                        break block0;
                                    }
                                    case 2: {
                                        this.changeSound();
                                    }
                                }
                                break block83;
                            }
                            case 4: {
                                if (!Keys.isFKRightCode(keyCode)) return;
                                this.nextScreen(2, 3);
                                return;
                            }
                            case 5: {
                                if (Keys.isFKRightCode(keyCode)) {
                                    this.nextScreen(2, 3);
                                    return;
                                }
                                if (!Keys.isFKLeftCode(keyCode)) return;
                                this.game.bPause = false;
                                this.nextScreen(1, 0);
                                return;
                            }
                        }
                    }
                }
            }
            return;
        }
        this.bAfterPause = false;
    }

    public void nextScreen(int nextScreen, int nextSubScreen) {
        this.screen = nextScreen;
        this.subScreen = nextSubScreen;
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 4: {
                        this.initTexts();
                        break;
                    }
                    case 2: {
                        this.delay = 3000;
                        break;
                    }
                }
            }
            case 2: {
                switch (this.subScreen) {
                    case 2: {
                        this.iScoreShowed = 0;
                        this.iResultStep = 0;
                        this.iResultCounter = 0;
                        this.iBlinkCounter = 0;
                        break block0;
                    }
                    case 0: {
                        isShowingQuest = true;
                        showingCounter = 1500;
                    }
                }
            }
        }
        this.setTexts();
    }

    public void shiftTextUp() {
        if (this.iInstructionsShiftY < this.iInstructionsMaxShiftY) {
            this.iInstructionsShiftY += this.fontMain.getHeight();
            this.iInstructionsShiftY += this.fontMain.getHeight();
            if (this.iInstructionsShiftY > this.iInstructionsMaxShiftY) {
                this.iInstructionsShiftY += this.fontMain.getHeight();
            }
        }
    }

    public void shiftTextDown() {
        if (this.iInstructionsShiftY > 0) {
            this.iInstructionsShiftY -= this.fontMain.getHeight();
            if (this.iInstructionsShiftY < 0) {
                this.iInstructionsShiftY = 0;
            }
        }
    }

    public boolean isInstructionButtonUpPressed(int x, int y) {
        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) + this.sprArrow.getHeight() * 3;
        int iArrowX = (MainCanvas.WIDTH >> 1) - this.sprArrow.getWidth();
        int iArrowY = iTextYUp - (this.sprArrow.getHeight() << 1);
        int iWidth = this.sprArrow.getWidth() << 1;
        int iHeight = this.sprArrow.getHeight() << 1;
        return x >= iArrowX && x <= iArrowX + iWidth && y >= iArrowY && y <= iArrowY + iHeight;
    }

    public boolean isInstructionButtonDownPressed(int x, int y) {
        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1) - this.sprArrow.getHeight() * 3;
        int iArrowX = (MainCanvas.WIDTH >> 1) - this.sprArrow.getWidth();
        int iArrowY = iTextYDown;
        int iWidth = this.sprArrow.getWidth() << 1;
        int iHeight = this.sprArrow.getHeight() << 1;
        return x >= iArrowX && x <= iArrowX + iWidth && y >= iArrowY && y <= iArrowY + iHeight;
    }

    public boolean isPressedInstructionsText(int x, int y) {
        return x > (MainCanvas.WIDTH >> 1) - (this.iAboutWidth >> 1) && x < (MainCanvas.WIDTH >> 1) + (this.iAboutWidth >> 1) && y > this.iInstructionsCenterY - (this.iAboutHeight >> 1) && y < this.iInstructionsCenterY + (this.iAboutHeight >> 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pointerPressed(int x, int y) {
        if (this.screen == 3 && this.subScreen == 2 || this.screen == 2 && this.subScreen == 4) {
            if (this.isInstructionButtonUpPressed(x, y)) {
                this.shiftTextDown();
                return;
            }
            if (this.isInstructionButtonDownPressed(x, y)) {
                this.shiftTextUp();
                return;
            }
            if (this.isPressedInstructionsText(x, y)) {
                this.bDragInstructions = true;
                return;
            }
        }
        block0 : switch (this.screen) {
            case 1: {
                switch (this.subScreen) {
                    case 2: {
                        if (!this.isPressedInstructionsText(x, y)) return;
                        this.bDragInstructions = true;
                    }
                }
                return;
            }
            case 2: {
                switch (this.subScreen) {
                    case 0: {
                        if (isShowingQuest && this.rectScreen.contains(x, y)) {
                            isShowingQuest = false;
                            showingCounter = -1;
                            break block0;
                        }
                        this.game.iPlayerSpeed = this.getPlayerSpeed(x, y);
                        if (this.game.iPlayerSpeed != 0) return;
                        this.game.resetPlayerSpeed();
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void pointerDragged(int x, int y) {
        if ((this.screen == 3 && this.subScreen == 2 || this.screen == 2 && this.subScreen == 4) && this.bDragInstructions) {
            if (!this.isPressedInstructionsText(x, y)) {
                this.bDragInstructions = false;
            }
            this.iTextShiftY += MainCanvas.lastPointerPressedY - y;
            MainCanvas.lastPointerPressedY = y;
        }
        switch (this.screen) {
            case 2: {
                switch (this.subScreen) {
                    case 0: {
                        if (this.rectSpeedUp.contains(x, y) || this.rectSpeedDown.contains(x, y)) return;
                        this.game.resetPlayerSpeed();
                    }
                }
                return;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pointerReleased(int x, int y) {
        block70: {
            if ((this.screen == 3 && this.subScreen == 2 || this.screen == 2 && this.subScreen == 4) && this.bDragInstructions) {
                this.bDragInstructions = false;
            }
            block0 : switch (this.screen) {
                case 0: {
                    switch (this.subScreen) {
                        case 2: {
                            if (this.delay <= 100) return;
                            this.delay = 100;
                            return;
                        }
                        case 3: {
                            for (int i = 0; i < 6; ++i) {
                                if (!this.rectLanguages[i].contains(x, y)) continue;
                                this.iSelectedLanguage = i;
                                this.nextScreen(0, 4);
                                return;
                            }
                            return;
                        }
                        case 4: {
                            if (this.rectRight.contains(x, y)) {
                                this.soundOff();
                                this.nextScreen(1, 0);
                            }
                            if (!this.rectLeft.contains(x, y)) return;
                            this.soundOff();
                            this.changeSound();
                            this.nextScreen(1, 0);
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 1: {
                    switch (this.subScreen) {
                        case 0: {
                            if (this.rectRight.contains(x, y)) {
                                this.nextScreen(1, 5);
                                return;
                            }
                            for (int i = 0; i < this.iMenuItemsTotal; ++i) {
                                if (!this.rectMenuItems[i].contains(x, y)) continue;
                                this.iSelectedMenuItem = i;
                                switch (this.iSelectedMenuItem) {
                                    case 0: {
                                        this.play();
                                        this.nextScreen(2, 0);
                                        return;
                                    }
                                    case 1: {
                                        this.nextScreen(3, 6);
                                        return;
                                    }
                                }
                                return;
                            }
                            return;
                        }
                        case 2: {
                            if (!this.rectRight.contains(x, y)) return;
                            this.nextScreen(1, 0);
                            return;
                        }
                        case 3: {
                            if (!this.rectRight.contains(x, y)) return;
                            this.nextScreen(1, 0);
                            return;
                        }
                        case 5: {
                            if (this.rectRight.contains(x, y)) {
                                this.nextScreen(1, 0);
                                return;
                            }
                            if (!this.rectLeft.contains(x, y)) return;
                            this.quit();
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 3: {
                    switch (this.subScreen) {
                        case 6: {
                            if (this.rectRight.contains(x, y)) {
                                this.nextScreen(1, 0);
                                return;
                            }
                            for (int i = 0; i < this.iSettItemsTotal; ++i) {
                                if (!this.rectSettItems[i].contains(x, y)) continue;
                                this.iSelectedSettItem = i;
                                switch (this.iSelectedSettItem) {
                                    case 2: {
                                        this.nextScreen(3, 3);
                                        return;
                                    }
                                    case 0: {
                                        this.nextScreen(3, 2);
                                        return;
                                    }
                                    case 1: {
                                        this.changeSound();
                                        return;
                                    }
                                }
                                return;
                            }
                            return;
                        }
                        case 3: {
                            if (!this.rectRight.contains(x, y)) return;
                            this.nextScreen(3, 6);
                            return;
                        }
                        case 2: {
                            if (!this.rectRight.contains(x, y)) return;
                            this.nextScreen(3, 6);
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 2: {
                    switch (this.subScreen) {
                        case 4: {
                            if (!this.rectRight.contains(x, y)) return;
                            this.nextScreen(2, 3);
                            break block70;
                        }
                        case 0: {
                            if (this.rectSpeedUp.contains(x, y)) {
                                this.game.resetPlayerSpeed();
                            }
                            if (this.rectSpeedDown.contains(x, y)) {
                                this.game.resetPlayerSpeed();
                            }
                            if (!this.rectUpperRight.contains(x, y)) return;
                            this.game.bPause = true;
                            this.nextScreen(2, 3);
                            break block70;
                        }
                        case 2: {
                            if (!resultSteps[resultSteps.length - 1]) {
                                if (!this.rectScreen.contains(x, y)) return;
                                for (int index = 0; index < resultSteps.length; ++index) {
                                    ScreenMain.resultSteps[index] = true;
                                }
                                this.textUpResultX = 0;
                                this.textDownResultX = 0;
                                break block0;
                            } else if (this.game.isSuccessfuly()) {
                                if (!this.rectResultBtns[0].contains(x, y)) return;
                                int menuButtonW = this.imgTitle.getWidth() + (this.sprButton.getHeight() << 1) - (this.imgTitle.getWidth() >> 2);
                                int menuButtonH = this.sprButton.getHeight() << 1;
                                this.initMenu(menuButtonW, menuButtonH);
                                this.nextScreen(1, 0);
                                break block0;
                            } else {
                                if (this.rectResultBtns[1].contains(x, y)) {
                                    this.play();
                                    this.nextScreen(2, 0);
                                    break block0;
                                }
                                if (!this.rectResultBtns[2].contains(x, y)) return;
                                this.nextScreen(1, 0);
                                break block0;
                            }
                        }
                        case 3: {
                            if (this.rectRight.contains(x, y)) {
                                this.nextScreen(2, 5);
                            }
                            for (int i = 0; i < this.iPauseItemsTotal; ++i) {
                                if (!this.rectPauseItems[i].contains(x, y)) continue;
                                this.iSelectedPauseItem = i;
                                switch (this.iSelectedPauseItem) {
                                    case 1: {
                                        this.nextScreen(2, 4);
                                        return;
                                    }
                                    case 2: {
                                        this.changeSound();
                                        return;
                                    }
                                    case 0: {
                                        this.game.bPause = false;
                                        this.nextScreen(2, 0);
                                        return;
                                    }
                                }
                                return;
                            }
                            break block70;
                        }
                        case 5: {
                            if (this.rectRight.contains(x, y)) {
                                this.nextScreen(2, 3);
                                return;
                            }
                            if (!this.rectLeft.contains(x, y)) return;
                            this.nextScreen(1, 0);
                            return;
                        }
                    }
                }
            }
        }
    }

    private void initAbout() {
        this.iAboutWidth = MainCanvas.WIDTH - this.imgEarth.getWidth() - (this.imgYesBtn.getHeight() >> 1);
        this.iAboutHeight = MainCanvas.HEIGHT - (this.imgEarth.getHeight() << 1) - this.imgYesBtn.getHeight();
    }

    private void initInstructions() {
        this.iInstructionsCenterY = (MainCanvas.HEIGHT >> 1) + this.imgYesBtn.getHeight();
        this.iInstructionsHeight = MainCanvas.HEIGHT - this.imgYesBtn.getHeight() - (this.fontMain.getHeight() << 1);
    }

    private void initMenu(int width, int height) {
        int x = (MainCanvas.WIDTH >> 1) - (width >> 1);
        int y = (MainCanvas.HEIGHT >> 1) - (this.sprButton.getHeight() << 1);
        this.rectLevelMenu = new Rectangle(x, y, width, this.fontMain.getHeight());
        this.prepTextQuestMenu = new PreparedText(this.fontMain);
        this.prepTextQuestMenu.prepareText(this.quests.elementAt(this.game.getTransformLevel(Profile.level)).toString(), width);
        this.rectPrepQuest = new Rectangle(x, y + this.rectLevelMenu.height + (this.fontMain.getHeight() >> 1), width, this.prepTextQuestMenu.getTextHeight());
        this.rectMenu = new Rectangle(x, this.rectPrepQuest.getBottom(), width, MainCanvas.HEIGHT - this.imgBackBtn.getHeight() - this.rectPrepQuest.getBottom());
        int yDiff = this.rectLevelMenu.height + (this.fontMain.getHeight() >> 1) + this.prepTextQuestMenu.getTextHeight() + (this.rectMenu.height >> 1) - height;
        this.rectMenuItems = new Rectangle[this.iMenuItemsTotal];
        for (int i = 0; i < this.iMenuItemsTotal; ++i) {
            this.rectMenuItems[i] = new Rectangle(x, y + yDiff + i * (height + (this.sprButton.getHeight() >> 1)), width, height);
        }
        this.levelUp = new Rectangle(MainCanvas.WIDTH >> 1, 0, this.rectScreen.width >> 1, this.rectScreen.height >> 1);
        this.levelDown = new Rectangle(0, 0, this.rectScreen.width >> 1, this.rectScreen.height >> 1);
    }

    private void initSett(int width, int height) {
        this.rectSettItems = new Rectangle[this.iSettItemsTotal];
        for (int i = 0; i < this.iSettItemsTotal; ++i) {
            this.rectSettItems[i] = new Rectangle((MainCanvas.WIDTH >> 1) - (width >> 1), this.rectButtons.getCenterY() - ((height + (this.sprButton.getHeight() >> 1)) * this.iSettItemsTotal >> 1) + i * (height + (this.sprButton.getHeight() >> 1)), width, height);
        }
    }

    private void initPause(int width, int height) {
        this.rectPauseItems = new Rectangle[this.iPauseItemsTotal];
        for (int i = 0; i < this.iPauseItemsTotal; ++i) {
            this.rectPauseItems[i] = new Rectangle((MainCanvas.WIDTH >> 1) - (width >> 1), (MainCanvas.HEIGHT >> 1) - ((this.sprButton.getHeight() << 1) + this.sprButton.getHeight() + (this.sprButton.getHeight() >> 1)) + i * (height + (this.sprButton.getHeight() >> 1)), width, height);
        }
    }

    public void initGame() {
        int widthQuest = MainCanvas.WIDTH - onePixel - (MainCanvas.WIDTH >> 1);
        this.rectQuestGame = new Rectangle((this.rectScreen.width >> 1) - (this.iAboutWidth >> 1), (this.rectScreen.height >> 1) - (this.rectScreen.height >> 2), this.iAboutWidth, this.rectScreen.height >> 1);
        this.prepTextQuestGame = new PreparedText(this.fontMain);
        this.prepTextQuestGame.prepareText("\n\n" + Resources.resTexts[0].getHashedString(47) + "\n\n" + (String)this.quests.elementAt(this.game.getTransformLevel(Profile.level)), widthQuest);
        this.updateYResult = this.ResultTablePosY = this.sprDialog.getHeight() << 3;
    }

    private void initQuestList() {
        block10: for (int index = 0; index < Game.questLevel.length; ++index) {
            switch (Game.questLevel[index]) {
                case 0: {
                    this.quests.addElement(Resources.resTexts[0].getHashedString(38) + " " + Game.questDetailLevel[index] + " " + Resources.resTexts[0].getHashedString(39));
                    continue block10;
                }
                case 5: {
                    this.quests.addElement(Resources.resTexts[0].getHashedString(38) + " " + Game.questDetailLevel[index] + " " + Resources.resTexts[0].getHashedString(39) + " " + Resources.resTexts[0].getHashedString(46));
                    continue block10;
                }
                case 1: {
                    this.quests.addElement(Resources.resTexts[0].getHashedString(38) + " " + Game.questDetailLevel[index] + " S.");
                    continue block10;
                }
                case 7: {
                    this.quests.addElement(Resources.resTexts[0].getHashedString(38) + " " + Game.questDetailLevel[index] + " S. " + Resources.resTexts[0].getHashedString(46));
                    continue block10;
                }
                case 2: {
                    this.quests.addElement(Resources.resTexts[0].getHashedString(38) + " " + Game.questDetailLevel[index] + " S. " + Resources.resTexts[0].getHashedString(45));
                    continue block10;
                }
                case 3: {
                    this.quests.addElement(Resources.resTexts[0].getHashedString(38) + " " + Game.questDetailLevel[index] + " " + Resources.resTexts[0].getHashedString(40));
                    continue block10;
                }
                case 4: {
                    if (Game.questDetailLevel[index] > 1) {
                        this.quests.addElement(Resources.resTexts[0].getHashedString(42) + " " + Game.questDetailLevel[index] + " " + Resources.resTexts[0].getHashedString(44));
                        continue block10;
                    }
                    this.quests.addElement(Resources.resTexts[0].getHashedString(42) + " " + Game.questDetailLevel[index] + " " + Resources.resTexts[0].getHashedString(43));
                    continue block10;
                }
                case 6: {
                    if (Game.questDetailLevel[index] > 1) {
                        this.quests.addElement(Resources.resTexts[0].getHashedString(42) + " " + Game.questDetailLevel[index] + " " + Resources.resTexts[0].getHashedString(44) + " " + Resources.resTexts[0].getHashedString(46));
                        continue block10;
                    }
                    this.quests.addElement(Resources.resTexts[0].getHashedString(42) + " " + Game.questDetailLevel[index] + " " + Resources.resTexts[0].getHashedString(43) + " " + Resources.resTexts[0].getHashedString(46));
                    continue block10;
                }
            }
        }
    }

    private void paintCompletedGame(Graphics g) {
        int x = MainCanvas.WIDTH >> 1;
        int yLevel = MainCanvas.HEIGHT >> 2;
        int yResult = yLevel + (MainCanvas.HEIGHT >> 3);
        String s = this.sTextResult[0];
        if (this.isEarthquake) {
            int randMoveX = ScreenMain.getRandomInt(this.sprDialog.getWidth() >> 3);
            x += randMoveX;
        }
        this.paintTable(g, this.sprDialog, this.rectResult.getCenterX(), this.rectResult.getCenterY(), this.rectResult.width, this.rectResult.height, true);
        if (resultSteps[1]) {
            if (resultSteps[2]) {
                this.fontMain.drawString(g, ("LEVEL " + Profile.level).toCharArray(), x + this.textUpResultX, yLevel, 3);
            } else {
                this.fontMain.drawString(g, ("LEVEL " + Profile.level).toCharArray(), x + this.textUpResultX, yLevel, 3);
            }
        }
        if (resultSteps[2]) {
            this.fontMain.drawString(g, Resources.resTexts[0].getHashedString(35).toCharArray(), x + this.textDownResultX, yResult, 3);
        }
        if (resultSteps[3]) {
            this.paintMenuButton(g, this.rectResultBtns[0], s, true);
        }
    }

    private void paintFailedGame(Graphics g) {
        int x = MainCanvas.WIDTH >> 1;
        int yLevel = MainCanvas.HEIGHT >> 2;
        int yResult = yLevel + (MainCanvas.HEIGHT >> 3);
        String restart = this.sTextResult[1];
        String menu = this.sTextResult[2];
        if (this.isEarthquake) {
            int randMoveX = ScreenMain.getRandomInt(this.sprDialog.getWidth() >> 3);
            int randMoveY = ScreenMain.getRandomInt(this.sprDialog.getHeight() >> 3);
            x += randMoveX;
            yLevel += randMoveY;
        }
        this.paintTable(g, this.sprDialog, this.rectResult.getCenterX(), this.rectResult.getCenterY(), this.rectResult.width, this.rectResult.height, true);
        if (resultSteps[1]) {
            if (resultSteps[2]) {
                this.fontMain.drawString(g, ("LEVEL " + (Profile.level + 1)).toCharArray(), x + this.textUpResultX, yLevel, 3);
            } else {
                this.fontMain.drawString(g, ("LEVEL " + (Profile.level + 1)).toCharArray(), x + this.textUpResultX, yLevel, 3);
            }
        }
        if (resultSteps[2]) {
            this.fontMain.drawString(g, Resources.resTexts[0].getHashedString(36).toCharArray(), x + this.textDownResultX, yResult, 3);
        }
        if (resultSteps[3]) {
            if (selectOptionResult == 0) {
                this.paintMenuButton(g, this.rectResultBtns[1], restart, true);
            } else {
                this.paintMenuButton(g, this.rectResultBtns[1], restart, false);
            }
        }
        if (resultSteps[4]) {
            if (selectOptionResult == 0) {
                this.paintMenuButton(g, this.rectResultBtns[2], menu, false);
            } else {
                this.paintMenuButton(g, this.rectResultBtns[2], menu, true);
            }
        }
    }

    public String getQuest(int index) {
        if (this.quests != null && this.quests.size() >= index) {
            return (String)this.quests.elementAt(index);
        }
        return null;
    }

    private void initResult(int width, int height) {
        int xCenter = MainCanvas.WIDTH >> 1;
        int yPosCenter = (MainCanvas.HEIGHT >> 2) + (MainCanvas.HEIGHT >> 3) - (height >> 1);
        int rectWidth = (MainCanvas.WIDTH >> 1) + (MainCanvas.WIDTH >> 3);
        int rectHeight = (MainCanvas.HEIGHT >> 1) - height;
        this.rectResult = new Rectangle(xCenter - (rectWidth >> 1), yPosCenter - (rectHeight >> 1), rectWidth, rectHeight);
        yPosCenter = this.rectResult.getBottom() + (MainCanvas.HEIGHT - this.rectResult.getBottom() >> 1);
        this.rectResultBtns = new Rectangle[3];
        this.rectResultBtns[0] = new Rectangle(xCenter - (width >> 1), yPosCenter - (height >> 1), width, height);
        this.rectResultBtns[1] = new Rectangle(xCenter - (width >> 1), yPosCenter -= height + (height >> 2), width, height);
        this.rectResultBtns[2] = new Rectangle(xCenter - (width >> 1), yPosCenter += (height << 1) - (height >> 1), width, height);
    }

    private int getPlayerSpeed(int x, int y) {
        if (Game.backMode) {
            if (this.rectSpeedUp.contains(x, y)) {
                return -6;
            }
            if (!this.game.isBrakeDisabled() && this.rectSpeedDown.contains(x, y)) {
                Game.speedDragged = true;
                return -2;
            }
        } else {
            if (this.rectSpeedUp.contains(x, y)) {
                Game.speedDragged = true;
                return 6;
            }
            if (!this.game.isBrakeDisabled() && this.rectSpeedDown.contains(x, y)) {
                return 2;
            }
        }
        return 0;
    }

    private int getPlayerSpeed() {
        if (Game.backMode) {
            if ((Keys.isKeyPressed(52) || Keys.isActionPressed(3)) && !this.game.isBrakeDisabled()) {
                return -2;
            }
            if (Keys.isKeyPressed(54) || Keys.isActionPressed(4)) {
                Game.speedDragged = true;
                return -6;
            }
        } else {
            if ((Keys.isKeyPressed(52) || Keys.isActionPressed(3)) && !this.game.isBrakeDisabled()) {
                return 2;
            }
            if (Keys.isKeyPressed(54) || Keys.isActionPressed(4)) {
                Game.speedDragged = true;
                return 6;
            }
        }
        return 0;
    }

    public void paintQuest(Graphics g) {
        this.paintTable(g, this.sprDialog, this.rectQuestGame.getCenterX(), this.rectQuestGame.getCenterY(), this.rectQuestGame.width, this.rectQuestGame.height, false);
        int x = this.rectQuestGame.getCenterX();
        int y = this.rectQuestGame.getCenterY() - (this.prepTextQuestGame.getTextHeight() >> 1);
        for (int index = 0; index < this.prepTextQuestGame.getTextHeight() / this.fontMain.getHeight(); ++index) {
            this.fontMain.drawString(g, this.prepTextQuestGame.getText(index).toCharArray(), x, y, 3);
            y += this.fontMain.getHeight();
        }
    }

    static {
        resultSteps = new boolean[]{false, false, false, false, false};
        langCodes = new String[]{"en", "de", "fr", "es", "it", "pt"};
        selectOptionResult = 0;
    }
}

