/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.game;

import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.game.Asteroid;
import sk.inlogic.game.Enemy;
import sk.inlogic.screen.ScreenMain;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.ArrayAngles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Game {
    private ScreenMain gameScreen;
    public static final byte TOTAL_ENEMIES = 6;
    public static final byte TOTAL_TYPES = 2;
    public static final byte TOTAL_EARTHS = 2;
    public static final byte TOTAL_PLANETS = 4;
    private Image[] imgShipEnemy = new Image[2];
    private Image imgFinishLine;
    private Image imgGateUp;
    private Image imgGateDown;
    private Image imgShield;
    private Image imgShieldIcon;
    private Image imgAsteroid1;
    private Image imgAsteroid2;
    public static Sprite sprPlayer;
    private Sprite sprExplosion;
    private Sprite sprSmallExplosion;
    private Sprite sprShield;
    public static Rectangle playerRectangle;
    Rectangle[] enemyRectangle = new Rectangle[6];
    Rectangle finishRectangle;
    private int iGap;
    private static int onePixel;
    public boolean bGameOver;
    public boolean bPause;
    public boolean bNewBest;
    public int iCircleX;
    public int iCircleY;
    public int iCircleYSecond;
    private int iShipEnemyHeight;
    private int iShipEnemyWidth;
    private int iShipPlayerX;
    private int iShipPlayerY;
    private int iShipRadius;
    private int iShiftRadiusDown;
    private int iShiftRadiusUp;
    private int iRadiusShiftSteps = 12;
    private int iRadiusCounter;
    private int iGateUpRadius;
    private int iGateDownRadius;
    private int iPlayerAngle;
    public int iPlayerSpeed;
    int expFrameDuration = 80;
    int expActFrameDuration = 0;
    int expActFrame = 0;
    private static final byte MAX_EXPLOSION_FRAMES = 6;
    private int iScore;
    private int playMode;
    private int survivalCount;
    private int timeCount;
    private int gameTime = 0;
    private int asteroidsCount;
    private int destroyedAsteroids;
    private int shieldAngle;
    private int shieldSpeed;
    private int shieldPosition;
    private int shieldDirection;
    private int shieldDestroyFrame;
    private int destroyCounter;
    private int maxEnemyShips = 0;
    private int level = 0;
    private boolean bScoreAdd;
    private boolean bFinishPassed;
    private boolean brakeDisabled;
    private boolean isSuccessfully = false;
    private boolean hasShield = false;
    private boolean isShieldDestroyed = false;
    private boolean createdShield = false;
    private boolean createEnemy = false;
    private boolean isSpeedMode = false;
    public static boolean backMode;
    private Vector asteroids = new Vector();
    private Vector enemies = new Vector();
    private Rectangle rectShieldIcon = new Rectangle();
    private Rectangle rectDestroy = null;
    private String questTxt;
    static final Random randGenerator;
    private long timer;
    public static final int MODE_SURVIVAL = 0;
    public static final int MODE_FLY = 1;
    public static final int MODE_FLY_FAST = 2;
    public static final int MODE_ASTEROIDS = 3;
    public static final int MODE_DESTROY = 4;
    public static final int MODE_SURVIVAL_NO_BRAKE = 5;
    public static final int MODE_DESTROY_NO_BRAKE = 6;
    public static final int MODE_FLY_NO_BRAKE = 7;
    public static boolean[] directMode;
    public static int[] questLevel;
    public static int[] questDetailLevel;
    public static boolean speedDragged;
    public static int[][] timeGeneratePlane;
    public static int[][] timeGenerateShield;
    public static int[] startCountPlanes;
    public static int[] maxCountPlanes;
    private long genShieldSec = -1L;
    private long genPlaneSec = -1L;
    private long lastGenPlaneSec = -1L;
    int smallExplDuration = 80;
    int smallFrameDuration = 0;
    int smallCurrFrame = 0;
    private int xAsteroidResult;
    private int yAsteroidResult;
    private int typeAsteroid;
    private int xMoveAsteroidResult;
    private int yMoveAsteroidResult;
    public static Asteroid asteroidBackground;
    private boolean isDown;
    private boolean isRight;

    public Game(ScreenMain screen) {
        System.out.println("new game");
        this.gameScreen = screen;
    }

    static final int getRandomInt(int max) {
        return randGenerator.nextInt() % max;
    }

    static final int getRandomUInt(int max) {
        return Math.abs(randGenerator.nextInt() % max);
    }

    public void initFirst() {
        this.iPlayerAngle = 0;
        this.resetPlayerSpeed();
        this.iScore = 0;
        sprPlayer = Resources.resSprs[1];
        this.sprExplosion = Resources.resSprs[3];
        this.sprSmallExplosion = Resources.resSprs[6];
        this.sprShield = Resources.resSprs[5];
        this.imgShipEnemy[0] = Resources.resImgs[3];
        this.imgShipEnemy[1] = Resources.resImgs[34];
        this.imgFinishLine = Resources.resImgs[2];
        this.imgGateUp = Resources.resImgs[31];
        this.imgGateDown = Resources.resImgs[16];
        this.imgShield = Resources.resImgs[35];
        this.imgAsteroid1 = Resources.resImgs[36];
        this.imgAsteroid2 = Resources.resImgs[37];
        this.imgShieldIcon = Resources.resImgs[38];
        this.iCircleX = this.gameScreen.iCircleX;
        this.iCircleY = this.gameScreen.iCircleY;
        this.iCircleYSecond = this.gameScreen.iCircleYSecond;
        this.iRadiusCounter = 0;
        this.iShiftRadiusDown = 0;
        this.iShiftRadiusUp = 0;
        onePixel = ScreenMain.onePixel;
        this.iGap = ScreenMain.onePixel << 1;
        this.iShipEnemyHeight = this.imgShipEnemy[0].getHeight();
        this.iShipEnemyWidth = this.imgShipEnemy[0].getWidth();
        this.iShipPlayerX = this.iCircleX;
        this.iShipPlayerY = this.iCircleY;
        this.iShipRadius = MainCanvas.HEIGHT >> 2;
        this.iGateUpRadius = (MainCanvas.HEIGHT >> 2) + (this.imgFinishLine.getWidth() >> 1) + (this.imgFinishLine.getWidth() >> 2) + (this.imgGateUp.getWidth() >> 2);
        this.iGateDownRadius = (MainCanvas.HEIGHT >> 2) - (this.imgFinishLine.getWidth() >> 1) - (this.imgFinishLine.getWidth() >> 2) - (this.imgGateUp.getWidth() >> 2);
        this.setNewPlayMode();
    }

    public void resetDataBeforePlay() {
        System.out.println("reset data");
        if (this.bGameOver) {
            System.out.println("novy mod");
        }
        this.setNewPlayMode();
        this.iPlayerAngle = 0;
        this.resetPlayerSpeed();
        this.iScore = 0;
        this.iShiftRadiusDown = 0;
        this.iShiftRadiusUp = 0;
        this.expActFrameDuration = 0;
        this.expActFrame = 0;
        this.resetEnemy();
        playerRectangle = new Rectangle(0, 0, 0, 0);
        this.bGameOver = false;
        this.bPause = false;
        this.bNewBest = false;
        this.bFinishPassed = false;
        this.bScoreAdd = false;
        this.timer = 0L;
        ScreenMain.resultTime = 0;
        this.genShieldSec = -1L;
        ScreenMain.resultSteps[0] = false;
        ScreenMain.resultSteps[1] = false;
        ScreenMain.resultSteps[2] = false;
        ScreenMain.resultSteps[3] = false;
        ScreenMain.resultSteps[4] = false;
    }

    public void resetEnemy() {
        for (int i = 0; i < 6; ++i) {
            this.enemyRectangle[i] = null;
        }
        this.enemies.removeAllElements();
    }

    public void paint(Graphics g) {
        switch (this.gameScreen.subScreen) {
            case 0: {
                if (ScreenMain.isShowingQuest) {
                    this.paintQuest(g);
                    break;
                }
                this.paintFinish(g);
                if (!this.bGameOver) {
                    this.paintShipPlayer(g, this.iPlayerAngle);
                } else {
                    this.gameScreen.paintCircles(g);
                }
                switch (this.playMode) {
                    case 0: 
                    case 5: {
                        this.paintScore(g);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 7: {
                        this.paintScore(g);
                        break;
                    }
                    case 3: {
                        this.paintAsteroids(g);
                        this.paintScore(g);
                        break;
                    }
                    case 4: 
                    case 6: {
                        this.paintScore(g);
                    }
                }
                if (!this.bGameOver) {
                    for (int index = 0; index < this.enemies.size(); ++index) {
                        Enemy enemy = (Enemy)this.enemies.elementAt(index);
                        this.paintShipEnemy(g, index, enemy.getAngle() + enemy.getPosition(), this.imgShipEnemy[enemy.getType()]);
                    }
                    if (this.createdShield) {
                        this.paintShieldIcon(g, this.shieldAngle + this.shieldPosition);
                    }
                }
                this.paintExplosion(g, this.iPlayerAngle);
                if (this.rectDestroy == null) break;
                this.paintSmallExplosion(g, this.iPlayerAngle);
                break;
            }
            case 2: {
                if (this.gameScreen.iResultStep <= 1) break;
                this.gameScreen.paintGameOver(g);
                break;
            }
        }
    }

    public void updatePlayer() {
        if (this.iPlayerAngle >= 360) {
            this.iPlayerAngle = 0;
        } else if (this.iPlayerAngle <= 0) {
            this.iPlayerAngle = 360;
        }
        this.iPlayerAngle += this.iPlayerSpeed;
    }

    public void updateAngle() {
        for (int index = 0; index < this.enemies.size(); ++index) {
            Enemy enemy = (Enemy)this.enemies.elementAt(index);
            if (enemy.getDirection() == 0) {
                enemy.setAngle(4 + enemy.getSpeed());
                continue;
            }
            enemy.setAngle(-(4 + enemy.getSpeed()));
        }
        if (this.createdShield) {
            this.shieldAngle = this.shieldDirection == 0 ? (this.shieldAngle += 4 + this.shieldSpeed) : (this.shieldAngle -= 4 + this.shieldSpeed);
        }
    }

    public void update(long dt) {
        switch (this.gameScreen.subScreen) {
            case 0: {
                if (ScreenMain.isShowingQuest && (ScreenMain.showingCounter = (int)((long)ScreenMain.showingCounter - dt)) <= 0 && ScreenMain.isShowingQuest) {
                    int j;
                    ScreenMain.isShowingQuest = false;
                    for (j = 0; j < timeGeneratePlane[this.level].length; ++j) {
                        System.out.print("generate plane: " + timeGeneratePlane[this.level][j] + ", ");
                    }
                    for (j = 0; j < timeGenerateShield[this.level].length; ++j) {
                        System.out.println("generate shield: " + timeGenerateShield[this.level][j] + ", ");
                    }
                }
                if (!this.bGameOver && !this.bPause) {
                    this.updatePlayer();
                    this.updateAngle();
                    this.updateMode(dt);
                    this.intersect();
                    this.updateEnemiesPos();
                    if (this.isShieldDestroyed) {
                        this.updateShieldDestroy();
                    }
                    if (this.rectDestroy != null) {
                        this.updateSmallExplosion(dt);
                    }
                    this.timer += dt;
                } else {
                    this.updateCollision(dt);
                    if (this.rectDestroy != null) {
                        this.updateSmallExplosion(dt);
                    }
                }
                this.updateGameOver();
                if (!this.bFinishPassed) break;
                this.updateFinish();
                break;
            }
            case 2: {
                this.genShieldSec = -1L;
                this.gameScreen.updateBlink(dt);
                this.gameScreen.updateResult(dt);
                if (asteroidBackground == null) {
                    this.generateAsteroidBackground();
                    break;
                }
                this.updateAsteroidBackgroundScreen();
            }
        }
    }

    public void intersect() {
        int i;
        if (playerRectangle == null) {
            return;
        }
        for (i = 0; i < this.enemies.size(); ++i) {
            if (!playerRectangle.intersects(((Enemy)this.enemies.elementAt(i)).getRectEnemy())) continue;
            if (this.hasShield) {
                this.rectDestroy = ((Enemy)this.enemies.elementAt(i)).getRectEnemy();
                this.enemies.removeElementAt(i);
                this.hasShield = false;
                this.isShieldDestroyed = true;
                --this.destroyCounter;
                this.genShieldSec = this.timer;
                if (this.maxEnemyShips != maxCountPlanes[this.getTransformLevel(this.level)]) continue;
                this.lastGenPlaneSec = this.timer;
                continue;
            }
            this.isSuccessfully = false;
            this.bGameOver = true;
        }
        for (i = 0; i < this.asteroids.size(); ++i) {
            Asteroid asteroid = (Asteroid)this.asteroids.elementAt(i);
            if (!asteroid.intersectWithPlayer(playerRectangle)) continue;
            this.rectDestroy = ((Asteroid)this.asteroids.elementAt(i)).getRectAsteroid();
            if (this.hasShield) {
                this.hasShield = false;
                this.isShieldDestroyed = true;
                ++this.destroyedAsteroids;
            } else {
                this.isSuccessfully = false;
                this.bGameOver = true;
            }
            this.asteroids.removeElementAt(i);
        }
        this.scoreAdd();
        if (playerRectangle.intersects(this.rectShieldIcon)) {
            this.hasShield = true;
            this.createdShield = false;
            this.rectShieldIcon = new Rectangle(0, 0, 0, 0);
        }
    }

    public void updateCollision(long dt) {
        if (this.bGameOver) {
            if (this.expActFrame < 6 && this.expActFrameDuration > this.expFrameDuration) {
                this.expActFrameDuration = 0;
                ++this.expActFrame;
            }
            this.expActFrameDuration = (int)((long)this.expActFrameDuration + dt);
        }
    }

    public void paintExplosion(Graphics g, int angle) {
        if (this.bGameOver && !this.isSuccessfully) {
            return;
        }
    }

    public void paintShipPlayer(Graphics g, int angle) {
        playerRectangle = new Rectangle(this.iShipPlayerX + (this.iShipRadius * ArrayAngles.cos(angle) >> 8) - (this.iShipEnemyWidth >> 1), this.iShipPlayerY + (this.iShipRadius * ArrayAngles.sin(angle) >> 8) - (this.iShipEnemyHeight >> 1), this.iShipEnemyWidth, this.iShipEnemyHeight);
        int frame = 0;
        if (this.hasShield) {
            this.paintShield(g);
        } else if (this.isShieldDestroyed) {
            this.paintShieldDestroyAnim(g);
        }
        this.gameScreen.paintCircles(g);
        frame = this.iPlayerSpeed > 4 ? (angle >= 0 && angle < 90 ? 4 : (angle >= 90 && angle < 180 ? 2 : (angle >= 180 && angle < 270 ? 1 : 3))) : (this.iPlayerSpeed < -4 ? (angle >= 0 && angle < 90 ? 1 : (angle >= 90 && angle < 180 ? 3 : (angle >= 180 && angle < 270 ? 4 : 2))) : 0);
        this.setSpritePlayer(frame, g, angle);
    }

    public void paintShipEnemy(Graphics g, int enemyNumber, int angle, Image img) {
        this.iShipEnemyHeight = img.getHeight();
        this.iShipEnemyWidth = img.getWidth();
        g.drawImage(img, this.iShipPlayerX + (this.iShipRadius * ArrayAngles.cos(angle) >> 8), this.iCircleYSecond + (this.iShipRadius * ArrayAngles.sin(angle) >> 8), 3);
    }

    public void paintFinish(Graphics g) {
        this.finishRectangle = new Rectangle(this.iCircleX + ((this.iShipRadius + (sprPlayer.getWidth() >> 1)) * ArrayAngles.cos(224L) >> 8), this.iCircleY + (this.iShipRadius * ArrayAngles.sin(224L) >> 8), this.iShipEnemyHeight, 1);
        g.drawImage(this.imgFinishLine, this.iCircleX + (this.iShipRadius * ArrayAngles.cos(224L) >> 8), this.iCircleY + (this.iShipRadius * ArrayAngles.sin(224L) >> 8), 3);
        g.drawImage(this.imgGateUp, this.iCircleX + ((this.iGateUpRadius + this.iShiftRadiusUp) * ArrayAngles.cos(225L) >> 8), this.iCircleY + ((this.iGateUpRadius + this.iShiftRadiusUp) * ArrayAngles.sin(224L) >> 8), 3);
        g.drawImage(this.imgGateDown, this.iCircleX + ((this.iGateDownRadius + this.iShiftRadiusDown) * ArrayAngles.cos(225L) >> 8), this.iCircleY + ((this.iGateDownRadius + this.iShiftRadiusDown) * ArrayAngles.sin(224L) >> 8), 3);
    }

    public void updateFinish() {
        if (this.iRadiusCounter < this.iRadiusShiftSteps) {
            int len = this.imgGateUp.getWidth() >> 4 <= 0 ? 1 : this.imgGateUp.getWidth() >> 4;
            if (this.iRadiusCounter < 6) {
                this.iShiftRadiusDown += len;
                this.iShiftRadiusUp -= len;
            } else {
                this.iShiftRadiusDown -= len;
                this.iShiftRadiusUp += len;
            }
            ++this.iRadiusCounter;
        } else {
            this.bFinishPassed = false;
            this.iRadiusCounter = 0;
        }
    }

    public boolean isGameOver() {
        return this.bGameOver;
    }

    public void saveGame() {
        Profile.playMode = this.playMode;
        Profile.level = this.level;
        this.bNewBest = true;
        Profile.save();
    }

    private void paintScore(Graphics g) {
        String s = "";
        switch (this.playMode) {
            case 0: 
            case 5: {
                if (this.iScore < 0) break;
                s = this.iScore + "";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                s = this.timeCount + "";
                break;
            }
            case 3: {
                s = this.asteroidsCount - this.destroyedAsteroids + "";
                break;
            }
            case 4: 
            case 6: {
                s = this.destroyCounter + "";
            }
        }
        this.gameScreen.fontMain.drawString(g, s.toCharArray(), 0 + (onePixel << 1), 0 + onePixel, 20);
    }

    public int getScore() {
        return this.iScore;
    }

    private void updateGameOver() {
        if (this.bGameOver) {
            this.timer = 0L;
            this.genShieldSec = -1L;
            if (this.isSuccessfully && this.rectDestroy == null) {
                ScreenMain.selectOptionResult = 0;
                this.gameScreen.getClass();
                this.gameScreen.nextScreen(2, 2);
            }
            if (this.expActFrame == 6 && this.rectDestroy == null) {
                ScreenMain.selectOptionResult = 0;
                this.gameScreen.getClass();
                this.gameScreen.nextScreen(2, 2);
            }
        }
    }

    private void paintQuest(Graphics g) {
        int x = (MainCanvas.WIDTH >> 1) - onePixel;
        int y = 0 + onePixel;
        int width = MainCanvas.WIDTH >> 1;
        PreparedText text = new PreparedText(this.gameScreen.fontMain);
        text.prepareText(this.questTxt, width);
        int height = text.getTextHeight();
        Rectangle rectQuestText = new Rectangle(x, y, width, height);
        text.drawText(g, rectQuestText, 24);
    }

    private void paintShield(Graphics g) {
        g.drawImage(this.imgShield, playerRectangle.getCenterX(), playerRectangle.getCenterY(), 3);
    }

    private void paintShieldDestroyAnim(Graphics g) {
        this.sprShield.setFrame(this.shieldDestroyFrame);
        this.sprShield.setPosition(playerRectangle.getCenterX() - (this.sprShield.getWidth() >> 1), playerRectangle.getCenterY() - (this.sprShield.getHeight() >> 1));
        this.sprShield.paint(g);
    }

    public void setNewPlayMode() {
        System.out.println("SET NEW PLAY MODE");
        this.generateNewPlayMode(this.getTransformLevel(this.level));
        this.isSuccessfully = false;
        this.initNewPlayMode();
    }

    public int getPlayMode() {
        return this.playMode;
    }

    private void initNewPlayMode() {
        System.out.println("init new game");
        this.enemies.removeAllElements();
        this.asteroids.removeAllElements();
        this.hasShield = false;
        this.isShieldDestroyed = false;
        this.createdShield = false;
        this.maxEnemyShips = 0;
        this.isSpeedMode = false;
        this.rectShieldIcon = new Rectangle(0, 0, 0, 0);
        this.brakeDisabled = false;
        this.genPlaneSec = 0L;
        this.genShieldSec = 0L;
        this.lastGenPlaneSec = 0L;
        if (Profile.playMode == -1) {
            Profile.playMode = this.generateNewPlayMode(0);
            Profile.save();
        }
        this.playMode = Profile.playMode;
        this.level = Profile.level;
        backMode = directMode[this.getTransformLevel(this.level)];
        switch (this.playMode) {
            case 0: 
            case 5: {
                this.survivalCount = questDetailLevel[this.getTransformLevel(this.level)];
                if (this.playMode != 5) break;
                this.brakeDisabled = true;
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                this.timeCount = questDetailLevel[this.getTransformLevel(this.level)];
                if (this.playMode == 7) {
                    this.brakeDisabled = true;
                    break;
                }
                if (this.playMode != 2) break;
                this.isSpeedMode = true;
                break;
            }
            case 3: {
                this.destroyedAsteroids = 0;
                this.asteroidsCount = questDetailLevel[this.getTransformLevel(this.level)];
                break;
            }
            case 4: 
            case 6: {
                this.destroyCounter = questDetailLevel[this.getTransformLevel(this.level)];
                if (this.playMode != 6) break;
                this.brakeDisabled = true;
            }
        }
        this.gameTime = 0;
        this.questTxt = this.gameScreen.getQuest(this.getTransformLevel(this.level));
    }

    private void updateMode(long time) {
        if (!this.isSpeedMode) {
            this.gameTime = (int)((long)this.gameTime + time);
        } else if (speedDragged) {
            this.gameTime = (int)((long)this.gameTime + time);
        }
        switch (this.playMode) {
            case 0: 
            case 5: {
                if (this.survivalCount != this.getScore()) break;
                this.isSuccessfully = true;
                this.bGameOver = true;
                break;
            }
            case 1: 
            case 7: {
                if (this.gameTime % 1000 < 40 && this.gameTime > 100) {
                    --this.timeCount;
                }
                if (this.timeCount > 0) break;
                this.isSuccessfully = true;
                this.bGameOver = true;
                break;
            }
            case 2: {
                if (this.gameTime % 1000 < 40 && this.gameTime > 100 && speedDragged) {
                    --this.timeCount;
                }
                if (this.timeCount > 0) break;
                this.isSuccessfully = true;
                this.bGameOver = true;
                break;
            }
            case 3: {
                this.updateAsteroids(time);
                if (this.asteroidsCount != this.destroyedAsteroids || !this.asteroids.isEmpty()) break;
                this.isSuccessfully = true;
                this.bGameOver = true;
                break;
            }
            case 4: 
            case 6: {
                if (this.destroyCounter != 0 || this.rectDestroy != null) break;
                this.isSuccessfully = true;
                this.bGameOver = true;
            }
        }
        if (this.isSuccessfully) {
            ++this.level;
            this.playMode = this.generateNewPlayMode(this.getTransformLevel(this.level));
            this.saveGame();
            Profile.load();
            this.gameScreen.initGame();
        }
        if (timeGenerateShield[this.getTransformLevel(this.level)][0] > -1) {
            if (this.timer >= (long)(timeGenerateShield[this.getTransformLevel(this.level)][0] * 1000) && this.timer < (long)(timeGenerateShield[this.getTransformLevel(this.level)][0] * 1000 + 40)) {
                this.generateShieldIcon();
            } else if (this.timer >= (long)(timeGenerateShield[this.getTransformLevel(this.level)][1] * 1000) + this.genShieldSec && this.timer < (long)(timeGenerateShield[this.getTransformLevel(this.level)][1] * 1000) + this.genShieldSec + 40L && this.genShieldSec != -1L) {
                this.genShieldSec = -1L;
                this.generateShieldIcon();
            }
        }
    }

    private void setSpritePlayer(int frame, Graphics g, int angle) {
        sprPlayer.setFrame(frame);
        sprPlayer.setPosition(this.iShipPlayerX - (sprPlayer.getWidth() >> 1) + (this.iShipRadius * ArrayAngles.cos(angle) >> 8), this.iShipPlayerY - (sprPlayer.getHeight() >> 1) + (this.iShipRadius * ArrayAngles.sin(angle) >> 8));
        sprPlayer.paint(g);
    }

    private void generateAsteroids() {
        int xStop;
        int y = MainCanvas.HEIGHT + (MainCanvas.HEIGHT >> 2);
        int yStop = -this.imgAsteroid1.getHeight();
        int x = (MainCanvas.WIDTH >> 1) + Game.getRandomInt(MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2));
        int type = Game.getRandomUInt(150) % 2;
        int findMaxWidth = 100;
        if (x > MainCanvas.WIDTH >> 1) {
            xStop = (MainCanvas.WIDTH >> 1) - Game.getRandomUInt(MainCanvas.WIDTH >> 3);
            xStop = x - findMaxWidth;
        } else {
            xStop = (MainCanvas.WIDTH >> 1) + Game.getRandomUInt(MainCanvas.WIDTH >> 3);
            xStop = x + findMaxWidth;
        }
        int diffPosAsteroid = Math.abs(x - xStop);
        if (diffPosAsteroid < (this.imgAsteroid1.getWidth() << 1) + this.imgAsteroid1.getWidth()) {
            int diff = (this.imgAsteroid1.getWidth() << 1) - diffPosAsteroid >> 1;
            if (x < MainCanvas.WIDTH >> 1) {
                x -= diff;
                xStop += diff;
            } else {
                x += diff;
                xStop -= diff;
            }
        }
        Asteroid asteroid = new Asteroid(x, y, type, this.imgAsteroid1.getWidth(), this.imgAsteroid1.getHeight(), xStop, yStop);
        this.asteroids.addElement(asteroid);
    }

    private void updateAsteroids(long time) {
        this.gameTime = (int)((long)this.gameTime + time);
        if (this.gameTime % 4000 < 40 && this.gameTime > 100 && this.destroyedAsteroids != this.asteroidsCount && this.asteroids.isEmpty()) {
            this.generateAsteroids();
        }
        this.updateAsteroidsPos(0, 0, -1);
    }

    private void updateAsteroidsPos(int xMove, int yMove, int rekursionIndex) {
        int start = 0;
        int end = this.asteroids.size();
        if (rekursionIndex > -1) {
            start = rekursionIndex;
            end = rekursionIndex + 1;
        }
        if (!this.asteroids.isEmpty()) {
            for (int index = start; index < end; ++index) {
                Asteroid asteroid = (Asteroid)this.asteroids.elementAt(index);
                int yDiff = asteroid.getY() - asteroid.getYStop();
                int xDiff = asteroid.getX() - asteroid.getXStop();
                if (yDiff == 0) {
                    yMove = 0;
                }
                if (xDiff == 0) {
                    xMove = 0;
                }
                yMove = asteroid.getY() - asteroid.getYMove();
                xMove = asteroid.getX() + asteroid.getXMove();
                asteroid.setY(yMove);
                asteroid.setX(xMove);
                asteroid.setRect(xMove, yMove);
                if (asteroid.getRectAsteroid().getBottom() < asteroid.getYStop()) {
                    this.asteroids.removeElementAt(index);
                    ++this.destroyedAsteroids;
                }
                asteroid.intersectWithPlayer(playerRectangle);
            }
        }
    }

    private void paintAsteroids(Graphics g) {
        if (!this.asteroids.isEmpty()) {
            for (int index = 0; index < this.asteroids.size(); ++index) {
                Asteroid asteroid = (Asteroid)this.asteroids.elementAt(index);
                if (asteroid.getType() == 0) {
                    g.drawImage(this.imgAsteroid1, asteroid.getX(), asteroid.getY(), 3);
                    continue;
                }
                g.drawImage(this.imgAsteroid2, asteroid.getX(), asteroid.getY(), 3);
            }
        }
    }

    private void paintShieldIcon(Graphics g, int angle) {
        int height = this.imgShieldIcon.getHeight();
        int width = this.imgShieldIcon.getWidth();
        g.drawImage(this.imgShieldIcon, this.iShipPlayerX + (this.iShipRadius * ArrayAngles.cos(angle) >> 8), this.iCircleYSecond + (this.iShipRadius * ArrayAngles.sin(angle) >> 8), 3);
        this.rectShieldIcon = new Rectangle(this.iShipPlayerX + (this.iShipRadius * ArrayAngles.cos(angle) >> 8) - (width >> 1) + onePixel, this.iCircleYSecond + (this.iShipRadius * ArrayAngles.sin(angle) >> 8) - (height >> 1) + onePixel, width - this.iGap, height - this.iGap);
    }

    private void generateShieldIcon() {
        System.out.println("GENERATE SHIELD");
        this.shieldAngle = 0;
        this.shieldSpeed = RandomNum.getRandomUInt(4) - 3;
        this.shieldPosition = RandomNum.getRandomUInt(180);
        this.shieldDirection = RandomNum.getRandomUInt(2);
        this.createdShield = true;
    }

    private void updateEnemiesPos() {
        if (this.timer < 40L) {
            for (int count = 0; count < startCountPlanes[this.getTransformLevel(this.level)]; ++count) {
                System.out.println("generovanie na zaciatku");
                this.generateEnemy();
            }
            if (this.maxEnemyShips == 0) {
                this.genPlaneSec = timeGeneratePlane[this.getTransformLevel(this.level)][0];
            }
            this.createEnemy = false;
        }
        if (this.enemies.size() < maxCountPlanes[this.getTransformLevel(this.level)] && this.timer >= this.lastGenPlaneSec + this.genPlaneSec * 1000L && this.timer < this.lastGenPlaneSec + this.genPlaneSec * 1000L + 40L) {
            this.generateEnemy();
            this.createEnemy = false;
        }
        for (int index = 0; index < this.enemies.size(); ++index) {
            Enemy enemy = (Enemy)this.enemies.elementAt(index);
            int angle = enemy.getAngle() + enemy.getPosition();
            ((Enemy)this.enemies.elementAt((int)index)).getRectEnemy().x = this.iShipPlayerX + (this.iShipRadius * ArrayAngles.cos(angle) >> 8) - (this.iShipEnemyWidth >> 1) + onePixel;
            ((Enemy)this.enemies.elementAt((int)index)).getRectEnemy().y = this.iCircleYSecond + (this.iShipRadius * ArrayAngles.sin(angle) >> 8) - (this.iShipEnemyHeight >> 1) + onePixel;
        }
    }

    private void generateEnemy() {
        int width = this.iShipEnemyWidth - this.iGap;
        int height = this.iShipEnemyHeight - this.iGap;
        int position = RandomNum.getRandomUInt(180);
        int speed = RandomNum.getRandomUInt(4) - 3;
        int direction = RandomNum.getRandomUInt(2);
        int type = RandomNum.getRandomUInt(2);
        Enemy enemy = new Enemy(0, position, speed, direction, type, width, height);
        this.enemies.addElement(enemy);
        if (this.enemies.size() <= maxCountPlanes[this.getTransformLevel(this.level)]) {
            if (this.enemies.size() <= startCountPlanes[this.getTransformLevel(this.level)]) {
                this.genPlaneSec = timeGeneratePlane[this.getTransformLevel(this.level)][0];
            } else if (this.enemies.size() == maxCountPlanes[this.getTransformLevel(this.level)]) {
                this.maxEnemyShips = this.enemies.size();
                this.genPlaneSec = timeGeneratePlane[this.getTransformLevel(this.level)][this.maxEnemyShips - startCountPlanes[this.getTransformLevel(this.level)] - 1];
            } else if (this.enemies.size() < this.maxEnemyShips + 1) {
                --this.maxEnemyShips;
                this.genPlaneSec = timeGeneratePlane[this.getTransformLevel(this.level)][this.maxEnemyShips - startCountPlanes[this.getTransformLevel(this.level)]];
            } else {
                this.genPlaneSec = timeGeneratePlane[this.getTransformLevel(this.level)][this.maxEnemyShips - startCountPlanes[this.getTransformLevel(this.level)]];
            }
            this.lastGenPlaneSec = this.timer;
        }
        ++this.maxEnemyShips;
        this.lastGenPlaneSec = this.timer;
    }

    private void updateShieldDestroy() {
        if (this.timer % 200L < 40L) {
            ++this.shieldDestroyFrame;
            if (this.shieldDestroyFrame > 3) {
                this.shieldDestroyFrame = 0;
                this.isShieldDestroyed = false;
            }
        }
    }

    public boolean isSpeedMode() {
        return this.isSpeedMode();
    }

    public boolean isSuccessfuly() {
        return this.isSuccessfully;
    }

    public int generateNewPlayMode(int index) {
        return questLevel[index];
    }

    public void paintSmallExplosion(Graphics g, int angle) {
        if (this.rectDestroy != null) {
            return;
        }
    }

    private void updateSmallExplosion(long time) {
        if (this.smallCurrFrame < 6 && this.smallFrameDuration > this.smallExplDuration) {
            this.smallFrameDuration = 0;
            ++this.smallCurrFrame;
        }
        this.smallFrameDuration = (int)((long)this.smallFrameDuration + time);
    }

    public void paintAsteroidBackgroundScreen(Graphics g) {
        if (asteroidBackground != null) {
            switch (asteroidBackground.getType()) {
                case 1: {
                    g.drawImage(this.imgAsteroid1, asteroidBackground.getX(), asteroidBackground.getY(), 20);
                    break;
                }
                case 2: {
                    g.drawImage(this.imgAsteroid2, asteroidBackground.getX(), asteroidBackground.getY(), 20);
                }
            }
        }
    }

    public void updateAsteroidBackgroundScreen() {
        int x = asteroidBackground.getX() + this.xMoveAsteroidResult;
        int y = asteroidBackground.getY() + this.yMoveAsteroidResult;
        asteroidBackground.setRect(x + (this.imgAsteroid1.getWidth() >> 1), y + (this.imgAsteroid1.getHeight() >> 1));
        asteroidBackground.setX(x);
        asteroidBackground.setY(y);
        if (this.isDown) {
            if (Game.asteroidBackground.getRectAsteroid().y > MainCanvas.HEIGHT) {
                asteroidBackground = null;
                return;
            }
        } else if (asteroidBackground.getRectAsteroid().getBottom() < 0) {
            asteroidBackground = null;
            return;
        }
        if (this.isRight) {
            if (Game.asteroidBackground.getRectAsteroid().x > MainCanvas.WIDTH) {
                asteroidBackground = null;
            }
        } else if (asteroidBackground.getRectAsteroid().getRight() < 0) {
            asteroidBackground = null;
        }
    }

    public void generateAsteroidBackground() {
        int randX = Game.getRandomInt(MainCanvas.WIDTH >> 2);
        int randY = Game.getRandomInt(MainCanvas.HEIGHT >> 2);
        this.isRight = true;
        this.isDown = true;
        this.xAsteroidResult = randX < 0 ? randX - this.imgAsteroid1.getWidth() : MainCanvas.WIDTH + randX + (this.imgAsteroid1.getWidth() >> 1);
        this.yAsteroidResult = randY < 0 ? randX - this.imgAsteroid1.getHeight() : MainCanvas.HEIGHT + randY + (this.imgAsteroid1.getHeight() >> 1);
        this.typeAsteroid = Game.getRandomUInt(1500) % 2 + 1;
        this.xMoveAsteroidResult = Game.getRandomUInt(3) + 1;
        this.yMoveAsteroidResult = Game.getRandomUInt(3) + 1;
        if (this.xAsteroidResult > MainCanvas.WIDTH >> 1) {
            this.xMoveAsteroidResult *= -1;
            this.isRight = false;
        }
        if (this.yAsteroidResult > MainCanvas.HEIGHT >> 1) {
            this.yMoveAsteroidResult *= -1;
            this.isDown = false;
        }
        int width = this.imgAsteroid1.getWidth();
        int height = this.imgAsteroid1.getHeight();
        asteroidBackground = new Asteroid(this.xAsteroidResult, this.yAsteroidResult, this.typeAsteroid, width, height, -1, -1);
    }

    public void resetPlayerSpeed() {
        this.iPlayerSpeed = backMode ? -4 : 4;
        speedDragged = false;
    }

    private void scoreAdd() {
        if (backMode) {
            if (playerRectangle.intersects(this.finishRectangle) && !this.bScoreAdd) {
                this.bFinishPassed = true;
                ++this.iScore;
                if (!this.createEnemy) {
                    this.createEnemy = true;
                }
                this.bScoreAdd = true;
            } else if (!playerRectangle.intersects(this.finishRectangle) && this.bScoreAdd) {
                this.bScoreAdd = false;
            }
        } else if (playerRectangle.intersects(this.finishRectangle) && !this.bScoreAdd) {
            this.bFinishPassed = true;
            ++this.iScore;
            if (!this.createEnemy) {
                this.createEnemy = true;
            }
            this.bScoreAdd = true;
        } else if (!playerRectangle.intersects(this.finishRectangle) && this.bScoreAdd) {
            this.bScoreAdd = false;
        }
    }

    public boolean isBrakeDisabled() {
        return this.brakeDisabled;
    }

    public void nextLevel() {
        ++this.level;
        Profile.level = this.level;
        Profile.playMode = this.generateNewPlayMode(this.getTransformLevel(this.level));
        Profile.save();
    }

    public void previousLevel() {
        if (this.level > 0) {
            --this.level;
        }
        Profile.level = this.level;
        Profile.playMode = this.generateNewPlayMode(this.getTransformLevel(this.level));
        Profile.save();
    }

    public int getLevel() {
        return this.level;
    }

    public int getTransformLevel(int level) {
        if (level >= 50) {
            level = level % 25 + 25;
        }
        return level;
    }

    static {
        backMode = false;
        randGenerator = new Random();
        directMode = new boolean[]{false, false, false, false, false, false, true, false, false, false, true, false, false, false, false, false, true, false, false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, true, false, false, false, false};
        questLevel = new int[]{0, 3, 1, 2, 4, 0, 5, 1, 3, 4, 5, 1, 0, 4, 3, 1, 5, 1, 4, 0, 3, 5, 1, 3, 4, 0, 1, 0, 2, 5, 4, 3, 0, 1, 0, 4, 0, 1, 4, 5, 3, 2, 4, 0, 1, 7, 0, 3, 0, 4};
        questDetailLevel = new int[]{10, 3, 45, 20, 1, 13, 8, 60, 5, 2, 9, 70, 13, 2, 5, 80, 10, 90, 3, 15, 6, 8, 60, 6, 3, 16, 90, 16, 25, 9, 4, 6, 17, 90, 18, 4, 18, 100, 4, 10, 6, 30, 4, 20, 100, 30, 22, 6, 25, 5};
        timeGeneratePlane = new int[][]{{6, 6, 6}, {7, 7, 7}, {8, 9, 10}, {7, 8, 9, 10}, {1, 7, 8, 9, 10}, {7, 8, 9, 10}, {8, 9, 10}, {7, 8, 10, 13}, {7, 8, 9, 10}, {7, 8, 9, 10}, {7, 8, 9}, {9, 9, 9}, {8, 9, 10}, {8, 8, 8, 8}, {7, 8, 9, 10}, {7, 8, 9}, {8, 9, 10}, {7, 8, 9}, {7, 9, 11, 13}, {7, 9, 11, 13, 15}, {7, 8, 9, 10}, {8, 9, 10}, {3, 8, 10, 12, 15}, {7, 8, 9, 10}, {7, 8, 9, 10}, {3, 8, 10, 12, 15}, {3, 8, 10, 12}, {3, 8, 10, 12, 15}, {3, 8, 10, 12}, {8, 9, 10}, {7, 8, 9, 10}, {7, 8, 9, 10}, {3, 8, 10, 12, 15}, {3, 8, 10, 12}, {3, 8, 10, 12, 15}, {7, 8, 9, 10}, {3, 8, 10, 12, 15}, {3, 8, 10, 12}, {7, 8, 9, 10}, {8, 9, 10}, {7, 8, 9, 10}, {3, 8, 10, 12}, {7, 8, 9, 10}, {3, 8, 10, 12, 15}, {3, 8, 10, 12}, {3, 8, 10, 12}, {3, 8, 10, 12, 15}, {7, 8, 9, 10}, {3, 8, 10, 12, 15}, {7, 8, 9, 10, 11}};
        timeGenerateShield = new int[][]{{-1, -1}, {-1, -1}, {5, 5}, {5, 5}, {12, 5}, {5, 5}, {4, 4}, {5, 5}, {7, 7}, {12, 5}, {5, 5}, {6, 6}, {8, 6}, {10, 6}, {8, 5}, {7, 6}, {7, 6}, {7, 6}, {10, 7}, {6, 7}, {10, 5}, {6, 6}, {5, 5}, {7, 7}, {12, 8}, {6, 6}, {5, 5}, {6, 6}, {5, 5}, {6, 6}, {11, 7}, {8, 8}, {7, 6}, {5, 5}, {7, 6}, {12, 7}, {7, 6}, {5, 5}, {12, 7}, {6, 6}, {7, 7}, {5, 5}, {12, 8}, {8, 6}, {7, 7}, {5, 5}, {8, 7}, {8, 8}, {8, 8}, {12, 9}};
        startCountPlanes = new int[]{0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1};
        maxCountPlanes = new int[]{3, 3, 4, 5, 5, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 4, 4, 4, 5, 5, 4, 3, 5, 4, 5, 5, 4, 5, 4, 3, 5, 4, 5, 4, 5, 5, 5, 4, 5, 3, 5, 4, 5, 5, 4, 4, 5, 5, 5, 6};
    }
}

