/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    public static final int IMG_LOGO_INLOGIC = 0;
    public static final int IMG_SHIP_PLAYER = 1;
    public static final int IMG_FINISH_LINE = 2;
    public static final int IMG_SHIP_1 = 3;
    public static final int IMG_PLANETA_PLAYER_1 = 4;
    public static final int IMG_PLANETA_PLAYER_2 = 5;
    public static final int IMG_LOCKON_GREEN = 6;
    public static final int IMG_LOCKON_RED = 7;
    public static final int IMG_BACK_BTN = 8;
    public static final int IMG_YES_BTN = 9;
    public static final int IMG_NO_BTN = 10;
    public static final int IMG_BG = 11;
    public static final int IMG_PLANETA_ENEMY_1 = 12;
    public static final int IMG_PLANETA_ENEMY_2 = 13;
    public static final int IMG_PLANETA_ENEMY_3 = 14;
    public static final int IMG_PLANETA_ENEMY_4 = 15;
    public static final int IMG_GATE_DOWN = 16;
    public static final int IMG_TITLE_LOGO = 17;
    public static final int IMG_BUTTON = 18;
    public static final int IMG_4_BTN = 19;
    public static final int IMG_6_BTN = 20;
    public static final int IMG_SETTINGS = 21;
    public static final int IMG_PAUSE = 22;
    public static final int IMG_PLANETA_SCORE = 23;
    public static final int IMG_EN = 24;
    public static final int IMG_FR = 25;
    public static final int IMG_DE = 26;
    public static final int IMG_ES = 27;
    public static final int IMG_IT = 28;
    public static final int IMG_PT = 29;
    public static final int IMG_SHIP_2 = 30;
    public static final int IMG_GATE_UP = 31;
    public static final int IMG_UP_BTN = 32;
    public static final int IMG_DOWN_BTN = 33;
    public static final int IMG_SHIP_3 = 34;
    public static final int IMG_SHIELD = 35;
    public static final int IMG_ASTEROID1 = 36;
    public static final int IMG_ASTEROID2 = 37;
    public static final int IMG_SHIELD_ICON = 38;
    public static final int TOTAL_IMGS = 39;
    public static Image[] resImgs = new Image[39];
    public static final int SPR_DIALOG = 0;
    public static final int SPR_SHIP_PLAYER = 1;
    public static final int SPR_BUTTON = 2;
    public static final int SPR_EXPLOSION = 3;
    public static final int SPR_ARROWS = 4;
    public static final int SPR_SHIELD_DESTROY = 5;
    public static final int SPR_SMALL_EXPLOSION = 6;
    public static final int TOTAL_SPRS = 7;
    public static Sprite[] resSprs = new Sprite[7];
    public static final int GFONT_MAIN_SMALL = 0;
    public static final int TOTAL_GFONTS = 1;
    public static GFont[] resGFonts = new GFont[1];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 1;
    private static String langDir = "/";
    public static String langCode = "";
    public static ResourceBundle[] resTexts = new ResourceBundle[1];
    public static final int TEXT_MAIN_ENABLE_MUSIC_QUESTION = 2;
    public static final int TEXT_MAIN_YES = 3;
    public static final int TEXT_MAIN_NO = 4;
    public static final int TEXT_MAIN_MENU = 5;
    public static final int TEXT_MAIN_BACK = 6;
    public static final int TEXT_MAIN_PLAY = 7;
    public static final int TEXT_MAIN_INSTRUCTIONS = 8;
    public static final int TEXT_MAIN_SOUND = 9;
    public static final int TEXT_MAIN_ABOUT = 10;
    public static final int TEXT_MAIN_LANGUAGES = 11;
    public static final int TEXT_MAIN_QUIT = 12;
    public static final int TEXT_MAIN_RESUME = 13;
    public static final int TEXT_MAIN_QUIT_TO_MENU_QUESTION = 14;
    public static final int TEXT_MAIN_ON = 15;
    public static final int TEXT_MAIN_OFF = 16;
    public static final int TEXT_MAIN_VERSION = 17;
    public static final int TEXT_MAIN_EXIT_APP_QUESTION = 18;
    public static final int TEXT_MAIN_CONTINUE = 19;
    public static final int TEXT_MAIN_PAUSE = 20;
    public static final int TEXT_MAIN_SPEED = 21;
    public static final int TEXT_MAIN_BRAKE = 22;
    public static final int TEXT_MAIN_NEW_GAME = 23;
    public static final int TEXT_MAIN_BEST = 24;
    public static final int TEXT_MAIN_CONTROLS_TEXT_TOUCH = 26;
    public static final int TEXT_MAIN_CONTROLS_TEXT_KEYBOARD = 27;
    public static final int TEXT_MAIN_AIM_OF_GAME = 28;
    public static final int TEXT_MAIN_SCORE = 29;
    public static final int TEXT_MAIN_RECORD = 30;
    public static final int TEXT_MAIN_SETTINGS = 31;
    public static final int TEXT_MAIN_RESTART = 32;
    public static final int TEXT_MAIN_OK = 33;
    public static final int TEXT_MAIN_LEVEL = 34;
    public static final int TEXT_MAIN_COMPLETED = 35;
    public static final int TEXT_MAIN_FAILED = 36;
    public static final int TEXT_MAIN_START = 37;
    public static final int TEXT_MAIN_SURVIVE = 38;
    public static final int TEXT_MAIN_ROUNDS = 39;
    public static final int TEXT_MAIN_ASTEROIDS = 40;
    public static final int TEXT_MAIN_FLY = 41;
    public static final int TEXT_MAIN_DESTROY = 42;
    public static final int TEXT_MAIN_ENEMY = 43;
    public static final int TEXT_MAIN_ENEMIES = 44;
    public static final int TEXT_MAIN_FULL_SPEED = 45;
    public static final int TEXT_MAIN_NO_BRAKES = 46;
    public static final int TEXT_MAIN_OBJECTIVE = 47;
    public static final int TEXT_MAIN_SHIELD = 48;
    public static boolean sysFont;

    public static void initGraphicsDirs(int width, int height) {
        graphicsBaseDir = "/";
        graphicsDisplayDir = "/";
    }

    public static Image createImage(String imgName) {
        Image image = null;
        try {
            System.out.println(imgName);
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (image == null) {
            System.out.println("null");
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int imgIdx) {
        String imgPath = null;
        switch (imgIdx) {
            case 18: {
                imgPath = graphicsBaseDir + "button.png";
                break;
            }
            case 0: {
                imgPath = graphicsBaseDir + "logo_inlogic.png";
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "ship1.png";
                break;
            }
            case 30: {
                imgPath = graphicsBaseDir + "ship2.png";
                break;
            }
            case 9: {
                imgPath = graphicsBaseDir + "yes.png";
                break;
            }
            case 10: {
                imgPath = graphicsBaseDir + "no.png";
                break;
            }
            case 19: {
                imgPath = graphicsBaseDir + "four.png";
                break;
            }
            case 20: {
                imgPath = graphicsBaseDir + "six.png";
                break;
            }
            case 11: {
                imgPath = graphicsDisplayDir + "pozadie_01.png";
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "planeta_01.png";
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "planeta_02.png";
                break;
            }
            case 12: {
                imgPath = graphicsBaseDir + "planeta_03.png";
                break;
            }
            case 13: {
                imgPath = graphicsBaseDir + "planeta_04.png";
                break;
            }
            case 14: {
                imgPath = graphicsBaseDir + "planeta_05.png";
                break;
            }
            case 15: {
                imgPath = graphicsBaseDir + "planeta_06.png";
                break;
            }
            case 17: {
                imgPath = graphicsBaseDir + "title.png";
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "back.png";
                break;
            }
            case 23: {
                imgPath = graphicsBaseDir + "planet_score_01.png";
                break;
            }
            case 21: {
                imgPath = graphicsBaseDir + "settings.png";
                break;
            }
            case 22: {
                imgPath = graphicsBaseDir + "pause.png";
                break;
            }
            case 24: {
                imgPath = graphicsBaseDir + "en_01.png";
                break;
            }
            case 26: {
                imgPath = graphicsBaseDir + "de_01.png";
                break;
            }
            case 25: {
                imgPath = graphicsBaseDir + "fr_01.png";
                break;
            }
            case 27: {
                imgPath = graphicsBaseDir + "sp_01.png";
                break;
            }
            case 28: {
                imgPath = graphicsBaseDir + "it_01.png";
                break;
            }
            case 29: {
                imgPath = graphicsBaseDir + "br_01.png";
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "brana_03.png";
                break;
            }
            case 31: {
                imgPath = graphicsBaseDir + "brana_01.png";
                break;
            }
            case 16: {
                imgPath = graphicsBaseDir + "brana_02.png";
                break;
            }
            case 32: {
                imgPath = graphicsBaseDir + "hore.png";
                break;
            }
            case 33: {
                imgPath = graphicsBaseDir + "dole.png";
                break;
            }
            case 34: {
                imgPath = graphicsDisplayDir + "ship3.png";
                break;
            }
            case 35: {
                imgPath = graphicsBaseDir + "stit.png";
                break;
            }
            case 36: {
                imgPath = graphicsBaseDir + "meteor_01.png";
                break;
            }
            case 37: {
                imgPath = graphicsBaseDir + "meteor_02.png";
                break;
            }
            case 38: {
                imgPath = graphicsBaseDir + "bonus_stit_01.png";
                break;
            }
        }
        if (imgPath != null && resImgs[imgIdx] == null) {
            Resources.resImgs[imgIdx] = Resources.createImage(imgPath);
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void loadSprite(int sprIdx) {
        String imgPath = null;
        int slicesX = 1;
        int slicesY = 1;
        switch (sprIdx) {
            case 2: {
                imgPath = graphicsBaseDir + "button.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "arrows.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 0: {
                imgPath = graphicsBaseDir + "dialog.png";
                slicesX = 3;
                slicesY = 3;
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "ship_player.png";
                slicesX = 5;
                slicesY = 1;
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "vybuch_01.png";
                slicesX = 6;
                slicesY = 1;
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "stit_vybuch_01.png";
                slicesX = 4;
                slicesY = 1;
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "vybuch_02.png";
                slicesX = 6;
                slicesY = 1;
                break;
            }
        }
        if (imgPath != null && resSprs[sprIdx] == null) {
            Resources.resSprs[sprIdx] = Resources.createSprite(Resources.createImage(imgPath), slicesX, slicesY);
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFontMainSmall(Image gFontImg) {
        char[] fontChars = new char[]{'A', '\u00c6', 'B', 'C', 'D', '\u00d0', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cd', '\u00cc', '\u00cf', '\u00ce', '\u013d', '\u0147', '\u00d1', '\u00d3', '\u00d2', '\u00d6', '\u00d4', '\u00d5', '\u00da', '\u00d9', '\u00dc', '\u00db', '\u016e', '\u00dd', '\u0154', '\u0158', '\u015a', '\u0160', '\u0164', '\u017d', '\u00df', '&', '@', '\\', '%', '+', '=', '\u00f7', '-', '.', ',', ':', '\'', '\"', '!', '?', '\u00a1', '\u00bf', '_', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '|', '\u00a9', '(', ')', '/', '\u011e', '\u015e', '\u0130', ';'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 0;
        switch (gFontImg.getHeight()) {
            case 13: {
                fontCharsWidth = new short[]{9, 11, 7, 9, 8, 9, 6, 6, 9, 8, 4, 7, 8, 6, 10, 8, 9, 8, 9, 7, 7, 6, 7, 9, 11, 8, 9, 9, 9, 9, 9, 10, 10, 10, 8, 8, 8, 6, 7, 6, 6, 4, 4, 4, 4, 6, 8, 8, 9, 9, 9, 9, 8, 7, 7, 7, 7, 7, 9, 7, 8, 7, 7, 6, 9, 8, 9, 8, 5, 6, 8, 7, 8, 5, 2, 2, 3, 2, 4, 5, 7, 4, 7, 6, 8, 5, 8, 7, 7, 6, 7, 7, 6, 7, 2, 7, 3, 3, 5, 9, 7, 3, 2};
                break;
            }
            case 18: {
                fontCharsWidth = new short[]{13, 15, 10, 11, 10, 11, 8, 8, 11, 10, 5, 8, 10, 7, 14, 10, 12, 10, 11, 10, 9, 8, 9, 12, 15, 11, 12, 11, 13, 13, 13, 13, 13, 13, 11, 11, 10, 8, 9, 8, 8, 5, 5, 6, 5, 8, 10, 10, 12, 11, 12, 11, 12, 9, 9, 10, 9, 9, 11, 9, 10, 9, 10, 8, 12, 10, 12, 11, 7, 7, 9, 10, 10, 5, 3, 2, 4, 3, 4, 6, 10, 6, 10, 7, 10, 7, 10, 9, 9, 8, 9, 9, 8, 9, 2, 9, 4, 4, 7, 12, 9, 4, 3};
                break;
            }
            case 26: {
                fontCharsWidth = new short[]{17, 21, 13, 14, 14, 15, 10, 11, 16, 14, 6, 11, 12, 11, 19, 14, 16, 12, 16, 13, 13, 10, 13, 15, 20, 15, 16, 16, 17, 18, 18, 18, 17, 18, 14, 15, 14, 10, 11, 12, 11, 6, 7, 8, 7, 11, 13, 14, 16, 16, 16, 16, 16, 12, 12, 12, 12, 13, 15, 13, 13, 13, 12, 11, 15, 14, 17, 15, 9, 10, 13, 13, 14, 7, 3, 3, 4, 5, 6, 8, 15, 8, 13, 10, 13, 10, 13, 12, 12, 11, 12, 11, 11, 12, 2, 13, 6, 6, 9, 16, 12, 7, 4};
                break;
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, (int)fontCharsWidth[0]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "font_small.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMainSmall(gFontImg);
                break;
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        Resources.langCode = langCode;
        langDir = "/lang/" + langCode + "/";
        sysFont = langCode == "ru";
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    public static void freeAllResources() {
        int i;
        for (i = 0; i < resImgs.length; ++i) {
            Resources.resImgs[i] = null;
        }
        for (i = 0; i < resSprs.length; ++i) {
            Resources.resSprs[i] = null;
        }
        for (i = 0; i < resGFonts.length; ++i) {
            Resources.resGFonts[i] = null;
        }
    }
}

