/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.game;

import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.game.Game;
import sk.inlogic.util.Rectangle;

public class Asteroid {
    private int x;
    private int y;
    private int width;
    private int height;
    private int type;
    private int xStop;
    private int yStop;
    private Rectangle rectAsteroid;
    private int xMove = Integer.MAX_VALUE;
    private int yMove = Integer.MAX_VALUE;

    public Asteroid(int x, int y, int type, int width, int height, int xStop, int yStop) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.type = type;
        this.xStop = xStop;
        this.yStop = yStop;
        this.createRectangle();
        this.setMoving(0, 0, Game.sprPlayer, Game.playerRectangle);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getType() {
        return this.type;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getXStop() {
        return this.xStop;
    }

    public int getYStop() {
        return this.yStop;
    }

    private void createRectangle() {
        int x = this.x - (this.width >> 1);
        int y = this.y - (this.height >> 1);
        this.rectAsteroid = new Rectangle(x, y, this.width, this.height);
    }

    public Rectangle getRectAsteroid() {
        return this.rectAsteroid;
    }

    public void setRect(int x, int y) {
        this.rectAsteroid.x = x - (this.rectAsteroid.width >> 1);
        this.rectAsteroid.y = y - (this.rectAsteroid.height >> 1);
    }

    public boolean intersectWithPlayer(Rectangle player) {
        int playerMidX = player.getCenterX();
        int playerMidY = player.getCenterY();
        int asteroidMidX = this.rectAsteroid.getCenterX();
        int asteroidMidY = this.rectAsteroid.getCenterY();
        int halfWidthPlayer = player.width >> 1;
        int halfHeightPlayer = player.height >> 1;
        int halfWidthAsteroid = this.rectAsteroid.width >> 1;
        int halfHeightAsteroid = this.rectAsteroid.height >> 1;
        boolean isPlayerLeft = playerMidX - asteroidMidX < 0;
        boolean isPlayerTop = playerMidY - asteroidMidY < 0;
        int widthDistance = isPlayerLeft ? asteroidMidX - playerMidX : playerMidX - asteroidMidX;
        int heightDistance = isPlayerTop ? asteroidMidY - playerMidY : playerMidY - asteroidMidY;
        return widthDistance < halfWidthAsteroid + halfWidthPlayer && heightDistance < halfHeightAsteroid + halfHeightPlayer;
    }

    public int getXMove() {
        return this.xMove;
    }

    public int getYMove() {
        return this.yMove;
    }

    private void setMoving(int xMove, int yMove, Sprite sprPlayer, Rectangle playerRectangle) {
        int yDiff = this.getY() - this.getYStop();
        int xDiff = this.getX() - this.getXStop();
        if (xDiff < 0) {
            if (xDiff < yDiff) {
                ++xMove;
                yMove = xDiff != 0 ? (yMove -= yDiff / xDiff) : --yMove;
            } else {
                xMove = yDiff != 0 ? (xMove += xDiff / yDiff) : ++xMove;
                --yMove;
            }
        } else if (xDiff > 0) {
            if (xDiff < yDiff) {
                --xMove;
                yMove = xDiff != 0 ? (yMove -= yDiff / xDiff) : --yMove;
            } else {
                xMove = yDiff != 0 ? (xMove -= xDiff / yDiff) : --xMove;
                --yMove;
            }
        } else {
            --yMove;
        }
        if (yDiff == 0) {
            yMove = 0;
        }
        if (xDiff == 0) {
            xMove = 0;
        }
        if (Math.abs(xMove) <= sprPlayer.getWidth() && Math.abs(yMove) <= sprPlayer.getHeight()) {
            this.setMoving(xMove, yMove, sprPlayer, playerRectangle);
        }
        this.xMove = xMove;
        this.yMove = Math.abs(yMove);
    }
}

