/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public final class Sound {
    public static Player[] p;
    private InputStream sound;
    private VolumeControl[] synth;
    public static int currentSound;
    private String soundType;
    private String soundRes;
    private int soundNum;
    private int soundLevel;
    public int soundIndex;
    public long soundTime;

    public Sound(String s, int id, int num) {
        try {
            this.soundNum = num;
            currentSound = 0;
            p = new Player[num];
            this.synth = new VolumeControl[num];
            int i = id;
            while (i < id + num) {
                this.setType(Constant.SOUND_TYPE[i]);
                this.sound = this.getClass().getResourceAsStream(String.valueOf(s) + i + "." + this.soundType);
                Sound.p[i - id] = Manager.createPlayer((InputStream)this.sound, (String)("audio/" + this.soundRes));
                p[i - id].realize();
                this.synth[i - id] = (VolumeControl)p[i - id].getControl("VolumeControl");
                ++i;
            }
            this.sound = null;
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void soundOpen(int i) {
        System.out.println("sound open : " + i);
        if (p == null) {
            return;
        }
        if (i >= 0 && i < p.length) {
            if (currentSound != i) {
                this.soundStop();
            }
            currentSound = i;
        }
    }

    public void soundPlay(int i, int loop) {
        this.soundOpen(i);
        if (p == null) {
            return;
        }
        if (currentSound < 0 || currentSound >= p.length) {
            return;
        }
        if (p[currentSound] == null) {
            return;
        }
        if (p[currentSound].getState() == 400) {
            return;
        }
        try {
            System.out.println(String.valueOf(i) + " sound play: " + loop);
            System.out.println("sound level: " + this.soundLevel);
            if (p[currentSound].getState() == 200) {
                p[currentSound].prefetch();
            }
            System.out.println("set time : " + this.soundTime);
            if (loop != 0) {
                p[currentSound].setLoopCount(loop);
            }
            p[currentSound].start();
            this.soundLevel(this.soundLevel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void soundPause() {
        try {
            if (p[currentSound] == null) {
                return;
            }
            if (p[currentSound].getState() == 400) {
                p[currentSound].stop();
            }
            if (p[currentSound].getState() == 300) {
                p[currentSound].deallocate();
            }
        }
        catch (Exception _ex) {
            return;
        }
    }

    public void soundStop() {
        try {
            if (currentSound < 0 || p[currentSound] == null) {
                return;
            }
            if (p[currentSound].getState() == 400) {
                p[currentSound].stop();
                p[currentSound].setMediaTime(0L);
            }
            if (p[currentSound].getState() == 300) {
                p[currentSound].deallocate();
            }
            Sound.p[Sound.currentSound] = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void soundLevel(int level) {
        this.soundLevel = level;
        try {
            int i = 0;
            while (i < this.soundNum) {
                if (this.synth[i] != null) {
                    this.synth[i].setLevel(this.soundLevel * 20);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getSoundTime(int i) {
        if (i >= 0 && i < p.length && p != null) {
            return p[i].getMediaTime() / 1000L;
        }
        return 0L;
    }

    public void close() {
        if (p == null) {
            return;
        }
        try {
            int i = 0;
            while (i < p.length) {
                if (p[i] != null) {
                    p[i].close();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        p = null;
        this.sound = null;
        System.gc();
    }

    public void soundReset(long mediaTime) {
        try {
            p[currentSound].setMediaTime(mediaTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setType(int t) {
        if (t == 0) {
            this.soundType = "amr";
            this.soundRes = "amr";
        } else if (t == 1) {
            this.soundType = "mid";
            this.soundRes = "midi";
        } else if (t == 2) {
            this.soundType = "wav";
            this.soundRes = "x-wav";
        }
    }
}

