/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public final class Sound {
    private Player[] p;
    private InputStream sound;
    private VolumeControl[] synth;
    private int currentSound;
    private String soundType;
    private String soundRes;
    private int soundNum;
    private int soundLevel;
    public int soundIndex;
    public long soundTime;

    public Sound(String s, int id, int num) {
        try {
            this.soundNum = num;
            this.currentSound = 0;
            this.p = new Player[num];
            this.synth = new VolumeControl[num];
            int i = id;
            while (i < id + num) {
                this.setType(Constant.SOUND_TYPE[i]);
                this.sound = this.getClass().getResourceAsStream(String.valueOf(s) + i + "." + this.soundType);
                this.p[i - id] = Manager.createPlayer((InputStream)this.sound, (String)("audio/" + this.soundRes));
                this.p[i - id].realize();
                this.synth[i - id] = (VolumeControl)this.p[i - id].getControl("VolumeControl");
                ++i;
            }
            this.sound = null;
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void soundOpen(int i) {
        System.out.println("sound open : " + i);
        if (this.p == null) {
            return;
        }
        if (i >= 0 && i < this.p.length) {
            if (this.currentSound != i) {
                this.soundStop();
            }
            this.currentSound = i;
        }
    }

    public void soundPlay(int i, int loop) {
        this.soundOpen(i);
        if (this.p == null) {
            return;
        }
        if (this.currentSound < 0 || this.currentSound >= this.p.length) {
            return;
        }
        if (this.p[this.currentSound] == null) {
            return;
        }
        if (this.p[this.currentSound].getState() == 400) {
            return;
        }
        try {
            System.out.println(String.valueOf(i) + " sound play: " + loop);
            System.out.println("sound level: " + this.soundLevel);
            if (this.p[this.currentSound].getState() == 200) {
                this.p[this.currentSound].prefetch();
            }
            System.out.println("set time : " + this.soundTime);
            if (loop != 0) {
                this.p[this.currentSound].setLoopCount(loop);
            }
            this.p[this.currentSound].start();
            this.soundLevel(this.soundLevel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void soundPause() {
        try {
            if (this.p[this.currentSound] == null) {
                return;
            }
            if (this.p[this.currentSound].getState() == 400) {
                this.p[this.currentSound].stop();
            }
            if (this.p[this.currentSound].getState() == 300) {
                this.p[this.currentSound].deallocate();
            }
        }
        catch (Exception _ex) {
            return;
        }
    }

    public void soundStop() {
        try {
            if (this.currentSound < 0 || this.p[this.currentSound] == null) {
                return;
            }
            if (this.p[this.currentSound].getState() == 400) {
                this.p[this.currentSound].stop();
                this.p[this.currentSound].setMediaTime(0L);
            }
            if (this.p[this.currentSound].getState() == 300) {
                this.p[this.currentSound].deallocate();
            }
            this.p[this.currentSound] = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void soundLevel(int level) {
        this.soundLevel = level;
        try {
            int i = 0;
            while (i < this.soundNum) {
                if (this.synth[i] != null) {
                    this.synth[i].setLevel(this.soundLevel * 25);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getSoundTime(int i) {
        if (i >= 0 && i < this.p.length && this.p != null) {
            return this.p[i].getMediaTime() / 1000L;
        }
        return 0L;
    }

    public void close() {
        if (this.p == null) {
            return;
        }
        try {
            int i = 0;
            while (i < this.p.length) {
                if (this.p[i] != null) {
                    this.p[i].close();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.p = null;
        this.sound = null;
        System.gc();
    }

    public void soundReset(long mediaTime) {
        try {
            this.p[this.currentSound].setMediaTime(mediaTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setType(int t) {
        if (t == 0) {
            this.soundType = "amr";
            this.soundRes = "amr";
        } else if (t == 1) {
            this.soundType = "mid";
            this.soundRes = "midi";
        } else if (t == 2) {
            this.soundType = "wav";
            this.soundRes = "x-wav";
        }
    }
}

