/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TextBox {
    private String text;
    private int textLength;
    private int width;
    public int height;
    private Font font = Font.getFont((int)64, (int)1, (int)8);
    public int maxLineNum;
    private int lineSize;
    private int totalPage;
    private int[] lineNum;
    private int[] linePos;
    private int currentLen;
    private int wordNumber;
    private int letterLength;
    private int currentIndex;
    private int currentLine;
    public int totalLine;
    private int lineIndex;
    private int pageIndex;
    public int startLine;
    private static Image[] image;

    public TextBox() {
        this.setBoxSize(240, 300);
    }

    public void Close() {
        this.totalPage = 0;
        this.text = null;
        this.lineNum = null;
        this.linePos = null;
    }

    public void setFont(Font font) {
        this.font = font;
        this.resetBox();
    }

    private void resetBox() {
        if (this.width < 24 || this.height < 22) {
            System.out.println("TextBox create failed: size too small.");
            return;
        }
        this.lineSize = this.width - 4;
        this.maxLineNum = (this.height - 2) / this.font.getHeight();
        if (this.text != null) {
            this.setString(this.text);
        }
    }

    public void setBoxSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.resetBox();
    }

    private void newLine(int state) {
        ++this.currentLine;
        this.currentLen = 0;
        this.linePos[++this.lineIndex] = this.currentIndex - (state << 1);
        this.linePos[++this.lineIndex] = this.currentIndex + 1;
        if (this.currentLine == this.maxLineNum) {
            ++this.totalPage;
            this.totalLine += this.currentLine;
            this.lineNum[++this.pageIndex] = this.totalLine;
            this.currentLine = 0;
        }
    }

    public void setString(String text) {
        this.text = text;
        this.textLength = text.length();
        if (this.textLength == 0) {
            return;
        }
        this.lineNum = new int[this.textLength + 1];
        this.linePos = new int[this.textLength << 1];
        this.currentIndex = 0;
        this.wordNumber = 0;
        this.letterLength = 0;
        this.currentLen = 0;
        this.currentLine = 0;
        this.totalLine = 0;
        this.startLine = 0;
        this.pageIndex = 0;
        this.lineIndex = 0;
        this.lineNum[this.pageIndex] = 0;
        this.linePos[this.lineIndex] = 0;
        this.totalPage = 0;
        while (this.currentIndex < this.textLength) {
            String currentChar = text.substring(this.currentIndex, this.currentIndex + 1);
            char ch = currentChar.charAt(0);
            if (Character.isLowerCase(ch) || Character.isUpperCase(ch) || currentChar.compareTo("\ufffd\ufffd") >= 0) {
                this.wordNumber = 1;
                while (this.currentIndex + this.wordNumber < this.textLength && (Character.isLowerCase(text.substring(this.currentIndex + this.wordNumber, this.currentIndex + this.wordNumber + 1).charAt(0)) || Character.isUpperCase(text.substring(this.currentIndex + this.wordNumber, this.currentIndex + this.wordNumber + 1).charAt(0)) || text.substring(this.currentIndex + this.wordNumber, this.currentIndex + this.wordNumber + 1).compareTo("\ufffd\ufffd") >= 0)) {
                    ++this.wordNumber;
                }
                this.letterLength = this.font.substringWidth(text, this.currentIndex, this.wordNumber);
                if (this.letterLength > this.lineSize) {
                    int i = 0;
                    while (i < this.wordNumber) {
                        currentChar = text.substring(this.currentIndex, this.currentIndex + 1);
                        this.letterLength = this.font.stringWidth(currentChar);
                        if (this.currentLen + this.letterLength > this.lineSize) {
                            this.newLine(0);
                        } else {
                            this.currentLen += this.letterLength;
                        }
                        ++this.currentIndex;
                        ++i;
                    }
                    continue;
                }
                if (this.currentLen + this.letterLength > this.lineSize) {
                    --this.currentIndex;
                    this.newLine(0);
                    this.currentIndex += this.wordNumber;
                    this.currentLen = this.letterLength;
                    continue;
                }
                this.currentIndex += this.wordNumber;
                this.currentLen += this.letterLength;
                continue;
            }
            if (currentChar.equals("/")) {
                ++this.currentIndex;
                if (this.currentIndex >= this.textLength) continue;
                currentChar = text.substring(this.currentIndex, this.currentIndex + 1);
                if (currentChar.equals("n")) {
                    if (this.currentIndex == this.textLength - 1) {
                        --this.currentIndex;
                        break;
                    }
                    this.newLine(1);
                } else if (currentChar.equals("p")) {
                    if (this.currentIndex == this.textLength - 1) {
                        --this.currentIndex;
                        break;
                    }
                    ++this.currentLine;
                    this.currentLen = 0;
                    this.linePos[++this.lineIndex] = this.currentIndex - 2;
                    this.linePos[++this.lineIndex] = this.currentIndex + 1;
                    ++this.totalPage;
                    this.totalLine += this.currentLine;
                    this.lineNum[++this.pageIndex] = this.totalLine;
                    this.currentLine = 0;
                } else {
                    --this.currentIndex;
                    this.currentLen += this.font.stringWidth("/");
                    if (this.currentLen >= this.lineSize) {
                        if (this.currentLen > this.lineSize) {
                            --this.currentIndex;
                        }
                        this.newLine(0);
                    }
                }
                ++this.currentIndex;
                continue;
            }
            this.currentLen += this.font.stringWidth(currentChar);
            if (this.currentLen >= this.lineSize) {
                if (this.currentLen > this.lineSize) {
                    --this.currentIndex;
                }
                this.newLine(0);
            }
            ++this.currentIndex;
        }
        if (this.currentLine != 0 || this.currentLen != 0) {
            ++this.totalPage;
            this.totalLine += this.currentLine + 1;
            this.linePos[++this.lineIndex] = this.currentIndex - 1;
            this.lineNum[++this.pageIndex] = this.totalLine;
        }
    }

    public int page() {
        return Math.max(1, this.totalPage);
    }

    public boolean judgeLineUp() {
        return this.startLine > 0;
    }

    public void lineUp() {
        if (this.startLine > 0) {
            --this.startLine;
        }
    }

    public boolean judgeLineDown() {
        return this.startLine < this.totalLine - this.maxLineNum;
    }

    public void lineDown() {
        if (this.startLine < this.totalLine - this.maxLineNum) {
            ++this.startLine;
        }
    }

    public void paintText(Graphics g, int x, int y, int col, int currentPage, boolean pageRoll) {
        g.setFont(this.font);
        if (pageRoll) {
            int i = 0;
            while (i < this.lineNum[currentPage + 1] - this.lineNum[currentPage]) {
                TextBox.drawString(g, this.text.substring(this.linePos[i + this.lineNum[currentPage] << 1], this.linePos[(i + this.lineNum[currentPage] << 1) + 1] + 1), x, y + i * (this.font.getHeight() + 1), col, 0, 0xFFFFFF);
                ++i;
            }
        } else {
            int showLine = this.totalLine < this.maxLineNum ? this.totalLine : this.maxLineNum;
            int i = this.startLine;
            while (i < this.startLine + showLine) {
                TextBox.drawString(g, this.text.substring(this.linePos[i << 1], this.linePos[(i << 1) + 1] + 1), x, y + (i - this.startLine) * this.font.getHeight(), col, 0, 0xFFFFFF);
                ++i;
            }
        }
    }

    public void paintTextColor(Graphics g, int x, int y, int col, int currentPage, int color) {
        g.setFont(this.font);
        int showLine = this.totalLine < this.maxLineNum ? this.totalLine : this.maxLineNum;
        int i = this.startLine;
        while (i < this.startLine + showLine) {
            TextBox.drawString(g, this.text.substring(this.linePos[i << 1], this.linePos[(i << 1) + 1] + 1), x, y + (i - this.startLine) * this.font.getHeight(), col, 0, color);
            ++i;
        }
    }

    public void paintTextEffect(Graphics g, int x, int y, int anchor, int color) {
        g.setFont(this.font);
        int showLine = this.totalLine < this.maxLineNum ? this.totalLine : this.maxLineNum;
        int i = this.startLine;
        while (i < this.startLine + showLine) {
            TextBox.drawString(g, this.text.substring(this.linePos[i << 1], this.linePos[(i << 1) + 1] + 1), x - 1, y + (i - this.startLine) * this.font.getHeight(), anchor, 0, color);
            TextBox.drawString(g, this.text.substring(this.linePos[i << 1], this.linePos[(i << 1) + 1] + 1), x + 1, y + (i - this.startLine) * this.font.getHeight(), anchor, 0, color);
            TextBox.drawString(g, this.text.substring(this.linePos[i << 1], this.linePos[(i << 1) + 1] + 1), x, y + (i - this.startLine) * this.font.getHeight() - 1, anchor, 0, color);
            TextBox.drawString(g, this.text.substring(this.linePos[i << 1], this.linePos[(i << 1) + 1] + 1), x, y + (i - this.startLine) * this.font.getHeight() + 1, anchor, 0, color);
            TextBox.drawString(g, this.text.substring(this.linePos[i << 1], this.linePos[(i << 1) + 1] + 1), x, y + (i - this.startLine) * this.font.getHeight(), anchor, 0, 0xFFFFFF);
            ++i;
        }
    }

    public static void drawString(Graphics g, String s, int x, int y, int anchor, int foreColor, int backColor) {
        g.setColor(backColor);
        g.setFont(FrameWork.font);
        g.drawString(s, x, y, anchor);
    }

    public int height() {
        return this.totalLine * this.font.getHeight() - 2;
    }
}

