/*
 * Decompiled with CFR 0.152.
 */
package sweetalien;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import sweetalien.Base;
import sweetalien.Enemy;
import sweetalien.Levels;

public class StaticEnemy
extends Enemy {
    Base m_pBaseApp;
    int ticks;
    int blastState;
    boolean fireBlastWait;
    int blastIndex;
    int blast_mX;
    int blast_mY;
    int TW;
    int TH;
    Image bitmapLocal;
    int fireanim;
    int tankanim;
    int monsterAnim;

    StaticEnemy(Base ptya) {
        super(ptya);
        this.m_pBaseApp = ptya;
        this.TW = 20;
        this.TH = 20;
    }

    void update() {
        if (Math.abs(this.m_pBaseApp.m_pGameThread.x) >= this.pivotX || Math.abs(this.m_pBaseApp.m_pGameThread.y) >= this.pivotY) {
            // empty if block
        }
        if (this.isEnemyOver()) {
            return;
        }
        switch (this.type) {
            case 6: 
            case 7: {
                this.updateSlab();
                break;
            }
            case 5: {
                this.updateBridge();
                break;
            }
            case 1: 
            case 2: {
                this.updateLotus();
                break;
            }
            case 8: {
                this.updateObstaclePlatform();
                break;
            }
            case 12: {
                this.updateFireBlast();
                break;
            }
            case 10: {
                this.updatePendulum();
                break;
            }
            case 17: {
                this.updateJelly();
                break;
            }
            case 13: 
            case 19: 
            case 20: {
                this.updateMonster();
                break;
            }
            case 18: {
                this.updateRoller();
                break;
            }
            case 11: 
            case 14: {
                this.updateFish();
                break;
            }
            case 15: 
            case 16: {
                this.updateFly();
            }
        }
    }

    void updateFireBlast() {
        ++this.ticks;
        if (this.isEnemyCollide()) {
            this.yMove -= this.m_pBaseApp.m_pGameThread.RAMBO_SPEED;
            if (this.yMove > 0) {
                this.y -= this.m_pBaseApp.m_pGameThread.RAMBO_SPEED;
                this.pivotY -= this.m_pBaseApp.m_pGameThread.RAMBO_SPEED;
            }
        }
        if (this.ticks % 20 == 0) {
            this.blastState = 0;
            this.blastIndex = 0;
            this.fireBlastWait = !this.fireBlastWait;
            this.x = this.pivotX;
            this.y = this.pivotY;
            this.blast_mX = 0;
            this.blast_mY = 0;
        }
        if (!this.fireBlastWait) {
            return;
        }
        if (this.ticks % 2 == 0) {
            ++this.blastIndex;
        }
        switch (this.direction) {
            case 2: {
                if (this.y < this.pivotY + this.yMove) {
                    this.blast_mY = -3 * this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED;
                    this.y += this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                    break;
                }
                this.blast_mY += this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                break;
            }
            case 0: {
                if (this.y > this.pivotY - this.yMove) {
                    this.blast_mY = 3 * this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED;
                    this.y -= this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                    break;
                }
                this.blast_mY -= this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                break;
            }
            case 1: {
                if (this.x < this.pivotX + this.xMove) {
                    this.blast_mX = -3 * this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED;
                    this.x += this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                    break;
                }
                this.blast_mX += this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                break;
            }
            case 3: {
                if (this.x > this.pivotX - this.xMove) {
                    this.blast_mX = 3 * this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED;
                    this.x -= this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                    break;
                }
                this.blast_mX -= this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
            }
        }
    }

    void updateRunPower() {
    }

    void paint(Graphics g) {
        boolean i = false;
        boolean j = false;
        this.pivotY += this.m_pBaseApp.m_pGameThread.viewControlY;
        this.y += this.m_pBaseApp.m_pGameThread.viewControlY;
        ++this.tick;
        if (this.isEnemyOver()) {
            i = false;
            return;
        }
        switch (this.type) {
            case 11: {
                if (this.isEnemyCollide()) break;
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.width, this.height, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, this.showimage, 0);
                break;
            }
            case 14: {
                if (!this.isEnemyCollide()) break;
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.width, this.height, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, this.showimage, 0);
                break;
            }
            case 20: {
                if (!this.moveForward) {
                    this.m_pBaseApp.cropBitmap(g, this.m_pBaseApp.m_pGameThread.m_pBitmap[20], this.width, this.height, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, this.showimage, 0);
                    break;
                }
                this.m_pBaseApp.cropBitmap(g, this.m_pBaseApp.m_pGameThread.m_pBitmap[24], this.width, this.height, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, this.showimage, 0);
                break;
            }
            case 18: {
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.width, this.height, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY + this.TH / 3, this.showimage, 0);
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.width, this.height, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, this.showimage, 0);
                break;
            }
            case 10: {
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.width, this.height, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, this.showimage, 0);
                break;
            }
            case 12: {
                this.drawFireBlast(g);
                break;
            }
            case 8: {
                this.drawObstaclePlatform(g);
                break;
            }
            case 1: 
            case 2: {
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.width, this.height, this.x - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.y - this.height / 3, this.showimage, 0);
                break;
            }
            case 6: {
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY - this.TH, 4, 0);
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX + this.TW - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY - this.TH, 36, 0);
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, 0, 0);
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX + this.TW - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, 3, 0);
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY + this.TH, 31, 0);
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX + this.TW - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY + this.TH, 34, 0);
                break;
            }
            case 7: {
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY - this.TH, 62, 0);
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, 63, 0);
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY + this.TH, 64, 0);
                break;
            }
            case 5: {
                this.drawBridge(g);
                break;
            }
            case 9: {
                break;
            }
            case 4: {
                g.drawImage(this.bitmapLocal, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, 0);
                if (this.isEnemyCollide()) break;
                g.drawImage(this.m_pBaseApp.m_pGameThread.m_pBitmap[10], this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, 0);
                break;
            }
            case 3: 
            case 21: {
                g.drawImage(this.m_pBaseApp.m_pGameThread.m_pBitmap[8], this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, 0);
            }
        }
        this.pivotY -= this.m_pBaseApp.m_pGameThread.viewControlY;
        this.y -= this.m_pBaseApp.m_pGameThread.viewControlY;
    }

    void updateTank() {
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean isCollideWithRambo(int xPos, int yPos, int wid, int hgt, int collissionType) {
        if (this.isEnemyOver()) {
            return false;
        }
        int i = 0;
        int xStart = 0;
        int xEnd = 0;
        int yStart = 0;
        int yEnd = 0;
        int mH = 0;
        int mV = 0;
        switch (this.type) {
            case 4: {
                mV = -5;
                mH = -10;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                mV = 5;
                break;
            }
            case 8: {
                mV = 5;
                break;
            }
            case 17: {
                mV = 7;
                mH = 8;
                break;
            }
            case 11: {
                mV = 7;
                mH = 8;
                break;
            }
            case 14: {
                mV = 5;
                mH = 5;
                break;
            }
            case 18: {
                mV = 10;
                mH = 6;
                break;
            }
            case 19: {
                mV = 17;
                mH = 11;
                break;
            }
            case 20: {
                mV = 15;
                mH = 10;
                break;
            }
            case 13: {
                mV = 5;
                mH = 3;
                break;
            }
            case 15: 
            case 16: {
                mV = 3;
                mH = 4;
                break;
            }
            case 10: {
                mV = 5;
                mH = 5;
                yStart = this.pivotY + mV;
                yEnd = this.y + Levels.PENDULUM240[this.showimage];
                xStart = this.x - wid + mH + this.width * this.showimage / 9;
                xEnd = this.pivotX - mH + this.width * (this.showimage + 1) / 9;
                break;
            }
            case 12: {
                mV = 3;
                mH = 5;
                break;
            }
        }
        switch (this.type) {
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                if (xPos <= this.pivotX - wid + mH) return false;
                if (xPos >= this.pivotX - mH + this.width) return false;
                if (!(yPos + this.TH / 3 >= this.pivotY + mV && yPos + this.TH / 3 <= this.pivotY + this.height - mV || yPos + hgt >= this.pivotY + mV && yPos + hgt <= this.pivotY + this.height - mV)) {
                    if (yPos + hgt / 2 > this.pivotY + this.height) return false;
                    if (yPos + hgt / 2 < this.pivotY) return false;
                }
                if (this.type == 9) {
                    this.setEnemyCollide(this.index);
                    return false;
                }
                if (this.type == 3) {
                    this.m_pBaseApp.savedata.upd_X = this.x - this.TW;
                    this.m_pBaseApp.savedata.upd_Y = this.y;
                    return false;
                }
                switch (collissionType) {
                    case 0: {
                        if (this.m_pBaseApp.m_pGameThread.SHIELD_FREEZ) return false;
                        return true;
                    }
                    case 1: {
                        if (this.type == 15 && this.m_pBaseApp.m_pGamePlayer.tounghFireTimer == 0) {
                            this.m_pBaseApp.m_pGamePlayer.tounghFireTimer = 30;
                            this.m_pBaseApp.m_pGamePlayer.tounghFireForward = false;
                            this.setEnemyOver();
                            return false;
                        }
                        if (this.m_pBaseApp.m_pGameThread.SHIELD_FREEZ) return false;
                        return true;
                    }
                    case 2: {
                        this.m_pBaseApp.m_pGamePlayer.flyX = 0;
                        this.m_pBaseApp.m_pGamePlayer.tounghFireForward = false;
                        this.m_pBaseApp.m_pGamePlayer.tounghFire = false;
                        this.m_pBaseApp.m_pGamePlayer.tounghFireTimer = 0;
                        this.m_pBaseApp.m_pGamePlayer.tounghGarb = false;
                        this.m_pBaseApp.m_pGameThread.FLY_GRAB = false;
                        this.setEnemyOver();
                        return true;
                    }
                }
                return false;
            }
            case 10: {
                if (xPos <= xStart) return false;
                if (xPos >= xEnd) return false;
                if (yPos + this.TH / 3 <= yStart) return false;
                if (yPos + this.TH / 3 >= yEnd) return false;
                if (this.m_pBaseApp.m_pGameThread.HELMET_FREEZ) return false;
                return true;
            }
            case 12: {
                if (!this.fireBlastWait) return false;
                switch (this.direction) {
                    case 2: {
                        xStart = this.x - wid + mH;
                        xEnd = this.pivotX + wid - mH;
                        yStart = this.pivotY + mV;
                        yEnd = this.y + this.yMove - mV;
                        break;
                    }
                    case 0: {
                        xStart = this.x - wid + mH;
                        xEnd = this.pivotX + wid - mH;
                        yStart = this.y;
                        yEnd = this.pivotY + this.yMove + mV;
                        break;
                    }
                    case 1: {
                        xStart = this.pivotX - wid / 2 + mH;
                        xEnd = this.x + this.width - mH;
                        yStart = this.pivotY + mV;
                        yEnd = this.pivotY + this.TH - mV;
                        break;
                    }
                    case 3: {
                        xStart = this.x - wid + mH;
                        xEnd = this.pivotX + this.width - mH;
                        yStart = this.pivotY + mV;
                        yEnd = this.pivotY + this.TH - mV;
                        break;
                    }
                }
                if (xPos <= xStart) return false;
                if (xPos >= xEnd) return false;
                switch (this.direction) {
                    case 1: 
                    case 3: {
                        if (!(yPos + this.TH / 3 >= this.pivotY + mV && yPos + this.TH / 3 <= this.pivotY + this.height - mV || yPos + hgt >= this.pivotY + mV && yPos + hgt <= this.pivotY + this.height - mV) && (yPos + hgt / 2 > this.pivotY + this.height || yPos + hgt / 2 < this.pivotY)) break;
                        switch (collissionType) {
                            case 0: {
                                if (this.m_pBaseApp.m_pGameThread.HELMET_FREEZ) return false;
                                return true;
                            }
                        }
                        return false;
                    }
                    case 0: 
                    case 2: {
                        if ((yPos <= yStart || yPos >= yEnd) && (yPos + hgt <= yStart || yPos + hgt >= yEnd)) break;
                        switch (collissionType) {
                            case 0: {
                                if (this.m_pBaseApp.m_pGameThread.HELMET_FREEZ) return false;
                                return true;
                            }
                        }
                        return false;
                    }
                }
                return false;
            }
            case 8: {
                if (xPos <= this.pivotX - wid / 2) return false;
                if (xPos >= this.pivotX + this.width - wid / 2) return false;
                if (yPos + hgt <= this.pivotY - hgt / 2) return false;
                if (yPos + hgt >= this.pivotY + this.height + mV) return false;
                this.m_pBaseApp.m_pGamePlayer.updateObstaclePlatform();
                return false;
            }
            case 1: 
            case 2: {
                if (xPos <= this.x - wid / 2) return false;
                if (xPos >= this.x + this.width - wid) return false;
                if (yPos + hgt <= this.pivotY - hgt / 2) return false;
                if (yPos + hgt >= this.pivotY + this.TH) return false;
                if (this.m_pBaseApp.m_pGamePlayer.prevState == 27 || this.m_pBaseApp.m_pGamePlayer.prevState == 28) {
                    if (this.m_pBaseApp.m_pGamePlayer.state == 1) return false;
                    if (this.m_pBaseApp.m_pGamePlayer.state == 6) return false;
                    if (this.m_pBaseApp.m_pGamePlayer.state == 9) {
                        return false;
                    }
                }
                if (!this.isEnemyCollide()) return false;
                switch (this.showimage) {
                    case 0: 
                    case 1: 
                    case 3: {
                        switch (this.type) {
                            case 2: {
                                this.m_pBaseApp.m_pGamePlayer.state = 28;
                                break;
                            }
                            case 1: {
                                this.m_pBaseApp.m_pGamePlayer.state = 27;
                                break;
                            }
                        }
                        this.m_pBaseApp.m_pGamePlayer.fallThroughHeight = 0;
                        this.m_pBaseApp.m_pGamePlayer.prevState = this.m_pBaseApp.m_pGamePlayer.state;
                        this.m_pBaseApp.m_pGamePlayer.substate = 4;
                        this.m_pBaseApp.m_pGamePlayer.ramboY = this.pivotY - this.m_pBaseApp.m_pGamePlayer.RAMBO_STAND_IMAGE_HEIGHT;
                        return true;
                    }
                }
                return true;
            }
            case 4: {
                if (this.pivotX + mH > xPos) return false;
                if (this.pivotX + 3 * wid / 2 < xPos) return false;
                if (this.pivotY - this.height - (yPos + hgt) >= 0 + mV) return false;
                if (yPos >= this.pivotY) return false;
                if (this.m_pBaseApp.m_pGamePlayer.prevState != 1 && this.m_pBaseApp.m_pGamePlayer.prevState != 6) {
                    if (this.m_pBaseApp.m_pGamePlayer.prevState != 9) return false;
                }
                this.setEnemyCollide(this.index);
                return false;
            }
            case 5: {
                if (xPos + wid / 2 <= this.pivotX) return false;
                if (xPos >= this.pivotX + this.width) return false;
                if (yPos + hgt <= this.pivotY + mV) return false;
                if (yPos + hgt >= this.pivotY + this.height - mV) return false;
                this.m_pBaseApp.m_pGamePlayer.ramboY = this.pivotY - this.m_pBaseApp.m_pGamePlayer.RAMBO_HEIGHT;
                i = 0;
                while (i < this.xMove) {
                    this.m_pBaseApp.m_pGameThread.gameArr[(this.m_pBaseApp.m_pGamePlayer.ramboY + this.m_pBaseApp.m_pGamePlayer.RAMBO_HEIGHT) / this.TH][this.pivotX / this.TW + i] = 100;
                    ++i;
                }
                return false;
            }
            case 6: 
            case 7: {
                if (xPos + wid / 2 <= this.pivotX) return false;
                if (xPos >= this.pivotX + this.width) return false;
                if (yPos + hgt <= this.pivotY + mV) return false;
                if (yPos + hgt >= this.pivotY + this.height) return false;
                if (!this.isEnemyCollide()) {
                    this.m_pBaseApp.m_pGamePlayer.ramboY = this.pivotY - this.m_pBaseApp.m_pGamePlayer.RAMBO_HEIGHT;
                }
                if (this.yMove > 0) {
                    this.setEnemyCollide(this.index);
                }
                i = 0;
                while (i < this.xMove) {
                    this.m_pBaseApp.m_pGameThread.gameArr[this.pivotY / this.TH][this.pivotX / this.TW + i] = 100;
                    ++i;
                }
                return false;
            }
        }
        return false;
    }

    void drawBridge(Graphics g) {
        int i = 0;
        int j = 0;
        for (i = 0; i < this.xMove; ++i) {
            for (j = 2; j < 15; ++j) {
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY - j * this.TH, 56, 0);
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX + (this.xMove - 1) * this.TW - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY - j * this.TH, 56, 0);
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY - this.TH, 67, 0);
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX + (this.xMove - 1) * this.TW - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY - this.TH, 67, 0);
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX + i * this.TW - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY - this.TH, 62, 0);
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX + i * this.TW - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, 63, 0);
                this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX + i * this.TW - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY + this.TH, 64, 0);
            }
        }
    }

    void updateBridge() {
        if (this.isEnemyCollide()) {
            if (this.findDirection() == 2) {
                this.yMove -= this.m_pBaseApp.m_pGameThread.RAMBO_SPEED;
                if (this.yMove > -this.m_pBaseApp.m_pGameThread.RAMBO_SPEED) {
                    this.pivotY += this.m_pBaseApp.m_pGameThread.RAMBO_SPEED;
                } else {
                    this.setEnemyCollide(this.index);
                }
            } else {
                this.yMove -= this.m_pBaseApp.m_pGameThread.RAMBO_SPEED;
                if (Math.abs(this.yMove / this.TH) <= 2) {
                    this.pivotY -= this.m_pBaseApp.m_pGameThread.RAMBO_SPEED;
                } else {
                    this.setEnemyCollide(this.index);
                }
            }
        }
    }

    void updateSlab() {
        int id = -1;
        int Y1 = 0;
        Y1 = this.type == 7 ? 3 * this.TH : 3 * this.TH;
        if (this.isEnemyCollide()) {
            this.pivotY += this.m_pBaseApp.m_pGameThread.RAMBO_SPEED;
            if (this.pivotY / this.TH < this.m_pBaseApp.m_pGameThread.level_row && this.m_pBaseApp.m_pGameThread.gameArr[this.pivotY / this.TH][this.pivotX / this.TW] == 100) {
                this.m_pBaseApp.m_pGameThread.gameArr[this.pivotY / this.TH][this.pivotX / this.TW] = 0;
                if (this.m_pBaseApp.m_pGameThread.gameArr[this.pivotY / this.TH][this.pivotX / this.TW - 1] == 100) {
                    this.m_pBaseApp.m_pGameThread.gameArr[this.pivotY / this.TH][this.pivotX / this.TW - 1] = 0;
                }
                if (this.m_pBaseApp.m_pGameThread.gameArr[this.pivotY / this.TH][this.pivotX / this.TW + 1] == 100) {
                    this.m_pBaseApp.m_pGameThread.gameArr[this.pivotY / this.TH][this.pivotX / this.TW + 1] = 0;
                }
            }
            if (this.pivotY > this.y + Y1 && this.m_pBaseApp.m_pLegendData.enemyArr[this.index][9] != -1) {
                id = this.m_pBaseApp.m_pLegendData.enemyArr[this.index][9];
                this.m_pBaseApp.m_pLegendData.enemyArr[id][8] = 1;
            }
        }
    }

    void updateLotus() {
        int i = 0;
        switch (this.type) {
            case 1: {
                this.showimage = 0;
                if (this.isEnemyCollide()) {
                    switch (this.direction) {
                        case 4: {
                            if (this.moveForward) {
                                this.x += this.m_pBaseApp.m_pGamePlayer.LOTUS_SPEED;
                                if (this.x < this.pivotX + this.xMove * this.TW) break;
                                this.moveForward = false;
                                break;
                            }
                            this.x -= this.m_pBaseApp.m_pGamePlayer.LOTUS_SPEED;
                            if (this.x > this.pivotX) break;
                            this.moveForward = true;
                            break;
                        }
                        case 1: {
                            if (!this.moveForward) break;
                            this.x += this.m_pBaseApp.m_pGamePlayer.LOTUS_SPEED;
                            if (this.x < this.pivotX + this.xMove * this.TW) break;
                            this.m_pBaseApp.m_pLegendData.enemyArr[this.index][8] = 0;
                            this.m_pBaseApp.m_pGamePlayer.state = 4;
                            this.m_pBaseApp.m_pGamePlayer.substate = 4;
                            this.m_pBaseApp.m_pGameThread.is_BACK = false;
                            this.m_pBaseApp.m_pGameThread.is_FORWARD = false;
                        }
                    }
                }
                for (i = this.pivotX / this.TW; i < this.pivotX / this.TW + this.xMove + 3; ++i) {
                    if (this.isEnemyCollide()) {
                        if (i == this.x / this.TW + 1 || i == this.x / this.TW + 2) {
                            this.m_pBaseApp.m_pGameThread.gameArr[this.pivotY / this.TH][i] = 100;
                            continue;
                        }
                        this.m_pBaseApp.m_pGameThread.gameArr[this.pivotY / this.TH][i] = 0;
                        continue;
                    }
                    this.m_pBaseApp.m_pGameThread.gameArr[this.pivotY / this.TH][i] = i == this.x / this.TW || i == this.x / this.TW + 1 || i == this.x / this.TW + 2 ? 100 : 0;
                }
                break;
            }
            case 2: {
                ++this.ticks;
                if (this.ticks % 15 == 0) {
                    ++this.showimage;
                    if (this.showimage == 4) {
                        this.showimage = 0;
                    }
                }
                block13: for (i = this.pivotX / this.TW; i < this.pivotX / this.TW + 3; ++i) {
                    switch (this.showimage) {
                        case 0: 
                        case 1: 
                        case 3: {
                            this.m_pBaseApp.m_pGameThread.gameArr[this.pivotY / this.TH][i] = 100;
                            continue block13;
                        }
                        case 2: {
                            this.m_pBaseApp.m_pGameThread.gameArr[this.pivotY / this.TH][i] = 0;
                        }
                    }
                }
                break;
            }
        }
    }

    void updateObstaclePlatform() {
        if (this.isEnemyCollide() && this.findDirection() == 0) {
            this.yMove -= this.m_pBaseApp.m_pGameThread.RAMBO_SPEED;
            if (this.yMove > 0) {
                this.pivotY -= this.m_pBaseApp.m_pGameThread.RAMBO_SPEED;
            }
        }
    }

    void drawObstaclePlatform(Graphics g) {
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY, 4, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + this.TW, this.pivotY, 23, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + 2 * this.TW, this.pivotY, 36, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY + this.TH, 0, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + this.TW, this.pivotY + this.TH, 1, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + 2 * this.TW, this.pivotY + this.TH, 3, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY + 2 * this.TH, 9, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + this.TW, this.pivotY + 2 * this.TH, 10, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + 2 * this.TW, this.pivotY + 2 * this.TH, 12, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY + 3 * this.TH, 40, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + this.TW, this.pivotY + 3 * this.TH, 41, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + 2 * this.TW, this.pivotY + 3 * this.TH, 43, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY + 4 * this.TH, 40, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + this.TW, this.pivotY + 4 * this.TH, 41, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + 2 * this.TW, this.pivotY + 4 * this.TH, 43, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.pivotY + 5 * this.TH, 54, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + this.TW, this.pivotY + 5 * this.TH, 41, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + 2 * this.TW, this.pivotY + 5 * this.TH, 16, 0);
        this.m_pBaseApp.cropBitmap(g, this.bitmapLocal, this.TW, this.TH, this.pivotX - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + this.TW, this.pivotY + 6 * this.TH, 30, 0);
    }

    void drawFireBlast(Graphics g) {
        if (this.fireBlastWait) {
            switch (this.blastIndex) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.m_pBaseApp.cropBitmap(g, this.m_pBaseApp.m_pGameThread.m_pBitmap[13], this.width, this.height, this.x - this.m_pBaseApp.m_pGameThread.UPDATE_POSX + this.blast_mX, this.y + this.blast_mY, this.blastIndex - 4, 0);
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.m_pBaseApp.cropBitmap(g, this.m_pBaseApp.m_pGameThread.m_pBitmap[13], this.width, this.height, this.x - this.m_pBaseApp.m_pGameThread.UPDATE_POSX, this.y, this.blastIndex, 0);
                }
            }
        }
    }

    void updatePendulum() {
        ++this.ticks;
        if (this.ticks % 3 == 0) {
            if (this.moveForward) {
                ++this.showimage;
                if (this.showimage == 8) {
                    this.moveForward = false;
                }
            } else {
                --this.showimage;
                if (this.showimage == 0) {
                    this.moveForward = true;
                }
            }
        }
    }

    void updateFly() {
        ++this.ticks;
        switch (this.direction) {
            case 1: {
                if (this.moveForward) {
                    if (this.pivotX <= this.x + this.xMove) {
                        this.pivotX += this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                        break;
                    }
                    this.moveForward = false;
                    break;
                }
                if (this.pivotX >= this.x) {
                    this.pivotX -= this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                    break;
                }
                this.moveForward = true;
                break;
            }
            case 3: {
                if (this.moveForward) {
                    if (this.pivotX <= this.x) {
                        this.pivotX += this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                        break;
                    }
                    this.moveForward = false;
                    break;
                }
                if (this.pivotX >= this.x - this.xMove) {
                    this.pivotX -= this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                    break;
                }
                this.moveForward = true;
                break;
            }
            case 2: {
                if (this.moveUpward) {
                    if (this.pivotY <= this.y + this.yMove) {
                        this.pivotY += this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                        break;
                    }
                    this.moveUpward = false;
                    break;
                }
                if (this.pivotY >= this.y) {
                    this.pivotY -= this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                    break;
                }
                this.moveUpward = true;
                break;
            }
            case 0: {
                if (this.moveUpward) {
                    if (this.pivotY <= this.y) {
                        this.pivotY += this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                        break;
                    }
                    this.moveUpward = false;
                    break;
                }
                if (this.pivotY >= this.y - this.yMove) {
                    this.pivotY -= this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED / 2;
                    break;
                }
                this.moveUpward = true;
            }
        }
        ++this.showimage;
        if (this.showimage == 4) {
            this.showimage = 0;
        }
    }

    void updateJelly() {
        ++this.ticks;
        if (this.ticks % 2 == 0) {
            switch (this.direction) {
                case 1: {
                    if (this.moveForward) {
                        if (this.pivotX <= this.x + this.xMove) {
                            this.pivotX += this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED;
                            break;
                        }
                        this.moveForward = false;
                        break;
                    }
                    if (this.pivotX >= this.x) {
                        this.pivotX -= this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED;
                        break;
                    }
                    this.moveForward = true;
                    break;
                }
                case 3: {
                    if (this.moveForward) {
                        if (this.pivotX <= this.x) {
                            this.pivotX += this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED;
                            break;
                        }
                        this.moveForward = false;
                        break;
                    }
                    if (this.pivotX >= this.x - this.xMove) {
                        this.pivotX -= this.m_pBaseApp.m_pGamePlayer.RAMBO_SPEED;
                        break;
                    }
                    this.moveForward = true;
                }
            }
            ++this.showimage;
            if (this.showimage == 4) {
                this.showimage = 0;
            }
        }
    }

    void updateMonster() {
        switch (this.type) {
            case 13: {
                if (this.moveForward) {
                    this.pivotX = this.x;
                    this.pivotY = this.y;
                    this.moveForward = false;
                    this.moveUpward = false;
                } else if (this.pivotX >= this.x - this.xMove) {
                    this.pivotX -= 6;
                } else {
                    this.moveForward = true;
                }
                ++this.ticks;
                if (this.ticks % 1 != 0) break;
                ++this.showimage;
                if (this.showimage == 4) {
                    this.showimage = 0;
                }
                if (this.moveUpward) {
                    this.pivotY += 3;
                    break;
                }
                if (this.pivotY >= this.y - this.yMove) {
                    this.pivotY -= 3;
                    break;
                }
                this.moveUpward = true;
                break;
            }
            case 20: {
                ++this.ticks;
                if (this.ticks % 2 != 0) break;
                if (this.moveForward) {
                    if (this.pivotX <= this.x) {
                        this.pivotX += 4;
                    } else {
                        this.moveForward = false;
                    }
                } else if (this.pivotX >= this.x - this.xMove) {
                    this.pivotX -= 4;
                } else {
                    this.moveForward = true;
                }
                ++this.showimage;
                if (this.showimage == 4) {
                    this.showimage = 0;
                }
                switch (this.showimage) {
                    case 0: 
                    case 3: {
                        this.pivotY = this.y;
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.pivotY = this.y;
                        this.pivotY -= 3;
                    }
                }
                break;
            }
            case 19: {
                if (this.moveForward) {
                    this.x = this.pivotX;
                    this.y = this.pivotY;
                    this.moveForward = false;
                    this.moveUpward = false;
                    this.showimage = 1;
                    break;
                }
                if (this.x >= this.pivotX - this.xMove) {
                    this.x -= 6;
                    if (this.x > this.pivotX - this.TW) {
                        this.showimage = 1;
                        break;
                    }
                    this.showimage = 0;
                    break;
                }
                this.moveForward = true;
            }
        }
    }

    void updateRoller() {
        int x1 = 0;
        int y1 = 0;
        if (!this.isEnemyOver()) {
            if (this.isEnemyCollide()) {
                switch (this.direction) {
                    case 3: {
                        this.pivotX -= 6;
                        break;
                    }
                    case 1: {
                        this.pivotX += 6;
                    }
                }
                ++this.ticks;
                if (this.ticks % 2 == 0) {
                    if (this.x != this.pivotX) {
                        ++this.showimage;
                    }
                    if (this.showimage == 4) {
                        this.showimage = 0;
                    }
                }
            }
            if (!this.m_pBaseApp.m_pGameThread.isSolidTile(x1 = this.pivotX / this.TW, y1 = (this.pivotY + this.height) / this.TH, 1)) {
                this.pivotY += 3;
                if (y1 > this.m_pBaseApp.m_pGameThread.nrow) {
                    this.setEnemyOver();
                }
            }
        }
    }

    void updateFish() {
        switch (this.type) {
            case 11: {
                if (this.isEnemyCollide()) break;
                ++this.ticks;
                if (this.ticks % 3 == 0) {
                    ++this.showimage;
                    this.showimage %= 2;
                }
                if (this.ticks % 30 != 0) break;
                this.setEnemyCollide(this.index);
                break;
            }
            case 14: {
                ++this.ticks;
                if (!this.isEnemyCollide() || this.ticks % 1 != 0) break;
                if (this.moveUpward) {
                    if (this.pivotY >= this.y - this.yMove) {
                        this.pivotY -= 6;
                    } else {
                        this.moveUpward = false;
                    }
                } else if (this.pivotY <= this.y) {
                    this.pivotY += 6;
                } else {
                    this.ticks = 0;
                    this.setEnemyCollide(this.index);
                    this.moveUpward = true;
                }
                this.showimage = (this.y - this.pivotY) % (this.TH / 2) == 0 ? 0 : 1;
            }
        }
    }

    void reset(int type, int x, int y, int enem_index, int x_move, int y_move, int over, int direction, int collde, int connectId) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.pivotX = x;
        this.pivotY = y;
        this.index = enem_index;
        this.xMove = x_move;
        this.yMove = y_move;
        this.Enemy_over = over != 0;
        this.direction = direction;
        this.Enemy_collide = collde != 0;
        this.connect_Id = connectId;
        switch (type) {
            case 21: {
                this.width = 3 * this.TW;
                this.height = 2 * this.TH;
                break;
            }
            case 3: {
                this.width = 3 * this.TW;
                this.height = 2 * this.TH;
                this.pivotY -= this.TH;
                break;
            }
            case 9: {
                this.width = 2 * this.TW;
                this.height = this.TH;
                break;
            }
            case 4: {
                this.bitmapLocal = this.m_pBaseApp.m_pGameThread.m_pBitmap[11];
                this.width = this.m_pBaseApp.m_pGameThread.m_pBitmap[11].getWidth();
                this.height = this.m_pBaseApp.m_pGameThread.m_pBitmap[11].getHeight();
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.width = this.TW * this.xMove;
                this.height = this.TH;
                this.yMove = y_move * this.TH;
                this.bitmapLocal = this.m_pBaseApp.m_pGameThread.m_pBitmap[5];
                break;
            }
            case 2: {
                this.showimage = this.xMove;
            }
            case 1: {
                this.moveForward = true;
                this.bitmapLocal = this.m_pBaseApp.m_pGameThread.m_pBitmap[12];
                this.width = this.m_pBaseApp.m_pGameThread.m_pBitmap[12].getWidth() / 4;
                this.height = this.m_pBaseApp.m_pGameThread.m_pBitmap[12].getHeight();
                break;
            }
            case 8: {
                this.width = this.TW * 3;
                this.height = this.TH * 7;
                this.bitmapLocal = this.m_pBaseApp.m_pGameThread.m_pBitmap[5];
                break;
            }
            case 12: {
                this.width = this.m_pBaseApp.m_pGameThread.m_pBitmap[13].getWidth() / 7;
                this.height = this.m_pBaseApp.m_pGameThread.m_pBitmap[13].getHeight();
                this.x = x + this.TW / 2 - this.width / 2;
                this.pivotX = x + this.TW / 2 - this.width / 2;
                break;
            }
            case 17: {
                this.moveForward = this.direction == 1;
                this.bitmapLocal = this.m_pBaseApp.m_pGameThread.m_pBitmap[17];
                this.width = this.m_pBaseApp.m_pGameThread.m_pBitmap[17].getWidth() / 4;
                this.height = this.m_pBaseApp.m_pGameThread.m_pBitmap[17].getHeight();
                break;
            }
            case 14: {
                this.bitmapLocal = this.m_pBaseApp.m_pGameThread.m_pBitmap[14];
                this.width = this.m_pBaseApp.m_pGameThread.m_pBitmap[14].getWidth() / 2;
                this.height = this.m_pBaseApp.m_pGameThread.m_pBitmap[14].getHeight();
                this.moveUpward = true;
                break;
            }
            case 11: {
                this.bitmapLocal = this.m_pBaseApp.m_pGameThread.m_pBitmap[26];
                this.width = this.m_pBaseApp.m_pGameThread.m_pBitmap[26].getWidth() / 2;
                this.height = this.m_pBaseApp.m_pGameThread.m_pBitmap[26].getHeight();
                break;
            }
            case 18: {
                this.bitmapLocal = this.m_pBaseApp.m_pGameThread.m_pBitmap[18];
                this.width = this.m_pBaseApp.m_pGameThread.m_pBitmap[18].getWidth() / 4;
                this.height = this.m_pBaseApp.m_pGameThread.m_pBitmap[18].getHeight();
                break;
            }
            case 20: {
                this.width = this.m_pBaseApp.m_pGameThread.m_pBitmap[20].getWidth() / 4;
                this.height = this.m_pBaseApp.m_pGameThread.m_pBitmap[20].getHeight();
                this.moveForward = false;
                this.moveUpward = false;
                break;
            }
            case 13: {
                this.bitmapLocal = this.m_pBaseApp.m_pGameThread.m_pBitmap[22];
                this.width = this.m_pBaseApp.m_pGameThread.m_pBitmap[22].getWidth() / 4;
                this.height = this.m_pBaseApp.m_pGameThread.m_pBitmap[22].getHeight();
                this.moveForward = false;
                this.moveUpward = false;
                break;
            }
            case 19: {
                this.bitmapLocal = this.m_pBaseApp.m_pGameThread.m_pBitmap[19];
                this.width = this.m_pBaseApp.m_pGameThread.m_pBitmap[19].getWidth() / 2;
                this.height = this.m_pBaseApp.m_pGameThread.m_pBitmap[19].getHeight();
                break;
            }
            case 15: 
            case 16: {
                this.moveForward = this.direction == 1;
                this.moveUpward = this.direction == 0;
                switch (type) {
                    case 15: {
                        this.bitmapLocal = this.m_pBaseApp.m_pGameThread.m_pBitmap[15];
                        break;
                    }
                    case 16: {
                        this.bitmapLocal = this.m_pBaseApp.m_pGameThread.m_pBitmap[16];
                    }
                }
                this.width = this.m_pBaseApp.m_pGameThread.m_pBitmap[15].getWidth() / 4;
                this.height = this.m_pBaseApp.m_pGameThread.m_pBitmap[15].getHeight();
                break;
            }
            case 10: {
                this.moveForward = true;
                this.bitmapLocal = this.m_pBaseApp.m_pGameThread.m_pBitmap[21];
                this.width = this.m_pBaseApp.m_pGameThread.m_pBitmap[21].getWidth() / 9;
                this.height = this.m_pBaseApp.m_pGameThread.m_pBitmap[21].getHeight();
            }
        }
    }
}

