/*
 * Decompiled with CFR 0.152.
 */
package naughtysquirrel;

import javax.microedition.lcdui.Graphics;
import naughtysquirrel.BaseCanvas;
import naughtysquirrel.GameClass;

public class Player {
    BaseCanvas m_pBase;
    GameClass game;
    int currentState;
    int prevState;
    int w;
    int h;
    int X;
    int Y;
    int pX;
    int pY;
    int mX;
    int mY;
    int checkX;
    int checkY;
    int startX;
    int startY;
    int currentFrameX;
    int currentFrameY;
    int counter;
    int TIC = 3;
    int jump;
    int JUMP_HGT;
    int shiftY;
    boolean seeForward;
    boolean seeUpward;
    boolean seeDownward;
    boolean bottomCollide;
    boolean topCollide;
    boolean leftCollide;
    boolean rightCollide;
    boolean reachedTarget;
    float timeElapsed;
    float vX;
    float vY;
    float lunch_x;
    float lunch_y;
    float GRAVITY;
    double PI = 3.142857;

    public Player(BaseCanvas base) {
        this.m_pBase = base;
        this.game = this.m_pBase.m_pGameClass;
        this.inIt(2 * this.game.TW, 3 * this.game.TH);
    }

    public void inIt(int _x, int _y) {
        this.startX = _x;
        this.startY = _y;
        this.JUMP_HGT = 3 * this.game.TH + this.game.TH / 2;
        if (this.game.playerleft != null && this.game.playerleft != null) {
            this.w = this.game.playerleft.getWidth() / 10;
            this.h = this.game.playerleft.getHeight();
        }
        this.mX = this.w / 4;
        this.mY = this.h / 3;
        this.reset(_x, _y);
    }

    public void reset(int _x, int _y) {
        this.currentState = 2;
        this.counter = 0;
        this.currentFrameX = 0;
        this.currentFrameY = 0;
        this.jump = 0;
        this.X = _x;
        this.Y = _y;
        this.checkX = this.X;
        this.checkY = this.Y;
        this.shiftY = 0;
        this.seeForward = true;
        this.seeUpward = false;
        this.seeDownward = false;
        this.bottomCollide = false;
        this.topCollide = false;
        this.leftCollide = false;
        this.rightCollide = false;
        this.reachedTarget = false;
    }

    public void drawPlayer(Graphics g) {
        int jumpwidth = 67;
        int jumpheight = 95;
        int incy = 5;
        switch (this.currentState) {
            case 16: {
                this.m_pBase.cropImage(g, this.game.playerright, this.w, this.h, this.X + this.game.gameX, this.Y + this.game.gameY + incy, this.currentFrameX * this.w, this.currentFrameY * this.h);
                break;
            }
            case 0: {
                this.m_pBase.cropImage(g, this.game.playerright, this.w, this.h, this.X + this.game.gameX, this.Y + this.game.gameY + incy, this.currentFrameX * this.w, this.currentFrameY * this.h);
                break;
            }
            case 1: {
                this.m_pBase.cropImage(g, this.game.playerleft, this.w, this.h, this.X + this.game.gameX, this.Y + this.game.gameY + incy, this.currentFrameX * this.w, this.currentFrameY * this.h);
                break;
            }
            case 2: 
            case 4: {
                this.m_pBase.cropImage(g, this.game.playerrightjump, 34, 81, this.X + this.game.gameX, this.Y + this.game.gameY + incy, this.currentFrameX * jumpwidth, this.currentFrameY * jumpheight);
                break;
            }
            case 3: 
            case 5: {
                this.m_pBase.cropImage(g, this.game.playerleftjump, 34, 81, this.X + this.game.gameX, this.Y + this.game.gameY + incy, this.currentFrameX * jumpwidth, this.currentFrameY * jumpheight);
                break;
            }
            case 6: {
                this.m_pBase.cropImage(g, this.game.playerright, this.w, this.h, this.X + this.game.gameX, this.Y + this.game.gameY + incy, this.currentFrameX * this.w, this.currentFrameY * this.h);
                break;
            }
            case 7: {
                this.m_pBase.cropImage(g, this.game.playerleft, this.w, this.h, this.X + this.game.gameX, this.Y + this.game.gameY + incy, this.currentFrameX * this.w, this.currentFrameY * this.h);
                break;
            }
            case 12: 
            case 13: {
                this.m_pBase.cropImage(g, this.game.playerright, this.w, this.h, this.X + this.game.gameX, this.Y + this.game.gameY + incy, this.currentFrameX * this.w, this.currentFrameY * this.h);
                break;
            }
            case 8: 
            case 9: {
                this.m_pBase.cropImage(g, this.game.playerrightjump, 34, 81, this.X + this.game.gameX, this.Y + this.game.gameY + incy, this.currentFrameX * jumpwidth, this.currentFrameY * jumpheight);
                break;
            }
            case 14: 
            case 15: {
                this.m_pBase.cropImage(g, this.game.playerleft, this.w, this.h, this.X + this.game.gameX, this.Y + this.game.gameY + incy, this.currentFrameX * this.w, this.currentFrameY * this.h);
                break;
            }
            case 10: 
            case 11: {
                this.m_pBase.cropImage(g, this.game.playerleftjump, 34, 81, this.X + this.game.gameX, this.Y + this.game.gameY + incy, this.currentFrameX * jumpwidth, this.currentFrameY * jumpheight);
            }
        }
    }

    public void setState(int state) {
        this.prevState = this.currentState;
        this.currentState = state;
    }

    public void setX(int x) {
        this.pX = this.X;
        this.X = x;
    }

    public void setY(int y) {
        this.pY = this.Y;
        this.Y = y;
    }

    public void setStandY() {
        int y = (this.Y + this.h) / this.game.TH;
        y *= this.game.TH;
        if (Math.abs((y -= this.h) - this.Y) <= this.game.incY * 5 / 4) {
            this.setY(y);
        }
    }

    public void updateForward() {
        if (!this.checkCollision(-4)) {
            if (this.X < this.m_pBase.midlet.canvas.width - this.w) {
                this.setX(this.X + this.game.incX);
            } else {
                this.setState(0);
            }
        } else {
            this.setState(0);
        }
        if (!this.checkCollision(-2)) {
            this.setState(4);
        }
    }

    public void updateBackward() {
        if (!this.checkCollision(-3)) {
            if (this.X > 0) {
                this.setX(this.X - this.game.incX);
            } else {
                this.setState(1);
            }
        } else {
            this.setState(1);
        }
        if (!this.checkCollision(-2)) {
            this.setState(5);
        }
    }

    public void updateFall() {
        if (!this.checkCollision(-2)) {
            this.setY(this.Y + this.game.incY);
            switch (this.currentState) {
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    if (!this.checkCollision(-4)) {
                        if (this.X >= this.m_pBase.midlet.canvas.width - this.w) break;
                        this.setX(this.X + this.game.incX / 2);
                        break;
                    }
                    this.setState(2);
                    break;
                }
                case 5: {
                    if (!this.checkCollision(-3)) {
                        if (this.X <= 0) break;
                        this.setX(this.X - this.game.incX / 2);
                        break;
                    }
                    this.setState(3);
                }
            }
        } else {
            switch (this.currentState) {
                case 2: {
                    this.setStandY();
                    this.setState(0);
                    break;
                }
                case 3: {
                    this.setStandY();
                    this.setState(1);
                    break;
                }
                case 4: {
                    if (this.game.KEY_CODE == -4) {
                        this.setState(6);
                        break;
                    }
                    this.setStandY();
                    this.setState(0);
                    break;
                }
                case 5: {
                    if (this.game.KEY_CODE == -3) {
                        this.setState(7);
                        break;
                    }
                    this.setStandY();
                    this.setState(1);
                }
            }
        }
    }

    public void updateJump() {
        switch (this.currentState) {
            case 12: {
                if (this.jump < this.JUMP_HGT && !this.checkCollision(-1)) {
                    this.jump += this.game.incY;
                    this.setY(this.Y - this.game.incY);
                    this.game.shiftBackground(-1);
                    break;
                }
                this.jump = 0;
                this.setState(13);
                break;
            }
            case 13: {
                if (!this.checkCollision(-2)) {
                    this.setY(this.Y + this.game.incY);
                    this.game.shiftBackground(-2);
                    break;
                }
                this.setStandY();
                this.setState(0);
                break;
            }
            case 8: {
                if (this.jump < this.JUMP_HGT && !this.checkCollision(-1)) {
                    this.jump += this.game.incY;
                    this.setY(this.Y - this.game.incY);
                    this.game.shiftBackground(-1);
                } else {
                    this.jump = 0;
                    this.setState(9);
                }
                if (!this.checkCollision(-4)) {
                    if (this.X >= this.m_pBase.midlet.canvas.width - this.w) break;
                    this.setX(this.X + this.game.incX);
                    break;
                }
                if (this.currentState == 9) break;
                this.setState(12);
                break;
            }
            case 9: {
                if (!this.checkCollision(-2)) {
                    this.setY(this.Y + this.game.incY);
                    this.game.shiftBackground(-2);
                } else if (this.game.KEY_CODE == -4) {
                    this.setState(6);
                } else {
                    this.setStandY();
                    this.setState(0);
                }
                if (!this.checkCollision(-4)) {
                    if (this.X >= this.m_pBase.midlet.canvas.width - this.w) break;
                    this.setX(this.X + this.game.incX);
                    break;
                }
                this.setState(13);
                break;
            }
            case 14: {
                if (this.jump < this.JUMP_HGT && !this.checkCollision(-1)) {
                    this.jump += this.game.incY;
                    this.setY(this.Y - this.game.incY);
                    this.game.shiftBackground(-1);
                    break;
                }
                this.jump = 0;
                this.setState(15);
                break;
            }
            case 15: {
                if (!this.checkCollision(-2)) {
                    this.setY(this.Y + this.game.incY);
                    this.game.shiftBackground(-2);
                    break;
                }
                this.setStandY();
                this.setState(1);
                break;
            }
            case 10: {
                if (this.jump < this.JUMP_HGT && !this.checkCollision(-1)) {
                    this.jump += this.game.incY;
                    this.setY(this.Y - this.game.incY);
                    this.game.shiftBackground(-1);
                } else {
                    this.jump = 0;
                    this.setState(11);
                }
                if (!this.checkCollision(-3)) {
                    if (this.X <= 0) break;
                    this.setX(this.X - this.game.incX);
                    break;
                }
                if (this.currentState == 11) break;
                this.setState(14);
                break;
            }
            case 11: {
                if (!this.checkCollision(-2)) {
                    this.setY(this.Y + this.game.incY);
                    this.game.shiftBackground(-2);
                } else if (this.game.KEY_CODE == -3) {
                    this.setState(7);
                } else {
                    this.setStandY();
                    this.setState(1);
                }
                if (!this.checkCollision(-3)) {
                    if (this.X <= 0) break;
                    this.setX(this.X - this.game.incX);
                    break;
                }
                this.setState(15);
            }
        }
    }

    public boolean checkCollision(int dir) {
        boolean collide = false;
        switch (dir) {
            case -3: {
                collide = this.game.checkCollision(dir, this.X, this.Y, this.w, this.h, this.mX, this.mY, this.game.incX, this.game.incY, false);
                if (!this.leftCollide) break;
                collide = true;
                break;
            }
            case -4: {
                collide = this.game.checkCollision(dir, this.X, this.Y, this.w, this.h, this.mX, this.mY, this.game.incX, this.game.incY, false);
                if (!this.rightCollide) break;
                collide = true;
                break;
            }
            case -1: {
                collide = this.game.checkCollision(dir, this.X, this.Y, this.w, this.h, this.mX, this.mY, this.game.incX, this.game.incY, true);
                if (!this.topCollide) break;
                collide = true;
                break;
            }
            case -2: {
                collide = this.game.checkCollision(dir, this.X, this.Y, this.w, this.h, this.mX, this.mY, this.game.incX, this.game.incY, false);
                if (!this.bottomCollide) break;
                collide = true;
            }
        }
        return collide;
    }

    public void updateScreen() {
        if (!this.seeForward ? this.X - this.startX < Math.abs(this.game.gameX) + 5 * this.game.TW : this.X - this.startX > Math.abs(this.game.gameX)) {
            // empty if block
        }
        if (this.Y + this.h / 2 + this.game.gameY < this.m_pBase.height / 3) {
            this.seeUpward = true;
            this.seeDownward = false;
        } else if (this.Y + this.h / 2 + this.game.gameY < this.m_pBase.height * 2 / 3) {
            this.seeUpward = false;
            this.seeDownward = false;
        } else if (this.Y + this.h / 2 + this.game.gameY < this.m_pBase.height) {
            this.seeUpward = false;
            this.seeDownward = true;
        }
        if (this.seeUpward) {
            if (this.shiftY < this.JUMP_HGT) {
                ++this.shiftY;
            } else {
                this.shiftY = 0;
                this.seeUpward = false;
            }
            if (this.game.gameY < this.game.TOP_SHIFT_Y) {
                this.game.shiftBackground(-1);
            } else {
                this.seeUpward = false;
            }
        }
        if (this.seeDownward) {
            if (this.shiftY < this.JUMP_HGT) {
                ++this.shiftY;
            } else {
                this.shiftY = 0;
                this.seeDownward = false;
            }
            if (this.game.gameY > this.m_pBase.height - this.game.NO_OF_ROWS * this.game.TH + this.game.incY) {
                this.game.shiftBackground(-2);
            } else {
                this.seeDownward = false;
            }
        }
    }

    public void playerKeyPressed(int keyCode) {
        if (this.reachedTarget) {
            return;
        }
        block0 : switch (keyCode) {
            case -4: 
            case 54: {
                switch (this.currentState) {
                    case 1: {
                        this.seeForward = true;
                        this.setState(0);
                        break;
                    }
                    case 7: {
                        this.seeForward = true;
                        this.setState(0);
                        break;
                    }
                    case 0: {
                        this.seeForward = true;
                        this.setState(6);
                        break;
                    }
                    case 6: {
                        this.seeForward = true;
                        this.setState(0);
                        break;
                    }
                    case 14: {
                        this.seeForward = true;
                        this.setState(12);
                        break;
                    }
                    case 12: {
                        this.seeForward = true;
                        this.setState(8);
                        break;
                    }
                    case 15: {
                        this.seeForward = true;
                        this.setState(13);
                        break;
                    }
                    case 13: {
                        this.seeForward = true;
                        this.setState(9);
                        break;
                    }
                    case 3: {
                        this.seeForward = true;
                        this.setState(2);
                        break;
                    }
                    case 2: {
                        this.seeForward = true;
                        this.setState(4);
                        break;
                    }
                    case 10: {
                        this.seeForward = true;
                        this.setState(8);
                        break;
                    }
                    case 11: {
                        this.seeForward = true;
                        this.setState(9);
                    }
                }
                break;
            }
            case -3: 
            case 52: {
                switch (this.currentState) {
                    case 0: {
                        this.seeForward = false;
                        this.setState(1);
                        break;
                    }
                    case 6: {
                        this.seeForward = false;
                        this.setState(1);
                        break;
                    }
                    case 1: {
                        this.seeForward = false;
                        this.setState(7);
                        break;
                    }
                    case 7: {
                        this.seeForward = false;
                        this.setState(1);
                        break;
                    }
                    case 12: {
                        this.seeForward = false;
                        this.setState(14);
                        break;
                    }
                    case 14: {
                        this.seeForward = false;
                        this.setState(10);
                        break;
                    }
                    case 13: {
                        this.seeForward = false;
                        this.setState(15);
                        break;
                    }
                    case 15: {
                        this.seeForward = false;
                        this.setState(11);
                        break;
                    }
                    case 2: {
                        this.seeForward = false;
                        this.setState(3);
                        break;
                    }
                    case 3: {
                        this.seeForward = false;
                        this.setState(5);
                        break;
                    }
                    case 8: {
                        this.seeForward = false;
                        this.setState(10);
                        break;
                    }
                    case 9: {
                        this.seeForward = false;
                        this.setState(11);
                    }
                }
                break;
            }
            case -1: 
            case 50: {
                switch (this.currentState) {
                    case 0: {
                        this.jump = 0;
                        this.setState(12);
                        break;
                    }
                    case 1: {
                        this.jump = 0;
                        this.setState(14);
                        break;
                    }
                    case 6: {
                        this.jump = 0;
                        this.setState(8);
                        break;
                    }
                    case 7: {
                        this.jump = 0;
                        this.setState(10);
                    }
                }
                break;
            }
            case -2: 
            case 56: {
                switch (this.currentState) {
                    case 12: {
                        this.jump = 0;
                        this.setState(13);
                        break block0;
                    }
                    case 14: {
                        this.jump = 0;
                        this.setState(15);
                        break block0;
                    }
                    case 8: {
                        this.jump = 0;
                        this.setState(9);
                        break block0;
                    }
                    case 10: {
                        this.jump = 0;
                        this.setState(11);
                    }
                }
            }
        }
    }

    public void playerKeyPress(int keyCode) {
        if (this.reachedTarget) {
            return;
        }
        block0 : switch (keyCode) {
            case -4: 
            case 54: {
                switch (this.currentState) {
                    case 0: {
                        this.seeForward = true;
                        this.setState(6);
                        break;
                    }
                    case 1: {
                        this.seeForward = true;
                        this.setState(0);
                        break;
                    }
                    case 14: {
                        this.seeForward = true;
                        this.setState(12);
                        break;
                    }
                    case 12: {
                        this.seeForward = true;
                        this.setState(8);
                        break;
                    }
                    case 15: {
                        this.seeForward = true;
                        this.setState(13);
                        break;
                    }
                    case 13: {
                        this.seeForward = true;
                        this.setState(9);
                        break;
                    }
                    case 3: {
                        this.seeForward = true;
                        this.setState(2);
                        break;
                    }
                    case 2: {
                        this.seeForward = true;
                        this.setState(4);
                        break;
                    }
                    case 10: {
                        this.seeForward = true;
                        this.setState(8);
                        break;
                    }
                    case 11: {
                        this.seeForward = true;
                        this.setState(9);
                    }
                }
                break;
            }
            case -3: 
            case 52: {
                switch (this.currentState) {
                    case 0: {
                        this.seeForward = false;
                        this.setState(1);
                        break;
                    }
                    case 1: {
                        this.seeForward = false;
                        this.setState(7);
                        break;
                    }
                    case 12: {
                        this.seeForward = false;
                        this.setState(14);
                        break;
                    }
                    case 14: {
                        this.seeForward = false;
                        this.setState(10);
                        break;
                    }
                    case 13: {
                        this.seeForward = false;
                        this.setState(15);
                        break;
                    }
                    case 15: {
                        this.seeForward = false;
                        this.setState(11);
                        break;
                    }
                    case 2: {
                        this.seeForward = false;
                        this.setState(3);
                        break;
                    }
                    case 3: {
                        this.seeForward = false;
                        this.setState(5);
                        break;
                    }
                    case 8: {
                        this.seeForward = false;
                        this.setState(10);
                        break;
                    }
                    case 9: {
                        this.seeForward = false;
                        this.setState(11);
                    }
                }
                break;
            }
            case -1: 
            case 50: {
                switch (this.currentState) {
                    case 0: {
                        this.jump = 0;
                        this.setState(12);
                        break;
                    }
                    case 1: {
                        this.jump = 0;
                        this.setState(14);
                        break;
                    }
                    case 6: {
                        this.jump = 0;
                        this.setState(8);
                        break;
                    }
                    case 7: {
                        this.jump = 0;
                        this.setState(10);
                    }
                }
                break;
            }
            case -2: 
            case 56: {
                switch (this.currentState) {
                    case 12: {
                        this.jump = 0;
                        this.setState(13);
                        break block0;
                    }
                    case 14: {
                        this.jump = 0;
                        this.setState(15);
                        break block0;
                    }
                    case 8: {
                        this.jump = 0;
                        this.setState(9);
                        break block0;
                    }
                    case 10: {
                        this.jump = 0;
                        this.setState(11);
                    }
                }
            }
        }
    }

    public void playerKeyRelease(int keyCode) {
        if (this.reachedTarget) {
            return;
        }
        switch (keyCode) {
            case -4: 
            case 54: {
                switch (this.currentState) {
                    case 6: {
                        this.seeForward = true;
                        this.setState(0);
                    }
                }
                break;
            }
            case -3: 
            case 52: {
                switch (this.currentState) {
                    case 7: {
                        this.seeForward = false;
                        this.setState(1);
                    }
                }
                break;
            }
            case -1: 
            case 50: {
                break;
            }
        }
    }

    public void setDead(int x, int y, int theta, float velocity) {
        this.lunch_x = x;
        this.lunch_y = y;
        this.timeElapsed = 0.0f;
        this.GRAVITY = 1.8f;
        double radian = (double)theta * this.PI / 180.0;
        this.vX = (float)((double)velocity * Math.cos(radian));
        this.vY = (float)((double)velocity * Math.sin(radian));
    }

    public void updateDead() {
        this.pX = this.X;
        this.pY = this.Y;
        this.timeElapsed += 0.5f;
        this.Y = (int)(this.lunch_y - this.vY * this.timeElapsed + this.GRAVITY * this.timeElapsed * this.timeElapsed);
        this.X = (int)(this.lunch_x + this.vX * this.timeElapsed);
    }

    public void run() {
        ++this.counter;
        this.updateScreen();
        if (this.reachedTarget) {
            switch (this.currentState) {
                case 0: 
                case 1: 
                case 7: {
                    this.currentState = 6;
                    break;
                }
                case 3: 
                case 5: {
                    this.currentState = 4;
                }
            }
        }
        switch (this.currentState) {
            case 16: {
                this.currentFrameX = 0;
                this.currentFrameY = 0;
                this.updateDead();
                break;
            }
            case 0: {
                if (this.counter % this.TIC == 0) {
                    this.currentFrameX = this.currentFrameX == 1 ? 0 : 0;
                    this.currentFrameY = 0;
                }
                this.updateFall();
                this.setX(this.X);
                this.setY(this.Y);
                break;
            }
            case 1: {
                if (this.counter % this.TIC == 0) {
                    this.currentFrameX = this.currentFrameX == 1 ? 0 : 0;
                    this.currentFrameY = 0;
                }
                this.updateFall();
                this.setX(this.X);
                this.setY(this.Y);
                break;
            }
            case 2: 
            case 4: {
                this.currentFrameX = 1;
                this.currentFrameY = 0;
                this.updateFall();
                break;
            }
            case 3: 
            case 5: {
                this.currentFrameX = 1;
                this.currentFrameY = 0;
                this.updateFall();
                break;
            }
            case 6: {
                if (this.currentFrameX < 1) {
                    this.currentFrameX = 1;
                }
                this.currentFrameX = this.currentFrameX >= 9 ? 1 : ++this.currentFrameX;
                this.currentFrameY = 0;
                this.updateForward();
                break;
            }
            case 7: {
                if (this.currentFrameX < 1) {
                    this.currentFrameX = 1;
                }
                this.currentFrameX = this.currentFrameX >= 9 ? 1 : ++this.currentFrameX;
                this.currentFrameY = 0;
                this.updateBackward();
                break;
            }
            case 12: {
                this.currentFrameX = 0;
                this.currentFrameY = 0;
                this.updateJump();
                break;
            }
            case 13: {
                this.currentFrameX = 0;
                this.currentFrameY = 0;
                this.updateJump();
                break;
            }
            case 8: {
                this.currentFrameX = 1;
                this.currentFrameY = 0;
                this.updateJump();
                break;
            }
            case 9: {
                this.currentFrameX = 1;
                this.currentFrameY = 0;
                this.updateJump();
                break;
            }
            case 14: {
                this.currentFrameX = 0;
                this.currentFrameY = 0;
                this.updateJump();
                break;
            }
            case 15: {
                this.currentFrameX = 0;
                this.currentFrameY = 0;
                this.updateJump();
                break;
            }
            case 10: {
                this.currentFrameX = 1;
                this.currentFrameY = 0;
                this.updateJump();
                break;
            }
            case 11: {
                this.currentFrameX = 1;
                this.currentFrameY = 0;
                this.updateJump();
            }
        }
        if (this.Y > this.game.NO_OF_ROWS * this.game.TH) {
            this.game.setDead();
        }
    }
}

