/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Calendar;
import java.util.Date;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.Profile;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.game.Game;
import sk.inlogic.graphics.GFont;
import sk.inlogic.screen.IScreen;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class ScreenMain
implements IScreen {
    public MainCanvas mainCanvas;
    public GFont fontTableSmall;
    public GFont fontTable;
    public GFont fontCorrect;
    public GFont fontWrong;
    public GFont fontPurple;
    private Game game;
    public final byte SCREEN_INTRO;
    public final byte SCREEN_MENU;
    public final byte SCREEN_GAME = (byte)2;
    public final byte INTRO_INIT_GRAPHICS;
    public final byte INTRO_INIT;
    public final byte INTRO_LOGO_INLOGIC = (byte)2;
    public final byte INTRO_LANGUAGE = (byte)3;
    public final byte INTRO_ENABLE_MUSIC = (byte)4;
    public final byte MENU_SETTINGS;
    public final byte MENU_DAILY;
    public final byte MENU_INSTRUCTIONS = (byte)2;
    public final byte MENU_QUIT = (byte)3;
    public final byte MENU_LEVELS = (byte)4;
    public static final byte GAME_MAIN = 0;
    final byte ID_MENU_INSTRUCTIONS;
    final byte ID_MENU_ABOUT;
    final byte ID_MENU_SOUND = (byte)2;
    final byte ID_MENU_BACK = (byte)3;
    final byte ID_MENU_ITEMS_TOTAL = (byte)4;
    private int iMenuItemsTotal;
    final byte ID_BUTTON_SETTINGS;
    final byte ID_BUTTON_ABOUT;
    final byte ID_BUTTON_LEVELS = (byte)2;
    final byte ID_BUTTON_DAILY = (byte)3;
    final byte ID_BUTTON_QUIT = (byte)4;
    final byte ID_BUTTONS_TOTAL = (byte)5;
    private int screen;
    public int subScreen;
    public int iSelectedMenuItem;
    public int iSelectedButton = 2;
    public int iSelectedLevel = -1;
    public int iSelectedQuit = -1;
    public static int iUsedLanguage = -1;
    private int iButtonsTotal;
    public boolean bLoading = false;
    Rectangle[] rectMenuItems;
    Rectangle rectButtonCenter;
    Rectangle rectPlayButton;
    Rectangle[] rectMenuButtons;
    Rectangle[] rectLevelSelect;
    public int tutorialStep = -1;
    public boolean bDragInstructions = false;
    public boolean bDragLevelSelect = false;
    public int iTextLines = 1;
    public String strTextBody;
    public String strTextBodyType;
    String[] strTextMenu = new String[4];
    public String[] strTextPom = new String[3];
    public String[] dailyNums = new String[5];
    public PreparedText prepText;
    private int iInstructionsCenterY;
    private int iInstructionsWidth;
    private int iInstructionsHeight;
    private int iTextShiftY = 0;
    private int iShiftY = 0;
    private int iMaxShiftY = 0;
    private int iAboutCenterY;
    private int iAboutWidth;
    private int iAboutHeight;
    private int iMainX = 0;
    private boolean bMainIn = false;
    private boolean bMainOut = false;
    public boolean firstLevel = false;
    private static final int DELAY_TIME = 3000;
    private int delay;
    private static String[] langCodes = new String[]{"en", "de", "pt", "es", "fr", "it"};
    private static final int[] LANGUAGES = new int[]{6, 7, 8, 9, 10, 11};
    private static final int[] LANGUAGES_SELECTED = new int[]{0, 1, 2, 3, 4, 5};
    private static final int MAX_LANGUAGES = 6;
    private Rectangle[] rectLanguages = new Rectangle[6];
    private Rectangle rectSoundButton;
    private int iSelectedLanguage;
    private String time;
    private boolean dailyPlayed = false;
    public boolean dailyStarted = false;
    private boolean levelCompleted = false;
    private int levelCompletedTimer = 0;
    private boolean levelOpening = false;
    private int levelOpeningTimer = 0;
    private int levelToOpen = 0;
    private boolean levelStarsAnim = false;
    private int levelStarsAnimTimer = 0;
    private int levelStarsAnimX = 0;
    private int levelStarsAnimY = 0;
    private Rectangle rectLevelStarsAnim = new Rectangle();
    private int tableConfirmHeight = 0;
    private int selectorTutorial = -1;
    private Rectangle rectYes = new Rectangle();
    private Rectangle rectNo = new Rectangle();
    private boolean bRight = false;
    private int iShiftDirection;
    public int iShiftX = 0;
    private int iShiftStep;
    private int updateCounter = 0;
    private int iFlash;
    private int instructionControl = 0;
    private int rowShift = 0;
    private boolean music = false;
    private boolean bSelectedSound = false;
    private int ct = 0;
    private int particleVelocity = 0;
    private int iSelectedLevelX;
    private int iSelectedLevelY;
    public static Image imgBackground;
    public static Image imgHint;
    public static Image imgHint2;
    public static Image imgLogoMenu;
    public static Image imgLogoLevels;
    public static Image imgLogoIntro;
    public static Image imgQuestionBarBg;
    public static Image imgScore;
    public static Image imgDaily;
    public static Image imgAbout;
    public static Sprite sprDaily;
    public static Sprite sprLang;
    public static Sprite sprTable;
    public static Sprite sprTableS;
    public static Sprite sprBtnLevel;
    public static Sprite sprBtnMenu;
    public static Sprite sprBtnUtility;
    public static Sprite sprBtnGame;
    public static Sprite sprBtnLetters;
    public static Sprite sprBtnLetter;
    public static Sprite sprQuestionBar;
    public static Sprite sprQuestionBarAnim;
    public static Sprite sprResultIcons;
    public static Sprite sprSelectorSmall;
    public static Sprite sprSelectorBig;
    public static Sprite sprScrolling;
    public static Sprite sprTimerBg;
    public static Sprite sprPause;
    public static Sprite sprGreen;
    public static Sprite sprYellowPurple;
    public static Sprite sprGreenPurple;
    public static Sprite sprGreenGreen;
    public static Sprite sprQuestionBarSolo;
    public static Sprite sprParticles;
    public Rectangle rectTitleCenter;
    private int iHeaderHeight;
    public int[] scoreToUnlock;
    private boolean textsInited = false;

    public ScreenMain(MainCanvas mainCanvas) {
        this.SCREEN_INTRO = 0;
        this.SCREEN_MENU = 1;
        this.INTRO_INIT_GRAPHICS = 0;
        this.INTRO_INIT = 1;
        this.MENU_SETTINGS = 0;
        this.MENU_DAILY = 1;
        this.ID_MENU_INSTRUCTIONS = 0;
        this.ID_MENU_ABOUT = 1;
        this.ID_BUTTON_SETTINGS = 0;
        this.ID_BUTTON_ABOUT = 1;
        this.mainCanvas = mainCanvas;
    }

    public void update(long lTick) {
        if (this.mainCanvas.isInterrupted()) {
            return;
        }
        this.levelCompleted();
        if (this.dailyPlayed) {
            Calendar reset = Calendar.getInstance();
            reset.setTime(new Date(reset.getTime().getTime() + 86400000L));
            reset.set(13, 0);
            reset.set(12, 0);
            reset.set(11, 0);
            Profile.dailyReset = reset.getTime().getTime();
            Profile.dailyAvailable = false;
            Profile.save();
            this.dailyPlayed = false;
        }
        if (!Profile.dailyAvailable) {
            Calendar now = Calendar.getInstance();
            now.setTime(new Date(System.currentTimeMillis()));
            long dailyReset = Profile.dailyReset - now.getTime().getTime();
            int seconds = (int)(dailyReset / 1000L) % 60;
            int minutes = (int)(dailyReset / 60000L % 60L);
            int hours = (int)(dailyReset / 3600000L % 24L);
            this.time = this.textsInited ? Resources.resTexts[0].getHashedString(56) + " " + hours + ":" + minutes + ":" + seconds : "";
            if (Profile.dailyReset < System.currentTimeMillis()) {
                Profile.dailyAvailable = true;
                Profile.save();
            }
        } else {
            this.time = this.textsInited ? Resources.resTexts[0].getHashedString(58) : "";
        }
        if (this.iFlash > 0) {
            this.iFlash = (int)((long)this.iFlash - lTick);
        } else if (this.iFlash < 0) {
            this.iFlash = 0;
        }
        if (!this.bLoading) {
            block0 : switch (this.screen) {
                case 0: {
                    switch (this.subScreen) {
                        case 0: {
                            this.initGraphics();
                            break block0;
                        }
                        case 1: {
                            this.initIntro();
                            break block0;
                        }
                        case 2: {
                            if (this.delay > 0) {
                                this.delay = (int)((long)this.delay - lTick);
                                break block0;
                            }
                            this.nextScreen(0, 3);
                            break block0;
                        }
                        case 3: {
                            this.updateShift();
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.subScreen) {
                        case 0: {
                            this.updateMainX(this.bRight);
                            this.instructionControl = 0;
                            break block0;
                        }
                        case 1: {
                            this.updateMainX(this.bRight);
                            this.instructionControl = 0;
                            break block0;
                        }
                        case 2: {
                            this.updateMainX(this.bRight);
                            if (this.instructionControl == 1) {
                                this.instructionControl = 0;
                                this.updateInstructions();
                                break block0;
                            }
                            if (this.instructionControl != 0) break block0;
                            this.instructionControl = 1;
                            break block0;
                        }
                        case 4: {
                            this.updateMainX(this.bRight);
                            this.instructionControl = 0;
                            if (!Profile.tutorial || this.tutorialStep != 1) break block0;
                            this.updateShift();
                            break block0;
                        }
                        case 3: {
                            this.updateMainX(this.bRight);
                            this.instructionControl = 0;
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.subScreen) {
                        case 0: {
                            this.instructionControl = 0;
                            this.game.update(lTick);
                            break block0;
                        }
                    }
                    break;
                }
            }
            if (this.instructionControl == 0) {
                this.mainCanvas.repaint();
            }
        }
    }

    public void initMainX() {
        this.iMainX = MainCanvas.WIDTH;
        this.bMainIn = true;
        this.bMainOut = false;
    }

    public void updateMainX(boolean right) {
        if (this.bMainIn) {
            if (this.iMainX != 0) {
                if (right) {
                    this.iMainX -= MainCanvas.WIDTH >> 2;
                } else if (!right) {
                    this.iMainX += MainCanvas.WIDTH >> 2;
                }
                if (this.iMainX < 0 && right) {
                    this.iMainX = 0;
                }
                if (this.iMainX > 0 && !right) {
                    this.iMainX = 0;
                }
                if (this.iMainX == 0) {
                    this.bMainIn = false;
                    this.setTexts();
                }
            }
            return;
        }
        if (this.bMainOut) {
            if (right) {
                if (this.iMainX != -MainCanvas.WIDTH) {
                    this.iMainX -= MainCanvas.WIDTH >> 2;
                    if (this.iMainX < -MainCanvas.WIDTH) {
                        this.iMainX = -MainCanvas.WIDTH;
                    }
                } else if (this.iMainX == -MainCanvas.WIDTH) {
                    this.bMainOut = false;
                    switch (this.iSelectedButton) {
                        case 0: {
                            this.nextScreen(1, 0);
                            break;
                        }
                        case 1: {
                            this.nextScreen(1, 2);
                            break;
                        }
                        case 3: {
                            this.nextScreen(1, 1);
                            break;
                        }
                        case 2: {
                            this.nextScreen(1, 4);
                            break;
                        }
                        case 4: {
                            this.nextScreen(1, 3);
                            break;
                        }
                    }
                    this.iSelectedLevel = -1;
                    this.iSelectedLanguage = -1;
                    this.bSelectedSound = false;
                    this.bMainIn = true;
                    this.iMainX = MainCanvas.WIDTH;
                }
            }
            if (!right) {
                if (this.iMainX != MainCanvas.WIDTH) {
                    this.iMainX += MainCanvas.WIDTH >> 2;
                    if (this.iMainX > MainCanvas.WIDTH) {
                        this.iMainX = MainCanvas.WIDTH;
                    }
                } else if (this.iMainX == MainCanvas.WIDTH) {
                    this.bMainOut = false;
                    switch (this.iSelectedButton) {
                        case 0: {
                            this.nextScreen(1, 0);
                            break;
                        }
                        case 1: {
                            this.nextScreen(1, 2);
                            break;
                        }
                        case 3: {
                            this.nextScreen(1, 1);
                            break;
                        }
                        case 2: {
                            this.nextScreen(1, 4);
                            break;
                        }
                        case 4: {
                            this.nextScreen(1, 3);
                            break;
                        }
                    }
                    this.iSelectedLevel = -1;
                    this.iSelectedLanguage = -1;
                    this.bSelectedSound = false;
                    this.bMainIn = true;
                    this.iMainX = -MainCanvas.WIDTH;
                }
            }
            return;
        }
    }

    public void initNextScreen() {
        this.bMainIn = false;
        this.bMainOut = true;
    }

    public void updateShift() {
        ++this.updateCounter;
        if (this.updateCounter > 1) {
            this.updateCounter = 0;
            if (this.iShiftDirection > 0) {
                this.iShiftX += this.iShiftStep;
                if (this.iShiftX >= this.iShiftStep << 1) {
                    this.iShiftDirection = -1;
                }
            } else {
                this.iShiftX -= this.iShiftStep;
                if (this.iShiftX <= -(this.iShiftStep << 1)) {
                    this.iShiftDirection = 1;
                }
            }
        }
    }

    public void paint(Graphics g) {
        if (this.iFlash > 0) {
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            g.setColor(0);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            return;
        }
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 2: {
                        this.paintBg(g);
                        this.paintLogoInlogic(g);
                        break block0;
                    }
                    case 3: {
                        this.paintBg(g);
                        this.paintLanguages(g);
                        break block0;
                    }
                    case 4: {
                        this.paintBg(g);
                        this.paintEnableMusic(g);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        this.paintBg(g);
                        this.paintSettings(g);
                        break block0;
                    }
                    case 1: {
                        this.paintBg(g);
                        this.paintMenuPlay(g);
                        break block0;
                    }
                    case 2: {
                        this.paintBg(g);
                        this.paintInstructions(g);
                        break block0;
                    }
                    case 3: {
                        this.paintBg(g);
                        this.paintQuit(g);
                        break block0;
                    }
                    case 4: {
                        this.paintBg(g);
                        this.paintLevelSelect(g);
                        if (!this.firstLevel) break block0;
                        this.paintTutorial(g);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 0: {
                        this.paintBg(g);
                        this.game.paint(g);
                        break block0;
                    }
                }
                break;
            }
        }
        this.paintControls(g);
        Particles.paint(g);
    }

    public void paintBg(Graphics g) {
        g.drawImage(imgBackground, 0, 0, 20);
    }

    public void paintTutorial(Graphics g) {
        switch (this.tutorialStep) {
            case 0: {
                this.setTitleCenter(Resources.resTexts[0].getHashedString(74), this.fontTableSmall, MainCanvas.WIDTH - sprTableS.getWidth() * 3);
                this.paintTable(g, sprTableS, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, MainCanvas.WIDTH - sprTableS.getWidth() * 3, this.tableConfirmHeight);
                this.fontCorrect.drawString(g, Resources.resTexts[0].getHashedString(75).toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT - this.tableConfirmHeight >> 1) + this.fontTable.getHeight(), 3);
                for (int i = 0; i < this.iTextLines; ++i) {
                    this.fontTableSmall.drawString(g, this.prepText.getText(i).toCharArray(), MainCanvas.WIDTH >> 1, (MainCanvas.HEIGHT - this.tableConfirmHeight >> 1) + i * this.fontTableSmall.getHeight() + (this.fontTable.getHeight() << 1), 17);
                }
                sprBtnUtility.setFrame(5);
                sprBtnUtility.setPosition(this.rectYes.x, this.rectYes.y);
                sprBtnUtility.paint(g);
                sprBtnUtility.setFrame(4);
                sprBtnUtility.setPosition(this.rectNo.x, this.rectNo.y);
                sprBtnUtility.paint(g);
                if (!this.firstLevel) break;
                if (this.selectorTutorial == 1) {
                    sprSelectorSmall.setFrame(0);
                    sprSelectorSmall.setPosition(this.rectYes.x + (sprBtnUtility.getWidth() >> 1) - sprSelectorSmall.getWidth(), this.rectYes.y + (sprBtnUtility.getHeight() >> 1));
                    sprSelectorSmall.paint(g);
                    break;
                }
                if (this.selectorTutorial != 0) break;
                sprSelectorSmall.setFrame(0);
                sprSelectorSmall.setPosition(this.rectNo.x + (sprBtnUtility.getWidth() >> 1) - sprSelectorSmall.getWidth(), this.rectNo.y + (sprBtnUtility.getHeight() >> 1));
                sprSelectorSmall.paint(g);
                break;
            }
            case 1: {
                sprSelectorSmall.setFrame(0);
                sprSelectorSmall.setPosition(this.rectLevelSelect[1].x + (sprBtnLevel.getWidth() >> 1) - sprSelectorSmall.getWidth() + this.iShiftX, this.rectLevelSelect[1].y + (sprBtnLevel.getHeight() >> 1));
                sprSelectorSmall.paint(g);
                break;
            }
        }
    }

    public void paintGameOver(Graphics g) {
        if (this.game.isWin()) {
            this.fontTableSmall.drawString(g, this.strTextPom[0].toCharArray(), MainCanvas.WIDTH >> 1, this.fontTableSmall.getHeight(), 3);
            this.fontTableSmall.drawString(g, this.strTextPom[1].toCharArray(), MainCanvas.WIDTH >> 1, this.rectButtonCenter.y - this.fontTableSmall.getHeight(), 3);
        } else {
            this.fontTableSmall.drawString(g, this.strTextPom[0].toCharArray(), MainCanvas.WIDTH >> 1, this.fontTableSmall.getHeight(), 3);
            int lineY = 0;
            for (int i = 0; i < this.iTextLines; ++i) {
                lineY = this.iTextLines > 1 ? this.rectButtonCenter.y - this.fontTableSmall.getHeight() - (this.fontTableSmall.getHeight() >> 2) + i * this.fontTableSmall.getHeight() : this.rectButtonCenter.y - this.fontTableSmall.getHeight() - i * this.fontTableSmall.getHeight();
                this.fontTableSmall.drawString(g, this.prepText.getText(i).toCharArray(), MainCanvas.WIDTH >> 1, lineY, 3);
            }
        }
    }

    public void paintControls(Graphics g) {
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 3: {
                        this.paintLeftButton(g, 5);
                        break block0;
                    }
                    case 4: {
                        this.paintLeftButton(g, 5);
                        this.paintRightButton(g, 4);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        if (this.game.bPause) break block0;
                        this.paintMenuButtons(g);
                        this.paintSettingsSelectors(g);
                        break block0;
                    }
                    case 1: {
                        this.paintMenuButtons(g);
                        break block0;
                    }
                    case 2: {
                        this.paintMenuButtons(g);
                        break block0;
                    }
                    case 3: {
                        this.paintMenuButtons(g);
                        this.paintLeftButton(g, 5);
                        this.paintRightButton(g, 4);
                        break block0;
                    }
                    case 4: {
                        this.paintMenuButtons(g);
                        if (this.iSelectedLevel == -1) break block0;
                        sprSelectorSmall.setFrame(0);
                        sprSelectorSmall.setPosition(this.rectLevelSelect[this.iSelectedLevel].x + (sprBtnLevel.getWidth() >> 1) - sprSelectorSmall.getWidth(), this.rectLevelSelect[this.iSelectedLevel].y + (sprBtnLevel.getHeight() >> 1));
                        sprSelectorSmall.paint(g);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.subScreen) {
                    case 0: {
                        break block0;
                    }
                }
            }
        }
    }

    public void paintLevelSelect(Graphics g) {
        int frame;
        int i;
        int i2;
        this.paintTable(g, sprTable, (MainCanvas.WIDTH >> 1) + this.iMainX, (MainCanvas.HEIGHT >> 1) + sprTable.getHeight(), MainCanvas.WIDTH - (sprTable.getWidth() << 1), MainCanvas.HEIGHT);
        g.drawImage(imgScore, this.iMainX + MainCanvas.WIDTH - imgScore.getWidth() - (imgScore.getWidth() >> 2), imgScore.getHeight() >> 2, 20);
        String score = String.valueOf(Profile.stars);
        char[] scoreDigits = score.toCharArray();
        int scoreX = MainCanvas.WIDTH - (imgScore.getWidth() >> 1) - (imgScore.getWidth() >> 2) - (scoreDigits.length * sprYellowPurple.getWidth() >> 1) + this.iMainX;
        int scoreY = (imgScore.getHeight() >> 2) + (imgScore.getHeight() >> 2) * 3 - (sprYellowPurple.getHeight() >> 1);
        for (int k = 0; k < scoreDigits.length; ++k) {
            int p = Character.digit(scoreDigits[k], 10);
            p = p == 0 ? 9 : --p;
            sprYellowPurple.setFrame(p);
            sprYellowPurple.setPosition(scoreX + k * sprYellowPurple.getWidth(), scoreY);
            sprYellowPurple.paint(g);
        }
        g.drawImage(imgLogoLevels, (MainCanvas.WIDTH >> 1) - (imgLogoLevels.getWidth() >> 1) + this.iMainX, sprTable.getHeight() + (sprTable.getHeight() >> 1), 20);
        this.fontTable.drawString(g, this.strTextBody.toCharArray(), (MainCanvas.WIDTH >> 1) + this.iMainX, sprTable.getHeight() + (sprTable.getHeight() >> 1) + imgLogoLevels.getHeight() + (this.fontTable.getHeight() >> 1), 3);
        int y = sprTable.getHeight() + imgLogoLevels.getHeight() + (this.fontTable.getHeight() << 1);
        int offY = MainCanvas.HEIGHT - y - sprBtnMenu.getHeight() - (sprBtnMenu.getHeight() >> 2) - sprBtnLevel.getHeight() * 3 >> 2;
        if (offY < 0) {
            y += offY;
        }
        int offX = MainCanvas.WIDTH - sprBtnLevel.getWidth() * 3 - (sprTable.getWidth() << 1) >> 2;
        int k = 1;
        for (i2 = 0; i2 < Level.LAST_LEVEL / 3 + 1; ++i2) {
            for (int j = 0; j < 3 && k != Level.LAST_LEVEL + 1; ++k, ++j) {
                this.rectLevelSelect[k] = new Rectangle(sprTable.getWidth() + offX + j * offX + j * sprBtnLevel.getWidth() + this.iMainX, y + offY + i2 * (offY + sprBtnLevel.getHeight()) - this.rowShift * (offY + sprBtnLevel.getHeight()) - this.iShiftY, sprBtnLevel.getWidth(), sprBtnLevel.getHeight());
            }
            if (k == Level.LAST_LEVEL + 1) break;
        }
        if (this.levelCompleted) {
            this.rectLevelSelect[this.levelToOpen + 1].x += this.iShiftX;
        }
        g.setClip(0, y, MainCanvas.WIDTH, (sprBtnLevel.getHeight() + offY) * 3);
        for (i2 = 1; i2 < Level.LAST_LEVEL + 1; ++i2) {
            int p;
            int j;
            int lockY;
            int lockX;
            if (this.rectLevelSelect[i2].y <= 0 || this.rectLevelSelect[i2].y >= MainCanvas.HEIGHT) continue;
            if (Profile.completedLevels[i2 - 1] == 1) {
                sprBtnLevel.setFrame(1);
                sprBtnLevel.setPosition(this.rectLevelSelect[i2].x, this.rectLevelSelect[i2].y);
                sprBtnLevel.paint(g);
                continue;
            }
            if (Profile.openLevels[i2 - 1] == 1) {
                sprBtnLevel.setFrame(0);
                sprBtnLevel.setPosition(this.rectLevelSelect[i2].x, this.rectLevelSelect[i2].y);
                sprBtnLevel.paint(g);
                String stars = String.valueOf(this.scoreToUnlock[i2 - 1] + 1);
                char[] starsDigits = stars.toCharArray();
                lockX = this.rectLevelSelect[i2].x + (sprBtnLevel.getWidth() >> 1) + (sprBtnLevel.getWidth() >> 2) - (starsDigits.length * sprGreen.getWidth() >> 1) + this.iMainX;
                lockY = this.rectLevelSelect[i2].y + sprBtnLevel.getHeight() / 7 * 4;
                for (j = 0; j < starsDigits.length; ++j) {
                    p = Character.digit(starsDigits[j], 10);
                    p = p == 0 ? 9 : --p;
                    sprGreen.setFrame(p);
                    sprGreen.setPosition(lockX + j * sprYellowPurple.getWidth(), lockY);
                    sprGreen.paint(g);
                }
                continue;
            }
            sprBtnLevel.setFrame(2);
            sprBtnLevel.setPosition(this.rectLevelSelect[i2].x, this.rectLevelSelect[i2].y);
            sprBtnLevel.paint(g);
            String lock = String.valueOf(this.scoreToUnlock[i2 - 1]);
            char[] lockDigits = lock.toCharArray();
            lockX = this.rectLevelSelect[i2].x + (sprBtnLevel.getWidth() >> 1) - (lockDigits.length * sprYellowPurple.getWidth() >> 1) + this.iMainX;
            lockY = this.rectLevelSelect[i2].y + (sprBtnLevel.getHeight() >> 1) - (sprYellowPurple.getHeight() >> 3);
            for (j = 0; j < lockDigits.length; ++j) {
                p = Character.digit(lockDigits[j], 10);
                p = p == 0 ? 9 : --p;
                sprYellowPurple.setFrame(p);
                sprYellowPurple.setPosition(lockX + j * sprYellowPurple.getWidth(), lockY);
                sprYellowPurple.paint(g);
            }
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        int scrollers = (sprBtnLevel.getHeight() + offY) * 3 / sprScrolling.getHeight();
        int l = Level.LAST_LEVEL % 3 == 0 ? 3 : 2;
        double tmp = (double)(scrollers - 3) * ((double)this.rowShift / (double)(Level.LAST_LEVEL / 3 - l));
        if (tmp - (double)((int)tmp) >= 0.5) {
            tmp += 1.0;
        }
        for (i = 0; i < scrollers; ++i) {
            frame = 0;
            frame = i == 0 ? 0 : (i == scrollers - 1 ? 4 : 2);
            sprScrolling.setFrame(frame);
            sprScrolling.setPosition((MainCanvas.WIDTH + this.iInstructionsWidth >> 1) - (sprScrolling.getWidth() << 1) + this.iMainX, y + i * sprScrolling.getHeight());
            sprScrolling.paint(g);
        }
        for (i = 0; i < 3; ++i) {
            frame = 0;
            frame = i == 0 ? 1 : (i == 1 ? 3 : 5);
            int a = y + i * sprScrolling.getHeight() + sprScrolling.getHeight() * (int)tmp;
            sprScrolling.setFrame(frame);
            sprScrolling.setPosition((MainCanvas.WIDTH + this.iInstructionsWidth >> 1) - (sprScrolling.getWidth() << 1) + this.iMainX, a);
            sprScrolling.paint(g);
        }
        if (this.levelStarsAnim) {
            sprResultIcons.setFrame(0);
            sprResultIcons.setPosition(this.rectLevelStarsAnim.x, this.rectLevelStarsAnim.y);
            sprResultIcons.paint(g);
        }
    }

    public void paintMenuButtons(Graphics g) {
        int offX = MainCanvas.WIDTH - sprBtnMenu.getWidth() * this.iButtonsTotal >> 1;
        for (int i = 0; i < this.iButtonsTotal; ++i) {
            if (i == this.iSelectedButton) {
                sprBtnMenu.setFrame(i + 5);
                sprBtnMenu.setPosition(offX + i * sprBtnMenu.getWidth(), MainCanvas.HEIGHT - sprBtnMenu.getHeight() - (sprBtnMenu.getHeight() >> 2));
                sprBtnMenu.paint(g);
                continue;
            }
            sprBtnMenu.setFrame(i);
            sprBtnMenu.setPosition(offX + i * sprBtnMenu.getWidth(), MainCanvas.HEIGHT - sprBtnMenu.getHeight() - (sprBtnMenu.getHeight() >> 2));
            sprBtnMenu.paint(g);
        }
        if (Profile.dailyAvailable) {
            g.drawImage(imgDaily, offX + 3 * sprBtnMenu.getWidth() + sprBtnMenu.getWidth() - imgDaily.getWidth() / 3, MainCanvas.HEIGHT - sprBtnMenu.getHeight() - (sprBtnMenu.getHeight() >> 2), 3);
        }
    }

    public void paintLeftButton(Graphics g, int frame) {
        int y = MainCanvas.HEIGHT - sprBtnUtility.getHeight() - (sprBtnUtility.getHeight() >> 1);
        int x = sprBtnUtility.getWidth() >> 1;
        if (this.screen == 1 && this.subScreen == 3) {
            y -= sprBtnMenu.getHeight();
            x += sprBtnUtility.getWidth() >> 1;
        }
        sprBtnUtility.setFrame(frame);
        sprBtnUtility.setPosition(x + this.iMainX, y);
        sprBtnUtility.paint(g);
        if (this.iSelectedQuit == 1) {
            sprSelectorSmall.setFrame(0);
            sprSelectorSmall.setPosition(x + (sprBtnUtility.getWidth() >> 1) - sprSelectorSmall.getWidth(), y + (sprBtnUtility.getWidth() >> 1));
            sprSelectorSmall.paint(g);
        }
    }

    public void paintRightButton(Graphics g, int frame) {
        int y = MainCanvas.HEIGHT - sprBtnUtility.getHeight() - (sprBtnUtility.getHeight() >> 1);
        int x = MainCanvas.WIDTH - sprBtnUtility.getWidth() - (sprBtnUtility.getWidth() >> 1);
        if (this.screen == 1 && this.subScreen == 3) {
            y -= sprBtnMenu.getHeight();
            x -= sprBtnUtility.getWidth() >> 1;
        }
        sprBtnUtility.setFrame(frame);
        sprBtnUtility.setPosition(x + this.iMainX, y);
        sprBtnUtility.paint(g);
        if (this.iSelectedQuit == 0) {
            sprSelectorSmall.setFrame(0);
            sprSelectorSmall.setPosition(x + (sprBtnUtility.getWidth() >> 1) - sprSelectorSmall.getWidth(), y + (sprBtnUtility.getWidth() >> 1));
            sprSelectorSmall.paint(g);
        }
    }

    public void paintLogoInlogic(Graphics g) {
        g.drawImage(imgLogoIntro, (MainCanvas.WIDTH >> 1) - (imgLogoIntro.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (imgLogoIntro.getHeight() >> 1), 20);
    }

    public void paintLanguages(Graphics g) {
        for (int i = 0; i < 6; ++i) {
            if (i == this.iSelectedLanguage) {
                sprLang.setFrame(LANGUAGES_SELECTED[i]);
                sprLang.setPosition(this.rectLanguages[i].x + this.iShiftX + this.iMainX, this.rectLanguages[i].y);
                sprLang.paint(g);
                continue;
            }
            sprLang.setFrame(LANGUAGES[i]);
            sprLang.setPosition(this.rectLanguages[i].x + this.iMainX, this.rectLanguages[i].y);
            sprLang.paint(g);
        }
    }

    public void paintSettings(Graphics g) {
        if (this.music) {
            sprBtnUtility.setFrame(1);
        } else {
            sprBtnUtility.setFrame(0);
        }
        sprBtnUtility.setPosition(this.rectSoundButton.x + this.iMainX, this.rectSoundButton.y);
        sprBtnUtility.paint(g);
        for (int i = 0; i < 6; ++i) {
            if (i == iUsedLanguage) {
                sprLang.setFrame(LANGUAGES_SELECTED[i]);
                sprLang.setPosition(this.rectLanguages[i].x + this.iMainX, this.rectLanguages[i].y);
                sprLang.paint(g);
                continue;
            }
            sprLang.setFrame(LANGUAGES[i]);
            sprLang.setPosition(this.rectLanguages[i].x + this.iMainX, this.rectLanguages[i].y);
            sprLang.paint(g);
        }
    }

    public void paintSettingsSelectors(Graphics g) {
        for (int i = 0; i < 6; ++i) {
            if (i != this.iSelectedLanguage) continue;
            sprSelectorBig.setFrame(0);
            sprSelectorBig.setPosition(this.rectLanguages[i].x + this.iMainX + (sprLang.getWidth() >> 1) - sprSelectorBig.getWidth(), this.rectLanguages[i].y + (sprLang.getHeight() >> 1));
            sprSelectorBig.paint(g);
        }
        if (this.bSelectedSound) {
            sprSelectorSmall.setFrame(0);
            sprSelectorSmall.setPosition(this.rectSoundButton.x + this.iMainX + (sprBtnUtility.getWidth() >> 1) - sprSelectorSmall.getWidth(), this.rectSoundButton.y + (sprBtnUtility.getHeight() >> 1));
            sprSelectorSmall.paint(g);
        }
    }

    public void paintEnableMusic(Graphics g) {
        this.paintTable(g, sprTable, MainCanvas.WIDTH >> 1, MainCanvas.HEIGHT >> 1, this.rectTitleCenter.width, this.rectTitleCenter.height << 1);
        this.paintTextInRectangle(g, this.rectTitleCenter);
    }

    public void paintMenuPlay(Graphics g) {
        g.drawImage(imgLogoMenu, this.iMainX + (MainCanvas.WIDTH >> 1) - (imgLogoMenu.getWidth() >> 1), sprTable.getHeight() >> 1, 20);
        if (Profile.dailyAvailable) {
            sprDaily.setFrame(0);
        } else {
            sprDaily.setFrame(1);
        }
        sprDaily.setPosition(this.iMainX + this.rectButtonCenter.x, this.rectButtonCenter.y);
        sprDaily.paint(g);
        g.drawImage(imgScore, this.iMainX + MainCanvas.WIDTH - imgScore.getWidth() - (imgScore.getWidth() >> 2), imgScore.getHeight() >> 2, 20);
        String score = String.valueOf(Profile.stars);
        char[] scoreDigits = score.toCharArray();
        int scoreX = MainCanvas.WIDTH - (imgScore.getWidth() >> 1) - (imgScore.getWidth() >> 2) - (scoreDigits.length * sprYellowPurple.getWidth() >> 1) + this.iMainX;
        int scoreY = (imgScore.getHeight() >> 2) + (imgScore.getHeight() >> 2) * 3 - (sprYellowPurple.getHeight() >> 1);
        for (int k = 0; k < scoreDigits.length; ++k) {
            int p = Character.digit(scoreDigits[k], 10);
            p = p == 0 ? 9 : --p;
            sprYellowPurple.setFrame(p);
            sprYellowPurple.setPosition(scoreX + k * sprYellowPurple.getWidth(), scoreY);
            sprYellowPurple.paint(g);
        }
        int height = sprTable.getHeight() + sprBtnMenu.getHeight() + (sprBtnMenu.getHeight() >> 2) + this.fontTable.getHeight() * this.iTextLines + this.fontTableSmall.getHeight() + (this.fontTableSmall.getHeight() >> 1) * 3;
        this.paintTable(g, sprTable, (MainCanvas.WIDTH >> 1) + this.iMainX, MainCanvas.HEIGHT - (height >> 1) + sprTable.getHeight(), MainCanvas.WIDTH - (sprTable.getWidth() << 1), height);
        int y = MainCanvas.HEIGHT - height + (sprTable.getHeight() >> 1) + this.fontTable.getHeight();
        for (int i = 0; i < this.iTextLines; ++i) {
            this.fontTable.drawString(g, this.prepText.getText(i).toCharArray(), (MainCanvas.WIDTH >> 1) + this.iMainX, y + this.fontTable.getHeight() * i, 17);
        }
        this.fontTableSmall.drawString(g, this.time.toCharArray(), this.rectTitleCenter.getCenterX() + this.iMainX, y + this.fontTable.getHeight() * this.iTextLines, 17);
    }

    public void paintInstructions(Graphics g) {
        this.paintTable(g, sprTable, (MainCanvas.WIDTH >> 1) + this.iMainX, (MainCanvas.HEIGHT >> 1) + sprTable.getHeight(), MainCanvas.WIDTH - (sprTable.getWidth() << 1), MainCanvas.HEIGHT);
        this.fontTable.drawString(g, this.strTextBody.toCharArray(), (MainCanvas.WIDTH >> 1) + this.iMainX, sprTable.getHeight() + this.fontTable.getHeight(), 3);
        if (!this.bLoading) {
            this.paintInstructionsText(g);
        }
    }

    public void updateLevelSelect() {
        int i = Level.LAST_LEVEL % 3;
        int n = i = i == 0 ? 3 : i;
        if (this.iSelectedLevel != -1) {
            boolean isDivisibleBy3;
            if ((Keys.isActionPressed(1) || Keys.isKeyPressed(50)) && this.iSelectedLevel > 3) {
                this.iSelectedLevel -= 3;
                if (this.iSelectedLevel < (this.rowShift + 2) * 3 - 2 && this.iSelectedLevel > 3) {
                    --this.rowShift;
                }
            }
            if ((Keys.isActionPressed(2) || Keys.isKeyPressed(56)) && this.iSelectedLevel < Level.LAST_LEVEL - 2) {
                this.iSelectedLevel += 3;
                if (this.iSelectedLevel > (this.rowShift + 2) * 3 && this.iSelectedLevel <= Level.LAST_LEVEL - i) {
                    ++this.rowShift;
                }
            }
            if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                boolean bl = isDivisibleBy3 = (this.iSelectedLevel - 1) % 3 == 0;
                if (isDivisibleBy3) {
                    this.iSelectedButton = 2;
                    this.changeSelectedButton(-1);
                    this.iFlash = 0;
                    this.initNextScreen();
                } else {
                    --this.iSelectedLevel;
                }
            }
            if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                boolean bl = isDivisibleBy3 = this.iSelectedLevel % 3 == 0;
                if (isDivisibleBy3 || this.iSelectedLevel == Level.LAST_LEVEL) {
                    this.iSelectedButton = 2;
                    this.changeSelectedButton(1);
                    this.iFlash = 0;
                    this.initNextScreen();
                } else {
                    ++this.iSelectedLevel;
                }
            }
        }
    }

    public void updateInstructions() {
        if ((Keys.isActionPressed(1) || Keys.isKeyPressed(50)) && this.iShiftY > 0) {
            this.iShiftY -= this.fontTableSmall.getHeight();
            if (this.iShiftY < 0) {
                this.iShiftY = 0;
            }
        }
        if ((Keys.isActionPressed(2) || Keys.isKeyPressed(56)) && this.iShiftY < this.iMaxShiftY) {
            this.iShiftY += this.fontTableSmall.getHeight();
            if (this.iShiftY > this.iMaxShiftY) {
                this.iShiftY = this.iMaxShiftY;
            }
        }
    }

    public boolean isPressedInstructionsText(int x, int y) {
        return x > (MainCanvas.WIDTH >> 1) - (this.iInstructionsWidth >> 1) && x < (MainCanvas.WIDTH >> 1) + (this.iInstructionsWidth >> 1) && y > this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) && y < this.iInstructionsCenterY + (this.iInstructionsHeight >> 1);
    }

    public boolean isPressedLevelSelect(int x, int y) {
        int posY = sprTable.getHeight() + (sprTable.getHeight() >> 1) + imgLogoLevels.getHeight() + (this.fontTable.getHeight() << 1);
        int offY = MainCanvas.HEIGHT - posY - sprBtnMenu.getHeight() - (sprBtnMenu.getHeight() >> 2) - sprBtnLevel.getHeight() * 3 >> 2;
        return x >= 0 && x <= MainCanvas.WIDTH && y > posY && y < posY + (sprBtnLevel.getHeight() + offY) * 3;
    }

    public void paintInstructionsText(Graphics g) {
        int frame;
        int i;
        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1);
        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1);
        g.setClip(0, iTextYUp, MainCanvas.WIDTH, iTextYDown - iTextYUp);
        int lineY = 0;
        int logo = iTextYUp + (this.iTextLines + 2) * this.fontTableSmall.getHeight() - this.iShiftY;
        for (int i2 = 0; i2 < this.iTextLines; ++i2) {
            lineY = iTextYUp + (i2 + 1) * this.fontTableSmall.getHeight() - this.iShiftY;
            if (lineY + this.fontTableSmall.getHeight() <= this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) || lineY >= this.iInstructionsCenterY + (this.iInstructionsHeight >> 1)) continue;
            this.fontTableSmall.drawString(g, this.prepText.getText(i2).toCharArray(), (MainCanvas.WIDTH >> 1) + this.iMainX, lineY, 17);
        }
        if (logo > this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) && logo < this.iInstructionsCenterY + (this.iInstructionsHeight >> 1)) {
            g.drawImage(imgAbout, (MainCanvas.WIDTH - imgAbout.getWidth() >> 1) + this.iMainX, logo, 20);
        }
        if (logo > this.iInstructionsCenterY - (this.iInstructionsHeight >> 1) && logo + imgAbout.getHeight() < this.iInstructionsCenterY + (this.iInstructionsHeight >> 1)) {
            String version = X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + " " + X.singleton.getAppProperty("MIDlet-Version");
            this.fontTableSmall.drawString(g, version.toCharArray(), (MainCanvas.WIDTH >> 1) + this.iMainX, logo + imgAbout.getHeight(), 17);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        int scrollers = this.iInstructionsHeight / sprScrolling.getHeight();
        double tmp = (double)(scrollers - 3) * ((double)this.iShiftY / (double)this.iMaxShiftY);
        for (i = 0; i < scrollers; ++i) {
            frame = 0;
            frame = i == 0 ? 0 : (i == scrollers - 1 ? 4 : 2);
            sprScrolling.setFrame(frame);
            sprScrolling.setPosition((MainCanvas.WIDTH + this.iInstructionsWidth >> 1) - (sprScrolling.getWidth() << 1) + this.iMainX, iTextYUp + i * sprScrolling.getHeight());
            sprScrolling.paint(g);
        }
        for (i = 0; i < 3; ++i) {
            frame = 0;
            frame = i == 0 ? 1 : (i == 1 ? 3 : 5);
            int y = iTextYUp + i * sprScrolling.getHeight() + sprScrolling.getHeight() * (int)tmp;
            sprScrolling.setFrame(frame);
            sprScrolling.setPosition((MainCanvas.WIDTH + this.iInstructionsWidth >> 1) - (sprScrolling.getWidth() << 1) + this.iMainX, y);
            sprScrolling.paint(g);
        }
    }

    public void paintQuit(Graphics g) {
        int y = MainCanvas.HEIGHT - sprBtnUtility.getHeight() - sprBtnMenu.getHeight();
        int height = sprBtnUtility.getHeight() + (sprBtnUtility.getHeight() >> 1) + sprBtnMenu.getHeight() + (sprBtnMenu.getHeight() >> 2) + sprTable.getHeight();
        this.paintTable(g, sprTable, (MainCanvas.WIDTH >> 1) + this.iMainX, MainCanvas.HEIGHT - (height >> 1) + sprTable.getHeight(), MainCanvas.WIDTH - (sprTable.getWidth() << 1), height);
        this.fontTableSmall.drawString(g, this.strTextBody.toCharArray(), this.rectTitleCenter.getCenterX() + this.iMainX, y - (this.fontTableSmall.getHeight() >> 1), 17);
    }

    public void paintTextInRectangle(Graphics g, Rectangle rect) {
        int iCenterY = MainCanvas.HEIGHT >> 1;
        int textHeight = this.fontTableSmall.getHeight() * this.iTextLines;
        int pomY = iCenterY - (textHeight >> 1) - 1;
        for (int i = 0; i < this.iTextLines; ++i) {
            this.fontTableSmall.drawString(g, this.prepText.getText(i).toCharArray(), rect.getCenterX() + this.iMainX, pomY, 17);
            pomY += this.fontTableSmall.getHeight();
        }
    }

    public void setTitleCenter(String s, GFont font, int textMaxWidth) {
        this.rectTitleCenter.height = font.getHeight() + (font.getHeight() >> 1);
        this.prepText = new PreparedText(font);
        this.prepText.prepareText(s, textMaxWidth);
        this.iTextLines = this.prepText.getTextHeight() / font.getHeight();
        if (this.iTextLines > 1) {
            this.rectTitleCenter.height += (this.iTextLines - 1) * font.getHeight() + 1;
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void soundOn() {
        Profile.bMusic = true;
        this.music = true;
        MainCanvas.soundManager.SetSoundOn(true);
        MainCanvas.soundManager.SetMusicOn(true);
    }

    public void soundOff() {
        Profile.bMusic = false;
        this.music = false;
        MainCanvas.soundManager.SetSoundOn(false);
        MainCanvas.soundManager.SetMusicOn(false);
    }

    public boolean getMusic() {
        return this.music;
    }

    public void changeLanguage(int iType) {
        switch (iType) {
            case 0: {
                if (this.iSelectedLanguage < 3) {
                    this.iSelectedLanguage += 3;
                    break;
                }
                this.iSelectedLanguage -= 3;
                break;
            }
            case 1: {
                if (this.iSelectedLanguage < 3) {
                    this.iSelectedLanguage += 3;
                    break;
                }
                this.iSelectedLanguage -= 3;
                break;
            }
            case 2: {
                if (this.iSelectedLanguage > 0) {
                    --this.iSelectedLanguage;
                    break;
                }
                this.iSelectedLanguage = 5;
                break;
            }
            case 3: {
                if (this.iSelectedLanguage < 5) {
                    ++this.iSelectedLanguage;
                    break;
                }
                this.iSelectedLanguage = 0;
                break;
            }
        }
    }

    public void changeSettings(int iType) {
        switch (iType) {
            case 0: {
                if (this.iSelectedLanguage > 2) {
                    this.iSelectedLanguage -= 3;
                }
                if (!this.bSelectedSound) break;
                this.iSelectedLanguage = 4;
                this.bSelectedSound = false;
                break;
            }
            case 1: {
                if (this.iSelectedLanguage < 3 && !this.bSelectedSound) {
                    this.iSelectedLanguage += 3;
                    break;
                }
                if (this.bSelectedSound) {
                    this.iSelectedLanguage = -1;
                    this.bSelectedSound = false;
                    this.iSelectedButton = 0;
                    break;
                }
                this.iSelectedLanguage = -1;
                this.bSelectedSound = true;
                break;
            }
            case 2: {
                if (this.bSelectedSound) break;
                if (this.iSelectedLanguage > 0 && this.iSelectedLanguage < 3) {
                    --this.iSelectedLanguage;
                    break;
                }
                if (this.iSelectedLanguage <= 3 || this.iSelectedLanguage >= 6) break;
                --this.iSelectedLanguage;
                break;
            }
            case 3: {
                if (this.bSelectedSound || this.iSelectedLanguage == 2 || this.iSelectedLanguage == 5) {
                    this.iSelectedButton = 0;
                    this.iFlash = 0;
                    this.changeSelectedButton(1);
                    this.initNextScreen();
                    break;
                }
                if (this.bSelectedSound) break;
                if (this.iSelectedLanguage >= 0 && this.iSelectedLanguage < 2) {
                    ++this.iSelectedLanguage;
                    break;
                }
                if (this.iSelectedLanguage <= 2 || this.iSelectedLanguage >= 5) break;
                ++this.iSelectedLanguage;
                break;
            }
        }
    }

    public void changeSound() {
        Profile.bMusic = !Profile.bMusic;
        Profile.save();
        if (Profile.bMusic) {
            this.soundOn();
            this.playMusic(Sounds.MUSIC_MENU, -1);
        } else {
            this.soundOff();
        }
        this.setTexts();
    }

    public void changeSelectedMenuItem(int iShift) {
        this.iSelectedMenuItem = iShift > 0 ? (this.iSelectedMenuItem < this.iMenuItemsTotal - 1 ? ++this.iSelectedMenuItem : 0) : (this.iSelectedMenuItem > 0 ? --this.iSelectedMenuItem : this.iMenuItemsTotal - 1);
    }

    public void changeSelectedButton(int iShift) {
        if (iShift > 0) {
            if (this.iSelectedButton < this.iButtonsTotal - 1 && this.iSelectedButton >= 0) {
                this.bRight = true;
                ++this.iSelectedButton;
            }
        } else if (this.iSelectedButton < this.iButtonsTotal && this.iSelectedButton > 0) {
            this.bRight = false;
            --this.iSelectedButton;
        }
    }

    public void levelCompleted() {
        if (this.levelStarsAnim) {
            if (this.levelStarsAnimTimer == 10) {
                this.levelStarsAnim = false;
                this.levelStarsAnimTimer = 0;
                this.iShiftX = 0;
                if (!this.levelOpening) {
                    ++Profile.stars;
                }
            } else {
                if (this.levelOpening) {
                    this.updateShift();
                    this.updateShift();
                }
                this.rectLevelStarsAnim.x -= this.levelStarsAnimX;
                this.rectLevelStarsAnim.y -= this.levelStarsAnimY;
                ++this.levelStarsAnimTimer;
            }
        }
        if (this.levelOpening && !this.levelStarsAnim) {
            if (this.levelOpeningTimer == 15) {
                Profile.openLevels[this.levelToOpen] = 1;
                this.levelOpening = false;
                this.levelOpeningTimer = 0;
                this.ct = 0;
                this.createParticles(this.rectLevelSelect[this.levelToOpen + 1].getCenterX(), this.rectLevelSelect[this.levelToOpen + 1].getCenterY(), 5, 1);
                this.levelToOpen = 0;
            } else if (this.levelOpeningTimer == 10) {
                Profile.stars -= this.scoreToUnlock[this.levelToOpen];
                this.rectLevelStarsAnim = new Rectangle(MainCanvas.WIDTH - (imgScore.getWidth() >> 1) - (imgScore.getWidth() >> 2) - (sprResultIcons.getWidth() >> 1), (imgScore.getHeight() >> 1) + (imgScore.getHeight() >> 2) - (sprResultIcons.getHeight() >> 1), sprResultIcons.getWidth(), sprResultIcons.getHeight());
                this.levelStarsAnimX = (this.rectLevelStarsAnim.getCenterX() - this.rectLevelSelect[this.levelToOpen + 1].getCenterX()) / 10;
                this.levelStarsAnimY = (this.rectLevelStarsAnim.getCenterY() - this.rectLevelSelect[this.levelToOpen + 1].getCenterY()) / 10;
                this.levelStarsAnim = true;
            }
            if (this.levelOpening) {
                ++this.levelOpeningTimer;
            }
        }
        if (this.levelCompleted && !this.levelOpening && !this.levelStarsAnim) {
            if (this.levelCompletedTimer == this.scoreToUnlock[this.iSelectedLevel - 1] + 11 + Level.LAST_LEVEL) {
                this.levelCompleted = false;
                this.levelCompletedTimer = 0;
                Profile.save();
                Profile.load();
                this.nextScreen(1, 4);
            } else if (this.levelCompletedTimer > this.scoreToUnlock[this.iSelectedLevel - 1] + 11 && this.levelCompletedTimer < this.scoreToUnlock[this.iSelectedLevel - 1] + 11 + Level.LAST_LEVEL) {
                if (!this.levelOpening) {
                    for (int i = 0; i < Profile.openLevels.length; ++i) {
                        if (Profile.openLevels[i] != 0) continue;
                        this.levelToOpen = i;
                        break;
                    }
                    if (this.scoreToUnlock[this.levelToOpen] <= Profile.stars && this.levelToOpen != 0) {
                        this.levelOpening = true;
                    }
                }
            } else if (this.levelCompletedTimer == this.scoreToUnlock[this.iSelectedLevel - 1] + 6) {
                this.ct = 0;
                this.createParticles(this.rectLevelSelect[this.iSelectedLevel].getCenterX(), this.rectLevelSelect[this.iSelectedLevel].getCenterY(), 11, 7);
                Profile.completedLevels[this.iSelectedLevel - 1] = 1;
            } else if (this.levelCompletedTimer < this.scoreToUnlock[this.iSelectedLevel - 1] + 1 && !this.levelStarsAnim) {
                this.rectLevelStarsAnim = new Rectangle(this.rectLevelSelect[this.iSelectedLevel].getCenterX() - (sprResultIcons.getWidth() >> 1), this.rectLevelSelect[this.iSelectedLevel].getCenterY() - (sprResultIcons.getHeight() >> 1), sprResultIcons.getWidth(), sprResultIcons.getHeight());
                this.levelStarsAnimX = (this.rectLevelStarsAnim.getCenterX() - (MainCanvas.WIDTH - (imgScore.getWidth() >> 1) - (imgScore.getWidth() >> 2))) / 10;
                this.levelStarsAnimY = (this.rectLevelStarsAnim.getCenterY() - ((imgScore.getHeight() >> 1) + (imgScore.getHeight() >> 2))) / 10;
                this.levelStarsAnim = true;
            }
            if (this.levelCompleted) {
                ++this.levelCompletedTimer;
            }
        }
        Particles.update();
        if (this.levelCompleted) {
            if (this.ct == 0) {
                sprParticles.setTransform(0);
            } else if (this.ct == 1) {
                sprParticles.setTransform(5);
            } else if (this.ct == 2) {
                sprParticles.setTransform(3);
            } else if (this.ct == 3) {
                sprParticles.setTransform(6);
                this.ct = 0;
            }
            ++this.ct;
        }
    }

    public void createParticles(int x, int y, int frame, int frameS) {
        this.particleVelocity = sprBtnLevel.getWidth() / 2;
        Particles.createParticle(x, y, 0, -this.particleVelocity, 0, this.particleVelocity / 15, sprParticles, frame, 16);
        Particles.createParticle(x, y, this.particleVelocity, -this.particleVelocity, -this.particleVelocity / 15, this.particleVelocity / 15, sprParticles, frameS, 13);
        Particles.createParticle(x, y, this.particleVelocity, 0, -this.particleVelocity / 15, 0, sprParticles, frame, 15);
        Particles.createParticle(x, y, this.particleVelocity, this.particleVelocity, -this.particleVelocity / 15, -this.particleVelocity / 15, sprParticles, frameS, 14);
        Particles.createParticle(x, y, 0, this.particleVelocity, 0, -this.particleVelocity / 15, sprParticles, frame, 16);
        Particles.createParticle(x, y, -this.particleVelocity, this.particleVelocity, this.particleVelocity / 15, -this.particleVelocity / 15, sprParticles, frameS, 13);
        Particles.createParticle(x, y, -this.particleVelocity, 0, this.particleVelocity / 15, 0, sprParticles, frame, 15);
        Particles.createParticle(x, y, -this.particleVelocity, -this.particleVelocity, this.particleVelocity / 15, this.particleVelocity / 15, sprParticles, frameS, 14);
    }

    public void keyReleased(int keyCode) {
        if (!(this.levelCompleted || this.bMainIn || this.bMainOut)) {
            block0 : switch (this.screen) {
                case 0: {
                    switch (this.subScreen) {
                        case 2: {
                            if (this.delay <= 100) break block0;
                            this.delay = 100;
                            break block0;
                        }
                        case 3: {
                            if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                                this.changeLanguage(0);
                                return;
                            }
                            if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                                this.changeLanguage(1);
                                return;
                            }
                            if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                                this.changeLanguage(2);
                                return;
                            }
                            if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                                this.changeLanguage(3);
                                return;
                            }
                            if (!Keys.isFKLeftCode(keyCode) && !Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                            iUsedLanguage = this.iSelectedLanguage;
                            this.nextScreen(0, 4);
                            this.iShiftX = 0;
                            return;
                        }
                        case 4: {
                            if (Keys.isFKLeftCode(keyCode)) {
                                this.soundOn();
                                this.init();
                                return;
                            }
                            if (!Keys.isFKRightCode(keyCode)) break block0;
                            this.soundOff();
                            this.init();
                            return;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.subScreen) {
                        case 0: {
                            if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                                if (this.iSelectedLanguage == -1 && !this.bSelectedSound) {
                                    this.iSelectedLanguage = 0;
                                } else {
                                    this.changeSettings(0);
                                }
                                return;
                            }
                            if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                                if (this.iSelectedLanguage != -1 || this.bSelectedSound) {
                                    this.changeSettings(1);
                                }
                                return;
                            }
                            if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                                if (this.iSelectedLanguage != -1 || this.bSelectedSound) {
                                    this.changeSettings(2);
                                }
                                return;
                            }
                            if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                                if (this.iSelectedLanguage == -1 && !this.bSelectedSound) {
                                    if (this.iSelectedButton != this.iButtonsTotal - 1) {
                                        this.changeSelectedButton(1);
                                        this.iFlash = 0;
                                        this.initNextScreen();
                                    }
                                } else if (this.iSelectedLanguage != -1 || this.bSelectedSound) {
                                    this.changeSettings(3);
                                }
                                return;
                            }
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                            if (this.iSelectedLanguage != -1) {
                                iUsedLanguage = this.iSelectedLanguage;
                                Resources.initLangDirs(langCodes[iUsedLanguage]);
                                Resources.loadText(0);
                            }
                            if (this.bSelectedSound) {
                                this.changeSound();
                            }
                            this.setTexts();
                            return;
                        }
                        case 1: {
                            if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                                if (this.iSelectedButton != 0) {
                                    this.changeSelectedButton(-1);
                                    this.iFlash = 0;
                                    this.initNextScreen();
                                }
                                return;
                            }
                            if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                                if (this.iSelectedButton != this.iButtonsTotal - 1) {
                                    this.changeSelectedButton(1);
                                    this.iFlash = 0;
                                    this.initNextScreen();
                                }
                                return;
                            }
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                            if (this.iSelectedButton == 3 && Profile.dailyAvailable) {
                                this.dailyStarted = true;
                                this.dailyPlayed = true;
                                this.iSelectedLevel = -1;
                                Game.startTime = System.currentTimeMillis();
                                Game.stage = 0;
                                Game.timerPause = 0L;
                                this.dailyNums = new String[5];
                                this.game.dailyAfterRestart = 0;
                                this.nextScreen(2, 0);
                            }
                            return;
                        }
                        case 2: {
                            if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                                if (this.iSelectedButton != 0) {
                                    this.changeSelectedButton(-1);
                                    this.iFlash = 0;
                                    this.initNextScreen();
                                }
                                return;
                            }
                            if (!Keys.isActionPressed(4) && !Keys.isKeyPressed(54)) break block0;
                            if (this.iSelectedButton != this.iButtonsTotal - 1) {
                                this.changeSelectedButton(1);
                                this.iFlash = 0;
                                this.initNextScreen();
                            }
                            return;
                        }
                        case 3: {
                            if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                                if (this.iSelectedQuit == -1) {
                                    this.iSelectedQuit = 0;
                                }
                                return;
                            }
                            if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                                if (this.iSelectedButton != 0 && this.iSelectedQuit == -1) {
                                    this.changeSelectedButton(-1);
                                    this.iFlash = 0;
                                    this.initNextScreen();
                                } else if (this.iSelectedQuit == 0) {
                                    this.iSelectedQuit = 1;
                                }
                                return;
                            }
                            if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                                if (this.iSelectedQuit == 1) {
                                    this.iSelectedQuit = 0;
                                }
                                return;
                            }
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                            if (this.iSelectedQuit == 1) {
                                this.iSelectedQuit = -1;
                                this.quit();
                                return;
                            }
                            if (this.iSelectedQuit == 0) {
                                this.iSelectedQuit = -1;
                                this.changeSelectedButton(-1);
                                this.iFlash = 0;
                                this.initNextScreen();
                                this.setTexts();
                                return;
                            }
                            return;
                        }
                        case 4: {
                            if (Keys.isActionPressed(3) || Keys.isKeyPressed(52)) {
                                if (this.firstLevel) {
                                    if (this.tutorialStep == 0) {
                                        this.selectorTutorial = 1;
                                    }
                                    return;
                                }
                                if (this.iSelectedButton != 0 && this.iSelectedLevel == -1) {
                                    this.changeSelectedButton(-1);
                                    this.iFlash = 0;
                                    this.initNextScreen();
                                } else if (this.iSelectedLevel != -1) {
                                    this.updateLevelSelect();
                                }
                                return;
                            }
                            if (Keys.isActionPressed(4) || Keys.isKeyPressed(54)) {
                                if (this.firstLevel) {
                                    if (this.tutorialStep == 0) {
                                        this.selectorTutorial = 0;
                                    }
                                    return;
                                }
                                if (this.iSelectedButton != this.iButtonsTotal - 1 && this.iSelectedLevel == -1) {
                                    this.changeSelectedButton(1);
                                    this.iFlash = 0;
                                    this.initNextScreen();
                                    this.setTexts();
                                } else if (this.iSelectedLevel != -1) {
                                    this.updateLevelSelect();
                                }
                                return;
                            }
                            if (Keys.isActionPressed(1) || Keys.isKeyPressed(50)) {
                                if (this.firstLevel || Profile.tutorial) {
                                    return;
                                }
                                if (this.iSelectedLevel == -1) {
                                    this.iSelectedLevel = Profile.iLevel + 1;
                                } else if (this.iSelectedLevel != -1) {
                                    this.updateLevelSelect();
                                }
                                return;
                            }
                            if (Keys.isActionPressed(2) || Keys.isKeyPressed(56)) {
                                if (this.firstLevel || Profile.tutorial) {
                                    return;
                                }
                                if (this.iSelectedLevel != -1) {
                                    this.updateLevelSelect();
                                }
                                return;
                            }
                            if (!Keys.isActionPressed(5) && !Keys.isKeyPressed(53)) break block0;
                            if (this.firstLevel && this.tutorialStep == 0) {
                                if (this.selectorTutorial == 1) {
                                    Profile.tutorial = true;
                                    Profile.save();
                                    Game.startTime = System.currentTimeMillis();
                                    Game.stage = 0;
                                    Game.timerPause = 0L;
                                    this.iSelectedLevel = 1;
                                    this.tutorialStep = 2;
                                    this.firstLevel = false;
                                    this.game.tutorialMsg = true;
                                    this.game.bTutorialTable = true;
                                    this.nextScreen(2, 0);
                                    return;
                                }
                                if (this.selectorTutorial == 0) {
                                    Profile.tutorial = false;
                                    Game.startTime = System.currentTimeMillis();
                                    Game.stage = 0;
                                    Game.timerPause = 0L;
                                    this.iSelectedLevel = 1;
                                    this.tutorialStep = -1;
                                    this.firstLevel = false;
                                    this.nextScreen(2, 0);
                                    return;
                                }
                            }
                            if (this.iSelectedLevel != -1) {
                                if (this.iSelectedLevel == 1) {
                                    this.firstLevel = true;
                                    this.tutorialStep = 0;
                                    this.iSelectedLevel = -1;
                                    this.selectorTutorial = 1;
                                    return;
                                }
                                if (Profile.openLevels[this.iSelectedLevel - 1] == 1) {
                                    Game.startTime = System.currentTimeMillis();
                                    Game.stage = 0;
                                    Game.timerPause = 0L;
                                    this.nextScreen(2, 0);
                                }
                            }
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.subScreen) {
                        case 0: {
                            if (this.game.stepTimer > 0) {
                                return;
                            }
                            if (Keys.isFKRightCode(keyCode) && this.game.isWin()) {
                                if (Game.stage != 5) {
                                    if (Profile.tutorial) {
                                        if (this.game.tutorialMsg) {
                                            this.game.tutorialMsg = false;
                                            return;
                                        }
                                        if (this.tutorialStep == 5) {
                                            ++this.tutorialStep;
                                        }
                                        if (this.tutorialStep == 11) {
                                            this.iShiftX = 0;
                                            this.tutorialStep = -1;
                                            this.firstLevel = false;
                                            Profile.tutorial = false;
                                            Profile.save();
                                        }
                                    }
                                    this.nextScreen(2, 0);
                                    break block0;
                                }
                                if (this.dailyStarted) {
                                    this.dailyStarted = false;
                                    this.iSelectedButton = 3;
                                    this.nextScreen(1, 1);
                                } else {
                                    this.iSelectedButton = 2;
                                    this.nextScreen(1, 4);
                                    if (Profile.completedLevels[this.iSelectedLevel - 1] == 0) {
                                        this.levelCompleted = true;
                                    }
                                }
                                Profile.save();
                                Profile.load();
                                return;
                            }
                            if (Keys.isFKLeftCode(keyCode) && !this.game.bPause && !this.game.timeUp) {
                                this.game.selectorPause = 0;
                                this.game.pause();
                                return;
                            }
                            this.game.keyReleased(keyCode);
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        Keys.resetAllPressedKeysAndActions();
    }

    public void pointerPressed(int x, int y) {
        if (!(this.bMainIn || this.bMainOut || this.levelCompleted || Profile.tutorial)) {
            if (this.screen == 1 && this.subScreen == 2) {
                if (this.isPressedInstructionsText(x, y)) {
                    this.bDragInstructions = true;
                }
            } else if (this.screen == 1 && this.subScreen == 4 && this.isPressedLevelSelect(x, y)) {
                this.iSelectedLevelX = x;
                this.iSelectedLevelY = y;
                this.bDragLevelSelect = true;
            }
        }
    }

    public void quit() {
        X.quitApp();
    }

    public boolean isMiddleButtonPressed(int x, int y) {
        return this.rectButtonCenter.contains(x, y);
    }

    public boolean isLeftButtonPressed(int x, int y) {
        int shiftX = 0;
        int shiftY = 0;
        if (this.screen == 1 && this.subScreen == 3) {
            shiftX = sprBtnUtility.getWidth() >> 1;
            shiftY = sprBtnMenu.getHeight();
        }
        if (this.screen == 2 && this.subScreen == 0 && !this.game.bPause) {
            int offX = (MainCanvas.WIDTH - (sprBtnGame.getWidth() << 1) - sprTimerBg.getWidth() - imgQuestionBarBg.getWidth()) / 5;
            if (MainCanvas.WIDTH >= MainCanvas.HEIGHT) {
                offX = sprBtnGame.getWidth() >> 2;
            }
            if (x >= offX && x <= sprBtnGame.getWidth() + offX && y >= MainCanvas.HEIGHT - sprBtnGame.getHeight() - offX && y <= MainCanvas.HEIGHT - offX) {
                return true;
            }
        } else if (x >= (sprBtnUtility.getWidth() >> 1) + shiftX && x <= (sprBtnUtility.getWidth() >> 1) + sprBtnUtility.getWidth() + shiftX && y >= MainCanvas.HEIGHT - sprBtnUtility.getHeight() - (sprBtnUtility.getHeight() >> 1) - shiftY && y <= MainCanvas.HEIGHT - (sprBtnUtility.getHeight() >> 1) - shiftY) {
            return true;
        }
        return false;
    }

    public boolean isRightButtonPressed(int x, int y) {
        int shiftX = 0;
        int shiftY = 0;
        if (this.screen == 1 && this.subScreen == 3) {
            shiftX = sprBtnUtility.getWidth() >> 1;
            shiftY = sprBtnMenu.getHeight();
        }
        if (this.screen == 2 && this.subScreen == 0) {
            int offX = (MainCanvas.WIDTH - (sprBtnGame.getWidth() << 1) - sprTimerBg.getWidth() - imgQuestionBarBg.getWidth()) / 5;
            if (MainCanvas.WIDTH >= MainCanvas.HEIGHT) {
                offX = sprBtnGame.getWidth() >> 2;
            }
            if (x >= MainCanvas.WIDTH - sprBtnGame.getWidth() - offX && x <= MainCanvas.WIDTH - offX && y >= MainCanvas.HEIGHT - sprBtnGame.getHeight() - offX && y <= MainCanvas.HEIGHT - offX) {
                return true;
            }
        } else if (x <= MainCanvas.WIDTH - (sprBtnUtility.getWidth() >> 1) - shiftX && x >= MainCanvas.WIDTH - (sprBtnUtility.getWidth() >> 1) - sprBtnUtility.getWidth() - shiftX && y >= MainCanvas.HEIGHT - sprBtnUtility.getHeight() - (sprBtnUtility.getHeight() >> 1) - shiftY && y <= MainCanvas.HEIGHT - (sprBtnUtility.getHeight() >> 1) - shiftY) {
            return true;
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (!(this.bMainIn || this.bMainOut || this.levelCompleted || Profile.tutorial)) {
            if (this.screen == 1 && this.subScreen == 2 && this.bDragInstructions) {
                this.iTextShiftY += MainCanvas.lastPointerPressedY - y;
                MainCanvas.lastPointerPressedY = y;
            }
            if (this.screen == 1 && this.subScreen == 4 && this.bDragLevelSelect) {
                this.iTextShiftY += MainCanvas.lastPointerPressedY - y;
                MainCanvas.lastPointerPressedY = y;
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (!this.levelCompleted) {
            if (x >= this.iSelectedLevelX - MainCanvas.WIDTH / 30 && x <= this.iSelectedLevelX + MainCanvas.WIDTH / 30 && y >= this.iSelectedLevelY - MainCanvas.WIDTH / 30 && y <= this.iSelectedLevelY + MainCanvas.WIDTH / 30 && this.bDragLevelSelect) {
                this.bDragLevelSelect = false;
            }
            if (!(this.bMainIn || this.bMainOut || this.bDragInstructions || this.bDragLevelSelect)) {
                block0 : switch (this.screen) {
                    case 0: {
                        switch (this.subScreen) {
                            case 2: {
                                if (this.delay <= 100) break;
                                this.delay = 100;
                                break;
                            }
                            case 3: {
                                for (int i = 0; i < 6; ++i) {
                                    if (!this.rectLanguages[i].contains(x, y)) continue;
                                    iUsedLanguage = this.iSelectedLanguage = i;
                                    this.nextScreen(0, 4);
                                    return;
                                }
                                break block0;
                            }
                            case 4: {
                                if (this.isLeftButtonPressed(x, y)) {
                                    this.soundOn();
                                    this.init();
                                    return;
                                }
                                if (!this.isRightButtonPressed(x, y)) break;
                                this.soundOff();
                                this.init();
                                return;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (this.subScreen) {
                            case 0: {
                                int i;
                                for (i = 0; i < 6; ++i) {
                                    if (!this.rectLanguages[i].contains(x, y)) continue;
                                    iUsedLanguage = this.iSelectedLanguage = i;
                                    this.initTexts();
                                    return;
                                }
                                if (this.rectSoundButton.contains(x, y)) {
                                    this.changeSound();
                                    return;
                                }
                                for (i = 0; i < this.iButtonsTotal; ++i) {
                                    if (!this.rectMenuButtons[i].contains(x, y)) continue;
                                    this.bRight = true;
                                    this.iSelectedButton = i;
                                    break;
                                }
                                if (this.iSelectedButton == 0) break block0;
                                this.initNextScreen();
                                break block0;
                            }
                            case 2: {
                                for (int i = 0; i < this.iButtonsTotal; ++i) {
                                    if (!this.rectMenuButtons[i].contains(x, y)) continue;
                                    this.bRight = i > this.iSelectedButton;
                                    this.iSelectedButton = i;
                                    break;
                                }
                                if (this.iSelectedButton == 1) break block0;
                                this.initNextScreen();
                                break block0;
                            }
                            case 1: {
                                if (this.isMiddleButtonPressed(x, y)) {
                                    if (Profile.dailyAvailable) {
                                        this.dailyStarted = true;
                                        this.dailyPlayed = true;
                                        Game.startTime = System.currentTimeMillis();
                                        Game.stage = 0;
                                        Game.timerPause = 0L;
                                        this.dailyNums = new String[5];
                                        this.game.dailyAfterRestart = 0;
                                        this.nextScreen(2, 0);
                                    }
                                    return;
                                }
                                for (int i = 0; i < this.iButtonsTotal; ++i) {
                                    if (!this.rectMenuButtons[i].contains(x, y)) continue;
                                    this.bRight = i > this.iSelectedButton;
                                    this.iSelectedButton = i;
                                    break;
                                }
                                if (this.iSelectedButton == 3) break block0;
                                this.initNextScreen();
                                break block0;
                            }
                            case 3: {
                                if (this.isLeftButtonPressed(x, y)) {
                                    this.quit();
                                    return;
                                }
                                if (this.isRightButtonPressed(x, y)) {
                                    this.setTexts();
                                    this.bRight = false;
                                    --this.iSelectedButton;
                                    this.initNextScreen();
                                    return;
                                }
                                for (int i = 0; i < this.iButtonsTotal; ++i) {
                                    if (!this.rectMenuButtons[i].contains(x, y)) continue;
                                    this.bRight = false;
                                    this.iSelectedButton = i;
                                    break;
                                }
                                if (this.iSelectedButton == 4) break block0;
                                this.initNextScreen();
                                break block0;
                            }
                            case 4: {
                                int i;
                                if (this.firstLevel) {
                                    if (this.tutorialStep == 0) {
                                        if (this.rectYes.contains(x, y)) {
                                            Profile.tutorial = true;
                                            Profile.save();
                                            Game.startTime = System.currentTimeMillis();
                                            Game.stage = 0;
                                            Game.timerPause = 0L;
                                            this.iSelectedLevel = 1;
                                            this.tutorialStep = 2;
                                            this.firstLevel = false;
                                            this.game.tutorialMsg = true;
                                            this.game.bTutorialTable = true;
                                            this.nextScreen(2, 0);
                                            return;
                                        }
                                        if (this.rectNo.contains(x, y)) {
                                            Profile.tutorial = false;
                                            Game.startTime = System.currentTimeMillis();
                                            Game.stage = 0;
                                            Game.timerPause = 0L;
                                            this.iSelectedLevel = 1;
                                            this.tutorialStep = -1;
                                            this.firstLevel = false;
                                            this.nextScreen(2, 0);
                                            return;
                                        }
                                    }
                                    return;
                                }
                                for (i = 1; i < Level.LAST_LEVEL + 1; ++i) {
                                    if (!this.rectLevelSelect[i].contains(x, y) || x < this.iSelectedLevelX - MainCanvas.WIDTH / 30 || x > this.iSelectedLevelX + MainCanvas.WIDTH / 30 || y + this.iShiftY < this.iSelectedLevelY + this.iShiftY - MainCanvas.WIDTH / 30 || y + this.iShiftY > this.iSelectedLevelY + this.iShiftY + MainCanvas.WIDTH / 30) continue;
                                    if (i == 1) {
                                        this.firstLevel = true;
                                        this.tutorialStep = 0;
                                        return;
                                    }
                                    if (Profile.openLevels[i - 1] != 1) continue;
                                    Game.startTime = System.currentTimeMillis();
                                    Game.stage = 0;
                                    Game.timerPause = 0L;
                                    this.iSelectedLevel = i;
                                    this.nextScreen(2, 0);
                                    return;
                                }
                                for (i = 0; i < this.iButtonsTotal; ++i) {
                                    if (!this.rectMenuButtons[i].contains(x, y)) continue;
                                    this.bRight = i > this.iSelectedButton;
                                    this.iSelectedButton = i;
                                    break;
                                }
                                if (this.iSelectedButton == 2) break block0;
                                this.initNextScreen();
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (this.subScreen != 0) break;
                        if (this.game.stepTimer > 0) {
                            return;
                        }
                        if (this.isRightButtonPressed(x, y) && this.game.isWin()) {
                            if (Game.stage != 5) {
                                if (Profile.tutorial) {
                                    if (this.game.tutorialMsg) {
                                        this.game.tutorialMsg = false;
                                        return;
                                    }
                                    if (this.tutorialStep == 5) {
                                        ++this.tutorialStep;
                                    }
                                    if (this.tutorialStep == 11) {
                                        this.iShiftX = 0;
                                        this.tutorialStep = -1;
                                        this.firstLevel = false;
                                        Profile.tutorial = false;
                                        Profile.save();
                                    }
                                }
                                this.nextScreen(2, 0);
                                break;
                            }
                            if (this.dailyStarted) {
                                this.dailyStarted = false;
                                this.iSelectedButton = 3;
                                this.game.dailyAfterRestart = 0;
                                this.nextScreen(1, 1);
                            } else {
                                this.iSelectedButton = 2;
                                this.nextScreen(1, 4);
                                if (Profile.completedLevels[this.iSelectedLevel - 1] == 0) {
                                    this.levelCompleted = true;
                                }
                            }
                            return;
                        }
                        if (this.isLeftButtonPressed(x, y) && !this.game.bPause && !this.game.timeUp) {
                            this.game.pause();
                            return;
                        }
                        this.game.pointerReleased(x, y);
                    }
                }
            }
            if (this.screen == 1 && this.subScreen == 2 && this.bDragInstructions) {
                this.bDragInstructions = false;
            }
            if (this.screen == 1 && this.subScreen == 4 && this.bDragLevelSelect) {
                this.bDragLevelSelect = false;
            }
        }
    }

    public void afterHide() {
    }

    public void beforeShow() {
        Profile.load();
        this.screen = 0;
        this.subScreen = 0;
    }

    public void beforeInteruption() {
        if (this.screen != 0) {
            MainCanvas.soundManager.Stop();
            if (this.screen == 2 && this.subScreen == 0) {
                this.game.bPause = true;
                Game.timerPauseStart = System.currentTimeMillis();
                this.iFlash = 0;
            }
        }
    }

    public void afterInteruption() {
        if (this.screen == 2 && this.subScreen == 0) {
            this.game.bPause = true;
            this.iFlash = 0;
        }
        if (this.screen != 0) {
            this.playMusic(Sounds.MUSIC_MENU, -1);
        }
    }

    public void initGraphics() {
        this.bLoading = true;
        Resources.loadGFonts(new int[]{1, 5, 0, 3, 4});
        this.fontTableSmall = Resources.resGFonts[0];
        this.fontTable = Resources.resGFonts[1];
        this.fontCorrect = Resources.resGFonts[3];
        this.fontWrong = Resources.resGFonts[4];
        this.fontPurple = Resources.resGFonts[5];
        Resources.loadImages(new int[]{10, 9, 2, 7, 6, 5, 4, 3, 1, 0});
        imgBackground = Resources.resImgs[0];
        imgHint = Resources.resImgs[1];
        imgHint2 = Resources.resImgs[2];
        imgLogoMenu = Resources.resImgs[3];
        imgLogoIntro = Resources.resImgs[4];
        imgQuestionBarBg = Resources.resImgs[5];
        imgScore = Resources.resImgs[6];
        imgLogoLevels = Resources.resImgs[7];
        imgDaily = Resources.resImgs[9];
        imgAbout = Resources.resImgs[10];
        Resources.loadSprites(new int[]{22, 21, 20, 19, 18, 17, 3, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 2, 1, 0});
        sprLang = Resources.resSprs[0];
        sprTable = Resources.resSprs[1];
        sprTableS = Resources.resSprs[15];
        sprBtnLevel = Resources.resSprs[2];
        sprBtnMenu = Resources.resSprs[4];
        sprBtnUtility = Resources.resSprs[5];
        sprBtnGame = Resources.resSprs[6];
        sprBtnLetters = Resources.resSprs[7];
        sprBtnLetter = Resources.resSprs[3];
        sprQuestionBar = Resources.resSprs[8];
        sprResultIcons = Resources.resSprs[9];
        sprSelectorSmall = Resources.resSprs[10];
        sprSelectorBig = Resources.resSprs[11];
        sprScrolling = Resources.resSprs[12];
        sprTimerBg = Resources.resSprs[13];
        sprDaily = Resources.resSprs[14];
        sprPause = Resources.resSprs[16];
        sprGreen = Resources.resSprs[17];
        sprYellowPurple = Resources.resSprs[18];
        sprGreenPurple = Resources.resSprs[19];
        sprGreenGreen = Resources.resSprs[20];
        sprQuestionBarSolo = Resources.resSprs[21];
        sprParticles = Resources.resSprs[22];
        this.nextScreen(0, 1);
        this.bLoading = false;
    }

    public void initIntro() {
        this.bLoading = true;
        this.iShiftDirection = 1;
        this.iShiftX = 0;
        this.iShiftStep = MainCanvas.WIDTH / 120;
        if (MainCanvas.WIDTH > MainCanvas.HEIGHT) {
            this.iShiftStep = MainCanvas.HEIGHT / 160;
        }
        int offX = (MainCanvas.WIDTH - 3 * sprLang.getWidth()) / 4;
        this.iSelectedLanguage = 0;
        this.rectLanguages[0] = new Rectangle((MainCanvas.WIDTH >> 1) - sprLang.getWidth() - (sprLang.getWidth() >> 1) - offX, (MainCanvas.HEIGHT >> 1) - sprLang.getHeight() - (sprLang.getHeight() >> 2), sprLang.getWidth(), sprLang.getHeight());
        this.rectLanguages[1] = new Rectangle((MainCanvas.WIDTH >> 1) - (sprLang.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - sprLang.getHeight() - (sprLang.getHeight() >> 2), sprLang.getWidth(), sprLang.getHeight());
        this.rectLanguages[2] = new Rectangle((MainCanvas.WIDTH >> 1) + (sprLang.getWidth() >> 1) + offX, (MainCanvas.HEIGHT >> 1) - sprLang.getHeight() - (sprLang.getHeight() >> 2), sprLang.getWidth(), sprLang.getHeight());
        this.rectLanguages[3] = new Rectangle((MainCanvas.WIDTH >> 1) - sprLang.getWidth() - (sprLang.getWidth() >> 1) - offX, (MainCanvas.HEIGHT >> 1) + (sprLang.getHeight() >> 2), sprLang.getWidth(), sprLang.getHeight());
        this.rectLanguages[4] = new Rectangle((MainCanvas.WIDTH >> 1) - (sprLang.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) + (sprLang.getHeight() >> 2), sprLang.getWidth(), sprLang.getHeight());
        this.rectLanguages[5] = new Rectangle((MainCanvas.WIDTH >> 1) + (sprLang.getWidth() >> 1) + offX, (MainCanvas.HEIGHT >> 1) + (sprLang.getHeight() >> 2), sprLang.getWidth(), sprLang.getHeight());
        int pomMenuButtonHeight = (this.fontTableSmall.getHeight() << 2) + (this.fontTableSmall.getHeight() >> 1);
        int pomMenuButtonWidth = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
        this.rectTitleCenter = MainCanvas.HEIGHT < 241 ? new Rectangle((MainCanvas.WIDTH >> 1) - (pomMenuButtonWidth >> 1), MainCanvas.HEIGHT >> 4, pomMenuButtonWidth, pomMenuButtonHeight >> 2) : new Rectangle((MainCanvas.WIDTH >> 1) - (pomMenuButtonWidth >> 1), (MainCanvas.HEIGHT >> 1) - (pomMenuButtonHeight >> 1), pomMenuButtonWidth, pomMenuButtonHeight);
        this.nextScreen(0, 2);
        this.bLoading = false;
    }

    public void init() {
        int i;
        this.bLoading = true;
        this.game = new Game(this);
        this.nextScreen(1, 4);
        Profile.tutorial = false;
        Profile.save();
        System.gc();
        if (!Profile.dailyAvailable) {
            Calendar now = Calendar.getInstance();
            now.setTime(new Date(System.currentTimeMillis()));
            long dailyReset = Profile.dailyReset - now.getTime().getTime();
            int seconds = (int)(dailyReset / 1000L) % 60;
            int minutes = (int)(dailyReset / 60000L % 60L);
            int hours = (int)(dailyReset / 3600000L % 24L);
            this.time = Resources.resTexts[0].getHashedString(56) + " " + hours + ":" + minutes + ":" + seconds;
            if (Profile.dailyReset < System.currentTimeMillis()) {
                Profile.dailyAvailable = true;
                Profile.save();
            }
        } else {
            this.time = Resources.resTexts[0].getHashedString(58);
        }
        this.rectButtonCenter = new Rectangle((MainCanvas.WIDTH >> 1) - (sprDaily.getWidth() >> 1), (MainCanvas.HEIGHT >> 1) - (sprDaily.getHeight() >> 1), sprDaily.getWidth(), sprDaily.getHeight());
        this.iHeaderHeight = this.fontTableSmall.getHeight() << 1;
        this.rectMenuItems = new Rectangle[this.iMenuItemsTotal];
        this.rectMenuButtons = new Rectangle[this.iButtonsTotal];
        this.rectLevelSelect = new Rectangle[Level.LAST_LEVEL + 1];
        int offX = MainCanvas.WIDTH - sprBtnMenu.getWidth() * this.iButtonsTotal >> 1;
        for (i = 0; i < this.iButtonsTotal; ++i) {
            this.rectMenuButtons[i] = new Rectangle(offX + i * sprBtnMenu.getWidth(), MainCanvas.HEIGHT - sprBtnMenu.getHeight() - (sprBtnMenu.getHeight() >> 2), sprBtnMenu.getWidth(), sprBtnMenu.getHeight());
        }
        for (i = 0; i < 6; ++i) {
            this.rectLanguages[i].y -= sprLang.getHeight() >> 1;
        }
        this.rectSoundButton = new Rectangle(MainCanvas.WIDTH - sprBtnUtility.getWidth() >> 1, (MainCanvas.HEIGHT >> 1) + sprLang.getHeight(), sprBtnUtility.getWidth(), sprBtnUtility.getHeight());
        this.scoreToUnlock = new int[Level.LAST_LEVEL];
        int scoreCounter = 1;
        for (int i2 = 1; i2 < Level.LAST_LEVEL + 1; ++i2) {
            this.scoreToUnlock[i2 - 1] = scoreCounter++;
            if (i2 % 3 != 0) continue;
        }
        this.setTitleCenter(Resources.resTexts[0].getHashedString(74), this.fontTableSmall, MainCanvas.WIDTH - (sprTableS.getWidth() << 2));
        this.tableConfirmHeight = (this.iTextLines + 1) * this.fontTableSmall.getHeight() + (this.fontTableSmall.getHeight() >> 1) + sprBtnUtility.getHeight() + (this.fontTable.getHeight() << 1);
        this.rectYes = new Rectangle(sprTableS.getWidth() << 1, (MainCanvas.HEIGHT + this.tableConfirmHeight - sprTableS.getHeight() >> 1) - sprBtnUtility.getHeight(), sprBtnUtility.getWidth(), sprBtnUtility.getHeight());
        this.rectNo = new Rectangle(MainCanvas.WIDTH - (sprTableS.getWidth() << 1) - sprBtnUtility.getWidth(), (MainCanvas.HEIGHT + this.tableConfirmHeight - sprTableS.getHeight() >> 1) - sprBtnUtility.getHeight(), sprBtnUtility.getWidth(), sprBtnUtility.getHeight());
        this.iInstructionsHeight = MainCanvas.HEIGHT - sprTable.getHeight() - (this.fontTable.getHeight() << 1) - sprBtnMenu.getHeight() - (sprBtnMenu.getHeight() >> 2);
        this.iInstructionsCenterY = (this.iInstructionsHeight >> 1) + sprTable.getHeight() + (this.fontTable.getHeight() << 1);
        this.iInstructionsWidth = MainCanvas.WIDTH - (sprTable.getWidth() << 1);
        this.iAboutHeight = this.iInstructionsHeight;
        this.iAboutCenterY = (this.iAboutHeight >> 1) + this.iHeaderHeight + this.fontTableSmall.getHeight();
        this.iAboutWidth = this.rectTitleCenter.width;
        if (Profile.bMusic) {
            this.soundOn();
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.MUSIC_MENU, -1);
        } else {
            this.soundOff();
        }
        this.initMainX();
        this.bLoading = false;
    }

    public void initTexts() {
        this.textsInited = true;
        Resources.initLangDirs(langCodes[this.iSelectedLanguage]);
        Resources.loadText(0);
        this.iSelectedMenuItem = 0;
        this.iMenuItemsTotal = 4;
        this.iButtonsTotal = 5;
    }

    public void setTexts() {
        block0 : switch (this.screen) {
            case 0: {
                this.iTextLines = 1;
                switch (this.subScreen) {
                    case 4: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(2);
                        this.setTitleCenter(this.strTextBody, this.fontTableSmall, this.rectTitleCenter.width);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.iTextLines = 1;
                switch (this.subScreen) {
                    case 0: {
                        this.strTextMenu[0] = Resources.resTexts[0].getHashedString(36);
                        this.strTextMenu[1] = Resources.resTexts[0].getHashedString(10);
                        this.strTextMenu[2] = Resources.resTexts[0].getHashedString(9);
                        this.strTextMenu[2] = Profile.bMusic ? this.strTextMenu[2] + " " + Resources.resTexts[0].getHashedString(15) : this.strTextMenu[2] + " " + Resources.resTexts[0].getHashedString(16);
                        if (!this.game.bPause) {
                            this.strTextMenu[3] = Resources.resTexts[0].getHashedString(50);
                            break block0;
                        }
                        this.strTextMenu[3] = Resources.resTexts[0].getHashedString(13);
                        break block0;
                    }
                    case 1: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(65);
                        this.setTitleCenter(this.strTextBody, this.fontTable, MainCanvas.WIDTH - (sprTable.getWidth() << 1));
                        break block0;
                    }
                    case 2: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(36);
                        this.bLoading = true;
                        this.setTitleCenter(this.strTextBody, this.fontTableSmall, MainCanvas.WIDTH - (sprTable.getWidth() << 1));
                        this.strTextPom[0] = Resources.resTexts[0].getHashedString(8) + "\n\n" + Resources.resTexts[0].getHashedString(27);
                        int textMaxWidth = this.iInstructionsWidth - (this.iInstructionsWidth >> 3);
                        this.prepText = new PreparedText(this.fontTableSmall);
                        this.prepText.prepareText(this.strTextPom[0], textMaxWidth);
                        this.iTextLines = this.prepText.getTextHeight() / this.fontTableSmall.getHeight();
                        int iTextYUp = this.iInstructionsCenterY - (this.iInstructionsHeight >> 1);
                        int iTextYDown = this.iInstructionsCenterY + (this.iInstructionsHeight >> 1);
                        int iTextHeight = iTextYDown - iTextYUp;
                        this.iTextShiftY = 0;
                        this.iShiftY = 0;
                        this.iMaxShiftY = this.prepText.getTextHeight() - iTextHeight + (this.fontTableSmall.getHeight() << 1) + imgAbout.getHeight() + (this.fontTableSmall.getHeight() << 1);
                        this.bDragInstructions = false;
                        this.bLoading = false;
                        break block0;
                    }
                    case 3: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(12);
                        this.setTitleCenter(this.strTextBody, this.fontTableSmall, MainCanvas.WIDTH - (sprTable.getWidth() << 1));
                        break block0;
                    }
                    case 4: {
                        this.strTextBody = Resources.resTexts[0].getHashedString(52);
                        this.bDragLevelSelect = false;
                        this.iShiftY = 0;
                        this.rowShift = 0;
                        if (Profile.iLevel > 5) {
                            for (int tmp = 5; tmp < Profile.iLevel; tmp += 3) {
                                ++this.rowShift;
                            }
                        }
                        this.bLoading = false;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.iTextLines = 1;
                switch (this.subScreen) {
                    case 0: {
                        this.strTextPom[0] = Resources.resTexts[0].getHashedString(52) + " " + this.iSelectedLevel;
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void nextScreen(int nextScreen, int nextSubScreen) {
        this.screen = nextScreen;
        this.subScreen = nextSubScreen;
        block0 : switch (this.screen) {
            case 0: {
                switch (this.subScreen) {
                    case 4: {
                        this.initTexts();
                        this.iSelectedLanguage = -1;
                        break block0;
                    }
                    case 2: {
                        this.delay = 3000;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (this.subScreen) {
                    case 0: {
                        this.iSelectedMenuItem = 0;
                        this.instructionControl = 0;
                        break block0;
                    }
                    case 4: {
                        this.bDragLevelSelect = false;
                        this.iShiftY = 0;
                        this.rowShift = 0;
                        if (Profile.iLevel > 5) {
                            for (int tmp = 5; tmp < Profile.iLevel; tmp += 3) {
                                ++this.rowShift;
                            }
                        }
                        this.iShiftX = 0;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.iFlash = 0;
                this.iShiftX = 0;
                if (this.subScreen != 0 || this.game.bPause) break;
                if (this.dailyStarted) {
                    int rand = RandomNum.getRandomUInt(Level.LAST_LEVEL) + 1;
                    boolean number = false;
                    block14: while (!number) {
                        for (int i = 0; i < this.dailyNums.length; ++i) {
                            if (String.valueOf(rand).equals(this.dailyNums[i])) {
                                rand = RandomNum.getRandomUInt(Level.LAST_LEVEL) + 1;
                                continue block14;
                            }
                            if (this.dailyNums[i] != null) continue;
                            this.dailyNums[i] = String.valueOf(rand);
                            number = true;
                            continue block14;
                        }
                    }
                    this.game.init(rand);
                    break;
                }
                this.game.init(this.iSelectedLevel);
                break;
            }
        }
        this.setTexts();
    }

    public void playMusic(int type, int times) {
        MainCanvas.soundManager.Stop();
        MainCanvas.soundManager.Play(type, times);
    }

    public void paintTable(Graphics g, Sprite spr, int centerX, int centerY, int width, int height) {
        int i;
        if (height < spr.getHeight() << 1) {
            height = spr.getHeight() << 1;
        }
        int left = centerX - (width >> 1);
        int top = centerY - (height >> 1);
        int countX = (width - (spr.getWidth() << 1)) / spr.getWidth() + 1;
        int countY = (height - (spr.getHeight() << 1)) / spr.getHeight() + 1;
        int iHeight2 = height - (spr.getHeight() << 1);
        int iWidth2 = width - (spr.getWidth() << 1);
        int iX = left;
        int iY = top;
        spr.setFrame(0);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX, iY + spr.getHeight(), MainCanvas.WIDTH, iHeight2);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(3);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        iY = top + height - spr.getHeight();
        spr.setFrame(6);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX + spr.getWidth(), top, iWidth2, MainCanvas.HEIGHT);
        for (i = 0; i < countX; ++i) {
            iY = top;
            spr.setFrame(1);
            spr.setPosition(iX += spr.getWidth(), iY);
            spr.paint(g);
            for (int j = 0; j < countY; ++j) {
                spr.setFrame(4);
                spr.setPosition(iX, iY += spr.getHeight());
                spr.paint(g);
            }
            iY = top + height - spr.getHeight();
            spr.setFrame(7);
            spr.setPosition(iX, iY);
            spr.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        iX = left + width - spr.getWidth();
        iY = top;
        spr.setFrame(2);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX, iY + spr.getHeight(), MainCanvas.WIDTH, iHeight2);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(5);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        iY = top + height - spr.getHeight();
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        spr.setFrame(8);
        spr.setPosition(iX, iY);
        spr.paint(g);
    }
}

