/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.saves;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.saves.ShopItemData;

public class Shop
implements RMSHandler {
    private Vector shop = new Vector();

    public ShopItemData getShopItemData() {
        if (this.shop.size() > 0) {
            return (ShopItemData)this.shop.firstElement();
        }
        return null;
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
        this.shop.removeAllElements();
        if (dis.readInt() != 0) {
            int index;
            ShopItemData shopItem = new ShopItemData();
            shopItem.size = dis.readShort();
            shopItem.count = new short[shopItem.size];
            shopItem.id = new short[shopItem.size];
            for (index = 0; index < shopItem.size; ++index) {
                shopItem.id[index] = dis.readShort();
            }
            for (index = 0; index < shopItem.size; ++index) {
                shopItem.count[index] = dis.readShort();
            }
            this.shop.addElement(shopItem);
        }
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
        int index;
        ShopItemData shopData = (ShopItemData)this.shop.firstElement();
        dos.writeInt(1);
        dos.writeShort(shopData.size);
        for (index = 0; index < shopData.size; ++index) {
            dos.writeShort(shopData.id[index]);
        }
        for (index = 0; index < shopData.size; ++index) {
            dos.writeShort(shopData.count[index]);
        }
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(0);
    }

    public void saveGame(ShopItemData shopIt) {
        if (this.shop.size() > 0) {
            this.shop.setElementAt(shopIt, 0);
        } else {
            this.shop.addElement(shopIt);
        }
    }
}

