/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.saves;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.saves.SavedGameData;

public class Data
implements RMSHandler {
    private Vector data = new Vector();

    public SavedGameData getSavedGameData() {
        System.out.println("data size : " + this.data.size());
        if (this.data.size() > 0) {
            return (SavedGameData)this.data.firstElement();
        }
        return null;
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
        SavedGameData gameData = (SavedGameData)this.data.firstElement();
        dos.writeInt(1);
        dos.writeShort(gameData.coins);
        dos.writeShort(gameData.level);
        dos.writeShort(gameData.food);
        dos.writeShort(gameData.health);
        dos.writeShort(gameData.fun);
        dos.writeShort(gameData.energy);
        dos.writeShort(gameData.experience);
        dos.writeBoolean(gameData.hasExcrement);
        dos.writeBoolean(gameData.sleepMode);
        dos.writeLong(gameData.endTime);
        dos.writeBoolean(gameData.firstRun);
        dos.writeBoolean(gameData.isDirty);
        dos.writeBoolean(gameData.wearOutfit);
        dos.writeBoolean(gameData.wearHat);
        dos.writeBoolean(gameData.wearMostache);
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
        this.data.removeAllElements();
        if (dis.readInt() != 0) {
            SavedGameData gameData = new SavedGameData();
            gameData.coins = dis.readShort();
            gameData.level = dis.readShort();
            gameData.food = dis.readShort();
            gameData.health = dis.readShort();
            gameData.fun = dis.readShort();
            gameData.energy = dis.readShort();
            gameData.experience = dis.readShort();
            gameData.hasExcrement = dis.readBoolean();
            gameData.sleepMode = dis.readBoolean();
            gameData.endTime = dis.readLong();
            gameData.firstRun = dis.readBoolean();
            gameData.isDirty = dis.readBoolean();
            gameData.wearOutfit = dis.readBoolean();
            gameData.wearHat = dis.readBoolean();
            gameData.wearMostache = dis.readBoolean();
            this.data.addElement(gameData);
        }
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(0);
    }

    public void saveGame(SavedGameData savIt) {
        if (this.data.size() > 0) {
            this.data.setElementAt(savIt, 0);
        } else {
            this.data.addElement(savIt);
        }
    }
}

