/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Levels;
import sk.inlogic.MainCanvas;
import sk.inlogic.Obstacle;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.graphics.GFont;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private MainCanvas mainCanvas;
    private int status;
    private int interuption = 0;
    private static final int STATUS_GAME = 0;
    private static final int STATUS_INGAMEMENU = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    private static final int STATUS_INSTRUCTIONS = 3;
    private static final int STATUS_TUTORIAL = 4;
    private static final int STATUS_RESTARTSCREEN = 5;
    private static final int STATUS_REALLY_QUIT = 6;
    private static final int STATUS_MAIN_MENU = 7;
    private static final int COMP_ID_HINT = 0;
    private static final int COMP_ID_MENU = 1;
    private static final int COMP_ID_RESUME = 2;
    private static final int COMP_ID_RESTART = 3;
    private static final int COMP_ID_SOUNDS = 4;
    private static final int COMP_ID_MAINMENU = 5;
    private static final int COMP_ID_INSTRUCTION = 6;
    private static final int COMP_ID_G0_RESTART = 7;
    private static final int COMP_ID_G0_HOME = 8;
    private static final int COMP_ID_RESTART_BIG = 9;
    private static final int TOTAL_COMP_IDS = 10;
    private int[][] _animationSequence = new int[8][11];
    private AnimationComponent[] _animationComponents = new AnimationComponent[19];
    private Rectangle[] rectItems = new Rectangle[10];
    private Rectangle rectGameArea;
    private Rectangle rectPanel;
    private Rectangle rectText;
    private Rectangle rectScore;
    private Rectangle rectBestScore;
    private Rectangle rectPlay;
    private Rectangle rectLeftFk;
    private Rectangle rectRightFk;
    private Rectangle _rectDialog;
    private Rectangle _rectGameOver;
    private Rectangle _rectTopBig;
    private Rectangle _rectStars;
    private int[] _arrImages;
    private int[] _arrSprites;
    private int[] _arrFonts;
    private int selectedCompId;
    private static PreparedText _ptMenuItem;
    private static PreparedText _ptInstruction;
    private static PreparedText _ptActualScore;
    private static PreparedText _ptActualScoreGameOver;
    private static PreparedText best;
    private static PreparedText bestScore;
    private static PreparedText navigationKeysBB;
    private static PreparedText _ptSelectedModeText;
    private static PreparedText _ptPause;
    private static PreparedText _ptScore;
    private int textOffsetY;
    private boolean needRepaint;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private Image _imgInlogicLogo;
    private Image _imgMenuLogo;
    private Image _imgBottomPanel;
    private Image _imgBtnMenuSelector;
    private Image _imgBtnMenuMainSelector;
    private Image _imgBtnFinishSelector;
    private Image _imgBtnLevelSelector;
    private Image _imgColorLine;
    private Image _imgGameModeSelector;
    private Image _imgInlogicLogoAbout;
    private Image _imgStarBlue;
    private Image _imgStarFinish;
    private Image _imgStarGame;
    private Image _imgStarLock;
    private Image _imgStarOrange;
    private Sprite _sprArrowsActive;
    private Sprite _sprArrowsInactive;
    private Sprite _sprBtnModesCompleted;
    private Sprite _sprBtnModesFailed;
    private Sprite _sprBtnModesSelector;
    private Sprite _sprBtnMenu;
    private Sprite _sprBtnMenuMain;
    private Sprite _sprBtnFinish;
    private Sprite _sprBtnLevel;
    private Sprite _sprBtnShop;
    private Sprite _sprGameMode;
    private Sprite _sprTable;
    private Sprite _sprTopPanel;
    private Sprite _sprPlayer1;
    private Sprite _sprPlayer2;
    private Sprite _sprPlayer3;
    private Sprite _sprPlayer4;
    private Sprite _sprPlayer5;
    private Sprite _sprNumbers;
    private Sprite _sprNumbersSmall;
    private Sprite _sprNumbersBlack;
    private Sprite _sprNumbersGrey;
    private Sprite _sprBtnPlay;
    private Sprite _sprBtnPlaySelector;
    private static int _WIDTH;
    private static int _HEIGHT;
    int _iMode = 0;
    private static final int NORMAL = 0;
    private int _iSelectedCharacter;
    private Levels _lActualLevel;
    int _iActLevel;
    private int _selectedMode;
    int _finalHeight;
    int _off;
    int cycle = 10;
    private int _sequenceStop = 0;
    private int _sequenceShow = 1;
    private int _sequenceHide = 2;
    private int _sequence = 0;
    boolean changeSequence = false;
    private int nextScreen;
    boolean _bBkickUpdate = true;
    int lvl = 0;
    int checkButton = 2;
    int checkButton2 = 2;
    int posX = 0;
    int posY = 0;

    public ScreenGame(MainCanvas mainCanvas, int _iSelectedLevel, int _iSelectedCharacter) {
        Obstacle.setArcadeModeFlag(false);
        this.mainCanvas = mainCanvas;
        this._iSelectedCharacter = _iSelectedCharacter;
        this._iMode = 0;
        this.initDimensions();
        this.status = 0;
        this._lActualLevel = new Levels();
        this._lActualLevel.LoadLevel(_iSelectedLevel);
        this._iActLevel = _iSelectedLevel;
    }

    public void beforeShow() {
        this.prepareResources();
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
        RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true, this._iSelectedCharacter);
        this._bBkickUpdate = false;
        this._selectedMode = ScreenMenu.getSelectedMode();
    }

    public void afterHide() {
        this.freeGraphics();
        this.freeResources();
    }

    private void prepareResources() {
        this._arrImages = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        this._arrSprites = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24};
        this._arrFonts = new int[]{0, 1, 2, 3};
        Vector a = new Vector();
    }

    private void loadResources() {
        Resources.loadImages(this._arrImages);
        Resources.loadSprites(this._arrSprites);
        Resources.loadGFonts(this._arrFonts);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(this._arrImages);
        Resources.freeSprites(this._arrSprites);
        Resources.freeGFonts(this._arrFonts);
    }

    private void initDimensions() {
        _WIDTH = MainCanvas.WIDTH;
        _HEIGHT = MainCanvas.HEIGHT;
    }

    private void initImages() {
        this._imgInlogicLogo = Resources.resImgs[0];
        this._imgMenuLogo = Resources.resImgs[2];
        this._imgBottomPanel = Resources.resImgs[3];
        this._imgBtnMenuSelector = Resources.resImgs[4];
        this._imgBtnMenuMainSelector = Resources.resImgs[5];
        this._imgBtnFinishSelector = Resources.resImgs[6];
        this._imgBtnLevelSelector = Resources.resImgs[7];
        this._imgColorLine = Resources.resImgs[8];
        this._imgGameModeSelector = Resources.resImgs[10];
        this._imgInlogicLogoAbout = Resources.resImgs[11];
        this._imgStarBlue = Resources.resImgs[12];
        this._imgStarFinish = Resources.resImgs[13];
        this._imgStarGame = Resources.resImgs[14];
        this._imgStarLock = Resources.resImgs[15];
        this._imgStarOrange = Resources.resImgs[16];
    }

    private void initSprites() {
        this._sprArrowsActive = Resources.resSprs[0];
        this._sprArrowsInactive = Resources.resSprs[1];
        this._sprBtnModesCompleted = Resources.resSprs[2];
        this._sprBtnModesFailed = Resources.resSprs[3];
        this._sprBtnModesSelector = Resources.resSprs[4];
        this._sprBtnMenu = Resources.resSprs[5];
        this._sprBtnMenuMain = Resources.resSprs[6];
        this._sprBtnFinish = Resources.resSprs[7];
        this._sprBtnLevel = Resources.resSprs[8];
        this._sprBtnShop = Resources.resSprs[9];
        this._sprGameMode = Resources.resSprs[11];
        this._sprTable = Resources.resSprs[12];
        this._sprTopPanel = Resources.resSprs[13];
        this._sprPlayer1 = Resources.resSprs[14];
        this._sprPlayer2 = Resources.resSprs[15];
        this._sprPlayer3 = Resources.resSprs[16];
        this._sprPlayer4 = Resources.resSprs[17];
        this._sprPlayer5 = Resources.resSprs[18];
        this._sprNumbers = Resources.resSprs[19];
        this._sprNumbersSmall = Resources.resSprs[20];
        this._sprNumbersBlack = Resources.resSprs[21];
        this._sprNumbersGrey = Resources.resSprs[22];
        this._sprBtnPlay = Resources.resSprs[23];
        this._sprBtnPlaySelector = Resources.resSprs[24];
    }

    public void initTxt() {
        Resources.loadText(0);
        _ptMenuItem = new PreparedText(Resources.resGFonts[2]);
        _ptInstruction = new PreparedText(Resources.resGFonts[0]);
        _ptActualScore = new PreparedText(Resources.resGFonts[2]);
        _ptActualScoreGameOver = new PreparedText(Resources.resGFonts[2]);
        bestScore = new PreparedText(Resources.resGFonts[0]);
        best = new PreparedText(Resources.resGFonts[0]);
        navigationKeysBB = new PreparedText(Resources.resGFonts[0]);
        _ptSelectedModeText = new PreparedText(Resources.resGFonts[0]);
        _ptPause = new PreparedText(Resources.resGFonts[2]);
        _ptScore = new PreparedText(Resources.resGFonts[2]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 9;
        this._animationSequence[0][1] = 7;
        this._animationSequence[0][2] = 12;
        this._animationSequence[0][3] = -1;
        this._animationSequence[0][4] = -1;
        this._animationSequence[0][5] = -1;
        this._animationSequence[0][6] = -1;
        this._animationSequence[0][7] = -1;
        this._animationSequence[0][8] = -1;
        this._animationSequence[0][9] = -1;
        this._animationSequence[0][10] = -1;
        this._animationSequence[1][0] = 0;
        this._animationSequence[1][1] = 1;
        this._animationSequence[1][2] = 2;
        this._animationSequence[1][3] = 3;
        this._animationSequence[1][4] = 4;
        this._animationSequence[1][5] = 6;
        this._animationSequence[1][6] = 12;
        this._animationSequence[1][7] = 10;
        this._animationSequence[1][8] = 15;
        this._animationSequence[1][9] = -1;
        this._animationSequence[1][10] = -1;
        this._animationSequence[3][0] = 10;
        this._animationSequence[3][1] = 12;
        this._animationSequence[3][2] = 17;
        this._animationSequence[3][3] = 9;
        this._animationSequence[3][4] = 5;
        this._animationSequence[3][5] = 13;
        this._animationSequence[3][6] = -1;
        this._animationSequence[3][7] = -1;
        this._animationSequence[3][8] = -1;
        this._animationSequence[3][9] = -1;
        this._animationSequence[3][10] = -1;
        this._animationSequence[6][0] = 8;
        this._animationSequence[6][1] = 9;
        this._animationSequence[6][2] = 16;
        this._animationSequence[6][3] = 17;
        this._animationSequence[6][4] = 5;
        this._animationSequence[6][5] = 13;
        this._animationSequence[6][6] = 11;
        this._animationSequence[6][7] = 12;
        this._animationSequence[6][8] = -1;
        this._animationSequence[6][9] = -1;
        this._animationSequence[6][10] = -1;
        this._animationSequence[5][0] = 8;
        this._animationSequence[5][1] = 9;
        this._animationSequence[5][2] = 16;
        this._animationSequence[5][3] = 17;
        this._animationSequence[5][4] = 5;
        this._animationSequence[5][5] = 13;
        this._animationSequence[5][6] = 12;
        this._animationSequence[5][7] = 11;
        this._animationSequence[5][8] = -1;
        this._animationSequence[5][9] = -1;
        this._animationSequence[5][10] = -1;
        this._animationSequence[2][0] = 10;
        this._animationSequence[2][1] = 3;
        this._animationSequence[2][2] = 16;
        this._animationSequence[2][3] = 17;
        this._animationSequence[2][4] = 0;
        this._animationSequence[2][5] = 11;
        this._animationSequence[2][6] = 9;
        this._animationSequence[2][7] = 13;
        this._animationSequence[2][8] = 14;
        this._animationSequence[2][9] = -1;
        this._animationSequence[2][10] = -1;
        this._animationSequence[4][0] = 10;
        this._animationSequence[4][1] = 11;
        this._animationSequence[4][2] = 8;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
        this._animationSequence[4][6] = -1;
        this._animationSequence[4][7] = -1;
        this._animationSequence[4][8] = -1;
        this._animationSequence[4][9] = -1;
        this._animationSequence[4][10] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this.rectItems[3], _WIDTH, _HEIGHT);
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectItems[4], _WIDTH, _HEIGHT);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectItems[6], _WIDTH, _HEIGHT);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectItems[5], _WIDTH, _HEIGHT);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectPanel, _WIDTH, _HEIGHT);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this.rectText, _WIDTH, _HEIGHT);
        this._animationComponents[5].startShowAnimation(3);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, new Rectangle(0, 0, 0, 0), _WIDTH, _HEIGHT);
        this._animationComponents[6].startShowAnimation(2);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this.rectScore, _WIDTH, _HEIGHT);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this.rectBestScore, _WIDTH, _HEIGHT);
        this._animationComponents[8].startShowAnimation(0);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this.rectGameArea, _WIDTH, _HEIGHT);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this._rectTopBig, _WIDTH, _HEIGHT);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this.rectLeftFk, _WIDTH, _HEIGHT);
        this._animationComponents[11].startShowAnimation(0);
        this._animationComponents[12] = new AnimationComponent(this.mainCanvas, this.rectRightFk, _WIDTH, _HEIGHT);
        this._animationComponents[12].startShowAnimation(1);
        this._animationComponents[13] = new AnimationComponent(this.mainCanvas, this._rectDialog, _WIDTH, _HEIGHT);
        this._animationComponents[13].startShowAnimation(3);
        this._animationComponents[14] = new AnimationComponent(this.mainCanvas, this._rectGameOver, _WIDTH, _HEIGHT);
        this._animationComponents[14].startShowAnimation(3);
        this._animationComponents[15] = new AnimationComponent(this.mainCanvas, this.rectItems[2], _WIDTH, _HEIGHT);
        this._animationComponents[15].startShowAnimation(3);
        this._animationComponents[16] = new AnimationComponent(this.mainCanvas, this.rectItems[9], _WIDTH, _HEIGHT);
        this._animationComponents[16].startShowAnimation(1);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5].startShowAnimation(3);
        this._animationComponents[6].startShowAnimation(2);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8].startShowAnimation(0);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11].startShowAnimation(0);
        this._animationComponents[12].startShowAnimation(1);
        this._animationComponents[13].startShowAnimation(3);
        this._animationComponents[14].startShowAnimation(3);
        this._animationComponents[15].startShowAnimation(2);
        this._animationComponents[16].startShowAnimation(0);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(0);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(3);
        this._animationComponents[5].startHideAnimation(3);
        this._animationComponents[6].startHideAnimation(2);
        this._animationComponents[7].startHideAnimation(1);
        this._animationComponents[8].startHideAnimation(0);
        this._animationComponents[9].startHideAnimation(3);
        this._animationComponents[10].startHideAnimation(2);
        this._animationComponents[11].startHideAnimation(0);
        this._animationComponents[12].startHideAnimation(1);
        this._animationComponents[13].startHideAnimation(3);
        this._animationComponents[14].startHideAnimation(3);
        this._animationComponents[15].startHideAnimation(2);
        this._animationComponents[16].startHideAnimation(0);
    }

    private void freeGraphics() {
        this._imgInlogicLogo = null;
    }

    private void prepareTxt() {
        this.initTxt();
        String controls = "";
        controls = Resources.resTexts[0].getHashedString(17) + "\n\n\n\n\n\n\n\n";
        controls = Resources.resTexts[0].getHashedString(17) + "\n\n\n\n";
        _ptInstruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls, this.rectText.width);
        _ptInstruction.setLineHeightCorrection(-2);
        RMSObjects.game.loadStars();
    }

    private void saveLevelsDone() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = this._iActLevel;
        scoreItem.userName = Integer.toString(this._iActLevel);
        scoreItem.scoreValue = 1;
        switch (ScreenMenu.getSelectedMode()) {
            case 0: {
                RMSObjects.challenge.userName = Integer.toString(this._iActLevel);
                RMSObjects.challenge.insertScoreItem(scoreItem, this._iActLevel);
                if (!RMSObjects.rmsConnects[3].isExist()) {
                    RMSObjects.rmsConnects[3].create();
                }
                RMSObjects.rmsConnects[3].save();
                break;
            }
            case 1: {
                RMSObjects.colorSwap.userName = Integer.toString(this._iActLevel);
                RMSObjects.colorSwap.insertScoreItem(scoreItem, this._iActLevel);
                if (!RMSObjects.rmsConnects[4].isExist()) {
                    RMSObjects.rmsConnects[4].create();
                }
                RMSObjects.rmsConnects[4].save();
                break;
            }
            case 2: {
                RMSObjects.reverse.userName = Integer.toString(this._iActLevel);
                RMSObjects.reverse.insertScoreItem(scoreItem, this._iActLevel);
                if (!RMSObjects.rmsConnects[5].isExist()) {
                    RMSObjects.rmsConnects[5].create();
                }
                RMSObjects.rmsConnects[5].save();
            }
        }
    }

    public void beforeInteruption() {
        if (this.status == 0) {
            Keys.resetAllPressedKeysAndActions();
            this.setGameMenuStatus();
        }
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
    }

    private void calculatePositions() {
        int itemHeight;
        int rectPanelY = itemHeight = Resources.resGFonts[0].getHeight();
        int rectTextOffsetX = this._sprBtnMenu.getWidth() >> 1;
        int rectTextOffsetY = this._sprBtnMenu.getHeight() >> 1;
        this.rectPanel = new Rectangle(0, rectPanelY, _WIDTH, _HEIGHT - rectPanelY);
        this.rectGameArea = new Rectangle(0, 0, _WIDTH, _HEIGHT);
        _ptActualScore = new PreparedText(Resources.resGFonts[0]);
        _ptActualScoreGameOver = new PreparedText(Resources.resGFonts[0]);
        _ptActualScore.prepareText("0", MainCanvas.WIDTH);
        this.rectScore = new Rectangle(this._sprBtnMenu.getWidth() >> 1, itemHeight >> 1, MainCanvas.WIDTH - this._sprBtnMenu.getWidth(), _ptActualScore.getTextHeight());
        this.rectBestScore = new Rectangle(0, itemHeight >> 1, MainCanvas.WIDTH, itemHeight);
        this.rectPanel = new Rectangle(0, itemHeight, _WIDTH, _HEIGHT - (itemHeight << 1));
        this.rectText = new Rectangle(rectTextOffsetX, this.rectPanel.y + rectTextOffsetY, _WIDTH - (rectTextOffsetX << 1), this.rectPanel.height - (this.rectPanel.y + rectTextOffsetY));
        this.rectItems[2] = new Rectangle((_WIDTH >> 1) - (this._sprBtnFinish.getWidth() >> 1), (_HEIGHT >> 1) - (this._sprBtnFinish.getHeight() >> 2), this._sprBtnFinish.getWidth(), this._sprBtnFinish.getHeight());
        int pY = this.rectItems[2].y + this.rectItems[2].height + (this._sprBtnMenu.getWidth() >> 2);
        int pX = (_WIDTH >> 1) - (this._sprBtnMenu.getWidth() >> 1);
        int pXoffset = this._sprBtnMenu.getWidth() + (this._sprBtnMenu.getWidth() >> 1);
        this.rectItems[9] = _HEIGHT < 208 && ScreenMenu.isArcadeMode() ? new Rectangle((_WIDTH >> 1) - (this._sprBtnFinish.getWidth() >> 1), (_HEIGHT >> 1) + (this._sprBtnFinish.getHeight() >> 2) + (this._sprBtnFinish.getHeight() >> 3) + (this._sprBtnFinish.getHeight() >> 3), this._sprBtnFinish.getWidth(), this._sprBtnFinish.getHeight()) : new Rectangle((_WIDTH >> 1) - (this._sprBtnFinish.getWidth() >> 1), (_HEIGHT >> 1) + (this._sprBtnFinish.getHeight() >> 2), this._sprBtnFinish.getWidth(), this._sprBtnFinish.getHeight());
        this.rectItems[3] = new Rectangle((_WIDTH >> 1) - (this._sprBtnMenu.getWidth() >> 1), pY + (this._sprBtnMenu.getWidth() >> 1), this._sprBtnMenu.getWidth(), this._sprBtnMenu.getHeight());
        this.rectItems[5] = new Rectangle((_WIDTH >> 1) - (this._sprBtnMenu.getWidth() >> 1), (pY += this.rectItems[3].height + (this._sprBtnMenu.getWidth() >> 1)) + (this._sprBtnMenu.getWidth() >> 1), this._sprBtnMenu.getWidth(), this._sprBtnMenu.getHeight());
        this.rectItems[0] = this.rectLeftFk = new Rectangle(0, _HEIGHT - this._sprBtnMenu.getHeight(), this._sprBtnMenu.getWidth(), this._sprBtnMenu.getHeight());
        this.rectItems[1] = this.rectRightFk = new Rectangle(_WIDTH - this._sprBtnMenu.getWidth(), _HEIGHT - this._sprBtnMenu.getHeight(), this._sprBtnMenu.getWidth(), this._sprBtnMenu.getHeight());
        this.rectPlay = new Rectangle(0, _HEIGHT >> 1, _WIDTH, itemHeight);
        GFont font = Resources.resGFonts[2];
        int posLogoY = (_HEIGHT - this.rectItems[2].y >> 1) - font.getHeight() - this._imgMenuLogo.getHeight();
        this._rectTopBig = new Rectangle(_WIDTH >> 1, posLogoY, this._imgMenuLogo.getWidth(), this._imgMenuLogo.getHeight());
        this._rectStars = new Rectangle(MainCanvas.WIDTH - (this._imgStarFinish.getWidth() << 1), this._imgStarFinish.getHeight(), this._imgStarFinish.getWidth() << 1, this._imgStarFinish.getHeight() + (this._imgStarFinish.getHeight() >> 1) + this._imgStarFinish.getHeight());
    }

    private void calculateWindowTiles() {
    }

    public void update(long lastRunLenght) {
        this.animationController();
        this.animationComponentsUpdate();
        if (this.status == 0) {
            if (this.nextScreen == 2) {
                return;
            }
            if (this._bBkickUpdate) {
                return;
            }
            RMSObjects.game.update(lastRunLenght);
            this.mainCanvas.repaint();
            if (RMSObjects.game.isGameOver()) {
                this.selectedCompId = 9;
                this.startAnimation(true, 2);
            }
            if (RMSObjects.game.isLevelDone()) {
                this.selectedCompId = 9;
                this.startAnimation(true, 2);
            }
        }
        if (this.status == 2) {
            this.mainCanvas.repaint();
        }
        if (this.status == 3) {
            this.needRepaint = false;
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
        if (this.status == 1) {
            // empty if block
        }
    }

    public void textMove() {
        this.needRepaint = false;
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = _ptInstruction.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
        if (this.needRepaint) {
            this.mainCanvas.repaint();
        }
    }

    private boolean animationController() {
        if (this.changeSequence) {
            if (this._sequence == this._sequenceShow) {
                this.showAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceHide) {
                this.hideAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceStop) {
                this.changeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this.status].length; ++i) {
            if (this._animationSequence[this.status][i] == -1 || this._animationComponents[this._animationSequence[this.status][i]] == null || this._animationComponents[this._animationSequence[this.status][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this.status][i]].update();
            if (this.status == 0) {
                // empty if block
            }
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._sequence == this._sequenceHide) {
                if (this.nextScreen == 7) {
                    this.startMenuScreen();
                }
                this._sequence = this._sequenceShow;
                this.status = this.nextScreen;
                this.changeSequence = true;
            } else if (this._sequence == this._sequenceShow) {
                this._sequence = this._sequenceStop;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextScreen) {
        if (nextScreen == 7) {
            ScreenMenu.setSelectedMode(-1);
        }
        this.changeSequence = changeSequencem;
        this.nextScreen = nextScreen;
        this._sequence = this._sequenceHide;
    }

    private void startMenuScreen() {
        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode));
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this.status) {
            case 0: {
                RMSObjects.game.paint(g, this.status);
                this.paintPanelTop(g);
                break;
            }
            case 1: {
                this.paintGameLogo(g);
                this.paintMenuDialogItems(g);
                break;
            }
            case 2: {
                this.paintGameLogo(g);
                this.paintGameOver(g, RMSObjects.game.isLevelDone());
                break;
            }
            case 3: {
                this.paintInstrusctionTxt(g);
                this.paintArrows(g);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.paintMessage(g);
                break;
            }
            case 6: {
                this.paintMessage(g);
            }
        }
        this.paintFK(g);
    }

    public void paintBackground(Graphics g) {
        g.setColor(0x220024);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void paintGameLogo(Graphics g) {
        g.drawImage(this._imgMenuLogo, this._rectTopBig.x, this._rectTopBig.y, 17);
    }

    private void paintInstrusctionTxt(Graphics g) {
        _ptInstruction.drawText(g, this.rectText, this.textOffsetY, 20);
    }

    private void paintMessage(Graphics g) {
        if (this.status == 6) {
            _ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(77), this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 5) {
            _ptMenuItem.prepareText(Resources.resTexts[0].getHashedString(78), this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() >> 1, 3);
        } else if (this.status == 2) {
            Object _sprWarrior = null;
            String text = Resources.resTexts[0].getHashedString(13);
            String nect = RMSObjects.game.getArcadeBestScore() < RMSObjects.game.getScore() ? "\n" + Resources.resTexts[0].getHashedString(10) + " : " + RMSObjects.game.getScore() + "\n" + Resources.resTexts[0].getHashedString(83) + ": " + RMSObjects.game.getScore() : "\n" + Resources.resTexts[0].getHashedString(10) + " : " + RMSObjects.game.getScore() + "\n" + Resources.resTexts[0].getHashedString(83) + ": " + RMSObjects.game.getArcadeBestScore();
            _ptMenuItem.prepareText(text, this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() + (_ptMenuItem.getTextHeight() >> 1), 3);
            bestScore.prepareText(nect, this.rectText.width);
            bestScore.drawText(g, this.rectText, _ptMenuItem.getTextHeight(), 3);
        } else if (this.status == 0 && RMSObjects.game.isInitGame()) {
            _ptMenuItem.prepareText("PRESS 5 TO START THE GAME", this.rectText.width);
            _ptMenuItem.drawText(g, this.rectText, _ptMenuItem.getTextHeight() >> 1, 3);
        }
    }

    private void paintGameOver(Graphics g, boolean _bWin) {
        if (this.selectedCompId == 2) {
            if (!_bWin) {
                this.paintButton(g, 2, this._sprBtnFinish, true, 1);
            } else {
                this.paintButton(g, 2, this._sprBtnFinish, true, 2);
            }
        }
        if (this.selectedCompId == 9) {
            if (!_bWin) {
                this.paintButton(g, 9, this._sprBtnFinish, true, 1);
            } else {
                this.paintButton(g, 9, this._sprBtnFinish, true, 2);
            }
        } else if (!_bWin) {
            this.paintButton(g, 9, this._sprBtnFinish, false, 1);
        } else {
            this.paintButton(g, 9, this._sprBtnFinish, false, 2);
        }
        if (this.selectedCompId == 5) {
            this.paintButton(g, 5, this._sprBtnMenu, true, 5);
        } else {
            this.paintButton(g, 5, this._sprBtnMenu, false, 5);
        }
        GFont font = Resources.resGFonts[3];
        PreparedText _over = new PreparedText(Resources.resGFonts[2]);
        Rectangle rect = new Rectangle();
        String s = "";
        switch (this._selectedMode) {
            case -1: {
                s = "SCORE\n" + RMSObjects.game.getScore();
                break;
            }
            case 0: {
                s = Resources.resTexts[0].getHashedString(90);
                break;
            }
            case 1: {
                s = Resources.resTexts[0].getHashedString(91);
                break;
            }
            case 2: {
                s = Resources.resTexts[0].getHashedString(92);
                break;
            }
        }
        if (!ScreenMenu.isArcadeMode()) {
            GFont fnt = Resources.resGFonts[0];
            int _count_of_game_mode_btn = (fnt.stringWidth(s.toCharArray()) + font.getSpaceWidth()) / this._sprBtnModesFailed.getWidth() + 1;
            if (_count_of_game_mode_btn * this._sprBtnModesFailed.getWidth() + this._sprBtnModesFailed.getWidth() <= MainCanvas.WIDTH) {
                ++_count_of_game_mode_btn;
            }
            if (!RMSObjects.game.isLevelDone()) {
                for (int i = 0; i < _count_of_game_mode_btn; ++i) {
                    if (i == 0) {
                        this._sprBtnModesFailed.setFrame(0);
                    } else if (i == _count_of_game_mode_btn - 1) {
                        this._sprBtnModesFailed.setFrame(2);
                    } else {
                        this._sprBtnModesFailed.setFrame(1);
                    }
                    this._sprBtnModesFailed.setPosition((_WIDTH >> 1) - (_count_of_game_mode_btn * this._sprBtnModesFailed.getWidth() >> 1) + i * this._sprBtnModesFailed.getWidth(), this._rectTopBig.y + this._rectTopBig.height + (this._rectTopBig.height >> 2));
                    this._sprBtnModesFailed.paint(g);
                }
            } else {
                for (int i = 0; i < _count_of_game_mode_btn; ++i) {
                    if (i == 0) {
                        this._sprBtnModesCompleted.setFrame(0);
                    } else if (i == _count_of_game_mode_btn - 1) {
                        this._sprBtnModesCompleted.setFrame(2);
                    } else {
                        this._sprBtnModesCompleted.setFrame(1);
                    }
                    this._sprBtnModesCompleted.setPosition((_WIDTH >> 1) - (_count_of_game_mode_btn * this._sprBtnModesCompleted.getWidth() >> 1) + i * this._sprBtnModesCompleted.getWidth(), this._rectTopBig.y + this._rectTopBig.height + (this._rectTopBig.height >> 2));
                    this._sprBtnModesCompleted.paint(g);
                }
            }
        }
        if (!ScreenMenu.isArcadeMode()) {
            _ptSelectedModeText.prepareText(s, MainCanvas.WIDTH);
            rect = new Rectangle(0, this._rectTopBig.y + this._rectTopBig.height + (this._rectTopBig.height >> 2), _WIDTH, this._sprBtnModesFailed.getHeight());
            _ptSelectedModeText.drawText(g, rect, 0, 3);
        } else {
            _over.prepareText(s, this.rectText.width);
            rect = new Rectangle(0, this._rectTopBig.y + this._rectTopBig.height + (this._rectTopBig.height >> 2), _WIDTH, _over.getTextHeight());
            _over.drawText(g, rect, 0, 1);
        }
        if (!ScreenMenu.isArcadeMode()) {
            if (_bWin) {
                _over.prepareText(Resources.resTexts[0].getHashedString(49), _WIDTH);
            } else {
                _over.prepareText(Resources.resTexts[0].getHashedString(13), _WIDTH);
            }
        } else {
            _over = new PreparedText(Resources.resGFonts[3]);
            _over.prepareText(Resources.resTexts[0].getHashedString(95) + "\n" + RMSObjects.game.getArcadeBestScore(), MainCanvas.WIDTH);
        }
        int _iOffset = this._rectTopBig.y + this._rectTopBig.height + (this._rectTopBig.height >> 2) + rect.height + (font.getHeight() >> 1);
        g.drawImage(this._imgColorLine, MainCanvas.WIDTH >> 1, _iOffset, 17);
        _over.drawText(g, new Rectangle(0, _iOffset + (font.getHeight() >> 1), MainCanvas.WIDTH, _over.getTextHeight()), 0, 1);
        g.drawImage(this._imgStarFinish, this._rectStars.getCenterX(), this._rectStars.y, 17);
        Resources.resGFonts[2].drawString(g, (RMSObjects.game.getIngameScore() + "").toCharArray(), this._rectStars.getCenterX(), this._rectStars.getBottom(), 33);
    }

    private void paintArrows(Graphics g) {
        if (this.scrollDOWN && this.scrollUP) {
            this._sprArrowsActive.setFrame(0);
            this._sprArrowsActive.setPosition(_WIDTH - this._sprArrowsActive.getWidth() >> 1, this._sprTopPanel.getHeight());
            this._sprArrowsActive.paint(g);
            this._sprArrowsActive.setFrame(1);
            this._sprArrowsActive.setPosition(_WIDTH - this._sprArrowsActive.getWidth() >> 1, _HEIGHT - (this._imgBottomPanel.getHeight() >> 1) - (this._sprArrowsActive.getHeight() >> 1));
            this._sprArrowsActive.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._sprArrowsActive.setFrame(0);
            this._sprArrowsActive.setPosition(_WIDTH - this._sprArrowsActive.getWidth() >> 1, this._sprTopPanel.getHeight());
            this._sprArrowsActive.paint(g);
            this._sprArrowsInactive.setFrame(1);
            this._sprArrowsInactive.setPosition(_WIDTH - this._sprArrowsInactive.getWidth() >> 1, _HEIGHT - (this._imgBottomPanel.getHeight() >> 1) - (this._sprArrowsInactive.getHeight() >> 1));
            this._sprArrowsInactive.paint(g);
        }
        if (this.scrollDOWN && !this.scrollUP) {
            this._sprArrowsInactive.setFrame(0);
            this._sprArrowsInactive.setPosition(_WIDTH - this._sprArrowsInactive.getWidth() >> 1, this._sprTopPanel.getHeight());
            this._sprArrowsInactive.paint(g);
            this._sprArrowsActive.setFrame(1);
            this._sprArrowsActive.setPosition(_WIDTH - this._sprArrowsActive.getWidth() >> 1, _HEIGHT - (this._imgBottomPanel.getHeight() >> 1) - (this._sprArrowsActive.getHeight() >> 1));
            this._sprArrowsActive.paint(g);
        }
    }

    private void paintPanelTop(Graphics g) {
        if (RMSObjects.game.getScore() <= 0) {
            _ptActualScore.prepareText("0", this.rectScore.width);
        } else {
            _ptActualScore.prepareText("" + RMSObjects.game.getScore(), this.rectScore.width);
        }
        _ptActualScore.drawText(g, this.rectScore, 0, 6);
    }

    public void paintTop(Graphics g) {
    }

    private void paintFK(Graphics g) {
        if (this.status == 0) {
            this._sprBtnMenu.setFrame(3);
            this._sprBtnMenu.setPosition(this.rectRightFk.x, this.rectRightFk.y);
            this._sprBtnMenu.paint(g);
        } else if (this.status != 1) {
            if (this.status == 5) {
                this._sprBtnMenu.setFrame(1);
                this._sprBtnMenu.setPosition(this.rectRightFk.x, this.rectRightFk.y);
                this._sprBtnMenu.paint(g);
                this._sprBtnMenu.setFrame(0);
                this._sprBtnMenu.setPosition(this.rectLeftFk.x, this.rectLeftFk.y);
                this._sprBtnMenu.paint(g);
            } else if (this.status == 6) {
                this._sprBtnMenu.setFrame(1);
                this._sprBtnMenu.setPosition(this.rectRightFk.x, this.rectRightFk.y);
                this._sprBtnMenu.paint(g);
                this._sprBtnMenu.setFrame(0);
                this._sprBtnMenu.setPosition(this.rectLeftFk.x, this.rectLeftFk.y);
                this._sprBtnMenu.paint(g);
            } else if (this.status == 2) {
                // empty if block
            }
        }
    }

    private void paintMenuDialogItems(Graphics g) {
        if (this.selectedCompId == 2) {
            this.paintButton(g, 2, this._sprBtnFinish, true, 0);
        } else {
            this.paintButton(g, 2, this._sprBtnFinish, false, 0);
        }
        this._sprBtnMenu.setTransform(2);
        if (this.selectedCompId == 3) {
            this.paintButton(g, 3, this._sprBtnMenu, true, 3);
        } else {
            this.paintButton(g, 3, this._sprBtnMenu, false, 3);
        }
        this._sprBtnMenu.setTransform(0);
        if (this.selectedCompId == 5) {
            this.paintButton(g, 5, this._sprBtnMenu, true, 5);
        } else {
            this.paintButton(g, 5, this._sprBtnMenu, false, 5);
        }
        String s = Resources.resTexts[0].getHashedString(88);
        _ptPause.prepareText(s, this.rectText.width);
        Rectangle rect = new Rectangle(0, this._rectTopBig.y + this._rectTopBig.height + (this._rectTopBig.height >> 2), _WIDTH, this._sprBtnModesFailed.getHeight());
        _ptPause.drawText(g, rect, 0, 3);
    }

    private String getButtonName(int _idx) {
        if (_idx == 3) {
            return Resources.resTexts[0].getHashedString(25);
        }
        if (_idx == 6) {
            return Resources.resTexts[0].getHashedString(22);
        }
        if (_idx == 5) {
            return Resources.resTexts[0].getHashedString(19);
        }
        if (_idx == 4) {
            return MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27);
        }
        return "NAN";
    }

    private void paintButton(Graphics g, int _type, Sprite _sprBtn, boolean active, int frame) {
        if (active) {
            _sprBtn.setFrame(frame);
            _sprBtn.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
            _sprBtn.paint(g);
        } else {
            _sprBtn.setFrame(frame);
            _sprBtn.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
            _sprBtn.paint(g);
        }
    }

    private void paintWindow(Graphics g, Rectangle _rectWindow) {
    }

    private void paintWindowBlue(Graphics g, Rectangle _rectWindow) {
    }

    private int getWindowTileSprite(int _x, int _y) {
        return 7;
    }

    private int getWindowTileSpriteBlue(int _x, int _y, int cols, int rows) {
        return 10;
    }

    public void keyPressed(int keyCode) {
        if (0 == this.status && !Keys.isActionGeneratedByKey(3, keyCode) && !Keys.isActionGeneratedByKey(4, keyCode) && keyCode != 49 && Keys.isActionGeneratedByKey(5, keyCode)) {
            RMSObjects.game.Jump();
        }
    }

    public void keyReleased(int keyCode) {
        switch (this.status) {
            case 4: {
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 0);
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.setGameMenuStatus();
                }
                if (Keys.isFKLeftCode(keyCode) || keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) {
                    // empty if block
                }
                if (Keys.isActionGeneratedByKey(3, keyCode) || Keys.isActionGeneratedByKey(4, keyCode) || Keys.isActionGeneratedByKey(1, keyCode) || Keys.isActionGeneratedByKey(2, keyCode) || !Keys.isActionGeneratedByKey(5, keyCode)) break;
                break;
            }
            case 1: {
                if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
                    this.keyReleasedMenuGame(keyCode);
                }
                RMSObjects.game.setCurrentTime(System.currentTimeMillis());
                RMSObjects.game.setPauseTimer(true);
                break;
            }
            case 2: {
                this.keyReleasedResult(keyCode);
                break;
            }
            case 3: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55 || !Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
                this.selectedCompId = 6;
                break;
            }
            case 6: {
                if (Keys.isFKLeftCode(keyCode)) {
                    RMSObjects.game.setPauseTimer(false);
                    this.startAnimation(true, 7);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                break;
            }
            case 5: {
                if (Keys.isFKLeftCode(keyCode)) {
                    RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true, this._iSelectedCharacter);
                    RMSObjects.game.setPauseTimer(false);
                    this.startAnimation(true, 0);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
            }
        }
        this.mainCanvas.repaint();
    }

    private void setGameMenuStatus() {
        this.startAnimation(true, 1);
    }

    private void keyReleasedMenuGame(int keyCode) {
        switch (this.selectedCompId) {
            case 2: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                Keys.resetAllPressedKeysAndActions();
                RMSObjects.game.releaaseControls();
                this.startAnimation(true, 0);
                RMSObjects.game.resetTimer();
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 2;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 5);
                Keys.resetAllPressedKeysAndActions();
                this.mainCanvas.repaint();
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 2;
                    break;
                }
                if (Keys.isActionGeneratedByKey(3, keyCode) || Keys.isActionGeneratedByKey(4, keyCode) || !Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 6);
            }
        }
    }

    private void keyReleasedResult(int keyCode) {
        if (this.selectedCompId == 9) {
            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                this.selectedCompId = 5;
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                this.selectedCompId = 5;
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                if (RMSObjects.game.isGameOver()) {
                    RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true, this._iSelectedCharacter);
                    this.startAnimation(true, 0);
                    MainCanvas.soundManager.Stop();
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                } else if (RMSObjects.game.isLevelDone()) {
                    this.saveLevelsDone();
                    this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode, 6));
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    }
                }
            }
        } else if (this.selectedCompId == 5) {
            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                this.selectedCompId = 9;
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                this.selectedCompId = 9;
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                if (RMSObjects.game.isLevelDone()) {
                    this.saveLevelsDone();
                }
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode));
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            }
        }
        if (RMSObjects.game.isGameOver()) {
            if (Keys.isFKRightCode(keyCode)) {
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode));
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true, this._iSelectedCharacter);
                this.startAnimation(true, 0);
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                }
            }
        } else if (RMSObjects.game.isLevelDone()) {
            if (Keys.isFKLeftCode(keyCode)) {
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode));
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                // empty if block
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.posX = x;
        this.posY = y;
        block11: for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.existComponentInState(i, this.status) || this.rectItems[i] == null || !this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                case 2: {
                    if (this.status != 1) continue block11;
                    Keys.keyPressed(53);
                    RMSObjects.game.resetTimer();
                    continue block11;
                }
                case 5: {
                    if (this.status == 1) {
                        this.startAnimation(true, 6);
                        continue block11;
                    }
                    if (RMSObjects.game.isLevelDone()) {
                        this.saveLevelsDone();
                    }
                    this.startAnimation(true, 7);
                    continue block11;
                }
                case 0: {
                    if (this.status != 1) {
                        Keys.keyPressed(-6);
                        continue block11;
                    }
                    Keys.keyPressed(-6);
                    continue block11;
                }
                case 3: {
                    if (RMSObjects.game.isLevelDone()) {
                        this.saveLevelsDone();
                        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode, 6));
                        if (!MainCanvas.soundManager.IsSoundOn()) continue block11;
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                        continue block11;
                    }
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    continue block11;
                }
                case 9: {
                    if (RMSObjects.game.isGameOver()) {
                        RMSObjects.game.restartGame(this._lActualLevel, this.rectGameArea, this._iMode, true, this._iSelectedCharacter);
                        this.startAnimation(true, 0);
                        MainCanvas.soundManager.Stop();
                        if (!MainCanvas.soundManager.IsSoundOn()) continue block11;
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                        continue block11;
                    }
                    if (RMSObjects.game.isLevelDone()) {
                        this.saveLevelsDone();
                        this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0, this._iMode, 6));
                        if (!MainCanvas.soundManager.IsSoundOn()) continue block11;
                        MainCanvas.soundManager.Stop();
                        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                        continue block11;
                    }
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    continue block11;
                }
                case 7: {
                    if (this.status != 1) {
                        Keys.keyPressed(-6);
                        continue block11;
                    }
                    Keys.keyPressed(-6);
                    continue block11;
                }
                case 8: {
                    if (this.status == 3) {
                        this.startAnimation(true, 1);
                        this.textOffsetY = 0;
                        this.scrollUP = false;
                        this.scrollDOWN = true;
                        this.mainCanvas.repaint();
                        continue block11;
                    }
                    Keys.keyPressed(-7);
                    continue block11;
                }
                case 1: {
                    if (this.status == 3) {
                        this.startAnimation(true, 1);
                        this.textOffsetY = 0;
                        this.scrollUP = false;
                        this.scrollDOWN = true;
                        this.mainCanvas.repaint();
                        continue block11;
                    }
                    Keys.keyPressed(-7);
                    this.keyReleased(-7);
                    continue block11;
                }
                case 4: {
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.SetSoundOn(false);
                        MainCanvas.soundManager.Stop();
                    } else {
                        MainCanvas.soundManager.SetSoundOn(true);
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                    this.mainCanvas.repaint();
                    continue block11;
                }
            }
        }
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
    }

    private boolean existComponentInState(int i, int status) {
        if (status == 0) {
            if (i == 1) {
                return true;
            }
        } else if (status == 6) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 1) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
            if (i == 2) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 4) {
                return true;
            }
            if (i == 6) {
                return true;
            }
            if (i == 5) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 2) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
            if (i == 8) {
                return true;
            }
            if (i == 7) {
                return true;
            }
            if (i == 9) {
                return true;
            }
            if (i == 5) {
                return true;
            }
        } else if (status == 5) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 4) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this.status == 3) {
            if (this.posY > y) {
                this.dragUp();
            } else if (this.posY < y) {
                this.dragDown();
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.status == 4) {
            this.startAnimation(true, 0);
            return;
        }
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            RMSObjects.game.pointerReleased(x, y);
            return;
        }
        switch (this.selectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 7: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 8: {
                if (Keys.isKeyPressed(-7)) {
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                }
                this.mainCanvas.repaint();
                break;
            }
            case 1: {
                if (Keys.isKeyPressed(-7)) {
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                }
                this.mainCanvas.repaint();
                break;
            }
            default: {
                if (Keys.isKeyPressed(53)) {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
                if (this.status != 1) break;
                this.selectedCompId = 1;
                this.mainCanvas.repaint();
            }
        }
    }

    public void dragUp() {
        if (Resources.sysFont) {
            this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY < 0) {
            this.textOffsetY = 0;
            this.scrollUP = false;
            this.scrollDOWN = true;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        int maxOffsetY = _ptInstruction.getTextHeight() - this.rectPanel.height;
        if (Resources.sysFont) {
            this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY > maxOffsetY) {
            this.textOffsetY = maxOffsetY;
            this.scrollUP = true;
            this.scrollDOWN = false;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    static {
        _WIDTH = 0;
        _HEIGHT = 0;
    }
}

