/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.Character;
import sk.inlogic.MainCanvas;
import sk.inlogic.Obstacle;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenMenu
implements IScreen {
    private MainCanvas mainCanvas;
    public static final int COMP_ID_PLAY = 0;
    public static final int COMP_ID_INSTRUCTIONS = 1;
    public static final int COMP_ID_SCORE = 2;
    public static final int COMP_ID_ABOUT = 3;
    public static final int COMP_ID_SETTINGS = 4;
    public static final int COMP_ID_QUIT = 5;
    public static final int COMP_ID_OPTIONS = 6;
    public static final int COMP_ID_RIGHT_FK = 7;
    public static final int COMP_ID_LEFT_FK = 8;
    public static final int COMP_ID_SHOP = 9;
    public static final int COMP_ID_MODS = 10;
    public static final int COMP_ID_NONE = 11;
    private static final int TOTAL_COMP_IDS = 12;
    public static final int COMP_ID_PLAY_TXT = 0;
    public static final int COMP_ID_INSTRUCTIONS_TXT = 1;
    public static final int COMP_ID_SCORE_TXT = 2;
    public static final int COMP_ID_ABOUT_TXT = 3;
    public static final int COMP_ID_NONE_TXT = 6;
    private static final int TOTAL_COMP_IDS_TXT = 7;
    private int actualScreen = 0;
    private static final int SCREEN_MAIN_MENU = 0;
    private static final int SCREEN_INSTRUCTIONS = 1;
    private static final int SCREEN_SHOP = 2;
    private static final int SCREEN_START_GAME = 3;
    private static final int SCREEN_QUIT_GAME = 4;
    private static final int SCREEN_OPTIONS = 5;
    private static final int SCREEN_LEVELS = 6;
    private static final int SCREEN_GAME_MODS = 7;
    int _iPositionX = 0;
    int _iPositionY = 0;
    int _iSelectedLvl = 0;
    private Rectangle[] rectItems = new Rectangle[12];
    private int[][] _animationSequence = new int[9][12];
    private AnimationComponent[] _animationComponents = new AnimationComponent[12];
    private Rectangle[] _rectLevels = new Rectangle[100];
    private Rectangle[] _rectCharacters = new Rectangle[50];
    private Rectangle[] _rectGameModes = new Rectangle[3];
    private Rectangle rectLeftFk;
    private Rectangle rectRightFk;
    private Rectangle _rectTopBig;
    private Rectangle rectPanel;
    private Rectangle rectText;
    private Rectangle _rectDialog;
    private Rectangle _rectAboutDialog;
    private Rectangle _rectTopBar;
    private int[] _arrImages;
    private int[] _arrSprites;
    private int[] _arrFonts;
    private int iShiftY = 0;
    private int iMaxShiftY = 0;
    private int iMaxShiftYLevels = 0;
    private int _buttonRowsInArea = 0;
    private int _rowShopShift = 0;
    private int _iSelectedLevel = 0;
    private int _iSelectedCharacter = 0;
    private int _iCharacterSelector = 0;
    private static int _iGameModeSelector = -1;
    private int selectedCompId;
    private int selectorCompId;
    private int interuption = 0;
    private int _iTotalRowTiles = 0;
    private int _iTotalColTiles = 0;
    private int _iOffsetX;
    private int _iFinalHeight;
    private int scoresCount = 0;
    private int count = 0;
    private String[] levelsChallenge = new String[100];
    private String[] levelsColorSwap = new String[100];
    private String[] levelsReverse = new String[100];
    private String[] characters = new String[50];
    private String[] levelnames = new String[100];
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private boolean needRepaint = false;
    private boolean activeButton = true;
    PreparedText _ptMnuItem;
    PreparedText _ptNavigationKeysBB;
    PreparedText title;
    PreparedText _ptInstruction;
    PreparedText _ptLevels;
    PreparedText _ptVersionOfGame;
    PreparedText _ptDifficulty;
    PreparedText _ptTitle;
    PreparedText _ptShop;
    PreparedText _ptQuit;
    private int textOffsetY;
    private Image _imgInlogicLogo;
    private Image _imgMenuLogo;
    private Image _imgBottomPanel;
    private Image _imgBtnMenuSelector;
    private Image _imgBtnMenuMainSelector;
    private Image _imgBtnFinishSelector;
    private Image _imgBtnLevelSelector;
    private Image _imgColorLine;
    private Image _imgGameModeSelector;
    private Image _imgInlogicLogoAbout;
    private Image _imgStarBlue;
    private Image _imgStarFinish;
    private Image _imgStarGame;
    private Image _imgStarLock;
    private Image _imgStarOrange;
    private Sprite _sprArrowsActive;
    private Sprite _sprArrowsInactive;
    private Sprite _sprBtnModesCompleted;
    private Sprite _sprBtnModesFailed;
    private Sprite _sprBtnModesSelector;
    private Sprite _sprBtnMenu;
    private Sprite _sprBtnMenuMain;
    private Sprite _sprBtnFinish;
    private Sprite _sprBtnLevel;
    private Sprite _sprBtnShop;
    private Sprite _sprGameMode;
    private Sprite _sprTable;
    private Sprite _sprTopPanel;
    private Sprite _sprPlayer1;
    private Sprite _sprPlayer2;
    private Sprite _sprPlayer3;
    private Sprite _sprPlayer4;
    private Sprite _sprPlayer5;
    private Sprite _sprNumbers;
    private Sprite _sprNumbersSmall;
    private Sprite _sprNumbersBlack;
    private Sprite _sprNumbersGrey;
    private Sprite _sprBtnPlay;
    private Sprite _sprBtnPlaySelector;
    private static int _WIDTH = 0;
    private static int _HEIGHT = 0;
    boolean check = false;
    int _iColorBg = 15691352;
    int _count_of_game_mode_btn;
    int _count_of_game_mode_btn_selector;
    private int _iScore = 0;
    private int _iMainCharacter = 0;
    private boolean notEnoughScore = false;
    private int _iMode = 0;
    int _finalHeight;
    int _off;
    int cycle = 10;
    private int musicControler = 0;
    private int _sequenceStop = 0;
    private int _sequenceShow = 1;
    private int _sequenceHide = 2;
    private int _sequence = 0;
    boolean changeSequence = false;
    private int nextScreen;
    private final int _COLOR_BLACK;
    private final int _COLOR_BLUE;
    private final int _COLOR_GREEN;
    private final int _COLOR_RED;
    private final int _COLOR_YELLOW;
    int _iAngle = 0;
    Obstacle obs;
    Obstacle obs2;
    Character character;
    private int lastOpened = 0;
    private int levels = 0;
    private String[] allLevels = new String[100];
    private int notEnoughScoreCounter = 0;
    int a;
    private boolean releasedTouch = false;
    private static boolean _bArcade = false;
    private static int _topBarGameMode = -1;
    private int sel = this.selectedCompId;
    private int s = this.selectedCompId;
    private int force = this.selectedCompId;
    private int iPressedShopX;
    private int iPressedShopY;
    private boolean bDragShop = false;
    private int iShopDraggedY = 0;
    int posX = 0;
    int posY = 0;

    public ScreenMenu(MainCanvas mainCanvas, int selectedItem, int _imode) {
        this._COLOR_BLACK = 0;
        this._COLOR_BLUE = 45298;
        this._COLOR_GREEN = 46654;
        this._COLOR_RED = 16716619;
        this._COLOR_YELLOW = 16771584;
        MainCanvas.counterX = 0;
        MainCanvas.counterY = 0;
        MainCanvas.slcPack = 0;
        this.actualScreen = 0;
        this.mainCanvas = mainCanvas;
        this.initDimensions();
        this.selectedCompId = 11;
        this.selectorCompId = 11;
        this._iMode = _imode;
    }

    public ScreenMenu(MainCanvas mainCanvas, int selectedItem, int _imode, int _iScreen) {
        this._COLOR_BLACK = 0;
        this._COLOR_BLUE = 45298;
        this._COLOR_GREEN = 46654;
        this._COLOR_RED = 16716619;
        this._COLOR_YELLOW = 16771584;
        MainCanvas.counterX = 0;
        MainCanvas.counterY = 0;
        MainCanvas.slcPack = 0;
        this.actualScreen = _iScreen;
        this.mainCanvas = mainCanvas;
        this.initDimensions();
        this.selectedCompId = 11;
        this.selectorCompId = 11;
        this._iMode = _imode;
    }

    private void calcCountOfSprites() {
        this._count_of_game_mode_btn = ((Resources.resGFonts[0].stringWidth(Resources.resTexts[0].getHashedString(89).toCharArray()) + Resources.resGFonts[0].getSpaceWidth()) / this._sprBtnModesFailed.getWidth() >> 1) + 1;
    }

    public void beforeShow() {
        this.prepareResources();
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.initTxt();
        this.calculatePositions();
        this.prepareTxt();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.initMode();
        this.loadMainCharacter();
        this.loadStars();
        this.saveStars();
        this.prepareLevelsDone();
        this.initShop();
        this.initLevels();
        this.calcLevels();
        this.calcCountOfSprites();
    }

    public void afterHide() {
        this.freeResources();
        this.freeGraphics();
    }

    private void prepareResources() {
        this._arrImages = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        this._arrSprites = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24};
        this._arrFonts = new int[]{0, 1, 2, 3};
    }

    private void loadStars() {
        Vector scores = RMSObjects.localScores.getScoresForGame(0);
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].load()) {
            RMSObjects.rmsConnects[0].create();
        }
        if ((scores = RMSObjects.localScores.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this.scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this._iScore = scoreItem.scoreValue;
        }
    }

    private void prepareLevelsDone() {
        int i;
        for (int i2 = 0; i2 < 100; ++i2) {
            this.levelsChallenge[i2] = null;
            this.levelsColorSwap[i2] = null;
            this.levelsReverse[i2] = null;
            this.levelnames[i2] = null;
        }
        Vector scores = null;
        PowV2ScoreItem scoreItem = null;
        RMSObjects.createRMSConnect(3);
        if (!RMSObjects.rmsConnects[3].load()) {
            RMSObjects.rmsConnects[3].create();
            scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = 0;
            scoreItem.userName = Integer.toString(0);
            scoreItem.scoreValue = 1;
            RMSObjects.challenge.userName = Integer.toString(0);
            RMSObjects.challenge.insertScoreItem(scoreItem, 0);
            RMSObjects.rmsConnects[3].save();
        }
        if ((scores = RMSObjects.challenge.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        scoreItem = null;
        for (i = 0; i < 100; ++i) {
            if (i < this.scoresCount) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                this.levelsChallenge[i] = Integer.toString(scoreItem.scoreValue);
                MainCanvas.totalStars += scoreItem.scoreValue;
                ++this.count;
                continue;
            }
            this.levelsChallenge[i] = null;
        }
        RMSObjects.rmsConnects[3].save();
        RMSObjects.createRMSConnect(4);
        if (!RMSObjects.rmsConnects[4].load()) {
            RMSObjects.rmsConnects[4].create();
            scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = 0;
            scoreItem.userName = Integer.toString(0);
            scoreItem.scoreValue = 1;
            RMSObjects.colorSwap.userName = Integer.toString(0);
            RMSObjects.colorSwap.insertScoreItem(scoreItem, 0);
            RMSObjects.rmsConnects[4].save();
        }
        if ((scores = RMSObjects.colorSwap.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        scoreItem = null;
        for (i = 0; i < 100; ++i) {
            if (i < this.scoresCount) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                this.levelsColorSwap[i] = Integer.toString(scoreItem.scoreValue);
                MainCanvas.totalStars += scoreItem.scoreValue;
                ++this.count;
                continue;
            }
            this.levelsColorSwap[i] = null;
        }
        RMSObjects.rmsConnects[4].save();
        RMSObjects.createRMSConnect(5);
        if (!RMSObjects.rmsConnects[5].load()) {
            RMSObjects.rmsConnects[5].create();
            scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = 0;
            scoreItem.userName = Integer.toString(0);
            scoreItem.scoreValue = 1;
            RMSObjects.reverse.userName = Integer.toString(0);
            RMSObjects.reverse.insertScoreItem(scoreItem, 0);
            RMSObjects.rmsConnects[5].save();
        }
        if ((scores = RMSObjects.reverse.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        scoreItem = null;
        for (i = 0; i < 100; ++i) {
            if (i < this.scoresCount) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                this.levelsReverse[i] = Integer.toString(scoreItem.scoreValue);
                MainCanvas.totalStars += scoreItem.scoreValue;
                ++this.count;
                continue;
            }
            this.levelsReverse[i] = null;
        }
        RMSObjects.rmsConnects[5].save();
        this.loadCharacters();
    }

    private void loadCharacters() {
        Vector scores;
        for (int i = 0; i < 50; ++i) {
            this.characters[i] = null;
        }
        RMSObjects.createRMSConnect(6);
        if (!RMSObjects.rmsConnects[6].load()) {
            RMSObjects.rmsConnects[6].create();
            this.saveDefaultCharacters();
        }
        if ((scores = RMSObjects.characters.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        for (int i = 0; i < 50; ++i) {
            if (i < this.scoresCount) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                this.characters[i] = Integer.toString(scoreItem.scoreValue);
                ++this.count;
                continue;
            }
            this.characters[i] = null;
        }
        RMSObjects.rmsConnects[6].save();
    }

    private void saveDefaultCharacters() {
        for (int _iIdx = 0; _iIdx < 50; ++_iIdx) {
            PowV2ScoreItem scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = 0;
            scoreItem.userName = Integer.toString(_iIdx);
            scoreItem.scoreValue = _iIdx == 0 ? -1 : 0;
            RMSObjects.characters.userName = Integer.toString(_iIdx);
            RMSObjects.characters.insertScoreItem(scoreItem, _iIdx);
        }
        RMSObjects.rmsConnects[6].save();
    }

    private void saveStars() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        scoreItem.scoreValue = this._iScore;
        RMSObjects.localScores.userName = Integer.toString(0);
        RMSObjects.localScores.insertScoreItem(scoreItem, this._iScore);
        if (!RMSObjects.rmsConnects[0].isExist()) {
            RMSObjects.rmsConnects[0].create();
        }
        RMSObjects.rmsConnects[0].save();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean buyOrSelectCharacter() {
        if (!this.characters[this._iSelectedCharacter].equals("0")) {
            this._iMainCharacter = this._iSelectedCharacter;
            this.saveMainCharacter();
            return true;
        }
        if (this._iSelectedCharacter == 0) {
            this.saveCharacterStars();
            this._iMainCharacter = this._iSelectedCharacter;
            this.saveMainCharacter();
            return true;
        }
        if (this._iScore >= 20 * this._iSelectedCharacter) {
            this._iScore -= 20 * this._iSelectedCharacter;
            this._iMainCharacter = this._iSelectedCharacter;
            this.saveStars();
            this.loadStars();
            this.saveCharacterStars();
            this.saveMainCharacter();
            this.loadCharacters();
            this.mainCanvas.repaint();
            return false;
        }
        this.notEnoughScore = true;
        return false;
    }

    private void initShop() {
        int area = _HEIGHT - this._sprTopPanel.getHeight() - this._imgBottomPanel.getHeight() - this._sprArrowsActive.getHeight() - (this._sprArrowsActive.getHeight() >> 1);
        this.iMaxShiftY = this._rectCharacters.length % 3 == 0 ? this._rectCharacters.length / 3 * (this._sprBtnShop.getHeight() + this._sprBtnShop.getHeight() / 8) - area : (this._rectCharacters.length / 3 + 1) * (this._sprBtnShop.getHeight() + this._sprBtnShop.getHeight() / 8) - area;
    }

    private void initLevels() {
        int area = _HEIGHT - this._sprTopPanel.getHeight() - this._imgBottomPanel.getHeight() - this._sprArrowsActive.getHeight() - (this._sprArrowsActive.getHeight() >> 1);
        this.iMaxShiftYLevels = this._rectLevels.length % 4 == 0 ? this._rectLevels.length / 4 * (this._sprBtnLevel.getHeight() + this._sprBtnLevel.getHeight() / 8) - area : (this._rectLevels.length / 4 + 1) * (this._sprBtnLevel.getHeight() + this._sprBtnLevel.getHeight() / 8) - area;
    }

    private void saveCharacterStars() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = Integer.toString(0);
        scoreItem.scoreValue = this._iSelectedCharacter;
        RMSObjects.characters.userName = Integer.toString(0);
        RMSObjects.characters.insertScoreItem(scoreItem, this._iSelectedCharacter);
        if (!RMSObjects.rmsConnects[6].isExist()) {
            RMSObjects.rmsConnects[6].create();
        }
        RMSObjects.rmsConnects[6].save();
    }

    private void loadMainCharacter() {
        Vector scores;
        RMSObjects.createRMSConnect(7);
        if (!RMSObjects.rmsConnects[7].load()) {
            RMSObjects.rmsConnects[7].create();
            this._iMainCharacter = 0;
            this.saveMainCharacter();
        }
        if ((scores = RMSObjects.mainCharacter.getScoresForGame(0)).size() <= 0) {
            this._iMainCharacter = 0;
            this.saveMainCharacter();
            return;
        }
        PowV2ScoreItem scoreItem = (PowV2ScoreItem)scores.elementAt(0);
        this._iMainCharacter = scoreItem.scoreValue;
    }

    private void saveMainCharacter() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = Integer.toString(0);
        scoreItem.scoreValue = this._iMainCharacter;
        RMSObjects.mainCharacter.userName = Integer.toString(0);
        RMSObjects.mainCharacter.insertScoreItem(scoreItem, 0);
        if (!RMSObjects.rmsConnects[7].isExist()) {
            RMSObjects.rmsConnects[7].create();
        }
        RMSObjects.rmsConnects[7].save();
        System.err.println("char save: " + scoreItem.scoreValue);
    }

    private void loadResources() {
        Resources.loadImages(this._arrImages);
        Resources.loadSprites(this._arrSprites);
        Resources.loadGFonts(this._arrFonts);
        Resources.loadText(0);
    }

    private void freeResources() {
        Resources.freeImages(this._arrImages);
        Resources.freeSprites(this._arrSprites);
        Resources.freeGFonts(this._arrFonts);
    }

    private void initDimensions() {
        _WIDTH = MainCanvas.WIDTH;
        _HEIGHT = MainCanvas.HEIGHT;
    }

    private void initImages() {
        this._imgInlogicLogo = Resources.resImgs[0];
        this._imgMenuLogo = Resources.resImgs[2];
        this._imgBottomPanel = Resources.resImgs[3];
        this._imgBtnMenuSelector = Resources.resImgs[4];
        this._imgBtnMenuMainSelector = Resources.resImgs[5];
        this._imgBtnFinishSelector = Resources.resImgs[6];
        this._imgBtnLevelSelector = Resources.resImgs[7];
        this._imgColorLine = Resources.resImgs[8];
        this._imgGameModeSelector = Resources.resImgs[10];
        this._imgInlogicLogoAbout = Resources.resImgs[11];
        this._imgStarBlue = Resources.resImgs[12];
        this._imgStarFinish = Resources.resImgs[13];
        this._imgStarGame = Resources.resImgs[14];
        this._imgStarLock = Resources.resImgs[15];
        this._imgStarOrange = Resources.resImgs[16];
    }

    private void initSprites() {
        this._sprArrowsActive = Resources.resSprs[0];
        this._sprArrowsInactive = Resources.resSprs[1];
        this._sprBtnModesCompleted = Resources.resSprs[2];
        this._sprBtnModesFailed = Resources.resSprs[3];
        this._sprBtnModesSelector = Resources.resSprs[4];
        this._sprBtnMenu = Resources.resSprs[5];
        this._sprBtnMenuMain = Resources.resSprs[6];
        this._sprBtnFinish = Resources.resSprs[7];
        this._sprBtnLevel = Resources.resSprs[8];
        this._sprBtnShop = Resources.resSprs[9];
        this._sprGameMode = Resources.resSprs[11];
        this._sprTable = Resources.resSprs[12];
        this._sprTopPanel = Resources.resSprs[13];
        this._sprPlayer1 = Resources.resSprs[14];
        this._sprPlayer2 = Resources.resSprs[15];
        this._sprPlayer3 = Resources.resSprs[16];
        this._sprPlayer4 = Resources.resSprs[17];
        this._sprPlayer5 = Resources.resSprs[18];
        this._sprNumbers = Resources.resSprs[19];
        this._sprNumbersSmall = Resources.resSprs[20];
        this._sprNumbersBlack = Resources.resSprs[21];
        this._sprNumbersGrey = Resources.resSprs[22];
        this._sprBtnPlay = Resources.resSprs[23];
        this._sprBtnPlaySelector = Resources.resSprs[24];
    }

    public void initTxt() {
        this._ptMnuItem = new PreparedText(Resources.resGFonts[0]);
        this._ptVersionOfGame = new PreparedText(Resources.resGFonts[3]);
        this._ptInstruction = new PreparedText(Resources.resGFonts[2]);
        this._ptTitle = new PreparedText(Resources.resGFonts[0]);
        this._ptNavigationKeysBB = new PreparedText(Resources.resGFonts[2]);
        this._ptDifficulty = new PreparedText(Resources.resGFonts[2]);
        this._ptLevels = new PreparedText(Resources.resGFonts[2]);
        this._ptQuit = new PreparedText(Resources.resGFonts[2]);
        this._ptShop = new PreparedText(Resources.resGFonts[1]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 0;
        this._animationSequence[0][1] = 1;
        this._animationSequence[0][2] = 2;
        this._animationSequence[0][3] = 3;
        this._animationSequence[0][4] = 4;
        this._animationSequence[0][5] = 8;
        this._animationSequence[0][6] = 11;
        this._animationSequence[0][7] = -1;
        this._animationSequence[0][8] = -1;
        this._animationSequence[0][9] = -1;
        this._animationSequence[0][10] = -1;
        this._animationSequence[0][11] = -1;
        this._animationSequence[5][0] = 6;
        this._animationSequence[5][1] = 7;
        this._animationSequence[5][2] = 11;
        this._animationSequence[5][3] = 0;
        this._animationSequence[5][4] = -1;
        this._animationSequence[5][5] = -1;
        this._animationSequence[5][6] = -1;
        this._animationSequence[5][7] = -1;
        this._animationSequence[5][8] = -1;
        this._animationSequence[5][9] = -1;
        this._animationSequence[5][10] = -1;
        this._animationSequence[5][11] = -1;
        this._animationSequence[1][0] = 6;
        this._animationSequence[1][1] = 8;
        this._animationSequence[1][2] = 9;
        this._animationSequence[1][3] = -1;
        this._animationSequence[1][4] = -1;
        this._animationSequence[1][5] = -1;
        this._animationSequence[1][6] = -1;
        this._animationSequence[1][7] = -1;
        this._animationSequence[1][8] = -1;
        this._animationSequence[1][9] = -1;
        this._animationSequence[1][10] = -1;
        this._animationSequence[1][11] = -1;
        this._animationSequence[4][0] = 6;
        this._animationSequence[4][1] = 7;
        this._animationSequence[4][2] = 8;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
        this._animationSequence[4][6] = -1;
        this._animationSequence[4][7] = -1;
        this._animationSequence[4][8] = -1;
        this._animationSequence[4][9] = -1;
        this._animationSequence[4][10] = -1;
        this._animationSequence[4][11] = -1;
        this._animationSequence[2][0] = 8;
        this._animationSequence[2][1] = -1;
        this._animationSequence[2][2] = -1;
        this._animationSequence[2][3] = -1;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[2][6] = -1;
        this._animationSequence[2][7] = -1;
        this._animationSequence[2][8] = -1;
        this._animationSequence[2][9] = -1;
        this._animationSequence[2][10] = -1;
        this._animationSequence[2][11] = -1;
        this._animationSequence[6][0] = 8;
        this._animationSequence[6][1] = -1;
        this._animationSequence[6][2] = -1;
        this._animationSequence[6][3] = -1;
        this._animationSequence[6][4] = -1;
        this._animationSequence[6][5] = -1;
        this._animationSequence[6][6] = -1;
        this._animationSequence[6][7] = -1;
        this._animationSequence[6][8] = -1;
        this._animationSequence[6][9] = -1;
        this._animationSequence[6][10] = -1;
        this._animationSequence[6][11] = -1;
        this._animationSequence[7][0] = 8;
        this._animationSequence[7][1] = -1;
        this._animationSequence[7][2] = -1;
        this._animationSequence[7][3] = -1;
        this._animationSequence[7][4] = -1;
        this._animationSequence[7][5] = -1;
        this._animationSequence[7][6] = -1;
        this._animationSequence[7][7] = -1;
        this._animationSequence[7][8] = -1;
        this._animationSequence[7][9] = -1;
        this._animationSequence[7][10] = -1;
        this._animationSequence[7][11] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectTopBig, _WIDTH, _HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this.rectItems[0], _WIDTH, _HEIGHT);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this.rectItems[1], _WIDTH, _HEIGHT);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this.rectItems[3], _WIDTH, _HEIGHT);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this.rectItems[2], _WIDTH, _HEIGHT);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this.rectPanel, _WIDTH, _HEIGHT);
        this._animationComponents[5].startShowAnimation(2);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, this.rectText, _WIDTH, _HEIGHT);
        this._animationComponents[6].startShowAnimation(3);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this.rectItems[7], _WIDTH, _HEIGHT);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this.rectItems[8], _WIDTH, _HEIGHT);
        this._animationComponents[8].startShowAnimation(0);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this._rectDialog, _WIDTH, _HEIGHT);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this._rectAboutDialog, _WIDTH, _HEIGHT);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this.rectItems[10], _WIDTH, _HEIGHT);
        this._animationComponents[11].startShowAnimation(3);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(3);
        this._animationComponents[2].startShowAnimation(0);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(3);
        this._animationComponents[5].startShowAnimation(2);
        this._animationComponents[6].startShowAnimation(3);
        this._animationComponents[7].startShowAnimation(0);
        this._animationComponents[8].startShowAnimation(1);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11].startShowAnimation(3);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(3);
        this._animationComponents[2].startHideAnimation(0);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(3);
        this._animationComponents[5].startHideAnimation(2);
        this._animationComponents[6].startHideAnimation(3);
        this._animationComponents[7].startHideAnimation(0);
        this._animationComponents[8].startHideAnimation(1);
        this._animationComponents[9].startHideAnimation(3);
        this._animationComponents[10].startHideAnimation(2);
        this._animationComponents[11].startHideAnimation(3);
    }

    private void freeGraphics() {
        Resources.freeImages(this._arrImages);
        Resources.freeSprites(this._arrSprites);
        Resources.freeGFonts(this._arrFonts);
        this._ptMnuItem = null;
        this._ptVersionOfGame = null;
        this._ptInstruction = null;
        this._ptNavigationKeysBB = null;
        this._ptDifficulty = null;
        this._ptTitle = null;
    }

    public void prepareTxt() {
        String controls = "";
        this.textOffsetY = 0;
        this.scrollUP = false;
        this.scrollDOWN = true;
        controls = Resources.resTexts[0].getHashedString(16);
        controls = Resources.resTexts[0].getHashedString(17);
        this._ptVersionOfGame.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectPanel.width);
        this._ptInstruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls + "\n\n", this.rectText.width);
        this._ptInstruction.setLineHeightCorrection(-2);
        this._ptShop.prepareText(Resources.resTexts[0].getHashedString(93), _WIDTH - (this._sprBtnShop.getWidth() >> 1) - this._sprBtnShop.getWidth());
    }

    private void initMode() {
        if (this._iMode >= 3) {
            this._iMode = 0;
        }
        this._imgMenuLogo = Resources.resImgs[2];
        this._iColorBg = 15691352;
    }

    private void changeGraphicsForMode() {
        ++this._iMode;
        if (this._iMode >= 3) {
            this._iMode = 0;
        }
        this._imgMenuLogo = Resources.resImgs[2];
        this._iColorBg = 15691352;
    }

    public void beforeInteruption() {
        this.check = MainCanvas.soundManager.IsSoundOn();
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
    }

    private void calculatePositions() {
        int itemHeight = Resources.resGFonts[2].getHeight();
        int rectTextOffsetX = this._sprBtnMenu.getWidth() >> 1;
        int rectTextOffsetY = this._sprBtnMenu.getHeight() >> 1;
        int spaces = _HEIGHT - (this._imgMenuLogo.getHeight() >> 2) - this._imgMenuLogo.getHeight() - this._sprBtnPlay.getHeight() - this._sprGameMode.getHeight() - this._sprBtnMenuMain.getHeight() >> 2;
        this._rectTopBig = new Rectangle(_WIDTH >> 1, this._imgMenuLogo.getHeight() >> 2, this._imgMenuLogo.getWidth(), this._imgMenuLogo.getHeight());
        this.rectPanel = new Rectangle(0, itemHeight, _WIDTH, _HEIGHT - (itemHeight << 1));
        this._rectTopBar = new Rectangle(MainCanvas.WIDTH - this._sprTopPanel.getWidth() >> 1, 0, this._sprTopPanel.getWidth(), this._sprTopPanel.getHeight());
        this.rectText = new Rectangle(this._sprBtnMenu.getWidth() >> 1, this._rectTopBar.height + this._sprArrowsActive.getHeight() + (this._sprArrowsActive.getHeight() >> 1), _WIDTH - this._sprBtnMenu.getWidth(), _HEIGHT - this._rectTopBar.height - this._imgBottomPanel.getHeight() - this._sprArrowsActive.getHeight() - (this._sprArrowsActive.getHeight() >> 1));
        this.rectItems[7] = this.rectLeftFk = new Rectangle(0, _HEIGHT - (this._sprBtnMenu.getHeight() << 1), this._sprBtnMenu.getWidth() << 1, this._sprBtnMenu.getHeight() << 1);
        this.rectItems[8] = this.rectRightFk = new Rectangle(MainCanvas.WIDTH - (this._sprBtnMenu.getWidth() << 1), _HEIGHT - (this._sprBtnMenu.getHeight() << 1), this._sprBtnMenu.getWidth() << 1, this._sprBtnMenu.getHeight() << 1);
        this.posX = (_WIDTH >> 1) - (this._sprBtnPlay.getWidth() >> 1);
        this.rectItems[0] = new Rectangle((_WIDTH >> 1) - (this._sprBtnPlay.getWidth() >> 1), this._rectTopBig.y + this._imgMenuLogo.getHeight() + spaces, this._sprBtnPlay.getWidth(), this._sprBtnPlay.getHeight());
        double temp = MainCanvas.WIDTH / 3 * 2 / this._sprBtnModesCompleted.getWidth() + 1;
        int menuModesX = (int)temp * this._sprBtnModesCompleted.getWidth();
        this.rectItems[10] = new Rectangle((_WIDTH >> 1) - (menuModesX >> 1), this.rectItems[0].y + this._sprBtnPlay.getHeight() + spaces, menuModesX, this._sprBtnModesCompleted.getHeight());
        int pY = this.rectItems[10].y + this.rectItems[10].height + spaces;
        int pX = (_WIDTH >> 1) - (this._sprBtnMenuMain.getWidth() >> 1);
        int pXoffset = this._sprBtnMenuMain.getWidth() + (this._sprBtnMenuMain.getWidth() >> 1);
        this.rectItems[2] = new Rectangle(pX, pY, this._sprBtnMenuMain.getWidth(), this._sprBtnMenuMain.getHeight());
        this.rectItems[1] = new Rectangle(pX - pXoffset, pY, this._sprBtnMenuMain.getWidth(), this._sprBtnMenuMain.getHeight());
        this.rectItems[3] = new Rectangle(pX + pXoffset, pY, this._sprBtnMenuMain.getWidth(), this._sprBtnMenuMain.getHeight());
        int _windowWidth = _WIDTH >> 1;
        int _offsetX = _windowWidth % this._sprBtnMenu.getWidth() > 0 ? _windowWidth % this._sprBtnMenu.getWidth() : this._sprBtnMenu.getWidth();
        int _offsetTopY = (this._sprBtnMenu.getHeight() - this._sprBtnMenu.getHeight() << 1) + this._sprBtnMenu.getHeight();
        int _offsetBottomY = this._sprBtnMenu.getHeight() + (this._sprBtnMenu.getHeight() - this._sprBtnMenu.getHeight());
        int _panelHeight = _HEIGHT - _offsetTopY - _offsetBottomY;
        this._iOffsetX = _offsetX;
        this._iFinalHeight = _panelHeight % this._sprBtnMenu.getWidth() == 0 ? _panelHeight : _panelHeight - _panelHeight % this._sprBtnMenu.getWidth();
        this._rectDialog = new Rectangle(_offsetX, _offsetTopY, _WIDTH - (_offsetX << 1), this._iFinalHeight);
        this._rectAboutDialog = new Rectangle(_offsetX, _offsetTopY, _WIDTH - (_offsetX << 1), this._iFinalHeight);
        int area = _HEIGHT - this._sprTopPanel.getHeight() - this.rectItems[8].height;
        int offSetY = area - 3 * this._sprGameMode.getHeight() >> 2;
        for (int i = 0; i < 3; ++i) {
            this._rectGameModes[i] = new Rectangle(0, offSetY + this._sprTopPanel.getHeight() + (offSetY + this._sprGameMode.getHeight()) * i, _WIDTH, this._sprGameMode.getHeight());
        }
        this.calculateWindowTiles();
    }

    private void calculateWindowTiles() {
    }

    public void update(long lastRunLenght) {
        this.musicInteruptUpdate();
        this.animationController();
        this.animationComponentsUpdate();
        if (this.actualScreen == 1) {
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
        if (this.actualScreen == 2) {
            this.updateShopSelect(4);
        }
        if (this.actualScreen == 6) {
            this.updateLevelSelect(4);
        }
        if (this.obs2 != null) {
            this.obs2.Update(lastRunLenght, this.character);
        }
        if (this.character != null) {
            this.character.Update(lastRunLenght);
        }
        if (this._iAngle < 0) {
            this._iAngle = 360;
            this.mainCanvas.repaint();
        } else {
            this._iAngle -= 3;
            this.mainCanvas.repaint();
        }
    }

    private boolean animationController() {
        if (this.changeSequence) {
            if (this._sequence == this._sequenceShow) {
                this.showAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceHide) {
                this.hideAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceStop) {
                this.changeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this.actualScreen].length; ++i) {
            if (this._animationSequence[this.actualScreen][i] == -1 || this._animationComponents[this._animationSequence[this.actualScreen][i]] == null || this._animationComponents[this._animationSequence[this.actualScreen][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this.actualScreen][i]].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._sequence == this._sequenceHide) {
                if (this.nextScreen == 3) {
                    this.startGameScreen();
                }
                this._sequence = this._sequenceShow;
                this.actualScreen = this.nextScreen;
                this.changeSequence = true;
            } else if (this._sequence == this._sequenceShow) {
                this._sequence = this._sequenceStop;
                this.actualScreen = this.nextScreen;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextScreen) {
        this.changeSequence = changeSequencem;
        this.nextScreen = nextScreen;
        this._sequence = this._sequenceHide;
        if (nextScreen == 3 && MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Stop();
            MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
        }
    }

    private void startGameScreen() {
        ScreenGame sg = new ScreenGame(this.mainCanvas, this._iSelectedLevel + 1, this._iMainCharacter);
        this.mainCanvas.changeLastActiveScreen(sg);
        if (MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
        }
    }

    private void musicInteruptUpdate() {
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this.actualScreen) {
            case 0: {
                this.paintGameLogo(g);
                this.paintMainMenuDialogItems(g);
                break;
            }
            case 1: {
                this.paintInstructionTxt(g);
                this.paintShopArrows(g);
                break;
            }
            case 2: {
                this.paintShop(g);
                break;
            }
            case 4: {
                this.paintQuit(g);
                break;
            }
            case 6: {
                this.paintLevels(g);
                break;
            }
            case 7: {
                this.paintGameModes(g);
            }
        }
        this.paintFK(g);
    }

    private void paintCircle(Graphics g) {
        if (this.obs2 == null) {
            this.obs2 = new Obstacle(2, 0);
        }
        if (this.obs == null) {
            this.obs = new Obstacle(1, 0);
        }
        if (this.character == null) {
            this.character = new Character(0);
        }
        this.obs2.Paint(g);
        this.character.Paint(g);
    }

    private int getStartAngle(int _iPos) {
        int _iRetVal = 0;
        if (_iPos == 0) {
            _iRetVal = this._iAngle;
        } else if (_iPos == 1) {
            _iRetVal = this._iAngle + 90 < 360 ? this._iAngle + 90 : this._iAngle + 90 - 360;
        } else if (_iPos == 2) {
            _iRetVal = this._iAngle + 180 < 360 ? this._iAngle + 180 : this._iAngle + 180 - 360;
        } else if (_iPos == 3) {
            _iRetVal = this._iAngle + 270 < 360 ? this._iAngle + 270 : this._iAngle + 270 - 360;
        }
        return _iRetVal;
    }

    private int getEndAngle(int _iPos) {
        int _iRetVal = 0;
        if (_iPos == 0) {
            _iRetVal = this._iAngle + 90;
        } else if (_iPos == 1) {
            _iRetVal = this._iAngle + 180 > 360 ? 360 - (this._iAngle + 180) : this._iAngle + 180;
        } else if (_iPos == 2) {
            _iRetVal = this._iAngle + 270 > 360 ? 360 - (this._iAngle + 270) : this._iAngle + 270;
        } else if (_iPos == 3) {
            _iRetVal = this._iAngle + 360 > 360 ? 360 - (this._iAngle + 360) : this._iAngle + 360;
        }
        return _iRetVal;
    }

    public void paintBackground(Graphics g) {
        g.setColor(0x220024);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
    }

    public void paintGameLogo(Graphics g) {
        g.drawImage(this._imgMenuLogo, this._rectTopBig.x, this._rectTopBig.getCenterY(), 3);
    }

    private void paintInstructionTxt(Graphics g) {
        this.paintTopBar(g);
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(22), this.rectText.width);
        this._ptTitle.drawText(g, this._rectTopBar, 0, 3);
        g.setClip(this.rectText.x, this.rectText.y, this.rectText.width, this.rectText.height);
        this._ptInstruction.drawText(g, this.rectText, this.textOffsetY, 1);
        g.drawImage(this._imgInlogicLogoAbout, _WIDTH - this._imgInlogicLogoAbout.getWidth() >> 1, this.rectText.y - (this._imgInlogicLogoAbout.getHeight() >> 1) + this._ptInstruction.getTextHeight() - this.textOffsetY, 20);
        this._ptVersionOfGame.drawText(g, this.rectText, this.textOffsetY - this._ptInstruction.getTextHeight() - this._imgInlogicLogoAbout.getHeight(), 1);
        g.setClip(0, 0, _WIDTH, _HEIGHT);
        g.drawImage(this._imgBottomPanel, 0, _HEIGHT - this._imgBottomPanel.getHeight(), 20);
        g.drawImage(this._imgColorLine, MainCanvas.WIDTH >> 1, _HEIGHT - this._imgBottomPanel.getHeight(), 17);
    }

    private void paintLevels(Graphics g) {
        this.paintTopBar(g);
        GFont fontS1 = Resources.resGFonts[0];
        String s1 = Resources.resTexts[0].getHashedString(90);
        switch (ScreenMenu.getSelectedMode()) {
            case 0: {
                s1 = Resources.resTexts[0].getHashedString(90);
                break;
            }
            case 1: {
                s1 = Resources.resTexts[0].getHashedString(91);
                break;
            }
            case 2: {
                s1 = Resources.resTexts[0].getHashedString(92);
                break;
            }
        }
        GFont fontS2 = Resources.resGFonts[1];
        String s2 = this.levels + " \\ " + this._rectLevels.length;
        int textWidth = fontS1.stringWidth(s1.toCharArray());
        fontS1.drawString(g, s1.toCharArray(), MainCanvas.WIDTH - textWidth >> 1, this._sprTopPanel.getHeight() / 4, 20);
        fontS2.drawString(g, s2.toCharArray(), MainCanvas.WIDTH - textWidth >> 1, this._sprTopPanel.getHeight() / 4 + fontS1.getHeight(), 20);
        int clipOffY = 0;
        int _iTmpPos = 0;
        int _iLevelOffsetX = this._sprBtnLevel.getWidth() >> 3;
        int _iLevelOffsetY = this._sprBtnLevel.getHeight() >> 3;
        int _iOffsetLeft = _WIDTH - this._sprBtnLevel.getWidth() * 4 - _iLevelOffsetX * 3 >> 1;
        int _iOffsetUp = this._sprTopPanel.getHeight() + this._sprArrowsActive.getHeight() + (this._sprArrowsActive.getHeight() >> 1);
        for (int _iIdy = 0; _iIdy < 25; ++_iIdy) {
            for (int _iIdx = 0; _iIdx < 4; ++_iIdx) {
                if (_iTmpPos >= 100) continue;
                int _iX = _iOffsetLeft + _iIdx * _iLevelOffsetX + _iIdx * this._sprBtnLevel.getWidth();
                int _iY = _iOffsetUp + _iIdy * _iLevelOffsetY + _iIdy * this._sprBtnLevel.getHeight() - this.iShiftY;
                this._rectLevels[_iTmpPos] = new Rectangle(_iX, _iY, this._sprBtnLevel.getWidth(), this._sprBtnLevel.getHeight());
                ++_iTmpPos;
            }
        }
        _iTmpPos = 0;
        g.setClip(0, this._sprTopPanel.getHeight() + this._sprArrowsActive.getHeight() + (this._sprArrowsActive.getHeight() >> 1), _WIDTH, _HEIGHT - this._sprTopPanel.getHeight() - this._sprArrowsActive.getHeight() - (this._sprArrowsActive.getHeight() >> 1) - this._imgBottomPanel.getHeight() - clipOffY);
        for (int i = 0; i < 100; ++i) {
            int p;
            int k;
            int numberY;
            int numberX;
            char[] digits;
            String cost;
            if (this.allLevels[i] == null) {
                if (i == 0) {
                    this._sprBtnLevel.setFrame(0);
                    this._sprBtnLevel.setPosition(this._rectLevels[i].x, this._rectLevels[i].y);
                    this._sprBtnLevel.paint(g);
                    cost = String.valueOf(i + 1);
                    digits = cost.toCharArray();
                    numberX = this._rectLevels[i].x + (this._sprBtnLevel.getWidth() - digits.length * this._sprNumbersSmall.getWidth() >> 1);
                    numberY = this._rectLevels[i].y + (this._sprBtnLevel.getHeight() - this._sprNumbersSmall.getHeight() >> 1);
                    for (k = 0; k < digits.length; ++k) {
                        p = java.lang.Character.digit(digits[k], 10);
                        p = p == 0 ? 9 : --p;
                        this._sprNumbersSmall.setFrame(p);
                        this._sprNumbersSmall.setPosition(numberX + k * this._sprNumbersSmall.getWidth(), numberY);
                        this._sprNumbersSmall.paint(g);
                    }
                    continue;
                }
                this._sprBtnLevel.setFrame(2);
                this._sprBtnLevel.setPosition(this._rectLevels[i].x, this._rectLevels[i].y);
                this._sprBtnLevel.paint(g);
                continue;
            }
            if (i == this.lastOpened) {
                this._sprBtnLevel.setFrame(0);
            } else {
                this._sprBtnLevel.setFrame(1);
            }
            this._sprBtnLevel.setPosition(this._rectLevels[i].x, this._rectLevels[i].y);
            this._sprBtnLevel.paint(g);
            cost = String.valueOf(i + 1);
            digits = cost.toCharArray();
            numberX = this._rectLevels[i].x + (this._sprBtnLevel.getWidth() - digits.length * this._sprNumbersSmall.getWidth() >> 1);
            numberY = this._rectLevels[i].y + (this._sprBtnLevel.getHeight() - this._sprNumbersSmall.getHeight() >> 1);
            for (k = 0; k < digits.length; ++k) {
                p = java.lang.Character.digit(digits[k], 10);
                p = p == 0 ? 9 : --p;
                this._sprNumbersSmall.setFrame(p);
                this._sprNumbersSmall.setPosition(numberX + k * this._sprNumbersSmall.getWidth(), numberY);
                this._sprNumbersSmall.paint(g);
            }
        }
        g.setClip(0, 0, _WIDTH, _HEIGHT);
        g.drawImage(this._imgColorLine, MainCanvas.WIDTH >> 1, _HEIGHT - this._imgBottomPanel.getHeight(), 17);
        this.paintShopArrows(g);
    }

    private void paintShop(Graphics g) {
        this.paintTopBar(g);
        int chars = 0;
        for (int i = 0; i < this.characters.length; ++i) {
            if (this.characters[i].equals("0")) continue;
            ++chars;
        }
        String scoreShop = String.valueOf(this._iScore);
        char[] scoreDigits = scoreShop.toCharArray();
        GFont fontS1 = Resources.resGFonts[0];
        String s1 = Resources.resTexts[0].getHashedString(80);
        GFont fontS2 = Resources.resGFonts[1];
        String s2 = "TOTAL: " + chars + " \\ " + this.characters.length;
        int shopTextWidth = this._imgStarBlue.getWidth() + fontS2.stringWidth(s2.toCharArray()) + this._sprNumbers.getWidth() * scoreDigits.length;
        fontS1.drawString(g, s1.toCharArray(), this._sprTopPanel.getWidth() - shopTextWidth >> 1, this._sprTopPanel.getHeight() / 4, 20);
        fontS2.drawString(g, s2.toCharArray(), this._sprTopPanel.getWidth() - shopTextWidth >> 1, this._sprTopPanel.getHeight() / 4 + fontS1.getHeight(), 20);
        g.drawImage(this._imgStarBlue, (this._sprTopPanel.getWidth() - shopTextWidth + this._imgStarBlue.getWidth() >> 1) + fontS2.stringWidth(s2.toCharArray()), this._sprTopPanel.getHeight() / 4 + (fontS1.getHeight() + fontS2.getHeight() - this._imgStarBlue.getHeight() >> 1), 20);
        int scoreX = (this._sprTopPanel.getWidth() - shopTextWidth + this._imgStarBlue.getWidth() >> 1) + fontS2.stringWidth(s2.toCharArray()) + this._imgStarBlue.getWidth();
        int scoreY = this._sprTopPanel.getHeight() / 4 + (fontS1.getHeight() + fontS2.getHeight() - this._sprNumbers.getHeight() >> 1);
        for (int k = 0; k < scoreDigits.length; ++k) {
            int p = java.lang.Character.digit(scoreDigits[k], 10);
            p = p == 0 ? 9 : --p;
            this._sprNumbers.setFrame(p);
            this._sprNumbers.setPosition(scoreX + k * this._sprNumbers.getWidth(), scoreY);
            this._sprNumbers.paint(g);
        }
        this.paintCharacters(g);
        g.drawImage(this._imgColorLine, MainCanvas.WIDTH >> 1, _HEIGHT - this._imgBottomPanel.getHeight(), 17);
        this.paintShopArrows(g);
        if (this.notEnoughScore) {
            this.paintTable(g, this._sprTable, _WIDTH >> 1, _HEIGHT >> 1, _WIDTH - this._sprBtnShop.getWidth(), (this._imgStarOrange.getHeight() << 1) + this._ptShop.getTextHeight());
            ++this.notEnoughScoreCounter;
            g.drawImage(this._imgStarOrange, _WIDTH - this._imgStarOrange.getWidth() >> 1, (_HEIGHT >> 1) - this._imgStarOrange.getHeight(), 20);
            Rectangle rectShop = new Rectangle(this._sprBtnShop.getWidth() >> 1, _HEIGHT >> 1, _WIDTH - this._sprBtnShop.getWidth(), this._ptShop.getTextHeight());
            this._ptShop.drawText(g, rectShop, 0, 1);
            if (this.notEnoughScoreCounter == 100) {
                this.notEnoughScore = false;
                this.notEnoughScoreCounter = 0;
            }
        }
    }

    private void paintCharacters(Graphics g) {
        int clipOffY = 0;
        int _iTmpPos = 0;
        int _iShopOffsetX = this._sprBtnShop.getHeight() >> 3;
        int _iShopOffsetY = this._sprBtnShop.getHeight() >> 3;
        int _iOffsetLeft = _WIDTH - this._sprBtnShop.getWidth() * 3 - _iShopOffsetX * 2 >> 1;
        int _iOffsetUp = this._sprTopPanel.getHeight() + this._sprArrowsActive.getHeight() + (this._sprArrowsActive.getHeight() >> 1);
        for (int _iIdy = 0; _iIdy < 17; ++_iIdy) {
            for (int _iIdx = 0; _iIdx < 3; ++_iIdx) {
                if (_iTmpPos >= 50) continue;
                int _iX = _iOffsetLeft + _iIdx * _iShopOffsetX + _iIdx * this._sprBtnShop.getWidth();
                int _iY = _iOffsetUp + _iIdy * _iShopOffsetY + _iIdy * this._sprBtnShop.getHeight() - this.iShiftY;
                this._rectCharacters[_iTmpPos] = new Rectangle(_iX, _iY, this._sprBtnShop.getWidth(), this._sprBtnShop.getHeight());
                ++_iTmpPos;
            }
        }
        g.setClip(0, this._sprTopPanel.getHeight() + this._sprArrowsActive.getHeight() + (this._sprArrowsActive.getHeight() >> 1), _WIDTH, _HEIGHT - this._sprTopPanel.getHeight() - this._sprArrowsActive.getHeight() - (this._sprArrowsActive.getHeight() >> 1) - this._imgBottomPanel.getHeight() - clipOffY);
        _iTmpPos = 0;
        int frame = 0;
        for (int i = 0; i < 50; ++i) {
            if (this.characters[_iTmpPos].equals("0")) {
                if (_iTmpPos == 0) {
                    if (this._iSelectedCharacter == _iTmpPos) {
                        this._sprBtnShop.setFrame(1);
                    } else {
                        this._sprBtnShop.setFrame(0);
                    }
                    this._sprBtnShop.setPosition(this._rectCharacters[_iTmpPos].x + (this._sprBtnShop.getWidth() - this._sprBtnShop.getWidth() >> 1), this._rectCharacters[_iTmpPos].y + (this._sprBtnShop.getHeight() - this._sprBtnShop.getHeight() >> 1));
                    this._sprBtnShop.paint(g);
                    this.paintCharacter(g, _iTmpPos, frame);
                } else {
                    this._sprBtnShop.setFrame(2);
                    this._sprBtnShop.setPosition(this._rectCharacters[_iTmpPos].x + (this._sprBtnShop.getWidth() - this._sprBtnShop.getWidth() >> 1), this._rectCharacters[_iTmpPos].y + (this._sprBtnShop.getHeight() - this._sprBtnShop.getHeight() >> 1));
                    this._sprBtnShop.paint(g);
                    String cost = String.valueOf(20 * _iTmpPos);
                    char[] digits = cost.toCharArray();
                    int lockedX = this._rectCharacters[_iTmpPos].x + (this._sprBtnShop.getWidth() - this._imgStarLock.getWidth() - digits.length * this._sprNumbersGrey.getWidth() >> 1);
                    int lockedY = this._rectCharacters[_iTmpPos].y + (this._sprBtnShop.getHeight() - this._sprNumbersGrey.getHeight() >> 1);
                    g.drawImage(this._imgStarLock, lockedX, lockedY, 20);
                    for (int k = 0; k < digits.length; ++k) {
                        int p = java.lang.Character.digit(digits[k], 10);
                        p = p == 0 ? 9 : --p;
                        this._sprNumbersGrey.setFrame(p);
                        this._sprNumbersGrey.setPosition(lockedX + this._imgStarLock.getWidth() + k * this._sprNumbersGrey.getWidth(), lockedY);
                        this._sprNumbersGrey.paint(g);
                    }
                }
            } else {
                if (this._iSelectedCharacter == _iTmpPos) {
                    this._sprBtnShop.setFrame(1);
                } else {
                    this._sprBtnShop.setFrame(0);
                }
                this._sprBtnShop.setPosition(this._rectCharacters[_iTmpPos].x + (this._sprBtnShop.getWidth() - this._sprBtnShop.getWidth() >> 1), this._rectCharacters[_iTmpPos].y + (this._sprBtnShop.getHeight() - this._sprBtnShop.getHeight() >> 1));
                this._sprBtnShop.paint(g);
                this.paintCharacter(g, _iTmpPos, frame);
            }
            ++_iTmpPos;
            ++frame;
        }
        g.setClip(0, 0, _WIDTH, _HEIGHT);
    }

    private void paintCharacter(Graphics g, int _iPosition, int frame) {
        this._sprPlayer1.setFrame(frame);
        this._sprPlayer1.setPosition(this._rectCharacters[_iPosition].x + (this._sprBtnShop.getWidth() - this._sprPlayer1.getWidth() >> 1), this._rectCharacters[_iPosition].y + (this._sprBtnShop.getHeight() - this._sprPlayer1.getHeight() >> 1));
        this._sprPlayer1.paint(g);
    }

    private void paintArrows(Graphics g) {
        if (this.scrollDOWN && this.scrollUP) {
            this._sprArrowsActive.setFrame(0);
            this._sprArrowsActive.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y - this._sprArrowsActive.getHeight() - (this._sprArrowsActive.getHeight() >> 1));
            this._sprArrowsActive.paint(g);
            this._sprArrowsActive.setFrame(1);
            this._sprArrowsActive.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y + this.rectText.height + (this._sprArrowsActive.getHeight() >> 1));
            this._sprArrowsActive.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._sprArrowsActive.setFrame(0);
            this._sprArrowsActive.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y - this._sprArrowsActive.getHeight() - (this._sprArrowsActive.getHeight() >> 1));
            this._sprArrowsActive.paint(g);
            this._sprArrowsInactive.setFrame(1);
            this._sprArrowsInactive.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y + this.rectText.height + (this._sprArrowsInactive.getHeight() >> 1));
            this._sprArrowsInactive.paint(g);
        }
        if (this.scrollDOWN && !this.scrollUP) {
            this._sprArrowsInactive.setFrame(0);
            this._sprArrowsInactive.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y - this._sprArrowsInactive.getHeight() - (this._sprArrowsInactive.getHeight() >> 1));
            this._sprArrowsInactive.paint(g);
            this._sprArrowsActive.setFrame(1);
            this._sprArrowsActive.setPosition(this.rectText.x + this.rectText.width >> 1, this.rectText.y + this.rectText.height + (this._sprArrowsActive.getHeight() >> 1));
            this._sprArrowsActive.paint(g);
        }
    }

    private void paintShopArrows(Graphics g) {
        if (this.scrollDOWN && this.scrollUP) {
            this._sprArrowsActive.setFrame(0);
            this._sprArrowsActive.setPosition(_WIDTH - this._sprArrowsActive.getWidth() >> 1, this._sprTopPanel.getHeight());
            this._sprArrowsActive.paint(g);
            this._sprArrowsActive.setFrame(1);
            this._sprArrowsActive.setPosition(_WIDTH - this._sprArrowsActive.getWidth() >> 1, _HEIGHT - (this._imgBottomPanel.getHeight() >> 1) - (this._sprArrowsActive.getHeight() >> 1));
            this._sprArrowsActive.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            this._sprArrowsActive.setFrame(0);
            this._sprArrowsActive.setPosition(_WIDTH - this._sprArrowsActive.getWidth() >> 1, this._sprTopPanel.getHeight());
            this._sprArrowsActive.paint(g);
            this._sprArrowsInactive.setFrame(1);
            this._sprArrowsInactive.setPosition(_WIDTH - this._sprArrowsInactive.getWidth() >> 1, _HEIGHT - (this._imgBottomPanel.getHeight() >> 1) - (this._sprArrowsInactive.getHeight() >> 1));
            this._sprArrowsInactive.paint(g);
        }
        if (this.scrollDOWN && !this.scrollUP) {
            this._sprArrowsInactive.setFrame(0);
            this._sprArrowsInactive.setPosition(_WIDTH - this._sprArrowsInactive.getWidth() >> 1, this._sprTopPanel.getHeight());
            this._sprArrowsInactive.paint(g);
            this._sprArrowsActive.setFrame(1);
            this._sprArrowsActive.setPosition(_WIDTH - this._sprArrowsActive.getWidth() >> 1, _HEIGHT - (this._imgBottomPanel.getHeight() >> 1) - (this._sprArrowsActive.getHeight() >> 1));
            this._sprArrowsActive.paint(g);
        }
    }

    private void paintAboutLogo(Graphics g) {
        g.drawImage(this._imgInlogicLogoAbout, this.rectPanel.getCenterX(), this.rectPanel.getCenterY(), 3);
        this._ptVersionOfGame.prepareText(X.singleton.getAppProperty("MIDlet-Name").toUpperCase() + ", " + X.singleton.getAppProperty("MIDlet-Version"), this.rectPanel.width);
        this._ptVersionOfGame.drawText(g, this.rectPanel, 0, 33);
    }

    private void paintQuit(Graphics g) {
        this._ptQuit.prepareText(Resources.resTexts[0].getHashedString(2), _WIDTH);
        Rectangle r = new Rectangle(0, 0, _WIDTH, _HEIGHT);
        this._ptQuit.drawText(g, r, 0, 3);
    }

    private void paintFK(Graphics g) {
        if (this.actualScreen == 4) {
            this._sprBtnMenu.setFrame(1);
            this._sprBtnMenu.setPosition(this.rectItems[8].x + (this._sprBtnMenu.getWidth() >> 1) + (this._sprBtnMenu.getWidth() >> 2), this.rectItems[8].y + (this._sprBtnMenu.getHeight() >> 1) + (this._sprBtnMenu.getWidth() >> 2));
            this._sprBtnMenu.paint(g);
            this._sprBtnMenu.setFrame(0);
            this._sprBtnMenu.setPosition(this.rectItems[7].x + (this._sprBtnMenu.getWidth() >> 2), this.rectItems[7].y + (this._sprBtnMenu.getHeight() >> 1) + (this._sprBtnMenu.getWidth() >> 2));
            this._sprBtnMenu.paint(g);
        } else if (this.actualScreen == 0) {
            this._sprBtnMenu.setFrame(2);
            this._sprBtnMenu.setPosition(this.rectItems[8].x + (this._sprBtnMenu.getWidth() >> 1) + (this._sprBtnMenu.getWidth() >> 2), this.rectItems[8].y + (this._sprBtnMenu.getHeight() >> 1) + (this._sprBtnMenu.getWidth() >> 2));
            this._sprBtnMenu.paint(g);
        } else if (this.actualScreen != 0) {
            this._sprBtnMenu.setFrame(3);
            this._sprBtnMenu.setPosition(this.rectItems[8].x + (this._sprBtnMenu.getWidth() >> 1) + (this._sprBtnMenu.getWidth() >> 2), this.rectItems[8].y + (this._sprBtnMenu.getHeight() >> 1) + (this._sprBtnMenu.getWidth() >> 2));
            this._sprBtnMenu.paint(g);
        }
    }

    private void paintMainMenuDialogItems(Graphics g) {
        if (this.selectedCompId == 2) {
            if (MainCanvas.soundManager.IsSoundOn()) {
                this.paintGraphicsButton(g, this.selectedCompId, this._sprBtnMenuMain, true, 1);
            } else {
                this.paintGraphicsButton(g, this.selectedCompId, this._sprBtnMenuMain, true, 0);
            }
        } else if (MainCanvas.soundManager.IsSoundOn()) {
            this.paintGraphicsButton(g, 2, this._sprBtnMenuMain, false, 1);
        } else {
            this.paintGraphicsButton(g, 2, this._sprBtnMenuMain, false, 0);
        }
        if (this.selectedCompId == 1) {
            this.paintGraphicsButton(g, this.selectedCompId, this._sprBtnMenuMain, true, 3);
        } else {
            this.paintGraphicsButton(g, 1, this._sprBtnMenuMain, false, 3);
        }
        if (this.selectedCompId == 3) {
            this.paintGraphicsButton(g, this.selectedCompId, this._sprBtnMenuMain, true, 2);
        } else {
            this.paintGraphicsButton(g, 3, this._sprBtnMenuMain, false, 2);
        }
        if (this.selectedCompId == 0) {
            this.paintGraphicsButton(g, this.selectedCompId, this._sprBtnPlay, true, 0);
        } else {
            this.paintGraphicsButton(g, 0, this._sprBtnPlay, false, 0);
        }
        if (this.selectedCompId == 10) {
            this.paintGraphicsButton(g, this.selectedCompId, this._sprBtnModesCompleted, true, 0);
        } else {
            this.paintGraphicsButton(g, 10, this._sprBtnModesCompleted, false, 0);
        }
    }

    private void paintGraphicsButton(Graphics g, int _type, Sprite _sprite, boolean active, int frame) {
        if (active) {
            if (_type == 0) {
                _sprite.setFrame(frame);
                _sprite.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
                _sprite.paint(g);
            } else if (_type == 10) {
                for (int i = 0; i < this._count_of_game_mode_btn; ++i) {
                    if (i < this._count_of_game_mode_btn - 1) {
                        this._sprBtnModesCompleted.setFrame(1);
                        this._sprBtnModesCompleted.setPosition((_WIDTH >> 1) - this._sprBtnModesCompleted.getWidth() - i * this._sprBtnModesCompleted.getWidth(), this.rectItems[_type].y);
                        this._sprBtnModesCompleted.paint(g);
                        this._sprBtnModesCompleted.setPosition((_WIDTH >> 1) + i * this._sprBtnModesCompleted.getWidth(), this.rectItems[_type].y);
                        this._sprBtnModesCompleted.paint(g);
                        continue;
                    }
                    this._sprBtnModesCompleted.setFrame(0);
                    this._sprBtnModesCompleted.setPosition((_WIDTH >> 1) - this._sprBtnModesCompleted.getWidth() - i * this._sprBtnModesCompleted.getWidth(), this.rectItems[_type].y);
                    this._sprBtnModesCompleted.paint(g);
                    this._sprBtnModesCompleted.setFrame(2);
                    this._sprBtnModesCompleted.setPosition((_WIDTH >> 1) + i * this._sprBtnModesCompleted.getWidth(), this.rectItems[_type].y);
                    this._sprBtnModesCompleted.paint(g);
                }
                this._ptMnuItem.prepareText(Resources.resTexts[0].getHashedString(89), MainCanvas.WIDTH);
                this._ptMnuItem.drawText(g, this.rectItems[_type], 0, 3);
            } else {
                _sprite.setFrame(frame);
                _sprite.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
                _sprite.paint(g);
            }
        } else if (_type == 10) {
            for (int i = 0; i < this._count_of_game_mode_btn; ++i) {
                if (i < this._count_of_game_mode_btn - 1) {
                    this._sprBtnModesCompleted.setFrame(1);
                    this._sprBtnModesCompleted.setPosition((_WIDTH >> 1) - this._sprBtnModesCompleted.getWidth() - i * this._sprBtnModesCompleted.getWidth(), this.rectItems[_type].y);
                    this._sprBtnModesCompleted.paint(g);
                    this._sprBtnModesCompleted.setPosition((_WIDTH >> 1) + i * this._sprBtnModesCompleted.getWidth(), this.rectItems[_type].y);
                    this._sprBtnModesCompleted.paint(g);
                    continue;
                }
                this._sprBtnModesCompleted.setFrame(0);
                this._sprBtnModesCompleted.setPosition((_WIDTH >> 1) - this._sprBtnModesCompleted.getWidth() - i * this._sprBtnModesCompleted.getWidth(), this.rectItems[_type].y);
                this._sprBtnModesCompleted.paint(g);
                this._sprBtnModesCompleted.setFrame(2);
                this._sprBtnModesCompleted.setPosition((_WIDTH >> 1) + i * this._sprBtnModesCompleted.getWidth(), this.rectItems[_type].y);
                this._sprBtnModesCompleted.paint(g);
            }
            this._ptMnuItem.prepareText(Resources.resTexts[0].getHashedString(89), _WIDTH);
            this._ptMnuItem.drawText(g, this.rectItems[_type], 0, 3);
        } else {
            _sprite.setFrame(frame);
            _sprite.setPosition(this.rectItems[_type].x, this.rectItems[_type].y);
            _sprite.paint(g);
        }
    }

    private void paintTopBar(Graphics g) {
        if (this.actualScreen == 2) {
            this._sprTopPanel.setFrame(2);
            this._sprTopPanel.setPosition(this._rectTopBar.x, this._rectTopBar.y);
            this._sprTopPanel.paint(g);
        } else if (this.actualScreen == 7) {
            this._sprTopPanel.setFrame(0);
            this._sprTopPanel.setPosition(this._rectTopBar.x, this._rectTopBar.y);
            this._sprTopPanel.paint(g);
        } else if (this.actualScreen == 1) {
            this._sprTopPanel.setFrame(3);
            this._sprTopPanel.setPosition(this._rectTopBar.x, this._rectTopBar.y);
            this._sprTopPanel.paint(g);
        } else if (this.actualScreen == 6) {
            switch (_topBarGameMode) {
                case 0: {
                    this._sprTopPanel.setFrame(1);
                    break;
                }
                case 1: {
                    this._sprTopPanel.setFrame(2);
                    break;
                }
                case 2: {
                    this._sprTopPanel.setFrame(3);
                    break;
                }
            }
            this._sprTopPanel.setPosition(this._rectTopBar.x, this._rectTopBar.y);
            this._sprTopPanel.paint(g);
        }
    }

    private void paintGameModes(Graphics g) {
        this.paintTopBar(g);
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(89), this.rectText.width);
        this._ptTitle.drawText(g, this._rectTopBar, 0, 3);
        double temp = MainCanvas.WIDTH / this._sprGameMode.getWidth() + 1;
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while ((double)j < temp) {
                this._sprGameMode.setFrame(i);
                this._sprGameMode.setPosition(j * this._sprGameMode.getWidth() - 1, this._rectGameModes[i].y);
                this._sprGameMode.paint(g);
                ++j;
            }
            g.drawImage(this._imgColorLine, MainCanvas.WIDTH >> 1, this._rectGameModes[i].y + (this._imgColorLine.getHeight() << 1), 17);
            g.drawImage(this._imgColorLine, MainCanvas.WIDTH >> 1, this._rectGameModes[i].y + this._sprGameMode.getHeight() - this._imgColorLine.getHeight() * 3, 17);
            String s = "";
            switch (i) {
                case 0: {
                    s = Resources.resTexts[0].getHashedString(90);
                    break;
                }
                case 1: {
                    s = Resources.resTexts[0].getHashedString(91);
                    break;
                }
                case 2: {
                    s = Resources.resTexts[0].getHashedString(92);
                    break;
                }
            }
            this._ptTitle.prepareText(s, MainCanvas.WIDTH);
            this._ptTitle.drawText(g, this._rectGameModes[i], 0, 3);
        }
    }

    private String getButtonName(int _idx) {
        if (_idx == 0) {
            return Resources.resTexts[0].getHashedString(21);
        }
        if (_idx == 1) {
            return Resources.resTexts[0].getHashedString(22);
        }
        if (_idx == 3) {
            return Resources.resTexts[0].getHashedString(23);
        }
        if (_idx == 2) {
            return MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27);
        }
        return "NAN";
    }

    private void paintWindow(Graphics g, Rectangle _rectWindow) {
        boolean _actualTileX = false;
        boolean _actualTileY = false;
    }

    private int getWindowTileSprite(int _x, int _y) {
        if (_y == 0 && _x == 0) {
            return 0;
        }
        if (_y == 0 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 1;
        }
        if (_y == 0 && _x == this._iTotalColTiles - 1) {
            return 2;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == 0) {
            return 6;
        }
        if (_x == 0 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 3;
        }
        if (_x == this._iTotalColTiles - 1 && _y < this._iTotalRowTiles - 1 && _y > 0) {
            return 5;
        }
        if (_y == this._iTotalRowTiles - 1 && _x < this._iTotalColTiles - 1 && _x > 0) {
            return 7;
        }
        if (_y == this._iTotalRowTiles - 1 && _x == this._iTotalColTiles - 1) {
            return 8;
        }
        return 4;
    }

    public void keyPressed(int keyCode) {
    }

    public static boolean isArcadeMode() {
        return _bArcade;
    }

    public static int getSelectedMode() {
        return _iGameModeSelector;
    }

    public static void setSelectedMode(int mode) {
        _iGameModeSelector = mode;
    }

    public void keyReleased(int keyCode) {
        this.a = keyCode;
        if (this.activeButton) {
            if (Keys.isFKRightCode(keyCode)) {
                switch (this.actualScreen) {
                    case 0: {
                        this.startAnimation(true, 4);
                        this.selectedCompId = 0;
                        this.selectorCompId = 0;
                        break;
                    }
                    case 1: {
                        this.startAnimation(true, 0);
                        this.selectedCompId = 1;
                        this.selectorCompId = 1;
                        break;
                    }
                    case 5: {
                        this.startAnimation(true, 0);
                        this.selectedCompId = 0;
                        this.selectorCompId = 0;
                        break;
                    }
                    case 6: {
                        this.startAnimation(true, 7);
                        break;
                    }
                    case 2: {
                        this.startAnimation(true, 0);
                        this.selectedCompId = 3;
                        this.selectorCompId = 3;
                        break;
                    }
                    case 4: {
                        this.startAnimation(true, 0);
                        this.selectedCompId = 0;
                        this.selectorCompId = 0;
                        break;
                    }
                    case 7: {
                        this.startAnimation(true, 0);
                        this.selectedCompId = 10;
                    }
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                if (this.actualScreen == 4) {
                    X.quitApp();
                }
            } else {
                if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
                    switch (this.actualScreen) {
                        case 0: {
                            switch (this.selectedCompId) {
                                case 0: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 10;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    _iGameModeSelector = -1;
                                    _bArcade = true;
                                    this.startAnimation(true, 3);
                                    break;
                                }
                                case 10: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    _iGameModeSelector = 0;
                                    _bArcade = false;
                                    this.startAnimation(true, 7);
                                    break;
                                }
                                case 2: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 10;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.releasedTouch = true;
                                    if (MainCanvas.soundManager.IsSoundOn()) {
                                        MainCanvas.soundManager.SetSoundOn(false);
                                        MainCanvas.soundManager.Stop();
                                        break;
                                    }
                                    MainCanvas.soundManager.SetSoundOn(true);
                                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                                    break;
                                }
                                case 1: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 10;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 3;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this.textOffsetY = 0;
                                    this.scrollUP = false;
                                    this.scrollDOWN = true;
                                    this.startAnimation(true, 1);
                                    break;
                                }
                                case 3: {
                                    if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                        this.selectedCompId = 10;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                        this.selectedCompId = 0;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                        this.selectedCompId = 2;
                                        break;
                                    }
                                    if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                        this.selectedCompId = 1;
                                        break;
                                    }
                                    if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                                    this._iCharacterSelector = 0;
                                    this._iSelectedCharacter = this._iMainCharacter;
                                    this._iSelectedLevel = 0;
                                    this._rowShopShift = 0;
                                    this.iShopDraggedY = 0;
                                    this.iShiftY = 0;
                                    this.textOffsetY = 0;
                                    this.scrollUP = false;
                                    this.scrollDOWN = true;
                                    this.startAnimation(true, 2);
                                }
                            }
                            break;
                        }
                        case 2: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this.updateShopSelect(0);
                            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this.updateShopSelect(1);
                            } else if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                this.updateShopSelect(2);
                            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                this.updateShopSelect(3);
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            int revert = this._iSelectedCharacter;
                            this._iSelectedCharacter = this._iCharacterSelector;
                            if (!this.buyOrSelectCharacter()) {
                                this._iSelectedCharacter = revert;
                            }
                            this.mainCanvas.repaint();
                            return;
                        }
                        case 6: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this.updateLevelSelect(0);
                            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this.updateLevelSelect(1);
                            } else if (Keys.isActionGeneratedByKey(3, keyCode)) {
                                this.updateLevelSelect(2);
                            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                                this.updateLevelSelect(3);
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode) || this._iSelectedLevel > this.lastOpened) break;
                            this.startAnimation(true, 3);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 7: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                if (_iGameModeSelector == 0) {
                                    _iGameModeSelector = 2;
                                    break;
                                }
                                --_iGameModeSelector;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                if (_iGameModeSelector == 2) {
                                    _iGameModeSelector = 0;
                                    break;
                                }
                                ++_iGameModeSelector;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            _topBarGameMode = _iGameModeSelector;
                            this._iCharacterSelector = this._iMainCharacter;
                            this._iSelectedCharacter = this._iMainCharacter;
                            this._iSelectedLevel = 0;
                            this._rowShopShift = 0;
                            this.iShopDraggedY = 0;
                            this.iShiftY = 0;
                            this.textOffsetY = 0;
                            this.scrollUP = false;
                            this.scrollDOWN = true;
                            this.calcLevels();
                            this.startAnimation(true, 6);
                            break;
                        }
                    }
                }
                this.selectorCompId = this.selectedCompId;
                this.a = this.selectedCompId;
                this.force = this.selectedCompId;
            }
            this.mainCanvas.repaint();
        }
    }

    public void calcLevels() {
        int _levelButtonsAreaY = _HEIGHT - this._sprTopPanel.getHeight() - this._imgBottomPanel.getHeight() - this._sprArrowsActive.getHeight() - (this._sprArrowsActive.getHeight() >> 1);
        this.levels = 0;
        this.allLevels = new String[100];
        for (int i = 0; i < this._rectLevels.length; ++i) {
            if (this.levelsChallenge[i] != null && ScreenMenu.getSelectedMode() == 0) {
                this.allLevels[i] = "1";
                this.lastOpened = i;
                ++this.levels;
            }
            if (this.levelsColorSwap[i] != null && ScreenMenu.getSelectedMode() == 1) {
                this.allLevels[i] = "1";
                this.lastOpened = i;
                ++this.levels;
            }
            if (this.levelsReverse[i] == null || ScreenMenu.getSelectedMode() != 2) continue;
            this.allLevels[i] = "1";
            this.lastOpened = i;
            ++this.levels;
        }
        int _iLevelOffsetY = this._sprBtnLevel.getHeight() >> 3;
        this._buttonRowsInArea = _levelButtonsAreaY / (this._sprBtnLevel.getHeight() + _iLevelOffsetY);
        int btns = this.lastOpened / 4;
        this.iShiftY = (this._sprBtnLevel.getHeight() + _iLevelOffsetY) * btns;
        if (this.iShiftY > this.iMaxShiftYLevels) {
            this.iShiftY = this.iMaxShiftYLevels;
        }
        int tmp = 0;
        tmp = this.actualScreen == 2 ? this.iMaxShiftY : this.iMaxShiftYLevels;
        if (this.iShiftY == 0) {
            this.scrollUP = false;
            this.scrollDOWN = true;
        } else if (this.iShiftY == tmp) {
            this.scrollUP = true;
            this.scrollDOWN = false;
        } else {
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
    }

    public void pointerPressed(int x, int y) {
        int i;
        this.posX = x;
        this.posY = y;
        if ((this.actualScreen == 2 || this.actualScreen == 6) && this.isPressedShop(x, y)) {
            this.iPressedShopX = x;
            this.iPressedShopY = y;
            this.bDragShop = true;
        }
        if (this.actualScreen == 7) {
            for (i = 0; i < this._rectGameModes.length; ++i) {
                if (!this._rectGameModes[i].contains(x, y)) continue;
                _topBarGameMode = _iGameModeSelector = i;
                this.iShopDraggedY = 0;
                this.iShiftY = 0;
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
        }
        for (i = 0; i < this.rectItems.length; ++i) {
            if (i == 11) {
                this.selectorCompId = this.selectedCompId = 11;
                this.mainCanvas.repaint();
                break;
            }
            if (i == 11 || this.rectItems[i] == null || !this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            this.s = i;
            switch (this.selectedCompId) {
                case 5: {
                    this.force = 5;
                    this.selectedCompId = 5;
                    i = 5;
                    this.selectorCompId = 5;
                    this.a = this.selectedCompId;
                    this.keyReleased(-5);
                    Keys.keyReleased(-5);
                    break;
                }
                case 8: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyReleased(-7);
                    break;
                }
                case 7: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyReleased(-6);
                    break;
                }
                default: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public boolean isPressedShop(int x, int y) {
        int offY = this._sprTopPanel.getHeight() + this._sprArrowsActive.getHeight() + (this._sprArrowsActive.getHeight() >> 1);
        return x >= 0 && x <= MainCanvas.WIDTH && y > offY && y < _HEIGHT - this._imgBottomPanel.getHeight();
    }

    public void pointerDragged(int x, int y) {
        if (this.actualScreen == 1) {
            if (this.posY < y) {
                if (Resources.sysFont) {
                    this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this.textOffsetY -= Resources.resGFonts[2].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this.textOffsetY < 0) {
                    this.textOffsetY = 0;
                    this.scrollUP = false;
                    this.scrollDOWN = true;
                }
                this.needRepaint = true;
            } else if (this.posY > y) {
                int maxOffsetY = this._ptInstruction.getTextHeight() + this._imgInlogicLogoAbout.getHeight() + this._ptVersionOfGame.getTextHeight() + (Font.getDefaultFont().getHeight() >> 1) - this.rectText.height;
                if (Resources.sysFont) {
                    this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                } else {
                    this.textOffsetY += Resources.resGFonts[2].getHeight() >> 1;
                    this.scrollUP = true;
                    this.scrollDOWN = true;
                }
                if (this.textOffsetY > maxOffsetY) {
                    this.textOffsetY = maxOffsetY;
                    this.scrollUP = true;
                    this.scrollDOWN = false;
                }
                this.needRepaint = true;
            }
        }
        if (this.actualScreen == 2 || this.actualScreen == 6) {
            int tmp = 0;
            tmp = this.actualScreen == 2 ? this.iMaxShiftY : this.iMaxShiftYLevels;
            if (this.iShiftY == 0) {
                this.scrollUP = false;
                this.scrollDOWN = true;
            } else if (this.iShiftY == tmp) {
                this.scrollUP = true;
                this.scrollDOWN = false;
            } else {
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.bDragShop) {
                if (!this.isPressedShop(x, y)) {
                    this.bDragShop = false;
                }
                this.iShopDraggedY += MainCanvas.lastPointerPressedY - y;
                MainCanvas.lastPointerPressedY = y;
            }
        }
        if (this.selectedCompId != 11) {
            if (!this.rectItems[this.selectedCompId].contains(x, y)) {
                switch (this.selectedCompId) {
                    case 4: {
                        break;
                    }
                    case 8: {
                        Keys.keyReleased(-7);
                        break;
                    }
                    case 7: {
                        Keys.keyReleased(-6);
                        break;
                    }
                    default: {
                        Keys.keyReleased(53);
                        break;
                    }
                }
            }
        } else {
            this.selectorCompId = this.selectedCompId = 11;
            this.mainCanvas.repaint();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.actualScreen == 2) {
            if (this.bDragShop) {
                this.bDragShop = false;
            }
            for (int _iIDx = 0; _iIDx < this._rectCharacters.length; ++_iIDx) {
                if (this._rectCharacters[_iIDx] == null || !this._rectCharacters[_iIDx].contains(x, y) || x != this.iPressedShopX || y + this.iShiftY != this.iPressedShopY + this.iShiftY) continue;
                int revert = this._iSelectedCharacter;
                this._iSelectedCharacter = _iIDx;
                if (!this.buyOrSelectCharacter()) {
                    this._iSelectedCharacter = revert;
                }
                this.mainCanvas.repaint();
                return;
            }
        }
        if (this.actualScreen == 6) {
            if (this.bDragShop) {
                this.bDragShop = false;
            }
            for (int _iIdx = 0; _iIdx < this._rectLevels.length; ++_iIdx) {
                if (this._rectLevels[_iIdx] == null || !this._rectLevels[_iIdx].contains(x, y) || x != this.iPressedShopX || y + this.iShiftY != this.iPressedShopY + this.iShiftY) continue;
                this._iSelectedLevel = _iIdx;
                if (this._iSelectedLevel <= this.lastOpened) {
                    this.startAnimation(true, 3);
                }
                return;
            }
        }
        if (this.actualScreen == 7) {
            for (int i = 0; i < this._rectGameModes.length; ++i) {
                if (!this._rectGameModes[i].contains(x, y) || _iGameModeSelector != i) continue;
                this.calcLevels();
                this.startAnimation(true, 6);
            }
        }
        if (this.selectedCompId != 11) {
            switch (this.selectedCompId) {
                case 5: {
                    this.activeButton = true;
                    this.selectedCompId = this.force;
                    this.keyReleased(-5);
                    Keys.keyReleased(-5);
                    break;
                }
                case 4: {
                    if (this.actualScreen != 4) break;
                    X.quitApp();
                    break;
                }
                case 8: {
                    this.activeButton = true;
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                    break;
                }
                case 7: {
                    this.activeButton = true;
                    this.keyReleased(-6);
                    Keys.keyReleased(-6);
                    break;
                }
                default: {
                    this.activeButton = true;
                    if (!Keys.isKeyPressed(53)) break;
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
            }
        }
        this.selectorCompId = this.selectedCompId = 11;
        this.mainCanvas.repaint();
    }

    private void textMove() {
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[2].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = this._ptInstruction.getTextHeight() + this._imgInlogicLogoAbout.getHeight() + this._ptVersionOfGame.getTextHeight() + (Font.getDefaultFont().getHeight() >> 1) - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[2].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
    }

    public void updateLevelSelect(int direction) {
        if (this.iShopDraggedY < 0) {
            if (this.iShiftY > 0) {
                this.iShiftY += this.iShopDraggedY;
                if (this.iShiftY <= 0) {
                    this.iShiftY = 0;
                    this.iShopDraggedY = 0;
                } else if (this.bDragShop) {
                    this.iShopDraggedY = 0;
                } else {
                    this.iShopDraggedY += MainCanvas.HEIGHT >> 6;
                    if (this.iShopDraggedY > 0) {
                        this.iShopDraggedY = 0;
                    }
                }
            } else {
                this.iShopDraggedY = 0;
            }
        }
        if (this.iShopDraggedY > 0) {
            if (this.iShiftY < this.iMaxShiftYLevels) {
                this.iShiftY += this.iShopDraggedY;
                if (this.iShiftY >= this.iMaxShiftYLevels) {
                    this.iShiftY = this.iMaxShiftYLevels;
                    this.iShopDraggedY = 0;
                } else if (this.bDragShop) {
                    this.iShopDraggedY = 0;
                } else {
                    this.iShopDraggedY -= MainCanvas.HEIGHT >> 6;
                    if (this.iShopDraggedY < 0) {
                        this.iShopDraggedY = 0;
                    }
                }
            } else {
                this.iShopDraggedY = 0;
            }
        }
    }

    public void updateShopSelect(int direction) {
        if (this.iShopDraggedY < 0) {
            if (this.iShiftY > 0) {
                this.iShiftY += this.iShopDraggedY;
                if (this.iShiftY <= 0) {
                    this.iShiftY = 0;
                    this.iShopDraggedY = 0;
                } else if (this.bDragShop) {
                    this.iShopDraggedY = 0;
                } else {
                    this.iShopDraggedY += MainCanvas.HEIGHT >> 6;
                    if (this.iShopDraggedY > 0) {
                        this.iShopDraggedY = 0;
                    }
                }
            } else {
                this.iShopDraggedY = 0;
            }
        }
        if (this.iShopDraggedY > 0) {
            if (this.iShiftY < this.iMaxShiftY) {
                this.iShiftY += this.iShopDraggedY;
                if (this.iShiftY >= this.iMaxShiftY) {
                    this.iShiftY = this.iMaxShiftY;
                    this.iShopDraggedY = 0;
                } else if (this.bDragShop) {
                    this.iShopDraggedY = 0;
                } else {
                    this.iShopDraggedY -= MainCanvas.HEIGHT >> 6;
                    if (this.iShopDraggedY < 0) {
                        this.iShopDraggedY = 0;
                    }
                }
            } else {
                this.iShopDraggedY = 0;
            }
        }
    }

    public void paintTable(Graphics g, Sprite spr, int centerX, int centerY, int width, int height) {
        int i;
        if (height < spr.getHeight() << 1) {
            height = spr.getHeight() << 1;
        }
        int left = centerX - (width >> 1);
        int top = centerY - (height >> 1);
        int countX = (width - (spr.getWidth() << 1)) / spr.getWidth() + 1;
        int countY = (height - (spr.getHeight() << 1)) / spr.getHeight() + 1;
        int iHeight2 = height - (spr.getHeight() << 1);
        int iWidth2 = width - (spr.getWidth() << 1);
        int iX = left;
        int iY = top;
        spr.setFrame(0);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX, iY + spr.getHeight(), MainCanvas.WIDTH, iHeight2);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(3);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        iY = top + height - spr.getHeight();
        spr.setFrame(6);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX + spr.getWidth(), top, iWidth2, MainCanvas.HEIGHT);
        for (i = 0; i < countX; ++i) {
            iY = top;
            spr.setFrame(1);
            spr.setPosition(iX += spr.getWidth(), iY);
            spr.paint(g);
            for (int j = 0; j < countY; ++j) {
                spr.setFrame(4);
                spr.setPosition(iX, iY += spr.getHeight());
                spr.paint(g);
            }
            iY = top + height - spr.getHeight();
            spr.setFrame(7);
            spr.setPosition(iX, iY);
            spr.paint(g);
        }
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        iX = left + width - spr.getWidth();
        iY = top;
        spr.setFrame(2);
        spr.setPosition(iX, iY);
        spr.paint(g);
        g.setClip(iX, iY + spr.getHeight(), MainCanvas.WIDTH, iHeight2);
        for (i = 0; i < countY; ++i) {
            spr.setFrame(5);
            spr.setPosition(iX, iY += spr.getHeight());
            spr.paint(g);
        }
        iY = top + height - spr.getHeight();
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        spr.setFrame(8);
        spr.setPosition(iX, iY);
        spr.paint(g);
    }
}

