/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Character;
import sk.inlogic.Game;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Obstacle {
    public static final int _TYPE_CIRCLE = 0;
    public static final int _TYPE_CIRCLE_SMALL = 1;
    public static final int _TYPE_CIRCLE_BIG = 2;
    public static final int _TYPE_RECT = 3;
    public static final int _TYPE_RECT_SMALL = 4;
    public static final int _TYPE_RECT_BIG = 5;
    public static final int _TYPE_LINE = 6;
    public static final int _TYPE_CIRCLE_DOTS = 7;
    public static final int _TYPE_DOUBLE_CIRCLE = 8;
    public static final int _TYPE_FINISH = -1;
    private int[] _arrSprites;
    private boolean _bIsAlive;
    private boolean _bIsSwitcherAlive;
    private boolean _bIsStarAlive;
    private boolean _bLeft;
    private boolean _bBig;
    int _iType;
    int _iOrder;
    int _iX;
    int _iY;
    private int _iAngle = 0;
    private int _iActualPos;
    private int[] _iPosX;
    private int[] _iPosY;
    private int _WIDTH;
    private int _HEIGHT;
    private final int _SWITCER_BLUE;
    private final int _SWITCER_GREEN;
    private final int _SWITCER_RED;
    private final int _SWITCER_YELLOW;
    private final int _COLOR_BACKGROUND;
    private final int _COLOR_BLUE;
    private final int _COLOR_GREEN;
    private final int _COLOR_RED;
    private final int _COLOR_YELLOW;
    private final int _COLOR_NONE_TYPE;
    private final int _COLOR_BLUE_TYPE;
    private final int _COLOR_GREEN_TYPE;
    private final int _COLOR_RED_TYPE;
    private final int _COLOR_YELLOW_TYPE;
    private int _iColorType = -1;
    private int _iTotalObs = 0;
    private int _circleDots = 12;
    private int dotSize = MainCanvas.WIDTH / 15;
    private Game _scrGame;
    private Rectangle _rectStar;
    private Rectangle _rectColorSwitcher;
    private Rectangle _rectObstacle;
    private Rectangle _rectObstacleEmpty;
    private Rectangle[] _rectObstacleCircleDots = new Rectangle[this._circleDots];
    private Rectangle[] _rectCollisions;
    private Sprite _sprStar;
    private Sprite _sprColorSwitcher;
    private Sprite _sprFinish;
    private int obstacleLineThickness = MainCanvas.WIDTH >> 5;
    private static boolean arcadeModeFlag = false;
    private int varDistance = 0;
    private int lineOffA = 0;
    private int lineOffB = 0;
    private int lineOffC = 0;
    private int lineOffD = 0;
    private float inAndOut = 1.0f;
    private boolean bIn = true;
    private static boolean flagForBestScoreLine;
    private Image _imgColorLine;
    private static int posYforBestScore;
    private int rectOffxA = 0;
    private int rectOffyA = 0;
    private int rectOffxB = 0;
    private int rectOffyB = 0;
    private int rectColorChange = 0;

    public Obstacle(Game game, int _itype, int _iorder, int _iTotal) {
        this._SWITCER_BLUE = 1;
        this._SWITCER_GREEN = 2;
        this._SWITCER_RED = 3;
        this._SWITCER_YELLOW = 4;
        this._COLOR_BACKGROUND = 0x220024;
        this._COLOR_BLUE = 45298;
        this._COLOR_GREEN = 46654;
        this._COLOR_RED = 16716619;
        this._COLOR_YELLOW = 16771584;
        this._COLOR_NONE_TYPE = -1;
        this._COLOR_BLUE_TYPE = 0;
        this._COLOR_GREEN_TYPE = 1;
        this._COLOR_RED_TYPE = 2;
        this._COLOR_YELLOW_TYPE = 3;
        this._scrGame = game;
        this._iTotalObs = _iTotal;
        this._iType = _itype;
        this._iOrder = _iorder;
        this._bLeft = false;
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
        this.initResources();
        this.calculate();
        this.createObstacle();
    }

    public Obstacle(int _itype, int _iorder) {
        this._SWITCER_BLUE = 1;
        this._SWITCER_GREEN = 2;
        this._SWITCER_RED = 3;
        this._SWITCER_YELLOW = 4;
        this._COLOR_BACKGROUND = 0x220024;
        this._COLOR_BLUE = 45298;
        this._COLOR_GREEN = 46654;
        this._COLOR_RED = 16716619;
        this._COLOR_YELLOW = 16771584;
        this._COLOR_NONE_TYPE = -1;
        this._COLOR_BLUE_TYPE = 0;
        this._COLOR_GREEN_TYPE = 1;
        this._COLOR_RED_TYPE = 2;
        this._COLOR_YELLOW_TYPE = 3;
        this._iType = _itype;
        this._iOrder = _iorder;
        this._bLeft = false;
        this._WIDTH = MainCanvas.WIDTH;
        this._HEIGHT = MainCanvas.HEIGHT;
        this.initResources();
        this.calculate();
    }

    private void initResources() {
        this._arrSprites = new int[]{29, 30, 25, 28, 27, 26, 31};
        Resources.loadSprites(this._arrSprites);
        if (RandomNum.getRandomUInt(100) < 20) {
            this._sprStar = Resources.resSprs[29];
            this._bBig = true;
        } else {
            this._sprStar = Resources.resSprs[30];
            this._bBig = false;
        }
        this._sprFinish = Resources.resSprs[31];
        this._sprColorSwitcher = Resources.resSprs[25];
        this._imgColorLine = Resources.resImgs[8];
        this._bIsAlive = true;
    }

    private void calculate() {
        this.calculateObstacle();
        if (this._rectObstacle == null) {
            // empty if block
        }
        this._rectObstacleEmpty = new Rectangle((this._WIDTH >> 1) - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), (this._rectObstacle.y + this._rectObstacle.height >> 1) - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.width - (this._rectObstacle.width >> 3), this._rectObstacle.width - (this._rectObstacle.width >> 3));
        int posYForColorSwitcher = ScreenMenu.getSelectedMode() != 2 ? this._rectObstacle.y - (this._sprColorSwitcher.getHeight() << 1) - (this._sprColorSwitcher.getHeight() << 1) - this._sprColorSwitcher.getHeight() : this._rectObstacle.y + this._rectObstacle.height + (this._sprColorSwitcher.getHeight() << 1) + this._sprColorSwitcher.getHeight();
        this._rectColorSwitcher = new Rectangle((MainCanvas.WIDTH >> 1) - this._sprColorSwitcher.getWidth(), posYForColorSwitcher, this._sprColorSwitcher.getWidth() << 1, this._sprColorSwitcher.getHeight() << 1);
        if (this._iOrder < this._iTotalObs - 1) {
            this._bIsSwitcherAlive = true;
        }
        this._bIsSwitcherAlive = ScreenMenu.isArcadeMode() ? this._iType != -1 && this._iOrder < this._iTotalObs && ScreenMenu.getSelectedMode() != 1 : this._iType != -1 && this._iOrder < this._iTotalObs - 2 && ScreenMenu.getSelectedMode() != 1;
        this._rectStar = new Rectangle(MainCanvas.WIDTH - this._sprStar.getWidth() >> 1, this._rectObstacle.getCenterY() - (this._sprStar.getHeight() >> 1), this._sprStar.getWidth(), this._sprStar.getHeight());
        if (this._iType != -1) {
            this._bIsStarAlive = true;
        }
    }

    public static void setArcadeModeFlag(boolean b) {
        arcadeModeFlag = b;
    }

    private void calculateObstacle() {
        int _iPosY = 0;
        RandomNum rand = new RandomNum();
        this._bLeft = RandomNum.getRandomUInt(2) == 0;
        switch (this._iType) {
            case 0: {
                switch (ScreenMenu.getSelectedMode()) {
                    case 0: {
                        if (this._iOrder == 0) {
                            _iPosY = -(this._WIDTH - (this._WIDTH >> 2)) >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                        break;
                    }
                    case 1: {
                        if (this._iOrder == 0) {
                            _iPosY = -(this._WIDTH - (this._WIDTH >> 2)) >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                        break;
                    }
                    case 2: {
                        if (this._iOrder == 0) {
                            _iPosY = MainCanvas.HEIGHT >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() + (this._sprColorSwitcher.getHeight() << 1) + this._sprColorSwitcher.getHeight();
                        break;
                    }
                    default: {
                        if (arcadeModeFlag) {
                            switch (this._iOrder) {
                                case 0: {
                                    this.varDistance = this._scrGame.GetObstacle(2).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                                    break;
                                }
                                case 1: {
                                    this.varDistance = this._scrGame.GetObstacle(0).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                                    break;
                                }
                                case 2: {
                                    this.varDistance = this._scrGame.GetObstacle(1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                                    break;
                                }
                                default: {
                                    this.varDistance = 0;
                                }
                            }
                        }
                        if (this._iOrder == 0) {
                            if (!arcadeModeFlag) {
                                _iPosY = -(this._WIDTH - (this._WIDTH >> 2)) >> 1;
                                break;
                            }
                            _iPosY = this.varDistance;
                            break;
                        }
                        _iPosY = !arcadeModeFlag ? this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2)) : this.varDistance;
                    }
                }
                this._rectObstacle = this._WIDTH < this._HEIGHT ? new Rectangle((this._WIDTH >> 1) - (this._WIDTH - (this._WIDTH >> 2) >> 1), _iPosY, this._WIDTH - (this._WIDTH >> 2), this._WIDTH - (this._WIDTH >> 2)) : new Rectangle((this._WIDTH >> 1) - (this._HEIGHT - (this._HEIGHT >> 2) >> 1), _iPosY, this._HEIGHT - (this._HEIGHT >> 2), this._HEIGHT - (this._HEIGHT >> 2));
                if (this._iOrder == 2 && ScreenMenu.isArcadeMode()) {
                    arcadeModeFlag = true;
                }
                return;
            }
            case 1: {
                switch (ScreenMenu.getSelectedMode()) {
                    case 0: {
                        if (this._iOrder == 0) {
                            _iPosY = -(this._WIDTH >> 1) >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH >> 1);
                        break;
                    }
                    case 1: {
                        if (this._iOrder == 0) {
                            _iPosY = -(this._WIDTH >> 1) >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH >> 1);
                        break;
                    }
                    case 2: {
                        if (this._iOrder == 0) {
                            _iPosY = MainCanvas.HEIGHT >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() + (this._sprColorSwitcher.getHeight() << 1) + this._sprColorSwitcher.getHeight();
                        break;
                    }
                    default: {
                        if (arcadeModeFlag) {
                            switch (this._iOrder) {
                                case 0: {
                                    this.varDistance = this._scrGame.GetObstacle(2).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH >> 1);
                                    break;
                                }
                                case 1: {
                                    this.varDistance = this._scrGame.GetObstacle(0).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH >> 1);
                                    break;
                                }
                                case 2: {
                                    this.varDistance = this._scrGame.GetObstacle(1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH >> 1);
                                    break;
                                }
                                default: {
                                    this.varDistance = 0;
                                }
                            }
                        }
                        if (this._iOrder == 0) {
                            if (!arcadeModeFlag) {
                                _iPosY = -(this._WIDTH >> 1) >> 1;
                                break;
                            }
                            _iPosY = this.varDistance;
                            break;
                        }
                        _iPosY = !arcadeModeFlag ? this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH >> 1) : this.varDistance;
                    }
                }
                this._rectObstacle = this._WIDTH < this._HEIGHT ? new Rectangle((this._WIDTH >> 1) - (this._WIDTH >> 2), _iPosY, this._WIDTH >> 1, this._WIDTH >> 1) : new Rectangle((this._WIDTH >> 1) - (this._HEIGHT >> 2), _iPosY, this._HEIGHT >> 1, this._HEIGHT >> 1);
                if (this._iOrder == 2 && ScreenMenu.isArcadeMode()) {
                    arcadeModeFlag = true;
                }
                return;
            }
            case 2: {
                switch (ScreenMenu.getSelectedMode()) {
                    case 0: {
                        if (this._iOrder == 0) {
                            _iPosY = -this._WIDTH >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                        break;
                    }
                    case 1: {
                        if (this._iOrder == 0) {
                            _iPosY = -this._WIDTH >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                        break;
                    }
                    case 2: {
                        if (this._iOrder == 0) {
                            _iPosY = MainCanvas.HEIGHT >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() + (this._sprColorSwitcher.getHeight() << 1) + this._sprColorSwitcher.getHeight();
                        break;
                    }
                    default: {
                        if (arcadeModeFlag) {
                            switch (this._iOrder) {
                                case 0: {
                                    this.varDistance = this._scrGame.GetObstacle(2).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                                    break;
                                }
                                case 1: {
                                    this.varDistance = this._scrGame.GetObstacle(0).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                                    break;
                                }
                                case 2: {
                                    this.varDistance = this._scrGame.GetObstacle(1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                                    break;
                                }
                                default: {
                                    this.varDistance = 0;
                                }
                            }
                        }
                        if (this._iOrder == 0) {
                            if (!arcadeModeFlag) {
                                _iPosY = -this._WIDTH >> 1;
                                break;
                            }
                            _iPosY = this.varDistance;
                            break;
                        }
                        _iPosY = !arcadeModeFlag ? this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH : this.varDistance;
                    }
                }
                this._rectObstacle = this._WIDTH < this._HEIGHT ? new Rectangle(0, _iPosY, this._WIDTH, this._WIDTH) : new Rectangle(this._WIDTH - this._HEIGHT >> 1, _iPosY, this._HEIGHT, this._HEIGHT);
                if (this._iOrder == 2 && ScreenMenu.isArcadeMode()) {
                    arcadeModeFlag = true;
                }
                return;
            }
            case -1: {
                _iPosY = ScreenMenu.getSelectedMode() != 2 ? this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() : this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() + this._sprFinish.getHeight();
                this._rectObstacle = new Rectangle(0, _iPosY, this._WIDTH, this._sprFinish.getHeight());
                if (this._iOrder == 2 && ScreenMenu.isArcadeMode()) {
                    arcadeModeFlag = true;
                }
                return;
            }
            case 4: {
                switch (ScreenMenu.getSelectedMode()) {
                    case 0: {
                        if (this._iOrder == 0) {
                            _iPosY = -(this._WIDTH >> 1) >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH >> 1);
                        break;
                    }
                    case 1: {
                        if (this._iOrder == 0) {
                            _iPosY = -(this._WIDTH >> 1) >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH >> 1);
                        break;
                    }
                    case 2: {
                        if (this._iOrder == 0) {
                            _iPosY = MainCanvas.HEIGHT >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() + (this._sprColorSwitcher.getHeight() << 1) + this._sprColorSwitcher.getHeight();
                        break;
                    }
                    default: {
                        if (arcadeModeFlag) {
                            switch (this._iOrder) {
                                case 0: {
                                    this.varDistance = this._scrGame.GetObstacle(2).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH >> 1);
                                    break;
                                }
                                case 1: {
                                    this.varDistance = this._scrGame.GetObstacle(0).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH >> 1);
                                    break;
                                }
                                case 2: {
                                    this.varDistance = this._scrGame.GetObstacle(1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH >> 1);
                                    break;
                                }
                                default: {
                                    this.varDistance = 0;
                                }
                            }
                        }
                        if (this._iOrder == 0) {
                            if (!arcadeModeFlag) {
                                _iPosY = -(this._WIDTH >> 1) >> 1;
                                break;
                            }
                            _iPosY = this.varDistance;
                            break;
                        }
                        _iPosY = !arcadeModeFlag ? this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH >> 1) : this.varDistance;
                    }
                }
                if (this._bLeft) {
                    this.rectOffxB = MainCanvas.WIDTH >> 1;
                    this.rectOffyB = MainCanvas.WIDTH >> 1;
                    if (this._WIDTH > this._HEIGHT) {
                        this.rectOffxB = MainCanvas.HEIGHT >> 1;
                        this.rectOffyB = MainCanvas.HEIGHT >> 1;
                    }
                }
                this._rectObstacle = this._WIDTH < this._HEIGHT ? new Rectangle((this._WIDTH >> 1) - (this._WIDTH >> 2), _iPosY, this._WIDTH >> 1, this._WIDTH >> 1) : new Rectangle((this._WIDTH >> 1) - (this._HEIGHT >> 2), _iPosY, this._HEIGHT >> 1, this._HEIGHT >> 1);
                if (this._iOrder == 2 && ScreenMenu.isArcadeMode()) {
                    arcadeModeFlag = true;
                }
                return;
            }
            case 3: {
                switch (ScreenMenu.getSelectedMode()) {
                    case 0: {
                        if (this._iOrder == 0) {
                            _iPosY = -(this._WIDTH - (this._WIDTH >> 2)) >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                        break;
                    }
                    case 1: {
                        if (this._iOrder == 0) {
                            _iPosY = -(this._WIDTH - (this._WIDTH >> 2)) >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                        break;
                    }
                    case 2: {
                        if (this._iOrder == 0) {
                            _iPosY = MainCanvas.HEIGHT >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() + (this._sprColorSwitcher.getHeight() << 1) + this._sprColorSwitcher.getHeight();
                        break;
                    }
                    default: {
                        if (arcadeModeFlag) {
                            switch (this._iOrder) {
                                case 0: {
                                    this.varDistance = this._scrGame.GetObstacle(2).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                                    break;
                                }
                                case 1: {
                                    this.varDistance = this._scrGame.GetObstacle(0).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                                    break;
                                }
                                case 2: {
                                    this.varDistance = this._scrGame.GetObstacle(1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                                    break;
                                }
                                default: {
                                    this.varDistance = 0;
                                }
                            }
                        }
                        if (this._iOrder == 0) {
                            if (!arcadeModeFlag) {
                                _iPosY = -(this._WIDTH - (this._WIDTH >> 2)) >> 1;
                                break;
                            }
                            _iPosY = this.varDistance;
                            break;
                        }
                        _iPosY = !arcadeModeFlag ? this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2)) : this.varDistance;
                    }
                }
                if (this._bLeft) {
                    this.rectOffxB = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
                    this.rectOffyB = MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2);
                    if (this._WIDTH > this._HEIGHT) {
                        this.rectOffxB = MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 2);
                        this.rectOffyB = MainCanvas.HEIGHT - (MainCanvas.HEIGHT >> 2);
                    }
                }
                this._rectObstacle = this._WIDTH < this._HEIGHT ? new Rectangle((this._WIDTH >> 1) - (this._WIDTH - (this._WIDTH >> 2) >> 1), _iPosY, this._WIDTH - (this._WIDTH >> 2), this._WIDTH - (this._WIDTH >> 2)) : new Rectangle((this._WIDTH >> 1) - (this._HEIGHT - (this._HEIGHT >> 2) >> 1), _iPosY, this._HEIGHT - (this._HEIGHT >> 2), this._HEIGHT - (this._HEIGHT >> 2));
                if (this._iOrder == 2 && ScreenMenu.isArcadeMode()) {
                    arcadeModeFlag = true;
                }
                return;
            }
            case 5: {
                switch (ScreenMenu.getSelectedMode()) {
                    case 0: {
                        if (this._iOrder == 0) {
                            _iPosY = -this._WIDTH >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                        break;
                    }
                    case 1: {
                        if (this._iOrder == 0) {
                            _iPosY = -this._WIDTH >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                        break;
                    }
                    case 2: {
                        if (this._iOrder == 0) {
                            _iPosY = MainCanvas.HEIGHT >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() + (this._sprColorSwitcher.getHeight() << 1) + this._sprColorSwitcher.getHeight();
                        break;
                    }
                    default: {
                        if (arcadeModeFlag) {
                            switch (this._iOrder) {
                                case 0: {
                                    this.varDistance = this._scrGame.GetObstacle(2).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                                    break;
                                }
                                case 1: {
                                    this.varDistance = this._scrGame.GetObstacle(0).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                                    break;
                                }
                                case 2: {
                                    this.varDistance = this._scrGame.GetObstacle(1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                                    break;
                                }
                                default: {
                                    this.varDistance = 0;
                                }
                            }
                        }
                        if (this._iOrder == 0) {
                            if (!arcadeModeFlag) {
                                _iPosY = -this._WIDTH >> 1;
                                break;
                            }
                            _iPosY = this.varDistance;
                            break;
                        }
                        _iPosY = !arcadeModeFlag ? this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH : this.varDistance;
                    }
                }
                if (this._bLeft) {
                    this.rectOffxB = MainCanvas.WIDTH;
                    this.rectOffyB = MainCanvas.WIDTH;
                    if (this._WIDTH > this._HEIGHT) {
                        this.rectOffxB = MainCanvas.HEIGHT;
                        this.rectOffyB = MainCanvas.HEIGHT;
                    }
                }
                this._rectObstacle = this._WIDTH < this._HEIGHT ? new Rectangle(0, _iPosY, this._WIDTH, this._WIDTH) : new Rectangle(this._WIDTH - this._HEIGHT >> 1, _iPosY, this._HEIGHT, this._HEIGHT);
                if (this._iOrder == 2 && ScreenMenu.isArcadeMode()) {
                    arcadeModeFlag = true;
                }
                return;
            }
            case 6: {
                switch (ScreenMenu.getSelectedMode()) {
                    case 0: {
                        if (this._iOrder == 0) {
                            _iPosY = this._WIDTH < this._HEIGHT ? this._WIDTH >> 1 : this._HEIGHT >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this.obstacleLineThickness;
                        break;
                    }
                    case 1: {
                        if (this._iOrder == 0) {
                            _iPosY = this._WIDTH < this._HEIGHT ? this._WIDTH >> 1 : this._HEIGHT >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this.obstacleLineThickness;
                        break;
                    }
                    case 2: {
                        if (this._iOrder == 0) {
                            _iPosY = MainCanvas.HEIGHT >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() + (this._sprColorSwitcher.getHeight() << 1) + this._sprColorSwitcher.getHeight();
                        break;
                    }
                    default: {
                        if (arcadeModeFlag) {
                            switch (this._iOrder) {
                                case 0: {
                                    this.varDistance = this._scrGame.GetObstacle(2).GetPositionForNext() - this.obstacleLineThickness - (this._HEIGHT >> 2);
                                    break;
                                }
                                case 1: {
                                    this.varDistance = this._scrGame.GetObstacle(0).GetPositionForNext() - this.obstacleLineThickness - (this._HEIGHT >> 2);
                                    break;
                                }
                                case 2: {
                                    this.varDistance = this._scrGame.GetObstacle(1).GetPositionForNext() - this.obstacleLineThickness - (this._HEIGHT >> 2);
                                    break;
                                }
                                default: {
                                    this.varDistance = 0;
                                }
                            }
                        }
                        if (this._iOrder == 0) {
                            if (!arcadeModeFlag) {
                                _iPosY = this._WIDTH < this._HEIGHT ? this._WIDTH >> 1 : this._HEIGHT >> 1;
                                break;
                            }
                            _iPosY = this.varDistance;
                            break;
                        }
                        _iPosY = !arcadeModeFlag ? this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this.obstacleLineThickness - (this._HEIGHT >> 2) : this.varDistance;
                    }
                }
                this._rectObstacle = new Rectangle(0, _iPosY, this._WIDTH, this.obstacleLineThickness);
                if (this._iOrder == 2 && ScreenMenu.isArcadeMode()) {
                    arcadeModeFlag = true;
                }
                return;
            }
            case 7: {
                switch (ScreenMenu.getSelectedMode()) {
                    case 0: {
                        if (this._iOrder == 0) {
                            _iPosY = -(this._WIDTH - (this._WIDTH >> 2)) >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                        break;
                    }
                    case 1: {
                        if (this._iOrder == 0) {
                            _iPosY = -(this._WIDTH - (this._WIDTH >> 2)) >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                        break;
                    }
                    case 2: {
                        if (this._iOrder == 0) {
                            _iPosY = MainCanvas.HEIGHT >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() + (this._sprColorSwitcher.getHeight() << 1) + this._sprColorSwitcher.getHeight();
                        break;
                    }
                    default: {
                        if (arcadeModeFlag) {
                            switch (this._iOrder) {
                                case 0: {
                                    this.varDistance = this._scrGame.GetObstacle(2).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                                    break;
                                }
                                case 1: {
                                    this.varDistance = this._scrGame.GetObstacle(0).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                                    break;
                                }
                                case 2: {
                                    this.varDistance = this._scrGame.GetObstacle(1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2));
                                    break;
                                }
                                default: {
                                    this.varDistance = 0;
                                }
                            }
                        }
                        if (this._iOrder == 0) {
                            if (!arcadeModeFlag) {
                                _iPosY = -(this._WIDTH - (this._WIDTH >> 2)) >> 1;
                                break;
                            }
                            _iPosY = this.varDistance;
                            break;
                        }
                        _iPosY = !arcadeModeFlag ? this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - (this._WIDTH - (this._WIDTH >> 2)) : this.varDistance;
                    }
                }
                this._rectObstacle = this._WIDTH < this._HEIGHT ? new Rectangle(this._WIDTH - (this._WIDTH - (this._WIDTH >> 2) >> 1) - (this._WIDTH >> 1), _iPosY, this._WIDTH - (this._WIDTH >> 2), this._WIDTH - (this._WIDTH >> 2)) : new Rectangle(this._WIDTH - (this._HEIGHT - (this._HEIGHT >> 2)) >> 1, _iPosY, this._HEIGHT - (this._HEIGHT >> 2), this._HEIGHT - (this._HEIGHT >> 2));
                if (this._iOrder == 2 && ScreenMenu.isArcadeMode()) {
                    arcadeModeFlag = true;
                }
                return;
            }
            case 8: {
                switch (ScreenMenu.getSelectedMode()) {
                    case 0: {
                        if (this._iOrder == 0) {
                            _iPosY = -this._WIDTH >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                        break;
                    }
                    case 1: {
                        if (this._iOrder == 0) {
                            _iPosY = -this._WIDTH >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                        break;
                    }
                    case 2: {
                        if (this._iOrder == 0) {
                            _iPosY = MainCanvas.HEIGHT >> 1;
                            break;
                        }
                        _iPosY = this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() + (this._sprColorSwitcher.getHeight() << 1) + this._sprColorSwitcher.getHeight();
                        break;
                    }
                    default: {
                        if (arcadeModeFlag) {
                            switch (this._iOrder) {
                                case 0: {
                                    this.varDistance = this._scrGame.GetObstacle(2).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                                    break;
                                }
                                case 1: {
                                    this.varDistance = this._scrGame.GetObstacle(0).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                                    break;
                                }
                                case 2: {
                                    this.varDistance = this._scrGame.GetObstacle(1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH;
                                    break;
                                }
                                default: {
                                    this.varDistance = 0;
                                }
                            }
                        }
                        if (this._iOrder == 0) {
                            if (!arcadeModeFlag) {
                                _iPosY = -this._WIDTH >> 1;
                                break;
                            }
                            _iPosY = this.varDistance;
                            break;
                        }
                        _iPosY = !arcadeModeFlag ? this._scrGame.GetObstacle(this._iOrder - 1).GetPositionForNext() - this._sprColorSwitcher.getHeight() - this._WIDTH : this.varDistance;
                    }
                }
                this._bLeft = ScreenMenu.getSelectedMode() != 2;
                this._rectObstacle = this._WIDTH < this._HEIGHT ? new Rectangle(0, _iPosY, this._WIDTH, this._WIDTH) : new Rectangle(this._WIDTH - this._HEIGHT >> 1, _iPosY, this._HEIGHT, this._HEIGHT);
                if (this._iOrder == 2 && ScreenMenu.isArcadeMode()) {
                    arcadeModeFlag = true;
                }
                return;
            }
        }
    }

    public int get_bBigValue() {
        if (!this._bBig) {
            return 1;
        }
        return 5;
    }

    public void ScrollDown(Character _char) {
        int tmp = MainCanvas.HEIGHT / 100;
        this._rectObstacle.y += tmp;
        this._rectColorSwitcher.y += tmp;
        this._rectStar.y += tmp;
        _char._iOffsetY = tmp;
        for (int i = 0; i < this._circleDots; ++i) {
            if (this._rectObstacleCircleDots[i] == null) continue;
            this._rectObstacleCircleDots[i].y += tmp;
        }
    }

    public void scrollDownBestScoreLine() {
        posYforBestScore += MainCanvas.HEIGHT / 100;
    }

    public void ScrollUp(Character _char) {
        int tmp = MainCanvas.HEIGHT / 100;
        this._rectObstacle.y -= tmp;
        this._rectColorSwitcher.y -= tmp;
        this._rectStar.y -= tmp;
        _char._iOffsetY = -tmp;
        for (int i = 0; i < this._circleDots; ++i) {
            if (this._rectObstacleCircleDots[i] == null) continue;
            this._rectObstacleCircleDots[i].y -= tmp;
        }
    }

    private void createObstacle() {
        switch (this._iType) {
            default: 
        }
    }

    public void Restart() {
        this._bIsAlive = true;
    }

    public void Deactivate() {
        this._bIsAlive = false;
    }

    public void Update(long lastRunLenght, Character _char) {
        if (!this.IsAlive()) {
            return;
        }
        this.updateFinish(_char);
        this.updateSwitcher(_char);
        this.updateStar(_char);
        switch (this._iType) {
            case 0: {
                this.IsCircleCollision(_char);
                break;
            }
            case 2: {
                this.IsCircleCollision(_char);
                break;
            }
            case 1: {
                this.IsCircleCollision(_char);
                break;
            }
            case 3: {
                this.isRectCollision(_char);
                break;
            }
            case 4: {
                this.isRectCollision(_char);
                break;
            }
            case 5: {
                this.isRectCollision(_char);
                break;
            }
            case 6: {
                this.isLineCollision(_char);
                break;
            }
            case 7: {
                this.isCircleDotsCollision(_char);
                break;
            }
            case 8: {
                this.isDoubleCircleCollision(_char);
                break;
            }
        }
        this.updateObstacle();
        this.checkAlive();
    }

    private void updateFinish(Character _r) {
        if (this._iType != -1) {
            return;
        }
        if (!this._bIsAlive) {
            return;
        }
        if (this._rectObstacle.intersects(_r.getCharacterRect()) && !ScreenMenu.isArcadeMode()) {
            this._scrGame.SetGameOver(true);
            this._bIsAlive = false;
        }
    }

    private void updateSwitcher(Character _r) {
        if (!this._bIsSwitcherAlive) {
            return;
        }
        if (this._rectColorSwitcher.intersects(_r.getCharacterRect())) {
            _r.ChangeColor();
            this._bIsSwitcherAlive = false;
        }
    }

    private void updateStar(Character _r) {
        if (!this._bIsStarAlive) {
            return;
        }
        if (this._rectStar.intersects(_r.getCharacterRect())) {
            if (!this._bBig) {
                this._scrGame.incScore(1);
            } else {
                this._scrGame.incScore(5);
            }
            this._bIsStarAlive = false;
        }
    }

    private void updateObstacle() {
        switch (this._iType) {
            case 0: {
                this.updateCircle();
                return;
            }
            case 1: {
                this.updateCircleSmall();
                return;
            }
            case 2: {
                this.updateCircleBig();
                return;
            }
            case 6: {
                this.updateLine();
                return;
            }
            case 3: {
                this.updateRect();
                return;
            }
            case 5: {
                this.updateRectBig();
                return;
            }
            case 4: {
                this.updateRectSmall();
                return;
            }
            case 7: {
                this.updateCircleDots();
                return;
            }
            case 8: {
                this.updateDoubleCircle();
                return;
            }
        }
    }

    private void updateCircle() {
        this._iAngle = this._bLeft ? (this._iAngle < 360 ? (this._iAngle += 2) : 0) : (this._iAngle < 0 ? 360 : (this._iAngle -= 2));
    }

    private void updateCircleSmall() {
        this._iAngle = this._bLeft ? (this._iAngle < 360 ? (this._iAngle += 2) : 0) : (this._iAngle < 0 ? 360 : (this._iAngle -= 2));
    }

    private void updateCircleBig() {
        this._iAngle = this._bLeft ? (this._iAngle < 360 ? (this._iAngle += 2) : 0) : (this._iAngle < 0 ? 360 : (this._iAngle -= 2));
    }

    private void updateLine() {
        if (this._bLeft) {
            if (this._iAngle > 0) {
                this._iAngle -= MainCanvas.WIDTH / 120;
                this.lineOffA = this._iAngle < MainCanvas.WIDTH >> 2 ? this._iAngle + (MainCanvas.WIDTH >> 2) * 3 : MainCanvas.WIDTH;
                this.lineOffB = this._iAngle < MainCanvas.WIDTH >> 1 ? this._iAngle + (MainCanvas.WIDTH >> 1) : MainCanvas.WIDTH;
                this.lineOffC = this._iAngle < (MainCanvas.WIDTH >> 2) * 3 ? this._iAngle + (MainCanvas.WIDTH >> 2) : MainCanvas.WIDTH;
                this.lineOffD = this._iAngle < MainCanvas.WIDTH ? this._iAngle : MainCanvas.WIDTH;
            } else {
                this._iAngle = MainCanvas.WIDTH;
            }
        } else if (this._iAngle < MainCanvas.WIDTH) {
            this._iAngle += MainCanvas.WIDTH / 120;
            this.lineOffA = this._iAngle > MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2) ? this._iAngle - (MainCanvas.WIDTH - (MainCanvas.WIDTH >> 2)) : 0;
            this.lineOffB = this._iAngle > MainCanvas.WIDTH >> 1 ? this._iAngle - (MainCanvas.WIDTH >> 1) : 0;
            this.lineOffC = this._iAngle > MainCanvas.WIDTH >> 2 ? this._iAngle - (MainCanvas.WIDTH >> 2) : 0;
            this.lineOffD = this._iAngle > 0 ? this._iAngle : 0;
        } else {
            this._iAngle = 0;
        }
    }

    private void updateRectSmall() {
        int screenWidth = 0;
        screenWidth = this._WIDTH < this._HEIGHT ? this._WIDTH : this._HEIGHT;
        if (this._bLeft) {
            if (this._iAngle > 0) {
                this._iAngle -= screenWidth / 120;
                if (this._iAngle > (screenWidth << 1) - (screenWidth >> 1)) {
                    this.rectColorChange = 3;
                    this.rectOffxA = screenWidth >> 1;
                    this.rectOffyA = screenWidth >> 1;
                    this.rectOffxB -= screenWidth / 120;
                    this.rectOffyB -= screenWidth / 120;
                } else if (this._iAngle > screenWidth) {
                    this.rectColorChange = 2;
                    this.rectOffxB = screenWidth >> 1;
                    this.rectOffyB = screenWidth >> 1;
                    this.rectOffxA -= screenWidth / 120;
                    this.rectOffyA -= screenWidth / 120;
                } else if (this._iAngle > screenWidth - (screenWidth >> 1)) {
                    this.rectColorChange = 1;
                    this.rectOffxA = screenWidth >> 1;
                    this.rectOffyA = screenWidth >> 1;
                    this.rectOffxB -= screenWidth / 120;
                    this.rectOffyB -= screenWidth / 120;
                } else if (this._iAngle > 0) {
                    this.rectColorChange = 0;
                    this.rectOffxB = screenWidth >> 1;
                    this.rectOffyB = screenWidth >> 1;
                    this.rectOffxA -= screenWidth / 120;
                    this.rectOffyA -= screenWidth / 120;
                }
            } else {
                this._iAngle = screenWidth * 2;
            }
        } else if (this._iAngle < screenWidth * 2) {
            this._iAngle += screenWidth / 120;
            if (this._iAngle > (screenWidth << 1) - (screenWidth >> 1)) {
                this.rectColorChange = 3;
                this.rectOffxA = 0;
                this.rectOffyA = 0;
                this.rectOffxB += screenWidth / 120;
                this.rectOffyB += screenWidth / 120;
            } else if (this._iAngle > screenWidth) {
                this.rectColorChange = 2;
                this.rectOffxB = 0;
                this.rectOffyB = 0;
                this.rectOffxA += screenWidth / 120;
                this.rectOffyA += screenWidth / 120;
            } else if (this._iAngle > screenWidth - (screenWidth >> 1)) {
                this.rectColorChange = 1;
                this.rectOffxA = 0;
                this.rectOffyA = 0;
                this.rectOffxB += screenWidth / 120;
                this.rectOffyB += screenWidth / 120;
            } else if (this._iAngle > 0) {
                this.rectColorChange = 0;
                this.rectOffxB = 0;
                this.rectOffyB = 0;
                this.rectOffxA += screenWidth / 120;
                this.rectOffyA += screenWidth / 120;
            }
        } else {
            this._iAngle = 0;
        }
    }

    private void updateRectBig() {
        int screenWidth = 0;
        screenWidth = this._WIDTH < this._HEIGHT ? this._WIDTH : this._HEIGHT;
        if (this._bLeft) {
            if (this._iAngle > 0) {
                this._iAngle -= screenWidth / 30;
                if (this._iAngle > screenWidth * 3) {
                    this.rectColorChange = 3;
                    this.rectOffxA = screenWidth;
                    this.rectOffyA = screenWidth;
                    this.rectOffxB -= screenWidth / 30;
                    this.rectOffyB -= screenWidth / 30;
                } else if (this._iAngle > screenWidth * 2) {
                    this.rectColorChange = 2;
                    this.rectOffxB = screenWidth;
                    this.rectOffyB = screenWidth;
                    this.rectOffxA -= screenWidth / 30;
                    this.rectOffyA -= screenWidth / 30;
                } else if (this._iAngle > screenWidth) {
                    this.rectColorChange = 1;
                    this.rectOffxA = screenWidth;
                    this.rectOffyA = screenWidth;
                    this.rectOffxB -= screenWidth / 30;
                    this.rectOffyB -= screenWidth / 30;
                } else if (this._iAngle > 0) {
                    this.rectColorChange = 0;
                    this.rectOffxB = screenWidth;
                    this.rectOffyB = screenWidth;
                    this.rectOffxA -= screenWidth / 30;
                    this.rectOffyA -= screenWidth / 30;
                }
            } else {
                this._iAngle = screenWidth * 4;
            }
        } else if (this._iAngle < screenWidth * 4) {
            this._iAngle += screenWidth / 30;
            if (this._iAngle > screenWidth * 3) {
                this.rectColorChange = 3;
                this.rectOffxA = 0;
                this.rectOffyA = 0;
                this.rectOffxB += screenWidth / 30;
                this.rectOffyB += screenWidth / 30;
            } else if (this._iAngle > screenWidth * 2) {
                this.rectColorChange = 2;
                this.rectOffxB = 0;
                this.rectOffyB = 0;
                this.rectOffxA += screenWidth / 30;
                this.rectOffyA += screenWidth / 30;
            } else if (this._iAngle > screenWidth) {
                this.rectColorChange = 1;
                this.rectOffxA = 0;
                this.rectOffyA = 0;
                this.rectOffxB += screenWidth / 30;
                this.rectOffyB += screenWidth / 30;
            } else if (this._iAngle > 0) {
                this.rectColorChange = 0;
                this.rectOffxB = 0;
                this.rectOffyB = 0;
                this.rectOffxA += screenWidth / 30;
                this.rectOffyA += screenWidth / 30;
            }
        } else {
            this._iAngle = 0;
        }
    }

    private void updateRect() {
        int screenWidth = 0;
        screenWidth = this._WIDTH < this._HEIGHT ? this._WIDTH : this._HEIGHT;
        if (this._bLeft) {
            if (this._iAngle > 0) {
                this._iAngle -= screenWidth / 60;
                if (this._iAngle > (screenWidth << 1) + (screenWidth >> 2)) {
                    this.rectColorChange = 3;
                    this.rectOffxA = screenWidth - (screenWidth >> 2);
                    this.rectOffyA = screenWidth - (screenWidth >> 2);
                    this.rectOffxB -= screenWidth / 60;
                    this.rectOffyB -= screenWidth / 60;
                } else if (this._iAngle > screenWidth + (screenWidth >> 1)) {
                    this.rectColorChange = 2;
                    this.rectOffxB = screenWidth - (screenWidth >> 2);
                    this.rectOffyB = screenWidth - (screenWidth >> 2);
                    this.rectOffxA -= screenWidth / 60;
                    this.rectOffyA -= screenWidth / 60;
                } else if (this._iAngle > screenWidth - (screenWidth >> 2)) {
                    this.rectColorChange = 1;
                    this.rectOffxA = screenWidth - (screenWidth >> 2);
                    this.rectOffyA = screenWidth - (screenWidth >> 2);
                    this.rectOffxB -= screenWidth / 60;
                    this.rectOffyB -= screenWidth / 60;
                } else if (this._iAngle > 0) {
                    this.rectColorChange = 0;
                    this.rectOffxB = screenWidth - (screenWidth >> 2);
                    this.rectOffyB = screenWidth - (screenWidth >> 2);
                    this.rectOffxA -= screenWidth / 60;
                    this.rectOffyA -= screenWidth / 60;
                }
            } else {
                this._iAngle = screenWidth * 3;
            }
        } else if (this._iAngle < screenWidth * 3) {
            this._iAngle += screenWidth / 60;
            if (this._iAngle > (screenWidth << 1) + (screenWidth >> 2)) {
                this.rectColorChange = 3;
                this.rectOffxA = 0;
                this.rectOffyA = 0;
                this.rectOffxB += screenWidth / 60;
                this.rectOffyB += screenWidth / 60;
            } else if (this._iAngle > screenWidth + (screenWidth >> 1)) {
                this.rectColorChange = 2;
                this.rectOffxB = 0;
                this.rectOffyB = 0;
                this.rectOffxA += screenWidth / 60;
                this.rectOffyA += screenWidth / 60;
            } else if (this._iAngle > screenWidth - (screenWidth >> 2)) {
                this.rectColorChange = 1;
                this.rectOffxA = 0;
                this.rectOffyA = 0;
                this.rectOffxB += screenWidth / 60;
                this.rectOffyB += screenWidth / 60;
            } else if (this._iAngle > 0) {
                this.rectColorChange = 0;
                this.rectOffxB = 0;
                this.rectOffyB = 0;
                this.rectOffxA += screenWidth / 60;
                this.rectOffyA += screenWidth / 60;
            }
        } else {
            this._iAngle = 0;
        }
    }

    private void updateCircleDots() {
        if (this._bLeft) {
            if (this._iAngle < 360) {
                this._iAngle += 2;
                if (this._iAngle > 360) {
                    this._iAngle -= 360;
                }
            } else {
                this._iAngle = 0;
            }
        } else if (this._iAngle < 0) {
            this._iAngle = 360;
        } else {
            this._iAngle -= 2;
            if (this._iAngle < 0) {
                this._iAngle += 360;
            }
        }
        if (this.bIn) {
            if (this.inAndOut < 2.0f) {
                this.inAndOut = (float)((double)this.inAndOut + 0.05);
            } else {
                this.bIn = false;
            }
        } else if (this.inAndOut > 1.0f) {
            this.inAndOut = (float)((double)this.inAndOut - 0.05);
        } else {
            this.bIn = true;
        }
    }

    private void updateDoubleCircle() {
        this._iAngle = this._bLeft ? (this._iAngle < 360 ? (this._iAngle += 2) : 0) : (this._iAngle < 0 ? 360 : (this._iAngle -= 2));
    }

    private void checkAlive() {
        if (this._iY >= MainCanvas.HEIGHT) {
            this._bIsAlive = false;
        }
    }

    public void Paint(Graphics g) {
        if (!this.IsAlive()) {
            return;
        }
        this.paintObstacle(g);
        if (this.IsSwitcherAlive()) {
            this.paintColorSwither(g);
        }
        if (this.IsStarAlive()) {
            this.paintStar(g);
        }
        if (flagForBestScoreLine && ScreenMenu.isArcadeMode()) {
            this.paintBestScoreLine(g);
        }
    }

    private void paintColorSwither(Graphics g) {
        this.paintSwitcherFragment(g, Resources.resSprs[25], 1);
        this.paintSwitcherFragment(g, Resources.resSprs[28], 2);
        this.paintSwitcherFragment(g, Resources.resSprs[27], 3);
        this.paintSwitcherFragment(g, Resources.resSprs[26], 4);
    }

    private void paintSwitcherFragment(Graphics g, Sprite _sprFragment, int _iPos) {
        switch (_iPos) {
            case 1: {
                _sprFragment.setTransform(0);
                _sprFragment.setPosition(this._rectColorSwitcher.x, this._rectColorSwitcher.y);
                break;
            }
            case 2: {
                _sprFragment.setTransform(0);
                _sprFragment.setTransform(2);
                _sprFragment.setPosition(this._rectColorSwitcher.x + _sprFragment.getWidth(), this._rectColorSwitcher.y);
                break;
            }
            case 3: {
                _sprFragment.setTransform(0);
                _sprFragment.setTransform(3);
                _sprFragment.setPosition(this._rectColorSwitcher.x + _sprFragment.getWidth(), this._rectColorSwitcher.y + _sprFragment.getWidth());
                break;
            }
            case 4: {
                _sprFragment.setTransform(0);
                _sprFragment.setTransform(1);
                _sprFragment.setPosition(this._rectColorSwitcher.x, this._rectColorSwitcher.y + _sprFragment.getWidth());
            }
        }
        _sprFragment.paint(g);
    }

    private void paintStar(Graphics g) {
        this._sprStar.setPosition(this._rectStar.x, this._rectStar.y);
        this._sprStar.paint(g);
    }

    public void setFlagForBestScoreLine(boolean flag) {
        flagForBestScoreLine = flag;
        posYforBestScore = this._rectColorSwitcher.y;
    }

    public static boolean getFlagForBestScoreLine() {
        return flagForBestScoreLine;
    }

    private void paintBestScoreLine(Graphics g) {
        if (posYforBestScore > MainCanvas.HEIGHT) {
            flagForBestScoreLine = false;
            return;
        }
        g.drawImage(this._imgColorLine, MainCanvas.WIDTH >> 1, posYforBestScore + this._sprColorSwitcher.getHeight() - (this._imgColorLine.getHeight() >> 1), 17);
    }

    private void paintObstacle(Graphics g) {
        switch (this._iType) {
            case 0: {
                this.paintCircle(g);
                return;
            }
            case 2: {
                this.paintCircle(g);
                return;
            }
            case 1: {
                this.paintCircle(g);
                return;
            }
            case -1: {
                this.paintFinish(g);
                return;
            }
            case 3: {
                this.paintRect(g);
                return;
            }
            case 4: {
                this.paintRect(g);
                return;
            }
            case 5: {
                this.paintRect(g);
                return;
            }
            case 6: {
                this.paintLine(g);
                return;
            }
            case 7: {
                this.paintCircleDots(g);
                return;
            }
            case 8: {
                this.paintDoubleCircle(g);
                return;
            }
        }
    }

    private void paintFinish(Graphics g) {
        for (int _iIdx = this._rectObstacle.x; _iIdx < this._rectObstacle.x + this._rectObstacle.width; _iIdx += this._sprFinish.getWidth()) {
            int _iIdy = this._rectObstacle.y;
            this._sprFinish.setPosition(_iIdx, _iIdy);
            this._sprFinish.paint(g);
        }
    }

    private void paintCircle(Graphics g) {
        g.setColor(45298);
        g.fillArc(this._rectObstacle.x, this._rectObstacle.y, this._rectObstacle.width, this._rectObstacle.height, this.getStartAngle(0), 90);
        g.setColor(46654);
        g.fillArc(this._rectObstacle.x, this._rectObstacle.y, this._rectObstacle.width, this._rectObstacle.height, this.getStartAngle(1), 90);
        g.setColor(16716619);
        g.fillArc(this._rectObstacle.x, this._rectObstacle.y, this._rectObstacle.width, this._rectObstacle.height, this.getStartAngle(2), 90);
        g.setColor(16771584);
        g.fillArc(this._rectObstacle.x, this._rectObstacle.y, this._rectObstacle.width, this._rectObstacle.height, this.getStartAngle(3), 90);
        g.setColor(0x220024);
        g.fillArc((this._WIDTH >> 1) - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.getCenterY() - (this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1), this._rectObstacle.width - (this._rectObstacle.width >> 3), this._rectObstacle.width - (this._rectObstacle.width >> 3), 0, 360);
    }

    private void paintSquare(Graphics g) {
    }

    private void paintLine(Graphics g) {
        int lineY = this._rectObstacle.y;
        if (this._bLeft) {
            g.setColor(45298);
            g.fillRect(this._iAngle - (MainCanvas.WIDTH >> 2), lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            if (this.lineOffA < MainCanvas.WIDTH) {
                g.setColor(45298);
                g.fillRect(this.lineOffA, lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            }
            g.setColor(46654);
            g.fillRect(this._iAngle - (MainCanvas.WIDTH >> 1), lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            if (this.lineOffB < MainCanvas.WIDTH) {
                g.setColor(46654);
                g.fillRect(this.lineOffB, lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            }
            g.setColor(16716619);
            g.fillRect(this._iAngle - (MainCanvas.WIDTH >> 2) * 3, lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            if (this.lineOffC < MainCanvas.WIDTH) {
                g.setColor(16716619);
                g.fillRect(this.lineOffC, lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            }
            g.setColor(16771584);
            g.fillRect(this._iAngle - MainCanvas.WIDTH, lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            if (this.lineOffD < MainCanvas.WIDTH) {
                g.setColor(16771584);
                g.fillRect(this.lineOffD, lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            }
        } else {
            g.setColor(45298);
            g.fillRect(0 + this._iAngle, lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            if (this.lineOffA > 0) {
                g.setColor(45298);
                g.fillRect(this.lineOffA - (MainCanvas.WIDTH >> 2), lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            }
            g.setColor(46654);
            g.fillRect((MainCanvas.WIDTH >> 2) + this._iAngle, lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            if (this.lineOffB > 0) {
                g.setColor(46654);
                g.fillRect(this.lineOffB - (MainCanvas.WIDTH >> 2), lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            }
            g.setColor(16716619);
            g.fillRect((MainCanvas.WIDTH >> 1) + this._iAngle, lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            if (this.lineOffC > 0) {
                g.setColor(16716619);
                g.fillRect(this.lineOffC - (MainCanvas.WIDTH >> 2), lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            }
            g.setColor(16771584);
            g.fillRect((MainCanvas.WIDTH >> 2) * 3 + this._iAngle, lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            if (this.lineOffD > 0) {
                g.setColor(16771584);
                g.fillRect(this.lineOffD - (MainCanvas.WIDTH >> 2), lineY, MainCanvas.WIDTH >> 2, this.obstacleLineThickness);
            }
        }
    }

    private void paintDoubleCircle(Graphics g) {
        g.setColor(45298);
        g.fillArc(this._rectObstacle.x, this._rectObstacle.y + (this._rectObstacle.height >> 2), this._rectObstacle.width >> 1, this._rectObstacle.height >> 1, this.getStartAngle(0), 90);
        g.setColor(46654);
        g.fillArc(this._rectObstacle.x, this._rectObstacle.y + (this._rectObstacle.height >> 2), this._rectObstacle.width >> 1, this._rectObstacle.height >> 1, this.getStartAngle(3), 90);
        g.setColor(16716619);
        g.fillArc(this._rectObstacle.x, this._rectObstacle.y + (this._rectObstacle.height >> 2), this._rectObstacle.width >> 1, this._rectObstacle.height >> 1, this.getStartAngle(2), 90);
        g.setColor(16771584);
        g.fillArc(this._rectObstacle.x, this._rectObstacle.y + (this._rectObstacle.height >> 2), this._rectObstacle.width >> 1, this._rectObstacle.height >> 1, this.getStartAngle(1), 90);
        g.setColor(0x220024);
        g.fillArc((this._WIDTH >> 1) - (this._rectObstacle.width - (this._rectObstacle.width >> 4) >> 1), this._rectObstacle.y + (this._rectObstacle.height >> 2) + (this._rectObstacle.height >> 5), this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1, this._rectObstacle.height - (this._rectObstacle.height >> 3) >> 1, 0, 360);
        g.setColor(45298);
        g.fillArc(this._rectObstacle.x + (this._rectObstacle.width >> 1), this._rectObstacle.y + (this._rectObstacle.height >> 2), this._rectObstacle.width >> 1, this._rectObstacle.height >> 1, this.getStartAngleL(0), 90);
        g.setColor(46654);
        g.fillArc(this._rectObstacle.x + (this._rectObstacle.width >> 1), this._rectObstacle.y + (this._rectObstacle.height >> 2), this._rectObstacle.width >> 1, this._rectObstacle.height >> 1, this.getStartAngleL(1), 90);
        g.setColor(16716619);
        g.fillArc(this._rectObstacle.x + (this._rectObstacle.width >> 1), this._rectObstacle.y + (this._rectObstacle.height >> 2), this._rectObstacle.width >> 1, this._rectObstacle.height >> 1, this.getStartAngleL(2), 90);
        g.setColor(16771584);
        g.fillArc(this._rectObstacle.x + (this._rectObstacle.width >> 1), this._rectObstacle.y + (this._rectObstacle.height >> 2), this._rectObstacle.width >> 1, this._rectObstacle.height >> 1, this.getStartAngleL(3), 90);
        g.setColor(0x220024);
        g.fillArc((this._WIDTH >> 1) + (this._rectObstacle.width >> 4 >> 1), this._rectObstacle.y + (this._rectObstacle.height >> 2) + (this._rectObstacle.height >> 5), this._rectObstacle.width - (this._rectObstacle.width >> 3) >> 1, this._rectObstacle.height - (this._rectObstacle.height >> 3) >> 1, 0, 360);
    }

    private void paintRect(Graphics g) {
        switch (this.rectColorChange) {
            case 0: {
                g.setColor(45298);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y, this._rectObstacle.width - this.rectOffxA, this.obstacleLineThickness);
                g.setColor(45298);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y, this.obstacleLineThickness, this.rectOffyA);
                g.setColor(46654);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y + this.rectOffyA, this.obstacleLineThickness, this._rectObstacle.height - this.rectOffyA);
                g.setColor(46654);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y + this._rectObstacle.height - this.obstacleLineThickness, this.rectOffxA, this.obstacleLineThickness);
                g.setColor(16716619);
                g.fillRect(this._rectObstacle.x + this.rectOffxA, this._rectObstacle.y + this._rectObstacle.height - this.obstacleLineThickness, this._rectObstacle.width - this.rectOffxA, this.obstacleLineThickness);
                g.setColor(16716619);
                g.fillRect(this._rectObstacle.x + this._rectObstacle.width - this.obstacleLineThickness, this._rectObstacle.y + this._rectObstacle.height - this.rectOffyA, this.obstacleLineThickness, this.rectOffyA);
                g.setColor(16771584);
                g.fillRect(this._rectObstacle.x + this._rectObstacle.width - this.obstacleLineThickness, this._rectObstacle.y, this.obstacleLineThickness, this._rectObstacle.height - this.rectOffyA);
                g.setColor(16771584);
                g.fillRect(this._rectObstacle.x + this._rectObstacle.width - this.rectOffxA, this._rectObstacle.y, this.rectOffxA, this.obstacleLineThickness);
                break;
            }
            case 1: {
                g.setColor(16771584);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y, this._rectObstacle.width - this.rectOffxB, this.obstacleLineThickness);
                g.setColor(16771584);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y, this.obstacleLineThickness, this.rectOffyB);
                g.setColor(45298);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y + this.rectOffyB, this.obstacleLineThickness, this._rectObstacle.height - this.rectOffyB);
                g.setColor(45298);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y + this._rectObstacle.height - this.obstacleLineThickness, this.rectOffxB, this.obstacleLineThickness);
                g.setColor(46654);
                g.fillRect(this._rectObstacle.x + this.rectOffxB, this._rectObstacle.y + this._rectObstacle.height - this.obstacleLineThickness, this._rectObstacle.width - this.rectOffxB, this.obstacleLineThickness);
                g.setColor(46654);
                g.fillRect(this._rectObstacle.x + this._rectObstacle.width - this.obstacleLineThickness, this._rectObstacle.y + this._rectObstacle.height - this.rectOffyB, this.obstacleLineThickness, this.rectOffyB);
                g.setColor(16716619);
                g.fillRect(this._rectObstacle.x + this._rectObstacle.width - this.obstacleLineThickness, this._rectObstacle.y, this.obstacleLineThickness, this._rectObstacle.height - this.rectOffyB);
                g.setColor(16716619);
                g.fillRect(this._rectObstacle.x + this._rectObstacle.width - this.rectOffxB, this._rectObstacle.y, this.rectOffxB, this.obstacleLineThickness);
                break;
            }
            case 2: {
                g.setColor(16716619);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y, this._rectObstacle.width - this.rectOffxA, this.obstacleLineThickness);
                g.setColor(16716619);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y, this.obstacleLineThickness, this.rectOffyA);
                g.setColor(16771584);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y + this.rectOffyA, this.obstacleLineThickness, this._rectObstacle.height - this.rectOffyA);
                g.setColor(16771584);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y + this._rectObstacle.height - this.obstacleLineThickness, this.rectOffxA, this.obstacleLineThickness);
                g.setColor(45298);
                g.fillRect(this._rectObstacle.x + this.rectOffxA, this._rectObstacle.y + this._rectObstacle.height - this.obstacleLineThickness, this._rectObstacle.width - this.rectOffxA, this.obstacleLineThickness);
                g.setColor(45298);
                g.fillRect(this._rectObstacle.x + this._rectObstacle.width - this.obstacleLineThickness, this._rectObstacle.y + this._rectObstacle.height - this.rectOffyA, this.obstacleLineThickness, this.rectOffyA);
                g.setColor(46654);
                g.fillRect(this._rectObstacle.x + this._rectObstacle.width - this.obstacleLineThickness, this._rectObstacle.y, this.obstacleLineThickness, this._rectObstacle.height - this.rectOffyA);
                g.setColor(46654);
                g.fillRect(this._rectObstacle.x + this._rectObstacle.width - this.rectOffxA, this._rectObstacle.y, this.rectOffxA, this.obstacleLineThickness);
                break;
            }
            case 3: {
                g.setColor(46654);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y, this._rectObstacle.width - this.rectOffxB, this.obstacleLineThickness);
                g.setColor(46654);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y, this.obstacleLineThickness, this.rectOffyB);
                g.setColor(16716619);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y + this.rectOffyB, this.obstacleLineThickness, this._rectObstacle.height - this.rectOffyB);
                g.setColor(16716619);
                g.fillRect(this._rectObstacle.x, this._rectObstacle.y + this._rectObstacle.height - this.obstacleLineThickness, this.rectOffxB, this.obstacleLineThickness);
                g.setColor(16771584);
                g.fillRect(this._rectObstacle.x + this.rectOffxB, this._rectObstacle.y + this._rectObstacle.height - this.obstacleLineThickness, this._rectObstacle.width - this.rectOffxB, this.obstacleLineThickness);
                g.setColor(16771584);
                g.fillRect(this._rectObstacle.x + this._rectObstacle.width - this.obstacleLineThickness, this._rectObstacle.y + this._rectObstacle.height - this.rectOffyB, this.obstacleLineThickness, this.rectOffyB);
                g.setColor(45298);
                g.fillRect(this._rectObstacle.x + this._rectObstacle.width - this.obstacleLineThickness, this._rectObstacle.y, this.obstacleLineThickness, this._rectObstacle.height - this.rectOffyB);
                g.setColor(45298);
                g.fillRect(this._rectObstacle.x + this._rectObstacle.width - this.rectOffxB, this._rectObstacle.y, this.rectOffxB, this.obstacleLineThickness);
                break;
            }
        }
    }

    private void paintCircleDots(Graphics g) {
        int i;
        int r = this._rectObstacle.width >> 1;
        for (i = 0; i < this._circleDots; ++i) {
            double t = 6.28 * (double)i / (double)this._circleDots;
            double angleInRadians = RMSObjects.game.angleToRadians(this._iAngle);
            double tmp = t + angleInRadians;
            if (tmp > 6.28) {
                tmp -= 6.28;
            }
            int cos = RMSObjects.game.getCOS(tmp -= 3.14);
            int sin = RMSObjects.game.getSIN(tmp);
            int x = (int)((float)r / this.inAndOut * (float)cos / 1000.0f) + 1;
            int y = (int)((float)r / this.inAndOut * (float)sin / 1000.0f) + 1;
            this._rectObstacleCircleDots[i] = new Rectangle(this._rectObstacle.getCenterX() + x - (this.dotSize >> 1), this._rectObstacle.getCenterY() + y - (this.dotSize >> 1), this.dotSize, this.dotSize);
        }
        for (i = 0; i < this._circleDots; ++i) {
            if (i < this._circleDots >> 2) {
                g.setColor(45298);
            } else if (i < this._circleDots >> 1) {
                g.setColor(46654);
            } else if (i < (this._circleDots >> 2) * 3) {
                g.setColor(16716619);
            } else if (i < this._circleDots) {
                g.setColor(16771584);
            }
            g.fillArc(this._rectObstacleCircleDots[i].x, this._rectObstacleCircleDots[i].y, this.dotSize, this.dotSize, 0, 360);
        }
    }

    private int getStartAngle(int _iPos) {
        int _iRetVal = 0;
        if (_iPos == 0) {
            _iRetVal = this._iAngle;
        } else if (_iPos == 1) {
            _iRetVal = this._iAngle + 90 < 360 ? this._iAngle + 90 : this._iAngle + 90 - 360;
        } else if (_iPos == 2) {
            _iRetVal = this._iAngle + 180 < 360 ? this._iAngle + 180 : this._iAngle + 180 - 360;
        } else if (_iPos == 3) {
            _iRetVal = this._iAngle + 270 < 360 ? this._iAngle + 270 : this._iAngle + 270 - 360;
        }
        return _iRetVal;
    }

    private int getStartAngleL(int _iPos) {
        int _iRetVal = 0;
        int temp = 360 - this._iAngle;
        if (_iPos == 0) {
            _iRetVal = temp;
            _iRetVal += 90;
        } else if (_iPos == 1) {
            _iRetVal = temp + 90 < 360 ? temp + 90 : temp + 90 - 360;
            _iRetVal += 90;
        } else if (_iPos == 2) {
            _iRetVal = temp + 180 < 360 ? temp + 180 : temp + 180 - 360;
            _iRetVal += 90;
        } else if (_iPos == 3) {
            _iRetVal = temp + 270 < 360 ? temp + 270 : temp + 270 - 360;
            _iRetVal += 90;
        }
        return _iRetVal;
    }

    public boolean IsCollisions(int _ix, int _iy) {
        if (!this.IsAlive()) {
            return false;
        }
        for (int _iIdx = 0; _iIdx < this._rectCollisions.length; ++_iIdx) {
            if (!this._rectCollisions[_iIdx].contains(_ix, _iy)) continue;
            return true;
        }
        return false;
    }

    public boolean IsCollision(Rectangle _rectCaracter) {
        if (!this.IsAlive()) {
            return false;
        }
        for (int _iIdx = 0; _iIdx < this._rectCollisions.length; ++_iIdx) {
            if (!this._rectCollisions[_iIdx].intersects(_rectCaracter)) continue;
            return true;
        }
        return false;
    }

    public boolean IsCircleCollision(Character Char) {
        if (this._iType == -1) {
            return false;
        }
        Sprite _sprChar = Resources.resSprs[14];
        int _iColorTypeBottom = 0;
        int _iColorTypeTop = 0;
        int[] _iAngles = new int[]{this.getStartAngle(0), this.getStartAngle(1), this.getStartAngle(2), this.getStartAngle(3)};
        double pxPerAngle = (double)(this._rectObstacle.width >> 1) / 90.0;
        double angle = (double)(_sprChar.getWidth() >> 1) / pxPerAngle;
        if ((double)_iAngles[0] + angle < 270.0 && (double)(_iAngles[0] + 90) - angle > 270.0) {
            _iColorTypeBottom = 0;
            _iColorTypeTop = 2;
        } else if ((double)_iAngles[1] + angle < 270.0 && (double)(_iAngles[1] + 90) - angle > 270.0) {
            _iColorTypeBottom = 1;
            _iColorTypeTop = 3;
        } else if ((double)_iAngles[2] + angle < 270.0 && (double)(_iAngles[2] + 90) - angle > 270.0) {
            _iColorTypeBottom = 2;
            _iColorTypeTop = 0;
        } else if ((double)_iAngles[3] + angle < 270.0 && (double)(_iAngles[3] + 90) - angle > 270.0) {
            _iColorTypeBottom = 3;
            _iColorTypeTop = 1;
        } else {
            _iColorTypeBottom = -1;
            _iColorTypeTop = -1;
        }
        if (Char.GetPositionY() < this._rectObstacle.y + (this._rectObstacle.height >> 4) && Char.GetPositionY() + _sprChar.getHeight() > this._rectObstacle.y && Char.GetActualColor() != _iColorTypeTop) {
            this._scrGame.SetGameOver(false);
        }
        if (Char.GetPositionY() < this._rectObstacle.y + this._rectObstacle.height && Char.GetPositionY() + _sprChar.getHeight() > this._rectObstacle.y + this._rectObstacle.height - (this._rectObstacle.height >> 4) && Char.GetActualColor() != _iColorTypeBottom) {
            this._scrGame.SetGameOver(false);
        }
        return false;
    }

    public boolean isLineCollision(Character Char) {
        if (this._iType == -1) {
            return false;
        }
        Sprite _sprChar = Resources.resSprs[14];
        int _iColorType = 0;
        int[] _iAngles = new int[]{this._iAngle, this._iAngle + (MainCanvas.WIDTH >> 2), this._iAngle - (MainCanvas.WIDTH >> 1), this._iAngle - (MainCanvas.WIDTH >> 2)};
        if (this._bLeft) {
            _iAngles = new int[]{this._iAngle - (MainCanvas.WIDTH >> 2), this._iAngle - (MainCanvas.WIDTH >> 1), this._iAngle + (MainCanvas.WIDTH >> 2), this._iAngle};
        }
        _iColorType = _iAngles[0] + (MainCanvas.WIDTH >> 2) > (MainCanvas.WIDTH >> 1) + (_sprChar.getWidth() >> 1) && _iAngles[0] < (MainCanvas.WIDTH >> 1) - (_sprChar.getWidth() >> 1) ? 0 : (_iAngles[1] + (MainCanvas.WIDTH >> 2) > (MainCanvas.WIDTH >> 1) + (_sprChar.getWidth() >> 1) && _iAngles[1] < (MainCanvas.WIDTH >> 1) - (_sprChar.getWidth() >> 1) ? 1 : (_iAngles[2] + (MainCanvas.WIDTH >> 2) > (MainCanvas.WIDTH >> 1) + (_sprChar.getWidth() >> 1) && _iAngles[2] < (MainCanvas.WIDTH >> 1) - (_sprChar.getWidth() >> 1) ? 2 : (_iAngles[3] + (MainCanvas.WIDTH >> 2) > (MainCanvas.WIDTH >> 1) + (_sprChar.getWidth() >> 1) && _iAngles[3] < (MainCanvas.WIDTH >> 1) - (_sprChar.getWidth() >> 1) ? 3 : -1)));
        if (Char.GetPositionY() < this._rectObstacle.y + this._rectObstacle.height && Char.GetPositionY() + _sprChar.getHeight() > this._rectObstacle.y && Char.GetActualColor() != _iColorType) {
            this._scrGame.SetGameOver(false);
        }
        return false;
    }

    public boolean isRectCollision(Character Char) {
        if (this._iType == -1) {
            return false;
        }
        Sprite _sprChar = Resources.resSprs[14];
        int _iColorTypeBottom = 0;
        int _iColorTypeTop = 0;
        int screenWidth = 0;
        screenWidth = this._WIDTH < this._HEIGHT ? this._WIDTH : this._HEIGHT;
        switch (this._iType) {
            case 4: {
                if (this._iAngle > (screenWidth >> 2) * 7 + (_sprChar.getWidth() >> 1) || this._iAngle < (screenWidth >> 2) - (_sprChar.getWidth() >> 1)) {
                    _iColorTypeBottom = 2;
                    _iColorTypeTop = 0;
                    break;
                }
                if (this._iAngle > (screenWidth >> 2) + (_sprChar.getWidth() >> 1) && this._iAngle < (screenWidth >> 2) * 3 - (_sprChar.getWidth() >> 1)) {
                    _iColorTypeBottom = 1;
                    _iColorTypeTop = 3;
                    break;
                }
                if (this._iAngle > (screenWidth >> 2) * 3 + (_sprChar.getWidth() >> 1) && this._iAngle < (screenWidth >> 2) * 5 - (_sprChar.getWidth() >> 1)) {
                    _iColorTypeBottom = 0;
                    _iColorTypeTop = 2;
                    break;
                }
                if (this._iAngle > (screenWidth >> 2) * 5 + (_sprChar.getWidth() >> 1) && this._iAngle < (screenWidth >> 2) * 7 - (_sprChar.getWidth() >> 1)) {
                    _iColorTypeBottom = 3;
                    _iColorTypeTop = 1;
                    break;
                }
                _iColorTypeBottom = -1;
                _iColorTypeTop = -1;
                break;
            }
            case 3: {
                if (this._iAngle > (screenWidth >> 3) * 21 + (_sprChar.getWidth() >> 1) || this._iAngle < (screenWidth >> 3) * 3 - (_sprChar.getWidth() >> 1)) {
                    _iColorTypeBottom = 2;
                    _iColorTypeTop = 0;
                    break;
                }
                if (this._iAngle > (screenWidth >> 3) * 3 + (_sprChar.getWidth() >> 1) && this._iAngle < (screenWidth >> 3) * 9 - (_sprChar.getWidth() >> 1)) {
                    _iColorTypeBottom = 1;
                    _iColorTypeTop = 3;
                    break;
                }
                if (this._iAngle > (screenWidth >> 3) * 9 + (_sprChar.getWidth() >> 1) && this._iAngle < (screenWidth >> 3) * 15 - (_sprChar.getWidth() >> 1)) {
                    _iColorTypeBottom = 0;
                    _iColorTypeTop = 2;
                    break;
                }
                if (this._iAngle > (screenWidth >> 3) * 15 + (_sprChar.getWidth() >> 1) && this._iAngle < (screenWidth >> 3) * 21 - (_sprChar.getWidth() >> 1)) {
                    _iColorTypeBottom = 3;
                    _iColorTypeTop = 1;
                    break;
                }
                _iColorTypeBottom = -1;
                break;
            }
            case 5: {
                if (this._iAngle > (screenWidth >> 1) * 7 + (_sprChar.getWidth() >> 1) || this._iAngle < (screenWidth >> 1) - (_sprChar.getWidth() >> 1)) {
                    _iColorTypeBottom = 2;
                    _iColorTypeTop = 0;
                    break;
                }
                if (this._iAngle > (screenWidth >> 1) + (_sprChar.getWidth() >> 1) && this._iAngle < (screenWidth >> 1) * 3 - (_sprChar.getWidth() >> 1)) {
                    _iColorTypeBottom = 1;
                    _iColorTypeTop = 3;
                    break;
                }
                if (this._iAngle > (screenWidth >> 1) * 3 + (_sprChar.getWidth() >> 1) && this._iAngle < (screenWidth >> 1) * 5 - (_sprChar.getWidth() >> 1)) {
                    _iColorTypeBottom = 0;
                    _iColorTypeTop = 2;
                    break;
                }
                if (this._iAngle > (screenWidth >> 1) * 5 + (_sprChar.getWidth() >> 1) && this._iAngle < (screenWidth >> 1) * 7 - (_sprChar.getWidth() >> 1)) {
                    _iColorTypeBottom = 3;
                    _iColorTypeTop = 1;
                    break;
                }
                _iColorTypeBottom = -1;
                _iColorTypeTop = -1;
            }
        }
        if (Char.GetPositionY() < this._rectObstacle.y + this.obstacleLineThickness && Char.GetPositionY() + _sprChar.getHeight() > this._rectObstacle.y && Char.GetActualColor() != _iColorTypeTop) {
            this._scrGame.SetGameOver(false);
        }
        if (Char.GetPositionY() < this._rectObstacle.y + this._rectObstacle.height && Char.GetPositionY() + _sprChar.getHeight() > this._rectObstacle.y + this._rectObstacle.height - this.obstacleLineThickness && Char.GetActualColor() != _iColorTypeBottom) {
            this._scrGame.SetGameOver(false);
        }
        return false;
    }

    public boolean isCircleDotsCollision(Character Char) {
        if (this._iType == -1) {
            return false;
        }
        int iColorType = 0;
        for (int i = 0; i < this._circleDots; ++i) {
            if (i < this._circleDots >> 2) {
                iColorType = 0;
            } else if (i < this._circleDots >> 1) {
                iColorType = 1;
            } else if (i < (this._circleDots >> 2) * 3) {
                iColorType = 2;
            } else if (i < this._circleDots) {
                iColorType = 3;
            } else {
                this._iColorType = -1;
            }
            if (!Char.getCharacterRect().intersects(this._rectObstacleCircleDots[i]) || Char.GetActualColor() == iColorType) continue;
            this._scrGame.SetGameOver(false);
        }
        return false;
    }

    public boolean isDoubleCircleCollision(Character Char) {
        if (this._iType == -1) {
            return false;
        }
        Sprite _sprChar = Resources.resSprs[14];
        int _iColorType = 0;
        int[] _iAngles = new int[]{this.getStartAngle(0), this.getStartAngle(1), this.getStartAngle(2), this.getStartAngle(3)};
        if (Char.GetPositionY() + (_sprChar.getHeight() >> 1) > this._rectObstacle.y + (this._rectObstacle.height >> 3) * 3 && Char.GetPositionY() + (_sprChar.getHeight() >> 1) < this._rectObstacle.y + (this._rectObstacle.height >> 3) * 5) {
            double pxPerAngle;
            int tmp = Char.GetPositionY() + (_sprChar.getHeight() >> 1) - this._rectObstacle.y - (this._rectObstacle.height >> 3) * 3;
            double angle = (double)tmp / (pxPerAngle = (double)(this._rectObstacle.width >> 2) / 90.0);
            if ((double)_iAngles[0] < 225.0 - angle && (double)(_iAngles[0] + 90) > 225.0 - angle) {
                _iColorType = 2;
            } else if ((double)_iAngles[1] < 225.0 - angle && (double)(_iAngles[1] + 90) > 225.0 - angle) {
                _iColorType = 1;
            } else if ((double)_iAngles[2] < 225.0 - angle && (double)(_iAngles[2] + 90) > 225.0 - angle) {
                _iColorType = 0;
            } else if ((double)_iAngles[3] < 225.0 - angle && (double)(_iAngles[3] + 90) > 225.0 - angle) {
                _iColorType = 3;
            }
            if (Char.GetActualColor() != _iColorType) {
                this._scrGame.SetGameOver(false);
            }
        }
        return false;
    }

    public boolean IsAlive() {
        return this._bIsAlive;
    }

    public boolean IsSwitcherAlive() {
        return this._bIsSwitcherAlive;
    }

    public boolean IsStarAlive() {
        return this._bIsStarAlive;
    }

    public int GetX() {
        return this._rectObstacle.x;
    }

    public int GetY() {
        return this._rectObstacle.y;
    }

    public void SetX(int x) {
        this._rectObstacle.x = x;
    }

    public void SetY(int y) {
        this._rectObstacle.y = y;
    }

    public int GetWidth() {
        return this._rectObstacle.width;
    }

    public int GetHeight() {
        return this._rectObstacle.height;
    }

    public int GetPositionForNext() {
        if (ScreenMenu.getSelectedMode() != 2) {
            return this._rectColorSwitcher.y - this._rectColorSwitcher.height;
        }
        return this._rectColorSwitcher.y + this._rectColorSwitcher.height;
    }

    static {
        posYforBestScore = -1;
    }

    public class ObstaclesVars {
        int[] _iAngles;
        boolean[] _bLeft;
    }
}

