/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Character;
import sk.inlogic.Levels;
import sk.inlogic.MainCanvas;
import sk.inlogic.Obstacle;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Game
implements RMSHandler {
    private static final int _STATUS_INITLEVEL = 0;
    private static final int _STATUS_READY = 1;
    private static final int _STATUS_LEVELDONE = 2;
    private static final int _STATUS_GAMEOVER = 3;
    public static final int _MOVE_NONE = 0;
    public static final int _MOVE_UP = 1;
    public static final int _MOVE_DOWN = 2;
    public static final int _MOVE_LEFT = 3;
    public static final int _MOVE_RIGHT = 4;
    public static final int _INPUT_FREE = 0;
    public static final int _INPUT_SELECT = 1;
    public static final int _INPUT_LUMP = 2;
    public static Rectangle _rectGameArea;
    private Rectangle rectRightFk;
    private Sprite _sprBtnMenu;
    private static int start;
    private static int end;
    private static final int countOfObstaclesForArcadeMode = 3;
    private static boolean flagForChangeCharacterColor;
    private static boolean isGameStarted;
    private static boolean isColorChanged;
    private boolean flag = false;
    private long timerForColorSwitcher = 0L;
    private Sprite _spr123;
    private int[] _arrSprites;
    private int _iInputState;
    private int _iStatus;
    private int _iScore;
    private Obstacle[] _scrObstacles;
    private Character _scrCharacter;
    private int[] _iWorld;
    private Levels _lActuallevel;
    private PreparedText _tapToStart;
    private PreparedText _ptNumber;
    private long currentTime = 0L;
    private boolean PauseTimer = false;
    private static PreparedText _ptPauseTimer;
    private int _iTmpColor;
    private final int _COLOR_BLUE;
    private final int _COLOR_GREEN;
    private final int _COLOR_RED;
    private final int _COLOR_YELLOW;
    private boolean flagForArcade = false;
    private int index;
    private boolean isFirstExe = true;
    private int _iScoreInc = 0;
    private int _iScoreDelimiter = 2;
    private boolean _pressed = false;
    private int _arcadeBestScore = 0;
    private int ingameScore = 0;
    private int scoresCount = 0;
    static int[] SIN_TABLE;
    static int[] COS_TABLE;

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public void setPauseTimer(boolean PauseTimer) {
        this.PauseTimer = PauseTimer;
    }

    public Game() {
        this._COLOR_BLUE = 45298;
        this._COLOR_GREEN = 46654;
        this._COLOR_RED = 16716619;
        this._COLOR_YELLOW = 16771584;
        this.init();
    }

    private void init() {
        this._sprBtnMenu = Resources.resSprs[5];
        this.rectRightFk = new Rectangle(MainCanvas.WIDTH - this._sprBtnMenu.getWidth(), MainCanvas.HEIGHT - this._sprBtnMenu.getHeight(), this._sprBtnMenu.getWidth(), this._sprBtnMenu.getHeight());
        this._tapToStart = new PreparedText(Resources.resGFonts[0]);
        this._ptNumber = new PreparedText(Resources.resGFonts[0]);
        _ptPauseTimer = new PreparedText(Resources.resGFonts[2]);
        this._arrSprites = new int[]{32};
        Resources.loadSprites(this._arrSprites);
        this._spr123 = Resources.resSprs[32];
    }

    public void restartGame(Levels _levels, Rectangle _rectArea, int mode, boolean _bFirstTimePlaying, int _iSelectedCharacter) {
        Obstacle.setArcadeModeFlag(false);
        this._lActuallevel = _levels;
        this.init();
        this._iWorld = !ScreenMenu.isArcadeMode() ? new int[this._lActuallevel._iObstacles.length + 1] : new int[3];
        this._iStatus = 0;
        _rectGameArea = _rectArea;
        this.createWorld();
        this.createCharacter(_iSelectedCharacter);
        this._iScore = 0;
        this._iStatus = 1;
        this._iInputState = 0;
    }

    private void createWorld() {
        this.flagForArcade = false;
        if (ScreenMenu.isArcadeMode()) {
            this._scrObstacles = new Obstacle[3];
            this._scrObstacles[0] = new Obstacle(this, 0, 0, this._scrObstacles.length);
            RandomNum rand = new RandomNum();
            for (int _iIdx = 1; _iIdx < this._scrObstacles.length; ++_iIdx) {
                this._scrObstacles[_iIdx] = new Obstacle(this, RandomNum.getRandomUInt(9), _iIdx, this._scrObstacles.length);
                this._scrObstacles[_iIdx].setFlagForBestScoreLine(false);
            }
            this.loadBestScore();
            this.isFirstExe = true;
        } else {
            switch (ScreenMenu.getSelectedMode()) {
                case 0: {
                    this._scrObstacles = new Obstacle[this._lActuallevel._iObstacles.length + 1];
                    for (int _iIdx = 0; _iIdx < this._lActuallevel._iObstacles.length; ++_iIdx) {
                        this._scrObstacles[_iIdx] = new Obstacle(this, this._lActuallevel._iObstacles[_iIdx], _iIdx, this._scrObstacles.length);
                    }
                    this._scrObstacles[this._lActuallevel._iObstacles.length] = new Obstacle(this, -1, this._lActuallevel._iObstacles.length, this._scrObstacles.length);
                    break;
                }
                case 1: {
                    this.timerForColorSwitcher = System.currentTimeMillis();
                    start = 5000;
                    end = 8000;
                    flagForChangeCharacterColor = false;
                    isColorChanged = true;
                    this.flag = false;
                    this._scrObstacles = new Obstacle[this._lActuallevel._iObstacles.length + 1];
                    for (int _iIdx = 0; _iIdx < this._lActuallevel._iObstacles.length; ++_iIdx) {
                        this._scrObstacles[_iIdx] = new Obstacle(this, this._lActuallevel._iObstacles[_iIdx], _iIdx, this._scrObstacles.length);
                    }
                    this._scrObstacles[this._lActuallevel._iObstacles.length] = new Obstacle(this, -1, this._lActuallevel._iObstacles.length, this._scrObstacles.length);
                    break;
                }
                case 2: {
                    this._scrObstacles = new Obstacle[this._lActuallevel._iObstacles.length + 1];
                    for (int _iIdx = 0; _iIdx < this._lActuallevel._iObstacles.length; ++_iIdx) {
                        this._scrObstacles[_iIdx] = new Obstacle(this, this._lActuallevel._iObstacles[_iIdx], _iIdx, this._scrObstacles.length);
                    }
                    this._scrObstacles[this._lActuallevel._iObstacles.length] = new Obstacle(this, -1, this._lActuallevel._iObstacles.length, this._scrObstacles.length);
                    break;
                }
            }
        }
    }

    private void createCharacter(int _iSelectedCharacter) {
        this._scrCharacter = new Character(this, _iSelectedCharacter);
    }

    private void setNewRandomColor() {
        this._iTmpColor = RandomNum.getRandomInt(4, 0);
        if (this._iTmpColor < 0) {
            this._iTmpColor *= -1;
        }
        if (this._scrCharacter.GetActualColor() == this._iTmpColor) {
            this.setNewRandomColor();
        }
    }

    public void showColorIndicator(Graphics g) {
        switch (this._iTmpColor) {
            case 0: {
                g.setColor(45298);
                break;
            }
            case 1: {
                g.setColor(46654);
                break;
            }
            case 2: {
                g.setColor(16716619);
                break;
            }
            case 3: {
                g.setColor(16771584);
                break;
            }
        }
        g.fillRect(0, 0, MainCanvas.WIDTH / 40, MainCanvas.HEIGHT);
        g.fillRect(MainCanvas.WIDTH - MainCanvas.WIDTH / 40, 0, MainCanvas.WIDTH / 40, MainCanvas.HEIGHT);
    }

    public int getCountOfObstaclesForArcadeMode() {
        return 3;
    }

    public void update(long lastRunLenght) {
        if (!this.PauseTimer) {
            int _iIdx;
            if (this._iStatus == 1) {
                // empty if block
            }
            if (!ScreenMenu.isArcadeMode()) {
                for (_iIdx = 0; _iIdx < this._scrObstacles.length; ++_iIdx) {
                    this._scrObstacles[_iIdx].Update(lastRunLenght, this._scrCharacter);
                }
            } else {
                for (_iIdx = 0; _iIdx < this._scrObstacles.length; ++_iIdx) {
                    this._scrObstacles[_iIdx].Update(lastRunLenght, this._scrCharacter);
                }
                if (RMSObjects.game.getScore() + 1 >= RMSObjects.game.getArcadeBestScore() && RMSObjects.game.getArcadeBestScore() != 0 && !Obstacle.getFlagForBestScoreLine() && this.isFirstExe && this._iStatus != 3) {
                    int position = 0;
                    if (this._scrObstacles[0].GetY() > 0 && this._scrObstacles[0].GetY() < MainCanvas.HEIGHT) {
                        position = 1;
                    }
                    if (this._scrObstacles[1].GetY() > 0 && this._scrObstacles[0].GetY() < MainCanvas.HEIGHT) {
                        position = 2;
                    }
                    if (this._scrObstacles[2].GetY() > 0 && this._scrObstacles[0].GetY() < MainCanvas.HEIGHT) {
                        position = 0;
                    }
                    this._scrObstacles[position].setFlagForBestScoreLine(true);
                    this.isFirstExe = false;
                    this.index = position;
                }
            }
            RandomNum rand = new RandomNum();
            if (this._scrObstacles[0].GetY() > MainCanvas.HEIGHT && ScreenMenu.isArcadeMode()) {
                this.flagForArcade = true;
            }
            if (this.flagForArcade) {
                if (this._scrObstacles[0].GetY() > MainCanvas.HEIGHT) {
                    this._scrObstacles[0] = new Obstacle(this, RandomNum.getRandomUInt(9), 0, this._scrObstacles.length);
                }
                if (this._scrObstacles[1].GetY() > MainCanvas.HEIGHT) {
                    this._scrObstacles[1] = new Obstacle(this, RandomNum.getRandomUInt(9), 1, this._scrObstacles.length);
                }
                if (this._scrObstacles[2].GetY() > MainCanvas.HEIGHT) {
                    this._scrObstacles[2] = new Obstacle(this, RandomNum.getRandomUInt(9), 2, this._scrObstacles.length);
                }
            }
            this._scrCharacter.Update(lastRunLenght);
            if (ScreenMenu.getSelectedMode() != 2) {
                if (this._scrCharacter.GetPositionY() < MainCanvas.HEIGHT >> 1) {
                    for (int _iIdx2 = 0; _iIdx2 < this._scrObstacles.length; ++_iIdx2) {
                        this._scrObstacles[_iIdx2].ScrollDown(this._scrCharacter);
                        if (_iIdx2 != this.index) continue;
                        this._scrObstacles[_iIdx2].scrollDownBestScoreLine();
                    }
                }
            } else if (this._scrCharacter.GetPositionY() > MainCanvas.HEIGHT >> 1) {
                for (int _iIdx3 = 0; _iIdx3 < this._scrObstacles.length; ++_iIdx3) {
                    this._scrObstacles[_iIdx3].ScrollUp(this._scrCharacter);
                }
                this._scrCharacter.SetPositionY(MainCanvas.HEIGHT >> 1);
            }
            Particles.update();
            this.updateScore();
            if (ScreenMenu.getSelectedMode() == 1) {
                this.updateTimer();
            }
        }
    }

    private void paintPauseTimer(Graphics g) {
        String s = "";
        if (System.currentTimeMillis() > this.currentTime && System.currentTimeMillis() < this.currentTime + 1000L) {
            this._spr123.setFrame(2);
        } else if (System.currentTimeMillis() > this.currentTime + 1000L && System.currentTimeMillis() < this.currentTime + 2000L) {
            this._spr123.setFrame(1);
        } else if (System.currentTimeMillis() > this.currentTime + 2000L && System.currentTimeMillis() < this.currentTime + 3000L) {
            this._spr123.setFrame(0);
        }
        if (System.currentTimeMillis() > this.currentTime + 3000L) {
            this.PauseTimer = false;
            return;
        }
        Rectangle rect = new Rectangle(0, (MainCanvas.HEIGHT >> 1) - (this._spr123.getHeight() >> 1), MainCanvas.WIDTH, this._spr123.getHeight());
        this._spr123.setPosition(rect.getCenterX() - (this._spr123.getWidth() >> 1), rect.y);
        this._spr123.paint(g);
    }

    private void updateTimer() {
        if (isGameStarted) {
            if (this.timerForColorSwitcher + (long)start < System.currentTimeMillis() && this.timerForColorSwitcher + (long)end > System.currentTimeMillis()) {
                if (!isColorChanged) {
                    this.setNewRandomColor();
                    isColorChanged = true;
                }
                if (this.timerForColorSwitcher + (long)start < System.currentTimeMillis() && this.timerForColorSwitcher + (long)start + 500L > System.currentTimeMillis() || this.timerForColorSwitcher + (long)start + 1000L < System.currentTimeMillis() && this.timerForColorSwitcher + (long)start + 1500L > System.currentTimeMillis() || this.timerForColorSwitcher + (long)start + 2000L < System.currentTimeMillis() && this.timerForColorSwitcher + (long)start + 2500L > System.currentTimeMillis()) {
                    flagForChangeCharacterColor = true;
                }
                if (this.timerForColorSwitcher + (long)start + 500L < System.currentTimeMillis() && this.timerForColorSwitcher + (long)start + 750L > System.currentTimeMillis() || this.timerForColorSwitcher + (long)start + 1500L < System.currentTimeMillis() && this.timerForColorSwitcher + (long)start + 1750L > System.currentTimeMillis() || this.timerForColorSwitcher + (long)start + 2500L < System.currentTimeMillis() && this.timerForColorSwitcher + (long)start + 2750L > System.currentTimeMillis()) {
                    flagForChangeCharacterColor = false;
                }
                this.flag = true;
            } else {
                flagForChangeCharacterColor = false;
                isColorChanged = false;
            }
            if (this.flag && !isColorChanged) {
                this._scrCharacter.ChangeColorForColorSwapMode(this._iTmpColor);
                start += 5000;
                end += 5000;
                this.flag = false;
            }
        }
    }

    private void updateScore() {
        if (this._iScoreInc <= 0) {
            return;
        }
        if (this._iScoreInc > 0) {
            if (this._iScoreInc % this._iScoreDelimiter == 0) {
                this.incScoreLocal(this._iScoreInc / this._iScoreDelimiter);
                this._iScoreInc -= this._iScoreInc / this._iScoreDelimiter;
            } else {
                this.incScoreLocal(this._iScoreInc % this._iScoreDelimiter);
                this._iScoreInc -= this._iScoreInc % this._iScoreDelimiter;
            }
        }
    }

    public void incScore(int _iValue) {
        this._iScoreInc += _iValue;
    }

    private void incScoreLocal(int _iValue) {
        this._iScore += _iValue;
    }

    private void updateMove() {
    }

    public void createParticles(int _iIdx) {
    }

    public int getParticleColor(int _iType) {
        switch (_iType) {
            case 1: {
                return 2782763;
            }
            case 2: {
                return 13148974;
            }
            case 3: {
                return 6335460;
            }
            case 4: {
                return 15623219;
            }
            case 5: {
                return 4875724;
            }
            case 6: {
                return 9125803;
            }
            case 7: {
                return 13977707;
            }
            case 8: {
                return 13554237;
            }
            case 9: {
                return 12397104;
            }
            case 10: {
                return 5680427;
            }
            case 11: {
                return 12707816;
            }
            case 12: {
                return 3623030;
            }
            case 13: {
                return 1314;
            }
        }
        return 1314;
    }

    private boolean checkGameOver(int _iX, int _iY) {
        return false;
    }

    public void paint(Graphics g, int status) {
        this.paintObstacles(g);
        this.paintCharacter(g);
        if (flagForChangeCharacterColor) {
            this.showColorIndicator(g);
        }
        if (this.PauseTimer) {
            this.paintPauseTimer(g);
        }
    }

    private void paintObstacles(Graphics g) {
        for (int _iIdx = 0; _iIdx < this._scrObstacles.length; ++_iIdx) {
            this._scrObstacles[_iIdx].Paint(g);
        }
    }

    private void paintCharacter(Graphics g) {
        this._scrCharacter.Paint(g);
    }

    private void checkScore() {
    }

    public void DragOrDrop() {
    }

    public void releaaseControls() {
        this._pressed = false;
    }

    public void pointerPressed(int x, int y) {
        if (!this._pressed && !this.rectRightFk.contains(x, y)) {
            this._pressed = true;
            this.Jump();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this._pressed) {
            this._pressed = false;
        }
    }

    public void Jump() {
        RMSObjects.game.GetCharacter().setDoubleJump(1);
        this._scrCharacter.Jump();
        if (!isGameStarted && ScreenMenu.getSelectedMode() == 1) {
            isGameStarted = true;
            this.timerForColorSwitcher = System.currentTimeMillis();
            start = 5000;
            end = 8000;
        }
    }

    public void resetTimer() {
        isGameStarted = false;
    }

    public int getScore() {
        return this._iScore;
    }

    public boolean isGameOver() {
        return this._iStatus == 3;
    }

    public void SetGameOver(boolean _bWin) {
        this._iStatus = !_bWin ? 3 : 2;
        Obstacle.setArcadeModeFlag(false);
        flagForChangeCharacterColor = false;
        isGameStarted = false;
        if (ScreenMenu.isArcadeMode()) {
            this.saveBestScore();
            this.loadBestScore();
        }
        this.saveStars();
        this.loadStars();
    }

    public int getArcadeBestScore() {
        return this._arcadeBestScore;
    }

    public int getIngameScore() {
        return this.ingameScore;
    }

    public void loadStars() {
        Vector scores = RMSObjects.localScores.getScoresForGame(0);
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].load()) {
            RMSObjects.rmsConnects[0].create();
        }
        if (scores != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this.scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this.ingameScore = scoreItem.scoreValue;
        }
    }

    public void saveStars() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        scoreItem.scoreValue = this.ingameScore + RMSObjects.game.getScore();
        RMSObjects.localScores.userName = Integer.toString(0);
        RMSObjects.localScores.insertScoreItem(scoreItem, 0);
        if (!RMSObjects.rmsConnects[0].isExist()) {
            RMSObjects.rmsConnects[0].create();
        }
        RMSObjects.rmsConnects[0].save();
    }

    public void loadBestScore() {
        PowV2ScoreItem scoreItem;
        Vector scores = RMSObjects.bestScores.getScoresForGame(0);
        RMSObjects.createRMSConnect(1);
        if (!RMSObjects.rmsConnects[1].load()) {
            RMSObjects.rmsConnects[1].create();
            scoreItem = new PowV2ScoreItem();
            scoreItem.powGameId = 0;
            scoreItem.scorePos = 0;
            scoreItem.userName = Integer.toString(0);
            scoreItem.scoreValue = 0;
            RMSObjects.bestScores.userName = Integer.toString(0);
            RMSObjects.bestScores.insertBestScoreItem(scoreItem, 0);
            RMSObjects.rmsConnects[1].save();
        }
        if (scores != null) {
            this.scoresCount = scores.size();
        }
        scoreItem = null;
        if (this.scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this._arcadeBestScore = scoreItem.scoreValue;
        }
    }

    public void saveBestScore() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        scoreItem.scoreValue = this._iScore;
        RMSObjects.bestScores.userName = Integer.toString(0);
        RMSObjects.bestScores.insertBestScoreItem(scoreItem, 0);
        if (!RMSObjects.rmsConnects[1].isExist()) {
            RMSObjects.rmsConnects[1].create();
        }
        RMSObjects.rmsConnects[1].save();
    }

    public void UnlockLevel() {
        this._iScore = 10;
        this._iStatus = 2;
    }

    public boolean isLevelDone() {
        return this._iStatus == 2;
    }

    public boolean isInitGame() {
        Obstacle.setArcadeModeFlag(false);
        return this._iStatus == 0;
    }

    public Obstacle[] GetObstacles() {
        return this._scrObstacles;
    }

    public Obstacle GetObstacle(int _iOrder) {
        if (_iOrder > this._lActuallevel._iObstacles.length - 1) {
            return null;
        }
        return this._scrObstacles[_iOrder];
    }

    public Character GetCharacter() {
        return this._scrCharacter;
    }

    public int GetCharacterColor() {
        return this._scrCharacter.GetActualColor();
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
    }

    public int getSIN(double dAngle) {
        int pom = 0;
        if (dAngle >= 0.0 && dAngle < 1.57) {
            pom = (int)(dAngle * 100.0);
            return SIN_TABLE[pom];
        }
        if (dAngle >= 1.57 && dAngle <= 3.14) {
            pom = (int)((dAngle - 1.57) * 100.0);
            return COS_TABLE[pom];
        }
        if (dAngle >= -3.14 && dAngle < -1.57) {
            pom = (int)((-dAngle - 1.57) * 100.0);
            return -COS_TABLE[pom];
        }
        if (dAngle >= -1.57 && dAngle < 0.0) {
            pom = (int)(-dAngle * 100.0);
            return -SIN_TABLE[pom];
        }
        return 0;
    }

    public int getCOS(double dAngle) {
        int pom = 0;
        if (dAngle >= 0.0 && dAngle < 1.57) {
            pom = (int)(dAngle * 100.0);
            return COS_TABLE[pom];
        }
        if (dAngle >= 1.57 && dAngle <= 3.14) {
            pom = (int)((dAngle - 1.57) * 100.0);
            return -SIN_TABLE[pom];
        }
        if (dAngle >= -3.14 && dAngle < -1.57) {
            pom = (int)((-dAngle - 1.57) * 100.0);
            return -SIN_TABLE[pom];
        }
        if (dAngle >= -1.57 && dAngle < 0.0) {
            pom = (int)(-dAngle * 100.0);
            return COS_TABLE[pom];
        }
        return 0;
    }

    public double angleToRadians(int angle) {
        return (double)angle * 3.14 / 180.0;
    }

    static {
        start = 5000;
        end = 8000;
        flagForChangeCharacterColor = false;
        isGameStarted = false;
        isColorChanged = false;
        SIN_TABLE = new int[]{0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140, 149, 159, 169, 179, 189, 199, 208, 218, 228, 238, 247, 257, 267, 276, 286, 296, 305, 315, 324, 333, 343, 352, 362, 371, 380, 389, 399, 408, 417, 426, 435, 444, 453, 462, 471, 479, 488, 497, 506, 514, 523, 531, 540, 548, 556, 565, 573, 581, 589, 597, 605, 613, 621, 629, 637, 644, 652, 659, 667, 674, 682, 689, 696, 703, 710, 717, 724, 731, 738, 745, 751, 758, 764, 771, 777, 783, 790, 796, 802, 808, 813, 819, 825, 830, 836, 841, 847, 852, 857, 862, 867, 872, 877, 882, 887, 891, 896, 900, 904, 909, 913, 917, 921, 925, 928, 932, 936, 939, 942, 946, 949, 952, 955, 958, 961, 964, 966, 969, 971, 973, 976, 978, 980, 982, 984, 985, 987, 989, 990, 991, 993, 994, 995, 996, 997, 997, 998, 999, 999, 1000, 1000, 1000, 1000};
        COS_TABLE = new int[]{1000, 1000, 1000, 1000, 999, 999, 998, 998, 997, 996, 995, 994, 993, 992, 990, 989, 987, 986, 984, 982, 980, 978, 976, 974, 971, 969, 966, 964, 961, 958, 955, 952, 949, 946, 943, 939, 936, 932, 929, 925, 921, 917, 913, 909, 905, 900, 896, 892, 887, 882, 878, 873, 868, 863, 858, 853, 847, 842, 836, 831, 825, 820, 814, 808, 802, 796, 790, 784, 778, 771, 765, 758, 752, 745, 738, 732, 725, 718, 711, 704, 697, 689, 682, 675, 667, 660, 652, 645, 637, 629, 622, 614, 606, 598, 590, 582, 574, 565, 557, 549, 540, 532, 523, 515, 506, 498, 489, 480, 471, 462, 454, 445, 436, 427, 418, 408, 399, 390, 381, 372, 362, 353, 344, 334, 325, 315, 306, 296, 287, 277, 267, 258, 248, 238, 229, 219, 209, 199, 190, 180, 170, 160, 150, 140, 130, 121, 111, 101, 91, 81, 71, 61, 51, 41, 31, 21, 11, 1};
    }
}

