/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Game;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Character {
    private boolean _bIsAlive = false;
    private final int _STATE_INIT;
    private final int _STATE_JUMP;
    private final int _STATE_FALL;
    private final int _STATE_WAIT;
    private final int _STATE_COLLISION;
    private final int _COLOR_NONE;
    private final int _COLOR_BLUE;
    private final int _COLOR_GREEN;
    private final int _COLOR_RED;
    private final int _COLOR_YELLOW;
    public int _iState = -1;
    int _iType;
    int _iActualColor = 0;
    int _iPositionX;
    int _iPositionY;
    int _iPositionYFallOffset = MainCanvas.HEIGHT / 100;
    int _iPositionYJumpOffset = 10;
    int _iAngle = 0;
    private int _iShiftY = 0;
    public int _iOffsetY = 0;
    private int _iTmpShift = 40;
    private int _iTmpPositionY = 0;
    private int _iTmpDefaultPositionY = 0;
    private Rectangle _rectCharacter;
    private Sprite _sprCharacter;
    private Sprite _sprCharacterBlue;
    private Sprite _sprCharacterGreen;
    private Sprite _sprCharacterRed;
    private Sprite _sprCharacterYellow;
    private Game _scrGame;
    int _iCount = 10;
    public int doubleJump = 0;

    public Character(Game _scrgame, int _itype) {
        this._STATE_INIT = 0;
        this._STATE_JUMP = 1;
        this._STATE_FALL = 2;
        this._STATE_WAIT = 3;
        this._STATE_COLLISION = 4;
        this._COLOR_NONE = -1;
        this._COLOR_BLUE = 0;
        this._COLOR_GREEN = 1;
        this._COLOR_RED = 2;
        this._COLOR_YELLOW = 3;
        this._iType = _itype;
        this._scrGame = _scrgame;
        this._iActualColor = -1;
        this.SetState(0);
        this.setCharacterSprite();
        this.ChangeColor();
        this.calculateCharacter();
        this._bIsAlive = true;
    }

    public Character(int _itype) {
        this._STATE_INIT = 0;
        this._STATE_JUMP = 1;
        this._STATE_FALL = 2;
        this._STATE_WAIT = 3;
        this._STATE_COLLISION = 4;
        this._COLOR_NONE = -1;
        this._COLOR_BLUE = 0;
        this._COLOR_GREEN = 1;
        this._COLOR_RED = 2;
        this._COLOR_YELLOW = 3;
        this._iType = _itype;
        this._iActualColor = -1;
        this.SetState(0);
        this.setCharacterSprite();
        this.ChangeColor();
        this.calculateCharacter();
        this._bIsAlive = true;
    }

    private void setCharacterSprite() {
        Resources.loadSprites(new int[]{15, 16, 17, 18});
        this._sprCharacterBlue = Resources.resSprs[15];
        this._sprCharacterBlue.setFrame(this._iType);
        this._sprCharacterYellow = Resources.resSprs[16];
        this._sprCharacterYellow.setFrame(this._iType);
        this._sprCharacterRed = Resources.resSprs[17];
        this._sprCharacterRed.setFrame(this._iType);
        this._sprCharacterGreen = Resources.resSprs[18];
        this._sprCharacterGreen.setFrame(this._iType);
    }

    public void ChangeColor() {
        int _iTmpColor;
        int lastColor = this._iActualColor;
        this._iActualColor = _iTmpColor = RandomNum.getRandomUInt(4);
        if (lastColor == this._iActualColor) {
            this.ChangeColor();
        } else {
            this.setSpriteByColor();
        }
    }

    public void ChangeColorForColorSwapMode(int _iTmpColor) {
        if (_iTmpColor < 0) {
            _iTmpColor *= -1;
        }
        this._iActualColor = _iTmpColor;
        this.setSpriteByColor();
    }

    private void setSpriteByColor() {
        switch (this._iActualColor) {
            case 0: {
                this._sprCharacter = this._sprCharacterBlue;
                return;
            }
            case 1: {
                this._sprCharacter = this._sprCharacterGreen;
                return;
            }
            case 2: {
                this._sprCharacter = this._sprCharacterRed;
                return;
            }
            case 3: {
                this._sprCharacter = this._sprCharacterYellow;
                return;
            }
        }
        this.ChangeColor();
    }

    private void calculateCharacter() {
        this._rectCharacter = ScreenMenu.getSelectedMode() != 2 ? new Rectangle((MainCanvas.WIDTH >> 1) - (this._sprCharacter.getWidth() >> 1), MainCanvas.HEIGHT - (this._sprCharacter.getHeight() << 1), this._sprCharacter.getWidth(), this._sprCharacter.getHeight()) : new Rectangle((MainCanvas.WIDTH >> 1) - (this._sprCharacter.getWidth() >> 1), this._sprCharacter.getHeight() << 2, this._sprCharacter.getWidth(), this._sprCharacter.getHeight());
    }

    public void Jump() {
        this.SetState(1);
    }

    public void Update(long lastRunLenght) {
        if (!this.IsAlive()) {
            return;
        }
        this.updateCharacterBehavioar();
    }

    private void updateCharacterBehavioar() {
        switch (this._iState) {
            case 0: {
                return;
            }
            case 1: {
                this.updateJump();
                return;
            }
            case 2: {
                this.updateFall();
                return;
            }
            case 3: {
                this.updateWait();
                return;
            }
        }
    }

    private void updateJump() {
        if (this.updateMoveUp()) {
            return;
        }
        this.SetState(3);
    }

    private void updateWait() {
        this.SetState(2);
    }

    private void updateFall() {
        this._rectCharacter.y += this._iPositionYFallOffset;
        if (this._rectCharacter.y >= MainCanvas.HEIGHT) {
            this._scrGame.SetGameOver(false);
        }
    }

    public void setDoubleJump(int doubleJump) {
        this.doubleJump += doubleJump;
        if (this.doubleJump > 2) {
            this.doubleJump = 2;
        }
        this._iCount = 10;
    }

    private boolean updateMoveUp() {
        if (this._iCount > 0) {
            --this._iCount;
            this._rectCharacter.y = this.doubleJump == 2 ? (int)((double)this._rectCharacter.y - (double)(MainCanvas.HEIGHT / 9 / 10) * 1.5) : (this._rectCharacter.y -= MainCanvas.HEIGHT / 9 / 10);
            this._rectCharacter.y += this._iOffsetY;
            this._iOffsetY = 0;
            if (this._rectCharacter.y < -this._rectCharacter.height && ScreenMenu.getSelectedMode() == 2) {
                this._scrGame.SetGameOver(false);
            }
            return true;
        }
        this._iOffsetY = 0;
        this.doubleJump = 0;
        this._iCount = 10;
        return false;
    }

    public void Paint(Graphics g) {
        if (!this.IsAlive()) {
            return;
        }
        this._sprCharacter.setPosition(this._rectCharacter.x, this._rectCharacter.y);
        this._sprCharacter.paint(g);
    }

    public void SetState(int _iNewState) {
        if (_iNewState == this._iState) {
            return;
        }
        this._iState = _iNewState;
    }

    public boolean IsAlive() {
        return this._bIsAlive;
    }

    public int GetActualColor() {
        return this._iActualColor;
    }

    public int GetPositionX() {
        return this._rectCharacter.x;
    }

    public int GetPositionY() {
        return this._rectCharacter.y;
    }

    public void SetPositionX(int _iX) {
        this._rectCharacter.x = _iX;
    }

    public void SetPositionY(int _iY) {
        this._rectCharacter.y = _iY;
    }

    public Rectangle getCharacterRect() {
        return this._rectCharacter;
    }
}

