/*
 * Decompiled with CFR 0.152.
 */
package subgame;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import subgame.MenuOption;
import subgame.SubGameCanvas;

public class Menu {
    MenuOption[] options;
    int currentSelection;
    float sinCounter;
    Font menuFont;

    public Menu(int maxOptions) {
        this.options = new MenuOption[maxOptions];
        this.sinCounter = 0.0f;
        this.currentSelection = 0;
        this.menuFont = Font.getFont((int)32, (int)0, (int)16);
    }

    public void addOption(String n, int t) {
        for (int i = 0; i < this.options.length; ++i) {
            if (this.options[i] != null) continue;
            this.options[i] = new MenuOption(n, t);
            return;
        }
    }

    public void render(Graphics g, SubGameCanvas c) {
        this.sinCounter = (float)((double)this.sinCounter + 0.05);
        for (int i = 0; i < this.options.length; ++i) {
            if (g.getFont() != this.menuFont) {
                g.setFont(this.menuFont);
                g.setColor(0, 0, 0);
            }
            if (i == this.currentSelection) {
                g.drawString(this.options[i].name, c.getWidth() / 2 + (int)(Math.sin(this.sinCounter) * 20.0), c.getHeight() / 3 + i * c.getHeight() / 8, 17);
                continue;
            }
            g.drawString(this.options[i].name, c.getWidth() / 2, c.getHeight() / 3 + i * (c.getHeight() / 8), 17);
        }
    }

    public int handleInput(SubGameCanvas c) {
        int keyState = c.getKeyStates();
        if (!c.keysLocked) {
            if ((keyState & 2) != 0 && this.currentSelection > 0) {
                --this.currentSelection;
                c.keysLocked = true;
            }
            if ((keyState & 0x40) != 0 && this.currentSelection < this.options.length - 1 && this.options[this.currentSelection + 1] != null) {
                ++this.currentSelection;
                c.keysLocked = true;
            }
            if ((keyState & 0x100) != 0) {
                c.keysLocked = true;
                return this.options[this.currentSelection].target;
            }
        }
        return -1;
    }
}

