/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.tools;

import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageHelper {
    private static ImageHelper self;
    public static Hashtable cachedImages;

    public static ImageHelper getInstance() {
        if (self == null) {
            self = new ImageHelper();
        }
        return self;
    }

    public static Image loadImage(String path, int width, int height) throws RuntimeException {
        ImageHelper.getInstance();
        return ImageHelper.scaleImage(ImageHelper.loadImage(path), width, height);
    }

    public static Image loadImage(String path, float scaling) throws RuntimeException {
        ImageHelper.getInstance();
        return ImageHelper.scaleImage(ImageHelper.loadImage(path), scaling);
    }

    public static Image loadImage(String path) throws RuntimeException {
        try {
            InputStream e = ImageHelper.getInstance().getClass().getResourceAsStream(path);
            Image image = Image.createImage((InputStream)e);
            return image;
        }
        catch (Exception var4) {
            RuntimeException re = new RuntimeException("ImageLoader failed to load image:" + path + " " + var4.getMessage());
            re.printStackTrace();
            throw re;
        }
    }

    public static Image loadImage(String path, float xScaling, float yScaling) {
        ImageHelper.getInstance();
        Image original = ImageHelper.loadImage(path);
        return ImageHelper.scaleImage(original, (int)((float)original.getWidth() * xScaling), (int)((float)original.getHeight() * yScaling));
    }

    public static Image loadCached(String path, float xScaling, float yScaling) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(xScaling));
        buffer.append(" x ");
        buffer.append(String.valueOf(yScaling));
        buffer.append(" ");
        buffer.append(path);
        String key = buffer.toString();
        if (cachedImages.containsKey(key)) {
            return (Image)cachedImages.get(key);
        }
        Image image = ImageHelper.loadImage(path, xScaling, yScaling);
        cachedImages.put(key, image);
        return image;
    }

    public static Image loadCached(String path, float scaling) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(scaling));
        buffer.append(" x ");
        buffer.append(path);
        String key = buffer.toString();
        if (cachedImages.containsKey(key)) {
            return (Image)cachedImages.get(key);
        }
        Image image = ImageHelper.loadImage(path, scaling);
        cachedImages.put(key, image);
        return image;
    }

    public static Image loadCached(String path, int width, int height) throws RuntimeException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(width));
        buffer.append(" x ");
        buffer.append(String.valueOf(height));
        buffer.append(" ");
        buffer.append(path);
        String key = buffer.toString();
        if (cachedImages.containsKey(key)) {
            return (Image)cachedImages.get(key);
        }
        ImageHelper.getInstance();
        Image image = ImageHelper.loadImage(path, width, height);
        cachedImages.put(key, image);
        return image;
    }

    public static Image loadCached(String path) {
        if (cachedImages.containsKey(path)) {
            return (Image)cachedImages.get(path);
        }
        ImageHelper.getInstance();
        Image image = ImageHelper.loadImage(path);
        cachedImages.put(path, image);
        return image;
    }

    public static Image scaleImage(Image original, float scaling) {
        return ImageHelper.scaleImage(original, (int)((double)(scaling * (float)original.getWidth()) + 0.5), (int)((double)(scaling * (float)original.getHeight()) + 0.5));
    }

    public static Image scaleImage(Image original, int newWidth, int newHeight) {
        int originalWidth = original.getWidth();
        int originalHeight = original.getHeight();
        return originalWidth == newWidth && originalHeight == newHeight ? original : (originalWidth <= newWidth ? ImageHelper.pixelMixing(original, newWidth, newHeight) : (originalWidth > newWidth ? ImageHelper.bilinearInterpolation(original, newWidth, newHeight) : original));
    }

    private static Image pixelMixing(Image original, int newWidth, int newHeight) {
        int oX16Start;
        int oHeight;
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int oWidth = original.getWidth();
        int[] oX16 = new int[newWidth + 1];
        for (int oXStartWidth = 0; oXStartWidth <= newWidth; ++oXStartWidth) {
            oX16[oXStartWidth] = (oXStartWidth * oWidth << 4) / newWidth;
        }
        int[] var39 = new int[newWidth];
        int[] oXEndWidth = new int[newWidth];
        for (oHeight = 0; oHeight < newWidth; ++oHeight) {
            var39[oHeight] = 16 - oX16[oHeight] % 16;
            oXEndWidth[oHeight] = oX16[oHeight + 1] % 16;
        }
        oHeight = original.getHeight();
        int[] oY16 = new int[newHeight + 1];
        for (oX16Start = 0; oX16Start <= newHeight; ++oX16Start) {
            oY16[oX16Start] = (oX16Start * oHeight << 4) / newHeight;
        }
        for (int newY = 0; newY < newHeight; ++newY) {
            int oY16Start = oY16[newY];
            int oY16End = oY16[newY + 1];
            int oYStart = oY16Start >>> 4;
            int oYEnd = oY16End >>> 4;
            int oYStartHeight = 16 - oY16Start % 16;
            int oYEndHeight = oY16End % 16;
            for (int newX = 0; newX < newWidth; ++newX) {
                oX16Start = oX16[newX];
                int oX16End = oX16[newX + 1];
                int oXStart = oX16Start >>> 4;
                int oXEnd = oX16End >>> 4;
                int outArea = 0;
                int outColorArea = 0;
                int outAlpha = 0;
                int outRed = 0;
                int outGreen = 0;
                int outBlue = 0;
                for (int j = oYStart; j <= oYEnd; ++j) {
                    int areaHeight = 16;
                    if (oYStart == oYEnd) {
                        areaHeight = oY16End - oY16Start;
                    } else if (j == oYStart) {
                        areaHeight = oYStartHeight;
                    } else if (j == oYEnd) {
                        areaHeight = oYEndHeight;
                    }
                    if (areaHeight == 0) continue;
                    for (int i = oXStart; i <= oXEnd; ++i) {
                        int areaWidth = 16;
                        if (oXStart == oXEnd) {
                            areaWidth = oX16End - oX16Start;
                        } else if (i == oXStart) {
                            areaWidth = var39[newX];
                        } else if (i == oXEnd) {
                            areaWidth = oXEndWidth[newX];
                        }
                        if (areaWidth == 0) continue;
                        int area = areaWidth * areaHeight;
                        outArea += area;
                        int argb = rawInput[i + j * original.getWidth()];
                        int a = argb >>> 24;
                        if (a == 0) continue;
                        area = a * area;
                        outColorArea += area;
                        int r = (argb & 0xFF0000) >>> 16;
                        int g = (argb & 0xFF00) >>> 8;
                        int b = argb & 0xFF;
                        outRed += area * r;
                        outGreen += area * g;
                        outBlue += area * b;
                    }
                }
                if (outColorArea > 0) {
                    outAlpha = outColorArea / outArea;
                    outRed /= outColorArea;
                    outGreen /= outColorArea;
                    outBlue /= outColorArea;
                }
                rawOutput[newX + newY * newWidth] = outAlpha << 24 | outRed << 16 | outGreen << 8 | outBlue;
            }
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
    }

    private static Image bilinearInterpolation(Image original, int newWidth, int newHeight) {
        int oHeight;
        int[] rawInput = new int[original.getHeight() * original.getWidth()];
        original.getRGB(rawInput, 0, original.getWidth(), 0, 0, original.getWidth(), original.getHeight());
        int[] rawOutput = new int[newWidth * newHeight];
        int oWidth = original.getWidth();
        int[] oX16 = new int[newWidth];
        int max = oWidth - 1 << 4;
        for (oHeight = 0; oHeight < newWidth; ++oHeight) {
            oX16[oHeight] = (((oHeight << 1) + 1) * oWidth << 3) / newWidth - 8;
            if (oX16[oHeight] < 0) {
                oX16[oHeight] = 0;
                continue;
            }
            if (oX16[oHeight] <= max) continue;
            oX16[oHeight] = max;
        }
        oHeight = original.getHeight();
        int[] oY16 = new int[newHeight];
        max = oHeight - 1 << 4;
        for (int oX = 0; oX < newHeight; ++oX) {
            oY16[oX] = (((oX << 1) + 1) * oHeight << 3) / newHeight - 8;
            if (oY16[oX] < 0) {
                oY16[oX] = 0;
                continue;
            }
            if (oY16[oX] <= max) continue;
            oY16[oX] = max;
        }
        int[] var30 = new int[2];
        int[] oY = new int[2];
        int[] wX = new int[2];
        int[] wY = new int[2];
        for (int newY = 0; newY < newHeight; ++newY) {
            oY[0] = oY16[newY] >>> 4;
            wY[1] = oY16[newY] & 0xF;
            wY[0] = 16 - wY[1];
            oY[1] = wY[1] == 0 ? oY[0] : oY[0] + 1;
            for (int newX = 0; newX < newWidth; ++newX) {
                var30[0] = oX16[newX] >>> 4;
                wX[1] = oX16[newX] & 0xF;
                wX[0] = 16 - wX[1];
                var30[1] = wX[1] == 0 ? var30[0] : var30[0] + 1;
                int outWeight = 0;
                int outColorWeight = 0;
                int outAlpha = 0;
                int outRed = 0;
                int outGreen = 0;
                int outBlue = 0;
                for (int j = 0; j < 2; ++j) {
                    for (int i = 0; i < 2; ++i) {
                        if (wY[j] == 0 || wX[i] == 0) continue;
                        int w = wX[i] * wY[j];
                        outWeight += w;
                        int argb = rawInput[var30[i] + oY[j] * original.getWidth()];
                        int a = argb >>> 24;
                        if (a == 0) continue;
                        w = a * w;
                        outColorWeight += w;
                        int r = (argb & 0xFF0000) >>> 16;
                        int g = (argb & 0xFF00) >>> 8;
                        int b = argb & 0xFF;
                        outRed += w * r;
                        outGreen += w * g;
                        outBlue += w * b;
                    }
                }
                if (outColorWeight > 0) {
                    outAlpha = outColorWeight / outWeight;
                    outRed /= outColorWeight;
                    outGreen /= outColorWeight;
                    outBlue /= outColorWeight;
                }
                rawOutput[newX + newY * newWidth] = outAlpha << 24 | outRed << 16 | outGreen << 8 | outBlue;
            }
        }
        return Image.createRGBImage((int[])rawOutput, (int)newWidth, (int)newHeight, (boolean)true);
    }

    public static void printCache() {
        System.out.println();
    }

    public static void cleanCache() {
        cachedImages.clear();
    }

    public static Image rotate(Image imgSource, int cx, int cy, double theta) {
        int[] dd = new int[2];
        int w1 = imgSource.getWidth();
        int h1 = imgSource.getHeight();
        int[] srcMap = new int[w1 * h1];
        imgSource.getRGB(srcMap, 0, w1, 0, 0, w1, h1);
        double dr = Math.sqrt(cx * cx + cy * cy);
        int wh2 = (int)(2.0 * dr + 1.0);
        int[] destMap = new int[wh2 * wh2];
        double radian = theta * Math.PI / 180.0;
        for (int i = 0; i < w1; ++i) {
            for (int j = 0; j < h1; ++j) {
                int destX = (int)(dr + (double)(i - cx) * Math.cos(radian) + (double)(j - cy) * Math.sin(radian));
                int destY = (int)(dr + (double)(j - cy) * Math.cos(radian) - (double)(i - cx) * Math.sin(radian));
                destMap[wh2 * destY + destX] = srcMap[j * w1 + i];
                destMap[wh2 * destY + destX + 1] = srcMap[j * w1 + i];
            }
        }
        dd[0] = (int)((double)cx - dr);
        dd[1] = (int)((double)cy - dr);
        return Image.createRGBImage((int[])destMap, (int)wh2, (int)wh2, (boolean)true);
    }

    public static Image rotate(Image imgSource, int cx, int cy, double theta, int[] dd) {
        if (Math.abs(theta % 360.0) < 0.1) {
            return imgSource;
        }
        int w1 = imgSource.getWidth();
        int h1 = imgSource.getHeight();
        int[] srcMap = new int[w1 * h1];
        imgSource.getRGB(srcMap, 0, w1, 0, 0, w1, h1);
        double dr = Math.sqrt(cx * cx + cy * cy);
        int wh2 = (int)(2.0 * dr + 1.0);
        int[] destMap = new int[wh2 * wh2];
        double radian = theta * Math.PI / 180.0;
        for (int i = 0; i < w1; ++i) {
            for (int j = 0; j < h1; ++j) {
                int destX = (int)(dr + (double)(i - cx) * Math.cos(radian) + (double)(j - cy) * Math.sin(radian));
                int destY = (int)(dr + (double)(j - cy) * Math.cos(radian) - (double)(i - cx) * Math.sin(radian));
                destMap[wh2 * destY + destX] = srcMap[j * w1 + i];
                destMap[wh2 * destY + destX + 1] = srcMap[j * w1 + i];
            }
        }
        dd[0] = (int)((double)cx - dr);
        dd[1] = (int)((double)cy - dr);
        return Image.createRGBImage((int[])destMap, (int)wh2, (int)wh2, (boolean)true);
    }

    public static Image drawTextOnImage(Image img, String str, Font font) {
        String text = str;
        Font fn = font != null ? font : Font.getDefaultFont();
        int hTitle = img.getHeight();
        int wTitle = img.getWidth();
        int hFont = fn.getHeight();
        int wFont = fn.stringWidth(str);
        Image titleImg = Image.createImage((int)wTitle, (int)hTitle);
        Graphics textGrP1 = titleImg.getGraphics();
        textGrP1.drawRegion(img, 0, 0, wTitle, hTitle, 0, 0, 0, 20);
        textGrP1.setColor(0);
        textGrP1.setFont(fn);
        if (wFont < wTitle) {
            textGrP1.drawString(str, wTitle / 2, hTitle / 2 - hFont / 2, 17);
        }
        if (wFont > wTitle) {
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != ' ') continue;
                textGrP1.drawString(text.substring(0, i), wTitle / 2, hTitle / 2, 33);
                textGrP1.drawString(text.substring(i), wTitle / 2, hTitle / 2, 17);
                break;
            }
        }
        return titleImg;
    }

    public static Image createInvisiblePic(int w, int h) {
        int[] srcMap = new int[w * h];
        for (int destImgNull = 0; destImgNull < srcMap.length; ++destImgNull) {
            srcMap[destImgNull] = 0;
        }
        Image var4 = Image.createRGBImage((int[])srcMap, (int)w, (int)h, (boolean)true);
        return var4;
    }

    public static Image createImageWithText(int w, int h, String str, Font font, int colorTextIn, int colorFonIn) {
        String text = str;
        Font fn = Font.getDefaultFont();
        if (font != null) {
            fn = font;
        }
        int hFont = fn.getHeight();
        int wFont = fn.stringWidth(str);
        Image titleImg = Image.createImage((int)w, (int)h);
        Graphics textGrP1 = titleImg.getGraphics();
        textGrP1.setColor(colorFonIn);
        textGrP1.fillRect(0, 0, w, h);
        textGrP1.setColor(colorTextIn);
        textGrP1.setFont(fn);
        if (wFont < w) {
            textGrP1.drawString(str, w / 2, h / 2 - hFont / 2, 17);
        }
        if (wFont > w) {
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != ' ') continue;
                textGrP1.drawString(text.substring(0, i), w / 2, h / 2, 33);
                textGrP1.drawString(text.substring(i), w / 2, h / 2, 17);
                break;
            }
        }
        return titleImg;
    }

    static {
        cachedImages = new Hashtable();
    }
}

