/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Matrix2f;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Contact;
import net.phys2d.raw.collide.Collider;
import net.phys2d.raw.collide.FeaturePair;
import net.phys2d.raw.shapes.Box;

public strictfp class BoxBoxCollider
implements Collider {
    public static final int FACE_A_X = 1;
    public static final int FACE_A_Y = 2;
    public static final int FACE_B_X = 3;
    public static final int FACE_B_Y = 4;
    public static final int NO_EDGE = 0;
    public static final int EDGE1 = 1;
    public static final int EDGE2 = 2;
    public static final int EDGE3 = 3;
    public static final int EDGE4 = 4;
    private static Vector2f hA = new Vector2f();
    private static Vector2f hB = new Vector2f();

    private void flip(FeaturePair fp) {
        int temp = fp.inEdge1;
        fp.inEdge1 = fp.inEdge2;
        fp.inEdge2 = temp;
        temp = fp.outEdge1;
        fp.outEdge1 = fp.outEdge2;
        fp.outEdge2 = temp;
    }

    private int clipSegmentToLine(ClipVertex[] vOut, ClipVertex[] vIn, Vector2f normal, float offset, char clipEdge) {
        int numOut = 0;
        float distance0 = normal.dot(vIn[0].v) - offset;
        float distance1 = normal.dot(vIn[1].v) - offset;
        if (distance0 <= 0.0f) {
            vOut[numOut++] = vIn[0];
        }
        if (distance1 <= 0.0f) {
            vOut[numOut++] = vIn[1];
        }
        if (distance0 * distance1 < 0.0f) {
            float interp = distance0 / (distance0 - distance1);
            vOut[numOut].v = MathUtil.scale(MathUtil.sub(vIn[1].v, vIn[0].v), interp);
            vOut[numOut].v.add(vIn[0].v);
            if (distance0 > 0.0f) {
                vOut[numOut].fp = vIn[0].fp;
                vOut[numOut].fp.inEdge1 = clipEdge;
                vOut[numOut].fp.inEdge2 = 0;
            } else {
                vOut[numOut].fp = vIn[1].fp;
                vOut[numOut].fp.outEdge1 = clipEdge;
                vOut[numOut].fp.outEdge2 = 0;
            }
            ++numOut;
        }
        return numOut;
    }

    private void computeIncidentEdge(ClipVertex[] c, ROVector2f h, ROVector2f pos, Matrix2f rot, Vector2f normal) {
        Matrix2f rotT = rot.transpose();
        Vector2f n = MathUtil.scale(MathUtil.mul(rotT, normal), -1.0f);
        Vector2f nAbs = MathUtil.abs(n);
        if (nAbs.x > nAbs.y) {
            if (MathUtil.sign(n.x) > 0.0f) {
                c[0].v.set(h.getX(), -h.getY());
                c[0].fp.inEdge2 = 3;
                c[0].fp.outEdge2 = 4;
                c[1].v.set(h.getX(), h.getY());
                c[1].fp.inEdge2 = 4;
                c[1].fp.outEdge2 = 1;
            } else {
                c[0].v.set(-h.getX(), h.getY());
                c[0].fp.inEdge2 = 1;
                c[0].fp.outEdge2 = 2;
                c[1].v.set(-h.getX(), -h.getY());
                c[1].fp.inEdge2 = 2;
                c[1].fp.outEdge2 = 3;
            }
        } else if (MathUtil.sign(n.y) > 0.0f) {
            c[0].v.set(h.getX(), h.getY());
            c[0].fp.inEdge2 = 4;
            c[0].fp.outEdge2 = 1;
            c[1].v.set(-h.getX(), h.getY());
            c[1].fp.inEdge2 = 1;
            c[1].fp.outEdge2 = 2;
        } else {
            c[0].v.set(-h.getX(), -h.getY());
            c[0].fp.inEdge2 = 2;
            c[0].fp.outEdge2 = 3;
            c[1].v.set(h.getX(), -h.getY());
            c[1].fp.inEdge2 = 3;
            c[1].fp.outEdge2 = 4;
        }
        c[0].v = MathUtil.mul(rot, c[0].v);
        c[0].v.add(pos);
        c[1].v = MathUtil.mul(rot, c[1].v);
        c[1].v.add(pos);
    }

    public int collide(Contact[] contacts, Body bodyA, Body bodyB) {
        char posEdge;
        char negEdge;
        float posSide;
        float negSide;
        Vector2f sideNormal;
        float front;
        Vector2f frontNormal;
        Vector2f normal;
        float x1 = bodyA.getPosition().getX();
        float y1 = bodyA.getPosition().getY();
        float x2 = bodyB.getPosition().getX();
        float y2 = bodyB.getPosition().getY();
        boolean touches = bodyA.getShape().getBounds().touches(x1, y1, bodyB.getShape().getBounds(), x2, y2);
        if (!touches) {
            return 0;
        }
        hA.set(((Box)bodyA.getShape()).getSize());
        hA.scale(0.5f);
        hB.set(((Box)bodyB.getShape()).getSize());
        hB.scale(0.5f);
        ROVector2f posA = bodyA.getPosition();
        ROVector2f posB = bodyB.getPosition();
        Matrix2f rotA = new Matrix2f(bodyA.getRotation());
        Matrix2f rotB = new Matrix2f(bodyB.getRotation());
        Matrix2f RotAT = rotA.transpose();
        Matrix2f RotBT = rotB.transpose();
        Vector2f dp = MathUtil.sub(posB, posA);
        Vector2f dA = MathUtil.mul(RotAT, dp);
        Vector2f dB = MathUtil.mul(RotBT, dp);
        Matrix2f C = MathUtil.mul(RotAT, rotB);
        Matrix2f absC = MathUtil.abs(C);
        Matrix2f absCT = absC.transpose();
        Vector2f faceA = MathUtil.abs(dA);
        faceA.sub(hA);
        faceA.sub(MathUtil.mul(absC, hB));
        if (faceA.x > 0.0f || faceA.y > 0.0f) {
            return 0;
        }
        Vector2f faceB = MathUtil.abs(dB);
        faceB.sub(MathUtil.mul(absCT, hA));
        faceB.sub(hB);
        if (faceB.x > 0.0f || faceB.y > 0.0f) {
            return 0;
        }
        int axis = 1;
        float separation = faceA.x;
        Vector2f vector2f = normal = dA.x > 0.0f ? rotA.col1 : MathUtil.scale(rotA.col1, -1.0f);
        if (faceA.y > 1.05f * separation + 0.01f * BoxBoxCollider.hA.y) {
            axis = 2;
            separation = faceA.y;
            Vector2f vector2f2 = normal = dA.y > 0.0f ? rotA.col2 : MathUtil.scale(rotA.col2, -1.0f);
        }
        if (faceB.x > 1.05f * separation + 0.01f * BoxBoxCollider.hB.x) {
            axis = 3;
            separation = faceB.x;
            Vector2f vector2f3 = normal = dB.x > 0.0f ? rotB.col1 : MathUtil.scale(rotB.col1, -1.0f);
        }
        if (faceB.y > 1.05f * separation + 0.01f * BoxBoxCollider.hB.y) {
            axis = 4;
            separation = faceB.y;
            normal = dB.y > 0.0f ? rotB.col2 : MathUtil.scale(rotB.col2, -1.0f);
        }
        ClipVertex[] incidentEdge = new ClipVertex[]{new ClipVertex(), new ClipVertex()};
        switch (axis) {
            case 1: {
                frontNormal = normal;
                front = posA.dot(frontNormal) + BoxBoxCollider.hA.x;
                sideNormal = rotA.col2;
                float side = posA.dot(sideNormal);
                negSide = -side + BoxBoxCollider.hA.y;
                posSide = side + BoxBoxCollider.hA.y;
                negEdge = '\u0003';
                posEdge = '\u0001';
                this.computeIncidentEdge(incidentEdge, hB, posB, rotB, frontNormal);
                break;
            }
            case 2: {
                frontNormal = normal;
                front = posA.dot(frontNormal) + BoxBoxCollider.hA.y;
                sideNormal = rotA.col1;
                float side = posA.dot(sideNormal);
                negSide = -side + BoxBoxCollider.hA.x;
                posSide = side + BoxBoxCollider.hA.x;
                negEdge = '\u0002';
                posEdge = '\u0004';
                this.computeIncidentEdge(incidentEdge, hB, posB, rotB, frontNormal);
                break;
            }
            case 3: {
                frontNormal = MathUtil.scale(normal, -1.0f);
                front = posB.dot(frontNormal) + BoxBoxCollider.hB.x;
                sideNormal = rotB.col2;
                float side = posB.dot(sideNormal);
                negSide = -side + BoxBoxCollider.hB.y;
                posSide = side + BoxBoxCollider.hB.y;
                negEdge = '\u0003';
                posEdge = '\u0001';
                this.computeIncidentEdge(incidentEdge, hA, posA, rotA, frontNormal);
                break;
            }
            case 4: {
                frontNormal = MathUtil.scale(normal, -1.0f);
                front = posB.dot(frontNormal) + BoxBoxCollider.hB.y;
                sideNormal = rotB.col1;
                float side = posB.dot(sideNormal);
                negSide = -side + BoxBoxCollider.hB.x;
                posSide = side + BoxBoxCollider.hB.x;
                negEdge = '\u0002';
                posEdge = '\u0004';
                this.computeIncidentEdge(incidentEdge, hA, posA, rotA, frontNormal);
                break;
            }
            default: {
                throw new RuntimeException("Unknown face!");
            }
        }
        ClipVertex[] clipPoints1 = new ClipVertex[]{new ClipVertex(), new ClipVertex()};
        ClipVertex[] clipPoints2 = new ClipVertex[]{new ClipVertex(), new ClipVertex()};
        int np = this.clipSegmentToLine(clipPoints1, incidentEdge, MathUtil.scale(sideNormal, -1.0f), negSide, negEdge);
        if (np < 2) {
            return 0;
        }
        np = this.clipSegmentToLine(clipPoints2, clipPoints1, sideNormal, posSide, posEdge);
        if (np < 2) {
            return 0;
        }
        int numContacts = 0;
        for (int i = 0; i < 2; ++i) {
            float separation2 = frontNormal.dot(clipPoints2[i].v) - front;
            if (!(separation2 <= 0.0f)) continue;
            contacts[numContacts].setSeparation(separation2);
            contacts[numContacts].setNormal(normal);
            contacts[numContacts].setPosition(MathUtil.sub(clipPoints2[i].v, MathUtil.scale(frontNormal, separation2)));
            contacts[numContacts].setFeature(clipPoints2[i].fp);
            if (axis == 3 || axis == 4) {
                this.flip(contacts[numContacts].getFeature());
            }
            ++numContacts;
        }
        return numContacts;
    }

    private strictfp class ClipVertex {
        Vector2f v = new Vector2f();
        FeaturePair fp = new FeaturePair();
    }
}

