/*
 * Decompiled with CFR 0.152.
 */
package hello;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.BodyList;
import net.phys2d.raw.CollisionEvent;
import net.phys2d.raw.CollisionListener;
import net.phys2d.raw.FixedJoint;
import net.phys2d.raw.World;
import net.phys2d.raw.shapes.Box;
import net.phys2d.raw.shapes.Circle;
import net.phys2d.raw.strategies.QuadSpaceStrategy;

public class HelloCanvas_1
extends Canvas
implements Runnable,
CollisionListener {
    World world = new World(new Vector2f(0.0f, 1000.0f), 10, new QuadSpaceStrategy(20, 5));
    BodyList bodylist = new BodyList();
    Body glassbase;
    Body glassleft;
    Body glassright;
    Body base;
    Body fireBall;
    Body fireBall1;
    FixedJoint leftg;
    FixedJoint rightg;
    int adjustX = 0;

    public HelloCanvas_1() {
        int glassStartingPointX = 200;
        int glassStartingPointY = 200;
        int glassWidth = 40;
        int glassThickness = 2;
        int glassHeight = 50;
        this.setFullScreenMode(true);
        this.glassbase = new Body("player1", new Box(glassWidth, glassThickness), 1.0f);
        this.glassbase.setPosition(glassStartingPointX, glassStartingPointY);
        this.glassleft = new Body("player2", new Box(glassThickness, glassHeight), 1.0f);
        this.glassleft.setPosition(glassStartingPointX - glassWidth / 2, glassStartingPointY + glassThickness / 2 - glassHeight / 2);
        this.glassright = new Body("player2", new Box(glassThickness, glassHeight), 1.0f);
        this.glassright.setPosition(glassStartingPointX + glassWidth / 2, glassStartingPointY + glassThickness / 2 - glassHeight / 2);
        this.leftg = new FixedJoint(this.glassbase, this.glassleft);
        this.rightg = new FixedJoint(this.glassbase, this.glassright);
        this.leftg.applyImpulse();
        this.rightg.applyImpulse();
        this.base = new Body("player2", new Box(1000.0f, 10.0f), 10.0f);
        this.base.setPosition(0.0f, 300.0f);
        this.base.setGravityEffected(false);
        this.base.setRotatable(false);
        this.base.setMoveable(false);
        this.fireBall = new Body("player2", new Circle(10.0f), 20.0f);
        this.fireBall.setPosition(0.0f, 290.0f);
        this.fireBall.addForce(new Vector2f(300000.0f, -600000.0f));
        this.fireBall1 = new Body("player2", new Circle(10.0f), 20.0f);
        this.fireBall1.setPosition(70.0f, 290.0f);
        this.fireBall1.addForce(new Vector2f(200000.0f, -600000.0f));
        this.bodylist.add(this.glassbase);
        this.bodylist.add(this.glassleft);
        this.bodylist.add(this.glassright);
        this.bodylist.add(this.base);
        this.bodylist.add(this.fireBall);
        this.world.add(this.glassbase);
        this.world.add(this.glassleft);
        this.world.add(this.glassright);
        this.world.add(this.leftg);
        this.world.add(this.rightg);
        this.world.add(this.base);
        this.world.add(this.fireBall);
    }

    protected void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0, 0, 0);
        int adjustX = (int)this.fireBall.getShape().getBounds().getOffsetX();
        g.translate(-100, 0);
        for (int i = 0; i < this.bodylist.size(); ++i) {
            ROVector2f v1;
            Body body = this.bodylist.get(i);
            try {
                if (body.getShape() == (Box)body.getShape()) {
                    Box box = (Box)body.getShape();
                    Vector2f[] pts = box.getPoints(body.getPosition(), body.getRotation());
                    v1 = pts[0];
                    Vector2f v2 = pts[1];
                    Vector2f v3 = pts[2];
                    Vector2f v4 = pts[3];
                    g.drawLine((int)((Vector2f)v1).x - adjustX, (int)((Vector2f)v1).y, (int)v2.x - adjustX, (int)v2.y);
                    g.drawLine((int)v2.x - adjustX, (int)v2.y, (int)v3.x - adjustX, (int)v3.y);
                    g.drawLine((int)v3.x - adjustX, (int)v3.y, (int)v4.x - adjustX, (int)v4.y);
                    g.drawLine((int)v4.x - adjustX, (int)v4.y, (int)((Vector2f)v1).x - adjustX, (int)((Vector2f)v1).y);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (body.getShape() != (Circle)body.getShape()) continue;
                Circle cir = (Circle)body.getShape();
                int r = (int)cir.getRadius();
                v1 = body.getPosition();
                g.drawArc((int)v1.getX() - r - adjustX, (int)v1.getY() - r, 2 * r, 2 * r, 0, 360);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.world.step();
            this.repaint();
        }
    }

    public void collisionOccured(CollisionEvent event) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void keyPressed(int key) {
    }
}

