/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework;

import com.appon.miniframework.Container;
import com.appon.miniframework.Control;
import com.appon.miniframework.Event;
import com.appon.miniframework.LocalizationProvider;
import com.appon.miniframework.Queue;
import com.appon.miniframework.ScrollableContainer;

public class EventQueue {
    private static EventQueue instance;
    private Queue requestQueue = new Queue();
    private boolean isEnding = false;
    private boolean isOnSelfEndAnim = false;
    private Control hotControl;
    private int currentDelay;
    private boolean isProcsseing = false;
    private LocalizationProvider localProvider;

    private EventQueue() {
    }

    public String getLocalText(int id) {
        if (this.localProvider != null && id != -1) {
            return this.localProvider.getLocalText(id);
        }
        return null;
    }

    public void registerLocalProvider(LocalizationProvider provider) {
        this.localProvider = provider;
    }

    public boolean isProcsseing() {
        return this.isProcsseing;
    }

    public void setHotControl(Control hotControl) {
        this.hotControl = hotControl;
    }

    public Control getHotControl() {
        return this.hotControl;
    }

    public void reset() {
        this.isEnding = false;
        this.requestQueue.clear();
        this.isProcsseing = false;
        ScrollableContainer.isBringingToCenter = false;
    }

    public static EventQueue getInstance() {
        if (instance == null) {
            instance = new EventQueue();
        }
        return instance;
    }

    public boolean isEnding() {
        return this.isEnding;
    }

    public void process(Container parent) {
        if (this.requestQueue.size() > 0) {
            this.isProcsseing = true;
            if (this.getHotControl().getDelayInSelection() > 0 && this.currentDelay++ < this.getHotControl().getDelayInSelection()) {
                return;
            }
            this.isEnding = true;
            boolean allOver = this.allEndingAnimOver(parent);
            while (allOver && this.requestQueue.size() > 0) {
                Event e = (Event)this.requestQueue.dequeue();
                if (e.getSource() == null || e.getSource().getEventListener() == null) continue;
                e.getSource().getEventListener().event(e);
            }
        }
    }

    public void addEvent(Event e) {
        if (e.getSource().isClickable()) {
            this.requestQueue.enqueue(e);
            this.setIsOnSelfEndAnim(e.getSource().isEndAnimOnSelf());
            this.setHotControl(e.getSource());
            this.currentDelay = 0;
        }
    }

    public boolean isIsOnSelfEndAnim() {
        return this.isOnSelfEndAnim;
    }

    public void setIsOnSelfEndAnim(boolean isOnSelfEndAnim) {
        this.isOnSelfEndAnim = isOnSelfEndAnim;
    }

    public boolean allStartAnimOver(Container parent) {
        boolean allOver = true;
        if (parent.getStartAnimation() != null && !parent.getStartAnimation().isAnimationOver()) {
            allOver = false;
        }
        for (int i = 0; i < parent.getSize(); ++i) {
            boolean tmp;
            Control c = parent.getChild(i);
            if (c instanceof Container) {
                tmp = this.allStartAnimOver((Container)c);
                if (tmp) continue;
                allOver = false;
                return allOver;
            }
            if (c.getStartAnimation() == null || (tmp = c.getStartAnimation().isAnimationOver())) continue;
            allOver = false;
            return allOver;
        }
        return allOver;
    }

    private boolean allEndingAnimOver(Container parent) {
        if (this.isIsOnSelfEndAnim()) {
            for (int i = 0; i < parent.getSize(); ++i) {
                boolean value;
                Control c = parent.getChild(i);
                if (c.getId() == this.getHotControl().getId()) {
                    if (c.getEndAnimation() == null) {
                        return true;
                    }
                    return c.getEndAnimation().isAnimationOver();
                }
                if (!(c instanceof Container) || !(value = this.allEndingAnimOver((Container)c))) continue;
                return true;
            }
        }
        boolean allOver = true;
        if (parent.getEndAnimation() != null && !parent.getEndAnimation().isAnimationOver()) {
            allOver = false;
        }
        for (int i = 0; i < parent.getSize(); ++i) {
            boolean tmp;
            Control c = parent.getChild(i);
            if (c instanceof Container) {
                tmp = this.allEndingAnimOver((Container)c);
                if (tmp) continue;
                allOver = false;
                return allOver;
            }
            if (c.getEndAnimation() == null || (tmp = c.getEndAnimation().isAnimationOver())) continue;
            allOver = false;
            return allOver;
        }
        return allOver;
    }
}

