/*
 * Decompiled with CFR 0.152.
 */
package com.appon.gtantra;

import com.appon.gtantra.GAnimListener;
import com.appon.gtantra.GTantra;
import javax.microedition.lcdui.Graphics;

public class GAnim {
    private int currentFrame;
    private int timer;
    private GTantra gTantra;
    private int animId;
    private GAnimListener animListener;
    private int animUID;
    private Object userData;
    private boolean isAnimOver = false;

    public GAnim(GTantra gTantra, int animId) {
        this.gTantra = gTantra;
        this.animId = animId;
    }

    public GAnim(GTantra gTantra, int animId, int UID) {
        this(gTantra, animId);
        this.animUID = UID;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public boolean isAnimRendering() {
        return this.getAnimationCurrentCycle() >= 1 && this.getAnimationCurrentCycle() <= this.getNumberOfFrames();
    }

    public void reInit(int animId) {
        this.animListener = null;
        this.userData = null;
        this.setCurrentFrame(0);
        this.timer = 0;
        this.animId = animId;
        this.animUID = 0;
        this.isAnimOver = false;
    }

    public void setFrame(int frameID) {
        this.setCurrentFrame(frameID);
    }

    public int getCurrentFrameMinimumX() {
        return this.gTantra.getFrameMinimumX(this.gTantra.getFrameId(this.animId, this.currentFrame));
    }

    public int getCurrentFrameMinimumY() {
        return this.gTantra.getFrameMinimumY(this.gTantra.getFrameId(this.animId, this.currentFrame));
    }

    public int getAnimationCurrentCycle() {
        return this.currentFrame;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setAnimUID(int animUID) {
        this.animUID = animUID;
    }

    public int getAnimUID() {
        return this.animUID;
    }

    public void setAnimListener(GAnimListener animListener) {
        this.animListener = animListener;
    }

    public boolean isAnimationOver() {
        return this.isAnimOver;
    }

    public void reset() {
        this.setCurrentFrame(0);
        this.isAnimOver = false;
    }

    public int getCurrentFrame() {
        return this.gTantra._iAnimFrames[this.animId][this.currentFrame];
    }

    public int getAnimationFrameX(int frameLocation) {
        return this.gTantra._iAnimFrameX[this.animId][frameLocation];
    }

    public int getAnimationFrameY(int frameLocation) {
        return this.gTantra._iAnimFrameY[this.animId][frameLocation];
    }

    public int getAnimationCurrentCycle(int animation) {
        return this.currentFrame;
    }

    public int getNumberOfFrames() {
        return this.gTantra._iAnimFrameCnt[this.animId];
    }

    public void render(Graphics g, int posX, int posY, int flags, boolean loop) {
        byte currentFrameTime = this.gTantra.frameTimer[this.animId][this.currentFrame];
        if (currentFrameTime != 0) {
            this.gTantra.DrawAnimationFrame(g, this.animId, this.currentFrame, posX, posY, flags);
        }
        this.updateFrame(loop);
    }

    public void updateFrame(boolean loop) {
        byte currentTimer = this.gTantra.frameTimer[this.animId][this.currentFrame];
        if (this.timer + 1 >= currentTimer) {
            this.timer = 0;
            ++this.currentFrame;
            if (this.currentFrame >= this.gTantra._iAnimFrameCnt[this.animId]) {
                if (loop) {
                    this.setCurrentFrame(0);
                } else {
                    this.setCurrentFrame(this.gTantra._iAnimFrameCnt[this.animId] - 1);
                    this.isAnimOver = true;
                }
                if (this.animListener != null) {
                    this.animListener.animationOver(this);
                }
            }
            if (this.animListener != null) {
                this.animListener.frameChanged(this);
            }
        } else {
            ++this.timer;
        }
    }

    public int getAnimId() {
        return this.animId;
    }

    public void setCurrentFrame(int currentFrame) {
        this.currentFrame = currentFrame;
    }
}

