/*
 * Decompiled with CFR 0.152.
 */
package com.appon.effectengine;

import com.appon.effectengine.EArc;
import com.appon.effectengine.ELine;
import com.appon.effectengine.EPolygon;
import com.appon.effectengine.ERect;
import com.appon.effectengine.EShape;
import com.appon.effectengine.ETraingle;
import com.appon.effectengine.Effect;
import com.appon.effectengine.EffectGroup;
import com.appon.effectengine.EffectLayer;
import com.appon.effectengine.EffectsSerilize;
import com.appon.effectengine.Point;
import com.appon.effectengine.ProjectileMotion;
import com.appon.effectengine.TimeFrame;
import java.io.ByteArrayInputStream;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Util {
    public static int LOADING_VERSION = 0;
    private static int[] xTrianglePoints = new int[3];
    private static int[] yTrianglePoints = new int[3];
    private static int resizePercent = 0;
    private static int[] xPoints = new int[4];
    private static int[] yPoints = new int[4];
    public static Point pointToRotate = new Point();

    public static int getColor(int color) {
        return color & 0xFFFFFF;
    }

    public static void drawPolygon(Graphics g, int[] xPoints, int[] yPoints, int thickness) {
        int max = xPoints.length - 1;
        for (int i = 0; i < max; ++i) {
            Util.drawThickLine(g, xPoints[i], yPoints[i], xPoints[i + 1], yPoints[i + 1], thickness);
        }
        Util.drawThickLine(g, xPoints[max], yPoints[max], xPoints[0], yPoints[0], thickness);
    }

    public static void fillPolygon(Graphics g, int[] xPoints, int[] yPoints) {
        Stack stack = new Stack();
        Util.fillPolygon(g, xPoints, yPoints, stack);
        while (!stack.isEmpty()) {
            Util.fillPolygon(g, (int[])stack.pop(), (int[])stack.pop(), stack);
        }
    }

    public static void fillTriangle(Graphics g, int x1, int y1, int x2, int y2, int x3, int y3) {
        Util.xTrianglePoints[0] = x1;
        Util.yTrianglePoints[0] = y1;
        Util.xTrianglePoints[1] = x2;
        Util.yTrianglePoints[1] = y2;
        Util.xTrianglePoints[2] = x3;
        Util.yTrianglePoints[2] = y3;
        g.fillTriangle(xTrianglePoints[0], yTrianglePoints[0], xTrianglePoints[1], yTrianglePoints[1], xTrianglePoints[2], yTrianglePoints[2]);
    }

    private static void fillPolygon(Graphics g, int[] xPoints, int[] yPoints, Stack stack) {
        while (xPoints.length > 2) {
            int a = Util.indexOfLeast(xPoints);
            int b = (a + 1) % xPoints.length;
            int c = a <= 0 ? xPoints.length - 1 : a - 1;
            int leastInternalIndex = -1;
            boolean leastInternalSet = false;
            if (xPoints.length > 3) {
                for (int i = 0; i < xPoints.length; ++i) {
                    if (i == a || i == b || i == c || !Util.withinBounds(xPoints[i], yPoints[i], xPoints[a], yPoints[a], xPoints[b], yPoints[b], xPoints[c], yPoints[c]) || leastInternalSet && xPoints[i] >= xPoints[leastInternalIndex]) continue;
                    leastInternalIndex = i;
                    leastInternalSet = true;
                }
            }
            if (!leastInternalSet) {
                Util.fillTriangle(g, xPoints[a], yPoints[a], xPoints[b], yPoints[b], xPoints[c], yPoints[c]);
                int[][] trimmed = Util.trimEar(xPoints, yPoints, a);
                xPoints = trimmed[0];
                yPoints = trimmed[1];
                continue;
            }
            int[][][] split = Util.split(xPoints, yPoints, a, leastInternalIndex);
            int[][] poly1 = split[0];
            int[][] poly2 = split[1];
            stack.push(poly2[1]);
            stack.push(poly2[0]);
            stack.push(poly1[1]);
            stack.push(poly1[0]);
            break;
        }
    }

    static boolean withinBounds(int px, int py, int ax, int ay, int bx, int by, int cx, int cy) {
        if (px < Util.min(ax, bx, cx) || px > Util.max(ax, bx, cx) || py < Util.min(ay, by, cy) || py > Util.max(ay, by, cy)) {
            return false;
        }
        boolean sameabc = Util.sameSide(px, py, ax, ay, bx, by, cx, cy);
        boolean samebac = Util.sameSide(px, py, bx, by, ax, ay, cx, cy);
        boolean samecab = Util.sameSide(px, py, cx, cy, ax, ay, bx, by);
        return sameabc && samebac && samecab;
    }

    static int[][][] split(int[] xPoints, int[] yPoints, int aIndex, int bIndex) {
        int index;
        int i;
        int firstLen = bIndex < aIndex ? xPoints.length - aIndex + bIndex + 1 : bIndex - aIndex + 1;
        int secondLen = xPoints.length - firstLen + 2;
        int[][] first = new int[2][firstLen];
        int[][] second = new int[2][secondLen];
        for (i = 0; i < firstLen; ++i) {
            index = (aIndex + i) % xPoints.length;
            first[0][i] = xPoints[index];
            first[1][i] = yPoints[index];
        }
        for (i = 0; i < secondLen; ++i) {
            index = (bIndex + i) % xPoints.length;
            second[0][i] = xPoints[index];
            second[1][i] = yPoints[index];
        }
        int[][][] result = new int[][][]{first, second};
        return result;
    }

    static int[][] trimEar(int[] xPoints, int[] yPoints, int earIndex) {
        int[] newXPoints = new int[xPoints.length - 1];
        int[] newYPoints = new int[yPoints.length - 1];
        int[][] newPoly = new int[][]{newXPoints, newYPoints};
        int p = 0;
        for (int i = 0; i < xPoints.length; ++i) {
            if (i == earIndex) continue;
            newXPoints[p] = xPoints[i];
            newYPoints[p] = yPoints[i];
            ++p;
        }
        return newPoly;
    }

    static int indexOfLeast(int[] elements) {
        int index = 0;
        int least = elements[0];
        for (int i = 1; i < elements.length; ++i) {
            if (elements[i] >= least) continue;
            index = i;
            least = elements[i];
        }
        return index;
    }

    private static boolean sameSide(int p1x, int p1y, int p2x, int p2y, int l1x, int l1y, int l2x, int l2y) {
        long lhs = (p1x - l1x) * (l2y - l1y) - (l2x - l1x) * (p1y - l1y);
        long rhs = (p2x - l1x) * (l2y - l1y) - (l2x - l1x) * (p2y - l1y);
        long product = lhs * rhs;
        boolean result = product >= 0L;
        return result;
    }

    private static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    private static int max(int a, int b, int c) {
        return Math.max(Math.max(a, b), c);
    }

    public static EShape findShape(EffectGroup group, int id) {
        for (int k = 0; k < group.getSize(); ++k) {
            Effect effect = group.getEffect(k);
            Vector effectLayers = effect.getEffectLayers();
            int maxTimeFrames = Util.getMaxTimeFrame(group, k);
            for (int j = 0; j <= maxTimeFrames; ++j) {
                for (int i = 0; i < effectLayers.size(); ++i) {
                    EffectLayer object = (EffectLayer)effectLayers.elementAt(i);
                    TimeFrame tf = object.getTimeFrame(j);
                    if (tf == null) continue;
                    Vector shapes = tf.getShapes();
                    for (int l = 0; l < shapes.size(); ++l) {
                        EShape shapeobject = (EShape)shapes.elementAt(l);
                        if (shapeobject.getId() != id) continue;
                        return shapeobject;
                    }
                }
            }
        }
        return null;
    }

    public static int getMaxTimeFrame(EffectGroup group, int effectIndex) {
        Effect effect = group.getEffect(effectIndex);
        Vector vector = effect.getEffectLayers();
        int maxTimeFrame = 0;
        for (int i = 0; i < vector.size(); ++i) {
            EffectLayer effectLayer = (EffectLayer)vector.elementAt(i);
            Vector timeFrames = effectLayer.getTimeFrames();
            for (int j = 0; j < timeFrames.size(); ++j) {
                TimeFrame object = (TimeFrame)timeFrames.elementAt(j);
                if (object.getTimeFrameId() <= maxTimeFrame) continue;
                maxTimeFrame = object.getTimeFrameId();
            }
        }
        return maxTimeFrame;
    }

    public static void setResizePercent(int resizePercent) {
        Util.resizePercent = resizePercent;
    }

    public static EffectGroup loadEffect(byte[] data) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        LOADING_VERSION = com.appon.miniframework.Util.readInt(bis, 1);
        EffectGroup container = (EffectGroup)EffectsSerilize.deserialize(bis, EffectsSerilize.getInstance());
        if (resizePercent != 0) {
            Util.rescale(container, resizePercent);
        }
        return container;
    }

    public static void rescale(EffectGroup group, int percent) {
        for (int k = 0; k < group.getSize(); ++k) {
            Effect effect = group.getEffect(k);
            Vector effectLayers = effect.getEffectLayers();
            int maxTimeFrames = Util.getMaxTimeFrame(group, k);
            for (int j = 0; j <= maxTimeFrames; ++j) {
                for (int i = 0; i < effectLayers.size(); ++i) {
                    EffectLayer object = (EffectLayer)effectLayers.elementAt(i);
                    TimeFrame tf = object.getTimeFrame(j);
                    if (tf == null) continue;
                    Vector shapes = tf.getShapes();
                    for (int l = 0; l < shapes.size(); ++l) {
                        EShape shapeobject = (EShape)shapes.elementAt(l);
                        Util.portShape(percent, shapeobject);
                    }
                }
            }
        }
    }

    public static void portShape(int per, EShape selShape) {
        if (selShape != null) {
            if (selShape instanceof ELine) {
                ELine line = (ELine)selShape;
                line.setX(Util.getScaleValue(line.getX(), per));
                line.setY(Util.getScaleValue(line.getY(), per));
                line.setX2(Util.getScaleValue(line.getX2(), per));
                line.setY2(Util.getScaleValue(line.getY2(), per));
            } else if (selShape instanceof EPolygon) {
                EPolygon poly = (EPolygon)selShape;
                int[] x = poly.getXPoints();
                int[] y = poly.getYPoints();
                for (int i = 0; i < x.length; ++i) {
                    x[i] = Util.getScaleValue(x[i], per);
                    y[i] = Util.getScaleValue(y[i], per);
                }
            } else if (selShape instanceof ETraingle) {
                ETraingle trai = (ETraingle)selShape;
                int[] x = trai.getXPoints();
                int[] y = trai.getYPoints();
                for (int i = 0; i < x.length; ++i) {
                    x[i] = Util.getScaleValue(x[i], per);
                    y[i] = Util.getScaleValue(y[i], per);
                }
            } else if (selShape instanceof ERect) {
                ERect line = (ERect)selShape;
                line.setX(Util.getScaleValue(line.getX(), per));
                line.setY(Util.getScaleValue(line.getY(), per));
                line.setWidth(Util.getScaleValue(line.getWidth(), per));
                line.setHeight(Util.getScaleValue(line.getHeight(), per));
            } else if (selShape instanceof EArc) {
                EArc line = (EArc)selShape;
                line.setX(Util.getScaleValue(line.getX(), per));
                line.setY(Util.getScaleValue(line.getY(), per));
                line.setWidth(Util.getScaleValue(line.getWidth(), per));
                line.setHeight(Util.getScaleValue(line.getHeight(), per));
            } else {
                selShape.setX(Util.getScaleValue(selShape.getX(), per));
                selShape.setY(Util.getScaleValue(selShape.getY(), per));
            }
        }
    }

    public static int approx_distance(int dx, int dy) {
        int max;
        int min;
        if (dx < 0) {
            dx = -dx;
        }
        if (dy < 0) {
            dy = -dy;
        }
        if (dx < dy) {
            min = dx;
            max = dy;
        } else {
            min = dy;
            max = dx;
        }
        return (max << 8) + (max << 3) - (max << 4) - (max << 1) + (min << 7) - (min << 5) + (min << 3) - (min << 1) >> 8;
    }

    public static void drawThickLine(Graphics g, int x1, int y1, int x2, int y2, int thickness) {
        if (thickness <= 1) {
            g.drawLine(x1, y1, x2, y2);
            return;
        }
        int dX = x2 - x1;
        int dY = y2 - y1;
        int lineLength = Util.approx_distance(dX, dY);
        if (lineLength == 0) {
            lineLength = 1;
        }
        int scale = (thickness << 14) / (2 * lineLength);
        int ddx = -scale * dY;
        int ddy = scale * dX;
        int n = ddy >> 14 > 0 ? 8192 : -8192;
        int dx = (ddx += ddx >> 14 > 0 ? 8192 : -8192) >> 14;
        int dy = (ddy += n) >> 14;
        Util.xPoints[0] = x1 + dx;
        Util.yPoints[0] = y1 + dy;
        Util.xPoints[1] = x1 - dx;
        Util.yPoints[1] = y1 - dy;
        Util.xPoints[2] = x2 - dx;
        Util.yPoints[2] = y2 - dy;
        Util.xPoints[3] = x2 + dx;
        Util.yPoints[3] = y2 + dy;
        Util.fillPolygon(g, xPoints, yPoints);
    }

    public static void drawArc(Graphics g, int x, int y, int width, int height, int startangle, int endAngle, int thickness) {
        if (thickness <= 1) {
            g.drawArc(x, y, width, height, startangle, endAngle);
            return;
        }
        for (int i = 0; i < thickness; ++i) {
            g.drawArc(x + i, y + i, width - (i << 1), height - (i << 1), startangle, endAngle);
        }
    }

    public static void drawRectangle(Graphics g, int x, int y, int width, int height, int thickness) {
        if (thickness <= 1) {
            g.drawRect(x, y, width, height);
            return;
        }
        for (int i = 0; i < thickness; ++i) {
            g.drawRect(x + i, y + i, width - (i << 1), height - (i << 1));
        }
    }

    public static Point rotatePoint(Point pt, int anchorX, int anchorY, int theta, int zoom, EShape shape) {
        if (zoom != 0) {
            pt.x = Util.getScaleValue(pt.x, zoom);
            pt.y = Util.getScaleValue(pt.y, zoom);
        }
        if (theta == 0) {
            return pt;
        }
        pt.x += shape.getWidth() >> 1;
        pt.y += shape.getHeight() >> 1;
        int d = theta;
        int tmpX1 = pt.x;
        int tmpY1 = pt.y;
        int centerX = anchorX;
        int centerY = anchorY;
        int tmpValue = 0;
        tmpValue = (tmpX1 -= centerX) * ProjectileMotion.cos(d) - (tmpY1 -= centerY) * ProjectileMotion.sin(d) >> 14;
        tmpY1 = tmpX1 * ProjectileMotion.sin(d) + tmpY1 * ProjectileMotion.cos(d) >> 14;
        tmpX1 = tmpValue;
        pt.x = tmpX1 += centerX;
        pt.y = tmpY1 += centerY;
        pt.x -= shape.getWidth() >> 1;
        pt.y -= shape.getHeight() >> 1;
        return pt;
    }

    public static int getScaleValue(int value, int scale) {
        if (scale == 0) {
            return value;
        }
        value += value * scale / 100;
        return value;
    }

    public static int getMaxTimeFrame(Effect effect) {
        Vector vector = effect.getEffectLayers();
        int maxTimeFrame = 0;
        for (int i = 0; i < vector.size(); ++i) {
            EffectLayer effectLayer = (EffectLayer)vector.elementAt(i);
            Vector timeFrames = effectLayer.getTimeFrames();
            for (int j = 0; j < timeFrames.size(); ++j) {
                TimeFrame object = (TimeFrame)timeFrames.elementAt(j);
                if (object.getTimeFrameId() <= maxTimeFrame) continue;
                maxTimeFrame = object.getTimeFrameId();
            }
        }
        return maxTimeFrame;
    }

    public static int findLayerIndex(Effect effect, int id) {
        Vector effectLayers = effect.getEffectLayers();
        int maxTimeFrames = Util.getMaxTimeFrame(effect);
        for (int j = 0; j <= maxTimeFrames; ++j) {
            for (int i = 0; i < effectLayers.size(); ++i) {
                EffectLayer object = (EffectLayer)effectLayers.elementAt(i);
                TimeFrame tf = object.getTimeFrame(j);
                if (tf == null) continue;
                Vector shapes = tf.getShapes();
                for (int l = 0; l < shapes.size(); ++l) {
                    EShape shapeobject = (EShape)shapes.elementAt(l);
                    if (shapeobject.getId() != id) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public static int findTimeFrameIndex(Effect effect, int id) {
        Vector effectLayers = effect.getEffectLayers();
        int maxTimeFrames = Util.getMaxTimeFrame(effect);
        for (int j = 0; j <= maxTimeFrames; ++j) {
            for (int i = 0; i < effectLayers.size(); ++i) {
                EffectLayer object = (EffectLayer)effectLayers.elementAt(i);
                TimeFrame tf = object.getTimeFrame(j);
                if (tf == null) continue;
                Vector shapes = tf.getShapes();
                for (int l = 0; l < shapes.size(); ++l) {
                    EShape shapeobject = (EShape)shapes.elementAt(l);
                    if (shapeobject.getId() != id) continue;
                    return j;
                }
            }
        }
        return -1;
    }
}

