/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.layout;

import com.appon.miniframework.Container;
import com.appon.miniframework.Control;
import com.appon.miniframework.Layout;
import com.appon.miniframework.Util;
import com.appon.miniframework.layout.RelativeLayout;
import java.io.ByteArrayInputStream;

public class LinearLayout
implements Layout {
    public static final int ORIANTATION_VERTICAL = 0;
    public static final int ORIANTATION_HORIZONTAL = 1;
    public static final int PADDING_EQUAL = 1;
    public static final int PADDING_CUSTOM = 0;
    public static final int ALLIGNMENT_TOP_OF_PARENT = 0;
    public static final int ALLIGNMENT_BOTTOM_OF_PARENT = 1;
    public static final int ALLIGNMENT_CENTER_OF_PARENT = 2;
    public static final int ALLIGNMENT_LEFT_OF_PARENT = 0;
    public static final int ALLIGNMENT_RIGHT_OF_PARENT = 1;
    private int allignmentX;
    private int allignmentY;
    private int paddingType;
    private int padding;
    private int oriantation;
    private int offset;
    private boolean portOffset;
    private boolean portPadding;
    private int oppositeAdditionalPadding;
    private boolean portOppsiteAdditionalPadding;

    public int getAllignmentX() {
        return this.allignmentX;
    }

    public void setAllignmentX(int allignmentX) {
        this.allignmentX = allignmentX;
    }

    public int getOppositeAdditionalPadding() {
        return this.oppositeAdditionalPadding;
    }

    public void setOppositeAdditionalPadding(int oppositeAdditionalPadding) {
        this.oppositeAdditionalPadding = oppositeAdditionalPadding;
    }

    public boolean isPortOppsiteAdditionalPadding() {
        return this.portOppsiteAdditionalPadding;
    }

    public void setPortOppsiteAdditionalPadding(boolean portOppsiteAdditionalPadding) {
        this.portOppsiteAdditionalPadding = portOppsiteAdditionalPadding;
    }

    public int getTotalChildsWidth(Container c) {
        int width = 0;
        for (int i = 0; i < c.getSize(); ++i) {
            Control control = c.getChild(i);
            if (!control.isVisible()) continue;
            width += control.getWidth();
        }
        return width;
    }

    public int getTotalChildsHeight(Container c) {
        int width = 0;
        for (int i = 0; i < c.getSize(); ++i) {
            Control control = c.getChild(i);
            if (!control.isVisible()) continue;
            width += control.getHeight();
        }
        return width;
    }

    public int getAllignmentY() {
        return this.allignmentY;
    }

    public void setAllignmentY(int allignmentY) {
        this.allignmentY = allignmentY;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOriantation() {
        return this.oriantation;
    }

    public void setOriantation(int oriantation) {
        this.oriantation = oriantation;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public int getPaddingType() {
        return this.paddingType;
    }

    public void setPaddingType(int paddingType) {
        this.paddingType = paddingType;
    }

    public boolean isPortOffset() {
        return this.portOffset;
    }

    public void setPortOffset(boolean portOffset) {
        this.portOffset = portOffset;
    }

    public boolean isPortPadding() {
        return this.portPadding;
    }

    public void setPortPadding(boolean portPadding) {
        this.portPadding = portPadding;
    }

    public void applyLayout(Container parent, Control currentContainer) {
        if (!(currentContainer instanceof Container)) {
            throw new RuntimeException("Linear layout can be applied only on Container");
        }
        Container container = (Container)currentContainer;
        if (this.oriantation == 0) {
            if (this.paddingType == 1) {
                this.padding = (container.getBoundHeight() - this.getTotalChildsHeight(container) - this.offset * 2) / (container.getSize() - 1);
                if (this.padding < 0) {
                    this.padding = 0;
                }
            }
            int startY = this.offset;
            int startX = 0;
            if (this.allignmentY == 2) {
                int totalHeight = (container.getSize() - 1) * this.padding + this.getTotalChildsHeight(container);
                startY = container.getBoundHeight() - totalHeight >> 1;
            } else if (this.allignmentY == 1) {
                startY = container.getBoundHeight() - this.offset;
            }
            for (int i = 0; i < container.getSize(); ++i) {
                Control c = container.getChild(i);
                if (c.getRelativeLocation() != null) continue;
                if (this.allignmentY == 1) {
                    startY -= c.getHeight();
                }
                if (this.allignmentX == 0) {
                    startX = this.oppositeAdditionalPadding;
                } else if (this.allignmentX == 1) {
                    startX = container.getBoundWidth() - c.getWidth() - this.oppositeAdditionalPadding;
                } else {
                    startX = container.getBoundWidth() - c.getWidth() >> 1;
                    startX += this.oppositeAdditionalPadding;
                }
                if (startY < 0) {
                    startY = 0;
                }
                c.setPoistion(startX, startY);
                if (this.allignmentY == 1) {
                    startY -= this.padding;
                    continue;
                }
                startY += this.padding + c.getHeight();
            }
        } else {
            if (this.paddingType == 1) {
                this.padding = (container.getBoundWidth() - this.getTotalChildsWidth(container) - this.offset * 2) / (container.getSize() - 1);
                if (this.padding < 0) {
                    this.padding = 0;
                }
            }
            int startX = this.offset;
            int startY = 0;
            if (this.allignmentX == 2) {
                int totalWidth = (container.getSize() - 1) * this.padding + this.getTotalChildsWidth(container);
                startX = container.getBoundWidth() - totalWidth >> 1;
            } else if (this.allignmentX == 1) {
                startX = container.getBoundWidth() - this.offset;
            }
            for (int i = 0; i < container.getSize(); ++i) {
                Control c = container.getChild(i);
                if (this.allignmentX == 1) {
                    startX -= c.getWidth();
                }
                startY = this.allignmentY == 0 ? this.oppositeAdditionalPadding : (this.allignmentY == 1 ? container.getBoundHeight() - c.getHeight() - this.oppositeAdditionalPadding : container.getBoundHeight() - c.getHeight() >> 1);
                if (startX < 0) {
                    startX = 0;
                }
                if (!(c.getLayout() instanceof RelativeLayout)) {
                    c.setPoistion(startX, startY);
                }
                if (this.allignmentX == 1) {
                    startX -= this.padding;
                    continue;
                }
                startX += this.padding + c.getWidth();
            }
        }
    }

    public byte[] serialize() throws Exception {
        return null;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        this.setOriantation(Util.readInt(bis, 1));
        this.setAllignmentX(Util.readInt(bis, 1));
        this.setAllignmentY(Util.readInt(bis, 1));
        this.setOffset(Util.readSignedInt(bis, 2));
        this.setPaddingType(Util.readInt(bis, 1));
        this.setPadding(Util.readSignedInt(bis, 2));
        this.setOppositeAdditionalPadding(Util.readSignedInt(bis, 2));
        this.setPortOppsiteAdditionalPadding(Util.readBoolean(bis));
        this.setPortOffset(Util.readBoolean(bis));
        this.setPortPadding(Util.readBoolean(bis));
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 1007;
    }

    public void port() {
        int scaleX = Util.getScaleX();
        int scaleY = Util.getScaleY();
        if (this.isPortOffset()) {
            if (this.getOriantation() == 0) {
                this.setOffset(Util.getScaleValue(this.getOffset(), scaleY));
            } else {
                this.setOffset(Util.getScaleValue(this.getOffset(), scaleX));
            }
        }
        if (this.isPortOppsiteAdditionalPadding()) {
            if (this.getOriantation() == 0) {
                this.setOppositeAdditionalPadding(Util.getScaleValue(this.getOppositeAdditionalPadding(), scaleX));
            } else {
                this.setOppositeAdditionalPadding(Util.getScaleValue(this.getOppositeAdditionalPadding(), scaleY));
            }
        }
        if (this.isPortPadding()) {
            if (this.getOriantation() == 0) {
                this.setPadding(Util.getScaleValue(this.getPadding(), scaleY));
            } else {
                this.setPadding(Util.getScaleValue(this.getPadding(), scaleX));
            }
        }
    }

    public int getPreferedWidth(Container control) {
        if (this.oriantation == 1) {
            int h = this.getOffset() << 1;
            h += this.getPadding() * (control.getSize() - 1);
            for (int i = 0; i < control.getSize(); ++i) {
                h += Util.getChildernLayoutWrapWidth(control.getChild(i));
            }
            return h;
        }
        int max = this.getOppositeAdditionalPadding();
        for (int i = 0; i < control.getSize(); ++i) {
            int val = this.getOppositeAdditionalPadding() + Util.getChildernLayoutWrapWidth(control.getChild(i));
            if (val <= max) continue;
            max = val;
        }
        return max;
    }

    public int getPreferedHeight(Container control) {
        if (this.oriantation == 0) {
            int h = this.getOffset() << 1;
            h += this.getPadding() * (control.getSize() - 1);
            for (int i = 0; i < control.getSize(); ++i) {
                h += Util.getChildernLayoutWrapHeight(control.getChild(i));
            }
            return h;
        }
        int max = 0;
        for (int i = 0; i < control.getSize(); ++i) {
            int val = this.getOppositeAdditionalPadding() + Util.getChildernLayoutWrapHeight(control.getChild(i));
            if (val <= max) continue;
            max = val;
        }
        return max;
    }
}

