/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework;

import java.util.NoSuchElementException;

public class Queue {
    private int N;
    private Node first = null;
    private Node last = null;

    public boolean isEmpty() {
        return this.first == null;
    }

    public int size() {
        return this.N;
    }

    public Object peek() {
        if (this.isEmpty()) {
            throw new RuntimeException("Queue underflow");
        }
        return this.first.item;
    }

    public void enqueue(Object item) {
        Node x = new Node();
        x.item = item;
        if (this.isEmpty()) {
            this.first = x;
            this.last = x;
        } else {
            this.last.next = x;
            this.last = x;
        }
        ++this.N;
    }

    public Object dequeue() {
        if (this.isEmpty()) {
            throw new RuntimeException("Queue underflow");
        }
        Object item = this.first.item;
        this.first = this.first.next;
        --this.N;
        if (this.isEmpty()) {
            this.last = null;
        }
        return item;
    }

    public void clear() {
        this.first = null;
        this.last = null;
        this.N = 0;
    }

    public FIFOIterator iterator() {
        return new FIFOIterator();
    }

    private class FIFOIterator {
        private Node current;

        private FIFOIterator() {
            this.current = Queue.this.first;
        }

        public boolean hasNext() {
            return this.current != null;
        }

        public void remove() {
            throw new RuntimeException();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object item = this.current.item;
            this.current = this.current.next;
            return item;
        }
    }

    private class Node {
        private Object item;
        private Node next;

        private Node() {
        }
    }
}

