/*
 * Decompiled with CFR 0.152.
 */
package hello;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.BasicJoint;
import net.phys2d.raw.Body;
import net.phys2d.raw.BodyList;
import net.phys2d.raw.CollisionEvent;
import net.phys2d.raw.CollisionListener;
import net.phys2d.raw.World;
import net.phys2d.raw.shapes.Box;
import net.phys2d.raw.shapes.Circle;
import net.phys2d.raw.strategies.QuadSpaceStrategy;

public class HelloCanvas
extends Canvas
implements Runnable,
CollisionListener {
    World world = new World(new Vector2f(0.0f, 1000.0f), 10, new QuadSpaceStrategy(20, 5));
    int BRICKS = 5;
    BodyList bodylist = new BodyList();
    Body bodyHuman;
    Body bodyHuman1;
    BasicJoint bj;
    Body box;
    int backGroundLength = this.getWidth() / 3;
    int[] MAP = new int[]{1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0};
    int[] MAP_OBS = new int[]{0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int levelLocation = 0;
    int lastLoaded = 0;
    int[] BASIC_BOX_ID;
    int HUMAN_HEIGHT = 20;
    int adjustX = 0;
    float xV;
    float yV;
    boolean doit = false;
    int n = 0;

    public HelloCanvas() {
        this.setFullScreenMode(true);
        System.out.println(this.getWidth() + "    " + this.getHeight());
        this.loadHumanBody();
        this.basicLoadLevel();
        this.loadLevel();
    }

    public void basicLoadLevel() {
        if (this.levelLocation + 6 > this.lastLoaded) {
            for (int i = this.levelLocation; i < this.levelLocation + 6; ++i) {
                Body body;
                int H;
                if (this.MAP[i] == 1) {
                    H = 200;
                    body = new Body("player" + i, new Box(this.backGroundLength, 10.0f), (float)H);
                    body.setPosition(i * this.backGroundLength + this.backGroundLength / 2, this.getHeight() / 2);
                    body.setGravityEffected(false);
                    body.setMoveable(false);
                    body.setRotatable(false);
                    this.bodylist.add(body);
                    this.world.add(body);
                }
                if (this.MAP[i] == 2) {
                    H = 200;
                    body = new Body("player" + i, new Box(this.backGroundLength, 10.0f), (float)H);
                    body.setPosition(i * this.backGroundLength + this.backGroundLength / 2, this.getHeight() / 2);
                    body.setGravityEffected(false);
                    this.bodylist.add(body);
                    this.world.add(body);
                    body = new Body("player2" + i, new Box(this.backGroundLength, this.getHeight() * 2 / 3), (float)H);
                    body.setPosition(i * this.backGroundLength + this.backGroundLength / 2, 0.0f);
                    body.setGravityEffected(false);
                    body.setMoveable(false);
                    body.setRotatable(false);
                    this.bodylist.add(body);
                    this.world.add(body);
                }
                if (this.MAP_OBS[i] != 1) continue;
                for (int j = 0; j < 3; ++j) {
                    body = new Body("boxes_" + i + "_" + j, new Box(20.0f, 20.0f), 10.0f);
                    body.setPosition(i * this.backGroundLength + this.backGroundLength / 2 + j * 20, -50.0f);
                    body.setRotation(j);
                    body.addForce(new Vector2f(-100.0f, 100000.0f));
                    this.bodylist.add(body);
                    this.world.add(body);
                }
            }
        }
        this.lastLoaded = this.levelLocation + 6;
    }

    public void loadLevel() {
        if (this.levelLocation + 6 > this.lastLoaded && this.levelLocation + 7 < this.MAP.length) {
            for (int i = this.levelLocation + 6; i < this.levelLocation + 7; ++i) {
                Body body;
                int H;
                if (this.MAP[i] == 1) {
                    H = 200;
                    body = new Body("player" + i, new Box(this.backGroundLength, 10.0f), (float)H);
                    body.setPosition(i * this.backGroundLength + this.backGroundLength / 2, this.getHeight() / 2);
                    body.setGravityEffected(false);
                    body.setMoveable(false);
                    body.setRotatable(false);
                    this.bodylist.add(body);
                    this.world.add(body);
                }
                if (this.MAP[i] == 2) {
                    H = 200;
                    body = new Body("player" + i, new Box(this.backGroundLength, 10.0f), (float)H);
                    body.setPosition(i * this.backGroundLength + this.backGroundLength / 2, this.getHeight() / 2);
                    body.setGravityEffected(false);
                    body.setMoveable(false);
                    body.setRotatable(false);
                    this.bodylist.add(body);
                    this.world.add(body);
                    body = new Body("player2" + i, new Box(this.backGroundLength, this.getHeight() * 2 / 3), (float)H);
                    body.setPosition(i * this.backGroundLength + this.backGroundLength / 2, 0.0f);
                    body.setGravityEffected(false);
                    body.setMoveable(false);
                    body.setRotatable(false);
                    this.bodylist.add(body);
                    this.world.add(body);
                }
                if (this.MAP_OBS[i] != 1) continue;
                for (int j = 0; j < 3; ++j) {
                    body = new Body("boxes_" + i + "_" + j, new Box(20.0f, 20.0f), 10.0f);
                    body.setPosition(i * this.backGroundLength + this.backGroundLength / 2 + j * 20, -50.0f);
                    body.setRotation(j);
                    body.addForce(new Vector2f(-100.0f, 100000.0f));
                    this.bodylist.add(body);
                    this.world.add(body);
                }
            }
        }
        this.lastLoaded = this.levelLocation + 6;
    }

    public void removeLevel() {
        if (this.levelLocation - 1 > 0) {
            // empty if block
        }
    }

    public void loadHumanBody() {
        this.bodyHuman = new Body("circle", new Circle(this.HUMAN_HEIGHT / 2), 10.0f);
        this.bodyHuman.setPosition(20.0f, this.getHeight() / 2 - 15);
        this.bodyHuman.addForce(new Vector2f(100000.0f, 0.0f));
        System.out.println("Friction=" + this.bodyHuman.getFriction());
        this.bodylist.add(this.bodyHuman);
        this.bodylist.add(this.bodyHuman1);
        this.world.add(this.bodyHuman);
        this.world.addListener(this);
    }

    protected void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.translate(50, 0);
        g.setColor(0, 0, 0);
        for (int i = 0; i < this.bodylist.size(); ++i) {
            ROVector2f v1;
            Body body = this.bodylist.get(i);
            try {
                if (body.getShape() == (Box)body.getShape()) {
                    Box box = (Box)body.getShape();
                    Vector2f[] pts = box.getPoints(body.getPosition(), body.getRotation());
                    v1 = pts[0];
                    Vector2f v2 = pts[1];
                    Vector2f v3 = pts[2];
                    Vector2f v4 = pts[3];
                    g.drawLine((int)((Vector2f)v1).x - this.adjustX, (int)((Vector2f)v1).y, (int)v2.x - this.adjustX, (int)v2.y);
                    g.drawLine((int)v2.x - this.adjustX, (int)v2.y, (int)v3.x - this.adjustX, (int)v3.y);
                    g.drawLine((int)v3.x - this.adjustX, (int)v3.y, (int)v4.x - this.adjustX, (int)v4.y);
                    g.drawLine((int)v4.x - this.adjustX, (int)v4.y, (int)((Vector2f)v1).x - this.adjustX, (int)((Vector2f)v1).y);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (body.getShape() != (Circle)body.getShape()) continue;
                Circle cir = (Circle)body.getShape();
                int r = (int)cir.getRadius();
                v1 = body.getPosition();
                g.drawArc((int)v1.getX() - r - this.adjustX, (int)v1.getY() - r, 2 * r, 2 * r, 0, 360);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.adjustX = (int)this.bodyHuman.getPosition().getX();
            this.levelLocation = this.adjustX / this.backGroundLength;
            this.loadLevel();
            this.removeLevel();
            if (this.checkBottomSlab()) {
                this.bodyHuman.addForce(new Vector2f(1000.0f + (float)this.n * 100.0f, 0.0f));
                ++this.n;
            }
            System.out.println(this.n);
            this.world.step();
            this.repaint();
        }
    }

    public void collisionOccured(CollisionEvent event) {
        if (!(event.getBodyB().toString().indexOf("boxes") <= 0 && event.getBodyA().toString().indexOf("boxes") <= 0 || event.getBodyB().toString().indexOf("circle") <= 0 && event.getBodyA().toString().indexOf("circle") <= 0 || this.checkBottomSlab())) {
            this.n = this.n * 2 / 3;
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.checkBottomSlab()) {
            this.bodyHuman.addForce(new Vector2f(10000.0f, -150000.0f));
        }
    }

    public void keyPressed(int key) {
    }

    public boolean checkBottomSlab() {
        for (int i = 0; i < this.bodylist.size(); ++i) {
            Body body = this.bodylist.get(i);
            try {
                if (body.getShape() != (Box)body.getShape()) continue;
                Box box = (Box)body.getShape();
                Vector2f[] pts = box.getPoints(body.getPosition(), body.getRotation());
                Vector2f v1 = pts[0];
                Vector2f v2 = pts[1];
                Vector2f v3 = pts[2];
                Vector2f v4 = pts[3];
                if (!(v1.x < this.bodyHuman.getPosition().getX()) || !(v2.x > this.bodyHuman.getPosition().getX()) || !(v1.y < this.bodyHuman.getPosition().getY() + (float)this.HUMAN_HEIGHT) && !(v2.y < this.bodyHuman.getPosition().getY() + (float)this.HUMAN_HEIGHT)) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

