/*
 * Decompiled with CFR 0.152.
 */
package com.appon.util;

import com.appon.gtantra.GFont;
import com.appon.gtantra.LineEnumeration;
import com.appon.util.Util;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScrollableBox {
    public String[] text;
    private GFont font;
    private boolean isScrollable;
    private int anchor;
    private int startY;
    private int scrolledY;
    private int width;
    private int height;
    private Image downArrow;
    private static final int ARROW_PADDING = 2;
    private int origionalHeight;
    private int maxScrolledY;
    private int lastY;
    private int paintX;
    private int paintY;
    private int actualHeight;

    public ScrollableBox(String string, GFont font, int width, int height, Image downArrow, int anchor) {
        int totalHeight;
        this.font = font;
        this.text = new LineEnumeration(font, string, width).wrapText(string, width);
        this.origionalHeight = height;
        this.actualHeight = totalHeight = this.text.length * font.getFontHeight();
        this.anchor = anchor;
        if (height < totalHeight) {
            this.isScrollable = true;
            this.startY = downArrow.getHeight() + 2;
            height -= (downArrow.getHeight() << 1) + 4;
        }
        this.width = width;
        this.height = height;
        this.downArrow = downArrow;
        this.maxScrolledY = totalHeight - height;
        if (this.isScrollable) {
            if ((anchor & 4) != 0) {
                anchor = 4;
            }
            if ((anchor & 8) != 0) {
                anchor = 8;
            }
            if ((anchor & 1) != 0) {
                anchor = 1;
            }
            this.anchor = anchor;
        }
    }

    public void setHeight(int height) {
        this.origionalHeight = height;
        if (height < this.actualHeight) {
            this.isScrollable = true;
            this.startY = this.downArrow.getHeight() + 2;
            height -= (this.downArrow.getHeight() << 1) + 4;
        } else {
            this.isScrollable = false;
            this.startY = 0;
        }
        this.height = height;
        this.maxScrolledY = this.actualHeight - height;
    }

    public void paint(Graphics g, int x, int y) {
        this.paintX = x;
        this.paintY = y;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if (this.isScrollable) {
            if (this.scrolledY < 0) {
                g.drawRegion(this.downArrow, 0, 0, this.downArrow.getWidth(), this.downArrow.getHeight(), 3, x + (this.width - this.downArrow.getWidth() >> 1), y, 0);
            }
            if (this.scrolledY > -this.maxScrolledY) {
                g.drawImage(this.downArrow, x + (this.width - this.downArrow.getWidth() >> 1), y + this.origionalHeight - this.downArrow.getHeight(), 0);
            }
        }
        g.setClip(x, y + this.startY, this.width, this.height);
        g.translate(0, this.scrolledY);
        this.font.drawPage(g, this.text, x, y + this.startY, this.width, this.height, this.anchor);
        g.translate(0, -this.scrolledY);
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public boolean isIsScrollable() {
        return this.isScrollable;
    }

    public int getActualHeight() {
        return this.actualHeight;
    }

    public int getOrigionalHeight() {
        return this.origionalHeight;
    }

    public void keyPressed(int gameKey) {
        if (!this.isScrollable) {
            return;
        }
        if (Util.isUpPressed(this.anchor, gameKey) && this.scrolledY < 0) {
            this.scrolledY += this.font.getFontHeight();
        } else if (Util.isDownPressed(this.anchor, gameKey) && this.scrolledY > -this.maxScrolledY) {
            this.scrolledY -= this.font.getFontHeight();
        }
    }

    public void pointerPressed(int x, int y) {
        if (!this.isScrollable) {
            return;
        }
        this.lastY = y;
        if (Util.isInRect(this.paintX, this.paintY, this.width, this.downArrow.getHeight(), x, y)) {
            this.keyPressed(1);
        }
        if (Util.isInRect(this.paintX, this.paintY + this.origionalHeight - this.downArrow.getHeight(), this.width, this.downArrow.getHeight(), x, y)) {
            this.keyPressed(6);
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.isScrollable) {
            return;
        }
        int diff = y - this.lastY;
        this.lastY = y;
        if (Util.isInRect(this.paintX, this.paintY, this.width, this.origionalHeight, x, y)) {
            this.scrolledY += diff;
            if (this.scrolledY < -this.maxScrolledY) {
                this.scrolledY = -this.maxScrolledY;
            } else if (this.scrolledY > 0) {
                this.scrolledY = 0;
            }
        }
    }
}

