/*
 * Decompiled with CFR 0.152.
 */
package com.appon.util;

public class LineWalker {
    private int initialX;
    private int initialY;
    private int finalX;
    private int finalY;
    private int currentX;
    private int currentY;
    private int xAdder;
    private int yAdder;
    private static final int FP = 12;
    private int steps;
    private int totalPoints;

    public void init(int intialX, int intialY, int finalX, int finalY) {
        this.initialX = intialX;
        this.initialY = intialY;
        this.finalX = finalX;
        this.finalY = finalY;
        this.init();
    }

    private void init() {
        this.steps = 0;
        this.currentX = 0;
        this.currentY = 0;
        int xDiff = Math.abs(this.getInitialX() - this.finalX);
        int yDiff = Math.abs(this.getInitialY() - this.finalY);
        this.totalPoints = Math.max(xDiff, yDiff);
        if (this.totalPoints == 0) {
            this.steps = this.totalPoints + 1;
            return;
        }
        this.xAdder = (xDiff << 12) / this.totalPoints;
        this.yAdder = (yDiff << 12) / this.totalPoints;
        if (this.finalX < this.getInitialX()) {
            this.xAdder = -this.xAdder;
        }
        if (this.finalY < this.getInitialY()) {
            this.yAdder = -this.yAdder;
        }
    }

    public int getX() {
        return this.getInitialX() + (this.currentX >> 12);
    }

    public int getY() {
        return this.getInitialY() + (this.currentY >> 12);
    }

    public void update(int speed) {
        this.currentX += this.xAdder * speed;
        this.currentY += this.yAdder * speed;
        this.steps += speed;
    }

    public boolean isOver() {
        return this.steps >= this.totalPoints;
    }

    public int getInitialX() {
        return this.initialX;
    }

    public int getInitialY() {
        return this.initialY;
    }
}

