/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.animation;

import com.appon.miniframework.Settings;
import com.appon.miniframework.Util;
import com.appon.miniframework.animation.StartAnimation;
import java.io.ByteArrayInputStream;
import javax.microedition.lcdui.Graphics;

public class StartAnimationLinearMoveIn
extends StartAnimation {
    private int direction;
    private int movementType;
    private int speed = 5;
    private int actualSpeed;
    public static final int MOVE_FROM_RIGHT = 0;
    public static final int MOVE_FROM_LEFT = 1;
    public static final int MOVE_FROM_BOTTOM = 2;
    public static final int MOVE_FROM_TOP = 3;
    public static final int MOVEMENT_TYPES_STEPS = 0;
    public static final int MOVEMENT_TYPES_PIXELS = 1;
    private int refrenceFrom;
    public static final int REFRENCE_FROM_SCREEN = 0;
    public static final int REFRENCE_FROM_PARENT = 1;
    private int refrenceWidth;
    private int refrenceHeight;
    private int startDelay;
    private int tmpDelay;
    private boolean bringInRoatating;
    private int rotateSpeed;

    public int getDirection() {
        return this.direction;
    }

    public int getRotateSpeed() {
        return this.rotateSpeed;
    }

    public void setRotateSpeed(int rotateSpeed) {
        this.rotateSpeed = rotateSpeed;
    }

    public boolean isBringInRoatating() {
        return this.bringInRoatating;
    }

    public void setBringInRoatating(boolean bringInRoatating) {
        this.bringInRoatating = bringInRoatating;
    }

    public int getRefrenceFrom() {
        return this.refrenceFrom;
    }

    public int getStartDelay() {
        return this.startDelay;
    }

    public void setStartDelay(int startDelay) {
        this.startDelay = startDelay;
    }

    public void setRefrenceFrom(int refrenceFrom) {
        this.refrenceFrom = refrenceFrom;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getMovementType() {
        return this.movementType;
    }

    public void setMovementType(int movementType) {
        this.movementType = movementType;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void reset() {
        int _y;
        int _x;
        super.reset();
        if (this.refrenceFrom == 1 && this.control.getParent() != null) {
            this.refrenceWidth = this.control.getParent().getWidth();
            this.refrenceHeight = this.control.getParent().getWidth();
            _x = this.control.getX();
            _y = this.control.getY();
        } else {
            this.refrenceWidth = Settings.SCREEN_WIDTH;
            this.refrenceHeight = Settings.SCREEN_HEIGHT;
            _x = Util.getActualX(this.control);
            _y = Util.getActualY(this.control);
        }
        if (this.movementType == 0) {
            switch (this.getDirection()) {
                case 0: {
                    this.actualSpeed = (this.refrenceWidth - _x) / this.speed;
                    break;
                }
                case 1: {
                    this.actualSpeed = (_x + this.control.getWidth()) / this.speed;
                    break;
                }
                case 3: {
                    this.actualSpeed = (_y + this.control.getHeight()) / this.speed;
                    break;
                }
                case 2: {
                    this.actualSpeed = (this.refrenceHeight - _y) / this.speed;
                }
            }
        } else {
            this.actualSpeed = this.speed;
        }
        switch (this.getDirection()) {
            case 0: {
                this.control.setX(this.refrenceWidth - Util.getAddonParentsX(this.control));
                break;
            }
            case 1: {
                this.control.setX(-this.control.getWidth() - Util.getAddonParentsX(this.control));
                break;
            }
            case 3: {
                this.control.setY(-this.control.getHeight() - Util.getAddonParentsY(this.control));
                break;
            }
            case 2: {
                this.control.setY(this.refrenceHeight - Util.getAddonParentsY(this.control));
            }
        }
        this.tmpDelay = this.startDelay;
        if (this.isBringInRoatating()) {
            this.control.setRotation(0);
        }
    }

    public Object applyAnimation(Graphics g) {
        if (this.tmpDelay > 0) {
            --this.tmpDelay;
            return null;
        }
        if (this.isBringInRoatating()) {
            this.control.setRotation(this.control.getRotation() + this.getRotateSpeed());
        }
        switch (this.getDirection()) {
            case 0: {
                int newX = this.control.getX() - this.actualSpeed;
                if (this.refrenceFrom == 1) {
                    if (newX > this.getOrigionalX()) {
                        this.control.setX(newX);
                        break;
                    }
                    this.setIsAnimationOver(true);
                    break;
                }
                int checkX = Util.getActualX(this.control) - this.actualSpeed;
                if (checkX > this.getActualX()) {
                    this.control.setX(newX);
                    break;
                }
                this.setIsAnimationOver(true);
                break;
            }
            case 1: {
                int newX = this.control.getX() + this.actualSpeed;
                if (this.refrenceFrom == 1) {
                    if (newX < this.getOrigionalX()) {
                        this.control.setX(newX);
                        break;
                    }
                    this.setIsAnimationOver(true);
                    break;
                }
                int checkX = Util.getActualX(this.control) + this.actualSpeed;
                if (checkX < this.getActualX()) {
                    this.control.setX(newX);
                    break;
                }
                this.setIsAnimationOver(true);
                break;
            }
            case 3: {
                int newY = this.control.getY() + this.actualSpeed;
                if (this.refrenceFrom == 1) {
                    if (newY < this.getOrigionalY()) {
                        this.control.setY(newY);
                        break;
                    }
                    this.setIsAnimationOver(true);
                    break;
                }
                int checkY = Util.getActualY(this.control) + this.actualSpeed;
                if (checkY < this.getActualY()) {
                    this.control.setY(newY);
                    break;
                }
                this.setIsAnimationOver(true);
                break;
            }
            case 2: {
                int newY = this.control.getY() - this.actualSpeed;
                if (this.refrenceFrom == 1) {
                    if (newY > this.getOrigionalY()) {
                        this.control.setY(newY);
                        break;
                    }
                    this.setIsAnimationOver(true);
                    break;
                }
                int checkY = Util.getActualY(this.control) - this.actualSpeed;
                if (checkY > this.getActualY()) {
                    this.control.setY(newY);
                    break;
                }
                this.setIsAnimationOver(true);
            }
        }
        return null;
    }

    public byte[] serialize() throws Exception {
        return null;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        this.setDirection(Util.readInt(bis, 1));
        this.setMovementType(Util.readInt(bis, 1));
        this.setSpeed(Util.readInt(bis, 1));
        this.setRefrenceFrom(Util.readInt(bis, 1));
        this.setStartDelay(Util.readInt(bis, 1));
        this.setBringInRoatating(Util.readBoolean(bis));
        this.setRotateSpeed(Util.readSignedInt(bis, 2));
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 1011;
    }
}

