/*
 * Decompiled with CFR 0.152.
 */
package com.appon.car;

import com.appon.car.Point;

public class MathUtil {
    static final double sq2p1 = 2.414213562373095;
    static final double sq2m1 = 0.41421356237309503;
    static final double p4 = 16.15364129822302;
    static final double p3 = 268.42548195503974;
    static final double p2 = 1153.029351540485;
    static final double p1 = 1780.406316433197;
    static final double p0 = 896.7859740366387;
    static final double q4 = 58.95697050844462;
    static final double q3 = 536.2653740312153;
    static final double q2 = 1666.7838148816338;
    static final double q1 = 2079.33497444541;
    static final double q0 = 896.7859740366387;
    static final double PIO2 = 1.5707963267948966;
    static final double nan = Double.NaN;

    private static double mxatan(double arg) {
        double argsq = arg * arg;
        double value = (((16.15364129822302 * argsq + 268.42548195503974) * argsq + 1153.029351540485) * argsq + 1780.406316433197) * argsq + 896.7859740366387;
        return (value /= ((((argsq + 58.95697050844462) * argsq + 536.2653740312153) * argsq + 1666.7838148816338) * argsq + 2079.33497444541) * argsq + 896.7859740366387) * arg;
    }

    private static double msatan(double arg) {
        if (arg < 0.41421356237309503) {
            return MathUtil.mxatan(arg);
        }
        if (arg > 2.414213562373095) {
            return 1.5707963267948966 - MathUtil.mxatan(1.0 / arg);
        }
        return 0.7853981633974483 + MathUtil.mxatan((arg - 1.0) / (arg + 1.0));
    }

    public static double atan(double arg) {
        if (arg > 0.0) {
            return MathUtil.msatan(arg);
        }
        return -MathUtil.msatan(-arg);
    }

    public static double atan2(double arg1, double arg2) {
        if (arg1 + arg2 == arg1) {
            if (arg1 >= 0.0) {
                return 1.5707963267948966;
            }
            return -1.5707963267948966;
        }
        arg1 = MathUtil.atan(arg1 / arg2);
        if (arg2 < 0.0) {
            if (arg1 <= 0.0) {
                return arg1 + Math.PI;
            }
            return arg1 - Math.PI;
        }
        return arg1;
    }

    public static double asin(double arg) {
        int sign = 0;
        if (arg < 0.0) {
            arg = -arg;
            ++sign;
        }
        if (arg > 1.0) {
            return Double.NaN;
        }
        double temp = Math.sqrt(1.0 - arg * arg);
        temp = arg > 0.7 ? 1.5707963267948966 - MathUtil.atan(temp / arg) : MathUtil.atan(arg / temp);
        if (sign > 0) {
            temp = -temp;
        }
        return temp;
    }

    public static double acos(double arg) {
        if (arg > 1.0 || arg < -1.0) {
            return Double.NaN;
        }
        return 1.5707963267948966 - MathUtil.asin(arg);
    }

    public static double pow(double value, double pow) {
        int i = 0;
        while ((double)i < pow) {
            value *= value;
            ++i;
        }
        return value;
    }

    public static float correctEngle(float engle) {
        while (engle < 0.0f) {
            engle = 360.0f + engle;
        }
        while (engle > 360.0f) {
            engle -= 360.0f;
        }
        return engle;
    }

    public static float distance(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static Point getLineMiddlePoint(float x1, float y1, float x2, float y2) {
        return new Point((x1 + x2) / 2.0f, (y1 + y2) / 2.0f);
    }

    public static float getTheta(float x1, float y1, float x2, float y2) {
        float value = 0.0f;
        try {
            value = (x2 - x1) / (y2 - y1);
            value = (float)MathUtil.atan(value);
            value = (float)Math.toDegrees(value);
        }
        catch (Exception e) {
            value = 0.0f;
        }
        return value;
    }

    public static boolean isValidNumber(double value) {
        return value != Double.NEGATIVE_INFINITY && value != Double.POSITIVE_INFINITY;
    }

    public static boolean isLeft(Point a, Point b, Point c) {
        return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x) > 0.0f;
    }

    public static Point getLineIntersectionPoint(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        float Ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / ((y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1));
        float Ub = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / ((y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1));
        float x = x1 + Ua * (x2 - x1);
        float y = y1 + Ub * (y2 - y1);
        return new Point(x, y);
    }
}

