/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import java.util.Vector;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.BodyList;
import net.phys2d.raw.shapes.DynamicShape;
import net.phys2d.raw.shapes.Shape;

public strictfp class Body {
    int maxX;
    boolean collidable = true;
    private static int NEXT_ID = 0;
    public static final float INFINITE_MASS = Float.MAX_VALUE;
    private Vector2f position = new Vector2f();
    private Vector2f lastPosition = new Vector2f();
    private float rotation;
    private Vector2f velocity = new Vector2f();
    private float angularVelocity;
    private Vector2f lastVelocity = new Vector2f();
    private float lastAngularVelocity;
    private Vector2f biasedVelocity = new Vector2f();
    private float biasedAngularVelocity;
    private Vector2f force = new Vector2f();
    private float torque;
    private Shape shape;
    private float surfaceFriction;
    private float damping;
    private float rotDamping;
    private float mass;
    private float invMass;
    private float I;
    private float invI;
    private String name;
    private int id;
    private float restitution = 0.0f;
    private BodyList excluded = new BodyList();
    private boolean gravity = true;
    private long bitmask = 0L;
    private Object userData = null;
    private Vector2f oldPosition;
    private Vector2f newPosition;
    private boolean hitByAnother;
    private boolean isResting;
    private float originalMass;
    private int hitCount = 0;
    private boolean restingBodyDetection = false;
    private float hitTolerance;
    private float rotationTolerance;
    private float positionTolerance;
    private BodyList touching = new BodyList();
    private boolean touchingStatic = false;
    private int touchingCount;
    private boolean canRest = true;
    private boolean rotatable = true;
    private boolean moveable = true;
    private boolean enabled = true;
    private boolean added = false;
    private Vector2f maxVelocity;
    private boolean onlyNotifyColision = false;

    public Body(DynamicShape shape, float m) {
        this("UnnamedBody", (Shape)shape, m);
    }

    public boolean isCollidable() {
        return this.collidable;
    }

    public void setCollidable(boolean collidable) {
        this.collidable = collidable;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public void setMaxX(int maxX) {
        this.maxX = maxX;
    }

    public boolean disabled() {
        return !this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected Body(Shape shape, float m) {
        this("UnnamedBody", shape, m);
    }

    public Body(String name, DynamicShape shape, float m) {
        this(name, (Shape)shape, m);
    }

    protected Body(String name, Shape shape, float m) {
        this.name = name;
        this.id = NEXT_ID++;
        this.position.set(0.0f, 0.0f);
        this.lastPosition.set(0.0f, 0.0f);
        this.rotation = 0.0f;
        this.velocity.set(0.0f, 0.0f);
        this.angularVelocity = 0.0f;
        this.force.set(0.0f, 0.0f);
        this.torque = 0.0f;
        this.surfaceFriction = 0.2f;
        this.mass = Float.MAX_VALUE;
        this.invMass = 0.0f;
        this.I = Float.MAX_VALUE;
        this.invI = 0.0f;
        this.originalMass = m;
        this.set(shape, m);
    }

    public int getID() {
        return this.id;
    }

    public void setUserData(Object o) {
        this.userData = o;
    }

    public Object getUserData() {
        return this.userData;
    }

    public boolean isRotatable() {
        if (this.disabled()) {
            return false;
        }
        return this.rotatable;
    }

    public boolean isMoveable() {
        if (this.disabled()) {
            return false;
        }
        return this.moveable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public void setMoveable(boolean moveable) {
        this.moveable = moveable;
    }

    void configureRestingBodyDetection(float hitTolerance, float rotationTolerance, float positionTolerance) {
        this.hitTolerance = hitTolerance;
        this.rotationTolerance = rotationTolerance;
        this.positionTolerance = positionTolerance;
        this.restingBodyDetection = true;
    }

    public void setCanRest(boolean canRest) {
        this.canRest = canRest;
    }

    public boolean canRest() {
        return this.canRest;
    }

    void startFrame() {
        if (!this.canRest()) {
            return;
        }
        this.oldPosition = new Vector2f(this.getPosition());
        this.hitByAnother = false;
        this.hitCount = 0;
        this.touching.clear();
    }

    public void collided(Body other) {
        if (!this.restingBodyDetection) {
            return;
        }
        if (!this.touching.contains(other)) {
            this.touching.add(other);
        }
        if (this.isResting() && !other.isResting() && other.getVelocity().lengthSquared() > this.hitTolerance) {
            this.hitByAnother = true;
            this.setMass(this.originalMass);
        }
        ++this.hitCount;
    }

    public void endFrame() {
        if (!this.canRest()) {
            return;
        }
        if (this.hitCount == 0 || this.touchingCount != this.touching.size()) {
            this.isResting = false;
            this.setMass(this.originalMass);
            this.touchingStatic = false;
            this.touchingCount = this.touching.size();
        } else {
            this.newPosition = new Vector2f(this.getPosition());
            if (!this.hitByAnother) {
                if (this.newPosition.distanceSquared(this.oldPosition) <= this.positionTolerance && this.velocity.lengthSquared() <= 0.001f && this.biasedVelocity.lengthSquared() <= 0.001f && Math.abs(this.angularVelocity) <= this.rotationTolerance) {
                    if (!this.touchingStatic) {
                        this.touchingStatic = this.isTouchingStatic(new Vector());
                    }
                    if (this.touchingStatic) {
                        this.isResting = true;
                        this.setMass(Float.MAX_VALUE);
                        this.velocity.set(0.0f, 0.0f);
                        this.biasedVelocity.set(0.0f, 0.0f);
                        this.angularVelocity = 0.0f;
                        this.biasedAngularVelocity = 0.0f;
                        this.force.set(0.0f, 0.0f);
                        this.torque = 0.0f;
                    }
                }
            } else {
                this.isResting = false;
                this.setMass(this.originalMass);
            }
            if (this.newPosition.distanceSquared(this.oldPosition) > this.positionTolerance && Math.abs(this.angularVelocity) > this.rotationTolerance) {
                this.touchingStatic = false;
            }
        }
    }

    public boolean isTouchingStatic(Vector path) {
        boolean result = false;
        path.addElement(this);
        for (int i = 0; i < this.touching.size(); ++i) {
            Body body = this.touching.get(i);
            if (path.contains(body)) continue;
            if (body.isStatic()) {
                result = true;
                break;
            }
            if (!body.isTouchingStatic(path)) continue;
            result = true;
            break;
        }
        return result;
    }

    public BodyList getTouching() {
        return new BodyList(this.touching);
    }

    public BodyList getConnected() {
        return this.getConnected(false);
    }

    public BodyList getConnected(boolean stopAtStatic) {
        BodyList connected = new BodyList();
        this.getConnected(connected, new Vector(), stopAtStatic);
        return connected;
    }

    private void getConnected(BodyList list, Vector path, boolean stopAtStatic) {
        path.addElement(this);
        for (int i = 0; i < this.touching.size(); ++i) {
            Body body = this.touching.get(i);
            if (path.contains(body) || body.isStatic() && stopAtStatic) continue;
            list.add(body);
            body.getConnected(list, path, stopAtStatic);
        }
    }

    public boolean isStatic() {
        return false;
    }

    public boolean isResting() {
        return this.isResting;
    }

    public void setIsResting(boolean isResting) {
        if (this.isResting && !isResting) {
            this.setMass(this.originalMass);
        }
        this.touchingStatic = false;
        this.isResting = isResting;
    }

    public void setGravityEffected(boolean gravity) {
        this.gravity = gravity;
    }

    public boolean getGravityEffected() {
        return this.gravity || this.I == Float.MAX_VALUE;
    }

    public void addExcludedBody(Body other) {
        if (other.equals(this)) {
            return;
        }
        if (!this.excluded.contains(other)) {
            this.excluded.add(other);
            other.addExcludedBody(this);
        }
    }

    public void removeExcludedBody(Body other) {
        if (other.equals(this)) {
            return;
        }
        if (this.excluded.contains(other)) {
            this.excluded.remove(other);
            other.removeExcludedBody(this);
        }
    }

    public void setOnlyNotifyColision(boolean onlyNotifyColision) {
        this.onlyNotifyColision = onlyNotifyColision;
    }

    public boolean isOnlyNotifyColision() {
        return this.onlyNotifyColision;
    }

    public BodyList getExcludedList() {
        return this.excluded;
    }

    public float getMass() {
        return this.mass;
    }

    public float getI() {
        return this.I;
    }

    public void setRestitution(float rest) {
        this.restitution = rest;
    }

    public float getRestitution() {
        return this.restitution;
    }

    public void set(Shape shape, float m) {
        this.position.set(0.0f, 0.0f);
        this.lastPosition.set(0.0f, 0.0f);
        this.rotation = 0.0f;
        this.velocity.set(0.0f, 0.0f);
        this.angularVelocity = 0.0f;
        this.force.set(0.0f, 0.0f);
        this.torque = 0.0f;
        this.surfaceFriction = 0.2f;
        this.shape = shape;
        this.setMass(m);
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    private void setMass(float m) {
        this.mass = m;
        if (this.mass < Float.MAX_VALUE) {
            this.invMass = 1.0f / this.mass;
            this.I = this.mass * this.shape.getSurfaceFactor() / 12.0f;
            this.invI = 1.0f / this.I;
        } else {
            this.invMass = 0.0f;
            this.I = Float.MAX_VALUE;
            this.invI = 0.0f;
        }
    }

    public void setFriction(float friction) {
        this.surfaceFriction = friction;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public void setDamping(float damping) {
        this.damping = damping;
    }

    public float getDamping() {
        return this.damping;
    }

    public void setRotDamping(float damping) {
        this.rotDamping = damping;
    }

    public float getRotDamping() {
        return this.rotDamping;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setPosition(float x, float y) {
        this.position.set(x, y);
        this.lastPosition.set(x, y);
    }

    public void move(float x, float y) {
        this.lastPosition.set(this.position);
        this.position.set(x, y);
    }

    public ROVector2f getPosition() {
        return this.position;
    }

    public ROVector2f getLastPosition() {
        return this.lastPosition;
    }

    public ROVector2f getPositionDelta() {
        Vector2f vec = new Vector2f(this.getPosition());
        vec.sub(this.getLastPosition());
        return vec;
    }

    public ROVector2f getLastVelocity() {
        return this.lastVelocity;
    }

    public ROVector2f getVelocityDelta() {
        Vector2f vec = new Vector2f(this.getVelocity());
        vec.sub(this.getLastVelocity());
        return vec;
    }

    public float getLastAngularVelocity() {
        return this.lastAngularVelocity;
    }

    public float getAngularVelocityDelta() {
        return this.getAngularVelocity() - this.getLastAngularVelocity();
    }

    public float getRotation() {
        return this.rotation;
    }

    float getInvI() {
        return this.invI;
    }

    public void adjustPosition(ROVector2f delta, float scale) {
        this.lastPosition.set(this.position);
        this.position.x += delta.getX() * scale;
        this.position.y += delta.getY() * scale;
    }

    public void adjustPosition(Vector2f delta) {
        this.lastPosition.set(this.position);
        this.position.add(delta);
    }

    public void adjustRotation(float delta) {
        this.rotation += delta;
    }

    public void setForce(float x, float y) {
        this.force.set(x, y);
    }

    public void setTorque(float t) {
        this.torque = t;
    }

    public ROVector2f getVelocity() {
        return this.velocity;
    }

    public float getAngularVelocity() {
        return this.angularVelocity;
    }

    public void adjustVelocity(Vector2f delta) {
        if (!this.isMoveable()) {
            return;
        }
        this.lastVelocity.set(this.velocity);
        this.velocity.add(delta);
        this.validateVelocity();
    }

    public void adjustAngularVelocity(float delta) {
        if (!this.isRotatable()) {
            return;
        }
        this.lastAngularVelocity = this.angularVelocity;
        this.angularVelocity += delta;
    }

    public float getFriction() {
        return this.surfaceFriction;
    }

    public ROVector2f getForce() {
        return this.force;
    }

    public float getTorque() {
        return this.torque;
    }

    public void addForce(Vector2f f) {
        this.force.add(f);
    }

    float getInvMass() {
        return this.invMass;
    }

    public String toString() {
        return "[Body '" + this.name + "' id: " + this.id + " pos: " + this.position + " vel: " + this.velocity + " (" + this.angularVelocity + ")]";
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other.getClass() == this.getClass()) {
            return ((Body)other).id == this.id;
        }
        return false;
    }

    public ROVector2f getBiasedVelocity() {
        return this.biasedVelocity;
    }

    public float getBiasedAngularVelocity() {
        return this.biasedAngularVelocity;
    }

    public void adjustBiasedVelocity(Vector2f delta) {
        if (!this.isMoveable()) {
            return;
        }
        this.biasedVelocity.add(delta);
    }

    public void adjustBiasedAngularVelocity(float delta) {
        if (!this.isRotatable()) {
            return;
        }
        this.biasedAngularVelocity += delta;
    }

    public void resetBias() {
        this.biasedVelocity.set(0.0f, 0.0f);
        this.biasedAngularVelocity = 0.0f;
    }

    public float getEnergy() {
        float velEnergy = this.getMass() * this.getVelocity().dot(this.getVelocity());
        float angEnergy = this.getI() * (this.getAngularVelocity() * this.getAngularVelocity());
        return velEnergy + angEnergy;
    }

    public long getBitmask() {
        return this.bitmask;
    }

    public void setBitmask(long bitmask) {
        this.bitmask = bitmask;
    }

    public void addBit(long bitmask) {
        this.bitmask |= bitmask;
    }

    public void removeBit(long bitmask) {
        this.bitmask -= bitmask & this.bitmask;
    }

    public boolean added() {
        return this.added;
    }

    public void setAdded(boolean added) {
        this.added = added;
    }

    public void setMaxVelocity(float maxX, float maxY) {
        this.maxVelocity = new Vector2f(maxX, maxY);
    }

    protected void validateVelocity() {
        if (this.maxVelocity == null) {
            return;
        }
        if (Math.abs(this.velocity.x) > this.maxVelocity.x) {
            this.velocity.x = this.velocity.x > 0.0f ? this.maxVelocity.x : -this.maxVelocity.x;
        }
        if (Math.abs(this.velocity.y) > this.maxVelocity.y) {
            this.velocity.y = this.velocity.y > 0.0f ? this.maxVelocity.y : -this.maxVelocity.y;
        }
    }

    public String getName() {
        return this.name;
    }
}

