/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.shapes;

import net.phys2d.raw.shapes.AABox;
import net.phys2d.raw.shapes.AbstractShape;
import net.phys2d.raw.shapes.DynamicShape;

public strictfp class Circle
extends AbstractShape
implements DynamicShape {
    private float radius;

    public Circle(float radius) {
        super(new AABox(radius * 2.0f, radius * 2.0f));
        this.radius = radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getSurfaceFactor() {
        float circ = (float)(Math.PI * 2 * (double)this.radius);
        return (circ /= 2.0f) * circ;
    }

    public boolean touches(float x, float y, Circle other, float ox, float oy) {
        float dy;
        float totalRad2 = this.getRadius() + other.getRadius();
        if (Math.abs(ox - x) > totalRad2) {
            return false;
        }
        if (Math.abs(oy - y) > totalRad2) {
            return false;
        }
        float dx = Math.abs(ox - x);
        return (totalRad2 *= totalRad2) >= dx * dx + (dy = Math.abs(oy - y)) * dy;
    }
}

