/*
 * Decompiled with CFR 0.152.
 */
package com.appon.car;

import com.appon.car.Camera;
import com.appon.car.CarMidlet;
import com.appon.car.Collectable;
import com.appon.car.Constants;
import com.appon.car.GoodScoreCollection;
import com.appon.car.IngameButtonEngine;
import com.appon.car.IngameButtonListener;
import com.appon.effectengine.EffectGroup;
import com.appon.effectengine.EffectUtil;
import com.appon.gtantra.GAnim;
import com.appon.gtantra.GTantra;
import com.appon.miniframework.Event;
import com.appon.miniframework.EventManager;
import com.appon.miniframework.ResourceManager;
import com.appon.miniframework.ScrollableContainer;
import com.appon.miniframework.Util;
import com.appon.miniframework.controls.TextControl;
import com.appon.util.AshaGraphicsUtil;
import com.appon.util.ImageLoadInfo;
import com.appon.util.Resources;
import com.appon.util.SoundServer;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.BasicJoint;
import net.phys2d.raw.Body;
import net.phys2d.raw.BodyList;
import net.phys2d.raw.CollisionEvent;
import net.phys2d.raw.CollisionListener;
import net.phys2d.raw.StaticBody;
import net.phys2d.raw.World;
import net.phys2d.raw.shapes.Box;
import net.phys2d.raw.shapes.Circle;
import net.phys2d.raw.shapes.Polygon;
import net.phys2d.raw.strategies.QuadSpaceStrategy;

public class CarCanvas
extends Canvas
implements Runnable,
IngameButtonListener,
CollisionListener {
    ScrollableContainer creditsContainer;
    ScrollableContainer containerMenu;
    ScrollableContainer containerIngamePauseMenu;
    ScrollableContainer containergameOver;
    GTantra coinsGtantra;
    GAnim gAnimCoins;
    long milliesStored;
    public static final int FPS = 50;
    public static final float GRAVITY = 6000.0f;
    World world = new World(new Vector2f(0.0f, 6000.0f), 10, new QuadSpaceStrategy(20, 5));
    BodyList bodylist = new BodyList();
    Body carBody;
    Body carWheelFront;
    Body carWheelBack;
    private int[][] polyX = new int[][]{{0, 74, 151, 168, 236, 293, 442, 486, 580, 580, 0}, {0, 63, 129, 191, 250, 449, 549, 658, 858, 875, 887, 999, 1221, 1221, 0}, {0, 43, 114, 182, 301, 387, 486, 599, 641, 724, 724, 0}, {0, 39, 102, 164, 233, 309, 412, 489, 570, 724, 724, 0}, {0, 328, 724, 724, 0}};
    private int[][] polyY = new int[][]{{-20, -40, -45, -55, -48, -59, -38, -25, -20, 21, 20}, {-20, -20, -57, -69, -96, -90, -111, -113, -63, -66, -55, -26, -20, 20, 20}, {-20, -20, -47, -53, -38, -51, -25, -62, -41, -16, 20, 20}, {-20, -30, -19, -49, -50, -78, -84, -60, -57, -16, 20, 20}, {-20, -121, -16, 20, 20}};
    private int[][] collecatblesNodes = new int[][]{{0, 8}, {0, 12}, {0, 9}, {0, 9}, {0, 2}};
    private int platformX = 0;
    private static int CAR_SPEED = 400000;
    private static int CAR_MAX_SPEED = 2800;
    IngameButtonEngine buttons = new IngameButtonEngine(this);
    BasicJoint jointFWheelToBody;
    BasicJoint jointBWheelToBody;
    private int NORMAL_HEIGHT = 50;
    private int JUMP_HEIGHT = 100;
    private Vector collecatbles = new Vector();
    private int MIN_DISTANCE_TO_GENERATE_COLLECTABLES = 200;
    private int MAX_DISTANCE_TO_GENERATE_COLLECTABLES = 500;
    private int lastCollectableGeneratedAt = 0;
    private boolean pointerPressed = true;
    private boolean breakPressed = false;
    EffectGroup wheelEffect;
    EffectGroup bodyEffect;
    GoodScoreCollection goodScoreCollection;
    ImageLoadInfo gemImage;
    int currentCamX = 0;
    Image portral_Img;
    public static final int STATE_DRAW_LOGO = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_GAMEPLAY = 2;
    public static final int STATE_OVER = 3;
    public static final int STATE_MAINMENU_LOADING = 4;
    public static final int STATE_MAINMENU = 5;
    public static final int STATE_PAUSEGAME = 6;
    public static final int STATE_CREDITS = 7;
    private int state = 0;
    int carBodyWidth = 85;
    int carBodyHeight = 26;
    int carWheelRadius = 15;
    private static int BUTTON_SIZE_X = 50;
    private static int BUTTON_SIZE_Y = 50;
    private static int PADDING = 3;
    int additionalShiftCarBoxyX = -2;
    int additionalShiftCarBoxyY = 25;
    private int MASTER_VERSION_WIDTH = 320;
    private int MASTER_VERSION_HEIGHT = 240;
    int scaleValue = -35;
    private int INSTIAL_PLATFORM_HEIGHT = 40;
    private int EXTRA_HEIGHT_TO_LEAVE_CAR = 100;
    private String CARSHED = "CRASHED !!";
    private String FINAL_TEXT = "CRASHED !!";
    public static CarCanvas carcanvas;
    static Random random;
    private static int score;
    public static int HighScore;
    public long waitingCnt = 0L;
    private static final int CAMERA_LOCK_LOACATION_IN_PERCENTAGE = 30;
    int lockPosition;
    int[] xOfClipedPolys = new int[50];
    int[] yOfClipedPolys = new int[50];
    int[] IndexesOfClipedPolys = new int[50];
    private boolean gameLost = true;
    private boolean gameover = false;
    private int[] gameOverCollisionDetectionArrayX = new int[50];
    private int[] gameOverCollisionDetectionArrayY = new int[50];

    public CarCanvas() {
        this.setFullScreenMode(true);
        SoundServer.getInstance().init();
        com.appon.util.Util.isPortraitMode = this.getWidth() < this.getHeight();
        this.world.addListener(this);
        this.goodScoreCollection = new GoodScoreCollection();
        Resources.getInstance().init((Displayable)this);
        new Thread(this).start();
        if (com.appon.util.Util.isPortraitMode) {
            Constants.SCREEN_WIDTH = this.getHeight();
            Constants.SCREEN_HEIGHT = this.getWidth();
        } else {
            Constants.SCREEN_WIDTH = this.getWidth();
            Constants.SCREEN_HEIGHT = this.getHeight();
        }
    }

    public static CarCanvas getInstance() {
        if (carcanvas == null) {
            carcanvas = new CarCanvas();
        }
        return carcanvas;
    }

    private boolean isXDevice() {
        return this.getWidth() > 240;
    }

    private void port() {
        this.carBodyWidth = EffectUtil.getScaleValue(this.carBodyWidth, this.scaleValue);
        this.carBodyHeight = EffectUtil.getScaleValue(this.carBodyHeight, this.scaleValue);
        this.carWheelRadius = EffectUtil.getScaleValue(this.carWheelRadius, this.scaleValue);
        this.additionalShiftCarBoxyX = EffectUtil.getScaleValue(this.additionalShiftCarBoxyX, this.scaleValue);
        this.additionalShiftCarBoxyY = EffectUtil.getScaleValue(this.additionalShiftCarBoxyY, this.scaleValue);
        for (int i = 0; i < this.polyX.length; ++i) {
            for (int j = 0; j < this.polyX[i].length; ++j) {
                this.polyX[i][j] = EffectUtil.getScaleValue(this.polyX[i][j], this.scaleValue);
                this.polyY[i][j] = EffectUtil.getScaleValue(this.polyY[i][j], this.scaleValue);
            }
        }
        this.NORMAL_HEIGHT = EffectUtil.getScaleValue(this.NORMAL_HEIGHT, this.scaleValue);
        this.JUMP_HEIGHT = EffectUtil.getScaleValue(this.JUMP_HEIGHT, this.scaleValue);
        int xScale = 100 * (Constants.SCREEN_WIDTH - this.MASTER_VERSION_WIDTH) / this.MASTER_VERSION_WIDTH;
        int yScale = 100 * (Constants.SCREEN_HEIGHT - this.MASTER_VERSION_HEIGHT) / this.MASTER_VERSION_HEIGHT;
        BUTTON_SIZE_X = EffectUtil.getScaleValue(BUTTON_SIZE_X, yScale);
        BUTTON_SIZE_Y = EffectUtil.getScaleValue(BUTTON_SIZE_Y, yScale);
        CAR_MAX_SPEED = EffectUtil.getScaleValue(CAR_MAX_SPEED, this.scaleValue);
        this.INSTIAL_PLATFORM_HEIGHT = EffectUtil.getScaleValue(this.INSTIAL_PLATFORM_HEIGHT, this.scaleValue);
        this.EXTRA_HEIGHT_TO_LEAVE_CAR = EffectUtil.getScaleValue(this.EXTRA_HEIGHT_TO_LEAVE_CAR, this.scaleValue);
        System.out.println("yScale : " + yScale);
    }

    private void loadGame() {
        this.coinsGtantra = new GTantra();
        this.coinsGtantra.Load(GTantra.getFileByteData("/coin.GT"), true);
        this.gAnimCoins = new GAnim(this.coinsGtantra, 0);
        try {
            if (this.isXDevice()) {
                this.scaleValue = -35;
                byte[] data = GTantra.getFileByteData("/wheel.effect");
                this.wheelEffect = EffectUtil.loadEffect(data);
                data = GTantra.getFileByteData("/carbody.effect");
                this.bodyEffect = EffectUtil.loadEffect(data);
            } else {
                this.scaleValue = -35;
                byte[] data = GTantra.getFileByteData("/wheel.effect");
                this.wheelEffect = EffectUtil.loadEffect(data);
                data = GTantra.getFileByteData("/carbody.effect");
                this.bodyEffect = EffectUtil.loadEffect(data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void reset() {
        this.gAnimCoins.reset();
        CarMidlet.getInstance().loadRMSData();
        this.gameover = false;
        BUTTON_SIZE_X = Constants.BUTTON_PLAY.getWidth();
        BUTTON_SIZE_Y = Constants.BUTTON_PLAY.getHeight();
        int xPosition = Constants.SCREEN_WIDTH * 30 / 100 - (this.carBodyWidth >> 1) + this.carWheelRadius;
        int yPositionOfBody = Constants.SCREEN_HEIGHT - (this.INSTIAL_PLATFORM_HEIGHT >> 1) - this.carWheelRadius - (this.carBodyHeight >> 1);
        Camera.getInst().setRefrenceY((this.carBodyHeight + this.carWheelRadius) * 2);
        Camera.getInst().setCurrentRefrenceY((this.carBodyHeight + this.carWheelRadius) * 2);
        Camera.getInst().reset();
        this.buttons.removeAll();
        this.goodScoreCollection.reset();
        this.collecatbles.removeAllElements();
        this.world = new World(new Vector2f(0.0f, 6000.0f), 10, new QuadSpaceStrategy(20, 5));
        this.world.addListener(this);
        this.bodylist.clear();
        this.platformX = 0;
        this.lastCollectableGeneratedAt = 0;
        this.buttons.addButton("buttonjump", PADDING, Constants.SCREEN_HEIGHT - BUTTON_SIZE_Y, BUTTON_SIZE_X, BUTTON_SIZE_Y, 255, Constants.BUTTON_PLAY.getImage());
        this.buttons.addButton("Jump", PADDING, Constants.SCREEN_HEIGHT - BUTTON_SIZE_Y, BUTTON_SIZE_X, BUTTON_SIZE_Y, 255, Constants.BUTTON_JUMP.getImage());
        this.buttons.addButton("buttonrightturn", Constants.SCREEN_WIDTH - BUTTON_SIZE_X - PADDING, Constants.SCREEN_HEIGHT - BUTTON_SIZE_Y, BUTTON_SIZE_X, BUTTON_SIZE_Y, 0xFFFF00, Constants.BUTTON_PLAY.getImage());
        this.buttons.addButton("rightturn", Constants.SCREEN_WIDTH - BUTTON_SIZE_X - PADDING, Constants.SCREEN_HEIGHT - BUTTON_SIZE_Y, BUTTON_SIZE_X, BUTTON_SIZE_Y, 0xFFFF00, Constants.BUTTON_RIGHT.getImage());
        this.buttons.addButton("buttonleftturn", Constants.SCREEN_WIDTH - (BUTTON_SIZE_X << 1) - (PADDING << 1), Constants.SCREEN_HEIGHT - BUTTON_SIZE_Y, BUTTON_SIZE_X, BUTTON_SIZE_Y, 65280, Constants.BUTTON_PLAY.getImage());
        this.buttons.addButton("leftturn", Constants.SCREEN_WIDTH - (BUTTON_SIZE_X << 1) - (PADDING << 1), Constants.SCREEN_HEIGHT - BUTTON_SIZE_Y, BUTTON_SIZE_X, BUTTON_SIZE_Y, 65280, Constants.BUTTON_LEFT.getImage());
        this.buttons.addButton("buttonpause", Constants.SCREEN_WIDTH - Constants.BUTTON_PLAY.getWidth(), 2, Constants.BUTTON_PLAY.getWidth(), Constants.BUTTON_PLAY.getHeight(), 65280, Constants.BUTTON_PLAY.getImage());
        this.buttons.addButton("pause", Constants.SCREEN_WIDTH - Constants.BUTTON_PLAY.getWidth(), 2, Constants.BUTTON_PLAY.getWidth(), Constants.BUTTON_PLAY.getHeight(), 65280, Constants.BUTTON_PAUSE.getImage());
        this.buttons.addButtonSelection("Jump", PADDING, Constants.SCREEN_HEIGHT - BUTTON_SIZE_Y, BUTTON_SIZE_X, BUTTON_SIZE_Y, 255, Constants.BUTTON_PLAY_PRESS.getImage());
        this.buttons.addButtonSelection("rightturn", Constants.SCREEN_WIDTH - BUTTON_SIZE_X - PADDING, Constants.SCREEN_HEIGHT - BUTTON_SIZE_Y, BUTTON_SIZE_X, BUTTON_SIZE_Y, 0xFFFF00, Constants.BUTTON_PLAY_PRESS.getImage());
        this.buttons.addButtonSelection("leftturn", Constants.SCREEN_WIDTH - (BUTTON_SIZE_X << 1) - (PADDING << 1), Constants.SCREEN_HEIGHT - BUTTON_SIZE_Y, BUTTON_SIZE_X, BUTTON_SIZE_Y, 65280, Constants.BUTTON_PLAY_PRESS.getImage());
        int platformWidth = Constants.SCREEN_WIDTH / 2;
        this.addCar(xPosition, yPositionOfBody - this.EXTRA_HEIGHT_TO_LEAVE_CAR);
        StaticBody body = new StaticBody("roadstrip", new Box(platformWidth, this.INSTIAL_PLATFORM_HEIGHT));
        body.setPosition(platformWidth >> 1, Constants.SCREEN_HEIGHT - (this.INSTIAL_PLATFORM_HEIGHT >> 1));
        body.setGravityEffected(false);
        body.setMoveable(false);
        body.setRotatable(false);
        body.setMaxX(platformWidth);
        this.bodylist.add(body);
        this.world.add(body);
        this.platformX += platformWidth;
        this.addRoadStrip(this.platformX);
        this.pointerPressed = true;
        this.gameLost = true;
        score = 0;
    }

    public int[] getPolyArraysX(ROVector2f[] points) {
        int[] pos = new int[points.length];
        for (int i = 0; i < points.length; ++i) {
            pos[i] = (int)points[i].getX();
        }
        return pos;
    }

    public int[] getPolyArraysY(ROVector2f[] points) {
        int[] pos = new int[points.length];
        for (int i = 0; i < points.length; ++i) {
            pos[i] = (int)points[i].getY();
        }
        return pos;
    }

    public boolean isInCircle(int center_x, int center_y, int radius, int x, int y) {
        int dist = (center_x - x) * (center_x - x) + (center_y - y) * (center_y - y);
        return dist <= radius * radius;
    }

    boolean pnpoly(int nvert, int[] vertx, int[] verty, float testx, float testy) {
        boolean c = false;
        int i = 0;
        int j = nvert - 1;
        while (i < nvert) {
            if ((float)verty[i] > testy != (float)verty[j] > testy && testx < (float)(vertx[j] - vertx[i]) * (testy - (float)verty[i]) / (float)(verty[j] - verty[i]) + (float)vertx[i]) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    public ROVector2f[] getPolyVertexes(int[] x, int[] y) {
        ROVector2f[] pos = new ROVector2f[x.length];
        for (int i = 0; i < x.length; ++i) {
            pos[i] = new Vector2f(x[i], y[i]);
        }
        return pos;
    }

    public static int getRandomNumber(int min, int max) {
        if (max == min) {
            return 0;
        }
        int randomNum = Math.abs(random.nextInt());
        return min + Math.abs(randomNum % (max - min));
    }

    public void generateCollectable(int x, int y) {
        Collectable c = new Collectable(x, y);
        this.collecatbles.addElement(c);
    }

    public void collectableCollected(Collectable c) {
        ++score;
        this.collecatbles.removeElement(c);
        this.goodScoreCollection.addScoreCollection(c.getX(), c.getY(), "Score: +1");
    }

    public int getCenter(int[] array) {
        int sum = 0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum /= array.length;
    }

    public int getPolyWidth(int[] x) {
        return this.getMax(x) - this.getMin(x);
    }

    public int getMax(int[] array) {
        int sum = Integer.MIN_VALUE;
        for (int i = 0; i < array.length; ++i) {
            if (sum >= array[i]) continue;
            sum = array[i];
        }
        return sum;
    }

    public int getMin(int[] array) {
        int sum = Integer.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            if (sum <= array[i]) continue;
            sum = array[i];
        }
        return sum;
    }

    private void paintInGame(Graphics g) {
        g.drawImage(Constants.IMG_BGGAMEPLAY.getImage(), 0, 0, 0);
        if (this.carWheelBack != null) {
            if (this.pointerPressed) {
                this.carWheelBack.setTorque(CAR_SPEED);
                this.carWheelFront.setTorque(CAR_SPEED);
            } else if (this.breakPressed) {
                this.carWheelBack.setTorque(-CAR_SPEED);
                this.carWheelFront.setTorque(-CAR_SPEED);
            }
        }
        try {
            this.world.step(0.01f);
        }
        catch (Exception e) {
            this.FINAL_TEXT = this.CARSHED + " game crash";
        }
        this.paintWorld(g);
        this.buttons.paint(g);
        g.setColor(4730988);
        g.fillRoundRect(2, 2, 67, 2 + Constants.IMG_COIN.getHeight() + 2, 5, 5);
        g.drawImage(Constants.IMG_COIN.getImage(), 65 - Constants.IMG_COIN.getWidth(), 2, 0);
        Constants.FONT_TITLE.drawString(g, "" + score, 6, 2 + (Constants.IMG_COIN.getHeight() + 2 >> 1) - (Constants.FONT_TITLE.getFontHeight() >> 1), 0);
        this.setHighScore(score);
        if (!this.gameLost && !this.gameover) {
            this.gameover = true;
            CarMidlet.getInstance().saveRMS();
            this.setState(3);
        } else {
            this.checkForGameOver();
        }
    }

    void setHighScore(int scor) {
        TextControl Textscore = (TextControl)Util.findControl(this.containergameOver, 8);
        Textscore.setText("" + score);
        TextControl TextHighscore = (TextControl)Util.findControl(this.containergameOver, 11);
        TextHighscore.setText("" + HighScore);
        if (HighScore < scor) {
            HighScore = scor;
        }
    }

    public void paintGame(Graphics g) {
        switch (this.state) {
            case 0: {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, Constants.SCREEN_WIDTH, Constants.SCREEN_HEIGHT);
                if (Constants.LOGO.isNull()) {
                    this.port();
                    Constants.LOGO.loadImage();
                }
                g.drawImage(Constants.LOGO.getImage(), (Constants.SCREEN_WIDTH - Constants.LOGO.getImage().getWidth()) / 2, (Constants.SCREEN_HEIGHT - Constants.LOGO.getImage().getHeight()) / 2, 0);
                break;
            }
            case 4: {
                SoundServer.getInstance().playSound(0);
                g.setColor(4730988);
                g.fillRect(0, 0, Constants.SCREEN_WIDTH, Constants.SCREEN_HEIGHT);
                g.setColor(0xFFFFFF);
                Constants.FONT_TITLE.drawString(g, "Loading.....", 2, Constants.SCREEN_HEIGHT - (Constants.FONT_TITLE.getStringHeight("Loading") << 1), 0);
                Util.prepareDisplay(this.containerMenu);
                this.setState(5);
                break;
            }
            case 5: {
                g.setColor(255);
                g.fillRect(0, 0, Constants.SCREEN_WIDTH, Constants.SCREEN_HEIGHT);
                this.containerMenu.paintUI(g);
                break;
            }
            case 1: {
                g.setColor(4730988);
                g.fillRect(0, 0, Constants.SCREEN_WIDTH, Constants.SCREEN_HEIGHT);
                g.setColor(0xFFFFFF);
                Constants.FONT_TITLE.drawString(g, "Loading.....", 2, Constants.SCREEN_HEIGHT - (Constants.FONT_TITLE.getStringHeight("Loading") << 1), 0);
                if (this.getState() != 1) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.loadGame();
                if (com.appon.util.Util.isPortraitMode) {
                    Constants.SCREEN_WIDTH = this.getHeight();
                    Constants.SCREEN_HEIGHT = this.getWidth();
                } else {
                    Constants.SCREEN_WIDTH = this.getWidth();
                    Constants.SCREEN_HEIGHT = this.getHeight();
                }
                this.reset();
                this.setState(2);
                break;
            }
            case 7: {
                g.setColor(-1761607681);
                g.fillRect(0, 0, Constants.SCREEN_WIDTH, Constants.SCREEN_HEIGHT);
                this.creditsContainer.paintUI(g);
                break;
            }
            case 2: {
                this.paintInGame(g);
                break;
            }
            case 3: {
                this.paintInGame(g);
                this.containergameOver.paintUI(g);
                break;
            }
            case 6: {
                this.containerIngamePauseMenu.paintUI(g);
            }
        }
        if (this.getState() == 0) {
            this.setState(4);
        }
    }

    private void updateGame(Graphics g) {
        switch (this.state) {
            case 1: {
                this.loadImages();
                break;
            }
            case 0: {
                if (Constants.LOGO.isNull()) break;
                if (this.waitingCnt < 15L) {
                    ++this.waitingCnt;
                    break;
                }
                this.waitingCnt = 0L;
                break;
            }
            case 4: {
                this.loadMenuResources();
                break;
            }
            case 5: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void loadMenuResources() {
        try {
            Constants.IMG_SPLASH.loadImage();
            Constants.BIG_BUTTON_PLAY.loadImage();
            Constants.BIG_BUTTON_PLAY_PRESS.loadImage();
            Constants.BUTTON_PLAY.loadImage();
            Constants.BUTTON_PLAY_PRESS.loadImage();
            Constants.ICON_PLAY.loadImage();
            Constants.ICON_SOUND.loadImage();
            Constants.ICON_MUTE.loadImage();
            Constants.ICON_EXIT.loadImage();
            ResourceManager.getInstance().setImageResource(0, Constants.BIG_BUTTON_PLAY.getImage());
            ResourceManager.getInstance().setImageResource(1, Constants.BIG_BUTTON_PLAY_PRESS.getImage());
            ResourceManager.getInstance().setImageResource(2, Constants.BUTTON_PLAY.getImage());
            ResourceManager.getInstance().setImageResource(3, Constants.BUTTON_PLAY_PRESS.getImage());
            ResourceManager.getInstance().setImageResource(4, Constants.IMG_SPLASH.getImage());
            ResourceManager.getInstance().setImageResource(5, Constants.ICON_PLAY.getImage());
            ResourceManager.getInstance().setImageResource(6, Constants.ICON_SOUND.getImage());
            ResourceManager.getInstance().setImageResource(7, Constants.ICON_MUTE.getImage());
            ResourceManager.getInstance().setImageResource(8, Constants.ICON_EXIT.getImage());
            this.containerMenu = Util.loadContainer(GTantra.getFileByteData("/mainMenu.menuex"), 320, 240, Constants.SCREEN_WIDTH, Constants.SCREEN_HEIGHT, Constants.isMobileTouch);
            Util.reallignContainer(this.containerMenu);
            this.containerMenu.setEventManager(new EventManager(){

                public void event(Event event) {
                    System.out.println("event.getEventId()===" + event.getEventId());
                    if (event.getEventId() == 0) {
                        if (event.getSource().getId() == 2) {
                            CarCanvas.this.setState(1);
                            Util.prepareDisplay(CarCanvas.this.containerMenu);
                        }
                        if (event.getSource().getId() == 4) {
                            SoundServer.getInstance().soundSwitchToggle();
                            if (!SoundServer.getInstance().isSoundOff()) {
                                SoundServer.getInstance().playSound(0);
                            }
                            Util.prepareDisplay(CarCanvas.this.containerMenu);
                        }
                        if (event.getSource().getId() == 5) {
                            CarMidlet.getInstance().notifyDestroyed();
                            Util.prepareDisplay(CarCanvas.this.containerMenu);
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadImages() {
        try {
            Constants.IMG_COIN.loadImage();
            Constants.BUTTON_PAUSE.loadImage();
            Constants.BUTTON_JUMP.loadImage();
            Constants.BUTTON_LEFT.loadImage();
            Constants.BUTTON_RIGHT.loadImage();
            Constants.IMG_BGGAMEPLAY.loadImage();
            Constants.ICON_HOME.loadImage();
            Constants.ICON_REPLAY.loadImage();
            Constants.ICON_PLAYSMALL.loadImage();
            Constants.IMG_PAUSE.loadImage();
            ResourceManager.getInstance().setImageResource(0, Constants.BUTTON_PLAY.getImage());
            ResourceManager.getInstance().setImageResource(1, Constants.BUTTON_PLAY_PRESS.getImage());
            ResourceManager.getInstance().setImageResource(2, Constants.ICON_HOME.getImage());
            ResourceManager.getInstance().setImageResource(3, Constants.ICON_REPLAY.getImage());
            ResourceManager.getInstance().setImageResource(4, Constants.ICON_PLAYSMALL.getImage());
            ResourceManager.getInstance().setImageResource(5, Constants.IMG_PAUSE.getImage());
            this.containerIngamePauseMenu = Util.loadContainer(GTantra.getFileByteData("/ingamePause.menuex"), 320, 240, Constants.SCREEN_WIDTH, Constants.SCREEN_HEIGHT, Constants.isMobileTouch);
            Util.reallignContainer(this.containerIngamePauseMenu);
            this.containerIngamePauseMenu.setEventManager(new EventManager(){

                public void event(Event event) {
                    if (event.getEventId() == 4) {
                        if (event.getSource().getId() == 4) {
                            CarCanvas.this.setState(5);
                            Util.prepareDisplay(CarCanvas.this.containerIngamePauseMenu);
                        }
                        if (event.getSource().getId() == 5) {
                            CarCanvas.this.setState(1);
                            Util.prepareDisplay(CarCanvas.this.containerIngamePauseMenu);
                        }
                        if (event.getSource().getId() == 6) {
                            CarCanvas.this.setState(2);
                            Util.prepareDisplay(CarCanvas.this.containerIngamePauseMenu);
                        }
                    }
                }
            });
            Constants.IMG_GAMEOVER.loadImage();
            ResourceManager.getInstance().setFontResource(0, Constants.FONT_TITLE);
            ResourceManager.getInstance().setImageResource(0, Constants.BUTTON_PLAY.getImage());
            ResourceManager.getInstance().setImageResource(1, Constants.BUTTON_PLAY_PRESS.getImage());
            ResourceManager.getInstance().setImageResource(2, Constants.ICON_HOME.getImage());
            ResourceManager.getInstance().setImageResource(3, Constants.ICON_REPLAY.getImage());
            ResourceManager.getInstance().setImageResource(4, Constants.ICON_PLAYSMALL.getImage());
            ResourceManager.getInstance().setImageResource(6, Constants.IMG_GAMEOVER.getImage());
            this.containergameOver = Util.loadContainer(GTantra.getFileByteData("/gameOverMenu.menuex"), 320, 240, Constants.SCREEN_WIDTH, Constants.SCREEN_HEIGHT, Constants.isMobileTouch);
            Util.reallignContainer(this.containergameOver);
            this.containergameOver.setEventManager(new EventManager(){

                public void event(Event event) {
                    if (event.getEventId() == 4) {
                        if (event.getSource().getId() == 4) {
                            CarCanvas.this.setState(5);
                            Util.prepareDisplay(CarCanvas.this.containergameOver);
                        }
                        if (event.getSource().getId() == 5) {
                            CarCanvas.this.setState(1);
                            Util.prepareDisplay(CarCanvas.this.containergameOver);
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void paint(Graphics g) {
        try {
            this.updateGame(g);
            if (com.appon.util.Util.isPortraitMode) {
                if (this.portral_Img == null) {
                    this.portral_Img = Image.createImage((int)this.getHeight(), (int)this.getWidth());
                }
                this.paintGame(this.portral_Img.getGraphics());
                g.drawRegion(this.portral_Img, 0, 0, this.portral_Img.getWidth(), this.portral_Img.getHeight(), 5, 0, 0, 0);
            } else {
                this.paintGame(g);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void drawTextCenterAlligned(Graphics g, String text, int x, int y) {
        g.drawString(text, x - (g.getFont().stringWidth(text) >> 1), y - (g.getFont().getHeight() >> 1), 0);
    }

    private void paintWorld(Graphics g) {
        int translateX = 0;
        int translateY = 0;
        this.lockPosition = Constants.SCREEN_WIDTH * 30 / 100;
        if (this.carWheelFront != null && this.carWheelFront.getPosition() != null && this.gameLost) {
            this.currentCamX = (int)this.carWheelFront.getPosition().getX();
            Camera.getInst().setCurrentRefrenceY((int)this.carWheelBack.getPosition().getY());
            Camera.getInst().update();
            translateY = Camera.getInst().getY();
            if (this.currentCamX + this.lockPosition + Constants.SCREEN_WIDTH > this.platformX) {
                this.addRoadStrip(this.platformX);
                System.out.println("add new strip");
            }
            translateX = (int)((float)this.lockPosition - this.carWheelFront.getPosition().getX());
            g.translate(translateX, translateY);
        } else if (!this.gameLost) {
            translateX = this.lockPosition - this.currentCamX;
            translateY = Camera.getInst().getY();
            g.translate(translateX, translateY);
        }
        for (int i = this.bodylist.size() - 1; i >= 0; --i) {
            Vector2f v2;
            ROVector2f v1;
            Vector2f[] pts;
            Body body = this.bodylist.get(i);
            g.setColor(0xFF0000);
            if (body.getName() != null && body.getName().equals("roadstrip") && this.currentCamX - this.lockPosition > body.getMaxX()) {
                this.bodylist.remove(body);
                this.world.remove(body);
                System.out.println("body removed");
                continue;
            }
            if (body.getShape() instanceof Box) {
                Box box = (Box)body.getShape();
                if (body.getName().equals("carbody")) {
                    this.bodyEffect.getEffect(0).paint(g, (int)body.getPosition().getX() + this.additionalShiftCarBoxyX, (int)body.getPosition().getY() + this.additionalShiftCarBoxyY, true, (int)Math.toDegrees(body.getRotation()), 0, 0, 0);
                    continue;
                }
                pts = box.getPoints(body.getPosition(), body.getRotation());
                if (body.getName().equals("roadstrip")) {
                    this.drawClipedPoly(pts, g);
                    continue;
                }
                v1 = pts[0];
                v2 = pts[1];
                Vector2f v3 = pts[2];
                Vector2f v4 = pts[3];
                g.drawLine((int)((Vector2f)v1).x, (int)((Vector2f)v1).y, (int)v2.x, (int)v2.y);
                g.drawLine((int)v2.x, (int)v2.y, (int)v3.x, (int)v3.y);
                g.drawLine((int)v3.x, (int)v3.y, (int)v4.x, (int)v4.y);
                g.drawLine((int)v4.x, (int)v4.y, (int)((Vector2f)v1).x, (int)((Vector2f)v1).y);
                continue;
            }
            if (body.getShape() instanceof Circle) {
                Circle cir = (Circle)body.getShape();
                int r = (int)cir.getRadius();
                v1 = body.getPosition();
                if (body.getName().equals("frontwheel")) {
                    this.wheelEffect.getEffect(0).paint(g, (int)v1.getX(), (int)v1.getY(), true, (int)Math.toDegrees(body.getRotation()), 0, 0, 0);
                    continue;
                }
                if (!body.getName().equals("backwheel")) continue;
                this.wheelEffect.getEffect(0).paint(g, (int)v1.getX() - 2, (int)v1.getY(), true, (int)Math.toDegrees(body.getRotation()), 0, 0, 0);
                continue;
            }
            if (!(body.getShape() instanceof Polygon)) continue;
            Polygon b = (Polygon)body.getShape();
            pts = b.getVertices(body.getPosition(), body.getRotation());
            if (body.getName().equals("roadstrip")) {
                this.drawClipedPoly(pts, g);
            }
            for (int j = 0; j < pts.length - 1; ++j) {
                Vector2f v12 = pts[j];
                Vector2f v22 = pts[j + 1];
                g.drawLine((int)v12.x, (int)v12.y, (int)v22.x, (int)v22.y);
            }
            v1 = pts[pts.length - 1];
            v2 = pts[0];
            g.drawLine((int)((Vector2f)v1).x, (int)((Vector2f)v1).y, (int)v2.x, (int)v2.y);
        }
        if (this.collecatbles.size() > 0 && this.carBody != null) {
            Box box = (Box)this.carBody.getShape();
            ROVector2f[] pts = box.getPoints(this.carBody.getPosition(), this.carBody.getRotation());
            int[] x = this.getPolyArraysX(pts);
            int[] y = this.getPolyArraysY(pts);
            for (int i = 0; i < this.collecatbles.size(); ++i) {
                Collectable elementAt = (Collectable)this.collecatbles.elementAt(i);
                this.gAnimCoins.render(g, elementAt.getX(), elementAt.getY(), 0, true);
                if (this.pnpoly(x.length, x, y, elementAt.getX(), elementAt.getY()) || this.isInCircle((int)this.carWheelFront.getPosition().getX(), (int)this.carWheelFront.getPosition().getY(), (int)((Circle)this.carWheelFront.getShape()).getRadius(), elementAt.getX(), elementAt.getY()) || this.isInCircle((int)this.carWheelBack.getPosition().getX(), (int)this.carWheelBack.getPosition().getY(), (int)((Circle)this.carWheelBack.getShape()).getRadius(), elementAt.getX(), elementAt.getY())) {
                    this.collectableCollected(elementAt);
                    --i;
                }
                if (elementAt.x >= this.currentCamX - this.lockPosition) continue;
                this.collecatbles.removeElement(elementAt);
                --i;
            }
        }
        this.goodScoreCollection.paint(g);
        g.translate(-translateX, -translateY);
    }

    private int getShortedIndex(int[] data, int length) {
        int index = -1;
        int value = Integer.MAX_VALUE;
        for (int i = 0; i < length; ++i) {
            if (data[i] >= value) continue;
            index = i;
            value = data[i];
        }
        return index;
    }

    private int getLargestIndex(int[] data, int length) {
        int index = -1;
        int value = Integer.MIN_VALUE;
        for (int i = 0; i < length; ++i) {
            if (data[i] <= value) continue;
            index = i;
            value = data[i];
        }
        return index;
    }

    private void drawClipedPoly(Vector2f[] pts, Graphics g) {
        int[] x = this.getPolyArraysX(pts);
        int[] y = this.getPolyArraysY(pts);
        g.setColor(3161138);
        AshaGraphicsUtil.fillPolygon(g, x, y);
    }

    private int clapm(int value, int min, int max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public void addRoadStrip(int x) {
        int index = CarCanvas.getRandomNumber(0, this.polyX.length);
        StaticBody body = new StaticBody("roadstrip", new Polygon(this.getPolyVertexes(this.polyX[index], this.polyY[index])));
        body.setPosition(x, Constants.SCREEN_HEIGHT - (this.INSTIAL_PLATFORM_HEIGHT >> 1));
        body.addExcludedBody(body);
        body.setRestitution(0.2f);
        body.setMaxX(this.platformX + this.getPolyWidth(this.polyX[index]));
        this.bodylist.add(body);
        this.world.add(body);
        int startNode = Math.min(this.collecatblesNodes[index][0], this.collecatblesNodes[index][1]);
        int endNode = Math.max(this.collecatblesNodes[index][0], this.collecatblesNodes[index][1]);
        for (int i = startNode; i <= endNode; ++i) {
            int xP = x + this.polyX[index][i];
            int yP = Constants.SCREEN_HEIGHT - (this.INSTIAL_PLATFORM_HEIGHT >> 1) + this.polyY[index][i];
            int DISTANCE_TO_GENERATE_COLLECTABLES = CarCanvas.getRandomNumber(this.MIN_DISTANCE_TO_GENERATE_COLLECTABLES, this.MAX_DISTANCE_TO_GENERATE_COLLECTABLES);
            if (xP <= this.lastCollectableGeneratedAt + DISTANCE_TO_GENERATE_COLLECTABLES) continue;
            this.generateCollectable(xP, yP - CarCanvas.getRandomNumber(this.NORMAL_HEIGHT, this.JUMP_HEIGHT));
            this.lastCollectableGeneratedAt = xP;
        }
        this.platformX += this.getPolyWidth(this.polyX[index]);
    }

    private void addCar(int x, int y) {
        this.carBody = new Body("carbody", new Box(this.carBodyWidth, this.carBodyHeight), 1.0f);
        this.carBody.setPosition(x, y);
        this.carBody.setGravityEffected(true);
        this.carBody.setMoveable(true);
        this.carBody.setRotatable(true);
        this.carWheelFront = new Body("frontwheel", new Circle(this.carWheelRadius), 10.0f);
        this.carWheelFront.setPosition(x + (this.carBodyWidth >> 1) - this.carWheelRadius, y + (this.carBodyHeight >> 1) + this.carWheelRadius);
        this.carWheelFront.setGravityEffected(true);
        this.carWheelFront.setMoveable(true);
        this.carWheelFront.setRotatable(true);
        this.carWheelFront.setRestitution(1.0f);
        this.carWheelFront.setFriction(1.0f);
        this.bodylist.add(this.carWheelFront);
        this.world.add(this.carWheelFront);
        this.carWheelBack = new Body("backwheel", new Circle(this.carWheelRadius), 10.0f);
        this.carWheelBack.setPosition(x - (this.carBodyWidth >> 1) + this.carWheelRadius, y + (this.carBodyHeight >> 1) + this.carWheelRadius);
        this.carWheelBack.setGravityEffected(true);
        this.carWheelBack.setMoveable(true);
        this.carWheelBack.setRotatable(true);
        this.carWheelBack.setRestitution(1.0f);
        this.carWheelBack.setFriction(1.0f);
        this.bodylist.add(this.carWheelBack);
        this.world.add(this.carWheelBack);
        this.bodylist.add(this.carBody);
        this.world.add(this.carBody);
        this.jointFWheelToBody = new BasicJoint(this.carBody, this.carWheelFront, new Vector2f(x + (this.carBodyWidth >> 1) - this.carWheelRadius, y + (this.carBodyHeight >> 1) + this.carWheelRadius));
        this.jointBWheelToBody = new BasicJoint(this.carBody, this.carWheelBack, new Vector2f(x - (this.carBodyWidth >> 1) + this.carWheelRadius, y + (this.carBodyHeight >> 1) + this.carWheelRadius));
        this.jointFWheelToBody.setRelaxation(1.0f);
        this.jointBWheelToBody.setRelaxation(1.0f);
        this.world.add(this.jointFWheelToBody);
        this.world.add(this.jointBWheelToBody);
        this.carWheelFront.setMaxVelocity(CAR_MAX_SPEED, 1000.0f);
        this.carWheelBack.setMaxVelocity(CAR_MAX_SPEED, 1000.0f);
        this.carBody.setMaxVelocity(CAR_MAX_SPEED, 1000.0f);
    }

    protected void keyPressed(int keyCode) {
        this.keyPressedcanvas(keyCode, this.getGameAction(keyCode));
    }

    protected void keyReleased(int keyCode) {
        this.keyReleasedcanvas(keyCode, this.getGameAction(keyCode));
    }

    protected void keyPressedcanvas(int keyCode, int gameKey) {
        switch (this.state) {
            case 5: {
                this.containerMenu.keyPressed(keyCode, gameKey);
                break;
            }
            case 6: {
                this.containerIngamePauseMenu.keyPressed(keyCode, gameKey);
                break;
            }
            case 3: {
                this.containergameOver.keyPressed(keyCode, gameKey);
                break;
            }
            case 7: {
                this.creditsContainer.keyPressed(keyCode, gameKey);
                break;
            }
            case 2: {
                this.buttons.keyPressed(keyCode, gameKey);
            }
        }
    }

    protected void keyReleasedcanvas(int keyCode, int gameKey) {
        switch (this.state) {
            case 5: {
                this.containerMenu.keyReleased(keyCode, gameKey);
                break;
            }
            case 6: {
                this.containerIngamePauseMenu.keyReleased(keyCode, gameKey);
                break;
            }
            case 3: {
                this.containergameOver.keyReleased(keyCode, gameKey);
                break;
            }
            case 7: {
                this.creditsContainer.keyReleased(keyCode, gameKey);
                break;
            }
            case 2: {
                this.buttons.keyReleased(keyCode, gameKey);
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        if (!Constants.isMobileTouch) {
            Constants.isMobileTouch = true;
        }
        if (com.appon.util.Util.isPortraitMode) {
            int temp = x;
            x = y;
            y = temp;
            y = Constants.SCREEN_HEIGHT - y;
        }
        switch (this.state) {
            case 5: {
                this.containerMenu.pointerPressed(x, y);
                break;
            }
            case 6: {
                this.containerIngamePauseMenu.pointerPressed(x, y);
                break;
            }
            case 3: {
                this.containergameOver.pointerPressed(x, y);
                break;
            }
            case 2: {
                this.buttons.pointerPressed(x, y);
            }
        }
        System.out.println("x: " + x + "y: " + y + " w: " + Constants.SCREEN_WIDTH + " h: " + Constants.SCREEN_HEIGHT);
    }

    protected void pointerReleased(int x, int y) {
        if (com.appon.util.Util.isPortraitMode) {
            int temp = x;
            x = y;
            y = temp;
            y = Constants.SCREEN_HEIGHT - y;
        }
        switch (this.state) {
            case 5: {
                this.containerMenu.pointerReleased(x, y);
                break;
            }
            case 6: {
                this.containerIngamePauseMenu.pointerReleased(x, y);
                break;
            }
            case 3: {
                this.containergameOver.pointerReleased(x, y);
                break;
            }
            case 2: {
                this.buttons.pointerReleased(x, y);
            }
        }
        super.pointerReleased(x, y);
    }

    protected void pointerDragged(int x, int y) {
        switch (this.state) {
            case 7: {
                this.creditsContainer.pointerDragged(x, y);
            }
        }
    }

    public void run() {
        while (true) {
            try {
                block3: while (true) {
                    this.milliesStored = System.currentTimeMillis();
                    this.repaint();
                    this.serviceRepaints();
                    while (true) {
                        if (this.milliesStored + 50L <= System.currentTimeMillis()) continue block3;
                        Thread.yield();
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void buttonReleased(IngameButtonEngine.IngameButton ingameButton) {
        if (ingameButton.getName().equals("Speed")) {
            this.pointerPressed = false;
        } else if (ingameButton.getName().equals("Break")) {
            // empty if block
        }
    }

    public void buttonPressed(IngameButtonEngine.IngameButton ingameButton) {
        if (ingameButton.getName().equals("Speed")) {
            this.pointerPressed = true;
        } else if (ingameButton.getName().equals("Jump")) {
            this.carWheelFront.addForce(new Vector2f(0.0f, -1.002E8f));
            this.carWheelBack.addForce(new Vector2f(0.0f, -1.002E8f));
            ingameButton.setEnabled(false);
        }
        if (ingameButton.getName().equals("rightturn")) {
            this.carBody.setTorque(9000000.0f);
        } else if (ingameButton.getName().equals("leftturn")) {
            this.carBody.setTorque(-9000000.0f);
        } else if (ingameButton.getName().equals("Replay")) {
            this.reset();
        } else if (ingameButton.getName().equals("pause")) {
            this.setState(6);
        }
    }

    public void listenSoftKey(int keycode, int gamekey) {
        IngameButtonEngine.IngameButton b;
        if (com.appon.util.Util.isLeftPressed(gamekey) || com.appon.util.Util.isLeftSoftkeyPressed(keycode)) {
            b = (IngameButtonEngine.IngameButton)this.buttons.getaddedButtonVector().elementAt(2);
            this.buttons.pointerPressed(1, 1);
        }
        if (com.appon.util.Util.isRightPressed(gamekey) || com.appon.util.Util.isRightSoftkeyPressed(keycode, gamekey)) {
            this.buttons.getaddedButtonVector().elementAt(1);
            this.carBody.setTorque(9000000.0f);
        }
        if (com.appon.util.Util.isFirePressed(gamekey)) {
            b = (IngameButtonEngine.IngameButton)this.buttons.getaddedButtonVector().elementAt(0);
            this.buttons.pointerPressed(b.getX(), b.getY());
        }
    }

    public void carCrashed() {
        if (this.gameLost) {
            this.goodScoreCollection.reset();
            this.world.remove(this.jointFWheelToBody);
            this.world.remove(this.jointBWheelToBody);
            this.carWheelFront.setForce(0.0f, 0.0f);
            this.carWheelFront.addForce(new Vector2f(0.0f, -CarCanvas.getRandomNumber(100000, 1000000)));
            this.carBody.setForce(0.0f, 0.0f);
            this.carBody.addForce(new Vector2f(0.0f, -CarCanvas.getRandomNumber(100000, 1000000)));
            this.carWheelBack.setForce(0.0f, 0.0f);
            this.carWheelBack.addForce(new Vector2f(0.0f, -CarCanvas.getRandomNumber(100000, 1000000)));
            this.gameLost = false;
            this.world.remove(this.carBody);
            this.world.remove(this.carWheelBack);
            this.world.remove(this.carWheelFront);
            this.world.step();
            this.carBody.setCollidable(false);
            this.world.add(this.carBody);
            this.world.add(this.carWheelBack);
            this.world.add(this.carWheelFront);
            this.pointerPressed = false;
            this.buttons.removeAll();
            try {
                this.world.step();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("");
            }
        }
    }

    private boolean isBodyPresent(CollisionEvent event, String name) {
        return event.getBodyB().getName().equals(name) || event.getBodyA().getName().equals(name);
    }

    public void collisionOccured(CollisionEvent event) {
        if ((this.isBodyPresent(event, "frontwheel") || this.isBodyPresent(event, "backwheel")) && this.isBodyPresent(event, "roadstrip")) {
            this.buttons.enableButton("Jump", true);
        }
        if (event.getBodyB().getName().equals("carbody") && event.getBodyA().getName().equals("roadstrip")) {
            this.FINAL_TEXT = this.CARSHED + " body collision";
        }
    }

    public void fillPolyArraysXY(ROVector2f[] points) {
        for (int i = 0; i < points.length; ++i) {
            this.gameOverCollisionDetectionArrayX[i] = (int)points[i].getX();
            this.gameOverCollisionDetectionArrayY[i] = (int)points[i].getY();
        }
    }

    private void checkForGameOver() {
        Box box = (Box)this.carBody.getShape();
        Vector2f[] carBodyPts = box.getPoints(this.carBody.getPosition(), this.carBody.getRotation());
        block0: for (int i = 0; i < this.bodylist.size(); ++i) {
            Body roadBody = this.bodylist.get(i);
            if (!roadBody.getName().equals("roadstrip") || !(roadBody.getShape() instanceof Polygon)) continue;
            Polygon b = (Polygon)roadBody.getShape();
            ROVector2f[] pts = b.getVertices(roadBody.getPosition(), roadBody.getRotation());
            this.fillPolyArraysXY(pts);
            for (int j = 0; j < carBodyPts.length; ++j) {
                if (!this.pnpoly(pts.length, this.gameOverCollisionDetectionArrayX, this.gameOverCollisionDetectionArrayY, carBodyPts[j].getX(), carBodyPts[j].getY())) continue;
                this.carCrashed();
                continue block0;
            }
        }
    }

    public int getDirection(float value) {
        return value > 0.0f ? 1 : -1;
    }

    public Image loadImage(String name) {
        try {
            return Resources.getInstance().getImageFromKey(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void buttonkeyPressed(int keycode, int gamekey) {
        IngameButtonEngine.IngameButton b;
        if (com.appon.util.Util.isLeftPressed(gamekey) || com.appon.util.Util.isLeftSoftkeyPressed(keycode)) {
            b = (IngameButtonEngine.IngameButton)this.buttons.getaddedButtonVector().elementAt(4);
            this.buttons.pointerPressed(b.getX(), b.getY());
        }
        if (com.appon.util.Util.isRightPressed(gamekey) || com.appon.util.Util.isRightSoftkeyPressed(keycode, gamekey)) {
            b = (IngameButtonEngine.IngameButton)this.buttons.getaddedButtonVector().elementAt(2);
            this.buttons.pointerPressed(b.getX(), b.getY());
        }
        if (com.appon.util.Util.isFirePressed(gamekey)) {
            b = (IngameButtonEngine.IngameButton)this.buttons.getaddedButtonVector().elementAt(0);
            this.buttons.pointerPressed(b.getX(), b.getY());
        }
        if (com.appon.util.Util.isRightSoftkeyPressed(gamekey)) {
            this.setState(6);
        }
    }

    public void buttonkeyReleased(int keycode, int gamekey) {
        this.buttons.pointerReleased(0, 0);
    }

    protected void showNotify() {
        if (!SoundServer.getInstance().isSoundOff()) {
            SoundServer.getInstance().playSound(0);
        }
        if (this.state == 2) {
            this.setState(6);
        }
    }

    protected void hideNotify() {
        SoundServer.getInstance().stopMedia();
    }

    static {
        random = new Random(System.currentTimeMillis());
        score = 0;
        HighScore = 0;
    }
}

