/*
 * Decompiled with CFR 0.152.
 */
package com.appon.util;

import com.appon.util.Util;
import javax.microedition.rms.RecordStore;

public class Logger {
    public static final int OUTPUTMODE_FILE = 0;
    public static final int OUTPUTMODE_CONSOLE = 1;
    public static final int OUTPUTMODE_DISABLED = 2;
    public static final int LOGGINGLEVEL_INFO = 1;
    public static final int LOGGINGLEVEL_ERROR = 2;
    public static final int LOGGINGLEVEL_ALERT = 4;
    public static final int LOGGINGLEVEL_ALL = 7;
    private static int loggingLevel = 7;
    private static int outputMode = 1;
    private static final String FILE_PATH = "Logger";
    private static RecordStore rs;

    public static void log(String msg) {
        Logger.log("default", msg);
    }

    public static void error(String msg) {
        Logger.error("default", msg);
    }

    public static void alert(String msg) {
        Logger.alert("default", msg);
    }

    public static void log(String tag, String msg) {
        if ((loggingLevel & 1) != 0) {
            msg = "Log:: " + msg;
            Logger.writeLog(tag, msg);
        }
    }

    public static void error(String tag, String msg) {
        if ((loggingLevel & 2) != 0) {
            msg = "Error:: " + msg;
            Logger.writeLog(tag, msg);
        }
    }

    public static void alert(String tag, String msg) {
        if ((loggingLevel & 4) != 0) {
            msg = "Alert:: " + msg;
            Logger.writeLog(tag, msg);
        }
    }

    public static void setLoggingLevel(int loggingLevel) {
        Logger.loggingLevel = loggingLevel;
    }

    public static void setOutputMode(int outputMode) {
        Logger.outputMode = outputMode;
    }

    private static void writeLog(String tag, String msg) {
        if (outputMode == 1) {
            Logger.writeToConsole(tag, msg);
        } else if (outputMode == 0) {
            Logger.writeToFile(msg);
        }
    }

    private static void writeToFile(String msg) {
        try {
            if (rs == null) {
                rs = RecordStore.openRecordStore((String)FILE_PATH, (boolean)true);
            }
            rs.addRecord(msg.getBytes(), 0, msg.getBytes().length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void writeToConsole(String tag, String msg) {
        System.out.println(tag + msg);
    }

    private static void clear() {
        Util.deleteRMS(FILE_PATH);
    }
}

