/*
 * Decompiled with CFR 0.152.
 */
package mindbooster;

import mindbooster.MapDesign;

public class Map {
    private MapDesign mDesign;
    private int[][] mGoals;
    private int mGoalCount;

    public Map(MapDesign design) {
        this.mDesign = design;
        this.init();
    }

    public void init() {
        if (this.mGoals == null) {
            this.mGoals = new int[this.mDesign.getSizeY()][this.mDesign.getSizeX()];
        }
        int[][] goals = this.mDesign.getGoals();
        for (int y = 0; y < this.mDesign.getSizeY(); ++y) {
            for (int x = 0; x < this.mDesign.getSizeX(); ++x) {
                this.mGoals[y][x] = goals[y][x];
            }
        }
        this.mGoalCount = this.mDesign.getGoalCount();
    }

    public String getName() {
        return this.mDesign.getName();
    }

    public int[][] getWalls() {
        return this.mDesign.getWalls();
    }

    public int getWalls(int x, int y) {
        return this.mDesign.getWalls(x, y);
    }

    public int[][] getGoals() {
        return this.mGoals;
    }

    public int getGoal(int x, int y) {
        return this.mGoals[y][x];
    }

    public void removeGoal(int x, int y) {
        this.mGoalCount -= this.mGoals[y][x];
        this.mGoals[y][x] = 0;
    }

    public void setGoal(int x, int y, int value) {
        this.mGoalCount -= this.mGoals[y][x] - value;
        this.mGoals[y][x] = value;
    }

    public int getSizeX() {
        return this.mDesign.getSizeX();
    }

    public int getSizeY() {
        return this.mDesign.getSizeY();
    }

    public int getInitialPositionX() {
        return this.mDesign.getInitialPositionX();
    }

    public int getInitialPositionY() {
        return this.mDesign.getInitialPositionY();
    }

    public int getGoalCount() {
        return this.mGoalCount;
    }
}

