/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.GameImpl;
import com.ea.game.ISound;

public class Sound {
    private static Thread s_sfxThread;
    private static boolean s_isSoundThreadStarted;
    private static int s_lastSFXLagDelay;
    private static byte s_currentPlayingMusic;
    private static byte s_musicPlayingBeforeInterruption;
    private static int s_musicInterruptionStopTimer;
    private static final int SOUND_THREAD_PRIORITY = 10;

    private static void playSFXSound(byte by) {
        if (by == -1) {
            return;
        }
        if (ISound.SFX_FILE[by] == -1) {
            return;
        }
        try {
            GameImpl.s_soundManager.setCurrentLoop(1);
            GameImpl.s_soundManager.setPlaybackType(ISound.SFX_PRIORITY_PROPERTY[by]);
            GameImpl.s_soundManager.playSound(ISound.SFX_FILE[by]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void loadSFX(byte by) {
    }

    public static void loadMusic(byte by) {
    }

    public static void playSFX(byte by) {
        Sound.playSFX(by, false);
    }

    public static void playSFX(byte by, boolean bl) {
        if (by == -1) {
            return;
        }
        final byte by2 = ISound.SFX_MAPPING[by];
        if (by2 == -1) {
            return;
        }
        if (ISound.SFX_FILE[by2] == -1) {
            return;
        }
        if (GameImpl.getSoundState() == 0 || bl && GameImpl.getSoundState() == 1) {
            if (s_sfxThread != null) {
                if (s_sfxThread.isAlive()) {
                    if (ISound.SFX_PRIORITY_PROPERTY[by2] == 1) {
                        return;
                    }
                    try {
                        s_sfxThread.join();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                s_sfxThread = null;
                s_isSoundThreadStarted = false;
                s_lastSFXLagDelay = 0;
            }
            if (ISound.SFX_SYNCHRONIZATION_PROPERTY[by2] == 1) {
                Sound.playSFXSound(by2);
            } else {
                s_isSoundThreadStarted = true;
                s_sfxThread = new Thread(){

                    public void run() {
                        Sound.playSFXSound(by2);
                        s_isSoundThreadStarted = false;
                    }
                };
                s_sfxThread.setPriority(10);
                s_sfxThread.start();
            }
        }
    }

    public static void unloadAllSounds() {
        int n;
        for (n = 0; n < 16; n = (int)((byte)(n + 1))) {
            if (ISound.MUSIC_MAPPING[n] == -1 || ISound.MUSIC_FILE[ISound.MUSIC_MAPPING[n]] == -1) continue;
            try {
                GameImpl.s_soundManager.unloadCachedSound(ISound.MUSIC_FILE[ISound.MUSIC_MAPPING[n]]);
                GameImpl.s_soundManager.unloadSound(ISound.MUSIC_FILE[ISound.MUSIC_MAPPING[n]]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n = 0; n < 55; n = (int)((byte)(n + 1))) {
            if (ISound.SFX_MAPPING[n] == -1 || ISound.SFX_FILE[ISound.SFX_MAPPING[n]] == -1) continue;
            try {
                GameImpl.s_soundManager.unloadCachedSound(ISound.SFX_FILE[ISound.SFX_MAPPING[n]]);
                GameImpl.s_soundManager.unloadSound(ISound.SFX_FILE[ISound.SFX_MAPPING[n]]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void playMusic(byte by) {
        Sound.playMusic(by, false);
    }

    public static void playMusic(byte by, boolean bl) {
        if (by == -1) {
            return;
        }
        byte by2 = ISound.MUSIC_MAPPING[by];
        if (by2 == -1) {
            return;
        }
        if (ISound.MUSIC_FILE[by2] == -1) {
            return;
        }
        if (GameImpl.getSoundState() == 1 || bl && GameImpl.getSoundState() == 0) {
            if (by2 == s_currentPlayingMusic && ISound.MUSIC_LOOPING[by2] == 0) {
                return;
            }
            Sound.stopSound();
            s_currentPlayingMusic = by2;
            try {
                if (ISound.MUSIC_LOOPING[by2] == 0) {
                    GameImpl.s_soundManager.setCurrentLoop(-1);
                } else {
                    GameImpl.s_soundManager.setCurrentLoop(1);
                }
                GameImpl.s_soundManager.setPlaybackType(0);
                GameImpl.s_soundManager.playSound(ISound.MUSIC_FILE[by2]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void stopSound() {
        try {
            GameImpl.s_soundManager.stopSounds();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        s_currentPlayingMusic = (byte)-1;
        s_musicPlayingBeforeInterruption = (byte)-1;
        s_lastSFXLagDelay = 0;
    }

    private static void checkInterruptedMusicResume() {
        if (s_musicPlayingBeforeInterruption != -1 && (s_musicInterruptionStopTimer -= GameImpl.s_elapsedTimeClamped) < 0) {
            s_musicInterruptionStopTimer = 0;
            Sound.playMusic(s_musicPlayingBeforeInterruption);
            s_musicPlayingBeforeInterruption = (byte)-1;
        }
    }

    public static void resumeMusicInterruption() {
        s_musicInterruptionStopTimer = 1000;
    }

    public static void checkMusicInterruption() {
        if (s_currentPlayingMusic != -1) {
            byte by = s_currentPlayingMusic;
            Sound.stopSound();
            s_musicPlayingBeforeInterruption = by;
            s_musicInterruptionStopTimer = 1000;
        }
    }

    private static void updateThreadedSFXLag() {
        if (s_isSoundThreadStarted) {
            s_lastSFXLagDelay += GameImpl.s_elapsedTimeClamped;
        }
    }

    public static int getLastSFXLagDelay() {
        return s_lastSFXLagDelay;
    }

    public static void resetLastSFXLag() {
        s_lastSFXLagDelay = 0;
    }

    public static void update() {
        Sound.checkInterruptedMusicResume();
        Sound.updateThreadedSFXLag();
    }

    static {
        s_currentPlayingMusic = (byte)-1;
        s_musicPlayingBeforeInterruption = (byte)-1;
    }
}

