/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animation;
import com.ea.game.FileManager;
import com.ea.game.GameImpl;
import com.ea.game.Tileset;

public class Softkey {
    public static final byte SOFTKEY_ID_NONE = 0;
    public static final byte SOFTKEY_ID_OK = 1;
    public static final byte SOFTKEY_ID_NO = 2;
    public static final byte SOFTKEY_ID_NEXT = 3;
    public static final byte SOFTKEY_ID_BACK = 4;
    public static final byte SOFTKEY_ID_PAUSE = 5;
    public static final byte SOFTKEY_ID_INFO = 6;
    private static final byte SOFTKEY_TYPE_ACCEPT = 0;
    private static final byte SOFTKEY_TYPE_CANCEL = 1;
    private static final byte SOFTKEY_TYPE_BOTH = 2;
    private static final byte[] SOFTKEY_TYPES = new byte[]{2, 0, 1, 0, 1, 1, 0};
    private static final int[] SOFTKEY_ANIMATIONS = new int[]{0, 167772199, 167772198, 167772197, 167772195, 167772200, 167772196};
    private static final int[] SOFTKEY_TILESETS = new int[]{0, 167772287, 167772286, 167772285, 167772283, 0xA000080, 167772284};
    private static final int COLOR_DEBUG_SOFTKEY_LEFT = 65280;
    private static final int COLOR_DEBUG_SOFTKEY_RIGHT = 0xFF0000;
    private static Tileset[] s_softkeyTileset;
    private static Tileset s_softkeyTilesetKS;
    private static Animation[] s_softkeyAnimation;
    private static Animation s_softkeyBGAnimationLeft;
    private static Animation s_softkeyBGAnimationRight;
    private static Animation s_softkeyKSAnimationLeft;
    private static Animation s_softkeyKSAnimationRight;
    private static int s_softkeyAnimationInstance;
    private static byte s_currentAcceptSofkeyId;
    private static byte s_currentCancelSofkeyId;
    private static int s_softkeyLeftX;
    private static int s_softkeyRightX;
    private static int s_softkeyY;
    private static int s_softkeyBarHeight;
    private static int s_softkeyWidth;
    private static int s_softkeyInteriorOffsetX;
    private static int s_softkeyInteriorOffsetY;

    public static void initSoftkeys() {
        try {
            int n;
            s_softkeyAnimation = new Animation[SOFTKEY_ANIMATIONS.length];
            for (n = 1; n <= 6; ++n) {
                Softkey.s_softkeyAnimation[n] = Animation.loadAnimation(SOFTKEY_ANIMATIONS[n], 1);
            }
            s_softkeyAnimationInstance = 1;
            s_softkeyTileset = new Tileset[SOFTKEY_TILESETS.length];
            for (n = 1; n <= 6; ++n) {
                Softkey.s_softkeyTileset[n] = FileManager.createTileset(SOFTKEY_TILESETS[n]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        s_softkeyInteriorOffsetX = 15;
        s_softkeyInteriorOffsetY = -11;
        s_softkeyLeftX = s_softkeyInteriorOffsetX;
        s_softkeyRightX = GameImpl.s_screenWidth - s_softkeyInteriorOffsetX;
        s_softkeyY = GameImpl.s_screenHeight + s_softkeyInteriorOffsetY;
        s_softkeyBarHeight = s_softkeyAnimation[3].computeGlobalHeight(s_softkeyTileset[3]);
        s_softkeyWidth = s_softkeyAnimation[3].computeGlobalWidth(s_softkeyTileset[3]);
    }

    private static void drawSoftkey(byte by, boolean bl) {
        if (SOFTKEY_TYPES[by] == 0) {
            s_softkeyAnimation[by].drawInstance(s_softkeyAnimationInstance, s_softkeyTileset[by], 0, GameImpl.s_screenHeight, 0);
        } else {
            s_softkeyAnimation[by].drawInstance(s_softkeyAnimationInstance, s_softkeyTileset[by], GameImpl.s_screenWidth, GameImpl.s_screenHeight, 0);
        }
    }

    public static void drawSoftKeys() {
        Softkey.drawSoftKeys(true);
    }

    public static void updateSoftKeys() {
    }

    public static void drawSoftKeys(boolean bl) {
        if (s_currentAcceptSofkeyId != 0) {
            Softkey.drawSoftkey(s_currentAcceptSofkeyId, bl);
        }
        if (s_currentCancelSofkeyId != 0) {
            Softkey.drawSoftkey(s_currentCancelSofkeyId, bl);
        }
    }

    public static void setSoftkeys(byte by, byte by2) {
        s_currentAcceptSofkeyId = by;
        s_currentCancelSofkeyId = by2;
    }

    public static int getSoftkeyHeight() {
        return s_softkeyBarHeight;
    }

    public static byte getAcceptSoftkeyId() {
        return s_currentAcceptSofkeyId;
    }

    public static byte getCancelSoftkeyId() {
        return s_currentCancelSofkeyId;
    }

    public static void resetSoftkeys() {
        Softkey.setSoftkeys((byte)0, (byte)0);
    }
}

