/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animation;
import com.ea.game.Arena;
import com.ea.game.Battle;
import com.ea.game.Camera;
import com.ea.game.FileManager;
import com.ea.game.GameImpl;
import com.ea.game.ICollidable;
import com.ea.game.ICommand;
import com.ea.game.IFighter;
import com.ea.game.Ingame;
import com.ea.game.InputManager;
import com.ea.game.MathTools;
import com.ea.game.Particle;
import com.ea.game.Physics;
import com.ea.game.Projectile;
import com.ea.game.Sound;
import com.ea.game.Special;
import com.ea.game.Tileset;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import java.io.IOException;

public class Fighter
implements ICollidable {
    private static final int AI_MAX = 100;
    private static final int AI_JUMP_ATTACK_DISTANCE = 48;
    public int[] m_physicsData = new int[11];
    public boolean m_isOnGround;
    protected Tileset m_tileset;
    protected Animation[] m_anims;
    public int m_animInstance;
    public int m_fanLiftAnimInstance;
    int m_comboHitsNumber;
    int m_comboDamage;
    int m_animId;
    int m_state;
    protected int m_stateTimer;
    protected int m_attackResetTimer;
    public static final int ORIENTATION_FACING_RIGHT = 1;
    public static final int ORIENTATION_FACING_LEFT = -1;
    public int m_timeSinceLastProjectile;
    public int m_timeSinceLastSpecialMove;
    public int m_juggleCount;
    public int m_jabsHitsCount;
    public int m_jabsInGuardCount;
    public static final int FIGHTER_STATE_STAND = 0;
    public static final int FIGHTER_STATE_WALK_FORWARD = 1;
    public static final int FIGHTER_STATE_WALK_BACKWARD = 2;
    public static final int FIGHTER_STATE_CROUCH = 3;
    public static final int FIGHTER_STATE_STAND_PUNCH = 4;
    public static final int FIGHTER_STATE_STAND_KICK = 5;
    public static final int FIGHTER_STATE_JUMP_FORWARD = 6;
    public static final int FIGHTER_STATE_JUMP_NEUTRAL = 7;
    public static final int FIGHTER_STATE_JUMP_BACKWARD = 8;
    public static final int FIGHTER_STATE_JUMP_ATTACK = 9;
    public static final int FIGHTER_STATE_UPPERCUT = 10;
    public static final int FIGHTER_STATE_SWEEP = 11;
    public static final int FIGHTER_STATE_AIR_HIT = 12;
    public static final int FIGHTER_STATE_GROUND_FALL = 13;
    public static final int FIGHTER_STATE_GROUND_GET_UP = 14;
    public static final int FIGHTER_STATE_STAND_HIT = 15;
    public static final int FIGHTER_STATE_RUN = 16;
    public static final int FIGHTER_STATE_THROW = 17;
    public static final int FIGHTER_STATE_THROWN = 18;
    public static final int FIGHTER_STATE_THROWN_FALL = 19;
    public static final int FIGHTER_STATE_WIN_POSE = 20;
    public static final int FIGHTER_STATE_PROJECTILE = 21;
    public static final int FIGHTER_STATE_DIZZY = 22;
    public static final int FIGHTER_STATE_FROZEN = 23;
    public static final int FIGHTER_STATE_STAND_BLOCK = 24;
    public static final int FIGHTER_STATE_CROUCH_BLOCK = 25;
    public static final int FIGHTER_STATE_SPECIAL = 26;
    public static final int FIGHTER_STATE_REJECTED = 27;
    public static final int FIGHTER_STATE_FATALITY = 28;
    public static final int FIGHTER_STATE_SKELETON = 29;
    public static final int FIGHTER_STATE_COMBO = 30;
    public static final int FIGHTER_STATE_STAND_PUNCH_ALTERNATE = 31;
    public static final int FIGHTER_STATE_IN_NET = 32;
    public static final int FIGHTER_STATE_BABALITY = 33;
    public static final int FIGHTER_STATE_FAN_LIFTED = 34;
    public static final int FIGHTER_STATE_STRAIGHT_FALL = 35;
    public static final int FIGHTER_STATE_STRAIGHT_RECOVER = 36;
    public static final int FIGHTER_STATES_COUNT = 37;
    public static final int FIGHTER_STATE_HARPON_PULL_BACK = 100;
    public static final int FIGHTER_STATE_HARPON_CATCH = 101;
    public static final int FIGHTER_STATE_HARPON_CAUGHT = 102;
    public int m_score;
    public int m_orientation;
    public byte[][][] m_combos;
    public int m_comboId;
    public int m_comboStep;
    protected int m_poolState = 0;
    public static final int POOL_STATE_INACTIVE = 0;
    public static final int POOL_STATE_LOADING = 1;
    public static final int POOL_STATE_ACTIVE = 2;
    public static final int POOL_STATE_CLEANING = 3;
    protected static Fighter[] s_pool;
    public static final int MAX_FIGHTERS_IN_POOL = 8;
    int m_fighterId;
    protected int m_previousState;
    protected int m_poolStateTimer;
    int m_currentLoadingStep;
    protected int m_poolIndex;
    protected byte[] m_inputBuffer = new byte[128];
    protected int m_controlsType;
    protected int m_playerType;
    public static final int PLAYER_TYPE_LOCAL = 0;
    public static final int PLAYER_TYPE_REMOTE = 1;
    public static final int PLAYER_TYPE_CPU = 2;
    protected int m_collidableGroupId;
    protected boolean m_enableControlsOnActivation;
    protected boolean m_controlsEnabled;
    protected boolean m_autoAddToCollidablesOnActivation;
    protected int m_tilesetType;
    boolean m_attackConnected;
    boolean m_isTrajectoryLaunched;
    protected boolean m_resetTrajectory;
    protected int m_trajectoryFpWidth;
    protected int m_trajectoryFpHeight;
    protected int m_trajectoryDuration;
    protected int m_newOrientation;
    public static final int TILESET_IMAGE_TYPE_MAIN = 0;
    public static final int TILESET_IMAGE_TYPE_FROZEN = 1;
    public static final int TILESET_IMAGE_TYPES_COUNT = 2;
    public int m_healthPoints;
    public int m_fpRunMeter;
    public int m_runMeterInactiveTimer;
    public SDKString m_name;
    protected Fighter m_thrownOpponent;
    protected int m_throwTransformation;
    protected boolean m_throwDebug;
    protected int[] m_throwData;
    protected int m_antiThrowTimer;
    protected Projectile m_projectile;
    protected int m_frozenFrame;
    protected int m_tilesetBeforeFrozen;
    protected byte[][] m_commands;
    boolean m_leftWallCollided;
    boolean m_rightWallCollided;
    boolean m_attackBlocked;
    protected boolean m_attackHit;
    protected boolean m_autoUpdateAnimation;
    protected boolean m_useCustomAnim;
    protected Animation m_customAnim;
    protected Tileset m_customTileset;
    protected boolean m_skipPhysics;
    protected boolean m_isShaking;
    public int m_animFreezeTimer;
    SDKString m_moveList;
    private int m_aiTimer;
    private int m_aiState;
    private int m_aiCycleTimer;
    private boolean m_aiStronglyActive;
    public boolean m_useThrowTransformation;
    protected boolean m_nextJabBackward;
    protected boolean m_nextJab;
    public Tileset m_babalityTileset;
    public Animation m_babalityAnimation;
    public boolean m_blockUsed;
    public boolean m_isFrozenTilesetLoaded;
    protected int m_attackConnectedTimer;
    protected short[] m_projectileData;
    protected short[] m_airProjectileData;
    public static final int THROW_METADATA_EJECTION_TIMER = 0;
    public static final int THROW_METADATA_RECOVERY_TIMER = 1;
    public static final int THROW_METADATA_TRAJECTORY_WIDTH = 2;
    public static final int THROW_METADATA_TRAJECTORY_HEIGHT = 3;
    public static final int THROW_METADATA_TRAJECTORY_DURATION = 4;
    public static final int SIZEOF_THROW_METADATA = 5;
    public static final int THROW_OFFSET_DX = 0;
    public static final int THROW_OFFSET_DY = 1;
    public static final int THROW_OFFSET_ANIM = 2;
    public static final int THROW_OFFSET_FRAME = 3;
    public static final int THROW_OFFSET_TRANSFORMATION = 4;
    public static final int SIZEOF_THROW = 5;
    public static final int FIGHTER_ANIM_STAND = 0;
    public static final int FIGHTER_ANIM_STAND_BLOCK = 1;
    public static final int FIGHTER_ANIM_STAND_HIT = 2;
    public static final int FIGHTER_ANIM_AIR_HIT = 3;
    public static final int FIGHTER_ANIM_CROUCH = 4;
    public static final int FIGHTER_ANIM_CROUCH_BLOCK = 5;
    public static final int FIGHTER_ANIM_WALK = 6;
    public static final int FIGHTER_ANIM_RUN = 7;
    public static final int FIGHTER_ANIM_GROUND_FALL = 8;
    public static final int FIGHTER_ANIM_GET_UP = 9;
    public static final int FIGHTER_ANIM_JAB = 10;
    public static final int FIGHTER_ANIM_JAB_ALTERNATE = 11;
    public static final int FIGHTER_ANIM_JAB_RECOVER = 12;
    public static final int FIGHTER_ANIM_SWEEP = 13;
    public static final int FIGHTER_ANIM_LOW_KICK = 14;
    public static final int FIGHTER_ANIM_UPPERCUT = 15;
    public static final int FIGHTER_ANIM_THROW = 16;
    public static final int FIGHTER_ANIM_JUMP_TAKE_OFF = 17;
    public static final int FIGHTER_ANIM_JUMP_ROLL = 18;
    public static final int FIGHTER_ANIM_JUMP_STRAIGHT = 19;
    public static final int FIGHTER_ANIM_JUMP_ATTACK = 20;
    public static final int FIGHTER_ANIM_PROJECTILE = 21;
    public static final int FIGHTER_ANIM_DIZZY = 22;
    public static final int FIGHTER_ANIM_REJECT = 23;
    public static final int FIGHTER_ANIM_COMBO_1 = 24;
    public static final int FIGHTER_ANIM_COMBO_2 = 25;
    public static final int FIGHTER_ANIM_SPECIAL_1 = 26;
    public static final int FIGHTER_ANIM_SPECIAL_2 = 27;
    public static final int FIGHTER_ANIM_FATALITY_1 = 28;
    public static final int FIGHTER_ANIM_FATALITY_2 = 29;
    public static final int FIGHTER_ANIM_FATALITY_3 = 30;
    public static final int FIGHTER_ANIM_NO_HEAD = 31;
    public static final int FIGHTER_ANIM_HEAD_ROLL = 32;
    public static final int FIGHTER_ANIM_WIN_POSE = 33;
    public static final int FIGHTER_ANIM_BABALITY = 33;
    public static final int FIGHTER_ANIMS_COUNT = 34;
    public static final int FIGHTER_LOADING_STEP_TILESET = 0;
    public static final int FIGHTER_LOADING_STEP_ANIMATIONS = 1;
    public static final int FIGHTER_LOADING_STEP_FX = 2;
    public static final int FIGHTER_LOADING_STEP_DATA = 3;
    public static final int FIGHTER_LOADING_STEPS = 4;
    protected static final int MAX_INPUTS_IN_BUFFER = 128;
    protected static final int FIGHTER_SECURITY_TIMER = 200;
    protected static final int FIGHTER_TIMER_GET_UP = 150;
    protected static final int FIGHTER_TIMER_TAKE_OFF = 100;
    protected static final int COLLISION_BOXES_COUNT = 1;
    private static final boolean IS_DYNAMIC_FROZEN_PALETTE_SWAPPING = false;

    public void addKeyToInputBuffer() {
        InputManager.addKeyToInputBuffer(this.getMortalKey(), this.m_inputBuffer);
    }

    public Fighter() {
        InputManager.resetInputBuffer(this.m_inputBuffer);
        this.setOrientation(1);
    }

    public void setOrientation(int n) {
        if (this.m_orientation != n && this.isInChangeableOrientationState()) {
            this.m_newOrientation = n;
            this.m_orientation = n;
        }
    }

    public byte getMortalKey() {
        if (this.m_poolIndex == 0) {
            int n = 0;
            n = this.m_orientation == 1 ? (this.m_controlsType == 0 ? 0 : 2) : (this.m_controlsType == 0 ? 1 : 3);
            int[] nArray = ICommand.KEYPAD_LAYOUT[n];
            for (byte by = 0; by < nArray.length; by = (byte)(by + 1)) {
                int n2;
                int n3 = n2 = by == 0 || by == 1 || by == 2 || by == 3 ? InputManager.s_keysPressed : InputManager.s_keysDown;
                if ((nArray[by] & n2) == 0) continue;
                return by;
            }
        }
        return 10;
    }

    protected boolean isInChangeableOrientationState() {
        return this.m_state == 0 || this.m_state == 1 || this.m_state == 2 || this.m_state == 3 || this.m_state == 9 && this.m_stateTimer == 0 || this.m_state == 12 && this.m_stateTimer == 0 || this.m_state == 14 && this.m_stateTimer >= 200 || this.m_state == 25 && this.m_stateTimer == 0 || this.m_state == 24 && this.m_stateTimer == 0 || this.m_state == 15 && this.m_stateTimer == 0 || this.m_state == 102;
    }

    public static Fighter createFighter(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, boolean bl2) {
        Fighter fighter = null;
        int n8 = 0;
        for (n8 = 0; n8 < 8; ++n8) {
            if (Fighter.s_pool[n8].m_poolState != 0) continue;
            fighter = s_pool[n8];
            fighter.setPoolIndex(n8);
            fighter.setFighterId(n);
            fighter.setPlayerType(n5);
            fighter.setControlsType(n6);
            fighter.setControlsAutomaticActivation(bl);
            fighter.setCollidableGroupId(n7);
            fighter.setAutoAddToCollidables(bl2);
            fighter.setPosition(n2, n3);
            fighter.setOrientation(n4);
            break;
        }
        return fighter;
    }

    private void setMoveList() {
        this.m_moveList = Special.createMoveList(this.m_commands, this.m_combos, this.m_fighterId);
    }

    private void setCombos() {
        this.m_combos = IFighter.FIGHTERS_COMBOS[this.m_fighterId];
        if (this.m_controlsType == 1 && this.m_combos != null) {
            this.m_combos = Special.simplifyCombos(this.m_combos);
        }
    }

    protected void setProjectiles() {
        this.m_projectileData = IFighter.FIGHTERS_PROJECTILES[this.m_fighterId];
        this.m_airProjectileData = IFighter.FIGHTERS_AIR_PROJECTILES[this.m_fighterId];
    }

    void restoreRunMeter() {
        this.m_fpRunMeter = 25600;
    }

    protected void updateRunMeter() {
        this.m_runMeterInactiveTimer += GameImpl.s_elapsedTimeClamped;
        if (this.m_runMeterInactiveTimer > 3000) {
            this.alterRunMeter(GameImpl.s_elapsedTimeClamped * 19200 / 1000);
        }
    }

    protected void alterRunMeter(int n) {
        if (n < 0 && this.m_fpRunMeter > 0) {
            this.m_runMeterInactiveTimer = 0;
        }
        this.m_fpRunMeter += n;
        this.m_fpRunMeter = Math.max(this.m_fpRunMeter, 0);
        this.m_fpRunMeter = Math.min(this.m_fpRunMeter, 25600);
    }

    protected void setName() {
        this.m_name = Fighter.getFighterNameById(this.m_fighterId);
    }

    public boolean isAMan() {
        switch (this.m_fighterId) {
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.getName().toString();
    }

    public static SDKString getFighterNameById(int n) {
        return SDKUtils.getString(IFighter.FIGHTER_NAMES[n], null);
    }

    public void restoreMaxHealthPoints() {
        this.m_healthPoints = 100;
    }

    public void setControlsAutomaticActivation(boolean bl) {
        this.m_enableControlsOnActivation = bl;
    }

    public boolean getControlsAutomaticActivation() {
        return this.m_enableControlsOnActivation;
    }

    public void setAutoAddToCollidables(boolean bl) {
        this.m_autoAddToCollidablesOnActivation = bl;
    }

    public boolean getCollidablesAutoAdding() {
        return this.m_autoAddToCollidablesOnActivation;
    }

    protected void setPlayerType(int n) {
        this.m_playerType = n;
    }

    protected void setControlsType(int n) {
        this.m_controlsType = n;
    }

    public void setCollidableGroupId(int n) {
        this.m_collidableGroupId = n;
    }

    public int getCollidableGroupId() {
        return this.m_collidableGroupId;
    }

    protected void setPoolIndex(int n) {
        this.m_poolIndex = n;
    }

    protected void setFighterId(int n) {
        boolean bl = this.m_fighterId != n || this.m_poolState != 2;
        this.m_fighterId = n;
        if (bl) {
            Physics.removeCollidable(this, this.m_collidableGroupId);
            this.initPoolState(1);
        }
    }

    public void setPosition(int n, int n2) {
        this.m_physicsData[0] = n << 8;
        this.m_physicsData[1] = n2 << 8;
        this.m_physicsData[8] = n << 8;
        this.m_physicsData[9] = n2 << 8;
        this.m_physicsData[7] = 0;
    }

    public static void initPool() {
        s_pool = new Fighter[8];
        for (int i = 0; i < s_pool.length; ++i) {
            Fighter.s_pool[i] = new Fighter();
        }
    }

    protected void initPoolState(int n) {
        this.cleanupPoolState(this.m_poolState);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.disableControls();
                this.m_currentLoadingStep = 0;
                break;
            }
            case 2: {
                this.initState(0);
                this.m_isOnGround = true;
                if (this.getCollidablesAutoAdding()) {
                    Physics.addCollidable(this, this.getCollidableGroupId());
                }
                if (this.getControlsAutomaticActivation()) {
                    this.enableControls();
                }
                this.m_autoUpdateAnimation = true;
                this.m_skipPhysics = false;
                break;
            }
            case 3: {
                Physics.removeCollidable(this, this.m_collidableGroupId);
                Special.removeFighterFromPool(this);
                if (!Special.isNoLongerInPool(this.m_fighterId)) break;
                Projectile.cleanupProjectileResources(this.m_projectileData[0]);
                Special.cleanupSpecificResources(this.m_fighterId);
            }
        }
        this.m_poolStateTimer = 0;
        this.m_poolState = n;
    }

    protected void updatePoolState() {
        switch (this.m_poolState) {
            case 3: {
                this.initPoolState(0);
                break;
            }
            case 1: {
                if (this.m_currentLoadingStep < Fighter.getLoadingSteps()) break;
                this.initPoolState(2);
            }
        }
        block4 : switch (this.m_poolState) {
            case 1: {
                switch (this.m_currentLoadingStep) {
                    case 0: {
                        this.loadTileset();
                        ++this.m_currentLoadingStep;
                        break block4;
                    }
                    case 1: {
                        this.loadCommonAnimations();
                        ++this.m_currentLoadingStep;
                        break block4;
                    }
                    case 2: {
                        ++this.m_currentLoadingStep;
                        break block4;
                    }
                    case 3: {
                        this.restoreMaxHealthPoints();
                        this.restoreRunMeter();
                        this.setProjectiles();
                        this.setCombos();
                        this.setCommands();
                        this.setMoveList();
                        this.setName();
                        this.m_throwData = IFighter.FIGHTER_THROWS[this.m_fighterId];
                        ++this.m_currentLoadingStep;
                    }
                }
            }
        }
    }

    protected void setCommands() {
        this.m_commands = this.m_controlsType == 0 ? IFighter.FIGHTERS_SPECIAL_COMMANDS[this.m_fighterId] : IFighter.COMMON_SPECIAL_COMMANDS;
    }

    protected static int getLoadingSteps() {
        return 4;
    }

    protected void cleanupPoolState(int n) {
        switch (n) {
            default: 
        }
    }

    public static void releasePool() {
        s_pool = null;
    }

    public static void updateFighters() {
        if (s_pool == null) {
            Fighter.initPool();
        }
        for (int i = 0; i < s_pool.length; ++i) {
            s_pool[i].updatePoolState();
            if (Fighter.s_pool[i].m_poolState != 2) continue;
            s_pool[i].update();
        }
    }

    public void playNewAnim(int n) {
        this.m_useCustomAnim = false;
        this.m_animId = n;
        this.m_animInstance = 1;
    }

    public void reversePlayNewAnim(int n) {
        this.m_useCustomAnim = false;
        this.m_animId = n;
        Animation animation = this.getCurrentAnimation();
        this.m_animInstance = animation.createInstance(animation.getTotalDuration(), animation.getNbFrames() - 1, 2);
    }

    public void playNewAnimAtTheEnd(int n) {
        this.m_useCustomAnim = false;
        this.m_animId = n;
        Animation animation = this.getCurrentAnimation();
        this.m_animInstance = animation.createInstance(animation.getTotalDuration(), animation.getNbFrames() - 1, 1);
    }

    public void playNewAnimAt(int n, int n2) {
        this.m_useCustomAnim = false;
        this.m_animId = n;
        Animation animation = this.getCurrentAnimation();
        this.m_animInstance = animation.createInstance(animation.getTotalDuration(), animation.getNbFrames() - 1, 1);
    }

    public void playNewAnim(Animation animation, Tileset tileset) {
        this.m_animInstance = 1;
        this.m_useCustomAnim = true;
        this.m_customAnim = animation;
        this.m_customTileset = tileset;
    }

    public void reversePlayNewAnim(Animation animation, Tileset tileset) {
        this.m_animInstance = 2;
        this.m_useCustomAnim = true;
        this.m_customAnim = animation;
        this.m_customTileset = tileset;
        this.m_animInstance = this.m_customAnim.createInstance(this.m_customAnim.getTotalDuration(), this.m_customAnim.getNbFrames() - 1, 2);
    }

    public static void drawFighters(SDKGraphics sDKGraphics) {
        if (s_pool == null) {
            Fighter.initPool();
        }
        for (int i = 0; i < s_pool.length; ++i) {
            if (Fighter.s_pool[i].m_poolState != 2) continue;
            s_pool[i].draw(sDKGraphics);
        }
    }

    public boolean loadTileset() {
        int n = Fighter.getTilesetDeclaration(this.m_fighterId);
        try {
            int[] nArray = new int[Battle.requiresFrozenTilesets() ? 2 : 1];
            byte[] byArray = new byte[Battle.requiresFrozenTilesets() ? 2 : 1];
            nArray[0] = Battle.doesFighterRequireAlternateTileset(this) ? IFighter.FIGHTERS_TILESETS_ALTERNATIVE[this.m_fighterId] : -1;
            byArray[0] = 0;
            if (Battle.requiresFrozenTilesets()) {
                byArray[1] = 0;
                nArray[1] = IFighter.FIGHTERS_TILESETS_FROZEN[this.m_fighterId];
                this.m_isFrozenTilesetLoaded = true;
            }
            this.m_tileset = FileManager.createTileset(n, nArray, byArray, false, false);
        }
        catch (IOException iOException) {
            return true;
        }
        return false;
    }

    public int getTilesetType() {
        return this.m_tilesetType;
    }

    public static int getTilesetDeclaration(int n) {
        return IFighter.FIGHTERS_TILESETS[n];
    }

    public void setTilesetImageType(int n) {
        this.m_tilesetType = n;
        this.m_tileset.setCurrentImageSlot(this.m_tilesetType);
    }

    public boolean loadCommonAnimations() {
        int[] nArray = Fighter.getAnimationsDeclarations(this.m_fighterId);
        int n = 0;
        try {
            this.m_anims = new Animation[nArray.length / 2];
            for (n = 0; n < nArray.length; n += 2) {
                int n2 = nArray[n];
                int n3 = nArray[n + 1];
                if (n2 == -1) continue;
                this.m_anims[n / 2] = Animation.loadAnimation(n2, n3);
            }
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    public static int[] getAnimationsDeclarations(int n) {
        return IFighter.FIGHTERS_COMMON_ANIMATIONS[n];
    }

    public void update() {
        if (this.m_autoUpdateAnimation) {
            this.updateAnimation();
        }
        Special.updateState(this);
        this.m_leftWallCollided = false;
        this.m_rightWallCollided = false;
    }

    void initState(int n) {
        if (this.hasRestrictedMovement() && Fighter.isStateForbiddenInRestrictedMovements(n)) {
            return;
        }
        this.cleanupState(this.m_state);
        this.m_attackConnected = false;
        this.m_attackBlocked = false;
        this.m_attackHit = false;
        this.m_isTrajectoryLaunched = false;
        this.m_useCustomAnim = false;
        this.m_attackConnectedTimer = 0;
        if (n == 30 || n == 4 || n == 31 || n == 9 || n == 26) {
            Battle.fighterMoved(this);
        }
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                this.playSfx(0);
                break;
            }
            case 31: {
                if (Battle.getOpponentsDistance() < 48 || this.getOpponent().m_state == 15) break;
                this.playSfx(0);
                break;
            }
            case 21: {
                this.playSfx(7);
                break;
            }
            case 26: {
                this.playSfx(10);
                break;
            }
            case 19: {
                if (!this.getOpponent().doesImmediateDamageWithThrow()) break;
                this.playSfx(5);
                break;
            }
            case 13: {
                if (this.m_previousState != 19) break;
                this.playSfx(5);
            }
        }
        switch (n) {
            case 34: {
                this.m_isOnGround = false;
                break;
            }
            case 32: {
                this.cancelTrajectory();
                this.playNewAnim(23);
                break;
            }
            case 0: {
                Battle.backToBlockable(this);
                if (this.m_state == 24) {
                    this.reversePlayNewAnim(1);
                    break;
                }
                this.playNewAnim(0);
                break;
            }
            case 4: {
                this.playNewAnim(10);
                this.m_nextJab = false;
                this.m_nextJabBackward = false;
                this.resetInputBuffer();
                break;
            }
            case 31: {
                if (this.m_nextJabBackward) {
                    this.reversePlayNewAnim(11);
                } else {
                    this.playNewAnim(11);
                }
                this.m_nextJab = false;
                this.resetInputBuffer();
                break;
            }
            case 5: {
                this.playNewAnim(14);
                this.resetInputBuffer();
                break;
            }
            case 3: {
                if (this.m_state == 3) break;
                if (this.m_state == 25) {
                    this.reversePlayNewAnim(5);
                    break;
                }
                if (this.m_state == 11 || this.m_state == 10) {
                    this.playNewAnimAtTheEnd(4);
                    break;
                }
                this.playNewAnim(4);
                break;
            }
            case 10: {
                this.playNewAnim(15);
                this.resetInputBuffer();
                break;
            }
            case 11: {
                this.playNewAnim(13);
                this.resetInputBuffer();
                break;
            }
            case 2: {
                if (this.m_state == 2) break;
                this.reversePlayNewAnim(6);
                break;
            }
            case 1: {
                if (this.m_state == 1) break;
                this.playNewAnim(6);
                break;
            }
            case 6: 
            case 8: {
                this.playNewAnim(17);
                break;
            }
            case 9: {
                this.playNewAnim(20);
                this.resetInputBuffer();
                break;
            }
            case 7: {
                this.playNewAnim(19);
                break;
            }
            case 12: {
                this.playNewAnim(3);
                break;
            }
            case 13: {
                GameImpl.vibrate(500);
                Camera.cameraShake();
                this.playNewAnim(8);
                break;
            }
            case 14: {
                Battle.backToBlockable(this);
                this.playNewAnim(9);
                break;
            }
            case 15: {
                this.playNewAnim(2);
                break;
            }
            case 16: {
                if (this.m_state == 16) break;
                this.playNewAnim(7);
                break;
            }
            case 20: {
                this.playNewAnim(33);
                break;
            }
            case 17: {
                this.m_score += 2500;
                this.playNewAnim(16);
                this.m_thrownOpponent.initState(18);
                this.resetInputBuffer();
                Battle.fighterMoved(this);
                break;
            }
            case 18: {
                this.m_isOnGround = false;
                this.m_isTrajectoryLaunched = true;
                break;
            }
            case 19: {
                this.inflictDamage(16);
                this.m_isOnGround = false;
                this.m_isTrajectoryLaunched = false;
                break;
            }
            case 21: {
                this.m_timeSinceLastProjectile = 0;
                this.m_projectile = null;
                if (this.m_isOnGround) {
                    this.playNewAnim(21);
                } else {
                    this.playNewAnim(27);
                }
                this.cancelTrajectory();
                break;
            }
            case 100: {
                this.playNewAnim(27);
                break;
            }
            case 22: {
                this.m_isTrajectoryLaunched = true;
                this.playNewAnim(22);
                break;
            }
            case 101: {
                break;
            }
            case 102: {
                this.playNewAnim(3);
                this.m_isOnGround = true;
                this.m_physicsData[1] = 0;
                this.m_resetTrajectory = true;
                break;
            }
            case 23: {
                this.m_tilesetBeforeFrozen = this.getTilesetType();
                this.setTilesetImageType(1);
                this.m_frozenFrame = Animation.getInstanceCurrentFrame(this.m_animInstance);
                break;
            }
            case 24: {
                this.playNewAnim(1);
                this.m_blockUsed = true;
                break;
            }
            case 25: {
                this.playNewAnim(5);
                this.m_blockUsed = true;
                break;
            }
            case 26: {
                Special.initSpecialMove(this);
                break;
            }
            case 27: {
                this.playNewAnim(23);
                this.cancelTrajectory();
                break;
            }
            case 28: 
            case 33: {
                Battle.fighterMoved(this);
                Special.initFinisher(this);
                break;
            }
            case 30: {
                this.m_animFreezeTimer = 500;
                this.resetInputBuffer();
                int n2 = this.getCurrentComboAnimId();
                this.playNewAnim(n2);
                break;
            }
            case 35: {
                this.cancelTrajectory();
                this.playNewAnim(3);
                break;
            }
            case 36: {
                this.cancelTrajectory();
                this.reversePlayNewAnim(19);
            }
        }
        this.m_stateTimer = 0;
        this.m_previousState = this.m_state;
        this.m_state = n;
    }

    protected void cancelTrajectory() {
        this.m_physicsData[7] = 0;
        this.m_physicsData[4] = 0;
        this.m_physicsData[2] = 0;
        this.m_physicsData[3] = 0;
    }

    private static boolean isStateForbiddenInRestrictedMovements(int n) {
        return n == 6 || n == 8 || n == 7 || n == 3 || n == 11 || n == 17 || n == 30 || n == 16 || n == 10;
    }

    private int getCurrentComboAnimId() {
        return this.m_combos[this.m_comboId][this.m_comboStep * 2 + 1][0];
    }

    public Animation getCurrentAnimation() {
        if (this.m_useCustomAnim) {
            return this.m_customAnim;
        }
        if (this.m_anims == null || this.m_animId < 0 || this.m_animId >= this.m_anims.length) {
            return null;
        }
        return this.m_anims[this.m_animId];
    }

    public void updateAnimation() {
        Animation animation = this.getCurrentAnimation();
        if (animation != null && this.m_state != 18 && this.m_state != 19) {
            this.m_animInstance = animation.updateInstance(this.m_animInstance, GameImpl.s_elapsedTimeClamped);
        }
    }

    public boolean animationFinished() {
        return Animation.getInstanceCurrentState(this.m_animInstance) == 0;
    }

    private byte[] getCurrentComboTransitCommand() {
        if ((this.m_comboStep + 1) * 2 >= this.m_combos[this.m_comboId].length) {
            return null;
        }
        return this.m_combos[this.m_comboId][(this.m_comboStep + 1) * 2 + 0];
    }

    protected void resetThrow() {
        if (this.m_thrownOpponent != null) {
            this.m_thrownOpponent.initState(0);
            this.m_thrownOpponent = null;
        }
    }

    protected void resetProjectile() {
        if (this.m_projectile != null && this.m_projectile.isActive()) {
            this.m_projectile.deactivate();
            this.m_projectile = null;
        }
    }

    protected boolean canRecoverFromProjectile() {
        return this.animationFinished() && (this.m_isOnGround && this.m_stateTimer > IFighter.PROJECTILES_RECOVERY_TIMERS[this.m_fighterId] || !this.m_isOnGround && this.m_stateTimer > 450);
    }

    protected int[] getThrowData() {
        int[] nArray = this.m_throwData;
        return this.m_throwData;
    }

    protected boolean canRecoverFromThrow() {
        return this.animationFinished() && this.m_stateTimer > this.getThrowData()[1];
    }

    public boolean canRejectOpponent() {
        return this.m_stateTimer > this.getThrowData()[0];
    }

    public void forceAnimationFrame(int n, int n2) {
        this.m_animId = n;
        this.m_animInstance = this.getCurrentAnimation().startInstanceAtFrame(n2);
    }

    boolean healthDepleted() {
        return this.m_healthPoints <= 0;
    }

    protected boolean runMeterDepleted() {
        return this.m_fpRunMeter <= 0;
    }

    public int getPlayerType() {
        return this.m_playerType;
    }

    public void translate(int n, int n2) {
        this.m_physicsData[0] = this.m_physicsData[0] + n;
        this.m_physicsData[1] = this.m_physicsData[1] + n2;
        this.m_physicsData[8] = this.m_physicsData[8] + n;
        this.m_physicsData[9] = this.m_physicsData[9] + n2;
    }

    public boolean isControllable() {
        return this.m_controlsEnabled;
    }

    public void enableControls() {
        this.m_controlsEnabled = true;
    }

    public void disableControls() {
        this.m_controlsEnabled = false;
    }

    public int computeDifficulty() {
        int n = 0;
        switch (GameImpl.getDifficultyState()) {
            case 0: {
                n += 5;
                break;
            }
            case 1: {
                n += 20;
                break;
            }
            case 2: {
                n += 40;
            }
        }
        switch (Ingame.s_arcadeDestinyId) {
            case 0: {
                n += 5;
                break;
            }
            case 1: {
                n += 10;
                break;
            }
            case 2: {
                n += 20;
            }
        }
        switch (GameImpl.getDifficultyState()) {
            case 0: {
                n += Ingame.s_arcadeWonMatch * 8;
                break;
            }
            case 1: {
                n += Ingame.s_arcadeWonMatch * 10;
                break;
            }
            case 2: {
                n += Ingame.s_arcadeWonMatch * 12;
            }
        }
        return Math.min(100, n);
    }

    protected void updateAI() {
        Fighter fighter = Battle.getFighterOpponent(this);
        Fighter fighter2 = Battle.canFighterThrowOpponent(this);
        this.m_aiTimer += GameImpl.s_elapsedTimeReal;
        int n = this.computeDifficulty();
        if (this.m_aiTimer > this.m_aiCycleTimer) {
            this.m_aiCycleTimer = MathTools.getRandomInt(700, 2000);
            this.m_aiTimer = 0;
            boolean bl = this.m_aiStronglyActive = MathTools.getRandomInt(0, 100) < n;
        }
        if (this.m_fighterId == 6) {
            Special.UpdateShaoKahnAI(this, this.m_aiTimer, this.m_aiCycleTimer, n, this.m_aiStronglyActive);
            return;
        }
        if (!this.m_aiStronglyActive) {
            switch (this.m_state) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (this.m_aiTimer > 1800) {
                        switch (MathTools.getRandomInt(0, 1)) {
                            case 0: {
                                this.initState(26);
                                break;
                            }
                            case 1: {
                                if (!this.canPerformProjectile()) break;
                                this.initState(21);
                            }
                        }
                        break;
                    }
                    if (this.m_state == 0) break;
                    this.initState(0);
                }
            }
        }
        if (this.m_aiStronglyActive) {
            switch (this.m_state) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 16: {
                    if (this.m_previousState == 15 && (fighter.m_state == 4 || fighter.m_state == 31)) {
                        this.initState(11);
                        break;
                    }
                    if (fighter.m_state == 30 && Battle.getOpponentsDistance() <= 48 && (this.m_previousState == 24 || this.m_previousState == 25)) {
                        if (fighter2 != null) {
                            this.m_thrownOpponent = fighter2;
                            this.initState(17);
                            break;
                        }
                        this.initState(2);
                        break;
                    }
                    if (Battle.s_battleState == 3) {
                        if (fighter.m_animId != 22) break;
                        if (this.canPerformBabality()) {
                            this.initState(33);
                            break;
                        }
                        if (this.canPerformFatality()) {
                            this.initState(28);
                            break;
                        }
                        if (!this.canPerformProjectile()) break;
                        this.initState(21);
                        break;
                    }
                    if (fighter.m_state == 1) {
                        this.initState(2);
                        break;
                    }
                    if (fighter.m_state == 12 || fighter.m_state == 13 || fighter.m_state == 14) {
                        this.initState(2);
                        break;
                    }
                    if (this.m_state == 3 && fighter.m_projectile != null && fighter.m_projectile.isActive()) {
                        this.initState(3);
                        break;
                    }
                    if (fighter.m_state == 22 && !fighter.healthDepleted()) {
                        if (Battle.getOpponentsDistance() > 45) {
                            this.initState(1);
                            break;
                        }
                        this.initState(10);
                        break;
                    }
                    if (fighter.m_state == 23) {
                        if (Battle.getOpponentsDistance() > 45) {
                            this.initState(1);
                            break;
                        }
                        this.initState(10);
                        break;
                    }
                    if (Battle.getOpponentsDistance() > 69 && Battle.getOpponentsDistance() < 79 && MathTools.getRandomInt(0, 100) <= 10 && this.canPerformProjectile()) {
                        this.initState(21);
                        break;
                    }
                    if (fighter.m_state == 21) {
                        if (Battle.getOpponentsDistance() > 96) {
                            if (this.m_fighterId == 1) {
                                this.initState(26);
                                break;
                            }
                            if (this.m_fighterId == 0) {
                                this.initState(26);
                                break;
                            }
                            if (this.m_fighterId == 5) {
                                this.initState(26);
                                break;
                            }
                            this.initState(3);
                            break;
                        }
                        if (Battle.getOpponentsDistance() > 69) {
                            this.initState(6);
                            break;
                        }
                        this.initState(11);
                        break;
                    }
                    if (fighter2 != null && MathTools.getRandomInt(0, 100) <= 20) {
                        this.m_thrownOpponent = fighter2;
                        this.initState(17);
                        break;
                    }
                    if (fighter.m_state == 10 && Battle.getOpponentsDistance() < 45) {
                        if (fighter.m_stateTimer > 300) {
                            this.initState(10);
                            break;
                        }
                        this.initState(3);
                        break;
                    }
                    if (fighter.m_state == 5) {
                        this.initState(11);
                        break;
                    }
                    if (fighter.m_state == 6 || fighter.m_state == 9) {
                        if (fighter.m_physicsData[4] > 0 && Battle.getOpponentsDistance() < 48) {
                            this.initState(10);
                            break;
                        }
                        this.initState(16);
                        break;
                    }
                    if (fighter.m_state == 8) {
                        if (Battle.getOpponentsDistance() > 96 && this.canPerformProjectile()) {
                            this.initState(21);
                            break;
                        }
                        if (this.m_stateTimer >= 500) {
                            this.initState(6);
                            break;
                        }
                        if (this.m_state == 0) break;
                        this.initState(0);
                        break;
                    }
                    if (!(fighter.m_state != 6 && fighter.m_state != 7 || Battle.getOpponentsDistance() < 75 || this.m_fighterId != 2 && this.m_fighterId != 3)) {
                        if (this.m_fighterId != 2) break;
                        this.initState(26);
                        break;
                    }
                    if (Battle.getOpponentsDistance() < 45) {
                        if (fighter.m_isOnGround) {
                            this.m_comboStep = 0;
                            this.m_comboId = MathTools.getRandomInt(0, this.m_combos.length - 1);
                            this.initState(30);
                            break;
                        }
                        switch (MathTools.getRandomInt(0, 3)) {
                            case 0: {
                                this.initState(10);
                                break;
                            }
                            case 1: {
                                this.initState(4);
                                break;
                            }
                            case 2: {
                                this.initState(5);
                                break;
                            }
                            case 3: {
                                this.initState(11);
                            }
                        }
                        break;
                    }
                    this.initState(1);
                    break;
                }
                case 6: {
                    if (this.m_stateTimer <= 500) break;
                    this.initState(9);
                    break;
                }
                case 30: {
                    byte[] byArray;
                    if (!this.m_attackConnected || (byArray = this.getCurrentComboTransitCommand()) == null || this.m_animFreezeTimer < 150 || this.m_animFreezeTimer >= 400 || !this.m_aiStronglyActive) break;
                    this.nextComboStep();
                }
            }
        }
    }

    private boolean canPerformBabality() {
        return !this.m_blockUsed && !this.healthDepleted() && Battle.s_battleState == 3 && this.getOpponent().m_state == 22;
    }

    public void nextComboStep() {
        ++this.m_comboStep;
        if (this.m_comboStep < this.m_combos[this.m_comboId].length / 2) {
            this.m_fpRunMeter = 0;
            this.initState(30);
        }
    }

    public boolean isCommandInInputBuffer(byte[] byArray) {
        for (int i = 0; i < 2; ++i) {
            if (!InputManager.isCommandInInputBuffer(this.m_inputBuffer, byArray, i)) continue;
            return true;
        }
        return false;
    }

    protected void updateLocalControls() {
        byte by = this.getMortalKey();
        int n = -1;
        boolean bl = false;
        if (this.m_fighterId == 0 && this.canPerformSpecial() && !this.m_isOnGround && (this.m_state == 6 || this.m_state == 8 || this.m_state == 7 || this.m_state == 9) && this.isCommandInInputBuffer(this.m_commands[1])) {
            n = 26;
            bl = true;
        } else if (this.canPerformAirProjectile() && this.isCommandInInputBuffer(this.m_commands[0])) {
            n = 21;
            bl = true;
        }
        if (n == -1) {
            switch (this.m_state) {
                case 27: {
                    if (this.getOpponent().m_comboHitsNumber <= 0) break;
                    if (this.canPerformSpecial() && this.isCommandInInputBuffer(this.m_commands[1])) {
                        n = 26;
                        bl = true;
                        break;
                    }
                    if (!this.canPerformProjectile() || !this.isCommandInInputBuffer(this.m_commands[0])) break;
                    n = 21;
                    bl = true;
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 16: {
                    if (this.canPerformBabality() && this.isCommandInInputBuffer(this.m_commands[3])) {
                        n = 33;
                        bl = true;
                        break;
                    }
                    if (this.canPerformFatality() && this.isCommandInInputBuffer(this.m_commands[2])) {
                        n = 28;
                        bl = true;
                        break;
                    }
                    if (this.canPerformSpecial() && this.isCommandInInputBuffer(this.m_commands[1])) {
                        n = 26;
                        bl = true;
                        break;
                    }
                    if (Battle.canFighterThrowOpponent(this) != null && this.isCommandInInputBuffer(this.getCommand(4))) {
                        this.m_throwDebug = false;
                        this.m_thrownOpponent = Battle.canFighterThrowOpponent(this);
                        if (this.m_thrownOpponent == null) break;
                        n = 17;
                        bl = true;
                        break;
                    }
                    if (this.canPerformProjectile() && this.isCommandInInputBuffer(this.m_commands[0])) {
                        n = 21;
                        bl = true;
                        break;
                    }
                    if (Battle.getOpponentsDistance() < 48 && this.m_state != 3 && this.checkComboStarter() >= 0) {
                        this.m_comboId = this.checkComboStarter();
                        this.m_comboStep = 0;
                        n = 30;
                        bl = true;
                        break;
                    }
                    if (this.isCommandInInputBuffer(this.getCommand(0)) && !this.runMeterDepleted()) {
                        if (this.m_previousState == 16 && this.m_stateTimer <= 1200) break;
                        n = 16;
                        break;
                    }
                    if (this.isCommandInInputBuffer(this.getCommand(3))) {
                        n = 11;
                        break;
                    }
                    if (!this.isCommandInInputBuffer(this.getCommand(2))) break;
                    n = 5;
                }
            }
        }
        if (n == -1) {
            switch (this.m_state) {
                case 4: {
                    if (!this.isCommandInInputBuffer(this.getCommand(1)) || this.m_stateTimer <= 200 || this.hasRestrictedMovement()) break;
                    n = 31;
                    break;
                }
                case 31: {
                    if (!this.isCommandInInputBuffer(this.getCommand(1)) || this.m_nextJab) break;
                    this.m_nextJabBackward = !this.m_nextJabBackward;
                    this.m_nextJab = true;
                    break;
                }
                case 0: {
                    if (this.isCommandInInputBuffer(this.getCommand(1))) {
                        n = 4;
                    }
                    if (n != -1) break;
                    switch (by) {
                        case 8: {
                            n = 3;
                            break;
                        }
                        case 9: {
                            n = 2;
                            break;
                        }
                        case 7: {
                            n = 1;
                            break;
                        }
                        case 6: {
                            n = 6;
                            break;
                        }
                        case 5: {
                            n = 7;
                            break;
                        }
                        case 4: {
                            n = 8;
                        }
                    }
                    break;
                }
                case 16: {
                    switch (by) {
                        case 8: {
                            n = 3;
                            break;
                        }
                        case 9: {
                            n = 2;
                            break;
                        }
                        case 6: {
                            n = 6;
                            break;
                        }
                        case 5: {
                            n = 7;
                            break;
                        }
                        case 4: {
                            n = 8;
                        }
                    }
                    if (n != -1 || this.getMortalKey() == 7) break;
                    n = 0;
                    break;
                }
                case 3: {
                    if (this.isCommandInInputBuffer(this.getCommand(1))) {
                        n = 10;
                    }
                    if (n != -1) break;
                    switch (by) {
                        case 9: {
                            n = 2;
                            break;
                        }
                        case 7: {
                            n = 1;
                            break;
                        }
                        case 6: {
                            n = 6;
                            break;
                        }
                        case 5: {
                            n = 7;
                            break;
                        }
                        case 4: {
                            n = 8;
                        }
                    }
                    break;
                }
                case 1: {
                    if (by == 7 && this.isControllable()) break;
                    n = 0;
                    break;
                }
                case 2: {
                    if (by == 9 && this.isControllable()) break;
                    n = 0;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    if (by != 2 && by != 0 && by != 1) break;
                    n = 9;
                    bl = true;
                    break;
                }
                case 14: {
                    switch (by) {
                        case 6: {
                            n = 6;
                            break;
                        }
                        case 5: {
                            n = 7;
                            break;
                        }
                        case 4: {
                            n = 8;
                        }
                    }
                    break;
                }
                case 30: {
                    byte[] byArray;
                    if (!this.m_attackConnected || (byArray = this.getCurrentComboTransitCommand()) == null || this.m_animFreezeTimer < 150 || this.m_animFreezeTimer >= 400 || !this.isCommandInInputBuffer(byArray)) break;
                    this.nextComboStep();
                }
            }
        }
        if (bl) {
            this.resetInputBuffer();
        }
        if (n != -1) {
            this.initState(n);
        }
    }

    private int checkComboStarter() {
        if (this.m_combos == null || !Battle.getFighterOpponent((Fighter)this).m_isOnGround) {
            return -1;
        }
        for (int i = 0; i < this.m_combos.length; ++i) {
            byte[] byArray = this.m_combos[i][0];
            if (!this.isCommandInInputBuffer(byArray)) continue;
            return i;
        }
        return -1;
    }

    protected boolean canPerformFatality() {
        if (this.healthDepleted() || Battle.s_battleState != 3 || this.getOpponent().m_state != 22 || !this.canPerformProjectile()) {
            return false;
        }
        switch (this.m_fighterId) {
            case 2: {
                return Battle.getOpponentsDistance() < 96;
            }
        }
        return true;
    }

    void resetInputBuffer() {
        InputManager.resetInputBuffer(this.m_inputBuffer);
    }

    protected void drawState(SDKGraphics sDKGraphics) {
        int n = (this.m_physicsData[0] >> 8) - Camera.getCameraLeft();
        int n2 = (this.m_physicsData[1] >> 8) - Camera.getCameraTop();
        Animation animation = this.getCurrentAnimation();
        Tileset tileset = this.getCurrentTileset();
        if (tileset != null && animation != null) {
            int n3;
            int n4 = n3 = this.m_orientation == 1 ? 0 : 4;
            if (this.m_state == 18 || this.m_useThrowTransformation) {
                n3 = this.m_throwTransformation;
                if (this.m_orientation == -1) {
                    switch (n3) {
                        case 0: {
                            n3 = 4;
                            break;
                        }
                        case 1: {
                            n3 = 7;
                            break;
                        }
                        case 2: {
                            n3 = 6;
                            break;
                        }
                        case 3: {
                            n3 = 5;
                        }
                    }
                }
            }
            if (this.m_state == 100 || this.m_state == 101) {
                sDKGraphics.setColor(9985856);
                int n5 = (this.m_projectile.getPhysicsData()[0] >> 8) - Camera.getCameraLeft();
                int n6 = (this.m_projectile.getPhysicsData()[1] >> 8) - Camera.getCameraTop();
                sDKGraphics.drawLine(n + this.m_projectileData[1] * this.m_orientation, n6 - 1, n5, n6 - 1);
                sDKGraphics.drawLine(n + this.m_projectileData[1] * this.m_orientation, n6, n5, n6);
            }
            if (this.m_isShaking) {
                n += 2 * (GameImpl.s_toggle ? 1 : -1);
            }
            this.m_isShaking = false;
            animation.drawInstance(this.m_animInstance, tileset, n, n2, n3);
        }
    }

    protected Tileset getCurrentTileset() {
        if (this.m_useCustomAnim) {
            return this.m_customTileset;
        }
        return this.m_tileset;
    }

    protected void cleanupState(int n) {
        switch (n) {
            case 23: {
                this.setTilesetImageType(0);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 21: {
                this.m_attackResetTimer = 0;
                break;
            }
            case 32: {
                break;
            }
            case 30: {
                this.m_autoUpdateAnimation = true;
                this.m_antiThrowTimer = 0;
                break;
            }
        }
    }

    public void draw(SDKGraphics sDKGraphics) {
        this.drawState(sDKGraphics);
    }

    public boolean skipPhysics() {
        return this.m_skipPhysics || this.m_state == 23 || this.m_state == 26 && this.m_fighterId == 5;
    }

    public int[] getPhysicsData() {
        return this.m_physicsData;
    }

    public boolean getImpactData(int[] nArray, int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        int n2 = 0;
        short[] sArray = IFighter.TRAJ_IMPACT_STANDARD;
        if (this.m_state == 26) {
            switch (this.m_fighterId) {
                case 1: {
                    sArray = IFighter.TRAJ_IMPACT_SUBZERO_GROUND_SLIDE;
                    n2 = 12;
                    bl = true;
                    break;
                }
                case 0: {
                    sArray = IFighter.TRAJ_IMPACT_SCORPION_TELEPORT_PUNCH;
                    n2 = 13;
                    bl2 = true;
                    break;
                }
                case 4: {
                    sArray = IFighter.TRAJ_LAUNCHER_HORIZONTAL;
                    n2 = 17;
                    bl5 = true;
                    bl = true;
                    bl4 = true;
                    break;
                }
                case 3: {
                    sArray = IFighter.TRAJ_LAUNCHER_HORIZONTAL;
                    n2 = 15;
                    bl5 = true;
                    bl = true;
                    bl4 = true;
                    break;
                }
                case 2: {
                    bl7 = true;
                    break;
                }
                case 6: {
                    sArray = IFighter.TRAJ_LAUNCHER_HORIZONTAL_BIG;
                    n2 = 14;
                    bl5 = true;
                    bl = true;
                    bl4 = true;
                    bl3 = true;
                }
            }
        } else {
            switch (this.m_state) {
                case 4: 
                case 31: {
                    bl9 = true;
                    bl5 = true;
                    n2 = 5;
                    if (this.m_fighterId != 6) break;
                    sArray = IFighter.TRAJ_LAUNCHER_HORIZONTAL_BIG;
                    n2 = 14;
                    bl = true;
                    bl4 = true;
                    bl3 = true;
                    break;
                }
                case 10: {
                    sArray = IFighter.TRAJ_IMPACT_UPPERCUT;
                    bl = true;
                    n2 = 20;
                    bl4 = true;
                    bl6 = true;
                    break;
                }
                case 11: {
                    sArray = IFighter.TRAJ_IMPACT_SWEEP;
                    bl = true;
                    n2 = 10;
                    bl8 = true;
                    break;
                }
                case 5: {
                    n2 = 15;
                    if (this.m_fighterId != 6) break;
                    sArray = IFighter.TRAJ_LAUNCHER_HORIZONTAL_BIG;
                    bl = true;
                    n2 = 14;
                    bl4 = true;
                    bl3 = true;
                    bl5 = true;
                    break;
                }
                case 9: {
                    sArray = IFighter.TRAJ_IMPACT_JUMP_ATTACK;
                    bl = true;
                    n2 = 14;
                    bl4 = true;
                    bl5 = true;
                    break;
                }
                case 30: {
                    byte[] byArray = this.m_combos[this.m_comboId][this.m_comboStep * 2 + 1];
                    if (byArray[3] == 1) {
                        sArray = IFighter.TRAJ_LAUNCHER_VERTICAL;
                    } else if (byArray[3] == 2) {
                        sArray = IFighter.TRAJ_LAUNCHER_HORIZONTAL;
                    }
                    bl4 = true;
                    bl = byArray[3] > 0;
                    n2 = byArray[2];
                    bl5 = byArray[4] == 1;
                    boolean bl10 = bl6 = byArray[4] == 2;
                }
            }
        }
        if (this.m_fighterId == 6) {
            n2 *= 2;
        }
        int n3 = 0;
        nArray[n3 + 0] = sArray[0] << 8;
        nArray[n3 + 1] = sArray[1] << 8;
        nArray[n3 + 3] = sArray[2];
        nArray[n3 + 5] = n2;
        nArray[n3 + 4] = bl ? 256 : 0;
        int n4 = n3 + 4;
        nArray[n4] = nArray[n4] | (bl2 ? 128 : 0);
        int n5 = n3 + 4;
        nArray[n5] = nArray[n5] | (bl3 ? 2 : 0);
        int n6 = n3 + 4;
        nArray[n6] = nArray[n6] | (bl4 ? 8192 : 0);
        int n7 = n3 + 4;
        nArray[n7] = nArray[n7] | (bl5 ? 2048 : 0);
        int n8 = n3 + 4;
        nArray[n8] = nArray[n8] | (bl6 ? 4096 : 0);
        int n9 = n3 + 4;
        nArray[n9] = nArray[n9] | (bl7 ? 1 : 0);
        int n10 = n3 + 4;
        nArray[n10] = nArray[n10] | (bl8 ? 4 : 0);
        int n11 = n3 + 4;
        nArray[n11] = nArray[n11] | (bl8 ? 16384 : 0);
        nArray[n3 + 2] = this.m_state;
        return true;
    }

    protected boolean isInAnAttackState() {
        return this.m_state == 9 || this.m_state == 4 || this.m_state == 5 || this.m_state == 11 || this.m_state == 10;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean getCollisionBox(int n, int n2, int[] nArray, int n3) {
        int n4 = this.getX();
        int n5 = this.getY();
        short[] sArray = null;
        block0 : switch (n) {
            case 0: {
                switch (this.m_state) {
                    case 3: 
                    case 11: 
                    case 13: 
                    case 14: {
                        sArray = IFighter.BOX_HIT_COMMON_CROUCH;
                        break block0;
                    }
                    case 26: {
                        if (this.m_fighterId == 1) {
                            sArray = IFighter.BOX_HIT_SUBZERO_SPECIAL;
                            break block0;
                        }
                        if (this.m_fighterId == 3) {
                            sArray = IFighter.BOX_HIT_SQUARE_WAVE_PUNCH;
                            break block0;
                        }
                        if (this.m_fighterId == 5) {
                            return false;
                        }
                        if (this.m_fighterId == 6) {
                            sArray = IFighter.BOX_HIT_COMMON_CROUCH;
                            break block0;
                        }
                        sArray = IFighter.BOX_HIT_COMMON_SPECIAL;
                        break block0;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 35: 
                    case 36: {
                        sArray = IFighter.BOX_HIT_COMMON_JUMP;
                        break block0;
                    }
                    case 28: {
                        return false;
                    }
                    case 21: {
                        sArray = this.m_isOnGround ? IFighter.BOX_HIT_COMMON_DEFAULT : IFighter.BOX_HIT_COMMON_JUMP;
                        break block0;
                    }
                }
                sArray = IFighter.BOX_HIT_COMMON_DEFAULT;
                break;
            }
            case 1: {
                if (this.m_attackConnected) {
                    return false;
                }
                switch (this.m_state) {
                    case 4: 
                    case 31: {
                        if (!this.isInImpactTimer(200)) break;
                        sArray = IFighter.FIGHTERS_JABS_ATTACKBOXES[this.m_fighterId];
                        break;
                    }
                    case 5: {
                        if (!this.isInImpactTimer(290)) break;
                        sArray = IFighter.FIGHTERS_KICKS_ATTACKBOXES[this.m_fighterId];
                        break;
                    }
                    case 11: {
                        if (!this.isInImpactTimer(300)) break;
                        sArray = IFighter.FIGHTERS_SWEEP_ATTACKBOXES[this.m_fighterId];
                        break;
                    }
                    case 10: {
                        if (!this.isInImpactTimer(200)) break;
                        sArray = IFighter.BOX_ATK_COMMON_UPPERCUT;
                        break;
                    }
                    case 9: {
                        if (this.m_stateTimer <= 80) break;
                        sArray = IFighter.FIGHTERS_JUMP_ATTACKBOXES[this.m_fighterId];
                        break;
                    }
                    case 26: {
                        if (this.m_fighterId == 1 && this.m_stateTimer > 100) {
                            sArray = IFighter.BOX_ATK_SUBZERO_GROUND_SLIDE;
                            break;
                        }
                        if (this.m_fighterId == 0) {
                            sArray = IFighter.BOX_ATK_SCORPION_TELEPORT;
                            break;
                        }
                        if (this.m_fighterId == 3) {
                            if (this.m_animId != 26) break;
                            sArray = IFighter.BOX_ATK_SQUARE_WAVE_PUNCH;
                            break;
                        }
                        if (this.m_fighterId == 4 && this.m_stateTimer > 0) {
                            sArray = IFighter.BOX_ATK_DRAGON_KICK;
                            break;
                        }
                        if (this.m_fighterId == 6 && this.m_stateTimer > 250) {
                            sArray = IFighter.BOX_ATK_THRUSTER;
                            break;
                        }
                        if (this.m_fighterId != 2 || this.m_stateTimer <= 250) break;
                        sArray = IFighter.BOX_ATK_FAN_LIFT;
                        break;
                    }
                    case 30: {
                        byte[] byArray = this.m_combos[this.m_comboId][this.m_comboStep * 2 + 1];
                        if (this.m_stateTimer < 20 * byArray[1] || this.m_stateTimer >= 20 * byArray[1] + 200) break;
                        sArray = IFighter.BOX_ATK_COMMON_COMBO;
                    }
                }
                break;
            }
        }
        if (sArray == null) return false;
        nArray[n3 + 0] = n5 + sArray[0];
        nArray[n3 + 3] = n5 + sArray[3];
        if (this.m_orientation == 1) {
            nArray[n3 + 1] = n4 + sArray[1];
            nArray[n3 + 2] = n4 + sArray[2];
            return true;
        }
        nArray[n3 + 1] = n4 + sArray[2] * -1;
        nArray[n3 + 2] = n4 + sArray[1] * -1;
        return true;
    }

    private boolean isInImpactTimer(int n) {
        return this.m_stateTimer >= n && this.m_stateTimer < n + 140;
    }

    public int getCollisionBoxesCount(int n) {
        if (this.m_state == 18 || this.m_state == 19) {
            return 0;
        }
        return 1;
    }

    public boolean getRequiredTrajectory(int[] nArray, int n) {
        boolean bl = false;
        int n2 = 5;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.m_state == 26) {
            switch (this.m_fighterId) {
                case 0: {
                    if (this.m_isTrajectoryLaunched) break;
                    if (this.m_attackBlocked) {
                        n2 = 5;
                        n5 = 3072 * this.m_orientation * -1;
                        n6 = 15360;
                        n4 = 800;
                        this.m_isOnGround = false;
                        bl = true;
                        this.m_isTrajectoryLaunched = true;
                        this.m_stateTimer = 0;
                        break;
                    }
                    n2 = 5;
                    n5 = 24576 * this.m_orientation;
                    n6 = 6144;
                    n4 = 500;
                    this.m_isOnGround = false;
                    bl = true;
                    this.m_isTrajectoryLaunched = true;
                }
            }
        } else if (this.m_state == 17 && this.m_fighterId == 5 && this.m_isOnGround && this.m_stateTimer < 750 && this.m_stateTimer > 100) {
            n2 = 5;
            n5 = 3072 * this.m_orientation * -1;
            n6 = 24576;
            n4 = 750;
            this.m_isOnGround = false;
            bl = true;
            this.m_isTrajectoryLaunched = true;
        }
        if (this.m_resetTrajectory) {
            n3 = 120;
            n4 = 100;
            n5 = 0;
            n6 = -512;
            this.m_resetTrajectory = false;
            bl = true;
        } else if (this.m_isOnGround && (this.m_state == 8 || this.m_state == 7 || this.m_state == 6)) {
            int n7;
            int n8 = n7 = this.m_state == 7 ? 0 : this.m_orientation;
            if (this.m_state == 8) {
                n7 *= -1;
            }
            n2 = 5;
            n5 = 21504 * n7;
            n6 = 21504;
            n4 = 800;
            this.m_isOnGround = false;
            bl = true;
        } else if (!(this.m_state != 12 && this.m_state != 19 && this.m_state != 22 || this.m_isTrajectoryLaunched)) {
            if (this.m_state == 12 && this.m_juggleCount >= 2) {
                n4 = this.m_trajectoryDuration * 204 >> 8;
                n5 = this.m_trajectoryFpWidth * 204 >> 8;
                n6 = this.m_trajectoryFpHeight * 204 >> 8;
            } else {
                n4 = this.m_trajectoryDuration;
                n5 = this.m_trajectoryFpWidth;
                n6 = this.m_trajectoryFpHeight;
            }
            this.m_isOnGround = false;
            this.m_isTrajectoryLaunched = true;
            bl = true;
        }
        if (bl) {
            nArray[n + 0] = n2;
            nArray[n + 1] = n3;
            nArray[n + 2] = n4;
            nArray[n + 3] = n5;
            nArray[n + 4] = n6;
            return true;
        }
        return false;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public int onHit(ICollidable iCollidable, int[] nArray, int[] nArray2) {
        Battle.fighterHit(this);
        if (iCollidable instanceof Fighter) {
            return this.onHitByFighter((Fighter)iCollidable, nArray, nArray2);
        }
        if (iCollidable instanceof Projectile) {
            return this.onHitByProjectile((Projectile)iCollidable, nArray, nArray2);
        }
        return 0;
    }

    public boolean playSfx(int n) {
        byte by = Fighter.getSoundId(n, this.m_fighterId);
        if (by == -1) {
            return false;
        }
        Sound.playSFX(by);
        return true;
    }

    public static byte getSoundId(int n, int n2) {
        return IFighter.FIGHTER_SOUNDS[n2][n];
    }

    protected int onHitByProjectile(Projectile projectile, int[] nArray, int[] nArray2) {
        boolean bl = this.canGuard(false);
        int n = projectile.getDamage();
        int n2 = projectile.getHitEffect(this.m_orientation, bl);
        if (n > 0) {
            Battle.comboHit(this, n);
            GameImpl.vibrate(100);
        }
        if (!bl && !this.isSavedByAutoGuard(false)) {
            projectile.m_owner.m_score += 2000;
            this.inflictDamage(n);
            if (projectile.m_owner != null && projectile.m_owner.m_fighterId == 5) {
                this.playSfx(14);
            } else {
                projectile.m_owner.playSfx(8);
            }
            projectile.onAttackHit(this);
        } else {
            if (this.m_state == 3 || this.m_state == 3) {
                this.initState(25);
            } else {
                this.initState(24);
            }
            this.inflictBlockedDamage(n);
            projectile.onAttackBlocked(this);
            if (projectile.m_owner == null) {
                this.playSfx(1);
            } else {
                projectile.m_owner.playSfx(9);
            }
        }
        if (n2 >= 0) {
            Particle.launchParticleEffect(n2, this.getX(), this.getY() + -65, this.m_fighterId == 5 ? 1 : 0);
        }
        return 0;
    }

    protected boolean canGuard(boolean bl) {
        return this.isControllable() && this.isInPossibleGuardState() && (this.standGuardKeyDown() && !bl || this.crouchGuardKeyDown());
    }

    protected boolean crouchGuardKeyDown() {
        if (this.m_playerType == 0) {
            return this.getMortalKey() == 8;
        }
        return this.m_aiStronglyActive;
    }

    protected boolean standGuardKeyDown() {
        if (this.m_playerType == 0) {
            return this.getMortalKey() == 9;
        }
        return this.m_aiStronglyActive;
    }

    protected boolean isInPossibleGuardState() {
        return this.m_isOnGround && (this.m_state == 2 || this.m_state == 0 || this.m_state == 1 || this.m_state == 3 || this.m_state == 16 || this.m_state == 14 || this.m_state == 27 || this.m_state == 25 || this.m_state == 24);
    }

    protected int onHitByFighter(Fighter fighter, int[] nArray, int[] nArray2) {
        fighter.getImpactData(nArray, 0);
        int n = nArray[5];
        Battle.comboHit(this, n);
        int n2 = 15;
        int n3 = nArray[4];
        boolean bl = (n3 & 0x100) != 0;
        boolean bl2 = (n3 & 4) != 0;
        boolean bl3 = (n3 & 0x80) != 0;
        boolean bl4 = (n3 & 2) != 0;
        boolean bl5 = (n3 & 1) != 0;
        boolean bl6 = (n3 & 0x4000) != 0;
        int n4 = fighter.m_orientation;
        this.m_trajectoryFpWidth = nArray[0] * n4;
        this.m_trajectoryFpHeight = nArray[1];
        this.m_trajectoryDuration = nArray[3];
        if (!this.m_isOnGround || bl) {
            n2 = 12;
            ++this.m_juggleCount;
        }
        if (n2 != 12 && bl3) {
            n2 = 27;
        }
        if (bl5) {
            n2 = 34;
        }
        boolean bl7 = false;
        if (!this.canGuard(bl2) && !this.isSavedByAutoGuard(bl2)) {
            this.initState(n2);
        } else {
            if (bl4) {
                this.initState(27);
            } else if (bl2 || this.crouchGuardKeyDown()) {
                this.initState(25);
            } else {
                this.initState(24);
            }
            bl7 = true;
        }
        if (n > 0) {
            if (bl7) {
                if (this.isSavedByAutoGuard(bl2)) {
                    n *= 2;
                }
                this.inflictBlockedDamage(n);
            } else {
                this.inflictDamage(n);
            }
            fighter.onAttackHit();
        }
        if (bl6) {
            if (bl7) {
                ++this.m_jabsInGuardCount;
            } else {
                ++this.m_jabsHitsCount;
            }
        }
        if (bl7) {
            fighter.onAttackBlocked();
            if (this.getOpponent().m_state == 26) {
                this.getOpponent().playSfx(12);
            } else {
                this.playSfx(1);
            }
            return 0;
        }
        switch (fighter.m_state) {
            case 4: 
            case 31: {
                this.playSfx(2);
                break;
            }
            case 30: {
                if (bl || fighter.m_animId == 25) {
                    this.playSfx(6);
                    break;
                }
                this.playSfx(5);
                break;
            }
            case 9: {
                this.playSfx(5);
                break;
            }
            case 5: 
            case 11: {
                this.playSfx(5);
                break;
            }
            case 10: {
                GameImpl.vibrate(100);
                this.playSfx(6);
                break;
            }
            case 26: {
                if (this.getOpponent().m_fighterId == 6) {
                    this.playSfx(6);
                    break;
                }
                if (this.getOpponent().m_fighterId == 1) {
                    this.playSfx(5);
                    break;
                }
                this.getOpponent().playSfx(11);
            }
        }
        switch (fighter.m_state) {
            case 4: 
            case 31: {
                fighter.m_score += 500;
                break;
            }
            case 5: {
                fighter.m_score += 2000;
                break;
            }
            case 11: {
                fighter.m_score += 1000;
                break;
            }
            case 10: {
                fighter.m_score += 2000;
                break;
            }
            case 9: {
                fighter.m_score += 2000;
                break;
            }
            case 26: {
                fighter.m_score += 2000;
                break;
            }
            case 30: {
                fighter.m_score += 500;
            }
        }
        if ((n3 & 0x2000) != 0) {
            Camera.cameraShake();
        }
        this.m_orientation = n4 * -1;
        int n5 = -1;
        if ((n3 & 0x1000) != 0) {
            n5 = 0;
        } else if ((n3 & 0x800) != 0) {
            int n6 = n5 = this.m_orientation == 1 ? 2 : 1;
        }
        if (n5 >= 0) {
            Particle.launchParticleEffect(n5, this.getX(), -65, this.m_fighterId == 5 ? 1 : 0);
        }
        return 0;
    }

    private boolean isSavedByAutoGuard(boolean bl) {
        return this.isInPossibleGuardState() && !this.canGuard(bl) && this.hasAutoGuardFeature();
    }

    private boolean hasAutoGuardFeature() {
        return this.m_controlsType == 1 && this.m_playerType == 0 && (!Ingame.isInPracticeMode() || this != Battle.s_battleFighter2);
    }

    protected void onAttackBlocked() {
        this.m_attackBlocked = true;
    }

    protected void onAttackHit() {
        this.m_attackHit = true;
    }

    protected void inflictBlockedDamage(int n) {
        this.inflictDamage(n / 3);
    }

    public void inflictDamage(int n) {
        if (this.getOpponent() != null && this.getOpponent().m_healthPoints <= 0) {
            return;
        }
        if (this.m_fighterId == 6) {
            n /= 2;
        }
        this.m_healthPoints -= n;
        this.m_comboDamage += n;
        if (this.m_healthPoints < 0) {
            this.m_healthPoints = 0;
        }
    }

    public void onEnvironmentCollided(int n) {
        switch (n) {
            case 8: {
                this.m_isOnGround = true;
                break;
            }
            case 2: {
                this.m_leftWallCollided = true;
                break;
            }
            case 4: {
                this.m_rightWallCollided = true;
            }
        }
    }

    public boolean isOnGround() {
        return this.m_isOnGround;
    }

    public boolean isNextToWall() {
        return false;
    }

    public void executeCueState() {
    }

    public void onAttackConnected(ICollidable iCollidable, int[] nArray) {
        this.m_attackConnected = true;
        this.m_attackConnectedTimer = this.m_stateTimer;
        if (this.m_fighterId == 0 && this.m_state == 26) {
            return;
        }
        if (!this.m_isOnGround) {
            this.m_resetTrajectory = true;
        }
    }

    public void executeQueueState() {
    }

    public int getX() {
        return this.m_physicsData[0] >> 8;
    }

    public int getY() {
        return this.m_physicsData[1] >> 8;
    }

    public boolean isLoaded() {
        return this.m_poolState == 2;
    }

    public byte[] getCommand(int n) {
        return ICommand.COMMON_COMMANDS[this.m_controlsType][n];
    }

    public SDKString getName() {
        return this.m_name;
    }

    public boolean canThrow() {
        return this.m_attackResetTimer > 200 && !this.hasRestrictedMovement() && (this.m_state == 0 || this.m_state == 1 || this.m_state == 2 || this.m_state == 16);
    }

    public boolean canBeThrown() {
        return this.m_antiThrowTimer > 200 && !this.hasRestrictedMovement() && this.m_state != 27 && this.m_state != 15;
    }

    public void updateAntiThrowTimer() {
        this.m_antiThrowTimer += GameImpl.s_elapsedTimeClamped;
        if (!this.m_isOnGround || this.m_state == 13 || this.m_state == 14) {
            this.m_antiThrowTimer = 0;
        }
    }

    public boolean isCloseToArenaBoundaries() {
        return this.getX() < Arena.s_currentArenaPhysicsBoundaryLeft + 36 && this.m_orientation == 1 || this.getX() > Arena.s_currentArenaPhysicsBoundaryRight - 36 && this.m_orientation == -1;
    }

    public void onProjectileHit() {
        short s = this.m_projectileData[0];
        if (s == 0) {
            if (this.m_state == 21) {
                this.initState(101);
                this.m_projectile.m_victim.initState(102);
            }
        } else if (s == 1) {
            if (this.m_projectile.m_victim.m_state == 23) {
                this.initState(23);
                this.m_projectile.m_victim.m_stateTimer = 3500;
            } else {
                if (this.m_state != 23) {
                    this.initState(0);
                }
                this.m_projectile.m_victim.initState(23);
            }
        } else if (s == 2) {
            this.m_projectile.m_victim.initState(27);
        }
    }

    public void onProjectileBlocked() {
    }

    public boolean skipCameraTracking() {
        return this.m_state == 26 && this.m_fighterId == 0 && !this.m_attackConnected || this.m_state == 26 && this.m_fighterId == 5;
    }

    public Fighter getOpponent() {
        return Battle.getFighterOpponent(this);
    }

    public void onFinishHimSequenceMissed() {
        if (this.m_state == 22) {
            this.initState(12);
            this.m_isTrajectoryLaunched = true;
        }
    }

    public static void cleanupFighters() {
        Fighter.releasePool();
    }

    public boolean hasRestrictedMovement() {
        return this.m_fighterId == 6;
    }

    public boolean skipAdjustments() {
        return !this.m_isOnGround || this.m_state == 12 || this.m_state == 9;
    }

    public void applyTrajectory(short[] sArray) {
        this.m_trajectoryFpWidth = this.m_orientation * -1 * sArray[0] << 8;
        this.m_trajectoryFpHeight = sArray[1] << 8;
        this.m_trajectoryDuration = sArray[2];
        this.m_isTrajectoryLaunched = false;
    }

    public boolean canPerformProjectile() {
        boolean bl;
        boolean bl2 = bl = this.getOpponent().m_state != 19 && (this.m_projectile == null || !this.m_projectile.isActive());
        if (this.m_fighterId == 0) {
            return bl && (Battle.s_battleState != 2 || this.getOpponent().m_state != 22);
        }
        return bl;
    }

    public boolean canPerformAirProjectile() {
        return this.m_airProjectileData != null && (this.m_state == 6 || this.m_state == 7 || this.m_state == 8 || this.m_state == 9 || this.m_state == 36 && this.m_previousState == 9);
    }

    public boolean canPerformSpecial() {
        if (this.m_fighterId == 0) {
            return this.m_timeSinceLastSpecialMove > 2000;
        }
        if (this.m_fighterId == 2) {
            return this.getOpponent().m_juggleCount <= 0;
        }
        return true;
    }

    public boolean isActive() {
        return this.m_poolState == 2;
    }

    public boolean doesImmediateDamageWithThrow() {
        return this.m_fighterId == 2 || this.m_fighterId == 5;
    }
}

