/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animation;
import com.ea.game.Arena;
import com.ea.game.Camera;
import com.ea.game.FileManager;
import com.ea.game.GameImpl;
import com.ea.game.IFighter;
import com.ea.game.Ingame;
import com.ea.game.InputManager;
import com.ea.game.Softkey;
import com.ea.game.Sound;
import com.ea.game.Tileset;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

public class Destiny {
    public static final int DEFAULT_DESTINY = 1;
    public static final int DESTINY_STATE_FAR = 0;
    private static final int DESTINY_STATE_FAR_SELECTED = 1;
    private static final int DESTINY_STATE_FAR_CENTERING = 2;
    private static final int DESTINY_STATE_FAR_GOINGDOWN = 3;
    public static final int DESTINY_STATE_NEAR = 4;
    private static final int DESTINY_STATE_NEAR_INITIAL = 5;
    private static int s_currentDestinyState;
    private static byte s_currentAcceptSoftkeyType;
    private static byte s_currentCancelSoftkeyType;
    static final int DESTINY_DATA_NAME = 0;
    static final int DESTINY_DATA_NUMBER = 1;
    static final int DESTINY_OPPONENT_ENDURANCE2 = -1;
    static final int DESTINY_OPPONENT_ENDURANCE3 = -2;
    private static int[][] s_currentDestinySetup;
    private static int[] s_smallPillarsHeight;
    private static int s_smallPillarsDistance;
    private static int[] s_smallPillarX;
    private static int s_smallPillarBottom;
    private static int s_highestSmallPillar;
    private static int[] s_largePillarsHeight;
    private static SDKString s_currentDestinyHeader;
    private static SDKString s_currentDestinyName;
    private static int s_currentSelectedDestiny;
    private static int s_destinyHeaderY;
    private static final int EMPTY_LARGE_BRICK = -1;
    private static int s_currentSmallPillarOffset;
    private static int s_smallPillarBeginningOffset;
    private static int s_smallPillarEndOffset;
    private static int s_currentPillarOffset;
    private static int s_currentSelectedOpponent;
    private static int s_initialAnimationBeginningOffset;
    private static int s_initialAnimationEndOffset;
    private static final int INITIAL_ANIMATION_DURATION = 700;
    private static final int INITIAL_ANIMATION_DELAY_DURATION = 500;
    private static final int INITIAL_ANIMATION_END_DELAY_DURATION = 1000;
    private static final int TRANSITION_ANIMATION_DURATION = 1000;
    private static final int TRANSITION_END_DELAY_DURATION = 1000;
    private static final int CENTERING_ANIMATION_DURATION = 1000;
    private static final int CENTERING_ANIMATION_TOTAL_DURATION = 1500;
    private static final int GOING_DOWN_ANIMATION_DURATION = 2000;
    private static int s_currentInitialAnimationDuration;
    private static int s_initialAnimationTimer;
    private static int s_initialAnimationDelayTimer;
    private static int s_initialAnimationEndDelayTimer;
    private static int s_transitionAnimationBeginningOffset;
    private static int s_transitionAnimationEndOffset;
    private static int s_transitionAnimationTimer;
    private static int s_centeringAnimationBeginningOffset;
    private static int s_centeringAnimationEndOffset;
    private static int s_centeringAnimationTimer;
    private static int s_goingDownAnimationTimer;
    private static int s_currentCenteringOffset;
    private static boolean[][] s_blinkingPillarData;
    private static int s_blinkingPillarTop;
    private static int s_blinkingPillarBottom;
    private static boolean s_isDestinyScreenOver;
    private static final int DESTINY_TILESET_HEADER = 0;
    private static final int DESTINY_TILESET_AVATARS = 1;
    private static final int DESTINY_TILESET_DRAGON = 2;
    private static final int DESTINY_TILESET_BRICKS = 3;
    private static final int DESTINY_TILESET_BRICKS_LIGHT = 4;
    private static final int DESTINY_TILESET_ENDURANCE2 = 5;
    private static final int DESTINY_TILESET_ENDURANCE3 = 6;
    private static final int[] DESTINY_TILESET;
    private static Tileset[] s_destinyTileset;
    private static final int DESTINY_ANIMATION_HEADER = 0;
    private static final int DESTINY_ANIMATION_AVATAR_DRAGON_GRAY = 1;
    private static final int DESTINY_ANIMATION_AVATAR_DRAGON_RANDOM = 2;
    private static final int DESTINY_ANIMATION_DRAGON = 3;
    private static final int DESTINY_ANIMATION_DRAGON_FAST = 4;
    private static final int DESTINY_ANIMATION_BRICK_LARGE_EMPTY = 5;
    private static final int DESTINY_ANIMATION_BRICK_LARGE_FULL = 6;
    private static final int DESTINY_ANIMATION_BRICK_SMALL_EMPTY = 7;
    private static final int DESTINY_ANIMATION_BRICK_SMALL_FULL = 8;
    private static final int DESTINY_ANIMATION_ENDURANCE2 = 9;
    private static final int DESTINY_ANIMATION_ENDURANCE3 = 10;
    private static final int[] DESTINY_ANIMATION;
    private static final int[] DESTINY_ANIMATION_TILESETS;
    private static final int TOUCH_PILLAR_COLOUR = 65535;
    private static Animation[] s_destinyAnimation;
    private static Animation[] s_avatarsAnimation;
    private static int s_avatarsSize;
    private static int[] s_avatarsAnimationInstance;
    private static int[] s_destinyAnimationWidth;
    private static int[] s_destinyAnimationHeight;
    private static int[] s_destinyAnimationInstance;
    private static int s_selectedFighterId;
    private static int s_currentDragonAnimation;
    private static boolean s_isDestinyStateSaved;

    public static boolean getDestinySaved() {
        return s_isDestinyStateSaved;
    }

    public static void setDestinySaved(boolean bl) {
        s_isDestinyStateSaved = bl;
        if (!bl) {
            s_currentSelectedOpponent = 0;
        }
    }

    public static void initDestiny() {
        GameImpl.loadFont((byte)1);
        Arena.initArena((byte)4, 1);
        Camera.initCamera();
        s_destinyHeaderY = 6;
        try {
            int n;
            s_destinyTileset = new Tileset[DESTINY_TILESET.length];
            for (n = 0; n < DESTINY_TILESET.length; ++n) {
                Destiny.s_destinyTileset[n] = n == 4 ? FileManager.createTileset(DESTINY_TILESET[n], (byte)2) : FileManager.createTileset(DESTINY_TILESET[n]);
            }
            s_destinyAnimation = new Animation[DESTINY_ANIMATION.length];
            s_destinyAnimationInstance = new int[DESTINY_ANIMATION.length];
            s_destinyAnimationWidth = new int[DESTINY_ANIMATION.length];
            s_destinyAnimationHeight = new int[DESTINY_ANIMATION.length];
            for (n = 0; n < DESTINY_ANIMATION.length; ++n) {
                Destiny.s_destinyAnimation[n] = Animation.loadAnimation(DESTINY_ANIMATION[n], 1);
                Destiny.s_destinyAnimationInstance[n] = 1;
                Destiny.s_destinyAnimationWidth[n] = s_destinyAnimation[n].computeGlobalWidth(s_destinyTileset[DESTINY_ANIMATION_TILESETS[n]]);
                Destiny.s_destinyAnimationHeight[n] = s_destinyAnimation[n].computeGlobalHeight(s_destinyTileset[DESTINY_ANIMATION_TILESETS[n]]);
            }
            s_avatarsAnimation = new Animation[IFighter.FIGHTERS_AVATARS_ANIMATIONS.length];
            s_avatarsAnimationInstance = new int[IFighter.FIGHTERS_AVATARS_ANIMATIONS.length];
            s_avatarsSize = s_destinyAnimationWidth[1];
            for (n = 0; n < IFighter.FIGHTERS_AVATARS_ANIMATIONS.length; ++n) {
                Destiny.s_avatarsAnimation[n] = Animation.loadAnimation(IFighter.FIGHTERS_AVATARS_ANIMATIONS[n], 1);
                Destiny.s_avatarsAnimationInstance[n] = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileManager.cleanup();
    }

    public static void setFighterId(int n) {
        s_selectedFighterId = n;
    }

    public static int getFighterId() {
        return s_selectedFighterId;
    }

    public static void cleanupDestiny() {
        s_destinyTileset = null;
        s_destinyAnimation = null;
        s_avatarsAnimation = null;
        GameImpl.cleanupFont((byte)1);
        Arena.cleanupArena();
    }

    public static int[][] getDestinySetup() {
        return s_currentDestinySetup;
    }

    public static void setDestinySetup(int[][] nArray) {
        s_currentDestinySetup = nArray;
    }

    public static void setupDestiny(int[][] nArray) {
        s_currentDestinySetup = nArray;
        s_smallPillarsHeight = new int[nArray.length];
        s_largePillarsHeight = new int[nArray.length];
        s_smallPillarX = new int[nArray.length];
        s_highestSmallPillar = 0;
        s_smallPillarsDistance = (GameImpl.s_ingameWidth - s_destinyAnimationWidth[8] * s_currentDestinySetup.length) / (s_currentDestinySetup.length + 1);
        for (int i = 0; i < nArray.length; ++i) {
            Destiny.s_smallPillarsHeight[i] = (nArray[i].length - 1) * s_destinyAnimationHeight[8];
            if (s_smallPillarsHeight[i] > s_highestSmallPillar) {
                s_highestSmallPillar = s_smallPillarsHeight[i];
            }
            Destiny.s_smallPillarX[i] = (i + 1) * s_smallPillarsDistance + i * s_destinyAnimationWidth[7];
            Destiny.s_largePillarsHeight[i] = (nArray[i].length - 1) * s_destinyAnimationHeight[6];
        }
        s_smallPillarBottom = Math.max(s_destinyAnimationHeight[0] + s_highestSmallPillar, GameImpl.s_ingameHeight - Arena.s_currentArenaBottom);
        s_currentSelectedDestiny = 1;
        Destiny.setCorrectDestinyName();
    }

    private static void setCorrectDestinyName() {
        s_currentDestinyName = SDKUtils.getString(s_currentDestinySetup[s_currentSelectedDestiny][0], null);
    }

    public static void initState(int n) {
        s_currentDestinyState = n;
        switch (s_currentDestinyState) {
            case 0: {
                s_currentAcceptSoftkeyType = (byte)3;
                s_currentCancelSoftkeyType = (byte)4;
                s_currentDestinyHeader = SDKUtils.getString(26, null);
                s_blinkingPillarData = new boolean[s_currentDestinySetup.length][1];
                for (int i = 0; i < s_currentDestinySetup.length; ++i) {
                    Destiny.s_blinkingPillarData[i] = new boolean[s_currentDestinySetup[i].length - 1 + 1];
                }
                s_currentCenteringOffset = 0;
                s_currentDragonAnimation = 3;
                s_currentSmallPillarOffset = 0;
                Sound.playSFX((byte)7);
                break;
            }
            case 1: {
                s_currentAcceptSoftkeyType = (byte)3;
                s_currentCancelSoftkeyType = 0;
                s_blinkingPillarTop = -1;
                s_blinkingPillarBottom = 0;
                s_currentDragonAnimation = 4;
                break;
            }
            case 2: {
                s_currentAcceptSoftkeyType = (byte)3;
                s_currentCancelSoftkeyType = 0;
                s_centeringAnimationBeginningOffset = 0;
                s_centeringAnimationEndOffset = (GameImpl.s_ingameWidth - s_destinyAnimationWidth[8]) / 2 - s_smallPillarX[s_currentSelectedDestiny];
                s_centeringAnimationTimer = 0;
                if (s_centeringAnimationEndOffset - s_centeringAnimationBeginningOffset == 0) {
                    s_centeringAnimationTimer = 1000;
                }
                s_currentCenteringOffset = s_centeringAnimationBeginningOffset;
                s_currentDragonAnimation = 4;
                break;
            }
            case 3: {
                s_goingDownAnimationTimer = 0;
                s_smallPillarBeginningOffset = 0;
                s_smallPillarEndOffset = s_highestSmallPillar + (GameImpl.s_ingameHeight - s_smallPillarBottom) + s_destinyAnimationHeight[8];
                break;
            }
            case 5: {
                s_currentAcceptSoftkeyType = (byte)3;
                s_currentCancelSoftkeyType = 0;
                s_currentDestinyHeader = SDKUtils.getString(s_currentDestinySetup[s_currentSelectedDestiny][0], null);
                s_currentSelectedOpponent = 0;
                Destiny.setNewSelectedOpponent(s_currentSelectedOpponent);
                s_initialAnimationBeginningOffset = GameImpl.s_ingameHeight / 2 + (s_currentDestinySetup[s_currentSelectedDestiny].length - 1) * s_destinyAnimationHeight[6];
                s_initialAnimationEndOffset = s_destinyAnimationHeight[6];
                s_currentPillarOffset = s_initialAnimationBeginningOffset;
                s_initialAnimationTimer = 0;
                s_currentInitialAnimationDuration = 700 * (s_currentDestinySetup[s_currentSelectedDestiny].length - 1);
                s_initialAnimationDelayTimer = 0;
                s_initialAnimationEndDelayTimer = 0;
                s_currentDragonAnimation = 3;
                break;
            }
            case 4: {
                Sound.playMusic((byte)5);
                s_currentAcceptSoftkeyType = (byte)3;
                s_currentCancelSoftkeyType = 0;
                s_currentDestinyHeader = SDKUtils.getString(s_currentDestinySetup[s_currentSelectedDestiny][0], null);
                Destiny.setNewSelectedOpponent(s_currentSelectedOpponent);
                s_currentDragonAnimation = 3;
            }
        }
        s_isDestinyScreenOver = false;
    }

    public static int getNumberOfFights() {
        return s_currentDestinySetup[s_currentSelectedDestiny].length - 1;
    }

    private static void drawDestinyHeader() {
        for (int i = 0; i <= GameImpl.s_screenWidth; i += s_destinyAnimationWidth[0]) {
            Destiny.drawDestinyAnimation(0, i, 0);
        }
        GameImpl.setFont((byte)4);
        SDKUtils.drawString(s_currentDestinyHeader, GameImpl.s_screenWidth / 2, s_destinyHeaderY, 17);
    }

    private static void drawDestinyAnimation(int n, int n2, int n3) {
        s_destinyAnimation[n].drawInstance(s_destinyAnimationInstance[n], s_destinyTileset[DESTINY_ANIMATION_TILESETS[n]], n2, n3, 0);
    }

    private static void drawCharacterAvatar(int n, int n2, int n3) {
        s_avatarsAnimation[n].drawInstance(s_avatarsAnimationInstance[n], s_destinyTileset[1], n2, n3, 0);
    }

    private static void drawEmptyLargeBrick(int n, int n2) {
        Destiny.drawDestinyAnimation(5, n, n2);
    }

    private static void drawFullLargeBrick(int n, int n2, int n3) {
        Destiny.drawDestinyAnimation(6, n2, n3);
        switch (n) {
            case -1: {
                Destiny.drawDestinyAnimation(9, n2 + 56, n3 + 10);
                break;
            }
            case -2: {
                Destiny.drawDestinyAnimation(10, n2 + 56, n3 + 10);
                break;
            }
            default: {
                Destiny.drawCharacterAvatar(n, n2 + 56, n3 + 10);
            }
        }
    }

    private static void drawLargePillar(int[] nArray, int n, int n2, int n3, boolean bl) {
        int n4 = (GameImpl.s_ingameWidth - s_destinyAnimationWidth[5]) / 2;
        int n5 = GameImpl.s_ingameHeight - s_destinyAnimationHeight[6];
        if (bl) {
            n5 += n3 % s_destinyAnimationHeight[5];
        }
        int n6 = (GameImpl.s_ingameHeight - s_destinyAnimationHeight[0]) / s_destinyAnimationHeight[5] + 1;
        int n7 = n2 - n6 / 2;
        if (bl) {
            n7 += n3 / s_destinyAnimationHeight[5];
        }
        int n8 = n7 + n6;
        for (int i = n7; i <= n8; ++i) {
            if (i == -1) {
                Destiny.drawEmptyLargeBrick(n4 + GameImpl.s_ingameLeft, n5 + GameImpl.s_ingameTop);
            } else if (i >= -1 && i < nArray.length - 1) {
                Destiny.drawFullLargeBrick(nArray[i + 1], n4 + GameImpl.s_ingameLeft, n5 + GameImpl.s_ingameTop);
                if (i == n2) {
                    Destiny.drawCharacterAvatar(n, n4 + s_destinyAnimationWidth[6] - 56 - s_avatarsSize + GameImpl.s_ingameLeft, n5 + 10 + (!bl ? n3 : 0) + GameImpl.s_ingameTop);
                }
            }
            n5 -= s_destinyAnimationHeight[6];
        }
    }

    private static void drawSmallPillar(int[] nArray, int n, int n2, boolean[] blArray) {
        int n3 = s_smallPillarBottom - s_destinyAnimationHeight[8] + n2;
        if (blArray[0]) {
            s_destinyAnimation[7].drawInstance(s_destinyAnimationInstance[7], s_destinyTileset[4], n, n3, 0);
        } else {
            s_destinyAnimation[7].drawInstance(s_destinyAnimationInstance[7], s_destinyTileset[3], n, n3, 0);
        }
        for (int i = 0; i < nArray.length - 1; ++i) {
            n3 -= s_destinyAnimationHeight[8];
            if (blArray[i + 1]) {
                s_destinyAnimation[8].drawInstance(s_destinyAnimationInstance[8], s_destinyTileset[4], n, n3, 0);
                continue;
            }
            s_destinyAnimation[8].drawInstance(s_destinyAnimationInstance[8], s_destinyTileset[3], n, n3, 0);
        }
    }

    private static void drawSmallPillars(int n) {
        for (int i = 0; i < s_currentDestinySetup.length; ++i) {
            Destiny.drawSmallPillar(s_currentDestinySetup[i], s_smallPillarX[i] + s_currentCenteringOffset + GameImpl.s_ingameLeft, n + GameImpl.s_ingameTop, s_blinkingPillarData[i]);
        }
    }

    private static void drawSmallPillarSelection(int n) {
        Destiny.drawDestinyAnimation(s_currentDragonAnimation, s_smallPillarX[s_currentSelectedDestiny] + s_currentCenteringOffset + s_destinyAnimationWidth[7] / 2 - s_destinyAnimationWidth[3] / 2 + GameImpl.s_ingameLeft, s_smallPillarBottom - s_destinyAnimationHeight[7] / 2 - SDKUtils.getLineSize() / 2 - s_destinyAnimationHeight[3] + n + GameImpl.s_ingameTop);
        GameImpl.setFont((byte)1);
        SDKUtils.drawString(s_currentDestinyName, s_smallPillarX[s_currentSelectedDestiny] + s_currentCenteringOffset + s_destinyAnimationWidth[7] / 2 + GameImpl.s_ingameLeft, s_smallPillarBottom - s_destinyAnimationHeight[7] / 2 - SDKUtils.getLineSize() / 2 + n + GameImpl.s_ingameTop, 17);
    }

    public static void setNewSelectedOpponent(int n) {
        s_currentSelectedOpponent = n;
        if (s_currentSelectedOpponent >= s_currentDestinySetup[s_currentSelectedDestiny].length - 1) {
            s_currentSelectedOpponent = s_currentDestinySetup[s_currentSelectedDestiny].length - 1 - 1;
        }
        if (s_currentSelectedOpponent < 0) {
            s_currentSelectedOpponent = 0;
        }
        if (s_currentSelectedOpponent > 0) {
            s_transitionAnimationTimer = 0;
            s_transitionAnimationBeginningOffset = s_destinyAnimationHeight[6];
            s_transitionAnimationEndOffset = 0;
            s_currentPillarOffset = s_transitionAnimationBeginningOffset;
        } else {
            s_transitionAnimationTimer = 1000;
            s_transitionAnimationBeginningOffset = 0;
            s_transitionAnimationEndOffset = 0;
            s_currentPillarOffset = 0;
        }
    }

    public static boolean isOpponentEndurance2() {
        return s_currentDestinySetup[s_currentSelectedDestiny][s_currentSelectedOpponent + 1] == -1;
    }

    public static boolean isOpponentEndurance3() {
        return s_currentDestinySetup[s_currentSelectedDestiny][s_currentSelectedOpponent + 1] == -2;
    }

    public static boolean isOpponentStandard() {
        return s_currentDestinySetup[s_currentSelectedDestiny][s_currentSelectedOpponent + 1] >= 0;
    }

    public static int getSelectedOpponentFighterId() {
        return s_currentDestinySetup[s_currentSelectedDestiny][s_currentSelectedOpponent + 1];
    }

    public static int getSelectedBrick() {
        return s_currentSelectedOpponent;
    }

    public static void setSelectedBrick(int n) {
        s_currentSelectedOpponent = n;
    }

    public static boolean isDestinyOver() {
        return s_isDestinyScreenOver;
    }

    public static int getSelectedDestiny() {
        return s_currentSelectedDestiny;
    }

    public static void setSelectedDestiny(int n) {
        s_currentSelectedDestiny = n;
    }

    private static void updateTouchpad() {
    }

    public static void updateDestiny() {
        int n;
        Destiny.updateTouchpad();
        for (n = 0; n < DESTINY_ANIMATION.length; ++n) {
            Destiny.s_destinyAnimationInstance[n] = s_destinyAnimation[n].updateInstance(s_destinyAnimationInstance[n], GameImpl.s_elapsedTimeClamped);
        }
        Arena.updateArena();
        Camera.setCamera(0, 0, true);
        Camera.updateCamera();
        switch (s_currentDestinyState) {
            case 0: {
                if (InputManager.s_isKeyLeftPressed) {
                    if (--s_currentSelectedDestiny < 0) {
                        s_currentSelectedDestiny = s_currentDestinySetup.length - 1;
                    }
                    Destiny.setCorrectDestinyName();
                    Sound.playSFX((byte)37);
                }
                if (InputManager.s_isKeyRightPressed) {
                    if (++s_currentSelectedDestiny >= s_currentDestinySetup.length) {
                        s_currentSelectedDestiny = 0;
                    }
                    Destiny.setCorrectDestinyName();
                    Sound.playSFX((byte)37);
                }
                if (InputManager.s_isKeyCenterPressed || InputManager.s_isKeyAcceptPressed) {
                    Sound.playSFX((byte)38);
                    Destiny.initState(1);
                }
                if (!InputManager.s_isKeyCancelPressed) break;
                Ingame.ingameInitState(1);
                break;
            }
            case 1: {
                if (++s_blinkingPillarTop >= s_blinkingPillarData[s_currentSelectedDestiny].length) {
                    s_blinkingPillarTop = s_blinkingPillarData[s_currentSelectedDestiny].length - 1;
                    if (++s_blinkingPillarBottom > s_blinkingPillarData[s_currentSelectedDestiny].length) {
                        Destiny.s_blinkingPillarData[Destiny.s_currentSelectedDestiny] = new boolean[s_currentDestinySetup[s_currentSelectedDestiny].length - 1 + 1];
                        Destiny.initState(2);
                        return;
                    }
                }
                for (n = 0; n < s_blinkingPillarData[s_currentSelectedDestiny].length; ++n) {
                    Destiny.s_blinkingPillarData[Destiny.s_currentSelectedDestiny][n] = n >= s_blinkingPillarBottom && n <= s_blinkingPillarTop;
                }
                if (!InputManager.s_isKeyAcceptPressed && !InputManager.s_isKeyCenterPressed) break;
                Destiny.endDestinyScreen();
                break;
            }
            case 2: {
                if ((s_centeringAnimationTimer += GameImpl.s_elapsedTimeClamped) <= 1000) {
                    s_currentCenteringOffset = s_centeringAnimationBeginningOffset + s_centeringAnimationTimer * (s_centeringAnimationEndOffset - s_centeringAnimationBeginningOffset) / 1000;
                } else if (s_centeringAnimationTimer >= 1500) {
                    Destiny.initState(3);
                }
                if (InputManager.s_isKeyAcceptPressed || InputManager.s_isKeyCenterPressed) {
                    Destiny.endDestinyScreen();
                }
                return;
            }
            case 3: {
                if ((s_goingDownAnimationTimer += GameImpl.s_elapsedTimeClamped) > 2000) {
                    Destiny.initState(5);
                } else {
                    s_currentSmallPillarOffset = s_smallPillarBeginningOffset + s_goingDownAnimationTimer * (s_smallPillarEndOffset - s_smallPillarBeginningOffset) / 2000;
                }
                if (!InputManager.s_isKeyAcceptPressed && !InputManager.s_isKeyCenterPressed) break;
                Destiny.endDestinyScreen();
                break;
            }
            case 5: {
                if ((s_initialAnimationDelayTimer += GameImpl.s_elapsedTimeClamped) > 500) {
                    s_currentPillarOffset = s_initialAnimationBeginningOffset + (s_initialAnimationTimer += GameImpl.s_elapsedTimeClamped) * (s_initialAnimationEndOffset - s_initialAnimationBeginningOffset) / s_currentInitialAnimationDuration;
                    if (s_initialAnimationTimer >= s_currentInitialAnimationDuration) {
                        s_currentPillarOffset = s_initialAnimationEndOffset;
                        if ((s_initialAnimationEndDelayTimer += GameImpl.s_elapsedTimeClamped) > 1000) {
                            Destiny.endDestinyScreen();
                        }
                    }
                }
                if (!InputManager.s_isKeyAcceptPressed && !InputManager.s_isKeyCenterPressed) break;
                Destiny.endDestinyScreen();
                break;
            }
            case 4: {
                if ((s_transitionAnimationTimer += GameImpl.s_elapsedTimeClamped) >= 1000) {
                    s_currentPillarOffset = s_transitionAnimationEndOffset;
                    if (s_transitionAnimationTimer >= 2000) {
                        Destiny.endDestinyScreen();
                    }
                } else {
                    s_currentPillarOffset = s_transitionAnimationBeginningOffset + s_transitionAnimationTimer * (s_transitionAnimationEndOffset - s_transitionAnimationBeginningOffset) / 1000;
                }
                if (!InputManager.s_isKeyAcceptPressed && !InputManager.s_isKeyCenterPressed) break;
                Destiny.endDestinyScreen();
            }
        }
        Softkey.setSoftkeys(s_currentAcceptSoftkeyType, s_currentCancelSoftkeyType);
    }

    private static void endDestinyScreen() {
        s_isDestinyScreenOver = true;
        Sound.stopSound();
    }

    public static void drawDestiny() {
        GameImpl.setIngameClip();
        Arena.drawArena();
        switch (s_currentDestinyState) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                Destiny.drawSmallPillars(s_currentSmallPillarOffset);
                Destiny.drawSmallPillarSelection(s_currentSmallPillarOffset);
                break;
            }
            case 5: {
                Destiny.drawLargePillar(s_currentDestinySetup[s_currentSelectedDestiny], s_selectedFighterId, s_currentSelectedOpponent, s_currentPillarOffset, true);
                break;
            }
            case 4: {
                Destiny.drawLargePillar(s_currentDestinySetup[s_currentSelectedDestiny], s_selectedFighterId, s_currentSelectedOpponent, s_currentPillarOffset, false);
            }
        }
        GameImpl.setFullClip();
        Destiny.drawDestinyHeader();
    }

    static {
        DESTINY_TILESET = new int[]{167772275, 0xA000070, 167772278, 167772276, 167772276, 167772270, 167772271};
        DESTINY_ANIMATION = new int[]{167772189, 0xA000007, 0xA000007, 167772179, 167772180, 167772182, 167772183, 167772190, 167772191, 0xA000000, 0xA000001};
        DESTINY_ANIMATION_TILESETS = new int[]{0, 1, 1, 2, 2, 3, 3, 3, 3, 5, 6};
    }
}

