/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.FileManager;
import com.ea.game.GameImpl;
import com.ea.game.ITransformations;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKUtils;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class Tileset {
    private static final int[] TILESET_TO_MIDP_TRANSFORMATION_TABLE = new int[]{0, 6, 3, 5, 2, 4, 1, 7};
    private static final int[] MIDP_TO_TILESET_TRANSFORMATION_TABLE = new int[]{0, 6, 4, 2, 5, 3, 1, 7};
    private byte[] m_imageDataArray;
    private byte[][] m_imagePaletteArray;
    private boolean m_isDynamicPaletteSwapping;
    private SDKImage[] m_image;
    private int[] m_imagePalette;
    private byte[] m_imageEffect;
    private int m_currentImage;
    private int m_baseImageId;
    private Image m_originalImage;
    private static final int ROTATED_CACHE_MAXIMUM_SIZE = 400;
    private short m_rotatedImagesNumber;
    private SDKImage[] m_rotatedImage;
    private static final int NUMBER_OF_TRANSFORMS = 8;
    private short m_realTilesNumber;
    private boolean[][][] m_isTileInCache;
    private short[][][] m_tileCacheIndex;
    private static final int MISSING_CACHED_IMAGE = -1;
    private int[] m_midpTransMap;
    private byte[] m_indexMap;
    private int m_numTiles;
    private boolean m_isPretransformed;
    private int m_numberOfAlternativeImages;
    private long[] m_rectsLong;

    public static Tileset createTileset(int n, long[] lArray, byte[] byArray, byte[] byArray2, int[] nArray, byte[] byArray3, boolean bl, boolean bl2) throws IOException {
        int n2;
        Tileset tileset = new Tileset();
        tileset.m_numberOfAlternativeImages = nArray.length;
        tileset.m_isPretransformed = bl2;
        tileset.m_image = new SDKImage[tileset.m_numberOfAlternativeImages];
        tileset.m_imagePalette = nArray;
        tileset.m_imageEffect = byArray3;
        tileset.m_currentImage = 0;
        if (!tileset.m_isPretransformed) {
            tileset.m_image[tileset.m_currentImage] = FileManager.createSDKImage(n, nArray[tileset.m_currentImage], byArray3[tileset.m_currentImage]);
        }
        tileset.m_isDynamicPaletteSwapping = bl;
        if (tileset.m_isPretransformed) {
            tileset.m_isDynamicPaletteSwapping = false;
        }
        if (tileset.m_isDynamicPaletteSwapping && tileset.m_numberOfAlternativeImages > 1) {
            tileset.m_imageDataArray = new byte[FileManager.s_lastImageLength];
            System.arraycopy(FileManager.s_volumeBufferArray[FileManager.s_lastVolumeId], FileManager.s_lastImageStart, tileset.m_imageDataArray, 0, FileManager.s_lastImageLength);
            tileset.m_imagePaletteArray = new byte[tileset.m_numberOfAlternativeImages][0];
            if (FileManager.s_lastUsedPalette != null) {
                tileset.m_imagePaletteArray[tileset.m_currentImage] = new byte[FileManager.s_lastUsedPalette.length];
                for (n2 = 0; n2 < FileManager.s_lastUsedPalette.length; ++n2) {
                    tileset.m_imagePaletteArray[tileset.m_currentImage][n2] = FileManager.s_lastUsedPalette[n2];
                }
            } else {
                tileset.m_imagePaletteArray[tileset.m_currentImage] = FileManager.getPaletteData(tileset.m_imageDataArray, 0, FileManager.s_lastImageLength);
            }
        }
        tileset.m_indexMap = byArray;
        tileset.m_numTiles = byArray.length;
        tileset.m_rectsLong = lArray;
        tileset.m_midpTransMap = new int[byArray2.length];
        tileset.m_baseImageId = n;
        if (tileset.m_isPretransformed) {
            tileset.m_realTilesNumber = 0;
            for (n2 = 0; n2 < byArray.length; ++n2) {
                if ((byArray[n2] & 0xFF) <= tileset.m_realTilesNumber) continue;
                tileset.m_realTilesNumber = (short)(byArray[n2] & 0xFF);
            }
            tileset.m_realTilesNumber = (short)(tileset.m_realTilesNumber + 1);
            if (tileset.m_realTilesNumber > 1) {
                n2 = tileset.m_realTilesNumber * 7;
                if (n2 > 400) {
                    n2 = 400;
                }
                tileset.m_rotatedImage = new SDKImage[n2];
                tileset.m_isTileInCache = new boolean[tileset.m_realTilesNumber][8][tileset.m_numberOfAlternativeImages];
                tileset.m_tileCacheIndex = new short[tileset.m_realTilesNumber][8][tileset.m_numberOfAlternativeImages];
            } else {
                tileset.m_isPretransformed = false;
                tileset.m_image[tileset.m_currentImage] = FileManager.createSDKImage(n, nArray[tileset.m_currentImage], byArray3[tileset.m_currentImage]);
            }
        }
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            tileset.m_midpTransMap[n2] = TILESET_TO_MIDP_TRANSFORMATION_TABLE[byArray2[n2]];
        }
        if (tileset.m_isPretransformed) {
            for (n2 = 0; n2 < tileset.m_numberOfAlternativeImages; ++n2) {
                tileset.m_originalImage = FileManager.createImage(n, tileset.m_imagePalette[n2], tileset.m_imageEffect[n2]);
                for (int i = 0; i < tileset.m_numTiles; ++i) {
                    tileset.addImageToCache(tileset.m_indexMap[i] & 0xFF, tileset.m_midpTransMap[i], n2);
                }
            }
            tileset.m_originalImage = null;
        } else {
            for (n2 = 1; n2 < tileset.m_numberOfAlternativeImages; ++n2) {
                tileset.loadNewImage(n2, tileset.m_imagePalette[n2], tileset.m_imageEffect[n2]);
            }
        }
        return tileset;
    }

    private void loadNewImage(int n, int n2, byte by) throws IOException {
        this.m_imagePalette[n] = n2;
        this.m_imageEffect[n] = by;
        if (this.m_isDynamicPaletteSwapping) {
            if (n2 != -1) {
                this.m_imagePaletteArray[n] = FileManager.readResourcePalette(n2);
            } else {
                this.m_imagePaletteArray[n] = new byte[this.m_imagePaletteArray[0].length];
                System.arraycopy(this.m_imagePaletteArray[0], 0, this.m_imagePaletteArray[n], 0, this.m_imagePaletteArray[0].length);
            }
            if (by != 0) {
                FileManager.applyPaletteEffect(this.m_imagePaletteArray[n], by);
            }
        } else if (!this.m_isPretransformed) {
            this.m_image[n] = FileManager.createSDKImage(this.m_baseImageId, n2, by);
        }
    }

    public int getImagePalette(int n) {
        return this.m_imagePalette[n];
    }

    public int getImageEffect(int n) {
        return this.m_imageEffect[n];
    }

    public void setCurrentImageSlot(int n) {
        if (n == this.m_currentImage || n > this.m_image.length) {
            return;
        }
        if (this.m_isDynamicPaletteSwapping) {
            this.m_image[this.m_currentImage] = null;
            this.m_currentImage = n;
            if (this.m_image[this.m_currentImage] == null) {
                FileManager.changePalette(this.m_imageDataArray, 0, this.m_imageDataArray.length, this.m_imagePaletteArray[this.m_currentImage]);
                this.m_image[this.m_currentImage] = SDKUtils.createImage(this.m_imageDataArray, 0, this.m_imageDataArray.length);
            }
        } else if (this.m_image[n] != null || this.m_isPretransformed) {
            this.m_currentImage = n;
        }
    }

    public int getCurrentImageSlot() {
        return this.m_currentImage;
    }

    private SDKImage getCurrentSDKImage() {
        return this.m_image[this.m_currentImage];
    }

    public int getNbTiles() {
        return this.m_numTiles;
    }

    public int getTileWidth(int n) {
        long l = this.m_rectsLong[this.m_indexMap[n] & 0xFF];
        if ((this.m_midpTransMap[n] & 4) != 0) {
            return (int)(l & 0xFFFFL);
        }
        int n2 = (int)(l >>> 16 & 0xFFFFL);
        return n2;
    }

    public int getTileHeight(int n) {
        long l = this.m_rectsLong[this.m_indexMap[n] & 0xFF];
        if ((this.m_midpTransMap[n] & 4) != 0) {
            return (int)(l >>> 16 & 0xFFFFL);
        }
        int n2 = (int)(l & 0xFFFFL);
        return n2;
    }

    public void drawTile(int n, int n2, int n3) {
        if (this.m_isPretransformed) {
            this.displayCachedImage(this.checkCacheForImage(this.m_indexMap[n] & 0xFF, this.m_midpTransMap[n], this.m_currentImage), n2, n3);
        } else {
            long l = this.m_rectsLong[this.m_indexMap[n] & 0xFF];
            int n4 = (int)l & 0xFFFF;
            int n5 = (int)(l >>> 16 & 0xFFFFL);
            int n6 = (int)(l >>> 32 & 0xFFFFL);
            int n7 = (int)(l >>> 48 & 0xFFFFL);
            GameImpl.s_currentGraphics.drawRegion(this.getCurrentSDKImage(), n7, n6, n5, n4, this.m_midpTransMap[n], n2, n3, 20);
        }
    }

    public int getTileWidth(int n, int n2) {
        if ((n2 & 1) != 0) {
            return this.getTileHeight(n);
        }
        return this.getTileWidth(n);
    }

    public int getTileHeight(int n, int n2) {
        if ((n2 & 1) != 0) {
            return this.getTileWidth(n);
        }
        return this.getTileHeight(n);
    }

    public short checkCacheForImage(int n, int n2, int n3) {
        short s = -1;
        if (this.m_isTileInCache[n][n2][n3]) {
            s = this.m_tileCacheIndex[n][n2][n3];
        }
        return s;
    }

    public short addImageToCache(int n, int n2, int n3) {
        long l = this.m_rectsLong[n];
        int n4 = (int)l & 0xFFFF;
        int n5 = (int)(l >>> 16 & 0xFFFFL);
        int n6 = (int)(l >>> 32 & 0xFFFFL);
        int n7 = (int)(l >>> 48 & 0xFFFFL);
        if (this.m_rotatedImagesNumber >= 400) {
            this.m_rotatedImagesNumber = 0;
        }
        this.m_rotatedImage[this.m_rotatedImagesNumber] = FileManager.createSDKImageFromImage(this.m_originalImage, n7, n6, n5, n4, n2);
        this.m_isTileInCache[n][n2][n3] = true;
        this.m_tileCacheIndex[n][n2][n3] = this.m_rotatedImagesNumber;
        this.m_rotatedImagesNumber = (short)(this.m_rotatedImagesNumber + 1);
        return this.m_tileCacheIndex[n][n2][n3];
    }

    public void displayCachedImage(short s, int n, int n2) {
        if (s != -1) {
            GameImpl.s_currentGraphics.drawImage(this.m_rotatedImage[s], n, n2, 20);
        }
    }

    public void drawTile(int n, int n2, int n3, int n4) {
        int n5 = MIDP_TO_TILESET_TRANSFORMATION_TABLE[this.m_midpTransMap[n]];
        int n6 = ITransformations.TRANSFORMATION_TABLE[(n2 << 3) + n5];
        if (this.m_isPretransformed) {
            this.displayCachedImage(this.checkCacheForImage(this.m_indexMap[n] & 0xFF, TILESET_TO_MIDP_TRANSFORMATION_TABLE[n6], this.m_currentImage), n3, n4);
        } else {
            long l = this.m_rectsLong[this.m_indexMap[n] & 0xFF];
            int n7 = (int)l & 0xFFFF;
            int n8 = (int)(l >>> 16 & 0xFFFFL);
            int n9 = (int)(l >>> 32 & 0xFFFFL);
            int n10 = (int)(l >>> 48 & 0xFFFFL);
            GameImpl.s_currentGraphics.drawRegion(this.getCurrentSDKImage(), n10, n9, n8, n7, TILESET_TO_MIDP_TRANSFORMATION_TABLE[n6], n3, n4, 20);
        }
    }
}

