/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animation;
import com.ea.game.Arena;
import com.ea.game.Camera;
import com.ea.game.Destiny;
import com.ea.game.Fighter;
import com.ea.game.FileManager;
import com.ea.game.GameImpl;
import com.ea.game.Hud;
import com.ea.game.IArena;
import com.ea.game.ICommand;
import com.ea.game.IFighter;
import com.ea.game.Ingame;
import com.ea.game.InputManager;
import com.ea.game.Menu;
import com.ea.game.Particle;
import com.ea.game.Physics;
import com.ea.game.Projectile;
import com.ea.game.Rms;
import com.ea.game.Softkey;
import com.ea.game.Sound;
import com.ea.game.Special;
import com.ea.game.Tileset;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

public class Battle {
    public static int s_battleState;
    public static int s_battleStateTimer;
    public static int s_battleLoadingState;
    public static int s_battleLoadingStateTimer;
    public static int s_battleLoadingStep;
    public static final int BATTLE_LOADING_STEP_MISC = 0;
    public static final int BATTLE_LOADING_STEP_FIGHTER_1 = 1;
    public static final int BATTLE_LOADING_STEP_FIGHTER_2 = 5;
    public static final int BATTLE_LOADING_STEP_ARENA = 9;
    public static final int BATTLE_LOADING_STEP_SOUND01 = 10;
    public static final int BATTLE_LOADING_STEP_SOUND02 = 11;
    public static final int BATTLE_LOADING_STEP_SOUND03 = 12;
    public static final int BATTLE_LOADING_STEP_SOUND04 = 13;
    public static final int BATTLE_LOADING_STEP_SOUND05 = 14;
    public static final int BATTLE_LOADING_STEP_SOUND06 = 15;
    public static final int BATTLE_LOADING_STEP_SOUND07 = 16;
    public static final int BATTLE_LOADING_STEP_SOUND08 = 17;
    public static final int BATTLE_LOADING_STEP_SOUND09 = 18;
    public static final int BATTLE_LOADING_STEP_SOUND10 = 19;
    public static final int BATTLE_LOADING_STEP_SOUND11 = 20;
    public static final int BATTLE_LOADING_STEP_FX = 21;
    public static final int BATTLE_LOADING_STEP_HUD = 22;
    public static final int BATTLE_LOADING_STEP_FIGHTERS_FX = 23;
    public static final int BATTLE_LOADING_STEPS_COUNT = 24;
    static byte s_battleArenaId;
    static int s_battleFighter1Id;
    static int s_battleFighter2Id;
    static Fighter s_battleFighter1;
    static Fighter s_battleFighter2;
    private static Fighter s_lastActiveFighter;
    private static int s_battleTimer;
    private static int s_battleCurrentRound;
    private static int s_battleFighter1RoundsWon;
    private static int s_battleFighter2RoundsWon;
    private static Fighter s_battleAttackedFighter;
    public static final int BATTLE_LOADING_STATE_INACTIVE = 0;
    public static final int BATTLE_LOADING_STATE_IN_PROGRESS = 1;
    public static final int BATTLE_LOADING_STATE_READY = 2;
    public static final int BATTLE_LOADING_STATE_CLEANING_UP = 3;
    private static final int BATTLE_FIGHTER_START_POS_X = -48;
    private static final int BATTLE_FIGHTER_START_POS_Y = 0;
    private static final int BATTLE_TOTAL_TIMER = 99;
    public static boolean s_battleCameraAutomatic;
    public static boolean s_battleEnded;
    private static boolean s_battlePaused;
    private static byte s_currentAcceptSoftkeyType;
    private static byte s_currentCancelSoftkeyType;
    private static SDKString s_roundXBaseString;
    private static SDKString s_xWinsBaseString;
    private static SDKString s_enduranceRoundString;
    public static final int BATTLE_STATE_NEXT_ROUND = 0;
    public static final int BATTLE_STATE_MSG_FIGHT = 1;
    public static final int BATTLE_STATE_IN_FIGHT = 2;
    public static final int BATTLE_STATE_FINISH = 3;
    public static final int BATTLE_STATE_IN_FINISHER = 4;
    public static final int BATTLE_STATE_SHAO_KAHN_DEATH = 5;
    public static final int BATTLE_STATE_ROUND_END_WINS_PART1 = 6;
    public static final int BATTLE_STATE_ROUND_END_WINS_PART2 = 7;
    public static final int BATTLE_STATE_ROUND_END_SCORE = 8;
    public static final int BATTLE_STATE_ROUND_END_FATALITY = 9;
    public static final int BATTLE_STATE_ROUND_END_BABALITY = 10;
    public static final int BATTLE_STATE_TIME_OVER = 11;
    public static final int BATTLE_STATE_DRAW_GAME = 12;
    public static final int BATTLE_STATE_NEXT_ENDURANCE_FIGHTER = 13;
    public static final int BATTLE_STATE_CONTINUE_YES_NO = 14;
    public static final int BATTLE_STATE_END = 15;
    private static final int ROUNDS_TO_WIN = 2;
    private static final int BATTLE_BLACK_SCREEN_TIMER = 300;
    private static final int BATTLE_TIMER_FATALITY = 3500;
    private static final int COMBO_MINIMUM_HITS_NUMBER = 2;
    private static final int BATTLE_MSG_ROUND_X_DURATION = 2500;
    private static final int BATTLE_MSG_FIGHT_DURATION = 1500;
    private static final int BATTLE_END_WINS_PART1_DURATION = 1500;
    private static final int BATTLE_END_WINS_PART2_DURATION = 1000;
    private static final int BATTLE_END_WINS_FATALITY_DURATION = 3500;
    private static final int BATTLE_END_WINS_BABALITY_DURATION = 3500;
    private static final int BATTLE_END_SCORE_DURATION = 2000;
    private static final int PAUSE_MENU_TEXT_LINES_COUNT = 11;
    private static Tileset s_fatalityTileset;
    private static Animation s_fatalityAnimation;
    private static Tileset s_babalityTileset;
    private static Animation s_babalityAnimation;
    private static int s_fatalityAnimationHeight;
    private static int s_fatalityAnimationInstance;
    private static int s_babalityAnimationInstance;
    private static boolean s_battleFighter1BackToBlockable;
    private static boolean s_battleFighter2BackToBlockable;
    private static boolean s_wasFirstRoundFlawless;
    private static int s_lastTimeBonus;
    private static int s_lastLifeBonus;
    private static final int MAXIMUM_BONUS_VALUE_STRING_SIZE = 6;
    private static SDKString s_nextRoundString;
    private static SDKString s_timeOverString;
    private static SDKString s_drawGameString;
    private static SDKString s_fightString;
    private static SDKString s_battleEndString;
    private static SDKString s_lifeScoreString;
    private static SDKString s_lifeScoreValue;
    private static SDKString s_timeScoreString;
    private static SDKString s_timeScoreValue;
    private static SDKString s_finishString;
    private static SDKString s_fatalityScoreValue;
    private static SDKString s_fatalityString;
    private static SDKString s_babalityString;
    private static SDKString s_babalityScoreValue;
    private static int s_finisherType;
    public static final int FINISHER_NONE = 0;
    public static final int FINISHER_FATALITY = 1;
    public static final int FINISHER_BABALITY = 2;
    public static int s_enduranceFightersDefeated;
    private static int s_deathAnimationStep;
    private static boolean s_isWhiteBackground;
    private static int s_deathAnimationTimer;
    private static Tileset s_deathTileset;
    private static Animation s_deathAnimation;
    private static int s_deathAnimationInstance;
    private static Animation s_skDefeatAnimation;
    private static int s_skDefeatAnimationInstance;
    private static final int SHAO_KAHN_WAIVING_HANDS_DURATION = 2000;
    private static final int SHAO_KAHN_WHITE_SCREEN_DURATION = 500;
    private static final int SHAO_KAHN_EXPLODED_WHITE_SCREEN_DURATION = 1000;
    private static final int SHAO_KAHN_WHITE_SCREEN_BLINKING_DURATION = 1000;
    private static final int SHAO_KAHN_WHITE_SCREEN_EXPLOSION_DURATION = 1000;
    private static final int SHAO_KAHN_WINS_SCREEN_DURATION = 1000;
    private static final int SHAO_KAHN_NO_MORE_SCREEN_DURATION = 1000;
    private static final int SHAO_KAHN_CHAMPION_SCREEN_DURATION = 3000;
    private static final int SHAO_KAHN_DEATH_STEP_0_START = 0;
    private static final int SHAO_KAHN_DEATH_STEP_1_CENTER = 1;
    private static final int SHAO_KAHN_DEATH_STEP_2_WAIVE_HANDS = 2;
    private static final int SHAO_KAHN_DEATH_STEP_3_RAISE_HANDS = 3;
    private static final int SHAO_KAHN_DEATH_STEP_4_EXPLODE_PART1 = 4;
    private static final int SHAO_KAHN_DEATH_STEP_5_EXPLODE_PART2 = 5;
    private static final int SHAO_KAHN_DEATH_STEP_6_EXPLODE_PART3 = 6;
    private static final int SHAO_KAHN_DEATH_STEP_7_WHITE = 7;
    private static final int SHAO_KAHN_DEATH_STEP_8_WINS = 8;
    private static final int SHAO_KAHN_DEATH_STEP_9_NO_MORE = 9;
    private static final int SHAO_KAHN_DEATH_STEP_10_CHAMPION = 10;
    private static final int TIMER_ENDURANCE_FIGHT_TRANSITION = 0;
    private static final int BABALITY_GRAPHIC_MARGIN_TOP = 30;
    private static final int BABALITY_GRAPHIC_MARGIN_BOTTOM = 18;
    private static SDKString s_nomoreString;
    private static short[] s_nomoreStringData;
    private static SDKString s_championString;
    private static short[] s_championStringData;
    private static final int PRACTICE_MODE_HEAL_DELAY = 3500;
    private static final int FINISH_TIMER_MULTIPLIER_EASY = 2;
    private static final int FINISH_TIMER_MULTIPLIER = 1;
    private static final int BATTLE_CHEAT_STRING_OFFSET_Y = 24;
    private static int s_practiceModeHealTimer;
    private static int s_previousOpponentLife;
    private static boolean s_battleFinishHimTimerExtended;
    private static boolean s_battleInvincibilityP1;
    private static boolean s_battleInvincibilityP2;
    private static SDKString s_battleCheatString;
    private static int s_battleCheatStringTimer;
    private static SDKString s_battleContinueString;
    private static boolean s_isArenaIntroPlayed;
    private static boolean s_isArenaIntroFinished;
    private static int s_introMusicTimer;
    private static boolean s_isMainMusicPlayed;
    private static boolean s_isFinishMusicPlayed;
    private static boolean s_isFatalityStartPlayed;
    private static boolean s_isFatalitySuccessPlayed;
    private static boolean s_isFatalityMissPlayed;
    private static boolean s_isBabalityMusicPlayed;
    private static final byte BATTLE_INGAME_FONT = 4;
    public static final int LOADING_BAR_CANVAS_COLOR = 0x661122;
    public static final int LOADING_BAR_LOADED_COLOR = 0xFF4400;
    public static final int LOADING_BAR_BORDER_COLOR = 249700927;
    public static final int LOADING_BAR_HEIGHT = 6;
    public static final int LOADING_BAR_PADDING = 3;

    private static void resetBattle() {
        s_battleFighter1RoundsWon = 0;
        s_battleFighter2RoundsWon = 0;
        s_battleCurrentRound = 0;
        if (Ingame.isInPracticeMode()) {
            s_practiceModeHealTimer = 0;
        }
    }

    private static void initLoadingState(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                Sound.stopSound();
                s_battleLoadingStep = 0;
                s_xWinsBaseString = SDKUtils.getString(56, null);
                s_roundXBaseString = SDKUtils.getString(53, null);
                s_currentAcceptSoftkeyType = 0;
                s_currentCancelSoftkeyType = 0;
                break;
            }
            case 2: {
                Battle.resetBattleMusic();
                Battle.resetBattle();
                Arena.setCurrentArenaImageId(0);
                Battle.initBattleState(0);
                s_currentAcceptSoftkeyType = (byte)6;
                s_currentCancelSoftkeyType = (byte)5;
                break;
            }
        }
        s_battleLoadingState = n;
        s_battleLoadingStateTimer = 0;
    }

    public static SDKString getLastWinsString() {
        return s_battleEndString;
    }

    public static void loadFatalityMessage() {
        try {
            s_fatalityTileset = FileManager.createTileset(0x900000B, GameImpl.getBloodRed() ? (byte)0 : 3);
            s_fatalityAnimation = Animation.loadAnimation(0x9000002, 1);
            s_fatalityAnimationInstance = 1;
            s_fatalityAnimationHeight = s_fatalityAnimation.computeGlobalHeight(s_fatalityTileset);
            FileManager.cleanup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadBabalityMessage() {
        try {
            s_babalityTileset = FileManager.createTileset(0x900000A);
            s_babalityAnimation = Animation.loadAnimation(0x9000001, 0);
            s_babalityAnimationInstance = 1;
            FileManager.cleanup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void unloadFinishers() {
        s_fatalityTileset = null;
        s_fatalityAnimation = null;
        s_babalityTileset = null;
        s_babalityAnimation = null;
    }

    private static void updateLoadingState() {
        s_battleLoadingStateTimer += GameImpl.s_elapsedTimeClamped;
        switch (s_battleLoadingState) {
            case 0: {
                break;
            }
            case 1: {
                if (s_battleLoadingStep >= 1 && s_battleLoadingStep < 5) {
                    if (s_battleFighter1 == null) {
                        s_battleFighter1 = Fighter.createFighter(s_battleFighter1Id, -48, 0, 1, 0, GameImpl.getControlsState() == 1 ? 0 : 1, false, 0, true);
                        Battle.s_battleFighter1.m_score = Ingame.getBaseScore();
                        FileManager.cleanup();
                    } else {
                        Fighter.updateFighters();
                        s_battleLoadingStep = 1 + Battle.s_battleFighter1.m_currentLoadingStep;
                    }
                } else if (s_battleLoadingStep >= 5 && s_battleLoadingStep < 9) {
                    if (s_battleFighter2 == null) {
                        s_battleFighter2 = Fighter.createFighter(s_battleFighter2Id, 48, 0, -1, Ingame.isInPracticeMode() ? 0 : 2, GameImpl.getControlsState() == 1 ? 0 : 1, false, 1, true);
                        if (Ingame.isInPracticeMode()) {
                            s_previousOpponentLife = Battle.s_battleFighter2.m_healthPoints;
                        }
                        FileManager.cleanup();
                    } else {
                        Fighter.updateFighters();
                        s_battleLoadingStep = 5 + Battle.s_battleFighter2.m_currentLoadingStep;
                    }
                } else {
                    switch (s_battleLoadingStep) {
                        case 0: {
                            GameImpl.loadFont((byte)2);
                            GameImpl.loadFont((byte)3);
                            if (!Ingame.isInPracticeMode()) {
                                Destiny.setDestinySaved(true);
                                Rms.rmsSave();
                            }
                            Fighter.initPool();
                            Projectile.initPool();
                            Physics.initPhysics();
                            Camera.initCamera();
                            Special.initSpecial();
                            Menu.initPauseResources();
                            Special.loadShadows();
                            if (Battle.isEnduranceFight()) {
                                Particle.loadFlamesResources();
                                s_enduranceRoundString = SDKUtils.getString(112, null);
                            }
                            s_battleCurrentRound = 0;
                            Battle.initTouchpadZones();
                            ++s_battleLoadingStep;
                            FileManager.cleanup();
                            break;
                        }
                        case 21: {
                            Particle.initPool();
                            Particle.loadBloodResources();
                            ++s_battleLoadingStep;
                            FileManager.cleanup();
                            break;
                        }
                        case 10: {
                            Sound.loadSFX(Fighter.getSoundId(0, Battle.s_battleFighter1.m_fighterId));
                            Sound.loadSFX(Fighter.getSoundId(0, Battle.s_battleFighter2.m_fighterId));
                            ++s_battleLoadingStep;
                            break;
                        }
                        case 11: {
                            Sound.loadSFX(Fighter.getSoundId(1, Battle.s_battleFighter1.m_fighterId));
                            Sound.loadSFX(Fighter.getSoundId(1, Battle.s_battleFighter2.m_fighterId));
                            ++s_battleLoadingStep;
                            break;
                        }
                        case 12: {
                            Sound.loadSFX(Fighter.getSoundId(5, Battle.s_battleFighter1.m_fighterId));
                            Sound.loadSFX(Fighter.getSoundId(5, Battle.s_battleFighter2.m_fighterId));
                            ++s_battleLoadingStep;
                            break;
                        }
                        case 13: {
                            Sound.loadSFX(Fighter.getSoundId(6, Battle.s_battleFighter1.m_fighterId));
                            Sound.loadSFX(Fighter.getSoundId(6, Battle.s_battleFighter2.m_fighterId));
                            ++s_battleLoadingStep;
                            break;
                        }
                        case 14: {
                            Sound.loadSFX(Fighter.getSoundId(7, Battle.s_battleFighter1.m_fighterId));
                            Sound.loadSFX(Fighter.getSoundId(7, Battle.s_battleFighter2.m_fighterId));
                            Sound.loadMusic((byte)IArena.ARENA_DATA[Arena.s_currentArenaId][23]);
                            ++s_battleLoadingStep;
                            break;
                        }
                        case 15: {
                            Sound.loadSFX(Fighter.getSoundId(8, Battle.s_battleFighter1.m_fighterId));
                            Sound.loadSFX(Fighter.getSoundId(8, Battle.s_battleFighter2.m_fighterId));
                            Sound.loadSFX((byte)54);
                            ++s_battleLoadingStep;
                            break;
                        }
                        case 16: {
                            Sound.loadSFX(Fighter.getSoundId(10, Battle.s_battleFighter1.m_fighterId));
                            Sound.loadSFX(Fighter.getSoundId(10, Battle.s_battleFighter2.m_fighterId));
                            Sound.loadMusic((byte)11);
                            Sound.loadMusic((byte)15);
                            ++s_battleLoadingStep;
                            break;
                        }
                        case 17: {
                            Sound.loadSFX(Fighter.getSoundId(11, Battle.s_battleFighter1.m_fighterId));
                            Sound.loadSFX(Fighter.getSoundId(11, Battle.s_battleFighter2.m_fighterId));
                            Sound.loadMusic((byte)12);
                            Sound.loadMusic((byte)13);
                            Sound.loadMusic((byte)14);
                            ++s_battleLoadingStep;
                            break;
                        }
                        case 18: {
                            Sound.loadSFX((byte)16);
                            Sound.loadSFX((byte)15);
                            ++s_battleLoadingStep;
                            break;
                        }
                        case 19: {
                            Sound.loadSFX(IFighter.FIGHTERS_SFX_NAMES[Battle.s_battleFighter1.m_fighterId]);
                            Sound.loadSFX(IFighter.FIGHTERS_SFX_NAMES[Battle.s_battleFighter2.m_fighterId]);
                            ++s_battleLoadingStep;
                            break;
                        }
                        case 20: {
                            Sound.loadSFX(Fighter.getSoundId(9, Battle.s_battleFighter1.m_fighterId));
                            Sound.loadSFX(Fighter.getSoundId(9, Battle.s_battleFighter2.m_fighterId));
                            ++s_battleLoadingStep;
                            break;
                        }
                        case 9: {
                            Arena.initArena(s_battleArenaId);
                            ++s_battleLoadingStep;
                            FileManager.cleanup();
                            break;
                        }
                        case 22: {
                            Hud.initHud(GameImpl.s_ingameLeft, GameImpl.s_ingameTop, GameImpl.s_ingameRight, GameImpl.s_ingameBottom, s_battleFighter1.getName(), s_battleFighter2.getName(), 99);
                            FileManager.cleanup();
                            ++s_battleLoadingStep;
                            break;
                        }
                        case 23: {
                            Special.loadSpecificResources(Battle.s_battleFighter1.m_fighterId);
                            Projectile.loadProjectileResources(Battle.s_battleFighter1.m_projectileData[0]);
                            Special.loadSpecificResources(Battle.s_battleFighter2.m_fighterId);
                            Projectile.loadProjectileResources(Battle.s_battleFighter2.m_projectileData[0]);
                            ++s_battleLoadingStep;
                        }
                    }
                }
                if (s_battleLoadingStep != 24) break;
                FileManager.cleanup();
                Battle.initLoadingState(2);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private static void initTouchpadZones() {
    }

    private static int getTouchpadJoystickCenterX() {
        return 0;
    }

    private static int getTouchpadJoystickCenterY() {
        return 0 + (GameImpl.s_screenHeight - 30 - 0) / 2;
    }

    private static int getTouchpadButtonsCenterX() {
        return GameImpl.s_ingameRight + 0 + 0;
    }

    public static void drawTouchPadZonesBefore(SDKGraphics sDKGraphics) {
    }

    public static void drawTouchPadZonesAfter(SDKGraphics sDKGraphics) {
    }

    private static void initBattleState(int n) {
        Battle.cleanupBattleState(s_battleState);
        s_battleFighter1BackToBlockable = false;
        s_battleFighter2BackToBlockable = false;
        s_battleStateTimer = 0;
        switch (n) {
            case 15: {
                break;
            }
            case 14: {
                s_battleContinueString = SDKUtils.getString(82, null);
                Ingame.s_currentScore = Ingame.s_baseScore;
                Ingame.s_currentVisibleScore = Ingame.s_baseScore;
                Ingame.s_currentBeginningScore = Ingame.s_baseScore;
                Battle.unloadFinishers();
                FileManager.cleanup();
                break;
            }
            case 13: {
                Particle.killAllParticles();
                Projectile.killAllProjectiles();
                Particle.launchBurningEffect(s_battleFighter2.getX(), s_battleFighter2.getY());
                s_battleFighter2.initPoolState(3);
                if (Battle.s_battleFighter2.m_fighterId != Battle.s_battleFighter1.m_fighterId) {
                    Projectile.cleanupProjectileResources(IFighter.FIGHTERS_PROJECTILES[Battle.s_battleFighter2.m_fighterId][0]);
                    Special.cleanupSpecificResources(Battle.s_battleFighter2.m_fighterId);
                }
                FileManager.cleanup();
                ++s_enduranceFightersDefeated;
                break;
            }
            case 11: {
                s_timeOverString = SDKUtils.getString(55, null);
                break;
            }
            case 12: {
                s_drawGameString = SDKUtils.getString(54, null);
                ++s_battleFighter1RoundsWon;
                ++s_battleFighter2RoundsWon;
                break;
            }
            case 0: {
                Battle.resetBattleMusic();
                Particle.killAllParticles();
                Projectile.killAllProjectiles();
                s_battleFighter1.setPosition(-48, 0);
                s_battleFighter1.setOrientation(1);
                s_battleFighter1.restoreMaxHealthPoints();
                s_battleFighter1.restoreRunMeter();
                s_battleFighter1.initState(0);
                s_battleFighter1.disableControls();
                s_battleFighter1.resetInputBuffer();
                Battle.s_battleFighter1.m_skipPhysics = false;
                Battle.s_battleFighter1.m_comboDamage = 0;
                Battle.s_battleFighter1.m_comboHitsNumber = 0;
                Battle.s_battleFighter1.m_isOnGround = true;
                Battle.s_battleFighter1.m_blockUsed = false;
                Battle.s_battleFighter1.m_autoUpdateAnimation = true;
                Battle.s_battleFighter1.m_timeSinceLastProjectile = 99000;
                Battle.s_battleFighter1.m_timeSinceLastSpecialMove = 99000;
                Battle.s_battleFighter1.m_jabsHitsCount = 0;
                Battle.s_battleFighter1.m_jabsInGuardCount = 0;
                Battle.s_battleFighter1.m_juggleCount = 0;
                s_battleFighter1.setTilesetImageType(0);
                s_battleFighter2.setPosition(48, 0);
                s_battleFighter2.setOrientation(-1);
                s_battleFighter2.restoreMaxHealthPoints();
                s_battleFighter2.restoreRunMeter();
                s_battleFighter2.initState(0);
                s_battleFighter2.disableControls();
                s_battleFighter2.resetInputBuffer();
                Battle.s_battleFighter2.m_skipPhysics = false;
                Battle.s_battleFighter2.m_comboDamage = 0;
                Battle.s_battleFighter2.m_comboHitsNumber = 0;
                Battle.s_battleFighter2.m_isOnGround = true;
                Battle.s_battleFighter2.m_blockUsed = false;
                Battle.s_battleFighter2.m_autoUpdateAnimation = true;
                Battle.s_battleFighter2.m_timeSinceLastProjectile = 99000;
                Battle.s_battleFighter2.m_timeSinceLastSpecialMove = 99000;
                Battle.s_battleFighter2.m_jabsHitsCount = 0;
                Battle.s_battleFighter2.m_jabsInGuardCount = 0;
                Battle.s_battleFighter2.m_juggleCount = 0;
                s_battleFighter2.setTilesetImageType(0);
                s_battleCameraAutomatic = true;
                Hud.resetHud();
                s_battleTimer = 99000;
                ++s_battleCurrentRound;
                Camera.setCamera(0, 0, true);
                Arena.setCurrentArenaImageId(0);
                if (!Ingame.isInPracticeMode()) {
                    switch (s_battleCurrentRound) {
                        case 1: {
                            Sound.playSFX((byte)40);
                            break;
                        }
                        case 2: {
                            Sound.stopSound();
                            Sound.playSFX((byte)41);
                            break;
                        }
                        case 3: {
                            Sound.stopSound();
                            Sound.playSFX((byte)42);
                        }
                    }
                }
                s_nextRoundString = s_roundXBaseString.replaceFirst(s_battleCurrentRound);
                if (!Battle.isEnduranceFight()) break;
                s_enduranceFightersDefeated = 0;
                s_battleFighter2.disableControls();
                Battle.s_battleFighter2.m_enableControlsOnActivation = false;
                s_battleFighter2.setFighterId(Ingame.getFighterIdFromEnduranceList(0));
                Special.loadSpecificResources(Battle.s_battleFighter2.m_fighterId);
                Projectile.loadProjectileResources(IFighter.FIGHTERS_PROJECTILES[Battle.s_battleFighter2.m_fighterId][0]);
                FileManager.cleanup();
                break;
            }
            case 1: {
                s_fightString = SDKUtils.getString(23, null);
                Sound.playSFX((byte)14);
                break;
            }
            case 2: {
                s_battleFighter1.enableControls();
                s_battleFighter2.enableControls();
                break;
            }
            case 5: {
                Battle.s_battleFighter1.m_tileset = null;
                s_currentAcceptSoftkeyType = (byte)3;
                s_currentCancelSoftkeyType = 0;
                Ingame.checkShaoKahnUnlock();
                GameImpl.setFont((byte)4);
                s_battleEndString = s_xWinsBaseString.replaceFirst(Battle.getWinningFighter().m_name);
                s_nomoreString = SDKUtils.getString(66, null);
                s_nomoreStringData = SDKUtils.wrapString(s_nomoreString, null, GameImpl.s_ingameWidth - 12, (short)124);
                s_championString = SDKUtils.getString(67, null);
                s_championStringData = SDKUtils.wrapString(s_championString, null, GameImpl.s_ingameWidth - 12, (short)124);
                Arena.setCurrentArenaImageId(1);
                s_battleFighter1RoundsWon = 2;
                s_isWhiteBackground = false;
                s_deathAnimationStep = 0;
                s_deathAnimationTimer = 0;
                s_battleCameraAutomatic = false;
                s_battleFighter1.disableControls();
                s_battleFighter2.disableControls();
                Camera.setCamera(s_battleFighter2.getX(), 0);
                try {
                    s_deathTileset = FileManager.createTileset(134217842);
                    s_deathAnimation = Animation.loadAnimation(134217772, 0);
                    s_skDefeatAnimation = Animation.loadAnimation(0x600000F, 1);
                    FileManager.cleanup();
                    int[] nArray = new int[]{-1, 100663316};
                    byte[] byArray = new byte[]{0, 0};
                    if (Battle.s_battleFighter1.m_fighterId == 6) {
                        nArray[0] = IFighter.FIGHTERS_TILESETS_ALTERNATIVE[6];
                    }
                    Battle.s_battleFighter2.m_tileset = FileManager.createTileset(IFighter.FIGHTERS_TILESETS[6], nArray, byArray, false, false);
                    FileManager.cleanup();
                }
                catch (Exception exception) {}
                break;
            }
            case 6: {
                switch (s_finisherType) {
                    case 1: {
                        Battle.loadFatalityMessage();
                        break;
                    }
                    case 2: {
                        Battle.loadBabalityMessage();
                    }
                }
                Fighter fighter = Battle.getWinningFighter();
                if (fighter == s_battleFighter2) {
                    ++s_battleFighter2RoundsWon;
                } else if (fighter == s_battleFighter1) {
                    ++s_battleFighter1RoundsWon;
                }
                s_battleFighter1.disableControls();
                s_battleFighter2.disableControls();
                if (fighter != null) {
                    Sound.playSFX(IFighter.FIGHTERS_SFX_NAMES[fighter.m_fighterId]);
                }
                if (fighter != null) {
                    s_battleEndString = s_xWinsBaseString.replaceFirst(fighter.m_name);
                    break;
                }
                s_battleEndString = SDKUtils.getString(54, null);
                break;
            }
            case 7: {
                if (Battle.getWinningFighter() == null) break;
                Sound.playSFX((byte)54);
                break;
            }
            case 8: {
                boolean bl = Battle.getWinningFighter() != null && Battle.getWinningFighter().m_healthPoints == 100;
                s_lastTimeBonus = 1000 * (s_battleTimer / 1000);
                Battle.getWinningFighter().m_score += s_lastTimeBonus;
                s_timeScoreString = SDKUtils.getString(59, null);
                s_timeScoreValue = new SDKString(6, 0);
                s_timeScoreValue.append(s_lastTimeBonus);
                if (bl) {
                    Sound.playSFX((byte)17);
                    if (s_wasFirstRoundFlawless && s_battleCurrentRound == 2) {
                        s_lastLifeBonus = 500000;
                        Battle.getWinningFighter().m_score += s_lastLifeBonus;
                        s_lifeScoreString = SDKUtils.getString(58, null);
                    } else {
                        s_lastLifeBonus = 200000;
                        Battle.getWinningFighter().m_score += s_lastLifeBonus;
                        s_lifeScoreString = SDKUtils.getString(57, null);
                        if (s_battleCurrentRound == 1) {
                            s_wasFirstRoundFlawless = true;
                        }
                    }
                } else {
                    s_lastLifeBonus = 800 * Battle.getWinningFighter().m_healthPoints;
                    Battle.getWinningFighter().m_score += s_lastLifeBonus;
                    s_lifeScoreString = SDKUtils.getString(60, null);
                }
                s_lifeScoreValue = new SDKString(6, 0);
                s_lifeScoreValue.append(s_lastLifeBonus);
                break;
            }
            case 9: {
                Sound.playSFX((byte)13, true);
                if (Battle.getWinningFighter().m_playerType == 0) {
                    Battle.getWinningFighter().m_score += 100000;
                    s_fatalityString = SDKUtils.getString(63, null);
                    s_fatalityScoreValue = new SDKString(6, 0);
                    s_fatalityScoreValue.append(100000);
                    break;
                }
                s_fatalityString = new SDKString();
                s_fatalityScoreValue = new SDKString();
                break;
            }
            case 10: {
                Sound.playSFX((byte)5, true);
                if (Battle.getWinningFighter().m_playerType == 0) {
                    Battle.getWinningFighter().m_score += 100000;
                    s_babalityString = SDKUtils.getString(64, null);
                    s_babalityScoreValue = new SDKString(6, 0);
                    s_babalityScoreValue.append(100000);
                    break;
                }
                s_babalityString = new SDKString();
                s_babalityScoreValue = new SDKString();
                break;
            }
            case 3: {
                s_battleFighter1.disableControls();
                s_battleFighter2.disableControls();
                Battle.getWinningFighter().enableControls();
                if (Battle.getWinningFighter().getOpponent().isAMan()) {
                    s_finishString = SDKUtils.getString(61, null);
                    Sound.playSFX((byte)16);
                    break;
                }
                s_finishString = SDKUtils.getString(62, null);
                Sound.playSFX((byte)15);
                break;
            }
            case 4: {
                Arena.setCurrentArenaImageId(1);
                s_battleFighter1.disableControls();
                s_battleFighter2.disableControls();
                s_battleCameraAutomatic = false;
            }
        }
        s_battleState = n;
    }

    private static void finishRound() {
        if (s_battleFighter1RoundsWon == 2 || s_battleFighter2RoundsWon == 2 || Ingame.isInPracticeMode()) {
            Battle.initBattleState(15);
        } else {
            Battle.initBattleState(0);
        }
    }

    public static int getFinisherType() {
        return s_finisherType;
    }

    private static void gotoFinishers() {
        if (Special.s_didFinisherEnd) {
            switch (s_finisherType) {
                case 1: {
                    Battle.initBattleState(9);
                    break;
                }
                case 2: {
                    Battle.initBattleState(10);
                }
            }
        } else {
            Battle.finishRound();
        }
    }

    private static void updateBattleState() {
        int n;
        s_battleStateTimer += GameImpl.s_elapsedTimeClamped;
        Fighter fighter = Battle.getWinningFighter();
        switch (s_battleState) {
            case 15: {
                if (Battle.didPlayerWin()) {
                    s_battleEnded = true;
                    break;
                }
                Battle.initBattleState(14);
                break;
            }
            case 14: {
                Softkey.setSoftkeys((byte)1, (byte)2);
                if (InputManager.s_isKeyAcceptPressed) {
                    Special.s_didFinisherEnd = false;
                    Battle.initLoadingState(2);
                    break;
                }
                if (!InputManager.s_isKeyCancelPressed) break;
                s_battleEnded = true;
                break;
            }
            case 13: {
                if (Battle.s_battleFighter2.m_poolState != 2) break;
                Special.loadSpecificResources(s_battleFighter2Id);
                Projectile.loadProjectileResources(Battle.s_battleFighter2.m_projectileData[0]);
                FileManager.cleanup();
                s_battleFighter2.initState(6);
                Battle.initBattleState(2);
                break;
            }
            case 12: {
                if (s_battleStateTimer < 1500) break;
                if (s_battleFighter1RoundsWon == 2 || s_battleFighter2RoundsWon == 2) {
                    Battle.initBattleState(15);
                    break;
                }
                Battle.initBattleState(0);
                break;
            }
            case 11: {
                if (s_battleStateTimer <= 1500) break;
                if (fighter != null) {
                    Battle.initBattleState(6);
                    break;
                }
                Battle.initBattleState(12);
                break;
            }
            case 0: {
                if (s_battleStateTimer - Sound.getLastSFXLagDelay() <= 2500 && !Ingame.isInPracticeMode()) break;
                Sound.resetLastSFXLag();
                Battle.initBattleState(1);
                break;
            }
            case 1: {
                if (s_battleStateTimer < 1500) break;
                Battle.initBattleState(2);
                break;
            }
            case 2: {
                if (Battle.isTimeOver()) {
                    Battle.initBattleState(11);
                    break;
                }
                if (Battle.s_battleFighter1.m_healthPoints > 0 && Battle.s_battleFighter2.m_healthPoints > 0) break;
                if (Battle.s_battleFighter2.m_healthPoints <= 0 && Battle.isEnduranceFight() && Battle.anyMoreFightersInEnduranceList()) {
                    Battle.initBattleState(13);
                    break;
                }
                if (Battle.finishHim()) {
                    Special.s_didFinisherEnd = false;
                    Battle.initBattleState(3);
                    break;
                }
                if (Battle.getWinningFighter() == s_battleFighter1 && s_battleFighter1RoundsWon >= 1 && Battle.getWinningFighter().getOpponent().m_fighterId == 6 && Ingame.isFinalFight()) {
                    Battle.initBattleState(5);
                    break;
                }
                Battle.initBattleState(6);
                break;
            }
            case 5: {
                if (InputManager.s_isKeyAcceptPressed) {
                    Battle.initBattleState(15);
                }
                s_deathAnimationTimer += GameImpl.s_elapsedTimeClamped;
                switch (s_deathAnimationStep) {
                    case 0: {
                        if ((!s_battleFighter2.animationFinished() || !Battle.s_battleFighter2.m_isOnGround) && Battle.s_battleFighter2.m_state != 22 && Battle.s_battleFighter2.m_state != 102) break;
                        ++s_deathAnimationStep;
                        s_deathAnimationTimer = 0;
                        break;
                    }
                    case 1: {
                        if (s_deathAnimationTimer <= 500) break;
                        Sound.playSFX((byte)47);
                        GameImpl.vibrate(2000);
                        ++s_deathAnimationStep;
                        s_deathAnimationTimer = 0;
                        s_skDefeatAnimationInstance = 1;
                        break;
                    }
                    case 2: {
                        if (s_deathAnimationTimer <= 2000) break;
                        ++s_deathAnimationStep;
                        Battle.s_battleFighter2.m_tileset.setCurrentImageSlot(1);
                        s_skDefeatAnimationInstance = s_skDefeatAnimation.startInstanceAtFrame(0);
                        break;
                    }
                    case 3: {
                        s_deathAnimationInstance = 1;
                        ++s_deathAnimationStep;
                        break;
                    }
                    case 4: {
                        if (Animation.getInstanceCurrentFrame(s_deathAnimationInstance) != s_deathAnimation.getNbFrames() - 2) break;
                        ++s_deathAnimationStep;
                        s_deathAnimationTimer = 0;
                        break;
                    }
                    case 5: {
                        if (s_deathAnimationTimer <= 1000) break;
                        ++s_deathAnimationStep;
                        s_deathAnimationTimer = 0;
                        break;
                    }
                    case 6: {
                        if (s_deathAnimationTimer <= 1000) break;
                        ++s_deathAnimationStep;
                        s_deathAnimationTimer = 0;
                        break;
                    }
                    case 7: {
                        if (s_deathAnimationTimer <= 1000) break;
                        ++s_deathAnimationStep;
                        s_deathAnimationTimer = 0;
                        break;
                    }
                    case 8: {
                        if (s_deathAnimationTimer <= 1000) break;
                        ++s_deathAnimationStep;
                        s_deathAnimationTimer = 0;
                        break;
                    }
                    case 9: {
                        if (s_deathAnimationTimer <= 1000) break;
                        ++s_deathAnimationStep;
                        s_deathAnimationTimer = 0;
                        break;
                    }
                    case 10: {
                        if (s_deathAnimationTimer <= 3000) break;
                        Battle.initBattleState(15);
                    }
                }
                break;
            }
            case 6: {
                if (s_battleStateTimer - Sound.getLastSFXLagDelay() <= 1500) break;
                Sound.resetLastSFXLag();
                Battle.initBattleState(7);
                break;
            }
            case 7: {
                if (s_battleStateTimer - Sound.getLastSFXLagDelay() <= 1000) break;
                if (Ingame.isInPracticeMode() || Battle.getWinningFighter().getPlayerType() == 2) {
                    Battle.gotoFinishers();
                    break;
                }
                Battle.initBattleState(8);
                break;
            }
            case 8: {
                if (s_battleStateTimer - Sound.getLastSFXLagDelay() <= 2000) break;
                Sound.resetLastSFXLag();
                Battle.gotoFinishers();
                break;
            }
            case 9: {
                if (s_battleStateTimer - Sound.getLastSFXLagDelay() <= 3500) break;
                Sound.resetLastSFXLag();
                Battle.finishRound();
                break;
            }
            case 10: {
                if (s_battleStateTimer - Sound.getLastSFXLagDelay() <= 3500) break;
                Sound.resetLastSFXLag();
                Battle.finishRound();
                break;
            }
            case 3: {
                n = 3500 * (GameImpl.getDifficultyState() == 0 || Ingame.s_arcadeDestinyId == 0 ? 2 : 1);
                if (Battle.fatalityDetected()) {
                    s_finisherType = 1;
                    Battle.initBattleState(4);
                    break;
                }
                if (Battle.babalityDetected()) {
                    s_finisherType = 2;
                    Battle.initBattleState(4);
                    break;
                }
                if ((s_battleStateTimer - Sound.getLastSFXLagDelay() < n || s_battleFinishHimTimerExtended) && (s_battleAttackedFighter == null || !s_battleFighter1BackToBlockable || !s_battleFighter2BackToBlockable)) break;
                Sound.resetLastSFXLag();
                fighter.getOpponent().onFinishHimSequenceMissed();
                Battle.initBattleState(6);
                break;
            }
            case 4: {
                if (!Battle.hasFinisherEnded()) break;
                Battle.initBattleState(6);
            }
        }
        switch (s_battleState) {
            case 13: {
                if (Battle.s_battleFighter2.m_poolState != 0 || s_battleStateTimer < 0) break;
                n = Ingame.getFighterIdFromEnduranceList(s_enduranceFightersDefeated);
                int n2 = s_battleFighter1.getOrientation() == 1 ? Physics.s_fpWallRightLevel >> 8 : Physics.s_fpWallLeftLevel >> 8;
                int n3 = Physics.s_fpGroundLevel >> 8;
                int n4 = s_battleFighter1.getOrientation() * -1;
                int n5 = 1;
                Sound.playSFX(IFighter.FIGHTERS_SFX_NAMES[n]);
                s_battleFighter2 = Fighter.createFighter(n, n2, n3, n4, 2, 0, true, n5, true);
                s_battleFighter2Id = n;
                FileManager.cleanup();
                break;
            }
            case 0: {
                s_battleFighter1.setPosition(-48, 0);
                s_battleFighter2.setPosition(48, 0);
                Camera.updateCamera();
                Physics.updatePhysics();
                break;
            }
            case 2: {
                if (Ingame.isInPracticeMode()) {
                    if (s_previousOpponentLife != Battle.s_battleFighter2.m_healthPoints) {
                        s_previousOpponentLife = Battle.s_battleFighter2.m_healthPoints;
                        s_practiceModeHealTimer = 0;
                    }
                    if ((s_practiceModeHealTimer += GameImpl.s_elapsedTimeClamped) > 3500) {
                        s_practiceModeHealTimer = 0;
                        s_previousOpponentLife = Battle.s_battleFighter2.m_healthPoints = 100;
                    }
                }
                Battle.decreaseBattleTimer();
                Battle.updateBattleWatchdog();
                break;
            }
            case 5: {
                if (s_deathAnimationStep < 1) {
                    Camera.setCamera(s_battleFighter2.getX(), 0);
                } else {
                    Camera.setCamera(0, 0, true);
                }
                if (s_deathAnimationStep < 7) {
                    Camera.cameraShake();
                }
                switch (s_deathAnimationStep) {
                    case 0: 
                    case 5: {
                        s_isWhiteBackground = !s_isWhiteBackground;
                        break;
                    }
                    case 1: 
                    case 7: {
                        s_isWhiteBackground = true;
                        break;
                    }
                    case 8: {
                        s_isWhiteBackground = false;
                        break;
                    }
                    case 2: {
                        s_isWhiteBackground = false;
                        Battle.s_battleFighter2.m_tileset.setCurrentImageSlot(1 - Battle.s_battleFighter2.m_tileset.getCurrentImageSlot());
                        s_skDefeatAnimationInstance = s_skDefeatAnimation.updateInstance(s_skDefeatAnimationInstance, GameImpl.s_elapsedTimeClamped);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        s_isWhiteBackground = false;
                        s_deathAnimationInstance = s_deathAnimation.updateInstance(s_deathAnimationInstance, GameImpl.s_elapsedTimeClamped);
                        break;
                    }
                    case 6: {
                        s_isWhiteBackground = true;
                        s_deathAnimationInstance = s_deathAnimation.updateInstance(s_deathAnimationInstance, GameImpl.s_elapsedTimeClamped);
                    }
                }
                break;
            }
            case 6: 
            case 7: {
                if (fighter.m_state == 20 || fighter.m_state != 0 && fighter.m_state != 3 && fighter.m_state != 1 && fighter.m_state != 16 || Battle.isBattleFrozen()) break;
                fighter.initState(20);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                s_fatalityAnimationInstance = s_fatalityAnimation.updateInstance(s_fatalityAnimationInstance, GameImpl.s_elapsedTimeClamped);
                break;
            }
            case 10: {
                s_babalityAnimationInstance = s_babalityAnimation.updateInstance(s_babalityAnimationInstance, GameImpl.s_elapsedTimeClamped);
            }
        }
        s_battleAttackedFighter = null;
    }

    private static boolean anyMoreFightersInEnduranceList() {
        return Battle.isEnduranceFight() && s_enduranceFightersDefeated < Ingame.s_enduranceFighters.length - 1;
    }

    private static boolean isEnduranceFight() {
        return Ingame.s_enduranceFighters != null;
    }

    private static boolean babalityDetected() {
        return Battle.s_battleFighter1.m_state == 33 || Battle.s_battleFighter2.m_state == 33;
    }

    public static int getBattleAreaBottom() {
        return Math.min(GameImpl.s_screenHeight - Softkey.getSoftkeyHeight(), GameImpl.s_ingameBottom);
    }

    private static boolean isTimeOver() {
        return s_battleTimer <= 0;
    }

    private static boolean hasFinisherEnded() {
        return Special.s_didFinisherEnd;
    }

    private static boolean fatalityDetected() {
        return Battle.s_battleFighter1.m_state == 28 || Battle.s_battleFighter2.m_state == 28;
    }

    private static void decreaseBattleTimer() {
        if (!Ingame.isInPracticeMode()) {
            s_battleTimer -= GameImpl.s_elapsedTimeClamped;
        }
    }

    private static boolean finishHim() {
        if (Ingame.isInPracticeMode()) {
            return s_battleFighter1Id != 6 && s_battleFighter2.healthDepleted();
        }
        return s_battleFighter1Id != 6 && s_battleFighter2Id != 6 && (s_battleFighter1RoundsWon > 0 && s_battleFighter2.healthDepleted() || s_battleFighter2RoundsWon > 0 && s_battleFighter1.healthDepleted());
    }

    private static void drawBattleState(SDKGraphics sDKGraphics) {
        if (s_battleState == 15) {
            return;
        }
        if (s_battleState != 14 && (s_battleState != 0 || s_battleStateTimer > 300 && Battle.s_battleFighter2.m_poolState == 2)) {
            sDKGraphics.setColor(IArena.ARENA_DATA[Arena.s_currentArenaId][19 + Arena.getCurrentArenaImageId()]);
            sDKGraphics.fillRect(GameImpl.s_ingameLeft, GameImpl.s_ingameTop, GameImpl.s_ingameWidth, GameImpl.s_ingameHeight);
            Arena.drawArena();
            if (s_battleState != 5) {
                if (s_battleFighter1 != null && s_battleFighter1.isActive()) {
                    Special.drawShadow(s_battleFighter1);
                }
                if (s_battleFighter2 != null && s_battleFighter2.isActive()) {
                    Special.drawShadow(s_battleFighter2);
                }
                Particle.drawParticlesBehindPlayer();
                if (s_lastActiveFighter == s_battleFighter1) {
                    if (s_battleFighter2 != null && s_battleFighter2.isActive()) {
                        s_battleFighter2.draw(sDKGraphics);
                    }
                    if (s_battleFighter1 != null && s_battleFighter1.isActive()) {
                        s_battleFighter1.draw(sDKGraphics);
                    }
                } else {
                    if (s_battleFighter1 != null && s_battleFighter1.isActive()) {
                        s_battleFighter1.draw(sDKGraphics);
                    }
                    if (s_battleFighter2 != null && s_battleFighter2.isActive()) {
                        s_battleFighter2.draw(sDKGraphics);
                    }
                }
                Projectile.drawProjectiles(sDKGraphics);
                Particle.drawParticlesOverPlayer();
                Special.drawSpecial();
                Hud.drawHud(sDKGraphics);
            }
        }
        switch (s_battleState) {
            case 0: {
                if (s_battleStateTimer > 300 && !Ingame.isInPracticeMode()) {
                    GameImpl.setFont((byte)4);
                    SDKUtils.drawString(s_nextRoundString, GameImpl.s_ingameCenterX, Hud.getHudEnd(), 17);
                    if (Battle.isEnduranceFight()) {
                        GameImpl.setFont((byte)1);
                        SDKUtils.drawString(s_enduranceRoundString, GameImpl.s_ingameCenterX, Battle.getBattleAreaBottom() - SDKUtils.getLineSize(), 17);
                    }
                }
                s_battleFighter1.setPosition(-48, 0);
                s_battleFighter2.setPosition(48, 0);
                break;
            }
            case 1: {
                GameImpl.setFont(GameImpl.s_toggle2 ? (byte)2 : 3);
                SDKUtils.drawString(s_fightString, GameImpl.s_ingameCenterX, Hud.getHudEnd(), 17);
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                if (s_isWhiteBackground) {
                    sDKGraphics.setColor(0xFFFFFF);
                    sDKGraphics.fillRect(GameImpl.s_ingameLeft, GameImpl.s_ingameTop, GameImpl.s_ingameWidth, GameImpl.s_ingameHeight);
                }
                switch (s_deathAnimationStep) {
                    case 0: {
                        s_battleFighter2.draw(sDKGraphics);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        s_skDefeatAnimation.drawInstance(s_skDefeatAnimationInstance, Battle.s_battleFighter2.m_tileset, -Camera.getCameraLeft(), -Camera.getCameraTop(), 0);
                        if (s_deathAnimationStep < 4) break;
                        s_deathAnimation.drawInstance(s_deathAnimationInstance, s_deathTileset, -Camera.getCameraLeft(), -Camera.getCameraTop(), 0);
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        GameImpl.setFont((byte)4);
                        int n = Hud.getHudEnd() + 0;
                        SDKUtils.drawString(s_battleEndString, GameImpl.s_ingameCenterX, n, 17);
                        n += 2 * SDKUtils.getLineSize();
                        if (s_deathAnimationStep >= 9) {
                            SDKUtils.drawWrappedString(s_nomoreString, s_nomoreStringData, 1, s_nomoreStringData[0], GameImpl.s_ingameCenterX, n, 17);
                            n += (s_nomoreStringData[0] + 1) * SDKUtils.getLineSize();
                        }
                        if (s_deathAnimationStep != 10) break;
                        SDKUtils.drawWrappedString(s_championString, s_championStringData, 1, s_championStringData[0], GameImpl.s_ingameCenterX, n, 17);
                    }
                }
                break;
            }
            case 11: {
                GameImpl.setFont((byte)4);
                SDKUtils.drawString(s_timeOverString, GameImpl.s_ingameCenterX, Hud.getHudEnd(), 17);
                break;
            }
            case 12: {
                GameImpl.setFont((byte)4);
                SDKUtils.drawString(s_drawGameString, GameImpl.s_ingameCenterX, Hud.getHudEnd(), 17);
                break;
            }
            case 14: {
                GameImpl.setFont((byte)4);
                SDKUtils.drawString(s_battleContinueString, GameImpl.s_screenWidth / 2, GameImpl.s_screenHeight / 2 - Softkey.getSoftkeyHeight(), 17);
                break;
            }
            case 6: 
            case 7: {
                GameImpl.setFont((byte)4);
                SDKUtils.drawString(s_battleEndString, GameImpl.s_ingameCenterX, Hud.getHudEnd(), 17);
                break;
            }
            case 8: {
                GameImpl.setFont((byte)4);
                int n = Hud.getHudEnd();
                SDKUtils.drawString(s_lifeScoreString, GameImpl.s_ingameCenterX, n, 17);
                SDKUtils.drawString(s_lifeScoreValue, GameImpl.s_ingameCenterX, n += SDKUtils.getLineSize(), 17);
                if (s_battleStateTimer <= 1000) break;
                SDKUtils.drawString(s_timeScoreString, GameImpl.s_ingameCenterX, n += SDKUtils.getLineSize(), 17);
                SDKUtils.drawString(s_timeScoreValue, GameImpl.s_ingameCenterX, n += SDKUtils.getLineSize(), 17);
                break;
            }
            case 3: {
                GameImpl.setFont(GameImpl.s_toggle2 ? (byte)2 : 3);
                SDKUtils.drawString(s_finishString, GameImpl.s_ingameCenterX, Hud.getHudEnd(), 17);
                break;
            }
            case 9: {
                GameImpl.setFont((byte)4);
                int n = Hud.getHudEnd();
                s_fatalityAnimation.drawInstance(s_fatalityAnimationInstance, s_fatalityTileset, GameImpl.s_ingameCenterX, n, 0);
                n += s_fatalityAnimationHeight;
                if (Ingame.isInPracticeMode()) break;
                SDKUtils.drawString(s_fatalityString, GameImpl.s_ingameCenterX, n, 17);
                SDKUtils.drawString(s_fatalityScoreValue, GameImpl.s_ingameCenterX, n += SDKUtils.getLineSize(), 17);
                break;
            }
            case 10: {
                GameImpl.setFont((byte)4);
                int n = Hud.getHudEnd();
                s_babalityAnimation.drawInstance(s_babalityAnimationInstance, s_babalityTileset, GameImpl.s_ingameCenterX, n += 30, 0);
                n += 18;
                if (Ingame.isInPracticeMode()) break;
                SDKUtils.drawString(s_babalityString, GameImpl.s_ingameCenterX, n, 17);
                SDKUtils.drawString(s_babalityScoreValue, GameImpl.s_ingameCenterX, n += SDKUtils.getLineSize(), 17);
            }
        }
    }

    private static Fighter getWinningFighter() {
        if (Battle.s_battleFighter1.m_healthPoints > Battle.s_battleFighter2.m_healthPoints) {
            return s_battleFighter1;
        }
        if (Battle.s_battleFighter1.m_healthPoints < Battle.s_battleFighter2.m_healthPoints) {
            return s_battleFighter2;
        }
        return null;
    }

    private static void cleanupBattleState(int n) {
        switch (n) {
            case 2: {
                Hud.hideComboReports();
            }
        }
    }

    public static void initBattle(int n, int n2, byte by) {
        s_battleFighter1Id = n;
        s_battleFighter2Id = n2;
        s_battleArenaId = by;
        s_battleEnded = false;
        s_wasFirstRoundFlawless = false;
        s_enduranceFightersDefeated = 0;
        s_finisherType = 0;
        Battle.initLoadingState(1);
    }

    public static void updateBattleMusic(int n, int n2) {
        if (GameImpl.getSoundState() != 2) {
            switch (n2) {
                case 0: 
                case 1: 
                case 2: {
                    if (!s_isArenaIntroPlayed && !s_isArenaIntroFinished) {
                        s_isArenaIntroPlayed = true;
                        s_introMusicTimer = 0;
                        break;
                    }
                    if (s_isArenaIntroPlayed && !s_isArenaIntroFinished) {
                        s_introMusicTimer += GameImpl.s_elapsedTimeClamped;
                        break;
                    }
                    if (!s_isArenaIntroFinished || s_isMainMusicPlayed) break;
                    s_isMainMusicPlayed = true;
                    Sound.playMusic((byte)IArena.ARENA_DATA[n][23]);
                    break;
                }
                case 3: {
                    if (s_isFinishMusicPlayed) break;
                    s_isFinishMusicPlayed = true;
                    Sound.playMusic((byte)15);
                    break;
                }
                case 4: {
                    if (!s_isFinishMusicPlayed) break;
                    s_isFinishMusicPlayed = false;
                    if (Battle.getFinisherType() == 1) {
                        if (s_isFatalityStartPlayed) break;
                        s_isFatalityStartPlayed = true;
                        Sound.playMusic((byte)13, true);
                        break;
                    }
                    if (s_isBabalityMusicPlayed) break;
                    s_isBabalityMusicPlayed = true;
                    Sound.playMusic((byte)11, true);
                    break;
                }
                case 6: {
                    if (s_isFatalityStartPlayed) {
                        s_isFatalityStartPlayed = false;
                        s_isFatalitySuccessPlayed = true;
                        Sound.playMusic((byte)14);
                        break;
                    }
                    if (s_isFatalityMissPlayed || s_isFatalitySuccessPlayed || s_isBabalityMusicPlayed) break;
                    s_isFatalityMissPlayed = true;
                    Sound.playMusic((byte)12);
                }
            }
        }
    }

    public static void resetBattleMusic() {
        s_isArenaIntroFinished = true;
        s_isArenaIntroPlayed = false;
        s_isMainMusicPlayed = false;
        s_isFinishMusicPlayed = false;
        s_isFatalityStartPlayed = false;
        s_isFatalityMissPlayed = false;
        s_isFatalitySuccessPlayed = false;
        s_isBabalityMusicPlayed = false;
    }

    public static void updateBattle() {
        boolean bl;
        int n;
        int n2;
        if (s_battleLoadingState == 2) {
            Battle.updateBattleMusic(Arena.s_currentArenaId, s_battleState);
        }
        Battle.updateLoadingState();
        s_battleCheatStringTimer -= GameImpl.s_elapsedTimeClamped;
        if (GameImpl.s_areCheatcodesActivated && s_battleFighter1 != null && Battle.s_battleFighter1.m_inputBuffer != null) {
            if (s_battleInvincibilityP1) {
                Battle.s_battleFighter1.m_healthPoints = 100;
            }
            if (s_battleInvincibilityP2) {
                Battle.s_battleFighter2.m_healthPoints = 100;
            }
            n2 = s_battleFighter1Id;
            n = s_battleFighter2Id;
            byte by = s_battleArenaId;
            bl = false;
            Fighter fighter = s_battleFighter1;
            for (int i = 0; i < ICommand.CHEAT_COMMANDS.length; ++i) {
                byte[] byArray = ICommand.CHEAT_COMMANDS[i];
                if (fighter.isCommandInInputBuffer(byArray)) {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    switch (i) {
                        case 0: {
                            Battle.s_battleFighter1.m_healthPoints = 0;
                            s_battleFighter1.initState(13);
                            Battle.s_battleFighter1.m_physicsData[1] = 0;
                            Battle.initBattleState(2);
                            s_battleFighter2.initState(0);
                            s_battleInvincibilityP1 = false;
                            break;
                        }
                        case 1: {
                            Battle.s_battleFighter2.m_healthPoints = 0;
                            s_battleFighter2.initState(13);
                            Battle.s_battleFighter2.m_physicsData[1] = 0;
                            Battle.initBattleState(2);
                            s_battleFighter1.initState(0);
                            s_battleInvincibilityP2 = false;
                            break;
                        }
                        case 2: {
                            s_battleFinishHimTimerExtended = !s_battleFinishHimTimerExtended;
                            bl2 = true;
                            bl3 = s_battleFinishHimTimerExtended;
                            break;
                        }
                        case 3: {
                            s_battleInvincibilityP1 = !s_battleInvincibilityP1;
                            bl2 = true;
                            bl3 = s_battleInvincibilityP1;
                            break;
                        }
                        case 4: {
                            s_battleInvincibilityP2 = !s_battleInvincibilityP2;
                            bl2 = true;
                            bl3 = s_battleInvincibilityP2;
                            break;
                        }
                        case 5: {
                            s_battleTimer = 0;
                            break;
                        }
                        case 6: {
                            s_battleFighter2.setPlayerType(Battle.s_battleFighter2.m_playerType == 0 ? 2 : 0);
                            bl2 = true;
                            bl3 = Battle.s_battleFighter2.m_playerType == 2;
                            break;
                        }
                        case 7: {
                            Battle.s_battleFighter1.m_score += 100000;
                            break;
                        }
                        case 8: {
                            n2 = (n2 + 1) % 7;
                            bl = true;
                            break;
                        }
                        case 9: {
                            n = (n + 1) % 7;
                            bl = true;
                            break;
                        }
                        case 10: {
                            by = (byte)((by + 1) % IArena.ARENA_DATA.length);
                            bl = true;
                        }
                    }
                    fighter.resetInputBuffer();
                    s_battleCheatString = new SDKString(ICommand.CHEATS_NAMES[i] + (bl2 ? " - " + (bl3 ? "ON" : "OFF") : ""));
                    s_battleCheatStringTimer = 3500;
                }
                if (!bl) continue;
                Battle.cleanupBattle();
                Battle.initBattle(n2, n, by);
                return;
            }
        }
        if (!s_battlePaused) {
            if (Battle.battleHasEnded()) {
                Battle.cleanupBattle();
            }
            if (s_battleLoadingState == 2 && !Battle.isBattleFrozen()) {
                Camera.updateCamera();
                Physics.physicsUpdateTrajectories();
                Fighter.updateFighters();
                Physics.physicsUpdateCollisions();
                Arena.updateArena();
                Projectile.updateProjectiles();
                Particle.updateParticles();
                Physics.physicsUpdateAdjustments();
                Battle.updateTouchpadZones();
                if (s_battleFighter1.getX() < s_battleFighter2.getX()) {
                    s_battleFighter1.setOrientation(1);
                    s_battleFighter2.setOrientation(-1);
                } else {
                    s_battleFighter1.setOrientation(-1);
                    s_battleFighter2.setOrientation(1);
                }
                n2 = s_battleFighter1.getX() + (s_battleFighter2.getX() - s_battleFighter1.getX()) / 2;
                n = (s_battleFighter2.getY() + s_battleFighter1.getY()) / 2;
                Fighter fighter = Battle.getThrownFighter();
                if (fighter != null) {
                    Fighter fighter2 = Battle.getFighterOpponent(fighter);
                    n2 = fighter2.getX();
                    n = fighter2.getY();
                }
                bl = false;
                if (s_battleCameraAutomatic) {
                    if (!s_battleFighter1.skipCameraTracking() && !s_battleFighter2.skipCameraTracking()) {
                        n += Camera.s_groundLevel - GameImpl.s_ingameHeight / 2 + Arena.s_currentArenaBottom;
                        bl = true;
                    } else if (!s_battleFighter1.skipCameraTracking() && s_battleFighter2.skipCameraTracking()) {
                        n2 = s_battleFighter1.getX();
                        n += Camera.s_groundLevel - GameImpl.s_ingameHeight / 2 + Arena.s_currentArenaBottom;
                        bl = true;
                    } else if (s_battleFighter1.skipCameraTracking() && !s_battleFighter2.skipCameraTracking()) {
                        n2 = s_battleFighter2.getX();
                        n += Camera.s_groundLevel - GameImpl.s_ingameHeight / 2 + Arena.s_currentArenaBottom;
                        bl = true;
                    }
                }
                if (bl) {
                    Camera.setCamera(n2, n, false);
                }
            }
            if (s_battleLoadingState == 2) {
                Hud.setHudParameters(Battle.s_battleFighter1.m_healthPoints, Battle.s_battleFighter2.m_healthPoints, Battle.s_battleFighter1.m_fpRunMeter >> 8, Battle.s_battleFighter2.m_fpRunMeter >> 8, s_battleFighter1RoundsWon, s_battleFighter2RoundsWon, s_battleTimer / 1000, Ingame.getCurrentVisibleScore());
                Hud.setHUDNames(Battle.s_battleFighter1.m_name, Battle.s_battleFighter2.m_name);
                Ingame.setCurrentScore(Battle.s_battleFighter1.m_score);
                Hud.updateHud();
                Battle.updateBattleState();
            }
        }
        if (s_battleState != 14) {
            Softkey.setSoftkeys(s_currentAcceptSoftkeyType, s_currentCancelSoftkeyType);
        }
    }

    private static void updateTouchpadZones() {
    }

    public static int getTouchpadZoneId(boolean bl) {
        return -1;
    }

    private static boolean pointToLineVerify(int n, int n2, int n3, int n4) {
        return false;
    }

    private static boolean isBattleFrozen() {
        return Battle.isTimeOver();
    }

    public static boolean isLoadingFinished() {
        return s_battleLoadingState == 2;
    }

    public static boolean isPauseMenuStateAvailable() {
        return Battle.isLoadingFinished() && Ingame.s_ingameState == 3 && !Ingame.isPauseMenuLaunched() && s_battleState != 5 && s_battleState != 14 && !Ingame.isInfoMenuLaunched();
    }

    private static void updateBattleWatchdog() {
        for (int i = 0; i < 2; ++i) {
            Fighter fighter;
            Fighter fighter2 = fighter = i == 0 ? s_battleFighter1 : s_battleFighter2;
            if (fighter.m_juggleCount >= 4 && fighter.getOpponent().m_state != 21 && fighter.getOpponent().m_state != 26 && fighter.getOpponent().m_state != 30) {
                Special.forceReject(fighter.getOpponent());
            }
            if (fighter.m_jabsHitsCount < 4 || fighter.getOpponent().m_state == 21 || fighter.getOpponent().m_state == 26 || fighter.getOpponent().m_state == 30) continue;
            Special.forceReject(fighter.getOpponent());
            fighter.m_jabsHitsCount = 0;
        }
    }

    public static boolean battleHasEnded() {
        return s_battleEnded;
    }

    private static Fighter getThrownFighter() {
        if (Battle.s_battleFighter1.m_state == 18) {
            return s_battleFighter1;
        }
        if (Battle.s_battleFighter2.m_state == 18) {
            return s_battleFighter2;
        }
        return null;
    }

    public static void drawBattle(SDKGraphics sDKGraphics) {
        if (s_battleLoadingState == 1) {
            Battle.drawBattleLoadingBar(sDKGraphics);
        } else if (s_battleLoadingState == 2) {
            Battle.drawTouchPadZonesBefore(sDKGraphics);
            GameImpl.setIngameClip();
            Battle.drawBattleState(sDKGraphics);
            GameImpl.setFullClip();
            Battle.drawTouchPadZonesAfter(sDKGraphics);
        }
        if (s_battleCheatStringTimer > 0) {
            GameImpl.setFont((byte)4);
            SDKUtils.drawString(s_battleCheatString, GameImpl.s_ingameCenterX, Hud.getHudEnd() + 24, 17);
        }
    }

    public static void fighterMoved(Fighter fighter) {
        s_lastActiveFighter = fighter;
    }

    private static void drawBattleLoadingBar(SDKGraphics sDKGraphics) {
        int n = 3;
        int n2 = GameImpl.s_screenHeight / 2 - 3;
        int n3 = GameImpl.s_screenWidth - 6;
        int n4 = 6;
        Battle.drawLoadingBar(sDKGraphics, s_battleLoadingStep, 24, n, n2, n3, n4);
    }

    public static void cleanupBattle() {
        Sound.stopSound();
        s_battleFighter1 = null;
        s_battleFighter2 = null;
        s_lastActiveFighter = null;
        s_deathTileset = null;
        Fighter.cleanupFighters();
        Arena.cleanupArena();
        Particle.cleanupPool();
        Particle.cleanUpParticleResources();
        Physics.cleanupPhysics();
        Projectile.releasePool();
        Battle.unloadFinishers();
        Hud.cleanUpHud();
        GameImpl.cleanupFont((byte)2);
        GameImpl.cleanupFont((byte)3);
        Menu.cleanupPauseMenuResources();
        Special.cleanupShadows();
        Special.cleanupKitanaSpecial();
        Special.cleanupSonyaKiss();
        Special.cleanupSkeleton();
        Camera.resetCameraShake();
        Special.cleanupLiukangFatality();
    }

    public static void drawLoadingBar(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5 * (n + 1) / n2;
        n7 = Math.min(n7, n5);
        sDKGraphics.setColor(0x661122);
        sDKGraphics.fillRect(n3, n4, n5, n6);
        sDKGraphics.setColor(0xFF4400);
        sDKGraphics.fillRect(n3, n4, n7, n6);
        sDKGraphics.setColor(249700927);
        sDKGraphics.drawRect(n3, n4, n5, n6);
    }

    public static boolean requiresFrozenTilesets() {
        return s_battleFighter1Id == 1 || s_battleFighter2Id == 1 || Battle.isEnduranceFight();
    }

    public static boolean isMirrorMatch() {
        return s_battleFighter1Id == s_battleFighter2Id;
    }

    public static boolean doesFighterRequireAlternateTileset(Fighter fighter) {
        return (Battle.isMirrorMatch() || Battle.isEnduranceFight()) && fighter == Battle.getFighter2();
    }

    public static Fighter getFighter2() {
        return s_battleFighter2;
    }

    public static Fighter getFighter1() {
        return s_battleFighter1;
    }

    public static Fighter canFighterThrowOpponent(Fighter fighter) {
        Fighter fighter2 = Battle.getFighterOpponent(fighter);
        if (fighter.isCloseToArenaBoundaries() || Battle.getOpponentsDistance() > 48 || !fighter.canThrow() || !fighter2.canBeThrown()) {
            return null;
        }
        return fighter2;
    }

    static int getOpponentsDistance() {
        int n = s_battleFighter2.getX() - s_battleFighter1.getX();
        return n < 0 ? -n : n;
    }

    public static Fighter getFighterOpponent(Fighter fighter) {
        if (fighter == s_battleFighter1) {
            return s_battleFighter2;
        }
        if (fighter == s_battleFighter2) {
            return s_battleFighter1;
        }
        return null;
    }

    public static void fighterHit(Fighter fighter) {
        s_battleAttackedFighter = fighter;
    }

    public static boolean isBattleOver() {
        return s_battleEnded;
    }

    public static boolean didPlayerWin() {
        if (Ingame.isInPracticeMode()) {
            return true;
        }
        return s_battleFighter1RoundsWon == 2 && s_battleFighter1RoundsWon > s_battleFighter2RoundsWon;
    }

    public static void comboHit(Fighter fighter, int n) {
        ++fighter.m_comboHitsNumber;
    }

    public static void backToBlockable(Fighter fighter) {
        fighter.m_jabsHitsCount = 0;
        fighter.m_juggleCount = 0;
        if (fighter == s_battleFighter1) {
            s_battleFighter1BackToBlockable = true;
        } else if (fighter == s_battleFighter2) {
            s_battleFighter2BackToBlockable = true;
        }
        if (fighter.m_comboHitsNumber >= 2) {
            if (s_battleState == 2) {
                Fighter fighter2 = fighter == s_battleFighter1 ? s_battleFighter2 : s_battleFighter1;
                Hud.displayComboReport(fighter2 == s_battleFighter1 ? 0 : 1, fighter.m_comboHitsNumber, fighter.m_comboDamage);
            } else {
                fighter.m_comboHitsNumber = 0;
                fighter.m_comboDamage = 0;
            }
        }
        fighter.m_comboHitsNumber = 0;
        fighter.m_comboDamage = 0;
    }

    public static void resetInputBuffers() {
        if (s_battleFighter1 != null && s_battleFighter2 != null) {
            s_battleFighter1.resetInputBuffer();
            s_battleFighter2.resetInputBuffer();
        }
    }

    public static String force3digits(int n) {
        if (n < 10) {
            return "00" + n;
        }
        if (n < 100) {
            return "0" + n;
        }
        return "" + n;
    }
}

