/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Destiny;
import com.ea.game.GameImpl;
import com.ea.game.Ingame;
import com.ea.game.MathTools;
import com.ea.game.Menu;
import com.ea.sdk.SDKUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Rms {
    private static final byte[][] DEFAULT_HIGHSCORE_NAMES = new byte[][]{{28, 19, 21}, {20, 11, 13}, {12, 28, 31}, {11, 28, 15}, {11, 14, 28}, {25, 22, 1}, {15, 14, 25}, {23, 11, 30}, {33, 11, 15}, {29, 25, 16}};
    private static final int RECORD_ID = 0;
    private static byte[] s_rmsCache;
    private static final int MAXIMUM_DEFAULT_HIGHSCORE = 1000000;
    private static final int DEFAULT_HIGHSCORE_DIFFERENCE = 100000;

    public static boolean rmsLoad() {
        try {
            int n;
            int n2;
            Object object;
            if (s_rmsCache == null) {
                s_rmsCache = SDKUtils.loadRecord(0);
            }
            if (s_rmsCache == null) {
                throw new IOException();
            }
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(s_rmsCache));
            GameImpl.setSoundState(dataInputStream.readByte());
            GameImpl.setVibrationState(dataInputStream.readByte());
            GameImpl.setLanguageState(dataInputStream.readByte());
            GameImpl.setControlsState(dataInputStream.readByte());
            GameImpl.setDifficultyState(dataInputStream.readByte());
            boolean bl = dataInputStream.readBoolean();
            Destiny.setDestinySaved(bl);
            if (bl) {
                object = new int[dataInputStream.readByte()][0];
                for (n2 = 0; n2 < ((byte[])object).length; ++n2) {
                    object[n2] = (byte)new int[dataInputStream.readByte()];
                    for (n = 0; n < ((byte)object[n2]).length; ++n) {
                        object[n2][n] = dataInputStream.readInt();
                    }
                }
                Destiny.setDestinySetup((int[][])object);
                Destiny.setSelectedDestiny(dataInputStream.readInt());
                Destiny.setSelectedBrick(dataInputStream.readInt());
                Destiny.setFighterId(dataInputStream.readInt());
                Ingame.setBaseScore(dataInputStream.readInt());
            }
            object = new byte[3];
            for (n2 = 0; n2 < 10; ++n2) {
                for (n = 0; n < 3; ++n) {
                    object[n] = dataInputStream.readByte();
                }
                Menu.setHighscoreName(n2, object);
                Menu.setHighscoreValue(n2, dataInputStream.readInt());
            }
            GameImpl.setShaoKahnUnlocked(dataInputStream.readBoolean());
            GameImpl.setFirstLaunch(dataInputStream.readBoolean());
            return true;
        }
        catch (Exception exception) {
            Destiny.setDestinySaved(false);
            Rms.generateDefaultHighscores();
            GameImpl.setFirstLaunch(true);
            Rms.rmsSave();
            return false;
        }
    }

    public static void rmsSave() {
        try {
            int n;
            int n2;
            Object object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(GameImpl.getSoundState());
            dataOutputStream.writeByte(GameImpl.getVibrationState());
            dataOutputStream.writeByte(GameImpl.getLanguageState());
            dataOutputStream.writeByte(GameImpl.getControlsState());
            dataOutputStream.writeByte(GameImpl.getDifficultyState());
            if (Destiny.getDestinySaved()) {
                dataOutputStream.writeBoolean(true);
                object = Destiny.getDestinySetup();
                dataOutputStream.writeByte(((int[][])object).length);
                for (n2 = 0; n2 < ((int[][])object).length; ++n2) {
                    dataOutputStream.writeByte(object[n2].length);
                    for (n = 0; n < object[n2].length; ++n) {
                        dataOutputStream.writeInt(object[n2][n]);
                    }
                }
                dataOutputStream.writeInt(Destiny.getSelectedDestiny());
                dataOutputStream.writeInt(Destiny.getSelectedBrick());
                dataOutputStream.writeInt(Destiny.getFighterId());
                dataOutputStream.writeInt(Ingame.getBaseScore());
            } else {
                dataOutputStream.writeBoolean(false);
            }
            for (n2 = 0; n2 < 10; ++n2) {
                object = Menu.getHighscoreName(n2);
                for (n = 0; n < 3; ++n) {
                    dataOutputStream.writeByte((int)object[n]);
                }
                dataOutputStream.writeInt(Menu.getHighscoreValue(n2));
            }
            dataOutputStream.writeBoolean(GameImpl.isShaoKahnUnlocked());
            dataOutputStream.writeBoolean(GameImpl.getFirstLaunch());
            s_rmsCache = byteArrayOutputStream.toByteArray();
            SDKUtils.saveRecord(0, s_rmsCache);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void generateDefaultHighscores() {
        boolean[] blArray = new boolean[10];
        Menu.setHighscoreName(0, DEFAULT_HIGHSCORE_NAMES[0]);
        Menu.setHighscoreValue(0, 1000000);
        blArray[0] = true;
        for (int i = 1; i < 10; ++i) {
            int n;
            while (blArray[n = MathTools.getRandomInt(1, 9)]) {
            }
            blArray[n] = true;
            Menu.setHighscoreName(i, DEFAULT_HIGHSCORE_NAMES[n]);
            Menu.setHighscoreValue(i, 1000000 - i * 100000);
        }
    }
}

