/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Animation;
import com.ea.game.Battle;
import com.ea.game.CharacterSelection;
import com.ea.game.Destiny;
import com.ea.game.FileManager;
import com.ea.game.GameImpl;
import com.ea.game.Ingame;
import com.ea.game.InputManager;
import com.ea.game.Rms;
import com.ea.game.Softkey;
import com.ea.game.Sound;
import com.ea.game.Tileset;
import com.ea.sdk.SDKAutoConstants;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

public class Menu {
    public static final int MENU_STATE_MAIN = 0;
    public static final int MENU_STATE_OPTIONS = 1;
    public static final int MENU_STATE_HELP = 2;
    public static final int MENU_STATE_HELP_ARCADE = 3;
    public static final int MENU_STATE_HELP_CONTROLS = 4;
    public static final int MENU_STATE_ABOUT = 5;
    public static final int MENU_STATE_HIGHSCORE = 6;
    public static final int MENU_STATE_HIGHSCORE_BLINKING = 7;
    public static final int MENU_STATE_EXIT = 8;
    public static final int MENU_STATE_ERASE_DATA = 9;
    public static final int MENU_STATE_OPTIONS_LANGUAGE = 10;
    public static final int MENU_STATE_INITIAL_LANGUAGE = 11;
    public static final int MENU_STATE_OPTIONS_SOUND = 12;
    public static final int MENU_STATE_INITIAL_SOUND = 13;
    public static final int MENU_STATE_OPTIONS_VIBRA = 14;
    public static final int MENU_STATE_INITIAL_VIBRATION = 15;
    public static final int MENU_STATE_OPTIONS_DIFFICULTY = 16;
    public static final int MENU_STATE_INITIAL_DIFFICULTY = 17;
    public static final int MENU_STATE_OPTIONS_CONTROLS = 18;
    public static final int MENU_STATE_INITIAL_CONTROLS = 19;
    public static final int MENU_STATE_GET_MORE_GAMES = 20;
    public static final int MENU_STATE_LOAD_SAVED = 21;
    public static final int MENU_STATE_PRACTICE = 22;
    public static final int PAUSE_STATE_RESUME = 23;
    public static final int PAUSE_STATE_MAIN = 24;
    public static final int PAUSE_STATE_EXIT_CONFIRMATION = 25;
    public static final int PAUSE_STATE_HELP = 26;
    public static final int PAUSE_STATE_OPTIONS_SOUND = 27;
    public static final int PAUSE_STATE_OPTIONS_VIBRATION = 28;
    public static final int MENU_STATES_NUMBER = 29;
    public static int s_currentMenuState;
    private static int s_currentSelectedItem;
    private static int[] s_currentMenuItemDestination;
    public static int s_currentMenuType;
    private static boolean s_isCurrentMenuWithBackground;
    private static boolean s_isCurrentMenuWrapped;
    private static final int MAXIMUM_NUMBER_OF_BACK_STATES = 5;
    private static final int BACK_STATE_UNUSED = -1;
    private static int[] s_backStatesQueue;
    private static int s_lastBackState;
    private static int[] s_currentMenuVisibleOptions;
    private static SDKString[] s_currentMenuItemString;
    private static int[] s_currentMenuItemStringSize;
    private static int s_currentMenuItemsNumber;
    private static SDKString s_currentMenuHeaderString;
    private static byte s_currentAcceptSoftkeyType;
    private static byte s_currentCancelSoftkeyType;
    private static final int MAX_NUMBER_OF_VISIBLE_OPTIONS_IN_WRAPPING_MENU = 3;
    private static final int MENU_CONFIGURATION_ID_MAINMENU = 0;
    private static final int MENU_CONFIGURATION_ID_SUBMENU = 1;
    private static final int MENU_CONFIGURATION_ID_PAUSE_MAIN = 2;
    private static final int MENU_CONFIGURATION_ID_PAUSE_SUB = 3;
    private static final int NUMBER_OF_MENU_COORDINATE_CONFIGURATIONS = 4;
    private static int s_currentMenuConfiguration;
    public static final int MENU_TYPE_MAINMENU = 0;
    private static final int MENU_TYPE_PAUSE_MAIN = 1;
    private static final int MENU_TYPE_PAUSE_SUBMENU = 2;
    private static final int MENU_TYPE_SUBMENU = 3;
    private static final int MENU_TYPE_YESNOMENU = 4;
    private static final int MENU_TYPE_TEXTBOX_MAIN = 5;
    private static final int MENU_TYPE_TEXTBOX_PAUSE = 6;
    private static final int MENU_TYPE_HIGHSCORES = 7;
    private static final int MENU_DATA_MENU_TYPE = 0;
    private static final int MENU_DATA_HEADER_ID = 1;
    private static final int MENU_DATA_ELEMENTS_START = 2;
    private static final int MENU_DATA_TEXTBOX_ID = 2;
    private static final int MENU_ITEM_DATA_TEXTID = 0;
    private static final int MENU_ITEM_DATA_STATEID = 1;
    private static final int MENU_ITEM_DATA_SIZE = 2;
    public static boolean[] s_lockedStates;
    private static final byte NO_FONT_OVERRIDE = -1;
    private static final int[] PAUSE_MENU_ITEMS;
    private static final int[] PAUSE_YES_NO_EXIT_ITEMS;
    private static final int[] PAUSE_HELP_ITEMS;
    private static final int[] MENU_MAIN_ITEMS;
    private static final int[] MENU_OPTIONS_ITEMS;
    private static final int[] MENU_OPTIONS_LANGUAGE_ITEMS;
    private static final int[] MENU_OPTIONS_SOUND_ITEMS;
    private static final int[] MENU_OPTIONS_VIBRA_ITEMS;
    private static final int[] PAUSE_OPTIONS_SOUND_ITEMS;
    private static final int[] PAUSE_OPTIONS_VIBRA_ITEMS;
    private static final int[] MENU_OPTIONS_DIFFICULTY_ITEMS;
    private static final int[] MENU_OPTIONS_CONTROLS_ITEMS;
    private static final int[] MENU_HELP_ITEMS;
    private static final int[] MENU_ABOUT_ITEMS;
    private static final int[] MENU_HELP_ARCADE_ITEMS;
    private static final int[] MENU_HELP_CONTROLS_ITEMS;
    private static final int[] MENU_YES_NO_LOAD_ITEMS;
    private static final int[] MENU_YES_NO_EXIT_ITEMS;
    private static final int[] MENU_YES_NO_ERASE_DATA_ITEMS;
    private static int s_menuHeaderY;
    private static int s_menuMinOptionY;
    private static int s_menuMaxOptionY;
    private static int[] s_menuMaxOptionsNumber;
    private static int[] s_menuCellHeight;
    private static int[] s_menuCellDistance;
    private static int s_currentMenuFirstOptionY;
    private static int s_textboxX;
    private static int s_textboxY;
    private static int s_textboxWidth;
    private static int s_textboxHeight;
    private static int s_textboxMaxLines;
    private static int s_textboxRowsNumber;
    public static SDKString s_textboxString;
    private static int s_textboxTextPosition;
    private static short[] s_textboxLineData;
    private static int s_textboxTextPositionMax;
    private static int s_textboxAnchor;
    public static int s_upArrowCoordinateX;
    public static int s_upArrowCoordinateY;
    public static int s_downArrowCoordinateX;
    public static int s_downArrowCoordinateY;
    private static final int SCROLL_SPEED_UPDATE_TIME = 100;
    private static int s_timeSinceLastScroll;
    private static boolean s_isUpArrowDrawn;
    private static boolean s_isDownArrowDrawn;
    private static boolean s_isUpArrowActive;
    private static boolean s_isDownArrowActive;
    private static final int MENU_TILESET_BG = 0;
    private static final int MENU_TILESET_HEADER = 1;
    private static final int MENU_TILESET_ARROWS = 2;
    private static final int MENU_TILESET_DRAGON = 3;
    private static final int PAUSE_TILESET_DRAGON = 0;
    private static final int PAUSE_TILESET_ARROWS = 1;
    private static final int[] MENU_TILESET;
    private static final int[] PAUSE_TILESET;
    private static Tileset[] s_menuTileset;
    private static Tileset[] s_pauseTileset;
    private static final int MENU_FRAME_COLOUR_TOP = 789000;
    private static final int MENU_FRAME_COLOUR_LEFT = 1842466;
    private static final int MENU_FRAME_COLOUR_RIGHT = 0xCFCCC4;
    private static final int MENU_FRAME_COLOUR_BOTTOM = 10920337;
    private static final int MENU_FRAME_COLOUR_SHUTTER_BLANK = 0;
    private static final int MENU_FRAME_COLOUR_SHUTTER_FULL = -12304077;
    private static final int MENU_ANIMATION_BG = 0;
    private static final int MENU_ANIMATION_HEADER = 1;
    private static final int MENU_ANIMATION_CORNER_NW = 2;
    private static final int MENU_ANIMATION_CORNER_NE = 3;
    private static final int MENU_ANIMATION_CORNER_SW = 4;
    private static final int MENU_ANIMATION_CORNER_SE = 5;
    private static final int MENU_ANIMATION_DRAGON = 6;
    private static final int MENU_ANIMATION_ARROW_UP = 7;
    private static final int MENU_ANIMATION_ARROW_UP_ACTIVE = 8;
    private static final int MENU_ANIMATION_ARROW_DOWN = 9;
    private static final int MENU_ANIMATION_ARROW_DOWN_ACTIVE = 10;
    private static final int PAUSE_ANIMATION_DRAGON = 0;
    private static final int PAUSE_ANIMATION_ARROW_UP = 1;
    private static final int PAUSE_ANIMATION_ARROW_UP_ACTIVE = 2;
    private static final int PAUSE_ANIMATION_ARROW_DOWN = 3;
    private static final int PAUSE_ANIMATION_ARROW_DOWN_ACTIVE = 4;
    private static final int[] MENU_ANIMATION;
    private static final int[] PAUSE_ANIMATION;
    private static final int[] MENU_ANIMATION_TILESETS;
    private static final int[] PAUSE_ANIMATION_TILESETS;
    private static Animation[] s_menuAnimation;
    private static Animation[] s_pauseAnimation;
    private static int[] s_menuAnimationWidth;
    private static int[] s_menuAnimationHeight;
    private static int[] s_menuAnimationHSLeft;
    private static int[] s_menuAnimationHSTop;
    private static int[] s_menuAnimationInstance;
    private static int[] s_pauseAnimationWidth;
    private static int[] s_pauseAnimationHeight;
    private static int[] s_pauseAnimationInstance;
    private static int[] s_shutterArray;
    private static int s_menuCellWidth;
    private static boolean s_isMenuResourcesInitialized;
    private static boolean s_isPauseResourcesInitialized;
    private static int s_cellEdgeToScreenOffset;
    private static int s_textEdgeToDragonOffset;
    private static final byte[] DEFAULT_ENTERED_NAME;
    private static final byte[] FORBIDDEN_ENTERED_NAME;
    public static final int HIGHSCORE_NAME_SIZE = 3;
    public static final int HIGHSCORES_NUMBER = 10;
    private static byte[][] s_highscoreNames;
    private static int[] s_highscoreValues;
    private static SDKString[] s_highscoreNameString;
    private static SDKString[] s_highscoreNumberString;
    private static SDKString[] s_highscoreValueString;
    private static int s_highscoreY;
    private static int s_highscoreNameX;
    private static int s_highscoreValueX;
    private static int s_highscoreSpace;
    private static int s_highscoreHeight;
    private static int s_highscoreNum;
    private static final String HIGHSCORE_DOTSPACE = ". ";
    private static final int HIGHSCORE_NUMBER_STRING_SIZE = 4;
    private static SDKString s_newHighscore;
    private static SDKString s_enterName;
    private static final String HIGHSCORE_UNDERSCORE = "_";
    private static SDKString s_highscoreUnderscore;
    private static int s_newHighscoreY;
    private static int s_enterNameY;
    private static int s_nameLettersY;
    private static int s_nameLettersX;
    private static int s_nameUnderscoreSize;
    private static int s_nameLettersSpace;
    private static boolean s_isHighscoreAcceptPossible;
    private static boolean s_isHighscoreAccepted;
    private static short[] s_enterNameData;
    private static byte[] s_currentEnteredName;
    private static SDKString[] s_currentEnteredNameString;
    private static int s_currentSelectedNameLetter;
    private static boolean s_isCurrentSelectedLetterBlinking;
    private static final int LETTERS_CHANGE_BASE_SPEED = 20;
    private static final int LETTERS_CHANGE_ACCELERATION = 4;
    private static final int LETTERS_CHANGE_MINIMAL_SPEED = 2;
    private static int s_currentLettersChangeSpeed;
    private static int s_letterChangeTime;
    public static final int NO_BLINKING_HIGHSCORE = -1;
    private static boolean s_blinkingHighscoreBlink;
    private static int s_blinkingHighscoreOption;
    private static final int ENTER_NAME_ARROW_UP = 0;
    private static final int ENTER_NAME_ARROW_DOWN = 1;
    private static final int ENTER_NAME_ARROW_LEFT = 2;
    private static final int ENTER_NAME_ARROW_RIGHT = 3;
    private static final int ENTER_NAME_ARROW_NUMBER = 4;
    private static int ENTER_NAME_ARROWS_TILESET;
    private static final int[] ENTER_NAME_ARROWS_ANIMATIONS;
    private static final int SIZEOF_TXT_HELP_ARCADE = 1000;
    private static final int TOUCH_CELL_COLOUR = 255;
    private static final int TOUCH_ARROW_COLOUR = 0xFFFF00;
    private static final int TOUCH_ENTER_NAME_ARROWS_COLOUR = 0x666666;
    private static Tileset s_enterNameArrowsTileset;
    private static Animation[] s_enterNameArrowsAnimation;
    private static int[] s_enterNameArrowsAnimationInstance;
    private static int[] s_enterNameArrowX;
    private static int[] s_enterNameArrowY;
    private static int[] s_enterNameArrowWidth;
    private static int[] s_enterNameArrowHeight;

    private static void generateHighscoreStrings() {
        for (int i = 0; i < 10; ++i) {
            Menu.s_highscoreNumberString[i] = new SDKString(4, 0);
            s_highscoreNumberString[i].append(i + 1);
            s_highscoreNumberString[i].append(HIGHSCORE_DOTSPACE);
            Menu.s_highscoreNameString[i] = new SDKString(3, 0);
            Menu.s_highscoreValueString[i] = new SDKString(10, 0);
            s_highscoreValueString[i].append(s_highscoreValues[i]);
            for (int j = 0; j < 3; ++j) {
                s_highscoreNameString[i].append(0);
                s_highscoreNameString[i].setCharAt(j, (char)GameImpl.s_highscoreLettersArray[s_highscoreNames[i][j]]);
            }
        }
    }

    private static void initHighscore(int n) {
        s_blinkingHighscoreOption = n;
        Menu.generateHighscoreStrings();
        GameImpl.setFont((byte)4);
        s_highscoreHeight = SDKUtils.getBaselinePosition();
        s_highscoreSpace = 0;
        int n2 = GameImpl.s_screenHeight - (s_menuAnimationHeight[1] + 0) - Softkey.getSoftkeyHeight() - SDKUtils.getBaselinePosition();
        s_highscoreNum = n2 / (s_highscoreHeight + s_highscoreSpace);
        if (s_highscoreNum > 10) {
            s_highscoreNum = 10;
        }
        s_highscoreSpace = (n2 - s_highscoreNum * s_highscoreHeight) / s_highscoreNum;
        int n3 = s_highscoreNum * (s_highscoreHeight + s_highscoreSpace);
        s_highscoreY = s_menuAnimationHeight[1] + (n2 - n3) / 2 + s_highscoreHeight / 2 + 0;
        if (s_blinkingHighscoreOption == -1) {
            s_currentAcceptSoftkeyType = 0;
            s_currentCancelSoftkeyType = (byte)4;
        } else {
            s_currentAcceptSoftkeyType = 1;
            s_currentCancelSoftkeyType = 0;
        }
        s_isDownArrowDrawn = false;
        s_isUpArrowDrawn = false;
        s_currentMenuType = 7;
        s_currentMenuHeaderString = SDKUtils.getString(20, null);
        s_highscoreNameX = 36;
        s_highscoreValueX = GameImpl.s_screenWidth - 24;
    }

    private static void drawHighscore() {
        GameImpl.setFont((byte)4);
        int n = s_highscoreY;
        for (int i = 0; i < s_highscoreNum; ++i) {
            if (s_blinkingHighscoreOption != i || !s_blinkingHighscoreBlink) {
                SDKUtils.drawString(s_highscoreNumberString[i], s_highscoreNameX, n, 24);
                SDKUtils.drawString(s_highscoreNameString[i], s_highscoreNameX, n, 20);
                SDKUtils.drawString(s_highscoreValueString[i], s_highscoreValueX, n, 24);
            }
            n += s_highscoreHeight + s_highscoreSpace;
        }
    }

    public static boolean isEnoughForHighscore(int n) {
        return n > s_highscoreValues[9];
    }

    public static int addHighscore(byte[] byArray, int n) {
        int n2;
        int n3 = 9;
        for (n2 = 9; n2 >= 0; --n2) {
            if (n <= s_highscoreValues[n2]) continue;
            n3 = n2;
        }
        for (n2 = 9; n2 > n3; --n2) {
            Menu.setHighscoreName(n2, Menu.getCopyOfHighscoreName(n2 - 1));
            Menu.setHighscoreValue(n2, s_highscoreValues[n2 - 1]);
        }
        Menu.setHighscoreName(n3, byArray);
        Menu.setHighscoreValue(n3, n);
        return n3;
    }

    private static byte[] getCopyOfHighscoreName(int n) {
        byte[] byArray = new byte[3];
        for (int i = 0; i < 3; ++i) {
            byArray[i] = s_highscoreNames[n][i];
        }
        return byArray;
    }

    public static byte[] getHighscoreName(int n) {
        return s_highscoreNames[n];
    }

    public static void setHighscoreName(int n, byte[] byArray) {
        Menu.s_highscoreNames[n] = new byte[3];
        for (int i = 0; i < 3; ++i) {
            Menu.s_highscoreNames[n][i] = byArray[i];
        }
    }

    public static int getHighscoreValue(int n) {
        return s_highscoreValues[n];
    }

    public static void setHighscoreValue(int n, int n2) {
        Menu.s_highscoreValues[n] = n2;
    }

    private static void initMenuResources() {
        if (s_isMenuResourcesInitialized) {
            return;
        }
        try {
            int n;
            s_menuTileset = new Tileset[MENU_TILESET.length];
            for (n = 0; n < MENU_TILESET.length; ++n) {
                Menu.s_menuTileset[n] = FileManager.createTileset(MENU_TILESET[n]);
            }
            s_menuAnimation = new Animation[MENU_ANIMATION.length];
            s_menuAnimationInstance = new int[MENU_ANIMATION.length];
            s_menuAnimationWidth = new int[MENU_ANIMATION.length];
            s_menuAnimationHeight = new int[MENU_ANIMATION.length];
            s_menuAnimationHSLeft = new int[MENU_ANIMATION.length];
            s_menuAnimationHSTop = new int[MENU_ANIMATION.length];
            for (n = 0; n < MENU_ANIMATION.length; ++n) {
                Menu.s_menuAnimation[n] = Animation.loadAnimation(MENU_ANIMATION[n], 1);
                Menu.s_menuAnimationInstance[n] = 1;
                Menu.s_menuAnimationWidth[n] = s_menuAnimation[n].computeGlobalWidth(s_menuTileset[MENU_ANIMATION_TILESETS[n]]);
                Menu.s_menuAnimationHeight[n] = s_menuAnimation[n].computeGlobalHeight(s_menuTileset[MENU_ANIMATION_TILESETS[n]]);
                Menu.s_menuAnimationHSLeft[n] = s_menuAnimation[n].getMaxFrameLeft(s_menuTileset[MENU_ANIMATION_TILESETS[n]]);
                Menu.s_menuAnimationHSTop[n] = s_menuAnimation[n].getMaxFrameTop(s_menuTileset[MENU_ANIMATION_TILESETS[n]]);
            }
            s_cellEdgeToScreenOffset = 7;
            s_menuCellWidth = GameImpl.s_screenWidth - 2 * s_cellEdgeToScreenOffset;
            s_shutterArray = new int[s_menuCellWidth + 1];
            for (n = 0; n < s_menuCellWidth + 1; ++n) {
                Menu.s_shutterArray[n] = n % 2 == 0 ? 0 : -12304077;
            }
            s_isMenuResourcesInitialized = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GameImpl.loadFont((byte)4);
        GameImpl.loadFont((byte)5);
        GameImpl.loadFont((byte)6);
        Sound.loadSFX((byte)37);
        Sound.loadSFX((byte)38);
        FileManager.cleanup();
    }

    public static void initPauseResources() {
        if (s_isPauseResourcesInitialized) {
            return;
        }
        try {
            int n;
            s_pauseTileset = new Tileset[PAUSE_TILESET.length];
            for (n = 0; n < PAUSE_TILESET.length; ++n) {
                Menu.s_pauseTileset[n] = FileManager.createTileset(PAUSE_TILESET[n]);
            }
            s_pauseAnimation = new Animation[PAUSE_ANIMATION.length];
            s_pauseAnimationInstance = new int[PAUSE_ANIMATION.length];
            s_pauseAnimationWidth = new int[PAUSE_ANIMATION.length];
            s_pauseAnimationHeight = new int[PAUSE_ANIMATION.length];
            for (n = 0; n < PAUSE_ANIMATION.length; ++n) {
                Menu.s_pauseAnimation[n] = Animation.loadAnimation(PAUSE_ANIMATION[n], 1);
                Menu.s_pauseAnimationInstance[n] = 1;
                Menu.s_pauseAnimationWidth[n] = s_pauseAnimation[n].computeGlobalWidth(s_pauseTileset[PAUSE_ANIMATION_TILESETS[n]]);
                Menu.s_pauseAnimationHeight[n] = s_pauseAnimation[n].computeGlobalHeight(s_pauseTileset[PAUSE_ANIMATION_TILESETS[n]]);
            }
            s_isPauseResourcesInitialized = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void cleanupPauseMenuResources() {
        s_isPauseResourcesInitialized = false;
        s_pauseTileset = null;
        s_pauseAnimation = null;
    }

    private static void drawShutterArea(int n, int n2, int n3, int n4) {
        for (int i = 0; i < n4; ++i) {
            GameImpl.s_currentGraphics.drawRGB(s_shutterArray, i % 2, n3, n, n2 + i, n3, 1, true);
        }
    }

    public static void cleanupMenuResources() {
        s_menuTileset = null;
        s_menuAnimation = null;
        s_isMenuResourcesInitialized = false;
        GameImpl.cleanupFont((byte)5);
    }

    private static void drawMenuBackground() {
        if (!s_isCurrentMenuWithBackground) {
            return;
        }
        for (int i = 0; i < GameImpl.s_screenWidth; i += s_menuAnimationWidth[0]) {
            for (int j = 0; j < GameImpl.s_screenHeight; j += s_menuAnimationHeight[0]) {
                Menu.drawMenuAnimation(0, i, j);
            }
        }
    }

    private static void drawMenuHeader() {
        if (!s_isCurrentMenuWithBackground) {
            return;
        }
        for (int i = 0; i <= GameImpl.s_screenWidth; i += s_menuAnimationWidth[1]) {
            Menu.drawMenuAnimation(1, i, 0);
        }
    }

    private static void drawCell(int n, int n2, int n3, int n4, SDKString sDKString, int n5, boolean bl, int n6, byte by) {
        if (n6 == 0) {
            GameImpl.s_currentGraphics.setColor(789000);
            GameImpl.s_currentGraphics.fillRect(n + s_menuAnimationHeight[3], n2, n3 - 2 * s_menuAnimationHeight[3], s_menuAnimationHeight[3]);
            GameImpl.s_currentGraphics.setColor(10920337);
            GameImpl.s_currentGraphics.fillRect(n + s_menuAnimationHeight[3], n2 + n4 - s_menuAnimationHeight[3], n3 - 2 * s_menuAnimationHeight[3], s_menuAnimationHeight[3]);
            GameImpl.s_currentGraphics.setColor(1842466);
            GameImpl.s_currentGraphics.fillRect(n, n2 + s_menuAnimationHeight[3], s_menuAnimationHeight[3], n4 - 2 * s_menuAnimationHeight[3]);
            GameImpl.s_currentGraphics.setColor(0xCFCCC4);
            GameImpl.s_currentGraphics.fillRect(n + n3 - s_menuAnimationHeight[3], n2 + s_menuAnimationHeight[3], s_menuAnimationHeight[3], n4 - 2 * s_menuAnimationHeight[3]);
            s_menuAnimation[2].drawInstance(s_menuAnimationInstance[2], s_menuTileset[MENU_ANIMATION_TILESETS[2]], n - s_menuAnimationHSLeft[2], n2 - s_menuAnimationHSTop[2], 0);
            s_menuAnimation[3].drawInstance(s_menuAnimationInstance[3], s_menuTileset[MENU_ANIMATION_TILESETS[3]], n - s_menuAnimationHSLeft[3] + n3 - s_menuAnimationWidth[3], n2 - s_menuAnimationHSTop[3], 0);
            s_menuAnimation[4].drawInstance(s_menuAnimationInstance[4], s_menuTileset[MENU_ANIMATION_TILESETS[4]], n - s_menuAnimationHSLeft[4], n2 - s_menuAnimationHSTop[4] + n4 - s_menuAnimationHeight[4], 0);
            s_menuAnimation[5].drawInstance(s_menuAnimationInstance[5], s_menuTileset[MENU_ANIMATION_TILESETS[5]], n - s_menuAnimationHSLeft[5] + n3 - s_menuAnimationWidth[5], n2 - s_menuAnimationHSTop[5] + n4 - s_menuAnimationHeight[5], 0);
            Menu.drawShutterArea(n + s_menuAnimationHeight[3], n2 + s_menuAnimationHeight[3], n3 - s_menuAnimationHeight[3] * 2, n4 - 2 * s_menuAnimationHeight[3]);
        } else if (bl) {
            if (n6 == 2 || n6 == 3) {
                Menu.drawPauseAnimation(0, n + n3 / 2 - n5 / 2 - s_textEdgeToDragonOffset - s_menuAnimationWidth[6], n2 + n4 / 2 - s_menuAnimationHeight[6] / 2);
                Menu.drawPauseAnimation(0, n + n3 / 2 + n5 / 2 + s_textEdgeToDragonOffset, n2 + n4 / 2 - s_menuAnimationHeight[6] / 2);
            } else {
                Menu.drawMenuAnimation(6, n + n3 / 2 - n5 / 2 - s_textEdgeToDragonOffset - s_menuAnimationWidth[6], n2 + n4 / 2 - s_menuAnimationHeight[6] / 2);
                Menu.drawMenuAnimation(6, n + n3 / 2 + n5 / 2 + s_textEdgeToDragonOffset, n2 + n4 / 2 - s_menuAnimationHeight[6] / 2);
            }
        }
        if (by != -1) {
            GameImpl.setFont(by);
        } else if (bl) {
            GameImpl.setFont((byte)5);
        } else {
            GameImpl.setFont((byte)4);
        }
        SDKUtils.drawString(sDKString, n + n3 / 2 - n5 / 2, n2 + n4 / 2 - SDKUtils.getLineSize() / 2, 20);
    }

    private static void drawMenuAnimation(int n, int n2, int n3) {
        if (s_menuAnimation != null) {
            s_menuAnimation[n].drawInstance(s_menuAnimationInstance[n], s_menuTileset[MENU_ANIMATION_TILESETS[n]], n2, n3, 0);
        }
    }

    private static void drawPauseAnimation(int n, int n2, int n3) {
        if (s_pauseAnimation != null) {
            s_pauseAnimation[n].drawInstance(s_pauseAnimationInstance[n], s_pauseTileset[PAUSE_ANIMATION_TILESETS[n]], n2, n3, 0);
        }
    }

    public static void initMenu() {
        Menu.initMenuResources();
        s_upArrowCoordinateX = GameImpl.s_screenWidth / 2 - Menu.getArrowWidth() / 2;
        s_upArrowCoordinateY = s_menuAnimationHeight[1];
        s_downArrowCoordinateX = GameImpl.s_screenWidth / 2 - Menu.getArrowWidth() / 2;
        s_downArrowCoordinateY = GameImpl.s_screenHeight - Softkey.getSoftkeyHeight() - Menu.getArrowHeight();
        GameImpl.setFont((byte)4);
        s_menuHeaderY = 6;
        s_menuMinOptionY = s_upArrowCoordinateY + Menu.getArrowHeight() + SDKUtils.getLineSize() / 2;
        s_menuMaxOptionY = s_downArrowCoordinateY - SDKUtils.getLineSize() / 2;
        s_textEdgeToDragonOffset = 11;
        Menu.s_menuCellHeight[0] = 33;
        Menu.s_menuCellDistance[0] = 7;
        Menu.s_menuMaxOptionsNumber[0] = (s_menuMaxOptionY - s_menuMinOptionY) / (s_menuCellHeight[0] + s_menuCellDistance[0]);
        Menu.s_menuCellHeight[1] = 15;
        Menu.s_menuCellDistance[1] = 7;
        Menu.s_menuMaxOptionsNumber[1] = (s_menuMaxOptionY - s_menuMinOptionY) / (s_menuCellHeight[1] + s_menuCellDistance[1]);
        Menu.s_menuCellHeight[2] = 15;
        Menu.s_menuCellDistance[2] = 7;
        Menu.s_menuMaxOptionsNumber[2] = (s_menuMaxOptionY - s_menuMinOptionY) / (s_menuCellHeight[2] + s_menuCellDistance[2]);
        Menu.s_menuCellHeight[3] = 15;
        Menu.s_menuCellDistance[3] = 7;
        Menu.s_menuMaxOptionsNumber[3] = (s_menuMaxOptionY - s_menuMinOptionY) / (s_menuCellHeight[3] + s_menuCellDistance[3]);
    }

    public static void clearMenuHistory() {
        s_lastBackState = 0;
        for (int i = 0; i < 5; ++i) {
            Menu.s_backStatesQueue[i] = -1;
        }
    }

    public static void initState(int n) {
        s_currentSelectedItem = 0;
        s_currentMenuState = n;
        switch (s_currentMenuState) {
            case 24: {
                Menu.clearMenuHistory();
                Menu.setupItems(PAUSE_MENU_ITEMS, false);
                break;
            }
            case 25: {
                if (Ingame.s_isPauseMenuLaunchedExit) {
                    Menu.clearMenuHistory();
                    Menu.setupItems(PAUSE_MENU_ITEMS, false);
                    Menu.s_backStatesQueue[++Menu.s_lastBackState] = 24;
                    Ingame.s_isPauseMenuLaunchedExit = false;
                }
                Menu.setupItems(PAUSE_YES_NO_EXIT_ITEMS, false);
                break;
            }
            case 26: {
                SDKString sDKString = new SDKString(1500, 0);
                sDKString = sDKString.append(Menu.getControlsHelpText());
                sDKString = sDKString.append("||");
                sDKString = sDKString.append(Battle.getFighter1().m_moveList);
                sDKString = sDKString.append("||");
                sDKString = sDKString.append(Menu.getLegendHelpText());
                Menu.setupItems(PAUSE_HELP_ITEMS, false, sDKString);
                break;
            }
            case 23: {
                Rms.rmsSave();
                Ingame.exitPauseMenu();
                break;
            }
            case 28: {
                Menu.setupItems(PAUSE_OPTIONS_VIBRA_ITEMS, false);
                Menu.setNewSelectedOption(GameImpl.getVibrationState());
                break;
            }
            case 27: {
                Menu.setupItems(PAUSE_OPTIONS_SOUND_ITEMS, false);
                Menu.setNewSelectedOption(GameImpl.getSoundState());
                break;
            }
            case 0: {
                Sound.playMusic((byte)5);
                Menu.clearMenuHistory();
                Menu.setupItems(MENU_MAIN_ITEMS);
                if (!CharacterSelection.s_isCharacterSelectionBackToMenu || !Ingame.isInPracticeMode()) break;
                Menu.setNewSelectedOption(Menu.getItemIdForState(22));
                CharacterSelection.s_isCharacterSelectionBackToMenu = false;
                break;
            }
            case 1: {
                Menu.setupItems(MENU_OPTIONS_ITEMS);
                break;
            }
            case 10: {
                Menu.setupLanguageItems(MENU_OPTIONS_LANGUAGE_ITEMS);
                Menu.setNewSelectedOption(GameImpl.getLanguageState());
                break;
            }
            case 11: {
                Menu.setupLanguageItems(MENU_OPTIONS_LANGUAGE_ITEMS, false);
                Menu.setNewSelectedOption(GameImpl.getLanguageState());
                break;
            }
            case 12: {
                Menu.setupItems(MENU_OPTIONS_SOUND_ITEMS);
                Menu.setNewSelectedOption(GameImpl.getSoundState());
                break;
            }
            case 13: {
                Menu.setupItems(MENU_OPTIONS_SOUND_ITEMS, false);
                Menu.setNewSelectedOption(GameImpl.getSoundState());
                break;
            }
            case 15: {
                Menu.setupItems(MENU_OPTIONS_VIBRA_ITEMS, false);
                Menu.setNewSelectedOption(GameImpl.getVibrationState());
                break;
            }
            case 17: {
                Menu.setupItems(MENU_OPTIONS_DIFFICULTY_ITEMS, false);
                Menu.setNewSelectedOption(GameImpl.getDifficultyState());
                break;
            }
            case 19: {
                Menu.setupItems(MENU_OPTIONS_CONTROLS_ITEMS, false);
                Menu.setNewSelectedOption(GameImpl.getControlsState());
                break;
            }
            case 14: {
                Menu.setupItems(MENU_OPTIONS_VIBRA_ITEMS);
                Menu.setNewSelectedOption(GameImpl.getVibrationState());
                break;
            }
            case 16: {
                Menu.setupItems(MENU_OPTIONS_DIFFICULTY_ITEMS);
                Menu.setNewSelectedOption(GameImpl.getDifficultyState());
                break;
            }
            case 18: {
                Menu.setupItems(MENU_OPTIONS_CONTROLS_ITEMS);
                Menu.setNewSelectedOption(GameImpl.getControlsState());
                break;
            }
            case 9: {
                Menu.setupItems(MENU_YES_NO_ERASE_DATA_ITEMS);
                break;
            }
            case 2: {
                Menu.setupItems(MENU_HELP_ITEMS);
                break;
            }
            case 5: {
                SDKString sDKString = SDKUtils.getString(MENU_ABOUT_ITEMS[2], null);
                SDKString sDKString2 = sDKString.replaceFirst(GameImpl.s_midletVersionString);
                Menu.setupItems(MENU_ABOUT_ITEMS, true, sDKString2);
                break;
            }
            case 3: {
                SDKString sDKString = Menu.getArcadeHelpText();
                Menu.setupItems(MENU_HELP_ARCADE_ITEMS, true, sDKString);
                break;
            }
            case 4: {
                SDKString sDKString = GameImpl.getControlsState() == 1 ? Menu.getAdvancedControlsHelpText() : Menu.getStandardControlsHelpText();
                Menu.setupItems(MENU_HELP_CONTROLS_ITEMS, true, sDKString);
                break;
            }
            case 6: {
                Menu.initHighscore(-1);
                break;
            }
            case 7: {
                Menu.initHighscore(Ingame.getNewHighscorePosition());
                break;
            }
            case 20: {
                GameImpl.setState(10);
                break;
            }
            case 8: {
                Menu.setupItems(MENU_YES_NO_EXIT_ITEMS);
                break;
            }
            case 21: {
                Ingame.setPracticeMode(false);
                Rms.rmsLoad();
                if (Destiny.getDestinySaved()) {
                    Menu.setupItems(MENU_YES_NO_LOAD_ITEMS);
                    break;
                }
                Ingame.setBaseScore(0);
                GameImpl.setState(11);
                break;
            }
            case 22: {
                Ingame.setPracticeMode(true);
                GameImpl.setState(11);
            }
        }
    }

    private static SDKString getArcadeHelpText() {
        SDKString sDKString = new SDKString(1000, 0);
        SDKString sDKString2 = SDKUtils.getString(40, null);
        sDKString.append(sDKString2);
        SDKString sDKString3 = SDKUtils.getString(134, null);
        sDKString.append("||" + sDKString3);
        return sDKString;
    }

    private static SDKString getControlsHelpText() {
        return GameImpl.getControlsState() == 1 ? Menu.getAdvancedControlsHelpText() : Menu.getStandardControlsHelpText();
    }

    private static SDKString getAdvancedControlsHelpText() {
        int n = 0;
        n = 133;
        SDKString[] sDKStringArray = new SDKString[2];
        if (SDKAutoConstants.getReversedSoftkeys()) {
            sDKStringArray[0] = SDKUtils.getString(136, null);
            sDKStringArray[1] = SDKUtils.getString(137, null);
        } else {
            sDKStringArray[0] = SDKUtils.getString(135, null);
            sDKStringArray[1] = SDKUtils.getString(138, null);
        }
        SDKString sDKString = SDKUtils.getString(n, null);
        return sDKString.replace(sDKStringArray);
    }

    private static SDKString getStandardControlsHelpText() {
        int n = 0;
        n = 132;
        SDKString[] sDKStringArray = new SDKString[2];
        if (SDKAutoConstants.getReversedSoftkeys()) {
            sDKStringArray[0] = SDKUtils.getString(136, null);
            sDKStringArray[1] = SDKUtils.getString(137, null);
        } else {
            sDKStringArray[0] = SDKUtils.getString(135, null);
            sDKStringArray[1] = SDKUtils.getString(138, null);
        }
        SDKString sDKString = SDKUtils.getString(n, null);
        return sDKString.replace(sDKStringArray);
    }

    public static SDKString getLegendHelpText() {
        SDKString[] sDKStringArray = new SDKString[12];
        sDKStringArray[0] = SDKUtils.getString(85, null);
        sDKStringArray[1] = SDKUtils.getString(84, null);
        sDKStringArray[2] = SDKUtils.getString(87, null);
        sDKStringArray[3] = SDKUtils.getString(86, null);
        sDKStringArray[4] = SDKUtils.getString(89, null);
        sDKStringArray[5] = SDKUtils.getString(88, null);
        sDKStringArray[6] = SDKUtils.getString(93, null);
        sDKStringArray[7] = SDKUtils.getString(92, null);
        sDKStringArray[8] = SDKUtils.getString(95, null);
        sDKStringArray[9] = SDKUtils.getString(94, null);
        if (GameImpl.getControlsState() == 0) {
            sDKStringArray[8] = SDKUtils.getString(97, null);
            sDKStringArray[9] = SDKUtils.getString(96, null);
        }
        SDKString sDKString = SDKUtils.getString(44, null);
        sDKString = sDKString.replace(sDKStringArray);
        return sDKString;
    }

    public static void initEnterName() {
        int n;
        GameImpl.setFont((byte)4);
        try {
            s_enterNameArrowsTileset = FileManager.createTileset(ENTER_NAME_ARROWS_TILESET);
            s_enterNameArrowsAnimation = new Animation[4];
            s_enterNameArrowsAnimationInstance = new int[4];
            s_enterNameArrowWidth = new int[4];
            s_enterNameArrowHeight = new int[4];
            s_enterNameArrowX = new int[4];
            s_enterNameArrowY = new int[4];
            for (n = 0; n < 4; ++n) {
                Menu.s_enterNameArrowsAnimation[n] = Animation.loadAnimation(ENTER_NAME_ARROWS_ANIMATIONS[n], 0);
                Menu.s_enterNameArrowsAnimationInstance[n] = 1;
                Menu.s_enterNameArrowWidth[n] = s_enterNameArrowsAnimation[n].computeGlobalWidth(s_enterNameArrowsTileset);
                Menu.s_enterNameArrowHeight[n] = s_enterNameArrowsAnimation[n].computeGlobalHeight(s_enterNameArrowsTileset);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_currentSelectedNameLetter = 0;
        s_newHighscore = SDKUtils.getString(110, null);
        s_enterName = SDKUtils.getString(111, null);
        s_highscoreUnderscore = new SDKString(HIGHSCORE_UNDERSCORE);
        s_enterNameData = SDKUtils.wrapString(s_enterName, null, GameImpl.s_screenWidth - 24, (short)124);
        s_enterNameY = (GameImpl.s_screenHeight - Softkey.getSoftkeyHeight()) / 2 - s_enterNameData[0] * SDKUtils.getLineSize();
        s_newHighscoreY = s_enterNameY / 2;
        if (s_newHighscoreY > s_enterNameY - SDKUtils.getLineSize()) {
            s_newHighscoreY = s_enterNameY - SDKUtils.getLineSize();
        }
        s_nameLettersY = (GameImpl.s_screenHeight - Softkey.getSoftkeyHeight() - (s_enterNameY + s_enterNameData[0] * SDKUtils.getLineSize())) / 2;
        s_nameLettersY += s_enterNameY + s_enterNameData[0] * SDKUtils.getLineSize();
        s_nameLettersSpace = 12;
        s_nameUnderscoreSize = SDKUtils.getStringSize(s_highscoreUnderscore);
        s_nameLettersX = 3 * (s_nameUnderscoreSize + s_nameLettersSpace);
        s_nameLettersX = (GameImpl.s_screenWidth - s_nameLettersX) / 2 + s_nameLettersSpace / 2;
        Menu.s_enterNameArrowX[2] = s_nameLettersX - 3 * s_enterNameArrowWidth[2] + 0;
        Menu.s_enterNameArrowX[3] = s_nameLettersX + 3 * (s_nameUnderscoreSize + s_nameLettersSpace) - s_nameLettersSpace + 2 * s_enterNameArrowWidth[3] + 0;
        Menu.s_enterNameArrowX[0] = s_nameLettersX + s_nameUnderscoreSize / 2 - s_enterNameArrowWidth[0] / 2 + 0;
        Menu.s_enterNameArrowX[1] = s_nameLettersX + s_nameUnderscoreSize / 2 - s_enterNameArrowWidth[1] / 2 + 0;
        Menu.s_enterNameArrowY[0] = s_nameLettersY - 2 * s_enterNameArrowHeight[0] + 0;
        Menu.s_enterNameArrowY[1] = s_nameLettersY + SDKUtils.getLineSize() + s_enterNameArrowHeight[1] + 0;
        Menu.s_enterNameArrowY[2] = s_nameLettersY + SDKUtils.getLineSize() / 2 - s_enterNameArrowHeight[2] / 2 + 0;
        Menu.s_enterNameArrowY[3] = s_nameLettersY + SDKUtils.getLineSize() / 2 - s_enterNameArrowHeight[3] / 2 + 0;
        s_currentEnteredName = new byte[3];
        s_currentEnteredNameString = new SDKString[3];
        for (n = 0; n < 3; ++n) {
            Menu.s_currentEnteredName[n] = DEFAULT_ENTERED_NAME[n];
            Menu.s_currentEnteredNameString[n] = new SDKString(1, 0);
            s_currentEnteredNameString[n].append(0);
            s_currentEnteredNameString[n].setCharAt(0, (char)GameImpl.s_highscoreLettersArray[s_currentEnteredName[n]]);
        }
        s_isHighscoreAcceptPossible = true;
        s_currentAcceptSoftkeyType = 1;
        s_currentCancelSoftkeyType = 0;
        s_currentMenuHeaderString = new SDKString("");
        s_isDownArrowDrawn = false;
        s_isUpArrowDrawn = false;
        s_isHighscoreAccepted = false;
        s_letterChangeTime = s_currentLettersChangeSpeed = 20;
    }

    public static void cleanupEnterName() {
        s_enterNameArrowsTileset = null;
        s_enterNameArrowsAnimation = null;
    }

    public static void drawEnterName() {
        int n;
        GameImpl.setFont((byte)4);
        SDKUtils.drawString(s_newHighscore, GameImpl.s_screenWidth / 2, s_newHighscoreY, 17);
        SDKUtils.drawWrappedString(s_enterName, s_enterNameData, 1, s_enterNameData[0], GameImpl.s_screenWidth / 2, s_enterNameY, 17);
        int n2 = s_nameLettersX;
        for (n = 0; n < 3; ++n) {
            if (n != s_currentSelectedNameLetter || !s_isCurrentSelectedLetterBlinking) {
                if (s_currentEnteredName[n] != 0) {
                    SDKUtils.drawString(s_currentEnteredNameString[n], n2, s_nameLettersY, 20);
                } else {
                    SDKUtils.drawString(s_highscoreUnderscore, n2, s_nameLettersY, 20);
                }
            }
            n2 += s_nameUnderscoreSize + s_nameLettersSpace;
        }
        for (n = 0; n < 4; ++n) {
            s_enterNameArrowsAnimation[n].drawInstance(s_enterNameArrowsAnimationInstance[n], s_enterNameArrowsTileset, s_enterNameArrowX[n], s_enterNameArrowY[n], 0);
        }
    }

    private static boolean isCurrentNameForbidden() {
        boolean bl = true;
        for (int i = 0; i < 3; ++i) {
            if (s_currentEnteredName[i] == FORBIDDEN_ENTERED_NAME[i]) continue;
            bl = false;
        }
        return bl;
    }

    private static void changeSelectedLetter(int n) {
        Menu.s_currentEnteredName[Menu.s_currentSelectedNameLetter] = (byte)n;
        if (s_currentEnteredName[s_currentSelectedNameLetter] > GameImpl.s_highscoreLettersArray.length - 1) {
            Menu.s_currentEnteredName[Menu.s_currentSelectedNameLetter] = 0;
        }
        if (s_currentEnteredName[s_currentSelectedNameLetter] < 0) {
            Menu.s_currentEnteredName[Menu.s_currentSelectedNameLetter] = (byte)(GameImpl.s_highscoreLettersArray.length - 1);
        }
        s_currentEnteredNameString[s_currentSelectedNameLetter].setCharAt(0, (char)GameImpl.s_highscoreLettersArray[s_currentEnteredName[s_currentSelectedNameLetter]]);
        s_isHighscoreAcceptPossible = !Menu.isCurrentNameForbidden();
    }

    private static void updateEnterNameTouchpad() {
    }

    public static void updateEnterName() {
        Menu.updateEnterNameTouchpad();
        boolean bl = s_isCurrentSelectedLetterBlinking = !s_isCurrentSelectedLetterBlinking;
        if (InputManager.s_isKeyLeftPressed && --s_currentSelectedNameLetter < 0) {
            s_currentSelectedNameLetter = 2;
        }
        if (InputManager.s_isKeyRightPressed && ++s_currentSelectedNameLetter > 2) {
            s_currentSelectedNameLetter = 0;
        }
        if (InputManager.s_isKeyUpPressed) {
            Menu.changeSelectedLetter(s_currentEnteredName[s_currentSelectedNameLetter] + 1);
            s_letterChangeTime = s_currentLettersChangeSpeed = 20;
        }
        if (InputManager.s_isKeyDownPressed) {
            Menu.changeSelectedLetter(s_currentEnteredName[s_currentSelectedNameLetter] - 1);
            s_letterChangeTime = s_currentLettersChangeSpeed = 20;
        }
        if (InputManager.s_isKeyUpDown && --s_letterChangeTime <= 0) {
            if ((s_currentLettersChangeSpeed -= 4) < 2) {
                s_currentLettersChangeSpeed = 2;
            }
            s_letterChangeTime = s_currentLettersChangeSpeed;
            Menu.changeSelectedLetter(s_currentEnteredName[s_currentSelectedNameLetter] + 1);
        }
        if (InputManager.s_isKeyDownDown && --s_letterChangeTime <= 0) {
            if ((s_currentLettersChangeSpeed -= 4) < 2) {
                s_currentLettersChangeSpeed = 2;
            }
            s_letterChangeTime = s_currentLettersChangeSpeed;
            Menu.changeSelectedLetter(s_currentEnteredName[s_currentSelectedNameLetter] - 1);
        }
        if (InputManager.s_isKeyCenterPressed && ++s_currentSelectedNameLetter > 2) {
            if (s_isHighscoreAcceptPossible) {
                s_isHighscoreAccepted = true;
            } else {
                s_currentSelectedNameLetter = 2;
            }
        }
        if (s_isHighscoreAcceptPossible && InputManager.s_isKeyAcceptPressed) {
            s_isHighscoreAccepted = true;
        }
        Menu.s_enterNameArrowX[0] = s_nameLettersX + s_nameUnderscoreSize / 2 - s_enterNameArrowWidth[0] / 2 + s_currentSelectedNameLetter * (s_nameUnderscoreSize + s_nameLettersSpace) + 0;
        Menu.s_enterNameArrowX[1] = s_nameLettersX + s_nameUnderscoreSize / 2 - s_enterNameArrowWidth[0] / 2 + s_currentSelectedNameLetter * (s_nameUnderscoreSize + s_nameLettersSpace) + 0;
        s_currentAcceptSoftkeyType = s_isHighscoreAcceptPossible ? (byte)1 : 0;
        Softkey.setSoftkeys(s_currentAcceptSoftkeyType, s_currentCancelSoftkeyType);
    }

    public static boolean isEnterNameFinished() {
        return s_isHighscoreAccepted;
    }

    public static byte[] getEnteredName() {
        return s_currentEnteredName;
    }

    private static void setupItems(int[] nArray) {
        Menu.setupItems(nArray, true, null);
    }

    private static void setupItems(int[] nArray, boolean bl) {
        Menu.setupItems(nArray, bl, null);
    }

    private static void setupItems(int[] nArray, boolean bl, SDKString sDKString) {
        GameImpl.setFont((byte)4);
        s_currentMenuType = nArray[0];
        s_isCurrentMenuWithBackground = bl;
        s_isUpArrowDrawn = false;
        s_isDownArrowDrawn = false;
        s_currentAcceptSoftkeyType = 0;
        s_currentCancelSoftkeyType = (byte)(s_lastBackState > 0 ? 4 : 0);
        switch (s_currentMenuType) {
            case 0: {
                s_currentMenuConfiguration = 0;
                s_currentAcceptSoftkeyType = (byte)3;
                break;
            }
            case 1: {
                s_currentMenuConfiguration = 2;
                s_currentAcceptSoftkeyType = (byte)3;
                break;
            }
            case 2: {
                s_currentMenuConfiguration = 3;
                s_currentAcceptSoftkeyType = 1;
                break;
            }
            case 3: {
                s_currentMenuConfiguration = 1;
                s_currentAcceptSoftkeyType = 1;
                break;
            }
            case 5: {
                s_currentMenuConfiguration = 1;
                break;
            }
            case 6: {
                s_currentMenuConfiguration = 3;
                break;
            }
            case 4: {
                s_currentMenuConfiguration = 1;
                s_currentAcceptSoftkeyType = 1;
                s_currentCancelSoftkeyType = (byte)2;
            }
        }
        s_currentMenuHeaderString = SDKUtils.getString(nArray[1], null);
        switch (s_currentMenuType) {
            case 0: 
            case 1: {
                s_currentMenuItemsNumber = Menu.calculateUnlockedMenuItemsNumber(nArray);
                s_currentMenuItemDestination = new int[s_currentMenuItemsNumber];
                s_currentMenuItemString = new SDKString[s_currentMenuItemsNumber];
                s_currentMenuItemStringSize = new int[s_currentMenuItemsNumber];
                s_isCurrentMenuWrapped = s_currentMenuItemsNumber > s_menuMaxOptionsNumber[s_currentMenuConfiguration];
                s_currentMenuVisibleOptions = s_isCurrentMenuWrapped ? new int[3] : new int[s_currentMenuItemsNumber];
                Menu.recalculateFirstOptionPosition();
                int n = 0;
                for (int i = 0; i < (nArray.length - 2) / 2; ++i) {
                    if (s_lockedStates[nArray[i * 2 + 2 + 1]]) continue;
                    Menu.s_currentMenuItemString[n] = SDKUtils.getString(nArray[i * 2 + 2 + 0], null);
                    Menu.s_currentMenuItemDestination[n] = nArray[i * 2 + 2 + 1];
                    Menu.s_currentMenuItemStringSize[n] = SDKUtils.getStringSize(s_currentMenuItemString[n]);
                    ++n;
                }
                Menu.setNewSelectedOption(0);
                break;
            }
            case 2: 
            case 3: {
                s_currentMenuItemsNumber = nArray.length - 2;
                s_currentMenuItemString = new SDKString[s_currentMenuItemsNumber];
                s_currentMenuItemStringSize = new int[s_currentMenuItemsNumber];
                s_currentMenuItemDestination = null;
                s_isCurrentMenuWrapped = s_currentMenuItemsNumber > s_menuMaxOptionsNumber[s_currentMenuConfiguration];
                s_currentMenuVisibleOptions = s_isCurrentMenuWrapped ? new int[3] : new int[s_currentMenuItemsNumber];
                Menu.recalculateFirstOptionPosition();
                for (int i = 0; i < s_currentMenuItemsNumber; ++i) {
                    Menu.s_currentMenuItemString[i] = SDKUtils.getString(nArray[i + 2], null);
                    Menu.s_currentMenuItemStringSize[i] = SDKUtils.getStringSize(s_currentMenuItemString[i]);
                }
                Menu.setNewSelectedOption(0);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                s_currentMenuItemDestination = null;
                GameImpl.setFont((byte)4);
                boolean bl2 = s_currentMenuType == 4;
                int n = s_currentMenuType != 4 ? 20 : 17;
                int n2 = s_currentMenuType != 4 ? s_cellEdgeToScreenOffset : GameImpl.s_screenWidth / 2;
                int n3 = s_currentMenuType != 4 ? s_menuMinOptionY : s_menuMinOptionY + (s_menuMaxOptionY - s_menuMinOptionY) / 2;
                SDKString sDKString2 = sDKString;
                if (sDKString2 == null) {
                    sDKString2 = SDKUtils.getString(nArray[2], null);
                }
                Menu.menuInitTextbox(n2, n3, GameImpl.s_screenWidth - 2 * s_cellEdgeToScreenOffset, s_menuMaxOptionY - s_menuMinOptionY, sDKString2, n, bl2);
            }
        }
    }

    private static int calculateUnlockedMenuItemsNumber(int[] nArray) {
        int n = 0;
        for (int i = 0; i < (nArray.length - 2) / 2; ++i) {
            if (s_lockedStates[nArray[i * 2 + 2 + 1]]) continue;
            ++n;
        }
        return n;
    }

    private static void recalculateFirstOptionPosition() {
        s_currentMenuFirstOptionY = s_menuMinOptionY;
        int n = s_menuMaxOptionY - s_menuMinOptionY;
        int n2 = s_currentMenuVisibleOptions.length * (s_menuCellHeight[s_currentMenuConfiguration] + s_menuCellDistance[s_currentMenuConfiguration]) - s_menuCellDistance[s_currentMenuConfiguration];
        s_currentMenuFirstOptionY += (n - n2) / 2;
    }

    private static void setupLanguageItems(int[] nArray) {
        Menu.setupLanguageItems(nArray, true);
    }

    private static void setupLanguageItems(int[] nArray, boolean bl) {
        GameImpl.setFont((byte)4);
        s_currentMenuType = nArray[0];
        s_isCurrentMenuWithBackground = bl;
        s_currentAcceptSoftkeyType = 1;
        s_currentCancelSoftkeyType = (byte)(s_lastBackState > 0 ? 4 : 0);
        s_currentMenuConfiguration = 1;
        s_currentMenuItemsNumber = GameImpl.s_numLangsLoaded;
        s_currentMenuItemString = new SDKString[s_currentMenuItemsNumber];
        s_currentMenuItemStringSize = new int[s_currentMenuItemsNumber];
        s_currentMenuHeaderString = SDKUtils.getString(nArray[1], null);
        s_isCurrentMenuWrapped = s_currentMenuItemsNumber > s_menuMaxOptionsNumber[s_currentMenuConfiguration];
        s_currentMenuVisibleOptions = s_isCurrentMenuWrapped ? new int[3] : new int[s_currentMenuItemsNumber];
        Menu.recalculateFirstOptionPosition();
        s_currentSelectedItem = 0;
        for (int i = 0; i < s_currentMenuItemsNumber; ++i) {
            Menu.s_currentMenuItemString[i] = SDKUtils.getHeaderString(i, 0, null);
            Menu.s_currentMenuItemStringSize[i] = SDKUtils.getStringSize(s_currentMenuItemString[i]);
        }
        Menu.setNewSelectedOption(0);
    }

    public static void pushBackState(int n) {
        Menu.s_backStatesQueue[++Menu.s_lastBackState] = n;
    }

    private static int popBackState() {
        int n = -1;
        if (s_lastBackState > 0) {
            n = s_backStatesQueue[s_lastBackState];
            --s_lastBackState;
        }
        return n;
    }

    private static boolean goBack() {
        int n = Menu.popBackState();
        if (n != -1) {
            int n2 = s_currentMenuState;
            Menu.initState(n);
            Menu.setNewSelectedOption(Menu.getItemIdForState(n2));
            return true;
        }
        return false;
    }

    private static void updateTouchpad() {
    }

    public static void updateMenu() {
        int n;
        Menu.updateTouchpad();
        if (s_menuAnimation != null) {
            for (n = 0; n < MENU_ANIMATION.length; ++n) {
                Menu.s_menuAnimationInstance[n] = s_menuAnimation[n].updateInstance(s_menuAnimationInstance[n], GameImpl.s_elapsedTimeClamped);
            }
        }
        if (s_pauseAnimation != null) {
            for (n = 0; n < PAUSE_ANIMATION.length; ++n) {
                Menu.s_pauseAnimationInstance[n] = s_pauseAnimation[n].updateInstance(s_pauseAnimationInstance[n], GameImpl.s_elapsedTimeClamped);
            }
        }
        if (InputManager.s_isKeyAcceptPressed || InputManager.s_isKeyCenterPressed) {
            switch (s_currentMenuState) {
                case 11: {
                    GameImpl.setLanguageState(s_currentSelectedItem);
                    Rms.rmsSave();
                    GameImpl.setState(5);
                    return;
                }
                case 10: {
                    GameImpl.setLanguageState(s_currentSelectedItem);
                    Menu.goBack();
                    return;
                }
                case 27: {
                    GameImpl.setSoundState(s_currentSelectedItem);
                    if (s_currentSelectedItem == 0) {
                        Sound.playSFX((byte)38);
                    } else if (s_currentSelectedItem == 1) {
                        Sound.playMusic((byte)13);
                    }
                    Menu.goBack();
                    break;
                }
                case 13: {
                    if (s_currentSelectedItem != GameImpl.getSoundState()) {
                        GameImpl.setSoundState(s_currentSelectedItem);
                        Rms.rmsSave();
                    }
                    if (s_currentSelectedItem == 0) {
                        Sound.playSFX((byte)38);
                    } else if (s_currentSelectedItem == 1) {
                        Sound.playMusic((byte)13);
                    }
                    if (GameImpl.isVibrationSupported()) {
                        GameImpl.setState(6);
                    } else {
                        GameImpl.setVibrationState(1);
                        if (GameImpl.getFirstLaunch()) {
                            GameImpl.setState(7);
                        } else {
                            GameImpl.setState(9);
                        }
                    }
                    return;
                }
                case 15: {
                    if (s_currentSelectedItem != GameImpl.getVibrationState()) {
                        GameImpl.setVibrationState(s_currentSelectedItem);
                        Rms.rmsSave();
                    }
                    if (s_currentSelectedItem == 0) {
                        GameImpl.vibrate(100);
                    }
                    if (GameImpl.getFirstLaunch()) {
                        GameImpl.setState(7);
                        break;
                    }
                    GameImpl.setState(9);
                    break;
                }
                case 17: {
                    if (s_currentSelectedItem != GameImpl.getDifficultyState()) {
                        GameImpl.setDifficultyState(s_currentSelectedItem);
                        Rms.rmsSave();
                    }
                    GameImpl.setState(8);
                    break;
                }
                case 19: {
                    GameImpl.setControlsState(s_currentSelectedItem);
                    GameImpl.setFirstLaunch(false);
                    Rms.rmsSave();
                    GameImpl.setState(9);
                    break;
                }
                case 12: {
                    GameImpl.setSoundState(s_currentSelectedItem);
                    if (s_currentSelectedItem == 0) {
                        Sound.playSFX((byte)38);
                    } else if (s_currentSelectedItem == 1) {
                        Sound.playMusic((byte)5);
                    }
                    Menu.goBack();
                    return;
                }
                case 14: 
                case 28: {
                    GameImpl.setVibrationState(s_currentSelectedItem);
                    if (s_currentSelectedItem == 0) {
                        GameImpl.vibrate(100);
                    }
                    Menu.goBack();
                    return;
                }
                case 16: {
                    GameImpl.setDifficultyState(s_currentSelectedItem);
                    Menu.goBack();
                    return;
                }
                case 18: {
                    GameImpl.setControlsState(s_currentSelectedItem);
                    Menu.goBack();
                    return;
                }
                case 21: {
                    GameImpl.setState(11);
                    return;
                }
                case 9: {
                    Rms.generateDefaultHighscores();
                    Destiny.setDestinySaved(false);
                    Ingame.setBaseScore(0);
                    GameImpl.setShaoKahnUnlocked(false);
                    Rms.rmsSave();
                    Menu.goBack();
                    return;
                }
                case 25: {
                    Rms.rmsSave();
                    Ingame.exitPauseMenu();
                    Ingame.cleanupIngame();
                    GameImpl.setState(9);
                    break;
                }
                case 8: {
                    SDKMIDlet.exit();
                    return;
                }
                default: {
                    if (s_currentMenuType == 0) {
                        Sound.playSFX((byte)38);
                        Menu.pushBackState(s_currentMenuState);
                        Menu.initState(s_currentMenuItemDestination[s_currentSelectedItem]);
                        return;
                    }
                    if (s_currentMenuType != 1) break;
                    Menu.pushBackState(s_currentMenuState);
                    Menu.initState(s_currentMenuItemDestination[s_currentSelectedItem]);
                }
            }
        }
        if (InputManager.s_isKeyCancelPressed) {
            switch (s_currentMenuState) {
                case 1: {
                    Rms.rmsSave();
                    Menu.goBack();
                    break;
                }
                case 21: {
                    Destiny.setDestinySaved(false);
                    Ingame.setBaseScore(0);
                    Rms.rmsSave();
                    GameImpl.setState(11);
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    if (!Menu.goBack()) break;
                    return;
                }
            }
        }
        switch (s_currentMenuType) {
            case 0: 
            case 3: {
                if (InputManager.s_isKeyDownPressed) {
                    Menu.setNewSelectedOption(s_currentSelectedItem + 1);
                    if (s_isCurrentMenuWithBackground) {
                        Sound.playSFX((byte)37);
                    }
                }
                if (InputManager.s_isKeyUpPressed) {
                    Menu.setNewSelectedOption(s_currentSelectedItem - 1);
                    if (s_isCurrentMenuWithBackground) {
                        Sound.playSFX((byte)37);
                    }
                }
                Menu.updateArrowsDrawnFlags();
                break;
            }
            case 1: 
            case 2: {
                if (InputManager.s_isKeyDownPressed) {
                    Menu.setNewSelectedOption(s_currentSelectedItem + 1);
                }
                if (InputManager.s_isKeyUpPressed) {
                    Menu.setNewSelectedOption(s_currentSelectedItem - 1);
                }
                Menu.updateArrowsDrawnFlags();
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                Menu.updateTextbox();
                break;
            }
            case 7: {
                if (s_blinkingHighscoreOption == -1) break;
                boolean bl = s_blinkingHighscoreBlink = !s_blinkingHighscoreBlink;
                if (!InputManager.s_isKeyAcceptPressed && !InputManager.s_isKeyCenterPressed) break;
                Menu.initState(0);
            }
        }
        Softkey.setSoftkeys(s_currentAcceptSoftkeyType, s_currentCancelSoftkeyType);
    }

    private static void updateArrowsDrawnFlags() {
        s_isDownArrowDrawn = s_isCurrentMenuWrapped;
        s_isUpArrowDrawn = s_isCurrentMenuWrapped;
        s_isDownArrowActive = s_isDownArrowDrawn && InputManager.s_isKeyDownDown;
        s_isUpArrowActive = s_isUpArrowDrawn && InputManager.s_isKeyUpDown;
    }

    public static int getItemIdForState(int n) {
        for (int i = 0; i < s_currentMenuItemsNumber; ++i) {
            if (s_currentMenuItemDestination[i] != n) continue;
            return i;
        }
        return 0;
    }

    public static void setNewSelectedOption(int n) {
        s_currentSelectedItem = n;
        if (s_currentSelectedItem >= s_currentMenuItemsNumber) {
            s_currentSelectedItem = 0;
        }
        if (s_currentSelectedItem < 0) {
            s_currentSelectedItem = s_currentMenuItemsNumber - 1;
        }
        if (s_isCurrentMenuWrapped) {
            Menu.s_currentMenuVisibleOptions[0] = s_currentSelectedItem > 0 ? s_currentSelectedItem - 1 : s_currentMenuItemsNumber - 1;
            Menu.s_currentMenuVisibleOptions[1] = s_currentSelectedItem;
            Menu.s_currentMenuVisibleOptions[2] = s_currentSelectedItem < s_currentMenuItemsNumber - 1 ? s_currentSelectedItem + 1 : 0;
        } else {
            for (int i = 0; i < s_currentMenuItemsNumber; ++i) {
                Menu.s_currentMenuVisibleOptions[i] = i;
            }
        }
    }

    private static byte getCurrentItemFontID(int n) {
        int n2 = -1;
        if (s_currentMenuItemDestination != null && s_currentMenuItemDestination[s_currentMenuVisibleOptions[n]] == 20) {
            n2 = 6;
        }
        return (byte)n2;
    }

    public static void drawMenu() {
        Menu.drawMenuBackground();
        Menu.drawMenuHeader();
        Menu.drawArrows(s_currentMenuConfiguration);
        GameImpl.setFont((byte)4);
        SDKUtils.drawString(s_currentMenuHeaderString, GameImpl.s_screenWidth / 2, s_menuHeaderY, 17);
        switch (s_currentMenuType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                for (int i = 0; i < s_currentMenuVisibleOptions.length; ++i) {
                    Menu.drawCell(s_cellEdgeToScreenOffset, s_currentMenuFirstOptionY + i * (s_menuCellHeight[s_currentMenuConfiguration] + s_menuCellDistance[s_currentMenuConfiguration]), s_menuCellWidth, s_menuCellHeight[s_currentMenuConfiguration], s_currentMenuItemString[s_currentMenuVisibleOptions[i]], s_currentMenuItemStringSize[s_currentMenuVisibleOptions[i]], s_currentSelectedItem == s_currentMenuVisibleOptions[i], s_currentMenuConfiguration, Menu.getCurrentItemFontID(i));
                }
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                Menu.drawTextbox();
                break;
            }
            case 7: {
                Menu.drawHighscore();
            }
        }
    }

    public static void menuInitTextbox(int n, int n2, int n3, int n4, SDKString sDKString, int n5, boolean bl) {
        s_textboxX = n;
        s_textboxY = n2;
        s_textboxWidth = n3;
        s_textboxHeight = n4;
        s_textboxString = sDKString;
        GameImpl.setFont((byte)4);
        s_textboxMaxLines = s_textboxHeight / SDKUtils.getLineSize();
        s_textboxLineData = SDKUtils.wrapString(s_textboxString, null, s_textboxWidth, (short)124);
        s_textboxTextPosition = 1;
        s_textboxTextPositionMax = Math.max(s_textboxLineData[0] - s_textboxMaxLines + s_textboxTextPosition, s_textboxTextPosition);
        s_textboxRowsNumber = s_textboxMaxLines > s_textboxLineData[0] ? s_textboxLineData[0] : s_textboxMaxLines;
        s_textboxAnchor = n5;
        if (bl) {
            s_textboxY -= Math.min(s_textboxLineData[0], s_textboxRowsNumber) * SDKUtils.getLineSize() / 2;
        }
        Menu.updateTextbox();
    }

    public static void drawTextbox() {
        GameImpl.setFont((byte)4);
        SDKUtils.drawWrappedString(s_textboxString, s_textboxLineData, s_textboxTextPosition, Math.min(s_textboxLineData[0], s_textboxRowsNumber), s_textboxX, s_textboxY, s_textboxAnchor);
    }

    private static void drawArrows(int n) {
        switch (n) {
            case 0: 
            case 1: {
                Menu.drawArrows(s_isUpArrowDrawn, s_isUpArrowActive, s_isDownArrowDrawn, s_isDownArrowActive, s_upArrowCoordinateX, s_upArrowCoordinateY, s_downArrowCoordinateX, s_downArrowCoordinateY, false);
                break;
            }
            case 2: 
            case 3: {
                Menu.drawArrows(s_isUpArrowDrawn, s_isUpArrowActive, s_isDownArrowDrawn, s_isDownArrowActive, s_upArrowCoordinateX, s_upArrowCoordinateY, s_downArrowCoordinateX, s_downArrowCoordinateY, true);
            }
        }
    }

    public static int getArrowWidth() {
        int n = 0;
        n = s_pauseAnimationWidth == null ? s_menuAnimationWidth[7] : s_pauseAnimationWidth[1];
        return n;
    }

    public static int getArrowHeight() {
        int n = 0;
        n = s_pauseAnimationHeight == null ? s_menuAnimationHeight[7] : s_pauseAnimationHeight[1];
        return n;
    }

    public static void drawArrows(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, int n3, int n4, boolean bl5) {
        if (bl) {
            if (bl2) {
                if (bl5) {
                    Menu.drawPauseAnimation(2, n, n2);
                } else {
                    Menu.drawMenuAnimation(8, n, n2);
                }
            } else if (bl5) {
                Menu.drawPauseAnimation(1, n, n2);
            } else {
                Menu.drawMenuAnimation(7, n, n2);
            }
        }
        if (bl3) {
            if (bl4) {
                if (bl5) {
                    Menu.drawPauseAnimation(4, n3, n4);
                } else {
                    Menu.drawMenuAnimation(10, n3, n4);
                }
            } else if (bl5) {
                Menu.drawPauseAnimation(3, n3, n4);
            } else {
                Menu.drawMenuAnimation(9, n3, n4);
            }
        }
    }

    private static void updateTextbox() {
        s_isUpArrowActive = InputManager.s_isKeyUpDown;
        s_isDownArrowActive = InputManager.s_isKeyDownDown;
        if ((s_timeSinceLastScroll += GameImpl.s_elapsedTimeClamped) > 100) {
            if (s_isDownArrowActive) {
                if (s_textboxTextPosition < s_textboxTextPositionMax) {
                    ++s_textboxTextPosition;
                }
                s_timeSinceLastScroll = 1;
            }
            if (s_isUpArrowActive) {
                if (s_textboxTextPosition > 1) {
                    --s_textboxTextPosition;
                }
                s_timeSinceLastScroll = 0;
            }
        }
        s_isUpArrowDrawn = s_textboxTextPosition > 1;
        s_isDownArrowDrawn = s_textboxTextPosition < s_textboxTextPositionMax;
    }

    static {
        s_backStatesQueue = new int[5];
        s_lockedStates = new boolean[29];
        PAUSE_MENU_ITEMS = new int[]{1, 68, 83, 23, 30, 27, 10, 28, 19, 26, 69, 25};
        PAUSE_YES_NO_EXIT_ITEMS = new int[]{4, 24, 48};
        PAUSE_HELP_ITEMS = new int[]{6, 19, 71};
        MENU_MAIN_ITEMS = new int[]{0, 69, 16, 21, 22, 20, 17, 22, 18, 1, 19, 2, 21, 5, 20, 6, 24, 8};
        MENU_OPTIONS_ITEMS = new int[]{0, 18, 30, 12, 10, 14, 35, 10, 31, 16, 36, 18, 39, 9};
        MENU_OPTIONS_LANGUAGE_ITEMS = new int[]{3, 35};
        MENU_OPTIONS_SOUND_ITEMS = new int[]{3, 30, 8, 9, 12};
        MENU_OPTIONS_VIBRA_ITEMS = new int[]{3, 10, 11, 12};
        PAUSE_OPTIONS_SOUND_ITEMS = new int[]{2, 30, 8, 9, 12};
        PAUSE_OPTIONS_VIBRA_ITEMS = new int[]{2, 10, 11, 12};
        MENU_OPTIONS_DIFFICULTY_ITEMS = new int[]{3, 31, 32, 33, 34};
        MENU_OPTIONS_CONTROLS_ITEMS = new int[]{3, 36, 37, 38};
        MENU_HELP_ITEMS = new int[]{0, 19, 16, 3, 36, 4};
        MENU_ABOUT_ITEMS = new int[]{5, 21, 109};
        MENU_HELP_ARCADE_ITEMS = new int[]{5, 19, 40};
        MENU_HELP_CONTROLS_ITEMS = new int[]{5, 19, 40};
        MENU_YES_NO_LOAD_ITEMS = new int[]{4, 16, 50};
        MENU_YES_NO_EXIT_ITEMS = new int[]{4, 24, 47};
        MENU_YES_NO_ERASE_DATA_ITEMS = new int[]{4, 39, 49};
        s_menuMaxOptionsNumber = new int[4];
        s_menuCellHeight = new int[4];
        s_menuCellDistance = new int[4];
        MENU_TILESET = new int[]{167772274, 167772275, 167772277, 167772278};
        PAUSE_TILESET = new int[]{167772278, 167772277};
        MENU_ANIMATION = new int[]{167772184, 167772189, 0xA000010, 0xA00000F, 167772178, 0xA000011, 167772179, 0xA000004, 0xA000005, 0xA000002, 0xA000003};
        PAUSE_ANIMATION = new int[]{167772179, 0xA000004, 0xA000005, 0xA000002, 0xA000003};
        MENU_ANIMATION_TILESETS = new int[]{0, 1, 1, 1, 1, 1, 3, 2, 2, 2, 2};
        PAUSE_ANIMATION_TILESETS = new int[]{0, 1, 1, 1, 1};
        DEFAULT_ENTERED_NAME = new byte[]{11, 11, 11};
        FORBIDDEN_ENTERED_NAME = new byte[]{0, 0, 0};
        s_highscoreNames = new byte[10][3];
        s_highscoreValues = new int[10];
        s_highscoreNameString = new SDKString[10];
        s_highscoreNumberString = new SDKString[10];
        s_highscoreValueString = new SDKString[10];
        ENTER_NAME_ARROWS_TILESET = 0xA000077;
        ENTER_NAME_ARROWS_ANIMATIONS = new int[]{167772188, 167772185, 0xA00001A, 167772187};
        s_enterNameArrowX = new int[4];
        s_enterNameArrowY = new int[4];
        s_enterNameArrowWidth = new int[4];
        s_enterNameArrowHeight = new int[4];
    }
}

